/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.mips/src/closure_cons.p
 > Purpose:         Closure construction for MIPS
 > Author:          Rob Duncan, Feb  8 1990 (see revisions)
 > Related Files:   C.mips/src/ass.p
 */


#_INCLUDE 'declare.ph'

section $-Sys;

constant procedure (
	Exec_closure,
	Vm$-lo16,
	Vm$-hi16,
);

endsection;

;;; -----------------------------------------------------------------------


section $-Sys;

lconstant macro WORD = [_drop_ptr!(w)++ -> _drop_ptr];

define Cons_closure(_nfroz) -> _clos;
	lvars _drop_ptr, _offs, _nfroz, _size, _addr, _clos;

	;;; Compute code size in words
	if _zero(_nfroz) then
		_7 -> _size;
	elseif _nfroz _slteq _16 then
		_nfroz _mult _2 _add _5 -> _size;
	else
		_6 -> _size;
	endif;

	;;; Get the closure record
	@@PD_CLOS_FROZVALS[_nfroz _add _size] _sub @@POPBASE -> _size;
	Get_store(_size) -> _clos;
	##(w){_size} ->> _size -> _clos!PD_LENGTH;
	unless _clos!PD_LENGTH == _size then
		_clos -> Get_store();		;;; junk it
		mishap(0, 'CLOSURE EXCEEDS MAXIMUM ALLOWABLE SIZE')
	endunless;

	;;; Plant code
	_clos@PD_CLOS_FROZVALS[_nfroz] ->> _drop_ptr -> _clos!PD_EXECUTE;

	;;; On entry, execute address will be in CALL_REG: convert to
	;;; procedure address in ARG_REG_0
	;;; Drop_arithi(_ADDIU, _ARG_REG_0, _CALL_REG, -@@PD_CLOS_FROZVALS[_nfroz])
	_16:27240000 _biset Vm$-lo16(##(b){_clos, _drop_ptr}) -> WORD;
	if _zero(_nfroz) then
		;;; Get pdpart in TMP_REG_0
		;;;	Drop_load(_LW, _TMP_REG_0, _ARG_REG_0, @@PD_CLOS_PDPART);
		_16:8C880000 _biset @@PD_CLOS_PDPART -> WORD;
		_16:00000000 -> WORD;
		;;; Get pdpart execute address in _CALL_REG
		;;; Drop_load(_LW, _CALL_REG, _TMP_REG_0, @@PD_EXECUTE);
		_16:8D190000 _biset @@PD_EXECUTE -> WORD;
		_16:00000000 -> WORD;
		;;; Go to it
		;;; Drop_jr(_JR, _CALL_REG)
		_16:03200008 -> WORD;
		_16:00000000 -> WORD;
	elseif _nfroz _slteq _16 then
		;;; Get pdpart in TMP_REG_0
		;;;	Drop_load(_LW, _TMP_REG_0, _ARG_REG_0, @@PD_CLOS_PDPART)
		_16:8C880000 _biset @@PD_CLOS_PDPART -> WORD;
		;;; Load first frozval to TMP_REG_1
		;;; Drop_load(_LW, _TMP_REG_1, _ARG_REG_0, @@PD_CLOS_FROZVALS);
		_16:8C890000 _biset @@PD_CLOS_FROZVALS -> WORD;
		;;; Get pdpart execute address in _CALL_REG
		;;; Drop_load(_LW, _CALL_REG, _TMP_REG_0, @@PD_EXECUTE);
		_16:8D190000 _biset @@PD_EXECUTE -> WORD;
		;;; Interleave pushing of frozvals
		@@(w)[_1] -> _offs;
		until _zero(_nfroz _sub _1 ->> _nfroz) do
			if _offs _bitst @@(w)[_1] then
				;;; Drop_load(_LW, _TMP_REG_2, _ARG_REG_0, @@PD_CLOS_FROZVALS{_offs})
				_16:8C8A0000 _biset @@PD_CLOS_FROZVALS{_offs} -> WORD;
				;;; Drop_store(_SW, _TMP_REG_1, _USP, -_offs)
				_16:AFC90000 _biset Vm$-lo16(_negate(_offs)) -> WORD;
			else
				;;; Drop_load(_LW, _TMP_REG_1, _ARG_REG_0, @@PD_CLOS_FROZVALS{_offs});
				_16:8C890000 _biset @@PD_CLOS_FROZVALS{_offs} -> WORD;
				;;; Drop_store(_SW, _TMP_REG_2, _USP, -_offs);
				_16:AFCA0000 _biset Vm$-lo16(_negate(_offs)) -> WORD;
			endif;
			@@(w){_offs}++ -> _offs;
		enduntil;
		;;; Push the last frozval
		if _offs _bitst @@(w)[_1] then
			;;; Drop_store(_SW, _TMP_REG_1, _USP, -_offs)
			_16:AFC90000 _biset Vm$-lo16(_negate(_offs)) -> WORD;
		else
			;;; Drop_store(_SW, _TMP_REG_2, _USP, -_offs);
			_16:AFCA0000 _biset Vm$-lo16(_negate(_offs)) -> WORD;
		endif;
		;;; Jump to exceute address, adjusting USP in the delay slot
		;;; Drop_jr(_JR, _CALL_REG)
		_16:03200008 -> WORD;
		;;; Drop_arithi(_ADDIU, _USP, _USP, lo16(_negate(_offs)))
		_16:27DE0000 _biset Vm$-lo16(_negate(_offs)) -> WORD;
	else
		;;; Too many frozvals: pass closure as argument to Exec_closure
		Exec_closure!PD_EXECUTE -> _addr;
		;;; Drop_lui(_CALL_REG, hi16(_addr))
		_16:3C190000 _biset Vm$-hi16(_addr) -> WORD;
		;;; Drop_arithi(_ADDIU, _CALL_REG, _CALL_REG, lo16(_addr))
		_16:27390000 _biset Vm$-lo16(_addr) -> WORD;
		;;; Drop_arithi(_ADDIU, _USP, _USP, lo16(_-4))
		_16:27DEFFFC -> WORD;
		;;; Drop_jr(_JR, _CALL_REG)
		_16:03200008 -> WORD;
		;;; Drop_store(_SW, _ARG_REG_0, _USP, _0)
		_16:AFC40000 -> WORD;
	endif;
enddefine;

endsection;		/* $-Sys */

/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Mar  7 1994
		Changed for new pop calling convention: instead of the procedure
		address being passed in ARG_REG_0, the execute address is passed
		in CALL_REG ($t9).
--- John Gibson, Sep 23 1992
		Added check for size not being too large
--- Robert John Duncan, Jul 19 1990
		Squeezed out some no-ops.
 */
