/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:            S.iris/src/syscomp/sysdefs-r4.p
 > Purpose:         Silicon Graphics Iris: macros for machine and O/S
 > Author:          Simon Nichols, Mar 12 1990 (see revisions)
 */


section;

global constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; -- SYSTEM NAME --------------------------------------------------------

	MACHINE = [[iris]],


;;; -- PROCESSOR (MIPS R2000) ---------------------------------------------

	PROCESSOR = [[mips]],
	MIPS = true,

	;;; Byte orientation
	BIG_ENDIAN = true,

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	DOUBLE_ALIGN_BITS = 32,
	STRUCT_DOUBLE_ALIGN_BITS = 64,

	;;; Type of pointer to machine code
	CODE_POINTER_TYPE = "int",

	;;; Type of pointer for bitfield access
	BIT_POINTER_TYPE  = "byte",


;;; -- OPERATING SYSTEM (RISC/os) -----------------------------------------

	IRIX = 4.0,
	POSIX1 = 198808,			;;; probably later than this ...
	OPERATING_SYSTEM = [[unix irix ^IRIX posix {^POSIX1}]],
	UNIX = true,
	BERKELEY = 4.3,	;;; System V.3 with BSD 4.3 extensions and compatability

	;;; Feature list
	COFF = true,

	;;; Size of a virtual page (NBPP in <sys/immu.h>)
	VPAGE_OFFS = 16:1000,

	;;; Lowest executable address (see N_TXTOFF in <a.out.h>)
	LOWEST_ADDRESS = 16:400190,

	;;; Top of stack segment (from <sys/immu.h>)
	UNIX_USRSTACK = 16:7FFFF000,

	;;; Get and set the memory break and return the REAL end of memory:
	;;; this is to ensure that the end of the user stack is at the end
	;;; of memory so that a user stack underflow causes a memory access
	;;; violation.
	;;; Break values are rounded up to the next page boundary.
	GET_REAL_BREAK = [
		procedure();
			_extern sbrk(_0)@(b.r->vpage);
		endprocedure
	],

	SET_REAL_BREAK = [
		procedure(_break) -> _break;
			lvars _break = _break@(w.r->vpage);
			if _extern brk(_break@(w->b)) == _-1 then
				_-1 -> _break
			endif;
		endprocedure
	],

	;;; Flush the instruction cache after a garbage collection
	CACHEFLUSH = [
		procedure(_ptr, _nbytes);
			lvars _ptr, _nbytes;
			_extern cacheflush(_ptr, _nbytes, _1) -> ;
		endprocedure
	],


;;; -- OTHER --------------------------------------------------------------

	;;; MIPS C compiler returns "float" results as single, not double
	C_FLOAT_RESULT_SINGLE = true,

	;;; List of procedures to be optimised as subroutine calls:
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]
	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],

	;;; Old-style I_PUSH/POP_FIELD(_ADDR) instructions in ass.p
	OLD_FIELD_INSTRUCTIONS = true,

	;;; Enable listing of M-code in POPC assembler output
	M_DEBUG = false,

	;;; Enable dump of run-time code in ICODE.LOG
	I_DEBUG = false,

);

endsection;


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, May 12 1997
		Added OLD_FIELD_INSTRUCTIONS. Removed is* procedures from
		SUBROUTINE_OPTIMISE_LIST (no longer required).
--- Robert John Duncan, May 23 1995
		Renamed as sysdefs-r4.p: can be used to build for IRIX 4.x systems,
		but IRIX 5+ is now the default
--- John Gibson, Mar 21 1995
		Standard machine data type definitions are now in mcdata.p
--- John Gibson, Feb 28 1995
		Added POSIX1 and "posix" entry in OPERATING_SYSTEM, removed H*ERTZ
--- Robert John Duncan, Nov 26 1992
		Deleted T*ERMINFO flag -- now set in "unxidefs.ph"
--- John Gibson, Oct 22 1992
		Changed P*OPC to POPC_SYSDEFS_LOADED
 */
