/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            S.iris/src/syscomp/sysdefs-r5.p
 > Purpose:         Silicon Graphics Iris: macros for machine and O/S
 > Author:          Simon Nichols, Mar 12 1990 (see revisions)
 */


section;

global constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; -- SYSTEM NAME --------------------------------------------------------

	MACHINE = [[iris]],


;;; -- PROCESSOR (MIPS Rx000) ---------------------------------------------

	PROCESSOR = [[mips]],
	MIPS = true,

	;;; Byte orientation
	BIG_ENDIAN = true,

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	DOUBLE_ALIGN_BITS = 32,
	STRUCT_DOUBLE_ALIGN_BITS = 64,
	STACK_ALIGN_BITS  = 64,	;;; alignment in bits for stack frames

	;;; Type of pointer to machine code
	CODE_POINTER_TYPE = "int",

	;;; Type of pointer for bitfield access
	BIT_POINTER_TYPE  = "byte",


;;; -- OPERATING SYSTEM (IRIX) -----------------------------------------

	IRIX = 5.3,
	POSIX1 = 199009,
	OPERATING_SYSTEM = [[unix irix ^IRIX posix {^POSIX1}]],
	UNIX = true,
	SYSTEM_V = 4.0,

	;;; Has mmap and mprotect
;;; BSD_MMAP = true,
	BSD_MMAP = false,		/* using mmap causes problems with brk */
	BSD_MPROTECT = true,

	;;; Uses shared libraries
	SHARED_LIBRARIES = true,

	;;; Size of a virtual page (from sysconf PAGESIZE)
	VPAGE_OFFS = 4096,

	;;; Lowest executable address (varies, but close to this)
	LOWEST_ADDRESS = 16:400000,

	;;; Top of stack segment (USERSTACK from <sys/immu.h>)
	UNIX_USRSTACK = 16:80000000,

	;;; Get and set the memory break and return the REAL end of memory:
	;;; this is to ensure that the end of the user stack is at the end
	;;; of memory so that a user stack underflow causes a memory access
	;;; violation.
	;;; Break values are rounded up to the next page boundary.
	GET_REAL_BREAK = [
		procedure();
			_extern sbrk(_0)@(b.r->vpage);
		endprocedure
	],

	SET_REAL_BREAK = [
		procedure(_break) -> _break;
			lvars _break = _break@(w.r->vpage);
			if _extern brk(_break@(w->b)) == _-1 then
				_-1 -> _break
			endif;
		endprocedure
	],

	;;; Flush the instruction cache after a garbage collection
	CACHEFLUSH = [
		procedure(_ptr, _nbytes);
			lvars _ptr, _nbytes, _lim = _ptr@(w){_nbytes};
			;;; mprotect will flush the cache but does other mysterious
			;;; things which are necessary for executing code from the
			;;; data segment (see ___man ________mprotect(2))
			;;; NB: _____ptr must be page-aligned;
			;;; 7 = PROT_READ|PROT_WRITE|PROT_EXEC
			_ptr@(w.t->vpage) -> _ptr;
			_extern mprotect(_ptr, @@(b){_lim, _ptr}, _7) -> ;
		endprocedure
	],


;;; -- OTHER --------------------------------------------------------------

	;;; SGI C compiler is ANSI by default
	ANSI_C = true,
	C_FLOAT_RESULT_SINGLE = true,

	;;; List of procedures to be optimised as subroutine calls:
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]
	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],

	;;; Old-style I_PUSH/POP_FIELD(_ADDR) instructions in ass.p
	OLD_FIELD_INSTRUCTIONS = true,

	;;; Enable listing of M-code in POPC assembler output
	M_DEBUG = false,

	;;; Enable dump of run-time code in ICODE.LOG
	I_DEBUG = false,

);

endsection;


/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov  4 1996
		Added OLD_FIELD_INSTRUCTIONS. Removed is* procedures from
		SUBROUTINE_OPTIMISE_LIST (no longer required).
--- Integral Solutions Ltd, Aug 31 1995 (Julian Clinton)
		Changed IRIX version to 5.3.
--- Robert John Duncan, Jul 21 1995
		Now works on IRIX 5.3. Changed CACHEFLUSH to use mprotect rather
		than cacheflush, as recommended in ___man ________mprotect(2). Without this,
		fork will break if the child tries to execute user code.
--- Robert John Duncan, May 23 1995
		IRIX 5+ now the default; IRIX 4.x defs moved to "sysdefs-r4.p".
		Standard machine data type definitions are now in mcdata.p
		Added POSIX1 and "posix" entry in OPERATING_SYSTEM.
--- Robert John Duncan, Nov 21 1994
		Temporarily disabled use of mmap because of some weird interaction
		with brk which makes it impossible to reduce the break
--- Robert John Duncan, May 31 1994
		Changed for IRIX 5.2
--- Robert John Duncan, Nov 26 1992
		Deleted T*ERMINFO flag -- now set in "unxidefs.ph"
--- John Gibson, Oct 22 1992
		Changed P*OPC to POPC_SYSDEFS_LOADED
 */
