/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_xdefaults.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 26th May 1993
;;; File: go_xdefaults.p
;;; Author: Jonathan Meyer

compile_mode :pop11 +strict;

;;; INTRO: The go_xdefaults file queries the user's defaults for the
;;; INTRO: following items:
;;; INTRO:     1. Font: Default go_font used by text in Graphical Objects (GO)
;;; INTRO:        field in .Xdefaults file: GO.Font
;;; INTRO:     2. Foreground: Default go_fgcolour used by Graphical Objects (GO)
;;; INTRO:        field in .Xdefaults file: GO.Foreground
;;; INTRO:     3. Background: Default go_bgcolour used in Graphical Objects (GO)
;;; INTRO:        field in .Xdefaults file: GO.Background
;;; INTRO:

;;; uses XText;

XptLoadProcedures 'x_tExt' lvars
	XTextWidth;

include xpt_xtypes.ph;

lvars the_default_font, the_default_fgcolour, the_default_bgcolour;

l_typespec go_resources {
	font : exptr,
	foreground : XptPixel,
	background : XptPixel,
};

define :inline lconstant OFFSET(field=item);
	FIELDOFFSET(:go_resources,field)
enddefine;

lconstant macro SIZEOF = nonmac SIZEOFTYPE;

shadowclass lconstant XptResourceList [nc, prefix nc_];

lconstant
	go_appl_resources = nc_consXptResourceList( #|
		(XtN font, XtC Font, XtR FontStruct, SIZEOF(:exptr),
			OFFSET(font), XtR String, XtN XtDefaultFont),
		(XtN foreground, XtC Foreground, XtR Pixel, SIZEOF(:XptPixel),
			OFFSET(foreground), XtR String, XtN XtDefaultForeground),
		(XtN background, XtC Background, XtR Pixel, SIZEOF(:XptPixel),
			OFFSET(background), XtR String, XtN XtDefaultBackground),
	|# div 7),

	go_resources = EXPTRINITSTR(:go_resources),
;

define lconstant go_get_app_resources();
;;; REF: go_get_app_resources();
;;; REF: Procedure to load the different application resources from the
;;; REF: .Xdefaults file for the user. It is not intended to be called
;;; REF: directly by the user.
lvars widget;
	XtAppCreateShell('go', 'GO',
				XptWidgetSet("Toolkit")("ApplicationShellWidget"),
			XptDefaultDisplay, []) -> widget;

	XtVaGetApplicationResources(widget, go_resources,
		go_appl_resources, shadow_length(go_appl_resources), 0);

	XtDestroyWidget(widget);

	exacc go_resources.font -> the_default_font;
	exacc go_resources.foreground -> the_default_fgcolour;
	exacc go_resources.background -> the_default_bgcolour;
enddefine;

include xpt_xfontstruct;
p_typespec go_default_font :XFontStruct;

;;;-------------------------------------------------------------------
;;; COLOUR: general purpose routines for defaults:

define active go_default_fgcolour; ;;; REF: Global var: the user's default foreground colour.
;;; REF: Global var: go_default_fgcolour will if necessary get the
;;; REF: Global var: application's resources and return the value for the
;;; REF: Global var: resource GO*Foreground in either the user's .Xdefaults
;;; REF: Global var: file or the system defaults.
	if ( the_default_fgcolour.isundef ) then go_get_app_resources(); endif;
	the_default_fgcolour;
enddefine;

define active go_default_bgcolour; ;;; REF: Global var: the user's default background colour.
;;; REF: Global var: go_default_bgcolour will if necessary get the
;;; REF: Global var: application's resources and return the value for the
;;; REF: Global var: resource GO*Background in either the user's .Xdefaults
;;; REF: Global var: file or the system defaults.
	if ( the_default_bgcolour.isundef ) then go_get_app_resources(); endif;
	the_default_bgcolour;
enddefine;

;;;-------------------------------------------------------------------
;;; FONT: general purpose routines for defaults:

define active go_default_font;   ;;; GLOBAL VAR: the user's default font.
;;; REF: go_default_font will if necessary get the application's resources
;;; REF: and return the value for the resource GO*Font in either the
;;; REF: user's .Xdefaults file or the system defaults.
	if ( the_default_font.isundef ) then go_get_app_resources(); endif;
	the_default_font;
enddefine;

define go_font_width( font, str ) -> w;
lvars font, str, w;
;;; REF: go_font_width( FONT, STRING ) -> INTEGER;
;;; REF: Returns the width of the string in a given font. A possible font is
;;; REF: the go_default_font (REF * GO_VARS/go_default_font).
;;; REF: FONT is a XFontStruct with a valid font for the XpwGraphics widgets.
	exacc (3) :int raw_XTextWidth( font, str, length(str) ) -> w;
enddefine;

define go_font_height( font ) -> h;
lvars font, h;
;;; REF: go_font_width( FONT ) -> INTEGER;
;;; REF: Returns the height of the given font. A possible font is the
;;; REF: go_default_font (REF * GO_VARS/go_default_font).
;;; REF: FONT is a XFontStruct with a valid font for the XpwGraphics widgets.
l_typespec font :XFontStruct;
	(exacc font.ascent) + (exacc font.descent) -> h;
enddefine;

/* ---- Examples of other calls: ---- *
;;; Max width of a character (see INCLUDE * xpt_xfontstruct)
	exacc (exacc go_default_font.max_bounds).width -> w;
 * ---- Examples of other calls: ---- */

;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_xdefaults = true;

/* --- Revision History --------------------------------------------
 * BR 26/05/93
 *     Added comments.
 *     Added go_font_width, go_font_height routines .
 *     Made variables active.
 * BR 17/05/93
 *     Changed file-layout and comments.
 */
;;; eof
