/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 * File:			C.win32/extern/src/misc.c
 * Purpose:			Miscellaneous utilities
 * Author:			Robert John Duncan, Jun 14 1994 (see revisions)
 * Documentation:
 * Related Files:
 */

#include "popcore.h"


DWORD pop_get_last_error()
	/*	Returns the code number for the most recent error.
	*/
{
	return GetLastError();
}

DWORD pop_get_oem_id(void)
	/*	Returns the OEM's machine ID
	*/
{
	SYSTEM_INFO sinf;
	GetSystemInfo(&sinf);
	return sinf.dwOemId;
}

DWORD pop_get_computer_name(TCHAR *buffer, DWORD len)
	/*	Copies the computer name into a BUFFER of length LEN. Returns
		the number of characters in the name, or zero for error.
	*/
{
	DWORD nchars = MAX_COMPUTERNAME_LENGTH+1;
	TCHAR name[MAX_COMPUTERNAME_LENGTH+1];
	if (GetComputerName(name, &nchars))
		CopyMemory(buffer, name, (len <= nchars ? len : nchars+1)*sizeof(TCHAR));
	else
		nchars = 0;

	return nchars;
}

DWORD pop_get_user_name(TCHAR *buffer, DWORD len)
	/*	Copies the current user name into a BUFFER of length LEN. Returns
		the number of characters copied, or zero for error.
	*/
{
	TCHAR name[256];
	DWORD nchars;
	if (GetUserName(buffer, &len))
		return len;
	else if (len < 256 && (nchars = 256, GetUserName(name, &nchars)))
	{
		CopyMemory(buffer, name, (len < nchars ? len : nchars)*sizeof(TCHAR));
		return nchars;
	}
	else
		return 0;
}

DWORD pop_get_current_process_id(void)
{
	return GetCurrentProcessId();
}

TCHAR *pop_get_command_line(void)
{
	return GetCommandLine();
}

BOOL __pop_math_1(double *dfptr, double (*func)(double))
	/*	Apply a unary math function, checking for errors
	*/
{
	double res;
	SET_ERRNO(0);
	res = (*func)(*dfptr);
	if (GET_ERRNO == 0) {
		*dfptr = res;
		return TRUE;
	}
	else
		return FALSE;
}

BOOL __pop_math_2(double *dfptr_1, double *dfptr_2, double (*func)(double,double))
	/*	Apply a binary math function, checking for errors
	*/
{
	double res;
	SET_ERRNO(0);
	res = (*func)(*dfptr_1, *dfptr_2);
	if (GET_ERRNO == 0) {
		*dfptr_1 = res;
		return TRUE;
	}
	else
		return FALSE;
}

	/*	Xt functions referenced from the core system
	*/
void _pop_set_xt_wakeup(BOOL on)
{
}

	/* With NuTCRACKER, these will get real definitions from pop_poll.c
	*/
#ifndef __NUTC__
int (*_pop_Xt_poll_deferred)();
void _pop_retry_Xt_poll() {
}
#endif


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Nov  1 1996
		Added Xt poll function stubs
--- Robert Duncan, May 14 1996
		Changed to use macros for errno
--- Robert John Duncan, Feb  7 1996
		pop_ex*it_process moved to "start.c"
--- Robert John Duncan, Sep 13 1995
		Added __pop_math_1 & __pop_math_2
 */
