/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 * File:			C.win32/extern/src/popwin.h
 * Purpose:			Pop windows library header file
 * Author:			Robert John Duncan, Jul 14 1994 (see revisions)
 */

typedef struct _POP_EDIT_WINDOW_DATA {
	HWND	self;			/* window handle */
	HWND	parent;			/* parent window handle */
	int		clientw;		/* width of client area */
	int		clienth;		/* height of client area */
	int		nrows;			/* number of character rows */
	int		ncols;			/* number of character columns */
	int		caretx;			/* x-coord of caret (in characters) */
	int		carety;			/* y-coord of caret (in characters) */
	HFONT	font;			/* current font */
	LONG	charw;			/* width of a character */
	LONG	charh;			/* height of a character */
	TCHAR*	buffer;			/* screen buffer */
	TCHAR**	rows;			/* screen buffer rows */
	int		buffer_nrows;	/* number of buffer rows */
	int		buffer_ncols;	/* number of columns per buffer row */
	int		region_top;		/* start of scrolling region */
	int		region_bottom;	/* end of scrolling region */
	RECT	refresh;		/* region needing refresh */
	BOOL	insert_mode;	/* character output mode (insert/overstrike) */
} POP_EDIT_WINDOW_DATA;

typedef struct _POP_BASE_WINDOW_DATA {
	HWND	self;			/* window handle */
	HWND	child;			/* child window handle */
	RECT	frame;			/* size and position of base window */
	RECT	client;			/* size and position of client area */
	HFONT	font;			/* current font */
	int		charw;			/* width of a character */
	int		charh;			/* height of a character */
} POP_BASE_WINDOW_DATA;

typedef struct _POP_MSG {
	HWND	hwnd;			/* window handle */
	UINT	message;		/* message ID */
	WPARAM	wParam;			/* first message parameter */
	LPARAM	lParam;			/* second message parameter */
} POP_MSG;
	/* Essential data from a Windows message */

#define EDIT_CMD_CHAR_LEFT			'\002'	/* ^B */
#define EDIT_CMD_DELETE_CHAR 		'\004'	/* ^D */
#define EDIT_CMD_CHAR_RIGHT			'\006'	/* ^F */
#define EDIT_CMD_BELL				'\007'	/* ^G */
#define EDIT_CMD_BACKSPACE			'\010'	/* ^H */
#define EDIT_CMD_TAB				'\011'	/* ^I */
#define EDIT_CMD_LINEFEED			'\012'	/* ^J */
#define EDIT_CMD_CLEAR_EOL			'\013'	/* ^K */
#define EDIT_CMD_CLEAR 				'\014'	/* ^L */
#define EDIT_CMD_RETURN				'\015'	/* ^M */
#define EDIT_CMD_CHAR_DOWN			'\016'	/* ^N */
#define EDIT_CMD_INSERT_LINE 		'\017'	/* ^O */
#define EDIT_CMD_CHAR_UP			'\020'	/* ^P */
#define EDIT_CMD_SCROLL_UP			'\023'	/* ^S */
#define EDIT_CMD_SCROLL_DOWN		'\024'	/* ^T */
#define EDIT_CMD_DELETE_LINE 		'\025'	/* ^U */
#define EDIT_CMD_INSERT_CHAR 		'\026'	/* ^V */
#define EDIT_CMD_INSERT_MODE		'\027'	/* ^W */
#define EDIT_CMD_REPLACE_MODE		'\030'	/* ^X */
#define EDIT_CMD_GOTO				'\031'	/* ^Y */
#define EDIT_CMD_SET_SCROLL_REGION	'\032'	/* ^Z */
#define EDIT_CMD_ESCAPE				'\033'	/* ^[ */
	/* Control characters for an edit window */

#define MAKE_POP_MESSAGE(n)			(WM_USER+0x100+(n))
#define MAKE_POP_EDIT_MESSAGE(n) 	MAKE_POP_MESSAGE(100+(n))

#define POPM_CLOSE					MAKE_POP_MESSAGE(1)
#define POPM_CONFIRM_EXIT			MAKE_POP_MESSAGE(2)

#define POPM_EDIT_COMMAND			MAKE_POP_EDIT_MESSAGE(EDIT_CMD_ESCAPE)
#define POPM_EDIT_INSERT_CHAR		MAKE_POP_EDIT_MESSAGE(EDIT_CMD_INSERT_CHAR)
#define POPM_EDIT_GOTO				MAKE_POP_EDIT_MESSAGE(EDIT_CMD_GOTO)
#define POPM_EDIT_SET_SCROLL_REGION	MAKE_POP_EDIT_MESSAGE(EDIT_CMD_SET_SCROLL_REGION)

#define POPM_EDIT_INTERRUPT			MAKE_POP_EDIT_MESSAGE(256)
#define POPM_EDIT_CHAR	   			MAKE_POP_EDIT_MESSAGE(257)
#define POPM_EDIT_FUNCTION			MAKE_POP_EDIT_MESSAGE(258)
#define POPM_EDIT_SIZE				MAKE_POP_EDIT_MESSAGE(259)
#define POPM_EDIT_MOUSE				MAKE_POP_EDIT_MESSAGE(260)

extern const TCHAR POP_EDIT_CLASS_NAME[];
extern ATOM popwin_init_edit_window_class(void);

extern const TCHAR POP_BASE_CLASS_NAME[];
extern ATOM popwin_init_base_window_class(void);

extern BOOL popwin_get_message(POP_MSG *pmsg);
extern LRESULT popwin_send_message(POP_MSG *pmsg);
extern HWND popwin_get_window(HWND hwnd, UINT cmd);
extern HWND popwin_create_base_window(void);

/*******************************************************************************
New Interface as of 30/01/96
*******************************************************************************/

extern BOOL popwin_try_message(BOOL wait);
extern __declspec(dllexport) BOOL pop_in_message_wait(void);

/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Feb  7 1996
		Changed MAKE_POP_MESSAGE to increase base for Poplog messages as
		recommended for Windows '95. Added INTERRUPT message plus externs
		for new (experimental MDI) interface.
--- Robert John Duncan, Jan  8 1996
		Added POPM_EDIT_MOUSE
 */
