/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.win32/lib/auto/pipein.p
 > Author:			Robert John Duncan, Jan  8 1996 (see revisions)
 > Purpose:			Read output from a child process
 > Related Files:	LIB * PIPEOUT, C.unix/lib/auto/pipein.p
 */
compile_mode:pop11 +strict;

section;

	/*	Spawn a process to run a command and return a device or repeater
		for reading the output. Arguments:
			command, args	- same as for sys_create_process
			flag			- <true> for repeater, <false> for device
	*/
define pipein(command, args, flag);
	lvars ndev = sysopen('nul', 0, true);
	lvars (odev, idev) = syspipe(if flag then false else "line" endif);
	lvars pid = sys_create_process(command, args, {^ndev ^odev ^odev}, false);
	;;; *MUST* close this, or the last read from idev will hang indefinitely
	sysclose(odev);
	sysclose(ndev);
	if flag then discin(idev) else idev endif;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Robert Duncan, May 24 1996
		Specified std i/o explicitly in sys_create_process call
 */
