/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_colourable.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 5th May 1993
;;; File: go_colourable.p
;;; Author: Ben L.E. Rabau

compile_mode :pop11 +strict;

;;; This file go_contains colour definitions which can be used with objects
;;; to be used in conjunction with a "go_window_pane" instance.
;;; The colours are hashed in tables relating to a specific Graphics Widget.
;;; See also REF * GO_PANE.

;;;------------------------------------------------------
define :mixin go_colourable;
	slot stored_go_fgcolour   == false;
;;; REF: stored word of the foreground colour or false for default from pane
	slot stored_go_bgcolour   == false;
;;; REF: stored word of the background colour or false for default from pane
enddefine;

vars procedure go_update_and_draw;     ;;; DEFINED IN GO_SCREEN_OBJECT

;;;------------------------------------------------------
;;; COLORS:
;;;     implements cached colours:

define :method go_fgcolour( colObj :go_colourable );
lvars colObj;
;;; REF: go_fgcolour( COLOURABLE ) -> WORD_OR_INTEGER;
	colObj.stored_go_fgcolour;
enddefine;

define :method updaterof go_fgcolour( color, colObj :go_colourable );
lvars color, colObj;
;;; REF: WORD_OR_STRING_OR_INTEGER -> go_fgcolour( COLOURABLE );
;;; REF: The foreground colour of the colourable object. The colour is
;;; REF: stored as words rather than strings or as the integer representing
;;; REF: the colour index in the colour table of the go_pane it will be
;;; REF: shown in. Such an index is not screen independent and is unsafe.
;;; REF: This means that slot defaults need to be words or integers too !!!!
;;; REF: COLOURABLE is an go_colourable instance (see REF * GO_COLOURABLE)
	if not(color) then false
	elseif isstring(color) then consword(color);
	elseif isword(color) then color;
	else  fi_check(color, 0, false);
	endif -> colObj.stored_go_fgcolour;
	go_update_and_draw( colObj );
enddefine;

define :method go_bgcolour( colObj :go_colourable );
lvars colObj;
;;; REF: go_bgcolour( COLOURABLE ) -> WORD_OR_INTEGER;
	colObj.stored_go_bgcolour;
enddefine;

define :method updaterof go_bgcolour( color, colObj :go_colourable );
lvars color, colObj;
;;; REF: WORD_OR_STRING_OR_INTEGER -> go_bgcolour( COLOURABLE );
;;; REF: The background colour of the colourable object. The colour is
;;; REF: stored as words rather than strings or as the integer representing
;;; REF: the colour index in the colour table of the go_pane it will be
;;; REF: shown in. Such an index is not screen independent and is unsafe.
;;; REF: This means that slot defaults need to be words or integers too !!!!
;;; REF: COLOURABLE is an go_colourable instance (see REF * GO_COLOURABLE)
	if not(color) then false
	elseif isstring(color) then consword(color);
	elseif isword(color) then color;
	else   fi_check(color, 0, false);
	endif  -> colObj.stored_go_bgcolour;
	go_update_and_draw( colObj );
enddefine;

;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_colourable = true;


/* --- Revision History --------------------------------------------
 * BR 05/05/93
 *     Renamed file to reflext mixin name and added comments.
 * BR 26/11/92
 *     Global Name changes and code cleanup
 * BR 11/11/92
 *    This Mixin is retrieved from go_screenobject.p.
 */
;;; eof
