/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 * File:		S.pcwnt/src/asignals.s
 * Purpose:		Signals and system calls on 80x86 (Microsoft assembler)
 * Author:		Robert John Duncan, Apr 15 1994 (see revisions)
 * Related Files:	S.pcunix/src/asignals.s
 */

/*************************************************************************
		THIS FILE WAS GENERATED AUTOMATICALLY FROM
		/rsuna/pop/master/S.pcunix/src/asignals.s
		     ON Fri Apr 15 10:37:46 BST 1994
	  AND SUBSEQUENTLY EDITED ON Fri Apr 15 13:16:12 BST 1994
*************************************************************************/

#_<

#_INCLUDE 'declare.ph'

section $-Sys;

constant procedure (
	Callstack_reset,
	Error_signal,
);

vars
	Extern$- _saved_sp,
;

endsection;

lconstant macro (

	USP = "ebx",	;;; User stack pointer
	PB  = "ebp",	;;; Procedure base register

	SAVED_SP = [I_LAB(Sys$-Extern$- _saved_sp)],

);

>_#

	.erre	@Version ge 611
	option	casemap:none
	.386
	.model	flat


/************************* wrapping structures ************************/

	.code
	dword	L$text_size, C_LAB(Sys$-objmod_pad_key)
L$text_start:
	.data
	assume	cs:nothing
	dword	L$data_size, C_LAB(Sys$-objmod_pad_key)
L$data_start:

/**********************************************************************/


	.code

;;; -- ROUTINES TO CLEAN UP AND CALL A POP ERROR HANDLER ------------------

;;; RESET_POP_ENVIRON:
;;;	Restore a safe environment for Poplog

reset_pop_environ:

	;;; Save return address, as stack may be adjusted later

	pop	eax

	;;; Restore environment

	mov	dword ptr EXTERN_NAME(__pop_in_user_extern), 0	;;; just in case
	mov	USP, dword ptr I_LAB(_userhi)	;;; reset user stack
	mov	dword ptr EXTERN_NAME(__pop_fpe_handler), 0	;;; clear FPE handler

	;;; If saved stack pointer is non-zero, we're in an external call

	cmp	dword ptr SAVED_SP, 0
	je	L$1$1
	mov	esp, dword ptr SAVED_SP	;;; reset stack pointer
	mov	dword ptr SAVED_SP, 0	;;; clear saved stack pointer
	mov	PB, dword ptr [esp]	;;; restore procedure base

L$1$1:	jmp	eax	;;; return to caller

	align	4


;;; __POP_ERRSIG:
;;;	Chained from the exception filter in main

	public	EXTERN_NAME(__pop_errsig)
EXTERN_NAME(__pop_errsig):

	call	reset_pop_environ
	call	XC_LAB(Sys$-Error_signal)	;;; never returns

	align	4


;;; -- SYSTEM CALL INTERFACE ----------------------------------------------

;;; _CALL_SYS:
;;;     Make a system call, transferring arguments from the user stack
;;;     to the system stack. For system use only.

;;; Call:
;;;	_call_sys(_NARGS, _FNC_ADDR) -> _RES

;;; Register usage:
;;;	EAX	work; result of the system call
;;;	ECX	number of arguments to the system call
;;;	EDX	address of the system call routine

;;; Memory usage:
;;;	SAVED_SP
;;;		global variable which holds a pointer to the stack frame
;;;		of the calling procedure; used by _SIGNAL_HANDLER above.

DEF_C_LAB(_call_sys)

	;;; Save pointer to caller's stack frame in case of interrupts

	lea	eax, dword ptr [esp+4]
	mov	dword ptr SAVED_SP, eax

	;;; Get the system call address in EDX and the argument count in ECX

	mov	edx, dword ptr [USP]
	mov	ecx, dword ptr [USP+4]
	add	USP, 8

	;;; Copy any arguments to the system stack

	cmp	ecx, 0
	je	L$2$2
L$1$3:	push	dword ptr [USP]
	add	USP, 4
	loop	L$1$3

L$2$2:	;;; Make the call:
	;;; clear the direction flag first, as Sequent's library routines
	;;; seem to expect it like that!

	cld
	call	edx

	;;; Stack the result (from EAX)

	sub	USP, 4
	mov	dword ptr [USP], eax

L$3$1:	;;; Restore the stack pointer and return

	mov	eax, dword ptr SAVED_SP
	lea	esp, dword ptr [eax-4]
	mov	dword ptr SAVED_SP, 0	;;; indicates external call over
	ret

	align	4



/***************** end labels for wrapping structures *****************/

	.code
L$text_end:
	L$text_size	equ	L$text_end-L$text_start
	.data
	assume	cs:nothing
L$data_end:
	L$data_size	equ	L$data_end-L$data_start

/**********************************************************************/

@CurSeg	ends
	extern	C_LAB(Sys$-objmod_pad_key):near
	extern	EXTERN_NAME(__pop_fpe_handler):near
	extern	EXTERN_NAME(__pop_in_user_extern):near
	extern	I_LAB(_userhi):near
	extern	SAVED_SP:near
	extern	XC_LAB(Sys$-Callstack_reset):near
	extern	XC_LAB(Sys$-Error_signal):near
	end



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct 25 1994
	Removed the C pointers to pop vars (now set up in initial.p)
 */
