/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/src/sys_async_input.p
 > Purpose:			Simulate Unix-style asynchronous input on a device
 > Author:			Robert Duncan, Mar 26 1997
 > Documentation:	REF * SYSIO
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'io.ph'
#_INCLUDE 'signals.ph';
#_INCLUDE 'win32defs.ph'

constant procedure ( sys_input_waiting );

;;; -----------------------------------------------------------------------

section $-Sys$-Io => sys_async_io;

lvars in_async_read = false;

	/*	This works, for input only, by starting an overlapped read on the
		device and setting an AST on the event associated with the I/O
		completion.

		It screws up horribly if you try and write to the device while the
		overlapped read is pending (because writes use the same event for
		completion)
	*/
define sys_async_io(dev, ioset) -> trap_p;
	Check_integer_range(ioset, RD_SET, EX_SET);
	Check_device(dev, if ioset == WR_SET then 2:101 else 2:11 endif);
	if ioset == RD_SET and dev!D_UNIT_P!UNT_INPUT_TRAP ->> trap_p then
		fast_front(trap_p) -> trap_p;
	endif;
enddefine;
;;;
define updaterof sys_async_io(trap_p, dev, ioset);
	Check_integer_range(ioset, RD_SET, EX_SET);
	Check_device(dev, if ioset == WR_SET then 2:101 else 2:11 endif);
	unless ioset == RD_SET then
		mishap(dev, ioset, 2, 'sys_async_io: ASYNC INPUT ONLY SUPPORTED');
	endunless;

	if not(trap_p) then
		;;; disabling
		lvars trap = dev!D_UNIT_P!UNT_INPUT_TRAP;
		if trap then
			false -> dev!D_UNIT_P!UNT_INPUT_TRAP;
			lvars event = fast_back(trap);
			false -> sys_async_handle(event);
		endif;
		return;
	endif;

	;;; enabling
	Check_astp_arg(trap_p);

	;;; get the event object which signals overlapped completion
	lvars _ovl = _extern pop_file_is_overlapped(dev!D_CTRL_BLK!DCB_FILE);
	if _zero(_ovl) then
		mishap(dev, 1, 'sys_async_io: DEVICE NOT SET FOR OVERLAPPED I/O');
	endif;
	lvars event = sys_cons_handle(Cons_extern_ptr(_ovl), "EVENT", dev, false);

	;;; indicate async mode on the device
	conspair(trap_p, event) -> dev!D_UNIT_P!UNT_INPUT_TRAP;

	;;; handler for the event
	define InputReady(event, cancelled);
		returnif(cancelled);
		dlocal in_async_read = true;
		lvars dev = sys_handle_data(event);
		lvars trap = dev!D_UNIT_P!UNT_INPUT_TRAP;
		returnunless(trap);
		lvars trap_p = fast_front(trap), first_call = true, n;
		while (sys_input_waiting(dev) ->> n) and n fi_> 0 do
			false -> first_call;
			if ispair(trap_p) then fast_front(trap_p) -> trap_p endif;
			fast_apply(trap_p);
			dev!D_UNIT_P!UNT_INPUT_TRAP -> trap;
			returnunless(trap);
			fast_front(trap) -> trap_p;
		endwhile;
		returnif(n == 0 and first_call);	;;; assume EOF
		;;; start an overlapped read and set AST for its completion
		if _zero(_extern pop_file_start_overlapped_read(dev!D_CTRL_BLK!DCB_FILE))
		then
			dev!D_CTRL_BLK!DCB_FILE!PF_ERROR -> _syserror;
			Syserr_mishap(dev, 1, 'FAILED TO START ASYNC READ');
		endif;
		lvars ast_p = InputReady;
		if ispair(trap_p) then
			lconstant FLAGS = ASTP_TEMP_PAIR || ASTP_ERROR_DELETE;
			lvars flags = fast_back(trap_p);
			(flags fi_&&~~ ASTP_TEMP_CLOSURE) fi_|| FLAGS -> flags;
			conspair(ast_p, flags) -> ast_p;
		endif;
		ast_p -> sys_async_handle(event);
	enddefine;

	unless in_async_read then
		;;; test for input ready now
		InputReady(event, false);
	endunless;
enddefine;

endsection;		/* $-Sys$-Io */
