/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/src/sys_file_copy.p
 > Purpose:			Copy a file
 > Author:			Robert John Duncan, May 16 1994 (see revisions)
 > Documentation:	___REF * _______SYSUTIL
 > Related Files:
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'

constant
	procedure ($-Sys$-Io$-Backup_file);

;;; -----------------------------------------------------------------------


section $-Sys$-Io => sys_file_copy;

define sys_file_copy(old_name, new_name);
	sysfileok(old_name) -> old_name;
	sysfileok(new_name) -> new_name;
	lvars t_old = Tchars_in(old_name, wkstring1);
	lvars t_new = Tchars_in(new_name, wkstring2);
	returnif(_nonzero(_extern pop_copy_file(t_old@V_TCHARS, t_new@V_TCHARS, _0)));
	;;; copy failed
	GET_LAST_ERROR;
	if _syserror == _:WIN32_ERROR_FILE_EXISTS then
		;;; try backing up the existing file
		Backup_file(new_name);
		;;; then try the copy again, but this time replace existing
		Tchars_in(old_name, wkstring1) -> t_old;
		Tchars_in(new_name, wkstring2) -> t_new;
		returnif(_nonzero(_extern pop_copy_file(t_old@V_TCHARS, t_new@V_TCHARS,
			_1)));
		;;; failed again
		GET_LAST_ERROR;
	endif;
	Syserr_mishap(old_name, new_name, 2, 'CAN\'T COPY FILE');
enddefine;

endsection;		/* $-Sys$-Io */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Jan 29 1997
		Modifications for UNICODE compilation
 */
