/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			S.pcwnt/src/syscomp/asmout.p
 > Purpose:			Assembly code output for PC running Windows NT
 > Author:			Robert John Duncan, Apr  8 1994 (see revisions)
 > Related Files:	S.pcunix/src/syscomp/asmout.p
 */


#_INCLUDE 'common.ph'

	;;; assume this version of the Microsoft Macro Assembler
global constant macro MASM = 611;	;;; = 6.11

;;; -----------------------------------------------------------------------

section $-Popas;

define popint(n); lvars n; (n << 2) || 3; enddefine;

define mcint(n); lvars n; n >> 2; enddefine;

;;; Local labels

vars nextlabel;

define nextlab();
	dlocal pop_pr_radix = 36;
	'L$' >< nextlabel;
	nextlabel fi_+ 1 -> nextlabel;
enddefine;

;;; Global labels constructed from word plus prefix char

define lconstant asm_label(word, prefix_char) -> string;
	lvars word, prefix_char, string;
	lconstant SEP_CHAR = `$`;
	if isstring(word) then word else fast_word_string(word) endif -> string;
	lvars n, len = datalength(string);
	consstring(#|
		prefix_char, SEP_CHAR;
		fast_for n to len do
			go_on dup(fast_subscrs(n, string)) to
			;;; 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6
				c c c c c c c c c c c c c c c c		;;; Ctrl-A -- Ctrl-P
				c c c c c c c c c c c c c c c c		;;; Ctrl-Q -- SPACE
				s s s $ s s s s s s s s s s s d		;;;   !    --   0
				d d d d d d d d d s s s s s s s		;;;   1    --   @
				A A A A A A A A A A A A A A A A		;;;   A    --   P
				A A A A A A A A A A s s s s u s		;;;   Q    --   `
				a a a a a a a a a a a a a a a a		;;;   a    --   p
				a a a a a a a a a a s s s s c c		;;;   q    -- \(128)
			else c;

			A: a: d: u :		;;; alpha, digit, underscore
				nextloop;

			$ :
				if n /== len and fast_subscrs(n fi_+ 1, string) == `-`
				and (n /== 1 or len fi_> 2)
				then
					;;; replace section separator $- with SEP_CHAR
					-> ;			;;; erase $
					unless n == 1 then SEP_CHAR endunless;
					n fi_+ 1 -> n;	;;; skip -
					nextloop
				;;; else drop thru to "s"
				endif;

			s: c:				;;; other sign, control etc
				;;; represent as 3 decimal digits
				lvars (r, q) = () fi_// 100;
				q fi_+ `0`;
				r fi_// 10 -> (r, q);
				q fi_+ `0`, r fi_+ `0`;
		endfor;
	|#) -> string;
enddefine;

define asm_identlabel	= asm_label(% `i` %) enddefine;
define asm_pdpropslabel	= asm_label(% `p` %) enddefine;
define asm_symlabel		= asm_label(% `c` %) enddefine;
define asm_testdeflabel	= asm_label(% `t` %) enddefine;
define asm_wordidlabel	= asm_label(% `z` %) enddefine;
define asm_wordlabel	= asm_label(% `w` %) enddefine;

;;; Recording imports and exports from files:

define lconstant new_file_property(item, prop) -> p;
	lvars item, prop, p;
	newanyproperty([], 64, 1, 56, syshash, nonop =, "perm", false, false) -> p;
	p -> prop(item);
enddefine;
;;;
define lconstant file_uses =
	newanyproperty([], 8, false, false, false, false, "tmparg", false,
		new_file_property);
enddefine;
;;;
define lconstant file_defines =
	newanyproperty([], 8, false, false, false, false, "tmparg", false,
		new_file_property);
enddefine;

;;; Starting and ending an assembly code file

define asm_startfile(name);
	lvars name;
	;;; check assembler version
	asmf_printf(MASM, '\t.erre\t@Version ge %p\n');
	;;; preserve case of user identifiers
	asmf_printf('\toption\tcasemap:none\n');
	;;; declare processor type (80[345]86)
	lconstant PROCESSOR_TYPE = hd(PROCESSOR) - 80000;
	asmf_printf(PROCESSOR_TYPE, '\t.%p\n');
	;;; use the FLAT memory model
	asmf_printf('\t.model\tflat\n');
	;;; dummy section opener to match "ends" at EOF
	asmf_printf('\t.code\n');
enddefine;

define asm_endfile();
	;;; close the current segment (whatever it is)
	asmf_printf('\n@CurSeg\tends\n');
	;;; write out external declarations for all labels used and not
	;;; defined locally
	lvars label, procedure defines = file_defines(asmf_charout);
	for label in
		[%	appproperty(
				file_uses(asmf_charout),
				procedure(label, type);
					lvars label, type;
					unless defines(label) then label endunless;
				endprocedure);
		%], nc_listsort((), alphabefore)
	do
		asmf_printf(label, '\textern\t%p:near\n');
	endfor;
	;;; end the file
	asmf_printf('\tend\n');
enddefine;

;;; Switching segments:

define asm_startcode();
	asmf_printf('\n\t.code\n');
enddefine;

define asm_startdata();
	asmf_printf('\n\t.data\n');
	;;; default assumption in the data segment is ``cs:error'' to
	;;; prevent code generation: override that
	asmf_printf('\tassume\tcs:nothing\n');
enddefine;

;;; Planting labels:

define asm_outlab(lab);
	lvars lab;
	asmf_printf(lab, '%p:\n');
	true -> file_defines(asmf_charout)(lab);
enddefine;

define asm_outlabset(lab, val);
	lvars lab, val;
	asmf_printf(
		val, lab,
		if datalength(lab) fi_>= 8 then
			'%p\\\n\tequ\t%p\n'
		else
			'%p\tequ\t%p\n'
		endif);
	true -> file_defines(asmf_charout)(lab);
enddefine;

define asm_outglab(lab);
	lvars lab;
	asmf_printf(lab, '\tpublic\t%p\n');
	asm_outlab(lab);
enddefine;

define asm_outglabset(lab, val);
	lvars lab, val;
	asmf_printf(lab, '\tpublic\t%p\n');
	asm_outlabset(lab, val);
enddefine;

define asm_uselab(lab) -> lab;
	lvars lab;
	;;; record a reference to this label for possible later extern
	;;; declaration, unless it's obviously local
	define lconstant is_global_ref(item) -> lab;
		lvars item, lab = false;
		returnunless(isstring(item));
		lvars len = datalength(item);
		returnif(len == 0);
		lvars c = fast_subscrs(1, item);
		returnunless(isalphacode(c) or c == `_`);
		;;; label: exclude locals starting 'L$' or 'xL$'
		returnif(
			len fi_> 2
			and (  c == `L` and fast_subscrs(2, item) == `$`
				or c == `x` and fast_subscrs(2, item) == `L`
							and fast_subscrs(3, item) == `$`
				));
		;;; possible external
		item -> lab;
		;;; strip any trailing +/- displacement
		if (locchar(`+`, 2, lab) ->> c)
		or (locchar(`-`, 2, lab) ->> c)
		then
			substring(1, c fi_- 1, lab) -> lab;
		endif;
	enddefine;

	lvars extern;
	if is_global_ref(lab) ->> extern then
		true -> file_uses(asmf_charout)(extern);
	endif;
enddefine;


;;; Planting inline data:

define asm_align_word();
	asmf_printf('\talign\t4\n');
enddefine;

define asm_align_double();
	asm_align_word();
enddefine;

define lconstant outdata(n, type);
	lvars i, n, type;
	returnif(n == 0);

	define lconstant datum(i);
		lvars i, d = subscr_stack(i);
		asm_uselab(if isword(d) then fast_word_string(d) else d endif);
	enddefine;

	asmf_printf(type, '\t%p\t');
	fast_for i from n by -1 to 2 do
		asmf_pr(datum(i)), asmf_charout(',\s');
	endfor;
	asmf_printf(datum(1), '%p\n');
	erasenum(n);
enddefine;

define asm_outbyte	= outdata(% "byte" %) enddefine;
define asm_outshort	= outdata(% "word" %) enddefine;
define asm_outint	= outdata(% "dword" %) enddefine;
define asm_outword	= outdata(% "dword" %) enddefine;

define asm_out_dfloat(hipart, lopart);
	lvars hipart, lopart;
	asm_outword(lopart, hipart, 2);
enddefine;

	/*	optional procedure used by poplink to do more compact generation
		of strings
	*/
define asm_quick_genstring(string);
	lvars i, string, n = datalength(string);
	returnif(n == 0 or n > 255)(false);
	fast_for i to n do
		lvars c = fast_subscrs(i, string);
		returnif(c fi_< `\s` or c fi_> `~` or c == `\\` or c == `"`)(false);
	endfor;
	asmf_charout('\tbyte\t"'), asmf_charout(string), asmf_charout(`"`);
	;;; Pad to a word boundary
	n && (WORD_BYTES - 1) -> n;
	unless n == 0 then
		repeat WORD_BYTES - n times
			asmf_charout(',0');
		endrepeat;
	endunless;
	asmf_charout(`\n`);
	true;
enddefine;

	/*	-asm_addbits- is used to accumulate a sequence of bitfields into
		a (big)integer which -asm_outbits- is then called to output when the
		total number of bits accumulated occupies an exact number of bytes.
			-val- is the currently accumulated (big)integer, containing
		-nbits- bits so far; -new_val- is the field to be added, containing
		-new_nbits- bits.
			The value returned will be the -val- input for the next field
		(with -nbits- incremented by -new_nbits-), and so on. Other than
		initialising -val- to 0 at the start, nothing is assumed about how
		the fields are added to it, so it is the responsibility of this
		procedure and -asm_outbits- to output the bitfields correctly.
	*/
	;;; 386 version same as VAX ('little endian'), adds the fields at the
	;;; top and outputs the bytes from the bottom up
define asm_addbits(new_val, new_nbits, val, nbits);
	lvars new_val, new_nbits, val, nbits;
	val || (new_val << nbits) 	;;; add the new field at the top
enddefine;

	/*	In this, -nbits- is a multiple of BYTE_BITS, and -val- has been
		produced by repeated calls of -asm_addbits-
	*/
define asm_outbits(val, nbits);
	lvars val, nbits, count = 0;
	lconstant BYTE_MASK = (1<<BYTE_BITS)-1;
	until nbits == 0 do
		val && BYTE_MASK;			;;; output bytes from the bottom up
		val >> BYTE_BITS -> val;
		nbits-BYTE_BITS -> nbits;
		;;; this just saves putting each byte on a separate line
		if (count+1 ->> count) == 12 then asm_outbyte(count), 0 -> count endif;
	enduntil;
	if count /== 0 then asm_outbyte(count) endif
enddefine;

;;; asm_expr:
;;; 	add/subtract a displacement to/from a label

define asm_expr(lab, op, disp);
	lvars lab, op, disp;
	if disp == 0 then
		lab;
	elseif disp > 0 then
		lab >< op >< disp;
	elseif op == "+" then
		lab >< disp;
	else
		lab >< "+" >< abs(disp);
	endif;
enddefine;

;;; asm_pdr_len:
;;;     construct an expression which will evaluate to the length of a
;;;     procedure (in long words) given its header size, execute address
;;;     and end address

define asm_pdr_len(hdr_size, exec_addr, end_addr);
	lvars hdr_size, exec_addr, end_addr;
	dlocal cucharout = identfn;
	consstring(#|
		printf('(%p-%p) shr 2 + %p', [^end_addr ^exec_addr ^hdr_size]);
	|#);
enddefine;


;;; asm_gen_poplink_code:
;;;		code for undefined procedures generated by poplink

define asm_gen_poplink_code(outlabs, nfroz, jmplab);
	lvars outlabs, nfroz, jmplab, l, offs;
	;;; plant exec labels
	outlabs();
	;;; Push nfroz frozvals (last nfroz longwords planted)
	;;; EBX is the user stack pointer
	asm_outlab(nextlab() ->> l);
	fast_for offs from nfroz*4 by -4 to 4 do
		asmf_pr('\tsub\tebx, 4\n');
		asmf_printf(offs, l, '\tmov\teax, dword ptr %p-%p\n');
		asmf_pr('\tmov\tdword ptr [ebx], eax\n');
	endfast_for;
	;;; jump to -jmplab-
	asm_uselab(jmplab) -> jmplab;
	asmf_printf(jmplab, '\tmov\teax, %p\n');
	asmf_pr('\tjmp\teax\n');
	;;; Return the number of longwords planted
	asm_align_word();
	(nfroz*11+10)>>2;
enddefine;


/*
 *	Exfunc closure code -- jump to subroutine _exfunc_clos_action (aextern.s)
 *	with exfunc_closure record address in a reg, etc. This procedure is
 *	passed the label of _exfunc_clos_action. The code generated must be
 *	padded to exactly 4 words.
 */

define asm_gen_exfunc_clos_code(action_lab);
	lvars action_lab;
	asm_uselab(action_lab) -> action_lab;
	;;; lea eax, _exfunc_clos_action (= 6 bytes)
	asmf_printf(action_lab, '@@:\tlea\teax, %p\n');
	;;; call eax (= 2 bytes)
	asmf_printf('\tcall\teax\n');
	;;; pad to 16 bytes
	asmf_printf('\torg\t@b+16\n');
enddefine;


/*
 *	extern_name_translate:
 *		translate an external symbol, using the same conventions as the
 *		C compiler and linker (e.g. add a leading '_', truncate to N
 *		characters, etc.)
 */

define global extern_name_translate(lang, symbol, type) -> _symbol;
	lvars lang, symbol, type, _symbol;

		;;; Win32 API functions use the _______stdcall calling convention,
		;;; which means their names are dependent on the argument build
		;;; size: this is hard to work out dynamically, so for now we
		;;; just have a table of all the ones we reference. If a symbol
		;;; isn't found here, it's assumed to be a C-type function.
	define lconstant stdcall =
		newmapping([
			['GetEnvironmentVariable'		'_GetEnvironmentVariable@12']
			['SetEnvironmentVariable'		'_SetEnvironmentVariable@12']
			['ExpandEnvironmentStrings'		'_ExpandEnvironmentStrings@12']
		], 64, false, false);
	enddefine;

	unless stdcall(symbol) ->> _symbol then
		'_' <> symbol -> _symbol;
	endunless;
	true -> file_uses(asmf_charout)(_symbol);
enddefine;

endsection;		/* $-Popas */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 15 1996
		New version of extern_name_translate.
--- Robert John Duncan, Feb 12 1996
		Added initial ".code" directive to the start of every file so that
		the "@CurSeg ends" at the end will always have something to close.
--- John Gibson, Apr  3 1995
		Added asm_outint
--- Robert John Duncan, Jan 26 1994
		Revised to assume PC/Unix-type system
--- Robert John Duncan, May 20 1993
		Really added asm_gen_exfunc_clos_code
--- John Gibson, May 19 1993
		Added asm_gen_exfunc_clos_code
--- Robert John Duncan, Jul 27 1992
		Added -extern_name_translate-
--- John Gibson, Jul 17 1989
		OS command procedures commoned in C.unix/src/syscomp/os_comms.p
		(but this file still defines the "ld" command string since this
		is different for nearly every system).
--- John Gibson, Jun  7 1989
		Included common.ph
--- John Gibson, May 18 1989
		Thought the two uses of #_IF which didn't have newlines after
		the conditions were causing a problem, so changed them, but
		then realised they weren't, so changed them back!
--- John Gibson, Mar 23 1989
		Added -asm_addbits- and -asm_outbits-
--- Rob Duncan, Feb 16 1989
		Amalgamated with Sun 386 version
--- Rob Duncan, Feb  3 1989
		Fixed the code size returned by -asm_gen_poplink_code-
--- John Gibson, Feb  2 1989
		Changed -asm_gen_poplink_code- to allow any number of frozvals to
		be pushed.
--- John Gibson, Nov 16 1988
		Added procedure -unix_archive- (used by poplibr)
--- Rob Duncan, Oct 27 1988
		Changed -asm_startfile- to take the filename as argument
--- Rob Duncan, Oct 11 1988
		Removed a spurious `%` character from -asm_gen_poplink_code-
 */
