/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.windows/src/syscomp/os_comms.p
 > Purpose:			O/S commands for assembling and linking
 > Author:			Robert John Duncan, Apr  8 1994 (see revisions)
 > Related Files:	C.{unix,vms}/src/syscomp/os_comms.p
 */

#_INCLUDE 'common.ph'

section $-Popas;

define assemble_files(plist);
	lvars plist;
	unless islist(plist) then plist :: [] -> plist endunless;
	lvars item;
	for item in plist do
		lvars (afile, ofile) = destpair(item);
		sysobey('ml -nologo -c -coff -Fo' <> ofile <> ' ' <> afile);
		unless pop_status == 0 then
			mishap(0, 'ERRORS IN ASSEMBLER FILE (see above)');
		endunless;
		add_created_file(ofile);
	endfor;
enddefine;

define gen_link_command(exlink, link_cmnd, image_name, wobj_files, link_flags,
						link_other, extern_libdir, share, makebase,
						cleanup_command);
	lvars exlink, link_cmnd, image_name, wobj_files, link_flags,
		link_other, extern_libdir, share, makebase, cleanup_command;

	dlocal asmf_charout = discout(link_cmnd);
	add_created_file(link_cmnd);

	;;; comment
	asmf_printf('#\n# Usage: nmake -f <this-file> [IMAGE=<image-name>]\n#\n');
	;;; stop NMAKE echoing commands
	asmf_printf('.SILENT:\n');
	;;; include standard definitions
	asmf_printf('!INCLUDE <win32.mak>\n');
	;;; define POPEXTERNLIB -- may be overridden from environment or command
	;;; line; default is OK for $popsrc & $popsys
	asmf_printf('!IFNDEF POPEXTERNLIB\n');
	asmf_printf('POPEXTERNLIB=..\\extern\\lib\n');
	asmf_printf('!ENDIF\n');
	;;; define image name -- may be overridden on command line
	if sys_fname_extn(image_name) = nullstring then
		;;; default to .EXE
		image_name <> '.exe' -> image_name;
	endif;
	asmf_printf(image_name, 'IMAGE=%p\n');
	;;; pseudotarget to activate the link
	asmf_printf('link:\n');

	;;; the last_obj file must be linked at the end of the Poplog data area
	;;; but the Microsoft linker puts all command-line objects before those
	;;; extracted from libraries, so if the wobj_files list contains any
	;;; libraries, then to get last_obj in the right place we have to pack
	;;; it into a library also
	lconstant last_obj = 'poplink_4.o';
	lvars last_lib = false;
	[%	lvars file, lib_seen = false;
		for file in wobj_files do
			if isref(file) then
				;;; library
				true -> lib_seen;
				cont(file);
			elseif file = last_obj and lib_seen then
				;;; replace with lib equivalent
				sys_fname_nam(file) <> '.olb' ->> last_lib;
			else
				file;
			endif;
		endfor;
	%] -> wobj_files;
	if last_lib then
		;;; lib command
		asmf_printf(last_obj, last_lib, '\t$(implib) -nologo -out:%p %p\n');
	endif;
	;;; link command: additional options and file names go in an inline
	;;; file to avoid problems with command line length
	asmf_printf('\t$(link) -nologo $(linkdebug) -out:$(IMAGE) @<<\n');
	lvars arg, subsystem_known = false;
	for arg in link_flags do
		asmf_printf(arg, '%p\n');
		if isstartstring('-subsystem', arg) then
			true -> subsystem_known;
		endif;
	endfor;
	unless subsystem_known or sys_fname_extn(image_name) = '.dll' then
		;;; create console app by default
		asmf_printf('$(conlflags)\n');
	endunless;
	for arg in wobj_files do asmf_printf(arg, '%p\n') endfor;
	asmf_printf('$(POPEXTERNLIB)\\popwin.lib\n');
	asmf_printf('$(POPEXTERNLIB)\\popcore.lib\n');
	asmf_printf('$(POPEXTERNLIB)\\popmain.lib\n');
	for arg in link_other do asmf_printf(arg, '%p\n') endfor;
	asmf_printf('$(guilibsdll) advapi32.lib winmm.lib\n');
	asmf_printf('<<\n');
	;;; clean-up command
	if cleanup_command then
		asmf_printf(cleanup_command, '\t%p\n');
	endif;

	asmf_charout(termin);
enddefine;

define assemble_and_link(link_cmnd, a_files, image_name, makebase);
	lvars link_cmnd, a_files, image_name, makebase;
	if sys_fname_extn(image_name) = nullstring then
		;;; default to .EXE
		image_name <> '.exe' -> image_name;
	endif;
	assemble_files(a_files);
	sysobey('nmake -nologo -f ' <> link_cmnd <> ' IMAGE=' <> image_name);
	unless pop_status == 0 then
		mishap(0, 'ERRORS IN LINKING (see above)');
	endunless;
enddefine;

	/*	Run LIB32 to create/manipulate an archive library
	*/
define os_library_command(option, libfile, objfiles);
	lvars option, libfile, objfiles, objfile, tmpfile;
	new_tmp_file(false, 'lib', option=="x" and '.bat' or '.opt') -> tmpfile;
	add_created_file(tmpfile);
	dlocal asmf_charout = discout(tmpfile);
	if option == "c" then
		;;; create:
		;;; lib -out:libfile objfiles
		asmf_printf(libfile, '-out:%p\n');
		for objfile in objfiles do
			asmf_printf(objfile, '%p\n');
		endfor;
	elseif option == "r" then
		;;; replace:
		;;; lib -out:libfile libfile objfiles
		asmf_printf(libfile, libfile, '-out:%p %p\n');
		for objfile in objfiles do
			asmf_printf(objfile, '%p\n');
		endfor;
	elseif option == "x" then
		;;; extract (one at a time):
		;;; lib -extract:objfile -out:objfile libfile
		for objfile in objfiles do
			asmf_printf(libfile, objfile, sys_fname_name(objfile),
				'@lib >nul -extract:%p -out:%p %p\n');
		endfor;
	elseif option == "d" then
		;;; delete (ignoring pointless warning 501):
		;;; lib -ignore:501 -out:libfile libfile -remove:objfile ... -remove:objfile
		asmf_printf(libfile, libfile, '-ignore:501 -out:%p %p\n');
		for objfile in objfiles do
			asmf_printf(sys_fname_name(objfile), '-remove:%p\n');
		endfor;
	endif;
	asmf_charout(termin);
	sysobey(option=="x" and tmpfile or 'lib >nul @' <> tmpfile);
	unless pop_status == 0 then
		mishap(0, 'ERRORS RUNNING LIB32 (see above)')
	endunless;
enddefine;

	/*	Run POPLINK/POPLIBR from POPC
	*/
define run_comp_util(arg_list, name);
	lvars arg, arg_list, name, tmpfile;
	add_created_file(new_tmp_file(false, name, '.opt') ->> tmpfile);
	dlocal asmf_charout = discout(tmpfile);
	asmf_printf(name, '+$popsys/%p.psv\n');
	for arg in arg_list do
		asmf_printf(arg, '%p\n');
	endfor;
	asmf_charout(termin);
	sysobey(sysfileok('$popsys/corepop') <> ' @' <> tmpfile);
	unless pop_status == 0 then
		mishap(0, sprintf(lowertoupper(name), 'ERRORS RUNNING %p (see above)'))
	endunless;
enddefine;

endsection;		/* $-Popas */


/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Feb 12 1996
		Changes to poplink_cmnd:
		o	Fixed to allow for w-libraries by adding command to pack
			poplink_4.o into a temporary library when required.
		o	Made it sensitive to definition of POPEXTERNLIB, which will
			typically be set when command invoked from POPLINK.
		o	Added LINK "nologo" option which suppresses echoing of the
			command file as well as the banner; means that assemble_and_link
			doesn't have to redirect its output (including errors!) to NUL.
--- Robert John Duncan, Sep 15 1995
		lib32 --> lib
--- Robert John Duncan, Sep 13 1995
		Added missing popmain library from poplink_cmnd
 */
