/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:		S.pcwnt/src/syscomp/sysdefs.p
 > Purpose:		Definitions for machine & operating system (PC/WindowsNT)
 > Author:		Robert Duncan, Oct 31 1988 (see revisions)
 */


section;

global constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; === SYSTEM NAME (PC) ==============================================


	MACHINE = [[pc]],

	PC = true,


;;; === PROCESSOR (INTEL 80x86) =======================================


	PROCESSOR = [[80486]],		;;; or similar

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	SHORT_ALIGN_BITS = 8,		;;; alignment in bits for short access
	INT_ALIGN_BITS	 = 8,		;;; alignment in bits for int access
	DOUBLE_ALIGN_BITS = 8,		;;; alignment in bits for double access

	STRUCT_SHORT_ALIGN_BITS	= 16,	;;; bit alignment for short
	STRUCT_INT_ALIGN_BITS   = 32,	;;; bit alignment for int
	STRUCT_DOUBLE_ALIGN_BITS = 32,	;;; bit alignment for double

	CODE_POINTER_TYPE = "byte",	;;; type of pointer to machine code
	BIT_POINTER_TYPE = "byte",	;;; type of pointer for bitfield access


;;; == OPERATING SYSTEM (Windows NT) ======================================

	OPERATING_SYSTEM = [[windows nt 3.51]],

	WINDOWS_NT = last(OPERATING_SYSTEM(1)),
	WINDOWS = WINDOWS_NT,
	WIN32 = true,				;;; target API

	WIN32_UNICODE = true,		;;; uses Unicode APIs

	VPAGE_OFFS = 16:1000,		;;; word address offset of a virtual page

	LOWEST_ADDRESS = 64*1024,	;;; first 64Kb reserved to system

	SHARED_LIBRARIES = true,	;;; uses DLLs for external load


;;; === OTHER =========================================================

	;;; Using an ANSI C compiler & run-time library

	ANSI_C = true,
	C_FLOAT_RESULT_SINGLE = true,

	;;; list of procedures to be optimised as subroutine calls
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]

	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar	0 1 _prolog_newvar]
			[datakey		1 1 _datakey]
			[prolog_deref	1 1 _prolog_deref]
			[conspair		2 1 _conspair]
		]],

	;;; Old-style I_PUSH/POP_FIELD(_ADDR) instructions in ass.p
	OLD_FIELD_INSTRUCTIONS = true,

	;;; Include M-code listing in assembly language files

	M_DEBUG = false,

);

endsection;		/* $- */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Feb 13 1997
		Added WIN32_UNICODE
--- John Gibson, Nov  4 1996
		Added OLD_FIELD_INSTRUCTIONS. Removed is* procedures from
		SUBROUTINE_OPTIMISE_LIST (no longer required).
--- Robert Duncan, Mar 21 1996
		NT version = 3.51
--- John Gibson, Mar 21 1995
		Standard machine data type definitions are now in mcdata.p
--- Robert John Duncan, Sep  5 1994
		Adapted for Windows NT from version in S.pcunix
--- Robert John Duncan, Jan 26 1994
		Modified from Sun386 (now defunct) for PC running SVR4
		(some things left unchecked for now ...)
--- John Gibson, Oct 22 1992
		Changed P*OPC to POPC_SYSDEFS_LOADED
--- Robert John Duncan, Jun 23 1992
		Added BSD_VFORK
--- John Gibson, Dec 11 1990
		SUNOS 4.1
--- Rob Duncan, Aug 31 1989
		Put in value for UNIX_USRSTACK
--- John Gibson, Aug 31 1989
		Added comment for UNIX_USRSTACK, but have no way of finding value.
--- John Gibson, Aug 24 1989
		Removed S+IGNALS
--- Rob Duncan, Apr  3 1989
		Changed OPERATING_SYSTEM definition to include "unix" as well as
		"sunos"
 */
