/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/src/sysdate.p
 > Purpose:			Return the date and time as a string
 > Author:			Robert John Duncan, Feb 18 1994 (see revisions)
 > Documentation:	___REF * _____TIMES
 > Related Files:
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'

constant procedure (sys_real_time);

;;; -----------------------------------------------------------------------


section $-Sys => sys_convert_date, sysdaytime;

define sys_convert_date(seconds, localtime) -> date;
	lconstant msg = 'FAILED TO CONVERT THE DATE';
	lvars seconds, localtime, date;
	lvars _time = Pint_->_uint(seconds, _-1);
	lvars _local = if localtime then _1 else _0 endif;
	lvars _n = _extern pop_convert_date(_local, _time, wkstring1@V_TCHARS,
		_:WKSTRING_LENGTH);
	if _zero(_n) then
		mishap(seconds, 1, msg);
	elseif _n _lt _:WKSTRING_LENGTH then
		Tchars_out(wkstring1, _n) -> date;
	else
		lvars wkstring = Get_tstring(_n);
		unless _extern pop_convert_date(_local, _time, wkstring@V_TCHARS,
			_n _add _1) == _n
		then
			mishap(seconds, 1, msg);
		endunless;
		Tchars_out(wkstring, _n) -> date;
	endif;
enddefine;

define sysdaytime();
	sys_convert_date(sys_real_time(), true);
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Jan 29 1997
		Modifications for UNICODE compilation
 */
