/* --- Copyright University of Sussex 1998. All rights reserved. ----------
 > File:			C.win32/src/sysfileok.p
 > Purpose:			Filename translation and expansion
 > Author:			Robert John Duncan, Feb 23 1994 (see revisions)
 > Documentation:	___REF * _______SYSUTIL
 > Related Files:	C.win32/src/systranslate.p
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'

constant
	procedure (isalphacode, isnumbercode, Sys$-Expand_environment_strings,
		Sys$-Explode_substring, Sys$-Is_environment_variable, )
;

vars
	popdirectory,
;

;;; -----------------------------------------------------------------------

section $-Sys =>
	pop_filename_case
	pop_max_filename_len
	sysfileok
	dir_><
;

vars
	pop_filename_case = "lower",
		;;; map filenames to lower case
;

protected vars
	pop_max_filename_len = WIN32_MAX_FILE,
;

	/*	Convert filename to consistent case according to
		pop_filename_case
	*/
define Case_convert(file) -> file;
	lvars file;
	if pop_filename_case == "lower" then
		uppertolower(file) -> file;
	elseif pop_filename_case == "upper" then
		lowertoupper(file) -> file;
	endif;
enddefine;

	/*	Expand a filename to a full pathname
	*/
define Get_full_pathname(file) -> fullname;
	Tchars_in(file, wkstring1) -> file;
	wkstring2 -> fullname;
	lvars _n = _extern pop_get_full_pathname(file@V_TCHARS, fullname@V_TCHARS,
		_:WKSTRING_LENGTH);
	if _n _gr _:WKSTRING_LENGTH then
		;;; longer buffer needed
		Get_tstring(_n _sub _1) -> fullname;
		if _extern pop_get_full_pathname(file@V_TCHARS, fullname@V_TCHARS, _n)
			== _n _sub _1
		then
			Tchars_out(fullname, _n _sub _1) -> fullname;
		else
			false -> fullname;
		endif;
	elseif _nonzero(_n) then
		Tchars_out(fullname, _n) -> fullname;
	else
		false -> fullname;
	endif;
	if fullname then
		Case_convert(fullname) -> fullname;
	endif;
enddefine;

	/*	Expand a filename pattern where the last component only may
		include wildcards '*' and '?'. Returns the number of matching
		files. Optional _flags argument can increase or reduce the
		number of matching files:
			bit 0 => match only directory names
			bit 1 => match hidden files
	*/
define Expand_file_pattern(pat) -> count;
	lvars _flags = _0;
	if isinteger(pat) then
		((), _int(pat)) -> (pat, _flags);
	endif;
	lvars path_len = locchar_back(`\\`, datalength(pat), pat) or 0;
	dlvars _handle, _attrs;
	lvars t_pat = Tchars_in(pat, wkstring1);
	lvars _nchars = _extern pop_start_file_search(t_pat@V_TCHARS,
		wkstring2@V_TCHARS, _:WKSTRING_LENGTH, ident _attrs, ident _handle);
	lvars count = (#|
		until _zero(_nchars) do
			unless _flags _bitst _2:01
				and not(_attrs _bitst _:WIN32_FILE_ATTRIBUTE_DIRECTORY)
			or _attrs _bitst _:WIN32_FILE_ATTRIBUTE_HIDDEN
				and not(_flags _bitst _2:10)
			or _nchars == _2 and wkstring2!V_TCHARS[_0] == _:`.`
			or _nchars == _3 and wkstring2!V_TCHARS[_0] == _:`.`
							 and wkstring2!V_TCHARS[_1] == _:`.`
			then
				;;; accepted -- reunite file name with path
				lvars match = Tchars_out(wkstring2, _nchars _sub _1);
				Case_convert(consstring(#|
					Explode_substring(1, path_len, pat),
					explode(match),
				|#));
			endunless;
			;;; get next
			_extern pop_file_search(_handle, wkstring2@V_TCHARS,
				_:WKSTRING_LENGTH, ident _attrs) -> _nchars;
		enduntil;
	|#);
	_extern pop_end_file_search(_handle) -> ;
enddefine;

	/*	Do standard Unix pathname conversions
	*/
define lconstant Unix_convert(string) -> string;
	lvars string, orig = string;

	if isword(string) then
		copy(string!W_STRING) -> string;
	else
		Check_string(string);
	endif;

	lvars _i, _c, _len = datalength(string);
	returnif(_len == 0);

	fast_subscrs(1, string) -> _c;
	if _c == `$` then
		;;; May be a Unix-style env. var $____name, where ____name is a sequence
		;;; of alphanumerics followed by a `/` or the end of the string.
		;;; If so, replace by DOS-style %____name%.
		fast_for _i from 2 to _len do
			fast_subscrs(_i, string) -> _c;
			quitunless(isalphacode(_c) or isnumbercode(_c) or _c == `_`);
		endfor;
		if _i fi_> 2 and (_i fi_> _len or _c == `/`) then
			consstring(
				`%`, Explode_substring(2, _i fi_- 2, string), `%`,
				if _i fi_<= _len then
					Explode_substring(_i, _len fi_- _i fi_+ 1, string)
				endif,
				_len fi_+ 1
			) -> string;
		endif;
	elseif _c == `~` then
		;;; isolated '~' replaced by user's login directory
		;;; (popdirectory)
		if _len == 1 then
			copy(popdirectory) -> string;
		elseif fast_subscrs(2, string) == `/` then
			consstring(#|
				unless datalength(popdirectory) == 0 then
					explode(popdirectory),
					;;; drop any trailing `\\`
					if dup() == `\\` then erase() endif;
				endunless;
				Explode_substring(2, _len fi_- 1, string)
			|#) -> string;
		endif;
	elseif _c == `/` then
		;;; special cases for /tmp and /dev/null
		if isstartstring('/tmp', string) then
			if _len == 4 or fast_subscrs(5, string) == `/` then
				;;; replace with some temporary directory
				;;; NB: we don't like Win32 GetTempPath() because it
				;;; defaults to %WinDir%
				consstring(#|
					if Is_environment_variable('TMP') then
						explode('%TMP%')
					elseif Is_environment_variable('TEMP') then
						explode('%TEMP%')
					else
						explode('%SystemDrive%\\TEMP')
					endif,
					Explode_substring(5, _len fi_- 4, string),
				|#) -> string;
			endif;
		elseif string = '/dev/null' then
			copy('nul') -> string;
		endif;
	endif;

	;;; Replace Unix-style / separators by \ throughout
	if locchar(`/`, 1, string) ->> _i then
		if string == orig then copy(string) -> string endif;
		repeat
			`\\` -> fast_subscrs(_i, string);
			quitunless(locchar(`/`, _i fi_+ 1, string) ->> _i);
		endrepeat;
	endif;
enddefine;

define sysfileok(string);
	lvars string, want_parse = false, _i, _len;
	_CLAWBACK_SAVE;

	if isboolean(string) then ((), string) -> (string, want_parse) endif;

	Unix_convert(string) -> string;
	returnif(datalength(string) == 0)
		(nullstring, if want_parse then 1,1,1,1,1 endif);

	Expand_environment_strings(string) -> string;
	datalength(string) -> _len;

	;;; Parse the expanded name
	lvars
		parse_drive = 1,
		parse_dir = 1,
		parse_name,
		parse_extn,
		parse_vers,
	;
	;;; look for a leading drive letter (X:) OR share spec (\\server\share)
	if _len fi_>= 2 then
		if fast_subscrs(2, string) == `:` then
			3 -> parse_dir;
		elseif fast_subscrs(1, string) == `\\`
		and fast_subscrs(2, string) == `\\`
		then
			unless locchar(`\\`, 3, string) ->> parse_drive then
				_len fi_+ 1 ->> parse_drive -> parse_dir;
			elseunless locchar(`\\`, parse_drive fi_+ 1, string) ->> parse_dir
			then
				_len fi_+ 1 -> parse_dir;
			endunless;
		endif;
	endif;
	;;; directory extends up to last `\`
	parse_dir -> parse_name;
	while locchar(`\\`, parse_name, string) ->> _i do
		_i fi_+ 1 -> parse_name;
	endwhile;
	;;; filename extends up to last `.`
	if locchar(`.`, parse_name, string) ->> parse_extn then
		while locchar(`.`, parse_extn fi_+ 1, string) ->> _i do
			_i -> parse_extn;
		endwhile;
	endif;
	;;; version is a trailing sequence of `-` characters
	_len -> _i;
	while _i fi_>= parse_name and fast_subscrs(_i, string) == `-` do
		_i fi_- 1 -> _i;
	endwhile;
	_i fi_+ 1 -> parse_vers;
	unless parse_extn then parse_vers -> parse_extn endunless;

	;;; Ensure that length(name+extn+vers) <= pop_max_filename_len
	_len fi_- parse_name fi_+ 1 fi_- pop_max_filename_len -> _i;
	if _i fi_> 0 then
		;;; _i is the excess to be trimmed
		parse_vers fi_- _i -> parse_vers;
		parse_extn fi_- _i -> _i;
		if _i fi_<= parse_name then
			mishap(string, 1, 'sysfileok: EXTENSION/VERSION PART TOO LONG');
		endif;
		consstring(
			Explode_substring(1, _i fi_- 1, string),
			Explode_substring(parse_extn, _len fi_- parse_extn fi_+ 1, string),
			parse_name fi_+ pop_max_filename_len fi_- 1 ->> _len,
		) -> string;
		_i -> parse_extn;
	elseif _len == 0 then
		nullstring -> string;
	endif;
	;;; ... and that the full path length is < MAX_PATH
	if _len fi_>= WIN32_MAX_PATH then
		mishap(string, 1, 'sysfileok: PATH TOO LONG');
	endif;

	;;; Now do case conversion
	Case_convert(string) -> string;

	;;; Return the translated string
	Clawback(string);
	;;; ... and component indices, if requested
	if want_parse then
		(parse_drive, parse_dir, parse_name, parse_extn, parse_vers);
	endif;
enddefine;

define 4 dir dir_>< name;
	lvars dir, name;
	_CLAWBACK_SAVE;
	Unix_convert(dir) -> dir;
	Unix_convert(name) -> name;
	lvars dlen = datalength(dir), nlen = datalength(name);
	unless dlen == 0 then
		lvars _i = 1, _c = fast_subscrs(dlen, dir);
		consstring(#|
			if nlen fi_>= 2 and fast_subscrs(2, name) == `:` then
				;;; drop drive letter from name part
				3 -> _i; nlen fi_- 2 -> nlen;
				unless dlen fi_>= 2 and fast_subscrs(2, dir) == `:` then
					;;; ... but add it to resulting path
					Explode_substring(1, 2, name);
				endunless;
			endif;
			explode(dir);
			unless _c == `:` or _c == `\\`
			or nlen fi_> 0 and fast_subscrs(_i, name) == `\\`
			then
				`\\`;
			endunless;
			Explode_substring(_i, nlen, name);
		|#) -> name;
	endunless;
	Clawback(name);
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Jul 28 1998
		Changed to be a bit more intelligent about the expansion of /tmp
--- Robert Duncan, Jan 29 1997
		Modifications for UNICODE compilation
--- Robert Duncan, Jun 21 1996
		Changed sysfileok to parse UNC names such that the second subscript
		selects the share name
--- Robert John Duncan, Jan  8 1996
		Added Expand_file_pattern. Simplified Case_convert not to treat the
		drive name specially: whole pathname goes either to upper or lower
		case as requested.
 */
