/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.win32/src/sysobey.p
 > Purpose:			Execute a string as an O/S command
 > Author:			Robert John Duncan, May 17 1994 (see revisions)
 > Documentation:
 > Related Files:
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'

constant procedure (sys_create_process, sys_wait);

vars pop_status;

;;; -----------------------------------------------------------------------


section $-Sys => sysobey;

define sysobey(command);
	if isboolean(command) then
		;;; __________________may_do_term_output -- ignored
		((), command) -> (command, ());
	endif;
	if isinteger(command) then
		;;; Unix shell character -- ignored
		((), command) -> (command, ());
	endif;
	Check_string(command);
	lvars command_line = systranslate('COMSPEC') or 'cmd';
	unless datalength(command) == 0 then
		consstring(#|
			explode(command_line),
			explode(' /c '),
			explode(command);
		|#) -> command_line;
	endunless;
	lvars pid = sys_create_process(false, command_line, false, true);
	dlocal interrupt = identfn;	;;; ignore interrupt while waiting
	sys_wait(pid) -> (, pop_status);
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Jun  4 1996
		Now uses env. var COMSPEC to find the command interpreter, with NT
		'cmd' as the default if not set
 */
