/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.win32/src/syspipe.p
 > Purpose:			Create an anonymous pipe
 > Author:			Robert John Duncan, May 18 1994 (see revisions)
 > Documentation:	___REF * _____SYSIO
 > Related Files:
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'

constant procedure (Sys$-Io$-Cons_device);

;;; -----------------------------------------------------------------------


section $-Sys$-Io => syspipe;

define syspipe(org) -> (odev, idev);
	lvars org, odev, idev;
	dlvars _ihandle, _ohandle;
	if _zero(_extern pop_create_pipe(ident _ihandle, ident _ohandle)) then
		GET_LAST_ERROR;
		Syserr_mishap(0, 'FAILED TO CREATE PIPE');
	endif;
	Cons_device(dup('pipe_out'), 1, org, _ohandle, false) -> odev;
	Cons_device(dup('pipe_in'), 0, org, _ihandle, false) -> idev;
enddefine;

endsection;		/* $-Sys$-Io */

/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Jan  8 1996
		Passed extra argument (_overlapped) to Cons_device.
 */
