/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/src/systranslate.p
 > Purpose:			Translate environment variables (Win32)
 > Author:			Robert John Duncan, May 12 1994 (see revisions)
 > Documentation:	___REF * _______SYSUTIL
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'

weak constant procedure (
	sys_registry_value, Sys$-Expand_environment_strings, );

;;; -----------------------------------------------------------------------

section $-Sys => systranslate;

	;;; where to find env vars in the registry
lconstant ENVIRONMENT_KEY = 'Environment';

define lconstant Get_env_var(string) -> string;
	lvars string;
	Check_string(string);
	lvars _len = datalength(string);
	unless _len == 0 then
		lvars _c = fast_subscrs(1, string);
		if _c == `$` then
			;;; Unix-style: $____name
			substring(2, _len fi_- 1, string) -> string;
		elseif _c == `%` and _len fi_> 1 and fast_subscrs(_len, string) == `%`
		then
			;;; DOS-style: %____name%
			substring(2, _len fi_- 2, string) -> string;
		endif;
	endunless;
enddefine;

define systranslate(string) -> trans;
	lvars trans = false, flags = false;
	if isinteger(string) or string == false then
		;;; optional _____flags argument
		((), string) -> (string, flags);
	endif;
	Get_env_var(string) -> string;
	unless datalength(string) == 0 then
		lvars t_string = Tchars_in(string, wkstring1);
		lvars t_trans = wkstring2;
		lvars _n = _extern pop_get_environment_variable(t_string@V_TCHARS,
			t_trans@V_TCHARS, _:WKSTRING_LENGTH);
		if _n _gr _:WKSTRING_LENGTH then
			Get_tstring(_n _sub _1) -> t_trans;
			if _extern pop_get_environment_variable(t_string@V_BYTES,
				t_trans@V_TCHARS, _n) == _n _sub _1
			then
				Tchars_out(t_trans, _n _sub _1) -> trans;
			endif;
		elseif _nonzero(_n) then
			Tchars_out(t_trans, _n) -> trans;
		endif;
		if not(trans) and flags and testdef sys_registry_value then
			weakref sys_registry_value(ENVIRONMENT_KEY, string, flags) -> trans;
			if trans then
				;;; cache it for subsequent access
				trans -> systranslate(string);
			endif;
		endif;
	endunless;
enddefine;
;;;
define updaterof systranslate(trans, string);
	lvars flags = false;
	if isinteger(string) or string == false then
		;;; optional _____flags argument
		((), trans, string) -> (trans, string, flags);
	endif;
	Get_env_var(string) -> string;
	if datalength(string) == 0 then
		mishap(string, 1, 'NON-EMPTY STRING NEEDED');
	endif;
	lvars t_string = Tchars_in(string, wkstring1);
	lvars _value;
	if isstring(trans) then
		Tchars_in(
			if flags and flags &&/=_0 2:100 then
				;;; maintain consistency with what would be retrieved
				;;; from the registry (REG_EXPAND_SZ)
				Expand_environment_strings(trans)
			else
				trans
			endif,
			wkstring2)@V_TCHARS -> _value;
	elseif trans then
		;;; error
		Check_string(trans);
	else
		;;; unset
		_NULL -> _value;
	endif;
	if _zero(_extern pop_set_environment_variable(t_string@V_TCHARS, _value))
	then
		GET_LAST_ERROR;
		Syserr_mishap(trans, string, 2, 'FAILED TO SET ENVIRONMENT VARIABLE');
	endif;
	if flags and testdef sys_registry_value then
		trans -> weakref sys_registry_value(ENVIRONMENT_KEY, string, flags);
	endif;
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Jan 29 1997
		Modifications for UNICODE compilation
--- Robert Duncan, Jul 24 1996
		Extended to allow getting and setting of env vars in the registry
		by interpreting the optional _____flags argument.
		Moved out Exp*and_environment_strings (used elsewhere)
 */
