/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/src/win32_dir.p
 > Purpose:			The current directory
 > Author:			Robert John Duncan, Mar  1 1994 (see revisions)
 > Documentation:	___REF * _______SYSUTIL
 > Related Files:
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'

section $-Sys;

constant procedure ( Case_convert, Get_string, );

endsection;

;;; -----------------------------------------------------------------------

section $-Sys => popdirectory, current_directory;

protected vars
	popdirectory;

define active current_directory;
	_CLAWBACK_SAVE;
	lvars dir, t_dir = wkstring1;
	lvars _n = _extern pop_get_current_directory(t_dir@V_TCHARS,
		_:WKSTRING_LENGTH);
	if _zero(_n) then
		;;; error
		false -> dir;
	elseif _n _lt _:WKSTRING_LENGTH then
		;;; pathname fitted into wkstring; _n is the length
		unless t_dir!V_TCHARS[_n _sub _1] == _:`\\` then
			;;; add trailing \
			_:`\\` -> t_dir!V_TCHARS[_n];
			_n _add _1 -> _n;
		endunless;
		Tchars_out(t_dir, _n) -> dir;
	else
		;;; pathname too long: _n is the length+1, for the null byte
		Get_tstring(_n) -> t_dir;
		if _extern pop_get_current_directory(t_dir@V_TCHARS, _n) == _n _sub _1
		then
			if t_dir!V_TCHARS[_n _sub _2] == _:`\\` then
				;;; trailing \ already there: give one character back
				_n _sub _1 -> _n;
			else
				;;; add trailing \
				_:`\\` -> t_dir!V_TCHARS[_n _sub _1];
			endif;
			Tchars_out(t_dir, _n) -> dir;
		else
			;;; unexpected error
			false -> dir;
		endif;
	endif;
	if dir then
		Clawback(Case_convert(dir));
	else
		GET_LAST_ERROR;
		Syserr_mishap(0, 'CAN\'T GET CURRENT DIRECTORY');
	endif;
enddefine;
;;;
define updaterof active current_directory new_dir;
	sysfileok(new_dir) -> new_dir;
	if datalength(new_dir) == 0 then popdirectory -> new_dir endif;
	lvars t_dir = Tchars_in(new_dir, wkstring1);
	if _zero(_extern pop_set_current_directory(t_dir@V_TCHARS)) then
		GET_LAST_ERROR;
		Syserr_mishap(new_dir, 1, 'CAN\'T CHANGE DIRECTORY');
	endif;
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Jan 29 1997
		Modifications for UNICODE compilation
 */
