/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/src/win32defs.ph
 > Purpose:			Macro and type definitions for Win32 API
 > Author:			Robert John Duncan, May 11 1994 (see revisions)
 */


/**************************************************************************

WINDOWS DEFINITIONS
-------------------
There follows  a complete list of all the Win32 macros defined in
<windows.h> etc. which are used by Poplog; the Poplog versions have the
same names but prefixed with WIN32_. They are defined separately for each
system in 'win32macros.ph' included below; this file is generated by a C
program compiled and run on the target machine. This program can in turn be
generated automatically using the following procedure:

	define ved_generate;
		dlocal vedargument, vedautowrite = false;
		;;; create an empty C file
		if vedargument = nullstring then
			'win32macros.c' -> vedargument;
		elseif sys_fname_extn(vedargument) = nullstring then
			vedargument <> '.c' -> vedargument;
		endif;
		ved_ved();
		ved_clear();
		;;; copy in macro names
		nullstring -> vedargument;
		ved_ti();
		;;; strip pop comments
		'#@[\s\t@]@*;;;@?@*##-v' -> vedargument;
		ved_gs();
		;;; substitute macro names with C ``printf'' calls
		'#@[A-Z@]@[A-Z_@]@*#printf("\\\\tWIN32_@& = 16:%.8X,\\\\n", @&);#-v'
			-> vedargument;
		ved_gs();
		;;; add header lines
		vedtopfile();
		vedlineabove();
		lvars line;
		for line in [
			'#include <stddef.h>'
			'#include <stdlib.h>'
			'#include <stdio.h>'
			'#include <windows.h>'
			''
			'void main(int argc, char *argv[])'
			'{'
			'\tprintf("lconstant macro (\\n");'
			'\tprintf("\\tWIN32_MACROS_INCLUDED = true,\\n");'
		] do
			vedinsertstring(line);
			vedlinebelow();
		endfor;
		;;; add trailer lines
		vedendfile();
		vedlinebelow();
		lvars line;
		for line in [
			'\tprintf(");\\n");'
			'\texit(0);'
			'}'
		] do
			vedinsertstring(line);
			vedlinebelow();
		endfor;
		vedtopfile();
		vedcheck();
	enddefine;

To generate the C program, mark the following list of macro names and run
<ENTER> generate:

	CREATE_ALWAYS
	CREATE_NEW
	CREATE_NEW_CONSOLE
	DETACHED_PROCESS
	ERROR_ACCESS_DENIED
	ERROR_ALREADY_EXISTS
	ERROR_BROKEN_PIPE
	ERROR_DISK_FULL
	ERROR_FILE_EXISTS
	ERROR_FILE_NOT_FOUND
	ERROR_HANDLE_DISK_FULL
	ERROR_INVALID_DRIVE
	ERROR_INVALID_HANDLE
	ERROR_INVALID_NAME
	ERROR_LOCK_VIOLATION
	ERROR_NO_MORE_FILES
	ERROR_NOT_ENOUGH_QUOTA
	ERROR_PATH_NOT_FOUND
	ERROR_SHARING_VIOLATION
	ERROR_TOO_MANY_OPEN_FILES
	ERROR_WRITE_PROTECT
	FILE_ATTRIBUTE_ARCHIVE
	FILE_ATTRIBUTE_COMPRESSED
	FILE_ATTRIBUTE_DIRECTORY
	FILE_ATTRIBUTE_HIDDEN
	FILE_ATTRIBUTE_NORMAL
	FILE_ATTRIBUTE_READONLY
	FILE_ATTRIBUTE_SYSTEM
	FILE_ATTRIBUTE_TEMPORARY
	FILE_FLAG_NO_BUFFERING
	FILE_FLAG_OVERLAPPED
	FILE_SHARE_DELETE
	FILE_SHARE_READ
	FILE_SHARE_WRITE
	FILE_TYPE_CHAR
	FILE_TYPE_DISK
	FILE_TYPE_PIPE
	FILE_TYPE_UNKNOWN
	GENERIC_READ
	GENERIC_WRITE
	GW_CHILD
	INFINITE
	INVALID_HANDLE_VALUE
	MAX_PATH
	NO_ERROR
	OPEN_ALWAYS
	OPEN_EXISTING
	REG_DWORD
	REG_EXPAND_SZ
	REG_SZ
	STD_INPUT_HANDLE
	STD_OUTPUT_HANDLE
	STD_ERROR_HANDLE
	STILL_ACTIVE
	TRUNCATE_EXISTING
	WM_USER


**************************************************************************/

#_IF not(DEF WIN32_MACROS_INCLUDED)
#_INCLUDE 'win32macros.ph'
#_ENDIF

	;;; This one isn't defined anywhere: you're supposed to obtain it
	;;; dynamically for each different file system as needed. This value
	;;; is sufficient for NTFS and HPFS file systems.
lconstant macro (
	WIN32_MAX_FILE = 255,
);

	;;; Some useful abbreviations
lconstant macro (
	WIN32_FILE_SHARE_READ_WRITE =
		WIN32_FILE_SHARE_READ||WIN32_FILE_SHARE_WRITE,
	WIN32_GENERIC_READ_WRITE =
		WIN32_GENERIC_READ||WIN32_GENERIC_WRITE,
);

	;;; Basic typedefs mirroring those used by API functions
deftype
	BYTE	= byte,
	WORD	= short,
	DWORD	= word,
	PVOID	= word,
	PBYTE	= (BYTE),
	PWORD	= (WORD),
	PDWORD	= (DWORD),
	CHAR	= BYTE,
	WCHAR	= WORD
;

#_IF DEF WIN32_UNICODE
deftype TCHAR = WCHAR;
#_ELSE
deftype TCHAR = CHAR;
#_ENDIF


/**************************************************************************

POPLOG DEFINITIONS
------------------
Where indicated by [*] these are used for communication with C wrapper
functions defined in libpop.lib and must agree with the equivalent
definitions in $popexternlib/poplog.h.

**************************************************************************/

	;;; Pop Text string
struct TSTRING {
	TCHAR	V_TCHARS[];
};

	;;; Pop HANDLE
struct HANDLE
{	full	HND_PROPS,
			KEY;
>->	<word>	XP_PTR;
	full	HND_DATA,
			HND_ASTP;
	short	HND_FLAGS;
};

	;;; Pop device unit (a vector)
struct DEVUNIT_P
{
	DWORD	V_LENGTH;
	full	KEY,
>->			UNT_INPUT_TRAP;		;;; input waiting trap (or false)
};

	;;; Length of DEVUNIT_P vector
lconstant macro UNIT_P_LENGTH =
	[_pint(##(w)[_1|struct DEVUNIT_P] _sub (##V_WORDS _sub ##POPBASE))];

	;;; Non-pop device unit (a string)
struct DEVUNIT_N
{
	DWORD	V_LENGTH;
	full	KEY;
>->	DWORD	UNT_NDEVS,			;;; number of devices sharing this unit
			UNT_VOLUME_NUMBER,	;;; volume serial number
			UNT_INDEX_HI,		;;; high half of file index
			UNT_INDEX_LO,		;;; low half of file index
			UNT_TYPE,			;;; device type
			UNT_FLAGS;			;;; unit flags
};

	;;; Length of DEVUNIT_N string
lconstant macro UNIT_N_LENGTH =
	[_pint(##(b)[_1|struct DEVUNIT_N] _sub ##(b)[##V_WORDS _sub ##POPBASE|w])];

	;;; Device control block (a string) [*]
struct DEV_CONTROL_BLOCK
{
	DWORD	V_LENGTH;
	full	KEY;
>->	DWORD	DCB_HANDLE,			;;; open file handle
			DCB_FILE,			;;; file structure
			DCB_MODE;			;;; file mode (translations, etc.)
};

	;;; Length of DEV_CONTROL_BLOCK string
lconstant macro CTRL_BLK_LENGTH =
	[_pint(##(b)[_1|struct DEV_CONTROL_BLOCK] _sub ##(b)[##V_WORDS _sub ##POPBASE|w])];

	;;; File structure [*]
	;;; (other fields follow that we don't care about)
struct POP_FILE
{
	DWORD	PF_HANDLE,			;;; open file handle
			PF_FLAGS,			;;; status flags
			PF_ERROR;			;;; last error condition
	PVOID	PF_ENCODING;		;;; coding pair
};

	;;; Process information (a string) [*]
struct PROCESS_INFORMATION
{
	DWORD	V_LENGTH;
	full	KEY;
>->	DWORD	PI_PID,				;;; process ID
			PI_HPROCESS,		;;; process handle
			PI_HTHREAD,			;;; thread handle
			PI_HSTDIN,			;;; stdin handle
			PI_HSTDOUT,			;;; stdout handle
			PI_HSTDERR;			;;; stderr handle
};

	;;; Length of PROCESS_INFORMATION string
lconstant macro PROCINFO_LENGTH =
	[_pint(##(b)[_1|struct PROCESS_INFORMATION] _sub ##(b)[##V_WORDS _sub ##POPBASE|w])];


	;;; Macro definitions
lconstant macro (

	;;; size of a text string buffer
	WKSTRING_LENGTH			= WIN32_MAX_PATH+1,

	;;; HANDLE flags
	HNDF_CLOSED				= 16:01,	;;; handle is closed

	MAX_HANDLES				= 32,		;;; max. number to wait for, etc.

	;;; UNT_FLAGS flags
	M_UNT_IGNORE_WRITE_ERR	= 2:1e0,	;;; ignore write error on device

	;;; UNT_TYPE values [*]
	POP_FILE_TYPE_OTHER		= 16:00,	;;; unknown
	POP_FILE_TYPE_DISK		= 16:01,	;;; disk file
	POP_FILE_TYPE_CHAR		= 16:02,	;;; comms, printer, etc.
	POP_FILE_TYPE_PIPE		= 16:03,	;;; pipe
	POP_FILE_TYPE_CONSOLE	= 16:04,	;;; console

	;;; DCB_MODE flags [*]
	POP_FILE_MODE_TEXT		= 16:01,	;;; CR/NL mapping
	POP_FILE_MODE_LINE		= 16:02,	;;; stop input after NL
	POP_FILE_MODE_RAW		= 16:04,	;;; console in raw mode
	POP_FILE_MODE_16BIT		= 16:08,	;;; 16-bit (Unicode) output

	;;; PF_FLAGS flags [*]
	POP_FILE_INTERRUPT		= 16:10,	;;; operation interrupted
	POP_FILE_TIMEOUT		= 16:20,	;;; operation timed out
	POP_FILE_ERROR			= 16:40,	;;; error occurred

);


	;;; Set the error status from the last API call: this has to be
	;;; called explicitly where needed, because there's no standard
	;;; error return value which can be checked for by _call_sys
vars $- _syserror;

lconstant macro (
	GET_LAST_ERROR = [_extern pop_get_last_error() -> _syserror],
);

	;;; Frequently-used Win32-specific definitions
weak constant
	handle_key,
	procedure (
		ishandle,
		sys_async_handle,
		sys_check_handle,
		sys_close_handle,
		sys_cons_handle,
		sys_handle_auto_close,
		sys_handle_data,
		sys_handle_props,
		sys_test_handle,
		sys_wait_for_handle,
	)
;

section $-Sys;

weak constant
	wkstring1,
	wkstring2,
	wkstring3,
	procedure (
		Get_string,
		Get_string16,
		Tchars_in,
		Tchars_out,
	)
;

endsection;		/* $-Sys */

#_IF DEF WIN32_UNICODE
lconstant macro (
	Get_tstring = "Get_string16",
);
#_ELSE
lconstant macro (
	Get_tstring = "Get_string",
);
#_ENDIF


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Jun 10 1997
		Added various file flags and attributes
--- Robert Duncan, May 22 1997
		Added UNT_FLAGS to DEVUNIT_N and M_UNT_* flag values
--- Robert Duncan, Feb 27 1997
		Changes to support device encoding
--- Robert Duncan, Jan 29 1997
		Added definitions for UNICODE compilation
--- Robert Duncan, Jul 24 1996
		Added registry types
--- Robert Duncan, May 24 1996
		Added new HANDLE structure and declarations of related procedures.
		Modified PROCESS_INFORMATION structure for its revised usage.
--- Robert Duncan, May 14 1996
		Added extra macro definitions
--- Robert John Duncan, Jan  8 1996
		Changes for new I/O interface.
 */
