/* --- Copyright University of Sussex 1998. All rights reserved. ----------
 > File:			C.win32/src/win32extern.p
 > Purpose:			External load
 > Author:			Robert John Duncan, May 23 1994 (see revisions)
 > Documentation:
 > Related Files:
 */


#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'
#_INCLUDE 'external.ph'

section $-Sys$-Extern;

constant
		procedure (Shlib_open, Shlib_close, Shlib_findsym, Name_translate,
		Get_symbol_ptr)
	;

endsection;

vars poppid;

;;; -----------------------------------------------------------------------

section $-Sys$-Extern;

lconstant macro (
	LINK_DLLS		= 1,
	LINK_HANDLES	= 2,
	LINK_SYMBOLS	= 3,
	LINK_VALUES		= 4,
		;;; vector subscripts for items in the link stack
	LINK_VEC_LEN	= 4,
		;;; length of a link item
);

lvars
	link_stack = [],
		;;; stack of items describing each external load
;


define Restore_symtab(symfile, save_dev);
	lvars symfile, save_dev;
	;;; this should never be called
	mishap(0, 'SYSTEM ERROR DOING Restore_symtab');
enddefine;

define Get_link_base();
	false;
enddefine;

define Temp_name();
	(systranslate('TEMP') or './') dir_>< ('PXT' sys_>< poppid sys_>< '.');
enddefine;

	/*	Construct a list of DLLs to be loaded
	*/
define lconstant Process_objfiles(objfiles);
	lvars name, objfiles;
	[%	for name in objfiles do
			if isword(name) then
				name!W_STRING <> SHLIB_EXTN -> name
			else
				Check_string(name);
			endif;
			name;
		endfor;
	%];
enddefine;

	/*	Open some DLLs and return a vector of handles
	*/
define lconstant Open_DLLs(names);
	lvars name, names;
	{%	for name in names do
			sysfileok(name) -> name;
			lvars handle = Shlib_open(name, false);
			if handle then handle endif
		endfor;
	%};
enddefine;

	/*	Close a set of DLLs
	*/
define lconstant Close_DLLs(handles);
	lvars i, handles;
	fast_for i to datalength(handles) do
		Shlib_close(fast_subscrv(i, handles))
	endfor;
enddefine;

	/*	Transform symbol names according to O/S and language conventions
	*/
define lconstant Convert_symbols(symbol_list);
	lvars spec, lang, symbol_list;
	fast_for spec in symbol_list do
		;;; ____spec is a vector where ____spec(1) is the symbol name as a word or
		;;; string, and ____spec(2) is a language name string (or a pair
		;;; conspair(_________lang-name, ____type), where ____type is used only by Popc).
		;;; If symbol name is a string, take it as is, otherwise do standard
		;;; O/S conversion on it, taking language name into account.
		Name_translate(spec(1),
						ispair(spec(2)->>lang) and fast_front(lang) or lang,
						false) -> spec(1);
	endfor;
enddefine;

	/*	Get symbol values from a set of open DLLs
	*/
define lconstant Get_symbols(handles, symbols, values) -> success;
	lvars symbol, value, handles, symbols, values, success = true;
	fast_for symbol, value in symbols, values do
		unless Shlib_findsym(handles, false, symbol, value) then
			false -> success;
		endunless;
	endfor;
enddefine;

	/*	Open the DLLs and load the symbols for a _________link_item
	*/
define lconstant Link_load(link_item);
	lvars link_item;
	lvars handles = Open_DLLs(link_item(LINK_DLLS));
	unless Get_symbols(handles, link_item(LINK_SYMBOLS), link_item(LINK_VALUES))
	then
		Close_DLLs(handles);
		mishap(0, 'ERRORS ACCESSING EXTERNAL SYMBOLS (see above)');
	endunless;
	handles -> link_item(LINK_HANDLES);
enddefine;

	/*	Do a single user external load.
		The symbol specs are updated with external pointer values.
	*/
define Do_link_load(objfiles, symbol_list, dummy, linkfile);
	lvars objfiles, symbol_list, dummy, linkfile;
	lvars link_item = writeable initv(LINK_VEC_LEN);
	lvars spec, value;

	;;; Get list of DLLs
	Process_objfiles(objfiles) -> link_item(LINK_DLLS);

	;;; Convert symbol names
	Convert_symbols(symbol_list);
	[%	fast_for spec in symbol_list do
			spec(1);
		endfor;
	%] -> link_item(LINK_SYMBOLS);

	;;; Create external pointer for each symbol value
	[%	fast_for spec in symbol_list do
			Get_symbol_ptr(spec)	;;; assigns ptr into spec as well
		endfor;
	%] -> link_item(LINK_VALUES);

	Link_load(link_item);

	;;; Add external load record to the history list
	link_item :: link_stack -> link_stack;
enddefine;

	/*	Redo all external loads required by a saved image.
	*/
define Redo_link_loads(dummy);
	lvars dummy, link_item, link_items = link_stack;
	[] -> link_stack;
	repeat #| dl(link_items) |# times
		-> link_item;
		Link_load(link_item);
		link_item :: link_stack -> link_stack;
	endrepeat;
	false;	;;; dummy
enddefine;

	/*	Remove the DLLs loaded by the last call to Do_link_load.
	*/
define Undo_link_load();
	lvars link_item;
	dest(link_stack) -> (link_item, link_stack);
	Close_DLLs(link_item(LINK_HANDLES));
enddefine;

	/*	Remove all DLLs mapped in to memory by Do_link_load
	*/
define Undo_link_loads();
	until link_stack == [] do
		Undo_link_load();
	enduntil;
enddefine;

endsection;		/* $-Sys$-Extern */


/* --- Revision History ---------------------------------------------------
--- John Gibson, Jun 16 1998
		Fixed bug in Convert_symbols (not passing language name correctly)
--- John Gibson, Feb 27 1997
		Shared library stuff to extern_symbols.p and external.ph.
--- Robert Duncan, Jan 29 1997
		Modifications for UNICODE compilation
--- John Gibson, Aug 16 1996
		Removed Do_p*opc_load.
--- John Gibson, May 28 1996
		Changed to use Get_symbol_ptr to get the external pointer for each
		symbol.
--- John Gibson, Apr 13 1996
		Replaced use of sysio*message with %M in printf
 */
