/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.win32/src/win32handle.p
 > Purpose:			Interface to the Windows HANDLE datatype
 > Author:			Robert Duncan, May 17 1996
 > Documentation:
 > Related Files:
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'
#_INCLUDE 'gctypes.ph'

constant
	sys_destroy_action,
	procedure ( appproperty, isproperty, clearproperty, destlist,
		sys_raise_ast, );

section $-Sys;

constant procedure ( Check_astp_arg, Checkr_exptrclass, Extern_ptr_hash,
		Eq__Extern_ptr, );

endsection;

;;; -----------------------------------------------------------------------

section $-Sys =>
		handle_key,
		ishandle,
		sys_async_handle,
		sys_check_handle,
		sys_close_handle,
		sys_cons_handle,
		sys_handle_auto_close,
		sys_handle_data,
		sys_handle_props,
		sys_test_handle,
		sys_wait_for_handle,
	;


define lconstant HandleCache =
	newanyproperty([], 32, 1, 25, Extern_ptr_hash, Eq__Extern_ptr, "tmpval",
		false, false);
enddefine;

lvars procedure HandleAutoClose;
	;;; destroy property, can't be created statically

define ishandle(item);
	iscompound(item) and item!KEY == handle_key;
enddefine;

define sys_test_handle(item, type, checkopen);
	unless iscompound(item) and item!KEY == handle_key then
		false;
	elseif type and recursive_front(item!HND_PROPS) /== type then
		false;
	elseif checkopen and item!HND_FLAGS _bitst _:HNDF_CLOSED then
		false;
	else
		true;
	endunless;
enddefine;

define sys_check_handle(item, type, checkopen);
	unless iscompound(item) and item!KEY == handle_key then
		mishap(item, 1, 'HANDLE NEEDED');
	elseif type and recursive_front(item!HND_PROPS) /== type then
		mishap(type, item, 2, '%%P HANDLE NEEDED');
	endunless;
	returnunless(checkopen);
	if item!HND_FLAGS _bitst _:HNDF_CLOSED then
		mishap(item, 1, 'ATTEMPT TO USE CLOSED HANDLE');
	endif;
enddefine;

define sys_handle_props(hnd);
	sys_check_handle(hnd, false, false);
	hnd!HND_PROPS;
enddefine;
;;;
define updaterof sys_handle_props(props, hnd);
	sys_check_handle(hnd, false, false);
	props -> hnd!HND_PROPS;
enddefine;

define sys_handle_data(hnd);
	sys_check_handle(hnd, false, false);
	hnd!HND_DATA;
enddefine;
;;;
define updaterof sys_handle_data(data, hnd);
	sys_check_handle(hnd, false, false);
	data -> hnd!HND_DATA;
enddefine;

define sys_close_handle(hnd);
	sys_check_handle(hnd, false, false);
	unless hnd!HND_FLAGS _bitst _:HNDF_CLOSED then
		false -> sys_async_handle(hnd);
		if _zero(_extern pop_close_handle(hnd!XP_PTR)) then
			GET_LAST_ERROR;
			Syserr_mishap(hnd, 1, 'FAILED TO CLOSE HANDLE')
		endif;
		hnd!HND_FLAGS _biset _:HNDF_CLOSED -> hnd!HND_FLAGS;
	endunless;
	;;; flush it from the cache because, if all handles to this object
	;;; have now been closed, the handle could possibly be re-used for
	;;; something else (?)
	false -> HandleCache(hnd);
enddefine;

define sys_handle_auto_close(hnd);
	sys_check_handle(hnd, false, false);
	returnunless(isproperty(HandleAutoClose))(false);
	lvars auto_close = HandleAutoClose(hnd);
	auto_close == sys_close_handle and true or auto_close;
enddefine;
;;;
define updaterof sys_handle_auto_close(auto_close, hnd);
	sys_check_handle(hnd, false, true);
	if auto_close == false then
		returnunless(isproperty(HandleAutoClose));
	elseif auto_close == true then
		sys_close_handle -> auto_close;
	else
		Check_procedure(auto_close);
	endif;
	unless isproperty(HandleAutoClose) then
		copy(sys_destroy_action) -> HandleAutoClose;
		clearproperty(HandleAutoClose);
	endunless;
	auto_close -> HandleAutoClose(hnd);
enddefine;

define sys_cons_handle(exptr, props, data, auto_close) -> hnd;
	Checkr_exptrclass(exptr) -> ;
	if (HandleCache(exptr) ->> hnd)
	and not(hnd!HND_FLAGS _bitst _:HNDF_CLOSED)	;;; shouldn't happen
	then
		if props and hnd!HND_PROPS and props /== hnd!HND_PROPS
		or data and hnd!HND_DATA and data /== hnd!HND_DATA
		then
			mishap(exptr, props, data, 3, 'HANDLE ALREADY EXISTS');
		endif;
		if props and not(hnd!HND_PROPS) then props -> hnd!HND_PROPS endif;
		if data and not(hnd!HND_DATA) then data -> hnd!HND_DATA endif;
	else
		Get_store(@@(struct HANDLE)++) -> hnd;
		handle_key -> hnd!KEY;
		props -> hnd!HND_PROPS;
		data -> hnd!HND_DATA;
		false -> hnd!HND_ASTP;
		_0 -> hnd!HND_FLAGS;
		exptr!XP_PTR -> hnd!XP_PTR;
		hnd -> HandleCache(Cons_extern_ptr(exptr!XP_PTR));
		auto_close -> sys_handle_auto_close(hnd);
	endif;
enddefine;

define lconstant Handle_print(hnd);
	cucharout(`<`);
	lvars props = hnd!HND_PROPS, type = recursive_front(props);
	if isword(type) and pop_pr_level /== 0 then
		Print_str(type!W_STRING), cucharout(`\s`);
	endif;
	Print_str('HANDLE');
	if ispair(props) and pop_pr_level /== 0 then
		while ispair(fast_back(props) ->> props) do
			cucharout(`\s`), pr(fast_front(props));
		endwhile;
		if props and props /== [] then
			cucharout(`\s`), pr(props);
		endif;
	endif;
	cucharout(`>`);
enddefine;

global constant
	handle_key = struct KEY_R_NAFULL =>> {%
		_NULL,                  ;;; K_GC_RELOC
		key_key,                ;;; KEY
		_:M_K_SPECIAL_RECORD	;;; K_FLAGS
			_biset _:M_K_WRITEABLE
			_biset _:M_K_EXTERN_PTR
			_biset _:M_K_EXTERN_PTR_PROPS,
		_:GCTYPE_NFULLREC,      ;;; K_GC_TYPE
		Record_getsize,			;;; K_GET_SIZE

		"handle",        		;;; K_DATAWORD
		false,                  ;;; K_SPEC
		ishandle,        		;;; K_RECOGNISER
		WREF Exec_nonpd,		;;; K_APPLY
		nonop ==,				;;; K_SYS_EQUALS
		WREF nonop ==,			;;; K_EQUALS
		Handle_print,    		;;; K_SYS_PRINT
		WREF Handle_print,  	;;; K_PRINT
		WREF Extern_ptr_hash,	;;; K_HASH

		_:NUMTYPE_NON_NUMBER,   ;;; K_NUMBER_TYPE
		_:PROLOG_TYPE_OTHER,    ;;; K_PLOG_TYPE
		_:EXTERN_TYPE_DEREF,    ;;; K_EXTERN_TYPE
		_0,                     ;;; K_SPARE_BYTE

		@@(struct HANDLE)++,	;;; K_RECSIZE_R
		false,                  ;;; K_CONS_R
		false,                  ;;; K_DEST_R
		false,                  ;;; K_ACCESS_R

		@@(int)[_3],			;;; K_FULL_OFFS_SIZE
		=>> {%					;;; K_FULL_OFFS_TAB[_3]
				@@HND_PROPS,
				@@HND_DATA,
				@@HND_ASTP,
			%},
		%};


define Check_handles(hnd, type, _checkopen) -> _count;
	if ishandle(hnd) then
		sys_check_handle(hnd, type, _checkopen);
		return(hnd, 1 -> _count);
	endif;
	;;; multiple handles
	if isinteger(hnd) then
		hnd -> _count;
		if _count fi_< 0 or stacklength() fi_< _count then
			;;; this will mishap with an appropriate message
			consvector(_count) ->
		endif;
	elseif isvector(hnd) then
		destvector(hnd) -> _count;
	else
		destlist(hnd) -> _count;
	endif;
	lvars _n = _int(_count);
	until _zero(_n) do
		_n _sub _1 -> _n;
		sys_check_handle(_user_sp()!(w)[_n], type, _checkopen);
	enduntil;
enddefine;

define Handle_wait(_count, _timeout);
	lconstant hndv = writeable initv(MAX_HANDLES);
	if _count fi_> MAX_HANDLES then
		mishap(0, 'TOO MANY HANDLES');
	endif;
	lvars _n;
	fast_for _n from _count by -1 to 1 do
		() -> fast_subscrv(_n, hndv);
	endfor;
	_int(_count) -> _count;
	if _timeout then
		_int(_timeout) -> _timeout;
		dlvars _msec = _extern pop_counter_start();
	else
		_:WIN32_INFINITE -> _timeout;
	endif;
	while _zero(_extern pop_wait_for_objects(_count, hndv, _timeout) ->> _n) do
		;;; 0 indicates AST
		_CHECKINTERRUPT;
		unless _timeout == _:WIN32_INFINITE then
			_timeout _sub _extern pop_counter_diff(ident _msec) -> _timeout;
			returnif(_timeout _lteq _0)(false);
		endunless;
	endwhile;
	if _neg(_n) then
		GET_LAST_ERROR;
		Syserr_mishap(0, 'FAILED TO WAIT FOR HANDLE(S)');
	elseif _n _lteq _count then
		fast_subscrv(_pint(_n), hndv);
	else
		;;; timeout
		false;
	endif;
enddefine;

define sys_wait_for_handle(hnd);
	;;; optional timeout
	lvars _timeout = false;
	if hnd == false then
		() -> hnd;
	elseif isintegral(hnd) then
		Check_integer(hnd, 0);
		((), hnd) -> (hnd, _timeout);
	endif;
	Handle_wait(Check_handles(hnd, false, true), _timeout);
enddefine;


;;; == ASYNCHRONOUS HANDLES ===============================================

define lconstant Make_astp(hnd, flag);
	lvars astp = hnd and hnd!HND_ASTP;
	returnunless(astp)(false);
	;;; traps are one-shot
	false -> hnd!HND_ASTP;
	;;; part-apply to handle and flag
	if ispair(astp) then fast_front(astp) else astp endif,
	consclosure((), hnd, flag, 2),
	if ispair(astp) then conspair((), fast_back(astp)) endif;
enddefine;

define lconstant Restore_async_handles();
	;;; this is called after an error in the async waiting thread has
	;;; caused all async handles to be cancelled; it goes through the
	;;; handle cache re-enabling traps for those which have them
	appproperty(
		HandleCache,
		procedure(_, hnd);
			lvars astp = hnd!HND_ASTP;
			if astp and _zero(_extern pop_add_async_object(hnd!XP_PTR)) then
				;;; probably this handle which caused the error; raise
				;;; the trap with second arg <true> meaning "cancelled"
				sys_raise_ast(Make_astp(hnd, true));
			endif;
		endprocedure);
enddefine;

define Get_handle_trap(_handle);
	if _zero(_handle) then
		;;; error case
		Restore_async_handles;
	else
		Make_astp(HandleCache(Cons_extern_ptr(_handle)), false);
	endif;
enddefine;

define sys_async_handle(hnd);
	sys_check_handle(hnd, false, false);
	hnd!HND_ASTP;
enddefine;
;;;
define updaterof sys_async_handle(astp, hnd);
	sys_check_handle(hnd, false, true);
	if astp then
		;;; setting
		Check_astp_arg(astp);
		if _zero(_extern pop_add_async_object(hnd!XP_PTR)) then
			mishap(hnd, 1, 'FAILED TO SET ASYNC HANDLE');
		else
			astp -> hnd!HND_ASTP;
		endif;
	else
		;;; cancelling
		_extern pop_rem_async_object(hnd!XP_PTR) -> ;
		false -> hnd!HND_ASTP;
	endif;
enddefine;

endsection;		/* $-Sys */
