/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/src/win32registry.p
 > Purpose:			Read and write values in the registry
 > Author:			Robert Duncan, Jul 23 1996 (see revisions)
 > Documentation:
 > Related Files:
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'

constant procedure ( $-Sys$-Expand_environment_strings, );

;;; -----------------------------------------------------------------------

section $-Sys =>
		sys_registry_value,
;

define lconstant Check_key_value(key, value) -> (key, value);
	if isword(value) then
		value!W_STRING -> value;
	else
		Check_string(value);
	endif;
	if isword(key) then
		key!W_STRING -> key;
	else
		Check_string(key);
	endif;
	;;; Allow for / instead of \\ in key path
	lvars _i;
	if locchar(`/`, 1, key) ->> _i then
		copy(key) -> key;
		repeat
			`\\` -> fast_subscrs(_i, key);
			quitunless(locchar(`/`, _i fi_+ 1, key) ->> _i);
		endrepeat;
	endif;
enddefine;

define sys_registry_value(key, value) -> data;
	lvars flags = 0;
	if isinteger(value) then
		;;; optional flags
		((), key, value && 2:11) -> (key, value, flags);
	endif;
	Check_key_value(key, value) -> (key, value);
	lvars t_key = Tchars_in(key, wkstring1);
	lvars t_value = Tchars_in(value, wkstring2);
	dlvars _type, _len = ##(b)[_:WKSTRING_LENGTH|TCHAR];
	lvars _res =
		_extern pop_get_registry_value(t_key@V_TCHARS, t_value@V_TCHARS,
			_int(flags), ident _type, wkstring3@V_TCHARS, ident _len);
	if _zero(_res) then
		false -> data;
	elseif _type == _:WIN32_REG_DWORD then
		Sint_->_pint(wkstring3!V_WORDS[_0]) -> data;
	elseif _type == _:WIN32_REG_SZ or _type == _:WIN32_REG_EXPAND_SZ then
		;;; _len will include 0 terminator
		Tchars_out(wkstring3, ##(TCHAR)[_len|b] _sub _1) -> data;
		if _type == _:WIN32_REG_EXPAND_SZ then
			Expand_environment_strings(data) -> data;
		endif;
	else
		;;; unknown type
		false -> data;
	endif;
enddefine;
;;;
define updaterof sys_registry_value(data, key, value);
	lvars flags = 0;
	if isinteger(value) then
		;;; optional flags
		((), data, key, value) -> (data, key, value, flags);
	endif;
	lvars save_key = key, save_value = value;
	Check_key_value(key, value) -> (key, value);
	Tchars_in(key, wkstring1) -> key;
	Tchars_in(value, wkstring2) -> value;
	unless data then
		lvars _res = _extern pop_delete_registry_value(key@V_TCHARS,
						value@V_TCHARS, _int(flags));
		if _zero(_res) then
			GET_LAST_ERROR;
			Syserr_mishap(save_key, save_value, 2,
				'FAILED TO DELETE REGISTRY VALUE');
		endif;
		return;
	endunless;
	lvars _type, _data, _len;
	if isinteger(data) then
		lstackmem DWORD _dword;
		_:WIN32_REG_DWORD -> _type;
		##(b)[_1|DWORD] -> _len;
		_int(data) -> _dword!(DWORD);
		_dword -> _data;
	elseif isstring(data) then
		flags &&/=_0 2:100 and _:WIN32_REG_EXPAND_SZ or _:WIN32_REG_SZ -> _type;
		data!V_LENGTH _add _1 -> _len;
		if _len _gr _:WKSTRING_LENGTH then
			;;; WKSTRING_LENGTH is the maximum we can read (see above),
			;;; so better make it the maximum for update too
			mishap(data, 1, 'STRING TOO LONG FOR REGISTRY DATA');
		endif;
		;;; length should be in bytes rather than characters
		##(b)[_len|TCHAR] -> _len;
		Tchars_in(data, wkstring3)@V_TCHARS -> _data;
	else
		mishap(data, 1, 'ILLEGAL VALUE FOR REGISTRY DATA');
	endif;
	lvars _res = _extern pop_set_registry_value(key@V_TCHARS, value@V_TCHARS,
					_int(flags && 2:11), _type, _data, _len);
	if _zero(_res) then
		GET_LAST_ERROR;
		Syserr_mishap(save_key, save_value, 2, 'FAILED TO SET REGISTRY VALUE');
	endif;
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Jan 29 1997
		Modifications for UNICODE compilation
 */
