/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/src/win32tchar.p
 > Purpose:			Win32: support for UNICODE APIs
 > Author:			Robert Duncan, Jan 24 1997 (see revisions)
 > Documentation:
 > Related Files:
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'


constant procedure ( $-Sys$-Get_string, );

;;; -----------------------------------------------------------------------

section $-Sys;

	;;; Computes the size in bytes of a TSTRING of length _nchars
	;;; allowing room for the terminating null character
define :inline lconstant _TSTRING_SIZE(_nchars);
	(@@(b)[_nchars|TCHAR] _add --@@(b)[_1|TCHAR])
enddefine;

constant
	wkstring1  = writeable inits(_pint(_TSTRING_SIZE(_:WKSTRING_LENGTH))),
	wkstring2  = writeable copy(wkstring1),
	wkstring3  = writeable copy(wkstring1),
;

define Tchars_in(string, wkstring) -> wkstring;
#_IF DEF WIN32_UNICODE
	if string!KEY!K_FLAGS _bitst _:M_K_STRING16 then
		string -> wkstring;
	else
		;;; widen to 16 bits
		lvars _nchars = string!V_LENGTH;
		if _nchars _gr _:WKSTRING_LENGTH then
			Get_string16(_nchars) -> wkstring;
		endif;
		lvars _index = ##V_BYTES;
		while _index _lt _nchars do
			string!(CHAR)[_index] -> wkstring!(WCHAR)[_index];
			_index _add _1 -> _index;
		endwhile;
		_0 -> wkstring!(WCHAR)[_nchars];
	endif;
#_ELSE
	if string!KEY!K_FLAGS _bitst _:M_K_STRING16 then
		;;; narrow to 8 bits
		lvars _nchars = string!V_LENGTH;
		if _nchars _gr _:WKSTRING_LENGTH then
			Get_string(_nchars) -> wkstring;
		endif;
		lvars _index = ##V_TCHARS;
		while _index _lt _nchars do
			lvars _char = wkstring!(WCHAR)[_index];
			if _char _gr _16:FF then _:`?` -> _char endif;
			_char -> string!(CHAR)[_index];
			_index _add _1 -> _index;
		endwhile;
		_0 -> wkstring!(CHAR)[_nchars];
	else
		string -> wkstring;
	endif;
#_ENDIF
enddefine;

define Tchars_out(wkstring, _nchars);
	consstring(#|
		lvars _index = ##V_TCHARS;
		while _index _lt _nchars do
			_CHECKUSER;
			_pint(wkstring!(TCHAR)[_index]);
			_index _add _1 -> _index;
		endwhile;
	|#);
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Feb 13 1997
		String16 changes
 */
