/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/win/lib/win_clipboard.p
 > Purpose:			Access to the Windows clipboard
 > Author:			Robert Duncan, Jul  3 1997
 */
compile_mode :pop11 +strict;

section;
exload_batch;

include win_types;

lconstant

	CF_TEXT			= 1,
	CF_DIB			= 8,
	CF_UNICODETEXT	= 13,

	GMEM_MOVEABLE	= 16:0002,
	GMEM_DDESHARE	= 16:2000,

	BI_RGB			= 0,
;

l_typespec
	RGBQUAD {
		rgbBlue			: BYTE,
		rgbGreen		: BYTE,
		rgbRed			: BYTE,
		rgbReserved		: BYTE,
	},
	BITMAPINFO {
		biSize			: DWORD,
		biWidth			: LONG,
		biHeight		: LONG,
		biPlanes		: WORD,
		biBitCount		: WORD,
		biCompression	: DWORD,
		biSizeImage		: DWORD,
		biXPelsPerMeter	: LONG,
		biYPelsPerMeter	: LONG,
		biClrUsed		: DWORD,
		biClrImportant	: DWORD,
		bmiColors		: RGBQUAD[],
	}
;

lvars
	platform_type		= "undef",
	clipboard_locked 	= false,
;

exload win_clipboard [user32 kernel32]
lconstant

	OpenClipboard(1) : BOOL,
	EmptyClipboard(0) : BOOL,
	CloseClipboard(0) : BOOL,
	GetClipboardData(1) : HANDLE,
	SetClipboardData(2) : HANDLE,
	IsClipboardFormatAvailable(1) : BOOL,

	GlobalAlloc(2) : exptr,
	GlobalFree(1) : exptr,
	GlobalLock(1) : exptr,
	GlobalUnlock(1) : BOOL,
	GlobalSize(1) : DWORD,

	lstrlenW(1) : int,

endexload;

define lconstant CheckSupportedFormat(format) -> suppFormat;
	define IsSupported =
		newproperty([
			[TEXT				^CF_TEXT]
			[DIB				^CF_DIB]
			[^CF_TEXT			^CF_TEXT]
			[^CF_UNICODETEXT	^CF_UNICODETEXT]
			[^CF_DIB			^CF_DIB]
		], 8, false, "perm");
	enddefine;
	unless IsSupported(format) ->> suppFormat then
		mishap(format, 1, 'Unsupported clipboard format');
	endunless;
enddefine;

define lconstant CanUseUnicodeText();
	;;; can use CF_UNICODETEXT only on Windows NT
	if platform_type == "undef" then
		win_version(initv(1))(1) -> platform_type;
	endif;
	platform_type == "WIN32_NT";
enddefine;

define lconstant DeleteCR(text) -> text;
	lvars d = 0, j = 0, i = 1, len = datalength(text);
	while (locchar(`\r`, j fi_+ 1, text) ->> j) and j fi_< len do
		if fast_subscrs(j fi_+ 1, text) == `\n` then
			unless d == 0 then
				move_subvector(i fi_+ d, text, i, text, j fi_- i fi_- d);
			endunless;
			j fi_- d -> i;
			d fi_+ 1 -> d;
		endif;
	endwhile;
	unless d == 0 then
		move_subvector(i fi_+ d, text, i, text, len fi_+ 1 fi_- i fi_- d);
		substring(1, len fi_- d, text) -> text;
	endunless;
enddefine;

define lconstant InsertCR(text) -> text;
	lvars d = 0, j = 0;
	while locchar(`\n`, j fi_+ 1, text) ->> j do
		unless j fi_> 1 and fast_subscrs(j fi_- 1, text) == `\r` then
			d fi_+ 1 -> d;
		endunless;
	endwhile;
	returnif(d == 0);
	lvars len = datalength(text);
	lvars new_text = class_init(datakey(text))(len fi_+ d);
	lvars d = 0, j = 0, i = 1;
	while locchar(`\n`, j fi_+ 1, text) ->> j do
		unless j fi_> 1 and fast_subscrs(j fi_- 1, text) == `\r` then
			move_subvector(i, text, i fi_+ d, new_text, j fi_- i);
			`\r` -> fast_subscrs(j fi_+ d, new_text);
			j -> i;
			d fi_+ 1 -> d;
		endunless;
	endwhile;
	move_subvector(i, text, i fi_+ d, new_text ->> text, len fi_- i fi_+ 1);
enddefine;

define BitmapSize(bmp);
	l_typespec bmp : BITMAPINFO;
	lvars imgSize = exacc bmp.biSizeImage;
	if imgSize == 0 and exacc bmp.biCompression == BI_RGB then
		;;; work it out
		lvars bitsPerLine = exacc bmp.biBitCount * exacc bmp.biWidth;
		(((bitsPerLine + 31) div 32) * 4) * exacc bmp.biHeight -> imgSize;
	endif;
	lvars nClrs = exacc bmp.biClrUsed;
	if nClrs == 0 and exacc bmp.biBitCount <= 8 then
		;;; assume the maximum
		1 << exacc bmp.biBitCount -> nClrs;
	endif;
	exacc bmp.biSize + nClrs * SIZEOFTYPE(:RGBQUAD) + imgSize;
enddefine;

define lconstant CopyData(/*format,hnd*/) -> data with_nargs 2;
	lvars hnd, ptr;
	dlocal 0 %
		exacc GlobalLock(dup()) -> (hnd, ptr),
		exacc GlobalUnlock(hnd) ->
	%;
	lvars format = ();
	if format == CF_TEXT then
		exacc_ntstring(ptr) -> data;
		if data == termin then false -> data endif;
	elseif format == CF_UNICODETEXT then
		lvars n = exacc lstrlenW(ptr);
		inits16(n) -> data;
		move_bytes(1, ptr, 1, data, 2 fi_* n);
	elseif format == CF_DIB then
		lvars n = fi_min(exacc GlobalSize(hnd), BitmapSize(ptr));
		inits(n) -> data;
		move_bytes(1, ptr, 1, data, n);
	else
		false -> data;
	endif;
enddefine;
;;;
define updaterof CopyData(/*data,format,hnd*/) with_nargs 3;
	lvars hnd, ptr;
	dlocal 0 %
		exacc GlobalLock(dup()) -> (hnd, ptr),
		exacc GlobalUnlock(hnd) ->
	%;
	lvars (data, format) = ();
	if format == CF_TEXT then
		data -> exacc_ntstring(ptr);
	elseif format == CF_UNICODETEXT then
		lvars n = datalength(data);
		move_bytes(1, data, 1, ptr, 2 fi_* n);
		0 -> exacc :WCHAR[] ptr[n fi_+ 1];
	elseif format == CF_DIB then
		lvars n =
			if isstring(data) then
				datalength(data)
			else
				BitmapSize(data)
			endif;
		move_bytes(1, data, 1, ptr, n);
	endif;
enddefine;


/*
 *	Exported Identifiers
 */

vars win_clipboard_lock_ntries = 3;

define active win_clipboard_lock;
	clipboard_locked;
enddefine;
;;;
define updaterof win_clipboard_lock lock;
	if lock then
		unless clipboard_locked then
			lvars ntries = win_clipboard_lock_ntries;
			until ntries == 0 or exacc OpenClipboard(false) /== 0 do
				syssleep(1);
				if isinteger(ntries) then ntries fi_- 1 -> ntries endif;
			enduntil;
			if ntries == 0 then
				mishap(0, 'Failed to lock the clipboard');
			endif;
			true -> clipboard_locked;
		endunless;
	else
		if clipboard_locked then
			exacc CloseClipboard() -> ;
			false -> clipboard_locked;
		endif;
	endif;
enddefine;

define win_clipboard_data(format) -> data;
	lvars data = false;
	CheckSupportedFormat(format) -> format;
	dlocal win_clipboard_lock = true;
	if format == CF_TEXT and pop_sys_encoding
	and exacc IsClipboardFormatAvailable(CF_UNICODETEXT) /== 0
	then
		;;; avoid decoding overhead
		CF_UNICODETEXT -> format;
	endif;
	lvars hnd = exacc GetClipboardData(format);
	unless is_null_external_ptr(hnd) then
		CopyData(format, hnd) -> data;
	endunless;
enddefine;
;;;
define updaterof win_clipboard_data(data, format);
	CheckSupportedFormat(format) -> format;
	if format == CF_TEXT then
		if (pop_sys_encoding or isstring16(data)) and CanUseUnicodeText() then
			;;; avoid encoding overhead
			CF_UNICODETEXT -> format;
		endif;
	endif;
	lvars nbytes;
	if format == CF_TEXT then
		datalength(data) fi_+ 1 -> nbytes;
	elseif format == CF_UNICODETEXT then
		lvars n = datalength(data);
		unless isstring16(data) then
			;;; expand 8-bit --> 16-bit
			move_subvector(1, data, 1, inits16(n) ->> data, n);
		endunless;
		2 fi_* (n fi_+ 1) -> nbytes;
	elseif format == CF_DIB then
		if isstring(data) then
			datalength(data)
		else
			BitmapSize(data)
		endif -> nbytes;
	else
		mishap(0, 'Internal error (Impossible case in win_clipboard_data)');
	endif;
	;;; clipboard data must be copied to a global memory object
	lconstant GMEM_FLAGS = #_<GMEM_MOVEABLE||GMEM_DDESHARE>_#;
	lvars hnd;
	dlocal 0 %
		false -> hnd,
		if hnd and not(is_null_external_ptr(hnd)) then
			exacc GlobalFree(hnd) -> ;
		endif
	%;
	lvars hnd = exacc GlobalAlloc(GMEM_FLAGS, nbytes);
	if is_null_external_ptr(hnd) then
		mishap(0, 'Failed to allocate memory for clipboard data');
	endif;
	data -> CopyData(format, hnd);
	;;; put the data on the clipboard
	dlocal win_clipboard_lock = true;
	if exacc EmptyClipboard() == 0
	or is_null_external_ptr(exacc[nc] SetClipboardData(format, hnd))
	then
		mishap(0, 'Failed to set clipboard data');
	endif;
	;;; memory now belongs to the clipboard, so we mustn't free it
	false -> hnd;
enddefine;

define win_clipboard_text() -> text;
	if win_clipboard_data(CF_TEXT) ->> text then
		DeleteCR(text) -> text;
	endif;
enddefine;
;;;
define updaterof win_clipboard_text(text);
	InsertCR(text) -> win_clipboard_data(CF_TEXT);
enddefine;


constant win_clipboard = true;

endexload_batch;
endsection;		/* $- */
