/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/win/lib/win_shell.p
 > Purpose:			Windows Shell Functions
 > Author:			Robert Duncan, Nov  3 1997
 */
compile_mode :pop11 +strict;

section;
exload_batch;

include win_types;

;;; -----------------------------------------------------------------------


exload win_shell [shell32 kernel32]
	GetLastError() : DWORD,
	ShellExecuteExW(1) : BOOL,
endexload;

lconstant

	SEE_MASK_CLASSNAME		= 16:00000001,
	SEE_MASK_CLASSKEY		= 16:00000003,
	SEE_MASK_IDLIST			= 16:00000004,
	SEE_MASK_INVOKEIDLIST	= 16:0000000C,
	SEE_MASK_ICON			= 16:00000010,
	SEE_MASK_HOTKEY			= 16:00000020,
	SEE_MASK_NOCLOSEPROCESS	= 16:00000040,
	SEE_MASK_CONNECTNETDRV 	= 16:00000080,
	SEE_MASK_FLAG_DDEWAIT  	= 16:00000100,
	SEE_MASK_DOENVSUBST		= 16:00000200,
	SEE_MASK_FLAG_NO_UI		= 16:00000400,
	SEE_MASK_UNICODE		= 16:00004000,
	SEE_MASK_NO_CONSOLE		= 16:00008000,
	SEE_MASK_ASYNCOK		= 16:00100000,

	SW_SHOWNORMAL			= 1,

	ERROR_FILE_NOT_FOUND	= 2,
	ERROR_PATH_NOT_FOUND	= 3,
	ERROR_ACCESS_DENIED		= 5,
	ERROR_NOT_ENOUGH_MEMORY	= 8,
	ERROR_SHARING_VIOLATION	= 32,
	ERROR_NO_ASSOCIATION	= 1155,
	ERROR_DDE_FAIL			= 1156,
	ERROR_DLL_NOT_FOUND		= 1157,
	ERROR_CANCELLED			= 1223,

;

l_typespec
	SHELLEXECUTEINFO {
		seiSize			: DWORD,
		seiMask			: ULONG,
		seiHwnd			: HWND,
		seiVerb			: exptr,
		seiFile			: exptr,
		seiParameters	: exptr,
		seiDirectory	: exptr,
		seiShow			: int,
		seiInstApp		: exptr,
		seiIDList		: exptr,
		seiClass		: exptr,
		seiKeyClass		: HKEY,
		seiHotKey		: DWORD,
		seiIcon			: HANDLE,
		seiProcess		: HANDLE,
	}
;

define ErrorMessage(code) -> msg;
	define KnownError =
		newproperty([
			[^ERROR_FILE_NOT_FOUND		'FILE_NOT_FOUND']
			[^ERROR_PATH_NOT_FOUND		'PATH_NOT_FOUND']
			[^ERROR_ACCESS_DENIED		'ACCESS_DENIED']
			[^ERROR_NOT_ENOUGH_MEMORY	'NOT_ENOUGH_MEMORY']
			[^ERROR_SHARING_VIOLATION	'SHARING_VIOLATION']
			[^ERROR_NO_ASSOCIATION		'NO_ASSOCIATION']
			[^ERROR_DDE_FAIL			'DDE_FAIL']
			[^ERROR_DLL_NOT_FOUND		'DLL_NOT_FOUND']
			[^ERROR_CANCELLED			'CANCELLED']
		], 16, false, "perm");
	enddefine;
	unless KnownError(code) ->> msg then
		code >< nullstring -> msg;
	endunless;
enddefine;

define lconstant ShellExecute(file, verb) -> pid;
	lvars pid = false;
	;;; allocate SHELLEXECUTEINFO struct
	l_typespec sei :SHELLEXECUTEINFO;
	lvars sei = EXPTRINITSTR(:sei);
	lvars len = datalength(sei);
	set_bytes(0, 1, sei, len);
	len -> exacc sei.seiSize;
	;;; fill in parameters
	lconstant MASK = SEE_MASK_FLAG_NO_UI||SEE_MASK_FLAG_DDEWAIT||
						SEE_MASK_NOCLOSEPROCESS;
	define Fix(s) -> s;
		if not(isstring16(s)) then
			fill(init_fixed(deststring(s), string16_key)) -> s;
		elseif not(is_fixed(s)) then
			copy_fixed(s) -> s;
		endif;
		fill_external_ptr(s, consexternal_ptr()) -> s;
	enddefine;
	MASK -> exacc sei.seiMask;
	SW_SHOWNORMAL -> exacc sei.seiShow;
	Fix(verb) -> exacc sei.seiVerb;
	Fix(sysfileok(file)) -> exacc sei.seiFile;
	if exacc ShellExecuteExW(sei) == 0 then
		lvars err = exacc GetLastError();
		mishap(verb, ErrorMessage(err), file, 3,
			'%Failed to "%S" path (error: %S)');
	else
		;;; sadly, we can only return the handle, not the ID; this means
		;;; we can wait for it, but not terminate it safely
		lvars exptr = exacc sei.seiProcess;
		unless is_null_external_ptr(exptr) then
			sys_cons_handle(exptr, "PROCESS", false, true) -> pid;
		endunless;
	endif;
enddefine;

define win_shell_open(file) -> pid;
	ShellExecute(file, 'Open') -> pid;
enddefine;

define win_shell_print(file) -> pid;
	ShellExecute(file, 'Print') -> pid;
enddefine;

define win_shell_explore(file) -> pid;
	ShellExecute(file, 'Explore') -> pid;
enddefine;


;;; -----------------------------------------------------------------------

constant win_shell = true;

endexload_batch;
endsection;		/* $- */
