/* --- Copyright Integral Solutions Ltd 1997. All rights reserved. --------
 * File:			C.all/extern/unicode/euc_jp_tables.h
 * Purpose:			Conversion tables for EUC-JP
 * Author:			Todd Brye, NCR Corporation 1997 (see revisions)
 */

static const unsigned short
	enXX[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	setXX[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en00[] = {0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,/*0xA5*/0x5C,0x5D,0x5E,0x5F,0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,/*0xAF*/0x7E,0x7F,0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,0x3F,0xA2C2,0xA1F1,0xA1F2,0xA2F0,0x3F,0xA2C3,0xA1F8,0xA1AF,0xA2D9,0xA2D8,0x3F,0xA2CC,0x3F,0xA2DA,0xA2B4,0xA1EB,0xA1DE,0x3F,0x3F,0xA1AD,0x3F,0xA2F9,0x3F,0xA2B1,0x3F,0xA2D7,0x3F,0x3F,0x3F,0x3F,0xA2C4,0xAAA2,0xAAA1,0xAAA4,0xAAAA,0xAAA3,0xAAA9,0xA9A1,0xAAAE,0xAAB2,0xAAB1,0xAAB4,0xAAB3,0xAAC0,0xAABF,0xAAC2,0xAAC1,0x3F,0xAAD0,0xAAD2,0xAAD1,0xAAD4,0xAAD8,0xAAD3,0xA1DF,0xA9AC,0xAAE3,0xAAE2,0xAAE5,0xAAE4,0xAAF2,0xA9B0,0xA9CE,0xABA2,0xABA1,0xABA4,0xABAA,0xABA3,0xABA9,0xA9C1,0xABAE,0xABB2,0xABB1,0xABB4,0xABB3,0xABC0,0xABBF,0xABC2,0xABC1,0xA9C3,0xABD0,0xABD2,0xABD1,0xABD4,0xABD8,0xABD3,0xA1E0,0xA9CC,0xABE3,0xABE2,0xABE5,0xABE4,0xABF2,0xA9D0,0xABF3},
	set00[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xFF,3,1,1,3,0xFF,3,1,1,3,3,0xFF,1,0xFF,3,3,1,1,0xFF,0xFF,1,0xFF,1,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0xFF,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3},
	en01[] = {0xAAA7,0xABA7,0xAAA5,0xABA5,0xAAA8,0xABA8,0xAAAB,0xABAB,0xAAAC,0xABAC,0xAAAF,0xABAF,0xAAAD,0xABAD,0xAAB0,0xABB0,0xA9A2,0xA9C2,0xAAB7,0xABB7,0x3F,0x3F,0xAAB6,0xABB6,0xAAB8,0xABB8,0xAAB5,0xABB5,0xAABA,0xABBA,0xAABB,0xABBB,0xAABD,0xABBD,0xAABC,0x3F,0xAABE,0xABBE,0xA9A4,0xA9C4,0xAAC7,0xABC7,0xAAC5,0xABC5,0x3F,0x3F,0xAAC6,0xABC6,0xAAC4,0xA9C5,0xA9A6,0xA9C6,0xAAC8,0xABC8,0xAAC9,0xABC9,0xA9C7,0xAACA,0xABCA,0xAACC,0xABCC,0xAACB,0xABCB,0xA9A9,0xA9C9,0xA9A8,0xA9C8,0xAACD,0xABCD,0xAACF,0xABCF,0xAACE,0xABCE,0xA9CA,0xA9AB,0xA9CB,0xAAD7,0xABD7,0x3F,0x3F,0xAAD6,0xABD6,0xA9AD,0xA9CD,0xAAD9,0xABD9,0xAADB,0xABDB,0xAADA,0xABDA,0xAADC,0xABDC,0xAADD,0xABDD,0xAADF,0xABDF,0xAADE,0xABDE,0xAAE1,0xABE1,0xAAE0,0xABE0,0xA9AF,0xA9CF,0xAAEC,0xABEC,0xAAE9,0xABE9,0xAAE6,0xABE6,0xAAEB,0xABEB,0xAAE8,0xABE8,0xAAEA,0xABEA,0xAAF1,0xABF1,0xAAF4,0xABF4,0xAAF3,0xAAF5,0xABF5,0xAAF7,0xABF7,0xAAF6,0xABF6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xAAA6,0xABA6,0xAAC3,0xABC3,0xAAD5,0xABD5,0xAAE7,0xABE7,0xAAF0,0xABF0,0xAAED,0xABED,0xAAEF,0xABEF,0xAAEE,0xABEE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xABB9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set01[] = {3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0xFF,0xFF,3,3,3,3,3,3,3,3,3,3,3,3,3,0xFF,3,3,3,3,3,3,3,3,0xFF,0xFF,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0xFF,0xFF,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en02[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2B0,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2AF,0xA2B2,0xA2B6,0xA2B5,0x3F,0xA2B3,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set02[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,3,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en03[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2B8,0xA2B9,0xA6E1,0x3F,0xA6E2,0xA6E3,0xA6E4,0x3F,0xA6E7,0x3F,0xA6E9,0xA6EC,0xA6F6,0xA6A1,0xA6A2,0xA6A3,0xA6A4,0xA6A5,0xA6A6,0xA6A7,0xA6A8,0xA6A9,0xA6AA,0xA6AB,0xA6AC,0xA6AD,0xA6AE,0xA6AF,0xA6B0,0xA6B1,0x3F,0xA6B2,0xA6B3,0xA6B4,0xA6B5,0xA6B6,0xA6B7,0xA6B8,0xA6E5,0xA6EA,0xA6F1,0xA6F2,0xA6F3,0xA6F4,0xA6FB,0xA6C1,0xA6C2,0xA6C3,0xA6C4,0xA6C5,0xA6C6,0xA6C7,0xA6C8,0xA6C9,0xA6CA,0xA6CB,0xA6CC,0xA6CD,0xA6CE,0xA6CF,0xA6D0,0xA6D1,0xA6F8,0xA6D2,0xA6D3,0xA6D4,0xA6D5,0xA6D6,0xA6D7,0xA6D8,0xA6F5,0xA6FA,0xA6F7,0xA6F9,0xA6FC,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set03[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,3,0xFF,3,3,3,0xFF,3,0xFF,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xFF,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,1,1,1,1,1,1,3,3,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en04[] = {0x3F,0xA7A7,0xA7C2,0xA7C3,0xA7C4,0xA7C5,0xA7C6,0xA7C7,0xA7C8,0xA7C9,0xA7CA,0xA7CB,0xA7CC,0xA7CD,0xA7CE,0xA7CF,0xA7A1,0xA7A2,0xA7A3,0xA7A4,0xA7A5,0xA7A6,0xA7A8,0xA7A9,0xA7AA,0xA7AB,0xA7AC,0xA7AD,0xA7AE,0xA7AF,0xA7B0,0xA7B1,0xA7B2,0xA7B3,0xA7B4,0xA7B5,0xA7B6,0xA7B7,0xA7B8,0xA7B9,0xA7BA,0xA7BB,0xA7BC,0xA7BD,0xA7BE,0xA7BF,0xA7C0,0xA7C1,0xA7D1,0xA7D2,0xA7D3,0xA7D4,0xA7D5,0xA7D6,0xA7D8,0xA7D9,0xA7DA,0xA7DB,0xA7DC,0xA7DD,0xA7DE,0xA7DF,0xA7E0,0xA7E1,0xA7E2,0xA7E3,0xA7E4,0xA7E5,0xA7E6,0xA7E7,0xA7E8,0xA7E9,0xA7EA,0xA7EB,0xA7EC,0xA7ED,0xA7EE,0xA7EF,0xA7F0,0xA7F1,0x3F,0xA7D7,0xA7F2,0xA7F3,0xA7F4,0xA7F5,0xA7F6,0xA7F7,0xA7F8,0xA7F9,0xA7FA,0xA7FB,0xA7FC,0x3F,0xA7FD,0xA7FE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set04[] = {0xFF,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xFF,1,3,3,3,3,3,3,3,3,3,3,3,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en20[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA1BE,0x3F,0x3F,0x3F,0x3F,0xA1BD,0xA1C2,0x3F,0xA1C6,0xA1C7,0x3F,0x3F,0xA1C8,0xA1C9,0x3F,0x3F,0xA2F7,0xA2F8,0x3F,0x3F,0x3F,0xA1C5,0xA1C4,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2F3,0x3F,0xA1EC,0xA1ED,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2A8,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set20[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,1,1,0xFF,0xFF,1,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en21[] = {0x3F,0x3F,0x3F,0xA1EE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2F1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2DB,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2F2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2AB,0xA2AC,0xA2AA,0xA2AD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2CD,0x3F,0xA2CE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set21[] = {0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en22[] = {0xA2CF,0x3F,0xA2DF,0xA2D0,0x3F,0x3F,0x3F,0xA2E0,0xA2BA,0x3F,0x3F,0xA2BB,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA1DD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2E5,0x3F,0x3F,0xA2E7,0xA1E7,0x3F,0xA2DC,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2CA,0xA2CB,0xA2C1,0xA2C0,0xA2E9,0xA2EA,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA1E8,0xA2E8,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2E6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2E2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA1E2,0xA2E1,0x3F,0x3F,0x3F,0x3F,0xA1E5,0xA1E6,0x3F,0x3F,0xA2E3,0xA2E4,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2BE,0xA2BF,0x3F,0x3F,0xA2BC,0xA2BD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2DD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set22[] = {1,0xFF,1,1,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en23[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2DE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set23[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en25[] = {0xA8A1,0xA8AC,0xA8A2,0xA8AD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA8A3,0x3F,0x3F,0xA8AE,0xA8A4,0x3F,0x3F,0xA8AF,0xA8A6,0x3F,0x3F,0xA8B1,0xA8A5,0x3F,0x3F,0xA8B0,0xA8A7,0xA8BC,0x3F,0x3F,0xA8B7,0x3F,0x3F,0xA8B2,0xA8A9,0xA8BE,0x3F,0x3F,0xA8B9,0x3F,0x3F,0xA8B4,0xA8A8,0x3F,0x3F,0xA8B8,0xA8BD,0x3F,0x3F,0xA8B3,0xA8AA,0x3F,0x3F,0xA8BA,0xA8BF,0x3F,0x3F,0xA8B5,0xA8AB,0x3F,0x3F,0xA8BB,0x3F,0x3F,0xA8C0,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA8B6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2A3,0xA2A2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2A5,0xA2A4,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2A7,0xA2A6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2A1,0xA1FE,0x3F,0x3F,0x3F,0xA1FB,0x3F,0x3F,0xA1FD,0xA1FC,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2FE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set25[] = {1,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,1,0xFF,0xFF,1,1,0xFF,0xFF,1,1,0xFF,0xFF,1,1,1,0xFF,0xFF,1,0xFF,0xFF,1,1,1,0xFF,0xFF,1,0xFF,0xFF,1,1,0xFF,0xFF,1,1,0xFF,0xFF,1,1,0xFF,0xFF,1,1,0xFF,0xFF,1,1,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en26[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0xA1FA,0xA1F9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA1EA,0x3F,0xA1E9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA2F6,0x3F,0x3F,0xA2F5,0x3F,0xA2F4,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set26[] = {0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en30[] = {0xA1A1,0xA1A2,0xA1A3,0xA1B7,0x3F,0xA1B9,0xA1BA,0xA1BB,0xA1D2,0xA1D3,0xA1D4,0xA1D5,0xA1D6,0xA1D7,0xA1D8,0xA1D9,0xA1DA,0xA1DB,0xA2A9,0xA2AE,0xA1CC,0xA1CD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA1C1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA4A1,0xA4A2,0xA4A3,0xA4A4,0xA4A5,0xA4A6,0xA4A7,0xA4A8,0xA4A9,0xA4AA,0xA4AB,0xA4AC,0xA4AD,0xA4AE,0xA4AF,0xA4B0,0xA4B1,0xA4B2,0xA4B3,0xA4B4,0xA4B5,0xA4B6,0xA4B7,0xA4B8,0xA4B9,0xA4BA,0xA4BB,0xA4BC,0xA4BD,0xA4BE,0xA4BF,0xA4C0,0xA4C1,0xA4C2,0xA4C3,0xA4C4,0xA4C5,0xA4C6,0xA4C7,0xA4C8,0xA4C9,0xA4CA,0xA4CB,0xA4CC,0xA4CD,0xA4CE,0xA4CF,0xA4D0,0xA4D1,0xA4D2,0xA4D3,0xA4D4,0xA4D5,0xA4D6,0xA4D7,0xA4D8,0xA4D9,0xA4DA,0xA4DB,0xA4DC,0xA4DD,0xA4DE,0xA4DF,0xA4E0,0xA4E1,0xA4E2,0xA4E3,0xA4E4,0xA4E5,0xA4E6,0xA4E7,0xA4E8,0xA4E9,0xA4EA,0xA4EB,0xA4EC,0xA4ED,0xA4EE,0xA4EF,0xA4F0,0xA4F1,0xA4F2,0xA4F3,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA1AB,0xA1AC,0xA1B5,0xA1B6,0x3F,0x3F,0xA5A1,0xA5A2,0xA5A3,0xA5A4,0xA5A5,0xA5A6,0xA5A7,0xA5A8,0xA5A9,0xA5AA,0xA5AB,0xA5AC,0xA5AD,0xA5AE,0xA5AF,0xA5B0,0xA5B1,0xA5B2,0xA5B3,0xA5B4,0xA5B5,0xA5B6,0xA5B7,0xA5B8,0xA5B9,0xA5BA,0xA5BB,0xA5BC,0xA5BD,0xA5BE,0xA5BF,0xA5C0,0xA5C1,0xA5C2,0xA5C3,0xA5C4,0xA5C5,0xA5C6,0xA5C7,0xA5C8,0xA5C9,0xA5CA,0xA5CB,0xA5CC,0xA5CD,0xA5CE,0xA5CF,0xA5D0,0xA5D1,0xA5D2,0xA5D3,0xA5D4,0xA5D5,0xA5D6,0xA5D7,0xA5D8,0xA5D9,0xA5DA,0xA5DB,0xA5DC,0xA5DD,0xA5DE,0xA5DF,0xA5E0,0xA5E1,0xA5E2,0xA5E3,0xA5E4,0xA5E5,0xA5E6,0xA5E7,0xA5E8,0xA5E9,0xA5EA,0xA5EB,0xA5EC,0xA5ED,0xA5EE,0xA5EF,0xA5F0,0xA5F1,0xA5F2,0xA5F3,0xA5F4,0xA5F5,0xA5F6,0x3F,0x3F,0x3F,0x3F,0xA1A6,0xA1BC,0xA1B3,0xA1B4,0x3F},
	set30[] = {1,1,1,1,0xFF,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,1,0xFF,0xFF,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xFF,0xFF,0xFF,0xFF,1,1,1,1,0xFF},
	en4E[] = {0xB0EC,0xC3FA,0xB0A1,0xBCB7,0xB0A2,0xB0A3,0x3F,0xCBFC,0xBEE6,0xBBB0,0xBEE5,0xB2BC,0xB0A4,0xC9D4,0xCDBF,0x3F,0xD0A2,0xB1AF,0xB0A5,0x3F,0xB3EE,0xD0A3,0xC0A4,0xD2C2,0xB5D6,0xCABA,0x3F,0x3F,0x3F,0x3F,0xBEE7,0xB0A6,0x3F,0xCEBE,0x3F,0xB0A7,0xB0A8,0x3F,0xCAC2,0x3F,0xB0A9,0x3F,0xD0A4,0xB0AA,0x3F,0xC3E6,0xB0AB,0xB0AC,0xB0AD,0xD0A5,0xB6FA,0x3F,0x3F,0xB0AE,0xD0A6,0x3F,0xB4DD,0xC3B0,0x3F,0xBCE7,0xD0A7,0x3F,0x3F,0xD0A8,0xB0AF,0xB0B0,0xD0A9,0xC7B5,0xB0B1,0xB5D7,0x3F,0xB0B2,0x3F,0x3F,0x3F,0xC7B7,0x3F,0xC6E3,0xB8C3,0xCBB3,0x3F,0xB0B3,0x3F,0x3F,0x3F,0xE9C9,0xD0AA,0xBEE8,0xD0AB,0xB2B5,0xB0B4,0x3F,0xB0B5,0xB6E5,0xB8F0,0xCCE9,0x3F,0x3F,0xD6A6,0xB0B6,0x3F,0x3F,0x3F,0x3F,0xB0B7,0xB0B8,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCDF0,0x3F,0xC6FD,0xB0B9,0xB0BA,0x3F,0x3F,0x3F,0xB0BB,0x3F,0x3F,0x3F,0x3F,0xB4A5,0xB0BC,0xB5B5,0x3F,0xD0AC,0x3F,0x3F,0xD0AD,0xCEBB,0x3F,0xCDBD,0xC1E8,0xD0AF,0xBBF6,0xC6F3,0xB0BD,0xD0B2,0x3F,0x3F,0xB1BE,0xB8DF,0x3F,0xB8DE,0xB0E6,0xB0BE,0xB0BF,0xCFCB,0xCFCA,0x3F,0xBAB3,0xB0A1,0xB0C0,0xD0B3,0xD0B4,0xD0B5,0xCBB4,0xD0B6,0x3F,0xB8F2,0xB0E7,0xCBF2,0x3F,0xB5FC,0x3F,0x3F,0xB5FD,0xB5FE,0xC4E2,0xCEBC,0xB0C1,0xD0B7,0x3F,0x3F,0xD0B8,0x3F,0x3F,0xD0B9,0x3F,0x3F,0xB0C2,0xBFCD,0x3F,0x3F,0x3F,0x3F,0x3F,0xBDBA,0xBFCE,0xD0BE,0xB0C3,0xD0BC,0x3F,0xD0BD,0xB5D8,0x3F,0x3F,0xBAA3,0xB2F0,0x3F,0xD0BB,0xD0BA,0xCAA9,0xB0C4,0x3F,0x3F,0x3F,0xBBC6,0xBBC5,0xC2BE,0xD0BF,0xC9D5,0xC0E7,0xB0C5,0xB0C6,0x3F,0xA1B8,0xD0C0,0xD0C2,0xB0C7,0xB0C8,0xB0C9,0xC2E5,0xCEE1,0xB0CA,0x3F,0x3F,0xB0CA,0x3F,0x3F,0x3F,0x3F,0xD0C1,0xB2BE,0xB0CB,0xB6C4,0xB0CC,0xC3E7,0xB0CD,0x3F,0xB0CE,0xB7EF,0xD0C3,0x3F,0x3F,0x3F,0xC7A4,0x3F,0xB0CF,0xB0D0,0xB0D1},
	set4E[] = {1,1,3,1,3,3,0xFF,1,1,1,1,1,3,1,1,0xFF,1,1,3,0xFF,1,1,1,1,1,1,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,1,0xFF,3,3,0xFF,1,0xFF,3,0xFF,1,3,0xFF,1,3,3,3,1,1,0xFF,0xFF,3,1,0xFF,1,1,0xFF,1,1,0xFF,0xFF,1,3,3,1,1,3,1,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,1,1,1,0xFF,3,0xFF,0xFF,0xFF,1,1,1,1,1,3,0xFF,3,1,1,1,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,3,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,3,1,0xFF,1,0xFF,0xFF,1,1,0xFF,1,1,1,1,1,3,1,0xFF,0xFF,1,1,0xFF,1,1,3,3,1,1,0xFF,1,1,3,1,1,1,1,1,0xFF,1,1,1,0xFF,1,0xFF,0xFF,1,1,1,1,3,1,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,3,1,0xFF,1,1,0xFF,0xFF,1,1,0xFF,1,1,1,3,0xFF,0xFF,0xFF,1,1,1,1,1,1,3,3,0xFF,1,1,1,3,3,3,1,1,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,1,3,1,3,1,3,0xFF,3,1,1,0xFF,0xFF,0xFF,1,0xFF,3,3,3},
	en4F[] = {0xB0D2,0xB4EB,0xB0D3,0xB0D4,0x3F,0x3F,0x3F,0x3F,0xB0D5,0xD0C4,0xB0CB,0xB0D6,0xB0D7,0xB8E0,0xB4EC,0xC9FA,0xC8B2,0xB5D9,0xB0D8,0x3F,0x3F,0xB0D9,0xB0DA,0xB0DB,0x3F,0xB0DC,0xB2F1,0x3F,0xD0E7,0xC5C1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB0DD,0xC7EC,0xD0C6,0xB0DE,0x3F,0xB0E0,0xC8BC,0xB0E1,0xCEE2,0xB0E2,0xBFAD,0xB0E3,0xBBC7,0xB0E4,0xBBF7,0xB2C0,0xB0E5,0x3F,0xB0E6,0x3F,0xB0E7,0xC4D1,0x3F,0x3F,0xC3A2,0xD0CA,0xB0E8,0xB0E9,0x3F,0xB0EA,0xB0EB,0xB0CC,0xC4E3,0xBDBB,0xBAB4,0xCDA4,0xB0EC,0xC2CE,0xB0ED,0xB2BF,0xB0EE,0xD0C9,0xB0EF,0xCDBE,0xD0C5,0xD0C7,0xBAEE,0xD0C8,0xD5A4,0xB0F0,0xB0DF,0x3F,0x3F,0xB0F1,0x3F,0x3F,0x3F,0x3F,0x3F,0xD0D0,0xB0F2,0x3F,0xB0F3,0x3F,0xB0F4,0xD0D3,0xD0D1,0xB0F5,0x3F,0xB2C2,0x3F,0xCABB,0xD0CB,0xB0F6,0xB0F7,0xB0F8,0xB0F9,0xD0CF,0xB8F3,0xB0FA,0xB0FB,0xBBC8,0x3F,0xB0FC,0xB0FD,0xB4A6,0xB0FE,0xB1A1,0xD0D4,0x3F,0xD0CC,0xB1A2,0xB1A3,0xCEE3,0xB1A4,0xBBF8,0xB1A5,0xD0CD,0xB1A6,0xD0D2,0xB1A7,0xB1A8,0xB1A9,0x3F,0xD0D5,0xB1AA,0xD0CE,0xB1AB,0xB1AC,0xB6A1,0x3F,0xB0CD,0xB1AD,0xB1AE,0xB6A2,0xB2C1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD5A5,0x3F,0xCBF9,0xC9EE,0xB8F4,0x3F,0x3F,0xB1AF,0x3F,0x3F,0xBFAF,0xCEB7,0xB1B0,0x3F,0xB1B1,0x3F,0xB1B2,0xB1B3,0xB1B4,0xB1B5,0xCAD8,0xB1B6,0xB1B7,0xB7B8,0xC2A5,0xB2E4,0xB1B8,0xB1B9,0x3F,0xB1BA,0xB1BB,0xBDD3,0xB1BC,0xB1BD,0xB1BE,0xD0D9,0xB1BF,0xD0DE,0xD0DC,0xB1C0,0x3F,0xD0D7,0x3F,0x3F,0xC2AF,0xD0DA,0x3F,0xD0DD,0xD0DB,0xB1C1,0xCADD,0x3F,0xD0D8,0xB1C2,0xBFAE,0xB1C3,0xCBF3,0xD0DF,0xD0E0,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBDA4,0xD0ED,0xB1C4,0x3F,0xB1C5,0xC7D0,0x3F,0xC9B6,0xD0E8,0x3F,0xCAF0,0x3F,0xB2B6,0x3F,0xB1C6,0xB1C7,0xD0EC,0xB1C8},
	set4F[] = {3,1,3,3,0xFF,0xFF,0xFF,0xFF,3,1,1,3,3,1,1,1,1,1,3,0xFF,0xFF,3,3,3,0xFF,3,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,1,3,0xFF,3,1,3,1,3,1,3,1,3,1,1,3,0xFF,3,0xFF,3,1,0xFF,0xFF,1,1,3,3,0xFF,3,3,1,1,1,1,1,3,1,3,1,3,1,3,1,1,1,1,1,1,3,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,3,0xFF,3,1,1,3,0xFF,1,0xFF,1,1,3,3,3,3,1,1,3,3,1,0xFF,3,3,1,3,3,1,0xFF,1,3,3,1,3,1,3,1,3,1,3,3,3,0xFF,1,3,1,3,3,1,0xFF,1,3,3,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,1,1,0xFF,0xFF,3,0xFF,0xFF,1,1,3,0xFF,3,0xFF,3,3,3,3,1,3,3,1,1,1,3,3,0xFF,3,3,1,3,3,3,1,3,1,1,3,0xFF,1,0xFF,0xFF,1,1,0xFF,1,1,3,1,0xFF,1,3,1,3,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,3,0xFF,3,1,0xFF,1,1,0xFF,1,0xFF,1,0xFF,3,3,1,3},
	en50[] = {0xB1C9,0xB1CA,0x3F,0x3F,0xB1CB,0xD0E6,0xD0EF,0xB1CC,0x3F,0xC1D2,0xB1CD,0xB8C4,0xB1CE,0xC7DC,0xB1CF,0xE0C7,0xB1D0,0xD0EE,0xC5DD,0xB1D1,0xD0E3,0x3F,0xB8F6,0xB1D2,0xB1D3,0xB8F5,0xD0E1,0xB1D4,0xB1D5,0xB1D6,0xB1D7,0xBCDA,0x3F,0xD0E9,0xB1D8,0xCAEF,0xC3CD,0xD0E5,0xB7F1,0xB1D9,0xD0E2,0xD0EA,0xD0E4,0xCED1,0xD0EB,0xCFC1,0xB1DA,0x3F,0xB1DB,0x3F,0xB1DC,0xB1DD,0x3F,0xB1DE,0xB6E6,0x3F,0x3F,0xB7F0,0x3F,0xB1F6,0x3F,0x3F,0x3F,0x3F,0xB1DF,0xB1E0,0xB1E1,0xD0F0,0x3F,0xB1E2,0xB1E3,0xD0F1,0xD0F5,0xB0CE,0xB1E4,0x3F,0xB1E5,0x3F,0xB1E6,0xCAD0,0xD0F4,0xB1E7,0xB1E8,0xB1E9,0x3F,0xD0F3,0xD0F7,0xB1EA,0x3F,0xB1EB,0xD0F6,0x3F,0xC4E4,0x3F,0x3F,0xB1EC,0xB1ED,0x3F,0xB1EE,0xB1EF,0x3F,0xB7F2,0xB1F0,0xB1F1,0x3F,0x3F,0xB1F2,0x3F,0xD0F8,0xB1F3,0x3F,0x3F,0xB1F4,0xB1F5,0xBCC5,0x3F,0xC2A6,0xC4E5,0xB6F6,0x3F,0xD0F9,0x3F,0x3F,0x3F,0x3F,0xB5B6,0x3F,0x3F,0xD0FA,0xB1F7,0x3F,0xB1F8,0xB1F9,0xD0FC,0xB1FA,0x3F,0x3F,0x3F,0xB1FB,0x3F,0x3F,0xCBB5,0xB1FC,0xB1FD,0xB1FE,0xB7E6,0xB2A1,0xB2A2,0xB2A3,0x3F,0xB2A4,0x3F,0xBBB1,0xC8F7,0xD0FB,0xB2A5,0xB2A6,0x3F,0xB2A7,0xB2A8,0xB2A9,0xB2AA,0xB2AB,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB2AC,0x3F,0xBAC5,0xCDC3,0x3F,0xB2AD,0xB2AE,0x3F,0xD0FE,0xD1A3,0xD0FD,0xBAC4,0x3F,0xBDFD,0x3F,0xB2AF,0xB2B0,0x3F,0x3F,0xB2B1,0xB7B9,0x3F,0xB2B2,0x3F,0xD1A4,0xB2B3,0xB2B4,0xB6CF,0x3F,0xB2B5,0x3F,0xD1A1,0xD1A2,0x3F,0xB2B6,0xC6AF,0xB2B7,0xC1FC,0xB2B8,0xB6A3,0x3F,0xB2B9,0xB2BA,0xCBCD,0xD1A5,0x3F,0xB2BB,0x3F,0xCEBD,0x3F,0xB2BC,0xB2BD,0xD1A6,0xB2BE,0x3F,0x3F,0xB2BF,0xD1A9,0xB2C0,0xD1A7,0xB2C1,0xC1CE,0xB2C2,0xB2C3,0x3F,0x3F,0x3F,0xD1A8,0xD1AA,0xB2C4,0x3F,0xB2C5,0xB2D1,0x3F,0x3F,0xD1AC,0xB2C6,0x3F,0x3F,0xD1AB,0xB2C7,0xCAC8,0x3F,0x3F,0xB2C8,0x3F},
	set50[] = {3,3,0xFF,0xFF,3,1,1,3,0xFF,1,3,1,3,1,3,1,3,1,1,3,1,0xFF,1,3,3,1,1,3,3,3,3,1,0xFF,1,3,1,1,1,1,3,1,1,1,1,1,1,3,0xFF,3,0xFF,3,3,0xFF,3,1,0xFF,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,3,3,1,0xFF,3,3,1,1,1,3,0xFF,3,0xFF,3,1,1,3,3,3,0xFF,1,1,3,0xFF,3,1,0xFF,1,0xFF,0xFF,3,3,0xFF,3,3,0xFF,1,3,3,0xFF,0xFF,3,0xFF,1,3,0xFF,0xFF,3,3,1,0xFF,1,1,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,3,0xFF,3,3,1,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,3,3,3,1,3,3,3,0xFF,3,0xFF,1,1,1,3,3,0xFF,3,3,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,1,0xFF,3,3,0xFF,1,1,1,1,0xFF,1,0xFF,3,3,0xFF,0xFF,3,1,0xFF,3,0xFF,1,3,3,1,0xFF,3,0xFF,1,1,0xFF,3,1,3,1,3,1,0xFF,3,3,1,1,0xFF,3,0xFF,1,0xFF,3,3,1,3,0xFF,0xFF,3,1,3,1,3,1,3,3,0xFF,0xFF,0xFF,1,1,3,0xFF,3,3,0xFF,0xFF,1,3,0xFF,0xFF,1,3,1,0xFF,0xFF,3,0xFF},
	en51[] = {0xB5B7,0xD1AE,0xD1AF,0xB2C9,0xB2AF,0x3F,0xB2CA,0xB2CB,0xB2CC,0xD1AD,0x3F,0xB2CD,0xB2CE,0xB2CF,0xB2D0,0x3F,0xB2D2,0x3F,0xBCF4,0x3F,0xD1B2,0xD1B1,0xD1B0,0xB2D3,0xD0D6,0xB2D4,0xD1B3,0xB2D5,0xB2D6,0xB2D7,0xB2D8,0xBDFE,0x3F,0xD1B4,0x3F,0xB2D9,0x3F,0x3F,0x3F,0xB2DA,0xB2DB,0x3F,0xCDA5,0x3F,0xB2DC,0xB2DD,0x3F,0xB2DE,0x3F,0xB2DF,0xCCD9,0xB2E0,0xB2E1,0xB2E2,0x3F,0xD1B6,0xB2E3,0xB2E4,0xD1B5,0xD1B8,0xD1B7,0x3F,0x3F,0xD1B9,0xD1BA,0xB0F4,0xB2E5,0xB8B5,0xB7BB,0xBDBC,0xC3FB,0xB6A4,0xC0E8,0xB8F7,0xB2E6,0xB9EE,0xD1BC,0xCCC8,0xC5C6,0xB2E7,0xBBF9,0x3F,0xD1BB,0xB2E8,0xD1BD,0xB2E9,0x3F,0xB2EA,0xB2EB,0x3F,0xC5DE,0x3F,0xB3F5,0x3F,0x3F,0xB2EC,0x3F,0x3F,0xD1BE,0x3F,0xB2ED,0xC6FE,0xB2EE,0x3F,0xC1B4,0xD1C0,0xD1C1,0xC8AC,0xB8F8,0xCFBB,0xD1C2,0x3F,0x3F,0xB6A6,0x3F,0x3F,0x3F,0xCABC,0xC2B6,0xB6F1,0xC5B5,0x3F,0x3F,0x3F,0xB7F3,0x3F,0xB2EF,0x3F,0xD1C3,0x3F,0xD1C4,0xB2F0,0xB2F1,0xC6E2,0xB1DF,0x3F,0x3F,0xD1C7,0xBAFD,0xB2F2,0xD1C6,0xBAC6,0xB2F3,0xD1C8,0xE6EE,0xD1C9,0xCBC1,0xD1CA,0x3F,0xD1CB,0xD1CC,0xBEE9,0xB2F4,0xBCCC,0x3F,0x3F,0x3F,0xB2F5,0x3F,0x3F,0xB4A7,0xB2F6,0xD1CF,0xB2F7,0xD1CD,0xCCBD,0xD1CE,0x3F,0xC9DA,0xD1D0,0xD1D1,0xD1D2,0xC5DF,0xB2F8,0x3F,0x3F,0xD1D6,0xD1D4,0xD1D5,0xD1D3,0xBAE3,0xD1D7,0xCCEA,0xCEE4,0xB2F9,0x3F,0xB2FA,0x3F,0xB2FB,0xD1D8,0xB2FC,0xB2FD,0x3F,0x3F,0xB2FE,0x3F,0xC0A8,0xD1D9,0xBDDA,0x3F,0xB3A1,0xD1DA,0x3F,0xC3FC,0xCEBF,0xC5E0,0x3F,0xB3A2,0x3F,0xB3A3,0xB3A4,0xB3A5,0x3F,0xB3A6,0xD2C5,0x3F,0xB3A7,0x3F,0x3F,0xD1DB,0xF4A5,0xB6C5,0xB3A8,0x3F,0xD1DC,0xCBDE,0xB3A9,0x3F,0x3F,0xB3AA,0xBDE8,0xC2FC,0x3F,0xD1DE,0xC6E4,0x3F,0x3F,0xD1DF,0xB3AB,0x3F,0xD1E0,0xB3AE,0xB3AC,0xB3AD,0xB3AE,0xD1E1,0xB6A7,0xB3AF,0xC6CC,0xB1FA,0xBDD0,0x3F,0x3F,0xC8A1,0xD1E2,0x3F},
	set51[] = {1,1,1,3,1,0xFF,3,3,3,1,0xFF,3,3,3,3,0xFF,3,0xFF,1,0xFF,1,1,1,3,1,3,1,3,3,3,3,1,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,3,3,0xFF,1,0xFF,3,3,0xFF,3,0xFF,3,1,3,3,3,0xFF,1,3,3,1,1,1,0xFF,0xFF,1,1,1,3,1,1,1,1,1,1,1,3,1,1,1,1,3,1,0xFF,1,3,1,3,0xFF,3,3,0xFF,1,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,3,1,3,0xFF,1,1,1,1,1,1,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,1,1,1,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,1,0xFF,1,3,3,1,1,0xFF,0xFF,1,1,3,1,1,3,1,1,1,1,1,0xFF,1,1,1,3,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,3,1,3,1,1,1,0xFF,1,1,1,1,1,3,0xFF,0xFF,1,1,1,1,1,1,1,1,3,0xFF,3,0xFF,3,1,3,3,0xFF,0xFF,3,0xFF,1,1,1,0xFF,3,1,0xFF,1,1,1,0xFF,3,0xFF,3,3,3,0xFF,3,1,0xFF,3,0xFF,0xFF,1,1,1,3,0xFF,1,1,3,0xFF,0xFF,3,1,1,0xFF,1,1,0xFF,0xFF,1,3,0xFF,1,1,3,3,3,1,1,3,1,1,1,0xFF,0xFF,1,1,0xFF},
	en52[] = {0xC5E1,0xB3B0,0xB3B1,0xBFCF,0xD1E3,0xB3B2,0xCAAC,0xC0DA,0xB4A2,0x3F,0xB4A9,0xD1E4,0x3F,0x3F,0xD1E6,0x3F,0x3F,0xB7BA,0xB3B3,0xB3B4,0xD1E5,0xB3B5,0xB3B6,0xCEF3,0xB3B7,0x3F,0x3F,0x3F,0x3F,0xBDE9,0x3F,0x3F,0x3F,0x3F,0xB3B8,0x3F,0xC8BD,0xCACC,0x3F,0xD1E7,0xB3B9,0xCDF8,0xD1E8,0x3F,0x3F,0x3F,0xD1E9,0x3F,0xC5FE,0xB3BA,0xB3BB,0xD1EA,0x3F,0xB3BC,0xC0A9,0xBAFE,0xB7F4,0xD1EB,0xBBC9,0xB9EF,0xB3BD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC4E6,0xD1ED,0xB3BE,0x3F,0xC2A7,0x3F,0xB3BF,0xBAEF,0xD1EE,0xD1EF,0xC1B0,0x3F,0xD1EC,0x3F,0x3F,0x3F,0x3F,0xD1F1,0xB3C0,0xCBB6,0xB3C1,0xB3C2,0x3F,0xB3C3,0xB9E4,0xB3C4,0x3F,0xD1F0,0xB3C5,0xB3C6,0xB3C7,0x3F,0xB7F5,0xBADE,0xC7ED,0xB3C8,0x3F,0x3F,0xD1F4,0xD1F2,0x3F,0x3F,0x3F,0xB3C9,0xC9FB,0xBEEA,0xD1FB,0xB3E4,0xD1F5,0xD1F3,0xC1CF,0x3F,0xB3CA,0xB3CB,0xB3CC,0x3F,0x3F,0x3F,0xD1F7,0x3F,0xD1F6,0xB3CD,0x3F,0xB3CE,0xB3C4,0x3F,0xB3CF,0x3F,0xB7E0,0xD1FC,0xCEAD,0xB3D0,0x3F,0xB3D1,0xD1F8,0x3F,0x3F,0x3F,0xD1FD,0xD1FA,0xB3D2,0xD1F9,0xB3D3,0xB3D4,0xB3D5,0xB3D6,0x3F,0xB3D7,0xCECF,0xB3D8,0x3F,0x3F,0xB8F9,0xB2C3,0x3F,0x3F,0xCEF4,0xB3D9,0xB3DA,0xB3DB,0xB3DC,0x3F,0xBDF5,0xC5D8,0xB9E5,0xD2A2,0xD2A3,0x3F,0xB3DD,0xB3DE,0xCEE5,0x3F,0x3F,0xCFAB,0xD2A5,0xB3DF,0xB3E0,0xB3E1,0xB8FA,0xB3E2,0xB3E3,0xD2A4,0xB3E4,0xB3AF,0x3F,0xB3E5,0xD2A6,0x3F,0xCBD6,0xB3E6,0xC4BC,0xB3E7,0xCDA6,0xB3E8,0xCAD9,0x3F,0x3F,0xB3E9,0xD2A7,0x3F,0xB3EA,0x3F,0xB3EB,0xF0D5,0x3F,0xB3EC,0xC6B0,0xB3ED,0xD2A8,0xB4AA,0xCCB3,0x3F,0xB3EE,0xB3EF,0xBEA1,0xD2A9,0xCAE7,0xD2AD,0xB3F0,0xC0AA,0xD2AA,0xB6D0,0xB3F1,0xD2AB,0xB4AB,0xB3F2,0xB3F3,0xB3F4,0x3F,0xB3F5,0x3F,0x3F,0x3F,0xB3F6,0xB3F7,0xB7AE,0xD2AE,0xB3F8,0xD2AF,0xB3F9,0xB3FA,0xD2B0,0xD2B1,0xBCDB,0x3F,0x3F,0x3F,0xB8FB,0xCCDE},
	set52[] = {1,3,3,1,1,3,1,1,1,0xFF,1,1,0xFF,0xFF,1,0xFF,0xFF,1,3,3,1,3,3,1,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,1,0xFF,1,3,1,1,0xFF,0xFF,0xFF,1,0xFF,1,3,3,1,0xFF,3,1,1,1,1,1,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,3,0xFF,1,0xFF,3,1,1,1,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,3,1,3,3,0xFF,3,1,3,0xFF,1,3,3,3,0xFF,1,1,1,3,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,3,1,1,1,1,1,1,1,0xFF,3,3,3,0xFF,0xFF,0xFF,1,0xFF,1,3,0xFF,3,1,0xFF,3,0xFF,1,1,1,3,0xFF,3,1,0xFF,0xFF,0xFF,1,1,3,1,3,3,3,3,0xFF,3,1,3,0xFF,0xFF,1,1,0xFF,0xFF,1,3,3,3,3,0xFF,1,1,1,1,1,0xFF,3,3,1,0xFF,0xFF,1,1,3,3,3,1,3,3,1,3,1,0xFF,3,1,0xFF,1,3,1,3,1,3,1,0xFF,0xFF,3,1,0xFF,3,0xFF,3,1,0xFF,3,1,3,1,1,1,0xFF,3,3,1,1,1,1,3,1,1,1,3,1,1,3,3,3,0xFF,3,0xFF,0xFF,0xFF,3,3,1,1,3,1,3,3,1,1,1,0xFF,0xFF,0xFF,1,1},
	en53[] = {0xB3FB,0xCCE8,0xC6F7,0xB3FC,0x3F,0xCAF1,0xD2B2,0x3F,0xD2B3,0x3F,0xB3FD,0xB3FE,0xB4A1,0xD2B5,0x3F,0xD2B7,0xD2B6,0xB4A2,0x3F,0xB4A3,0x3F,0xD2B8,0xB2BD,0xCBCC,0xB4A4,0xBAFC,0xD2B9,0xB4A5,0xB4A6,0xC1D9,0xB4A7,0xB4A8,0xBEA2,0xB6A9,0x3F,0xD2BA,0x3F,0xB4A9,0x3F,0xB4AA,0xB4AB,0xB4AC,0xC8DB,0xB4AD,0xB4AE,0xB4AF,0x3F,0xD2BB,0xB4B0,0xD2BC,0xB4B1,0xD2BD,0x3F,0xB4B2,0x3F,0x3F,0xD2BE,0xC9A4,0xB6E8,0xB0E5,0xB4B3,0xB4B4,0xB4B5,0xC6BF,0xD2BF,0xBDBD,0xB4B6,0xC0E9,0x3F,0xD2C1,0xD2C0,0xBEA3,0xB8E1,0xD2C3,0xC8BE,0xB4B8,0xB4B7,0xD2C4,0x3F,0x3F,0x3F,0xC8DC,0xC2B4,0xC2EE,0xB6A8,0x3F,0x3F,0xC6EE,0xC3B1,0xB4B9,0xC7EE,0xB4BA,0xCBCE,0x3F,0xD2C6,0x3F,0xC0EA,0xB4BB,0x3F,0xB4BC,0x3F,0xB4BD,0xB7B5,0x3F,0x3F,0xD2C7,0x3F,0x3F,0xB4BE,0xB4BF,0xD2C8,0xB1AC,0xB0F5,0xB4ED,0xB4C0,0xC2A8,0xB5D1,0xCDF1,0x3F,0xD2CB,0xB2B7,0xB4C1,0x3F,0xD2CA,0x3F,0x3F,0xB4C2,0xB6AA,0x3F,0x3F,0xD2CC,0xB4C3,0xCCF1,0x3F,0x3F,0xB4C4,0xB4C5,0x3F,0x3F,0x3F,0x3F,0x3F,0xB4C6,0x3F,0x3F,0x3F,0x3F,0xB4C7,0xB4C8,0x3F,0xD2CD,0x3F,0xCED2,0xB4C9,0xB8FC,0x3F,0x3F,0xB4CA,0x3F,0xB8B6,0xD2CE,0xB4CB,0x3F,0x3F,0xB4CC,0xD2D0,0xD2CF,0x3F,0xBFDF,0xB1B9,0xB4CD,0xB4CE,0x3F,0xB1DE,0xD2D1,0xB4CF,0xD2D2,0x3F,0xB4D0,0xB8B7,0xB4D1,0xB4D2,0xD2D3,0xB4D3,0xB4D4,0x3F,0xB4D5,0xB5EE,0x3F,0xB4D6,0x3F,0x3F,0xB4D7,0x3F,0xBBB2,0xD2D4,0x3F,0xB4D8,0x3F,0x3F,0xCBF4,0xBAB5,0xB5DA,0xCDA7,0xC1D0,0xC8BF,0xBCFD,0xB4D9,0x3F,0x3F,0xB4DA,0xB4DB,0xBDC7,0xB4DC,0xBCE8,0xBCF5,0x3F,0xBDF6,0xB4DD,0xC8C0,0x3F,0xB4DE,0xB4DF,0xD2D7,0xB4E0,0xB1C3,0xC1D1,0xB8FD,0xB8C5,0xB6E7,0xB4E1,0xB4E2,0xD2DB,0xC3A1,0xC2FE,0xB6AB,0xBEA4,0xD2DC,0xD2DA,0xB2C4,0xC2E6,0xBCB8,0xBBCB,0xB1A6,0x3F,0xB4E3,0xB3F0,0xB9E6,0xBBCA,0x3F,0xD2DD,0x3F,0x3F,0x3F,0x3F,0x3F},
	set53[] = {3,1,1,3,0xFF,1,1,0xFF,1,0xFF,3,3,3,1,0xFF,1,1,3,0xFF,3,0xFF,1,1,1,3,1,1,3,3,1,3,3,1,1,0xFF,1,0xFF,3,0xFF,3,3,3,1,3,3,3,0xFF,1,3,1,3,1,0xFF,3,0xFF,0xFF,1,1,1,1,3,3,3,1,1,1,3,1,0xFF,1,1,1,1,1,1,3,3,1,0xFF,0xFF,0xFF,1,1,1,1,0xFF,0xFF,1,1,3,1,3,1,0xFF,1,0xFF,1,3,0xFF,3,0xFF,3,1,0xFF,0xFF,1,0xFF,0xFF,3,3,1,1,1,1,3,1,1,1,0xFF,1,1,3,0xFF,1,0xFF,0xFF,3,1,0xFF,0xFF,1,3,1,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,1,0xFF,1,3,1,0xFF,0xFF,3,0xFF,1,1,3,0xFF,0xFF,3,1,1,0xFF,1,1,3,3,0xFF,1,1,3,1,0xFF,3,1,3,3,1,3,3,0xFF,3,1,0xFF,3,0xFF,0xFF,3,0xFF,1,1,0xFF,3,0xFF,0xFF,1,1,1,1,1,1,1,3,0xFF,0xFF,3,3,1,3,1,1,0xFF,1,3,1,0xFF,3,3,1,3,1,1,1,1,1,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0xFF,3,1,1,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF},
	en54[] = {0x3F,0xD2DE,0xB4E4,0xB5C9,0xB3C6,0x3F,0x3F,0x3F,0xB9E7,0xB5C8,0xC4DF,0xB1A5,0xC6B1,0xCCBE,0xB9A1,0xCDF9,0xC5C7,0xB8FE,0x3F,0xB4E5,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB4E6,0xB7AF,0x3F,0xD2E7,0x3F,0xB6E3,0xCBCA,0xB4E7,0x3F,0x3F,0x3F,0x3F,0xC8DD,0xB4E8,0xB4E9,0xD2E6,0xB4EA,0xB4DE,0xD2E1,0xD2E2,0xD2E4,0xB4EB,0x3F,0xB4EC,0x3F,0x3F,0xB4ED,0xB4EE,0xD2E5,0x3F,0xB5DB,0xBFE1,0x3F,0xCAAD,0xD2E3,0xD2DF,0xB8E3,0x3F,0xD2E0,0x3F,0xCFA4,0xB4EF,0xB4F0,0x3F,0xCAF2,0xB4F1,0xC4E8,0xB8E2,0xB9F0,0x3F,0x3F,0xB4F2,0xD2E8,0xB4F3,0x3F,0xC6DD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB4F4,0xD2EC,0x3F,0x3F,0xB4F5,0x3F,0xB4F6,0x3F,0xB4F7,0xB4F8,0xBCFE,0xB4F9,0xBCF6,0xB4FA,0x3F,0xB4FB,0xB4FC,0x3F,0xD2EF,0xD2ED,0x3F,0xCCA3,0xB4FD,0xD2EA,0xD2F3,0xD2EE,0x3F,0x3F,0x3F,0xD2F1,0xB8C6,0xCCBF,0x3F,0xB4FE,0xD2F2,0xB5A1,0x3F,0xB5A2,0xD2F4,0xB5A3,0xD2F6,0x3F,0xB5A4,0xB5A5,0x3F,0xBAF0,0xCFC2,0xB5A6,0xD2EB,0xD2E9,0xD2F5,0xB5A7,0xD2F0,0x3F,0x3F,0xB5A8,0xB5A9,0x3F,0x3F,0x3F,0x3F,0x3F,0xB5AA,0x3F,0x3F,0xB5AB,0x3F,0xB5AC,0xD2F8,0x3F,0xD3A3,0xD2FA,0xB5AD,0xB5AE,0xD2FE,0xB5AF,0xB5B0,0xD3A1,0xD2FB,0xB5B1,0xB5B2,0xD3BE,0x3F,0xB5B3,0xBAE9,0xB3B1,0x3F,0x3F,0x3F,0xB5B4,0xD2F9,0xB5B5,0xB5B6,0xB5B7,0xD3A5,0xB0F6,0xD3A4,0xB5B8,0xB0A5,0xC9CA,0xD3A2,0x3F,0xD2FC,0x3F,0xB5B9,0xD2F7,0xD2FD,0xBAC8,0xB5BA,0x3F,0x3F,0xB5BB,0xB5BC,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD3A6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB5BD,0xB0F7,0xD3AF,0x3F,0x3F,0xD3A7,0xD3A8,0x3F,0xBEA5,0xCBE9,0xB5BE,0x3F,0xB5BF,0xD3AD,0xD3AC,0xB5C0,0x3F,0x3F,0xC5AF,0x3F,0x3F,0x3F,0xB5C1,0x3F,0x3F,0x3F,0xD3AE,0x3F,0xB5C2,0xD3AB,0xB5C3,0xB5C4},
	set54[] = {0xFF,1,3,1,1,0xFF,0xFF,0xFF,1,1,1,1,1,1,1,1,1,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,0xFF,1,0xFF,1,1,3,0xFF,0xFF,0xFF,0xFF,1,3,3,1,3,1,1,1,1,3,0xFF,3,0xFF,0xFF,3,3,1,0xFF,1,1,0xFF,1,1,1,1,0xFF,1,0xFF,1,3,3,0xFF,1,3,1,1,1,0xFF,0xFF,3,1,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,0xFF,0xFF,3,0xFF,3,0xFF,3,3,1,3,1,3,0xFF,3,3,0xFF,1,1,0xFF,1,3,1,1,1,0xFF,0xFF,0xFF,1,1,1,0xFF,3,1,3,0xFF,3,1,3,1,0xFF,3,3,0xFF,1,1,3,1,1,1,3,1,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,3,1,0xFF,1,1,3,3,1,3,3,1,1,3,3,1,0xFF,3,1,1,0xFF,0xFF,0xFF,3,1,3,3,3,1,1,1,3,1,1,1,0xFF,1,0xFF,3,1,1,1,3,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,1,0xFF,0xFF,1,1,0xFF,1,1,3,0xFF,3,1,1,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,3,1,3,3},
	en55[] = {0xB5C5,0xB5C6,0x3F,0x3F,0xB1B4,0xB5C7,0xBAB6,0xBFB0,0xB5C8,0xB5C9,0x3F,0x3F,0xB5CA,0xB5CB,0xB5CC,0xD3A9,0xC5E2,0x3F,0x3F,0x3F,0xD3AA,0xB5CD,0xB0A2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB5CE,0xB5CF,0x3F,0x3F,0xD3B4,0xCDA3,0x3F,0xBEA7,0xB5D0,0xD3BA,0x3F,0xB5D1,0xB5D2,0x3F,0xD3B9,0xD3B0,0x3F,0xB5D3,0xB5D4,0xB5D5,0xC2C3,0x3F,0xD3B1,0xB5D6,0x3F,0x3F,0xC2EF,0xD3B6,0xBEA6,0xB5D7,0x3F,0xB5D8,0xB5D9,0x3F,0xD3B3,0xB5DA,0x3F,0xCCE4,0xB5DB,0xB5DC,0x3F,0xB7BC,0x3F,0x3F,0xD3B7,0xD3B8,0xB5DD,0x3F,0xB5DE,0xB5DF,0xD3B5,0xD3BB,0xB5E0,0x3F,0xB5E1,0xB5E2,0x3F,0xD3B2,0xB5E3,0x3F,0xB5E4,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD3C1,0xD3C6,0x3F,0xD3C2,0xB5E5,0xD3BD,0xB5E6,0xB5E7,0xD3C7,0xC1B1,0x3F,0xB5E8,0xD3C9,0xB5E9,0xB9A2,0xD3BF,0xC3FD,0x3F,0x3F,0xB5EA,0xB5EB,0x3F,0xB5EC,0xB5ED,0xB5EE,0xB5EF,0x3F,0x3F,0xB5F0,0xD3C3,0xD3BC,0xB4AD,0x3F,0xB4EE,0xB3E5,0xD3C4,0xD3C0,0x3F,0x3F,0x3F,0xB5F1,0xB5F2,0x3F,0x3F,0xB7F6,0xD3CA,0xD3C8,0xC1D3,0xB5CA,0xB6AC,0xB5F3,0xD3C5,0x3F,0xB6F4,0x3F,0xB5F4,0x3F,0x3F,0x3F,0xB1C4,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB5F5,0x3F,0xB5F6,0x3F,0xB5F7,0xD3CE,0xD3CC,0xB5F8,0xD4A7,0x3F,0xB5F9,0x3F,0xB5FA,0xB5FB,0x3F,0xB5FC,0x3F,0x3F,0xB5FD,0xB5FE,0xB6A1,0xD3D1,0x3F,0x3F,0xB6A2,0xB6A3,0x3F,0xD3CB,0xB6A4,0xD3CF,0x3F,0xB6A5,0xD3CD,0x3F,0x3F,0xB6A6,0xBBCC,0xD3D0,0x3F,0x3F,0x3F,0x3F,0xB6A7,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB6A8,0xD3D3,0x3F,0xD3D8,0x3F,0x3F,0x3F,0xD3D6,0xD3D5,0xB6A9},
	set55[] = {3,3,0xFF,0xFF,1,3,1,1,3,3,0xFF,0xFF,3,3,3,1,1,0xFF,0xFF,0xFF,1,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,1,0xFF,1,3,1,0xFF,3,3,0xFF,1,1,0xFF,3,3,3,1,0xFF,1,3,0xFF,0xFF,1,1,1,3,0xFF,3,3,0xFF,1,3,0xFF,1,3,3,0xFF,1,0xFF,0xFF,1,1,3,0xFF,3,3,1,1,3,0xFF,3,3,0xFF,1,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,1,3,1,3,3,1,1,0xFF,3,1,3,1,1,1,0xFF,0xFF,3,3,0xFF,3,3,3,3,0xFF,0xFF,3,1,1,1,0xFF,1,1,1,1,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,1,1,1,1,1,3,1,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,3,1,1,3,1,0xFF,3,0xFF,3,3,0xFF,3,0xFF,0xFF,3,3,3,1,0xFF,0xFF,3,3,0xFF,1,3,1,0xFF,3,1,0xFF,0xFF,3,1,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,0xFF,1,0xFF,0xFF,0xFF,1,1,3},
	en56[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0xB6AA,0xC3B2,0x3F,0xB6AB,0xB2C5,0xB6AC,0x3F,0x3F,0xB6AD,0xB6AE,0xB6AF,0xB6B0,0xB6B1,0xB6B2,0x3F,0xD3D2,0x3F,0xD3D4,0xBEA8,0xB1B3,0xB6B3,0x3F,0xD3D7,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB2DE,0x3F,0x3F,0xB6B4,0x3F,0x3F,0xD3E2,0xB6B5,0xBEFC,0xD3DE,0xB6B6,0xD3DC,0xB6B7,0xD3DD,0xB6B8,0xD3DF,0xB6B9,0x3F,0xB6BA,0xB6BB,0xB6BC,0x3F,0xB6BD,0xB6BE,0xB6BF,0xB1BD,0xB6C0,0xB6C1,0x3F,0xB6C2,0x3F,0x3F,0xB6C3,0x3F,0xB6C4,0xC1B9,0xB6C5,0xD3D9,0xB6C6,0xD3DA,0x3F,0x3F,0x3F,0xB6C7,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB3FA,0x3F,0x3F,0xB6C8,0x3F,0xB6C9,0xB6CA,0xB6CB,0xB6CC,0xD3E1,0x3F,0xB6CD,0x3F,0xB4EF,0xB6CE,0xD3E4,0xD3E0,0xD3E3,0xB6CF,0x3F,0xB6D0,0x3F,0xB6D1,0xB6D2,0x3F,0xCAAE,0xB6D3,0x3F,0x3F,0xC6D5,0x3F,0xC8B8,0x3F,0x3F,0x3F,0x3F,0x3F,0xD3E6,0x3F,0x3F,0x3F,0xB6D4,0xB6D5,0xD3E5,0xB3C5,0xB6D6,0x3F,0xD3E7,0xB6D7,0xB6D8,0x3F,0x3F,0xD3EA,0x3F,0x3F,0x3F,0x3F,0xD3E9,0xB6D9,0x3F,0x3F,0x3F,0xB6DA,0xB6DB,0x3F,0x3F,0xB6DC,0xB6DD,0xB6DE,0xD3E8,0x3F,0xC7B9,0x3F,0x3F,0xD3EB,0xB6DF,0xB6E0,0xB6E1,0xB6E2,0x3F,0xB6E3,0xB6E4,0xB6E5,0xD3EC,0x3F,0x3F,0xB6E6,0x3F,0xB6E7,0xD3EE,0x3F,0xD3ED,0xB6E8,0x3F,0x3F,0x3F,0x3F,0xD3F0,0x3F,0xB6E9,0x3F,0xD3F3,0xD3F1,0xD3EF,0xD3F2,0x3F,0xB6EA,0x3F,0x3F,0xD3F4,0xB6EB,0xB6EC,0xB6ED,0xB6F0,0xB6F1,0xD3F5,0xB6EE,0xB6EF,0xD3F6,0x3F,0xD3F7,0x3F,0x3F,0x3F,0xD3F8,0xD1C5,0xB6F2,0xBCFC,0xBBCD,0xB6F3,0xB6F4,0xB2F3,0xB6F5,0xB0F8,0xB6F6,0x3F,0xC3C4,0xB6F7,0xB6F8,0xB6F9,0xB6FA,0xB6FB,0x3F,0x3F,0xB6FD,0x3F,0xB6FE,0xD3F9,0x3F,0xBAA4,0xB6FC,0xB0CF,0xBFDE,0x3F,0x3F,0xB7A1,0xB7A2,0x3F,0xD3FA,0xB8C7,0x3F,0x3F,0xB9F1,0x3F,0xD3FC},
	set56[] = {0xFF,0xFF,0xFF,0xFF,0xFF,3,1,0xFF,3,1,3,0xFF,0xFF,3,3,3,3,3,3,0xFF,1,0xFF,1,1,1,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,1,3,1,1,3,1,3,1,3,1,3,0xFF,3,3,3,0xFF,3,3,3,1,3,3,0xFF,3,0xFF,0xFF,3,0xFF,3,1,3,1,3,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,3,3,3,3,1,0xFF,3,0xFF,1,3,1,1,1,3,0xFF,3,0xFF,3,3,0xFF,1,3,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,3,1,1,3,0xFF,1,3,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,3,3,3,1,0xFF,1,0xFF,0xFF,1,3,3,3,3,0xFF,3,3,3,1,0xFF,0xFF,3,0xFF,3,1,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,1,1,1,1,0xFF,3,0xFF,0xFF,1,3,3,3,3,3,1,3,3,1,0xFF,1,0xFF,0xFF,0xFF,1,1,3,1,1,3,3,1,3,1,3,0xFF,1,3,3,3,3,3,0xFF,0xFF,3,0xFF,3,1,0xFF,1,3,1,1,0xFF,0xFF,3,3,0xFF,1,1,0xFF,0xFF,1,0xFF,1},
	en57[] = {0xD3FB,0xB7A3,0xB7A4,0xCAE0,0xD3FD,0x3F,0x3F,0xB7A5,0xD4A1,0xD3FE,0xB7A6,0xD4A2,0xB7A7,0xD4A3,0x3F,0xB7F7,0x3F,0xB7A8,0xB1E0,0xD4A4,0x3F,0xB7A9,0xD4A6,0x3F,0xD4A5,0x3F,0xB7AA,0xB7AB,0xD4A8,0xB7AC,0x3F,0xC5DA,0xB7AD,0x3F,0xB7AE,0xB7AF,0xB7B0,0xB7B1,0xD4A9,0xB0B5,0xBADF,0xB7B2,0xB7B3,0x3F,0xB7B4,0xB7BD,0xB7B5,0xB7B6,0xC3CF,0x3F,0x3F,0xB7B7,0xB7B8,0x3F,0x3F,0xD4AA,0xD4AB,0x3F,0x3F,0xD4AD,0x3F,0xB7B9,0xB7BA,0xB7BB,0xD4AE,0x3F,0xBAE4,0x3F,0x3F,0xB7BC,0xB7BD,0xB6D1,0x3F,0x3F,0xCBB7,0x3F,0xB7BE,0xB7BF,0xD4AC,0xD4AF,0xBAC1,0xB9A3,0xB7C0,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD4B3,0xB7C1,0x3F,0xBAA5,0xB7C2,0xC3B3,0xB7C3,0xB7C4,0xD4B0,0xC4DA,0xB7C5,0x3F,0xB7C6,0xB7C7,0xB7C8,0xB7C9,0xB7CA,0x3F,0xB7CB,0xB7CC,0xB7CD,0x3F,0xB7CE,0x3F,0xB7CF,0xB7D0,0xB7D1,0xB7D2,0x3F,0xB7D3,0xD4B4,0x3F,0xB7D4,0xBFE2,0xB7D5,0x3F,0x3F,0x3F,0x3F,0xD4B2,0xD4B5,0x3F,0xB7BF,0xB7D6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD4B6,0xB7D7,0xB7E0,0x3F,0xB7D8,0x3F,0xB7D9,0xB7DA,0x3F,0xB7DB,0xB7DC,0xB7DD,0xB7DE,0xD4B7,0xB7DF,0xB9A4,0xB3C0,0xD4B9,0x3F,0x3F,0xB7E1,0xB7E2,0xB7E3,0xD4BA,0x3F,0xB7E4,0x3F,0x3F,0x3F,0xD4BB,0x3F,0x3F,0xD4B8,0x3F,0x3F,0x3F,0x3F,0xB7E5,0x3F,0x3F,0x3F,0x3F,0xB7E6,0x3F,0x3F,0xD4B1,0x3F,0x3F,0xD4BC,0x3F,0x3F,0xD4BD,0xB7E7,0xB7E8,0x3F,0x3F,0xCBE4,0xB7E9,0x3F,0xBEEB,0xB7EA,0x3F,0x3F,0xD4BF,0xD4C0,0xD4BE,0xB7EB,0xD4C2,0x3F,0x3F,0x3F,0x3F,0x3F,0xC7B8,0xB7EC,0xB7ED,0xB0E8,0xC9D6,0xB7FE,0x3F,0xD4C3,0xB7EE,0x3F,0xB7EF,0xB7F0,0x3F,0xB7F1,0x3F,0x3F,0x3F,0xB7F2,0x3F,0x3F,0xB7F3,0x3F,0x3F,0x3F,0xBEFD,0xB7F4,0xB7F5,0xBCB9,0xB7F6,0xC7DD,0xB4F0,0x3F,0xBAEB,0xB7F7,0xB7F8,0xB7F9},
	set57[] = {1,3,3,1,1,0xFF,0xFF,3,1,1,3,1,3,1,0xFF,1,0xFF,3,1,1,0xFF,3,1,0xFF,1,0xFF,3,3,1,3,0xFF,1,3,0xFF,3,3,3,3,1,1,1,3,3,0xFF,3,1,3,3,1,0xFF,0xFF,3,3,0xFF,0xFF,1,1,0xFF,0xFF,1,0xFF,3,3,3,1,0xFF,1,0xFF,0xFF,3,3,1,0xFF,0xFF,1,0xFF,3,3,1,1,1,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,1,3,1,3,3,1,1,3,0xFF,3,3,3,3,3,0xFF,3,3,3,0xFF,3,0xFF,3,3,3,3,0xFF,3,1,0xFF,3,1,3,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,0xFF,3,0xFF,3,3,0xFF,3,3,3,3,1,3,1,1,1,0xFF,0xFF,3,3,3,1,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,1,3,3,0xFF,0xFF,1,3,0xFF,1,3,0xFF,0xFF,1,1,1,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,1,1,3,0xFF,1,3,0xFF,3,3,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,3,3,1,3,1,1,0xFF,1,3,3,3},
	en58[] = {0xCBD9,0x3F,0xC6B2,0xB7FA,0xB7FB,0xB7F8,0xC2CF,0x3F,0xB7FC,0xB7FD,0xD4C1,0xD4C4,0xB8A1,0xB8A2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC2C4,0x3F,0x3F,0x3F,0xD4C5,0x3F,0xB8A3,0x3F,0xD4C6,0xB8A4,0xB8A5,0xB8A6,0xD4C8,0x3F,0x3F,0xC4E9,0x3F,0xB8A7,0xB8A8,0x3F,0x3F,0xB4AE,0x3F,0x3F,0xB8A9,0x3F,0xF4A1,0xB1E1,0xCAF3,0xB8AA,0x3F,0xBEEC,0xC5C8,0x3F,0x3F,0x3F,0xB8AB,0xBAE6,0x3F,0x3F,0xD4CE,0x3F,0xB8AC,0xCABD,0xCEDD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB8AD,0xB2F4,0xD4CA,0xB8AE,0xB8AF,0x3F,0xB8B0,0xB8B1,0xC1BA,0xD4CD,0x3F,0xC5E3,0xB8B2,0x3F,0xC5C9,0xC5E4,0xC8B9,0xC4CD,0x3F,0x3F,0x3F,0xBAC9,0xB8B3,0x3F,0xB8B4,0xD4C9,0x3F,0xB8B5,0x3F,0x3F,0xB8B6,0xB8B7,0xB1F6,0x3F,0xC5B6,0x3F,0x3F,0x3F,0x3F,0xD4CB,0x3F,0xD4C7,0x3F,0x3F,0xBFD0,0x3F,0x3F,0xB8B8,0xD4CF,0x3F,0x3F,0xB8B9,0x3F,0xBDCE,0xB8BA,0xB8BB,0xB8BC,0x3F,0xB6AD,0x3F,0xD4D0,0x3F,0xB8BD,0xB8BE,0xB8BF,0xB8C0,0x3F,0xB8C1,0xB8C2,0x3F,0xB8C3,0xB8C4,0x3F,0x3F,0xCAE8,0xB8C5,0x3F,0xB8C6,0xC1FD,0x3F,0x3F,0x3F,0x3F,0xC4C6,0xB8C7,0x3F,0xD4D2,0xB8C8,0xB8C9,0xB8CA,0x3F,0x3F,0x3F,0xB8CB,0x3F,0xCBCF,0xB8CC,0x3F,0xD4D3,0x3F,0x3F,0xD4D8,0x3F,0x3F,0xB8CD,0xB8CE,0xCAAF,0x3F,0x3F,0x3F,0x3F,0xD4D7,0xD4D1,0xD4D4,0xD4D6,0xB8D0,0x3F,0xBAA6,0x3F,0x3F,0xCAC9,0xB8D1,0x3F,0xB8CF,0xD4D9,0x3F,0xC3C5,0xB8D2,0x3F,0xB2F5,0x3F,0xBEED,0xB8D3,0xB8D4,0x3F,0xB8D5,0xD4DB,0xB8D6,0xD4DA,0xB8D7,0xB9E8,0xB8D8,0xD4DC,0xD4DE,0xD4DD,0xB8D9,0x3F,0xD4E0,0xB8DA,0xD4D5,0xD4E2,0x3F,0xB8DB,0xB8DC,0x3F,0xD4E1,0xD4DF,0x3F,0x3F,0x3F,0xB8DD,0x3F,0xBBCE,0xBFD1,0x3F,0xC1D4,0xD4E3,0xC0BC,0xB0ED,0xC7E4,0xB8DE,0x3F,0x3F,0x3F,0xC4DB,0x3F,0xD4E5,0xD4E4,0xD4E6,0xD4E7,0xD4E8,0x3F,0x3F},
	set58[] = {1,0xFF,1,3,3,1,1,0xFF,3,3,1,1,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,1,3,3,3,1,0xFF,0xFF,1,0xFF,3,3,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,1,1,1,3,0xFF,1,1,0xFF,0xFF,0xFF,3,1,0xFF,0xFF,1,0xFF,3,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,1,3,3,0xFF,3,3,1,1,0xFF,1,3,0xFF,1,1,1,1,0xFF,0xFF,0xFF,1,3,0xFF,3,1,0xFF,3,0xFF,0xFF,3,3,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,3,1,0xFF,0xFF,3,0xFF,1,3,3,3,0xFF,1,0xFF,1,0xFF,3,3,3,3,0xFF,3,3,0xFF,3,3,0xFF,0xFF,1,3,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,1,3,3,3,0xFF,0xFF,0xFF,3,0xFF,1,3,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,3,3,1,0xFF,0xFF,0xFF,0xFF,1,1,1,1,3,0xFF,1,0xFF,0xFF,1,3,0xFF,3,1,0xFF,1,3,0xFF,1,0xFF,1,3,3,0xFF,3,1,3,1,3,1,3,1,1,1,3,0xFF,1,3,1,1,0xFF,3,3,0xFF,1,1,0xFF,0xFF,0xFF,3,0xFF,1,1,0xFF,1,1,1,1,1,3,0xFF,0xFF,0xFF,1,0xFF,1,1,1,1,1,0xFF,0xFF},
	en59[] = {0x3F,0x3F,0xD4E9,0x3F,0x3F,0xB8DF,0xB8E0,0x3F,0x3F,0xCAD1,0xD4EA,0xB8E1,0xB8E2,0x3F,0x3F,0xB2C6,0xD4EB,0x3F,0xB8E3,0xB8E4,0xB8E5,0xCDBC,0xB3B0,0x3F,0xD2C9,0xBDC8,0xC2BF,0xD4EC,0xCCEB,0xB8E7,0x3F,0x3F,0x3F,0xB8E8,0xCCB4,0xB8E9,0xB8EA,0xD4EE,0x3F,0xC2E7,0xB8EB,0xC5B7,0xC2C0,0xC9D7,0xD4EF,0xD4F0,0xB1FB,0xB8EC,0xB8ED,0xBCBA,0xD4F1,0xB8EE,0x3F,0xB8EF,0xB8F0,0xB0D0,0xD4F2,0x3F,0x3F,0x3F,0x3F,0x3F,0xD4F3,0xB8F1,0x3F,0x3F,0x3F,0xB8F2,0xB1E2,0x3F,0xB8F3,0xB4F1,0xC6E0,0xCAF4,0x3F,0x3F,0x3F,0x3F,0xD4F7,0xC1D5,0xD4F6,0xB7C0,0xB8F4,0xB8F5,0xCBDB,0xD4F5,0x3F,0xC5E5,0xD4F9,0xB8F6,0xD4F8,0xB8F7,0x3F,0xB8F8,0xB8F9,0xB8FA,0xD4FB,0xB8FB,0xD4FA,0xB8FC,0x3F,0xB1FC,0x3F,0xD4FC,0xBEA9,0xD4FE,0xC3A5,0xB8FD,0xD4FD,0xB8FE,0xCAB3,0xB9A1,0x3F,0x3F,0xB9A2,0xBDF7,0xC5DB,0xB9A3,0xB9A4,0x3F,0xD5A1,0xB9A5,0x3F,0xB9A6,0xB9A7,0xB9A5,0x3F,0x3F,0x3F,0xD5A2,0xC7A1,0xC8DE,0xCCD1,0x3F,0x3F,0x3F,0x3F,0x3F,0xC7A5,0xB9A8,0xB9A9,0xD5AB,0xB9AA,0x3F,0x3F,0x3F,0xB9AB,0xB5B8,0x3F,0xB9AC,0xCDC5,0xB9AD,0x3F,0xCCAF,0x3F,0xD6AC,0x3F,0xD5A3,0x3F,0xB9AE,0x3F,0x3F,0x3F,0xD5A6,0xB9AF,0xC2C5,0x3F,0xB9B0,0xCBB8,0x3F,0x3F,0x3F,0xC5CA,0xB9B1,0xB9B2,0xB9B3,0xB9B4,0x3F,0xD5A7,0xB9B5,0x3F,0x3F,0x3F,0xB9B6,0x3F,0xCBE5,0xB9B7,0xBACA,0xB9B8,0x3F,0xBEAA,0x3F,0x3F,0xB9B9,0x3F,0xB9BA,0xB9BB,0x3F,0xD5A8,0x3F,0xB9BC,0xBBD0,0xB9BD,0xBBCF,0x3F,0xB9BE,0x3F,0x3F,0xB0B9,0xB8C8,0xB9BF,0xC0AB,0xB0D1,0x3F,0x3F,0x3F,0x3F,0xD5AC,0xD5AD,0x3F,0xD5AA,0xB9C0,0xB9C1,0xB9C2,0x3F,0x3F,0x3F,0xB9C3,0xB9C4,0xB1B8,0xB4AF,0xB9C5,0xD5A9,0x3F,0xCCC5,0xC9B1,0x3F,0x3F,0xB9C6,0xB9C7,0x3F,0xB9C8,0xB9C9,0x3F,0xB9CA,0x3F,0xB0A8,0xB9CB,0x3F,0x3F,0x3F,0xB0F9,0x3F,0x3F,0x3F,0xBBD1},
	set59[] = {0xFF,0xFF,1,0xFF,0xFF,3,3,0xFF,0xFF,1,1,3,3,0xFF,0xFF,1,1,0xFF,3,3,3,1,1,0xFF,1,1,1,1,1,3,0xFF,0xFF,0xFF,3,1,3,3,1,0xFF,1,3,1,1,1,1,1,1,3,3,1,1,3,0xFF,3,3,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,3,1,0xFF,3,1,1,1,0xFF,0xFF,0xFF,0xFF,1,1,1,1,3,3,1,1,0xFF,1,1,3,1,3,0xFF,3,3,3,1,3,1,3,0xFF,1,0xFF,1,1,1,1,3,1,3,1,3,0xFF,0xFF,3,1,1,3,3,0xFF,1,3,0xFF,3,3,1,0xFF,0xFF,0xFF,1,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,1,3,0xFF,0xFF,0xFF,3,1,0xFF,3,1,3,0xFF,1,0xFF,1,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,1,3,1,0xFF,3,1,0xFF,0xFF,0xFF,1,3,3,3,3,0xFF,1,3,0xFF,0xFF,0xFF,3,0xFF,1,3,1,3,0xFF,1,0xFF,0xFF,3,0xFF,3,3,0xFF,1,0xFF,3,1,3,1,0xFF,3,0xFF,0xFF,1,1,3,1,1,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,1,3,3,3,0xFF,0xFF,0xFF,3,3,1,1,3,1,0xFF,1,1,0xFF,0xFF,3,3,0xFF,3,3,0xFF,3,0xFF,1,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1},
	en5A[] = {0xB9CC,0xB0D2,0x3F,0xB0A3,0xB9CD,0x3F,0x3F,0x3F,0x3F,0xD5B2,0x3F,0x3F,0xB9CE,0xB9CF,0xB9D0,0x3F,0x3F,0xD5B0,0xB9D1,0xB9D2,0x3F,0x3F,0x3F,0x3F,0xCCBC,0x3F,0xD5B3,0x3F,0xD5B1,0x3F,0xB9D3,0xD5AF,0xBFB1,0x3F,0x3F,0xB9D4,0xB9D5,0xD5AE,0x3F,0xB9D6,0xB9D7,0xCADA,0xB9D8,0x3F,0x3F,0xB9D9,0x3F,0xB8E4,0xB9DA,0x3F,0x3F,0x3F,0x3F,0xD5B7,0xD5B8,0x3F,0x3F,0x3F,0x3F,0x3F,0xBEAB,0x3F,0x3F,0x3F,0xD5B4,0xCFAC,0x3F,0x3F,0xB9DB,0xB9DC,0xC7CC,0xB9DD,0xB9DE,0xD5B6,0x3F,0x3F,0xB9DF,0x3F,0x3F,0x3F,0xB9E0,0x3F,0x3F,0x3F,0x3F,0xB9E1,0x3F,0x3F,0x3F,0x3F,0xBAA7,0x3F,0x3F,0x3F,0xB9E2,0x3F,0x3F,0x3F,0xD5B9,0xB9E3,0x3F,0xB9E4,0xC9D8,0xB9E5,0x3F,0x3F,0xD5BA,0x3F,0xD5B5,0xB9E6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB9E7,0x3F,0x3F,0xB9E8,0xB9E9,0x3F,0x3F,0xB9EA,0xCCBB,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB9EB,0x3F,0x3F,0x3F,0x3F,0xB9EC,0x3F,0xC7DE,0xB9ED,0x3F,0x3F,0xB9EE,0x3F,0x3F,0xB9EF,0xD5BB,0xC9B2,0xB9F0,0x3F,0xB9F1,0xB9F2,0xB9F3,0x3F,0xB9F4,0x3F,0x3F,0x3F,0x3F,0xB9F5,0x3F,0x3F,0x3F,0x3F,0xB9F6,0x3F,0x3F,0x3F,0x3F,0xB9F7,0xB9F8,0xB9F9,0x3F,0xB9FA,0x3F,0x3F,0xB9FB,0x3F,0xB9FC,0xB9FD,0xD5BC,0xD5C0,0xD5BD,0xB9FE,0x3F,0xB2C7,0xD5BF,0x3F,0xBAA1,0x3F,0xBAA2,0x3F,0xBAA3,0xBCBB,0x3F,0xD5BE,0xB7F9,0x3F,0x3F,0xBAA4,0xD5CC,0x3F,0x3F,0x3F,0x3F,0x3F,0xD5C5,0xD5C2,0x3F,0x3F,0xBAA5,0x3F,0xBAA6,0x3F,0x3F,0x3F,0xBAA7,0xC3E4,0x3F,0xD5C1,0x3F,0xBAA8,0xD5C3,0x3F,0x3F,0xD5C4,0xBAA9,0x3F,0x3F,0x3F,0xBAAA,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBAAB,0xBAAC,0x3F,0x3F,0x3F,0xD5C6,0xD5C7,0x3F,0xBAAD,0x3F,0x3F},
	set5A[] = {3,1,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,3,3,0xFF,0xFF,1,3,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,1,0xFF,3,1,1,0xFF,0xFF,3,3,1,0xFF,3,3,1,3,0xFF,0xFF,3,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,3,3,1,3,3,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,3,0xFF,3,1,3,0xFF,0xFF,1,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,3,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,3,0xFF,0xFF,3,0xFF,0xFF,3,1,1,3,0xFF,3,3,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,3,3,0xFF,3,0xFF,0xFF,3,0xFF,3,3,1,1,1,3,0xFF,1,1,0xFF,3,0xFF,3,0xFF,3,1,0xFF,1,1,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,3,1,0xFF,1,0xFF,3,1,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,1,1,0xFF,3,0xFF,0xFF},
	en5B[] = {0xBAAE,0xBAAF,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBAB0,0xB4F2,0x3F,0xD5C9,0xD5C8,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD5CA,0xBAB1,0x3F,0xBAB3,0x3F,0xBAB4,0x3F,0xBAB5,0x3F,0x3F,0x3F,0xBAB6,0xBEEE,0x3F,0x3F,0xBAB7,0x3F,0x3F,0x3F,0x3F,0xD5CD,0x3F,0xC4DC,0xBAB8,0x3F,0x3F,0xB1C5,0x3F,0xD5CB,0x3F,0xBAB2,0x3F,0xD5CE,0x3F,0xBAB9,0x3F,0x3F,0x3F,0x3F,0x3F,0xD5CF,0x3F,0xD5D2,0xBABA,0x3F,0xD5D0,0x3F,0xD5D1,0x3F,0x3F,0x3F,0x3F,0x3F,0xBABB,0xBABC,0x3F,0x3F,0x3F,0xBBD2,0xD5D3,0xBABD,0x3F,0xB9A6,0xD5D4,0xBABE,0xBBFA,0xC2B8,0x3F,0xD5D5,0xD5D6,0xBBDA,0xB9A7,0xBABF,0xCCD2,0x3F,0x3F,0x3F,0xB5A8,0xB8C9,0xD5D7,0xB3D8,0x3F,0xBAC0,0xD5D8,0x3F,0xC2B9,0x3F,0x3F,0xBAC1,0xBAC2,0xD5D9,0xD6A3,0x3F,0xD5DA,0x3F,0xD5DB,0x3F,0x3F,0xD5DC,0x3F,0xD5DE,0x3F,0xBAC3,0xBAC4,0xBAC5,0xBAC6,0xD5DF,0xBAC7,0x3F,0xD5E0,0xBAC8,0xC2F0,0xBAC9,0xB1A7,0xBCE9,0xB0C2,0xBACA,0xC1D7,0xB4B0,0xBCB5,0xBACB,0xB9A8,0xBACC,0xBACD,0x3F,0xBACE,0xBACF,0xC5E6,0xBAD0,0xBDA1,0xB4B1,0xC3E8,0xC4EA,0xB0B8,0xB5B9,0xCAF5,0x3F,0xBCC2,0x3F,0x3F,0xB5D2,0xC0EB,0xBCBC,0xCDA8,0xD5E1,0x3F,0xBAD1,0xBAD2,0x3F,0x3F,0xBAD3,0xBAD4,0xB5DC,0xBAD5,0xBACB,0xBAD6,0xBAD7,0xB3B2,0xB1E3,0xBEAC,0xB2C8,0xBAD8,0xD5E2,0xCDC6,0xBAD9,0x3F,0xBADA,0x3F,0x3F,0xBDC9,0xBADB,0xBADC,0xBCE4,0xD5E3,0xB4F3,0xC6D2,0xCCA9,0xD5E4,0x3F,0xD5E5,0x3F,0x3F,0xC9D9,0xBADD,0x3F,0xBADE,0xD5E7,0x3F,0xB4A8,0xB6F7,0xD5E6,0x3F,0xBADF,0xBAE0,0xBAE1,0xBAE2,0xBAE3,0xB4B2,0x3F,0xBFB2,0xD5EB,0xBBA1,0xBAE4,0xB2C9,0xD5EA,0x3F,0xD5E8,0xD5EC,0xD5E9,0xC7AB,0xDCCD,0xBFB3,0x3F,0xD5ED,0x3F,0x3F,0xCEC0,0xBAE5,0xD5EE,0xBAE6,0x3F,0xD5F0,0xBAE7,0xC3FE,0xD5EF,0x3F,0xC0A3,0x3F,0xBBFB,0x3F,0x3F,0xBAE8,0xC2D0,0xBCF7},
	set5B[] = {3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,3,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,3,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,3,0xFF,0xFF,1,0xFF,1,0xFF,3,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,3,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,1,1,3,0xFF,1,1,3,1,1,0xFF,1,1,1,1,3,1,0xFF,0xFF,0xFF,1,1,1,1,0xFF,3,1,0xFF,1,0xFF,0xFF,3,3,1,1,0xFF,1,0xFF,1,0xFF,0xFF,1,0xFF,1,0xFF,3,3,3,3,1,3,0xFF,1,3,1,3,1,1,1,3,1,1,1,3,1,3,3,0xFF,3,3,1,3,1,1,1,1,1,1,1,0xFF,1,0xFF,0xFF,1,1,1,1,1,0xFF,3,3,0xFF,0xFF,3,3,1,3,1,3,3,1,1,1,1,3,1,1,3,0xFF,3,0xFF,0xFF,1,3,3,1,1,1,1,1,1,0xFF,1,0xFF,0xFF,1,3,0xFF,3,1,0xFF,1,1,1,0xFF,3,3,3,3,3,1,0xFF,1,1,1,3,1,1,0xFF,1,1,1,1,1,1,0xFF,1,0xFF,0xFF,1,3,1,3,0xFF,1,3,1,1,0xFF,1,0xFF,1,0xFF,0xFF,3,1,1},
	en5C[] = {0x3F,0xC9F5,0xC0EC,0x3F,0xBCCD,0xD5F1,0xBEAD,0xD5F2,0xD5F3,0xB0D3,0xC2BA,0xBFD2,0xBAE9,0xD5F4,0xC6B3,0xBEAE,0x3F,0xBEAF,0x3F,0xD5F5,0x3F,0x3F,0xC0ED,0xBAEA,0x3F,0x3F,0xBEB0,0x3F,0x3F,0x3F,0xBAEB,0xBAEC,0xD5F6,0x3F,0xD5F7,0xBAED,0xCCE0,0x3F,0xBAEE,0x3F,0xD5F8,0xBAEF,0x3F,0xBAF0,0xBAF1,0xB6C6,0xBAF2,0x3F,0xBAF3,0xBDA2,0xBAF4,0x3F,0x3F,0xBAF5,0xBAF6,0x3F,0xD5F9,0xD5FA,0xBCDC,0xBFAC,0xC6F4,0xBFD4,0xC8F8,0xC7A2,0xB6C9,0xD5FB,0x3F,0x3F,0x3F,0xB5EF,0xD5FC,0x3F,0xB6FE,0x3F,0xC6CF,0xB2B0,0x3F,0xBBD3,0xD5FD,0xD6A2,0xD6A1,0xB6FD,0x3F,0xD5FE,0x3F,0xC5B8,0x3F,0x3F,0x3F,0xBAF7,0xBAF8,0x3F,0xBAF9,0x3F,0xC2B0,0x3F,0xC5CB,0xBCC8,0xBAFA,0xBAFB,0xC1D8,0xCDFA,0x3F,0xBAFC,0xBAFD,0xBAFE,0x3F,0x3F,0xD6A4,0xBBA1,0xD6A5,0xC6D6,0xBBA2,0xBBB3,0x3F,0x3F,0xBBA3,0xBBA4,0xD6A7,0x3F,0x3F,0xD6A8,0xBBA5,0xBBA6,0xBBA7,0xBBA8,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBBA9,0xBBAA,0x3F,0xBBAB,0x3F,0xD6A9,0x3F,0x3F,0xBBAC,0xB4F4,0xD6AA,0xBBAD,0x3F,0xD6AB,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBBAE,0x3F,0xBBAF,0xBBB0,0xB2AC,0xBBB1,0xBBB2,0x3F,0x3F,0xBBB3,0x3F,0xC1BB,0xB4E4,0xBBB4,0xD6AD,0xCCA8,0x3F,0x3F,0x3F,0x3F,0xC2D2,0xBBB5,0xB3D9,0xBBB6,0xBBB7,0xD6AF,0xD6B1,0xB4DF,0x3F,0xBBB8,0xD6AE,0xD6B0,0x3F,0xD6B3,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD6B2,0x3F,0xD6B4,0x3F,0xBBB9,0x3F,0xBBBA,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBBBB,0x3F,0x3F,0x3F,0x3F,0xBBBD,0x3F,0xD6B5,0x3F,0x3F,0x3F,0xBBBC,0x3F,0x3F,0xC6BD,0xB6AE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB2E5,0xD6B6,0xD6BB,0x3F,0x3F,0xD6B9,0xBBBE,0xCAF7,0xCAF6,0xBBBF,0xBBC0,0x3F,0xBBC1,0x3F,0xC5E7,0x3F,0x3F,0x3F,0xD6B8,0xBDD4,0x3F,0xD6B7,0x3F,0x3F},
	set5C[] = {0xFF,1,1,0xFF,1,1,1,1,1,1,1,1,3,1,1,1,0xFF,1,0xFF,1,0xFF,0xFF,1,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,3,1,0xFF,1,3,1,0xFF,3,0xFF,1,3,0xFF,3,3,1,3,0xFF,3,1,3,0xFF,0xFF,3,3,0xFF,1,1,1,1,1,1,1,1,1,1,0xFF,0xFF,0xFF,1,1,0xFF,1,0xFF,1,1,0xFF,1,1,1,1,1,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,3,3,0xFF,3,0xFF,1,0xFF,1,1,3,3,1,1,0xFF,3,3,3,0xFF,0xFF,1,3,1,1,3,1,0xFF,0xFF,3,3,1,0xFF,0xFF,1,3,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,3,0xFF,1,0xFF,0xFF,3,1,1,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,3,1,3,3,0xFF,0xFF,3,0xFF,1,1,3,1,1,0xFF,0xFF,0xFF,0xFF,1,3,1,3,3,1,1,1,0xFF,3,1,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF,0xFF,1,3,1,1,3,3,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,1,1,0xFF,1,0xFF,0xFF},
	en5D[] = {0x3F,0xBBC2,0x3F,0x3F,0x3F,0x3F,0xBBC3,0xBFF2,0x3F,0x3F,0x3F,0xD6BC,0x3F,0xBBC4,0xBAEA,0x3F,0x3F,0xD6C2,0xBBC5,0x3F,0xD6C3,0xD6BD,0xB3B3,0xD6BE,0xD6C7,0xD6C6,0xD6C5,0xD6C1,0x3F,0x3F,0x3F,0xD6C0,0x3F,0x3F,0xD6C4,0xBBC7,0xBBC8,0x3F,0xBBC9,0xBBCA,0x3F,0xCAF8,0x3F,0xBBC6,0x3F,0x3F,0x3F,0x3F,0x3F,0xBBCB,0x3F,0x3F,0xBBCC,0x3F,0x3F,0x3F,0x3F,0xBBCD,0x3F,0x3F,0x3F,0xBBCE,0x3F,0xBBCF,0x3F,0x3F,0xBBD0,0xBBD1,0x3F,0x3F,0xBBD2,0x3F,0xBBD3,0x3F,0xBBD7,0xD6CB,0xD6C8,0x3F,0xD6CA,0x3F,0xCDF2,0xBBD5,0xD6C9,0x3F,0x3F,0xBBD4,0x3F,0x3F,0x3F,0xBBD6,0x3F,0x3F,0xD6BF,0x3F,0x3F,0xBBD8,0xBBD9,0xBBDA,0xBBDB,0x3F,0xBBDC,0x3F,0x3F,0x3F,0x3F,0xBFF3,0xBBDD,0x3F,0xD6CC,0xBBDE,0x3F,0xBAB7,0xBBDF,0x3F,0x3F,0xD6CD,0x3F,0x3F,0xD6CE,0x3F,0x3F,0xBBE0,0xBBE1,0x3F,0x3F,0x3F,0xBBE2,0xBBE3,0x3F,0xBBE4,0xD6D1,0xBBE5,0xD6D0,0x3F,0x3F,0xD6CF,0xBBE6,0x3F,0xBBE7,0xC5E8,0xD6BA,0x3F,0x3F,0x3F,0xD6D7,0x3F,0xBBE8,0xBBE9,0xBBEA,0xBBEB,0x3F,0x3F,0x3F,0xBBEC,0x3F,0xBBED,0x3F,0xD6D3,0x3F,0xBBEE,0xBBEF,0x3F,0xD6D2,0x3F,0x3F,0x3F,0x3F,0xBBF0,0x3F,0x3F,0x3F,0xBBF1,0xD6D4,0x3F,0xD6D5,0x3F,0xBBF2,0x3F,0xE6F4,0x3F,0xBBF3,0x3F,0x3F,0xD6D8,0xBBF4,0xBBF5,0xCEE6,0x3F,0xD6D9,0xD6D6,0x3F,0x3F,0x3F,0x3F,0x3F,0xBBF6,0x3F,0x3F,0x3F,0xBBF7,0x3F,0xD6DA,0x3F,0xBBF8,0xB4E0,0xD6DB,0xBBFA,0x3F,0xBBF9,0x3F,0xD6DD,0xD6DC,0x3F,0x3F,0xD6DE,0x3F,0xBBFB,0xBBFC,0x3F,0xD6DF,0x3F,0xC0EE,0xBDA3,0x3F,0xBBFD,0xBDE4,0x3F,0xC1E3,0xBBFE,0xB9A9,0xBAB8,0xB9AA,0xB5F0,0xBCA1,0x3F,0xD6E0,0x3F,0x3F,0xBAB9,0x3F,0x3F,0xB8CA,0xD6E1,0xCCA6,0xC7C3,0xD6E2,0x3F,0xB9AB,0xBCA2,0xBCA3,0x3F,0xB4AC,0x3F,0xC3A7,0xB6D2,0x3F},
	set5D[] = {0xFF,3,0xFF,0xFF,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,1,0xFF,3,1,0xFF,0xFF,1,3,0xFF,1,1,1,1,1,1,1,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,3,3,0xFF,3,3,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,3,3,0xFF,0xFF,3,0xFF,3,0xFF,3,1,1,0xFF,1,0xFF,1,3,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,3,3,3,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,1,3,0xFF,1,3,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,3,3,0xFF,3,1,3,1,0xFF,0xFF,1,3,0xFF,3,1,1,0xFF,0xFF,0xFF,1,0xFF,3,3,3,3,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,1,0xFF,3,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,1,0xFF,1,0xFF,3,0xFF,3,0xFF,3,0xFF,0xFF,1,3,3,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,3,1,1,3,0xFF,3,0xFF,1,1,0xFF,0xFF,1,0xFF,3,3,0xFF,1,0xFF,1,1,0xFF,3,1,0xFF,1,3,1,1,1,1,3,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,1,1,1,1,1,0xFF,1,3,3,0xFF,1,0xFF,1,1,0xFF},
	en5E[] = {0xBCA4,0x3F,0xBBD4,0xC9DB,0x3F,0x3F,0xC8C1,0xBCA5,0x3F,0x3F,0x3F,0xD6E3,0xB4F5,0xBCA6,0x3F,0x3F,0x3F,0xD6E6,0xBCA7,0x3F,0xBCA8,0xBCA9,0xC4A1,0x3F,0xBCAA,0xD6E5,0xD6E4,0xD6E7,0x3F,0xC4EB,0x3F,0xBCAB,0xBCAC,0x3F,0x3F,0x3F,0x3F,0xBFE3,0x3F,0x3F,0xBCAE,0x3F,0x3F,0xBBD5,0x3F,0xC0CA,0xBCAD,0xC2D3,0xB5A2,0x3F,0xBCAF,0xC4A2,0x3F,0xBCB0,0xD6E8,0xD6E9,0xBEEF,0x3F,0x3F,0x3F,0x3F,0xCBB9,0xBCB1,0x3F,0xD6EC,0x3F,0x3F,0xD6EB,0xD6EA,0xC9FD,0x3F,0xD6F3,0x3F,0xBCB4,0x3F,0xBCB2,0xCBDA,0x3F,0xD6ED,0x3F,0xBCB3,0xBCB5,0x3F,0x3F,0xD6EF,0xCBEB,0xBCB6,0xD6EE,0xBCB7,0x3F,0x3F,0xBCB8,0xBCB9,0x3F,0xBCBA,0xD6F0,0x3F,0xC8A8,0xD6F1,0xCABE,0xD6F2,0x3F,0x3F,0x3F,0xBCBB,0x3F,0xBCBC,0xBCBD,0xBCBE,0xBCBF,0xBCC0,0x3F,0xBCC1,0x3F,0xB4B3,0xCABF,0xC7AF,0xD6F4,0xD6F5,0x3F,0xB9AC,0xB4B4,0xD6F6,0xB8B8,0xCDC4,0xCDA9,0xB4F6,0xD6F8,0xBCC2,0xC4A3,0x3F,0xB9AD,0xBEB1,0x3F,0x3F,0xC8DF,0x3F,0x3F,0xBEB2,0xBCC3,0x3F,0x3F,0xBCC4,0xBDF8,0x3F,0x3F,0x3F,0x3F,0x3F,0xC4EC,0xCAF9,0xC5B9,0x3F,0x3F,0xB9AE,0x3F,0xC9DC,0x3F,0x3F,0x3F,0xD6F9,0x3F,0xBCC5,0x3F,0xBCC6,0xBCC7,0xC5D9,0xBAC2,0xBCC8,0x3F,0xBCC9,0xB8CB,0xBCCA,0xC4ED,0x3F,0x3F,0x3F,0xBCCB,0x3F,0xBCCC,0x3F,0xB0C3,0xBDEE,0xB9AF,0xCDC7,0x3F,0x3F,0x3F,0x3F,0xBCCD,0xBCCE,0xBCCF,0x3F,0xD6FA,0xD6FB,0xC7D1,0x3F,0x3F,0xBCD0,0x3F,0xD6FC,0xCEF7,0xCFAD,0xBCD2,0xBCD1,0x3F,0xBCD3,0xD6FE,0xD6FD,0xBCD4,0xBCD5,0xB3C7,0xBCD6,0xBCD7,0xD7A1,0x3F,0x3F,0x3F,0xD7A4,0xD7A5,0xBCD8,0xD7A3,0xBCD9,0xC9C0,0xBEB3,0xD7A7,0xD7A6,0xD7A2,0x3F,0xBCDA,0x3F,0x3F,0xD7A8,0xD7A9,0x3F,0xBCDB,0xD7AA,0x3F,0x3F,0x3F,0xD7AD,0xD7AB,0x3F,0xD7AC,0xD7AE,0x3F,0xB1E4,0xC4EE,0xD7AF,0x3F,0xB7FA,0xB2F6,0xC7B6,0x3F,0xD7B0,0xC6FB},
	set5E[] = {3,0xFF,1,1,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,1,1,3,0xFF,0xFF,0xFF,1,3,0xFF,3,3,1,0xFF,3,1,1,1,0xFF,1,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,1,3,1,1,0xFF,3,1,0xFF,3,1,1,1,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,1,0xFF,0xFF,1,1,1,0xFF,1,0xFF,3,0xFF,3,1,0xFF,1,0xFF,3,3,0xFF,0xFF,1,1,3,1,3,0xFF,0xFF,3,3,0xFF,3,1,0xFF,1,1,1,1,0xFF,0xFF,0xFF,3,0xFF,3,3,3,3,3,0xFF,3,0xFF,1,1,1,1,1,0xFF,1,1,1,1,1,1,1,1,3,1,0xFF,1,1,0xFF,0xFF,1,0xFF,0xFF,1,3,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,3,3,1,1,3,0xFF,3,1,3,1,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,1,1,1,1,0xFF,0xFF,0xFF,0xFF,3,3,3,0xFF,1,1,1,0xFF,0xFF,3,0xFF,1,1,1,3,3,0xFF,3,1,1,3,3,1,3,3,1,0xFF,0xFF,0xFF,1,1,3,1,3,1,1,1,1,1,0xFF,3,0xFF,0xFF,1,1,0xFF,3,1,0xFF,0xFF,0xFF,1,1,0xFF,1,1,0xFF,1,1,1,0xFF,1,1,1,0xFF,1,1},
	en5F[] = {0x3F,0xCADB,0xBCDC,0xD7B1,0xCFAE,0x3F,0xBCDD,0xBCDE,0xBCDF,0xD7B2,0xCAC0,0xD7B5,0xD0A1,0xD0B1,0xBCE0,0xBCB0,0xC6F5,0xD7B6,0x3F,0xB5DD,0xC4A4,0xB0FA,0xD7B7,0xCAA6,0xB9B0,0xBCE1,0x3F,0xC3D0,0xBCE2,0xBCE3,0x3F,0xC4EF,0x3F,0xBCE4,0xBCE5,0xBCE6,0xBCE7,0xCCEF,0xB8B9,0xB8CC,0xBCE8,0xD7B8,0x3F,0xBCE9,0xBCEA,0xD7B9,0xBCEB,0xD7BF,0xBCEC,0xBCE5,0x3F,0x3F,0xBCED,0xC4A5,0xBCEE,0xB6AF,0xD7BA,0x3F,0x3F,0xBCEF,0xC9AB,0xBCF0,0xC3C6,0xBCF1,0xBCF2,0xD7BB,0x3F,0x3F,0xBCF3,0xBCF4,0x3F,0xBCF5,0xD7BC,0x3F,0xB6B0,0x3F,0xD7BD,0xBCF6,0xD7BE,0x3F,0xBCF7,0xD7C0,0x3F,0xC5F6,0xBCF8,0x3F,0xD7C1,0xD7C2,0xBCF9,0xD7C3,0x3F,0xBCFA,0xD7B4,0xD7B3,0x3F,0x3F,0xBCFB,0xD7C4,0xB7C1,0xBCFC,0xBCFD,0x3F,0xC9A7,0xBCFE,0x3F,0xBACC,0xC9B7,0xC4A6,0xC9CB,0xD7C5,0x3F,0xBDA1,0xBEB4,0xB1C6,0xBDA2,0xD7C6,0xBDA3,0xBDA4,0x3F,0xD7C7,0xBDA5,0xCCF2,0xBDA6,0x3F,0xC8E0,0xBDA7,0xBDA8,0xD7CA,0xB1FD,0xC0AC,0xD7C9,0xD7C8,0xB7C2,0xC2D4,0x3F,0xD7CE,0xD7CC,0xBDA9,0xD7CB,0xCEA7,0xB8E5,0xBDAA,0x3F,0xBDAB,0xBDF9,0xD7CD,0xC5CC,0xBDBE,0x3F,0x3F,0xBDAC,0xC6C0,0xD7D1,0xD7D0,0x3F,0x3F,0xBDAD,0xBDAE,0xD7CF,0x3F,0xD7D2,0xB8E6,0xBDAF,0x3F,0xBDB2,0x3F,0x3F,0xBDB0,0xD7D3,0xC9FC,0xBDDB,0xBDB1,0xBDB3,0xD7D4,0xC8F9,0xBDB4,0xBDB5,0xBDB6,0x3F,0xC6C1,0xC4A7,0x3F,0x3F,0x3F,0xBDB7,0xC5B0,0x3F,0x3F,0xD7D5,0xB5AB,0x3F,0x3F,0x3F,0x3F,0x3F,0xBFB4,0xBDB8,0xC9AC,0x3F,0xBDB9,0xBDBA,0xBDBB,0x3F,0xBDBC,0xB4F7,0xC7A6,0x3F,0x3F,0xBDBD,0xBDBE,0xBDBF,0xBDC0,0xBDC1,0x3F,0xD7D6,0xBBD6,0xCBBA,0xCBBB,0x3F,0x3F,0xB1FE,0xD7DB,0xBDC2,0x3F,0xC3E9,0xBDC3,0xBDC4,0x3F,0xD7D8,0x3F,0x3F,0x3F,0xBDC5,0xBDC6,0xBDC7,0xB2F7,0xBDC8,0xBDC9,0xBDCA,0xBDCB,0xD8AD,0xD7DA,0xBDCC,0xBDCD,0x3F,0xC7B0,0xBDCE,0x3F,0xD7D9,0x3F,0xBDCF,0xD7D7,0xBDD0,0xB9FA,0x3F,0xD7DD},
	set5F[] = {0xFF,1,3,1,1,0xFF,3,3,3,1,1,1,1,1,3,1,1,1,0xFF,1,1,1,1,1,1,3,0xFF,1,3,3,0xFF,1,0xFF,3,3,3,3,1,1,1,3,1,0xFF,3,3,1,3,1,3,1,0xFF,0xFF,3,1,3,1,1,0xFF,0xFF,3,1,3,1,3,3,1,0xFF,0xFF,3,3,0xFF,3,1,0xFF,1,0xFF,1,3,1,0xFF,3,1,0xFF,1,3,0xFF,1,1,3,1,0xFF,3,1,1,0xFF,0xFF,3,1,1,3,3,0xFF,1,3,0xFF,1,1,1,1,1,0xFF,3,1,1,3,1,3,3,0xFF,1,3,1,3,0xFF,1,3,3,1,1,1,1,1,1,1,0xFF,1,1,3,1,1,1,3,0xFF,3,1,1,1,1,0xFF,0xFF,3,1,1,1,0xFF,0xFF,3,3,1,0xFF,1,1,3,0xFF,3,0xFF,0xFF,3,1,1,1,3,3,1,1,3,3,3,0xFF,1,1,0xFF,0xFF,0xFF,3,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,1,0xFF,3,3,3,0xFF,3,1,1,0xFF,0xFF,3,3,3,3,3,0xFF,1,1,1,1,0xFF,0xFF,1,1,3,0xFF,1,3,3,0xFF,1,0xFF,0xFF,0xFF,3,3,3,1,3,3,3,3,1,1,3,3,0xFF,1,3,0xFF,1,0xFF,3,1,3,1,0xFF,1},
	en60[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBDD1,0x3F,0x3F,0xBDD2,0x3F,0x3F,0xBDD3,0xD7E3,0xD7E9,0xD7E1,0x3F,0xC5DC,0xBDD4,0xBDD5,0xD7E6,0xC9DD,0xBDD6,0xBDD7,0xD7E0,0xBDD8,0xD7E5,0xCEE7,0xBBD7,0x3F,0xBDD9,0xC2D5,0xD7DE,0x3F,0x3F,0xBDDA,0xB5DE,0xD7E8,0xC0AD,0xB1E5,0xD7E2,0xB2F8,0xD7E7,0x3F,0xBDDB,0x3F,0xB6B1,0x3F,0xD7E4,0x3F,0xBDDC,0x3F,0xBDDD,0x3F,0x3F,0x3F,0x3F,0xD7EA,0x3F,0x3F,0x3F,0x3F,0x3F,0xBDDE,0xD7EC,0xD7F6,0xD7F4,0x3F,0x3F,0xD7F1,0xBDDF,0xBDE0,0xBDE1,0xD7F0,0xCEF8,0xBDE2,0xD7F2,0x3F,0x3F,0xB6B2,0xBDE3,0xB9B1,0x3F,0xBDE4,0xBDFA,0xBDE5,0xBDE6,0x3F,0xD7F9,0xD7EB,0x3F,0x3F,0xBDE7,0x3F,0xD7EF,0xD7DF,0xBDE8,0xB2FA,0xD7F3,0xD7F5,0xC3D1,0x3F,0xBDE9,0xBAA8,0xB2B8,0xD7ED,0xD7F8,0xD7F7,0xB6B3,0x3F,0xC2A9,0xB3E6,0xBDEA,0x3F,0x3F,0x3F,0xB7C3,0x3F,0xD7EE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBDEB,0xBDEC,0x3F,0xD7FA,0xBDED,0xD7FD,0xD8A1,0x3F,0xBDEE,0x3F,0xBDEF,0xBCBD,0xBDF0,0xD8A7,0xC4F0,0xD7FB,0xBDF1,0x3F,0x3F,0xBDF2,0xD8A5,0xBDF3,0xB2F9,0xBDF4,0xD8A3,0xD8A4,0xBDF5,0x3F,0xD7FE,0xD8A2,0x3F,0xBDF6,0xBDF7,0xB8E7,0xCDAA,0x3F,0xBDF8,0xB4B5,0xBDF9,0xBDFA,0xB1D9,0xD8A6,0xBDFB,0xC7BA,0xB0AD,0x3F,0x3F,0x3F,0x3F,0x3F,0xBDFC,0xBDFD,0xC8E1,0xD7DC,0xD8AC,0xD8B0,0xCCE5,0xBDFE,0xD8A9,0x3F,0x3F,0xBEA1,0xC5E9,0xD8AE,0xBEA2,0x3F,0x3F,0x3F,0xBEA3,0x3F,0xBEA4,0xBEF0,0xD8AF,0xC6D7,0xBEA5,0xBEA6,0xBEA7,0xBEA8,0x3F,0x3F,0xBEA9,0xBEAA,0x3F,0xCFC7,0x3F,0xD8AB,0xBEAB,0xBEAC,0x3F,0x3F,0xD8B1,0xBEAD,0xB9FB,0xBEAE,0xC0CB,0xBEAF,0xBEB0,0xB0D4,0xD8AA,0xD8A8,0xBEB1,0xC1DA,0x3F,0xBEB2,0x3F,0xD7FC,0xBBB4,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC2C6,0xD8BD,0xBEB3,0xC1DB,0xD8B8,0xBEB4,0xD8B5,0xD8B6,0xBEB5,0xBCE6,0xD8B9,0xD8BC,0xBEB6,0xBEB7,0x3F,0x3F},
	set60[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,0xFF,3,1,1,1,0xFF,1,3,3,1,1,3,3,1,3,1,1,1,0xFF,3,1,1,0xFF,0xFF,3,1,1,1,1,1,1,1,0xFF,3,0xFF,1,0xFF,1,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,1,1,0xFF,0xFF,1,3,3,3,1,1,3,1,0xFF,0xFF,1,3,1,0xFF,3,1,3,3,0xFF,1,1,0xFF,0xFF,3,0xFF,1,1,3,1,1,1,1,0xFF,3,1,1,1,1,1,1,0xFF,1,1,3,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,1,3,1,1,0xFF,3,0xFF,3,1,3,1,1,1,3,0xFF,0xFF,3,1,3,1,3,1,1,3,0xFF,1,1,0xFF,3,3,1,1,0xFF,3,1,3,3,1,1,3,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,1,1,1,1,1,3,1,0xFF,0xFF,3,1,1,3,0xFF,0xFF,0xFF,3,0xFF,3,1,1,1,3,3,3,3,0xFF,0xFF,3,3,0xFF,1,0xFF,1,3,3,0xFF,0xFF,1,3,1,3,1,3,3,1,1,1,3,1,0xFF,3,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,3,1,1,3,1,1,3,1,1,1,3,3,0xFF,0xFF},
	en61[] = {0xD8B7,0xBDA5,0xBEB8,0xD8BA,0x3F,0x3F,0xD8B4,0xBEB9,0xCCFC,0xCCFB,0xBEBA,0x3F,0xBEBB,0xD8BE,0xD8BF,0xB0D5,0xBEBC,0xBEBD,0xBEBE,0xBEBF,0xBEC0,0xD8B3,0xBEC1,0xBEC2,0x3F,0xBEC3,0xB6F2,0xB0A6,0xBEC4,0x3F,0xBEC5,0xB4B6,0x3F,0xD8BB,0xBEC6,0x3F,0x3F,0x3F,0x3F,0xD8C3,0xD8C2,0x3F,0xBEC7,0xBEC8,0xD8C7,0x3F,0x3F,0x3F,0xBEC9,0xBECA,0x3F,0x3F,0xD8C8,0xBECB,0xBECC,0xBECD,0x3F,0xBECE,0x3F,0x3F,0xD8C6,0xD8C9,0xD8C1,0xD8C5,0x3F,0xBECF,0xD8CA,0x3F,0xD8CB,0xBED0,0xBED1,0xD8C0,0xBBFC,0xBED2,0xD8C4,0xC2D6,0xB9B2,0xD8B2,0xBFB5,0x3F,0x3F,0x3F,0x3F,0xD8D8,0x3F,0xCAE9,0x3F,0x3F,0xD8CE,0xD8CF,0xD8D0,0x3F,0x3F,0xD8D7,0xBED3,0xD8D6,0xBED4,0x3F,0xCBFD,0xB4B7,0x3F,0xD8D4,0x3F,0xB7C5,0xB3B4,0x3F,0x3F,0xD8D1,0xBED5,0x3F,0xCEB8,0xD8D3,0xB0D6,0xD8D5,0xBED6,0xD8CC,0xD8D2,0xD8D9,0xB7C4,0xD8CD,0xBED7,0x3F,0x3F,0xBED8,0xBED9,0x3F,0xCDDD,0xBEDA,0xBEDB,0xBEDC,0xCDAB,0xBEDD,0xBEDE,0x3F,0x3F,0xD8DC,0x3F,0x3F,0xD8E0,0xBEDF,0x3F,0xBEE0,0xC1FE,0x3F,0xCEF9,0xD8E1,0xBEE1,0xBEE2,0xD8DE,0x3F,0xD8DB,0xBEE3,0xBEE4,0xD8DA,0xD8DF,0x3F,0xBEE5,0xBEE6,0x3F,0xBEE7,0xBEE8,0x3F,0x3F,0x3F,0xCAB0,0xBEE9,0x3F,0xC6B4,0xBEEA,0xB7C6,0xBEEB,0xD8E2,0xD8DD,0xBEEC,0xD8E3,0x3F,0x3F,0x3F,0xB7FB,0x3F,0x3F,0x3F,0xB2B1,0x3F,0xBEED,0xBEEE,0xD8EB,0x3F,0xBEEF,0x3F,0xB4B8,0x3F,0xBEF0,0xBEF1,0xBEF2,0xD8E9,0x3F,0x3F,0xD8EA,0xBAA9,0xD8E8,0xD8E6,0xD8E5,0xD8EC,0xD8E4,0xD8EE,0xBEF3,0xBEF4,0xB2FB,0x3F,0x3F,0x3F,0x3F,0xBEF5,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBEF6,0xBEF7,0xBEF8,0xBEF9,0x3F,0xBEFA,0xBEFB,0xD8F0,0x3F,0xBEFE,0xD8EF,0xBEFC,0x3F,0xBEFD,0x3F,0x3F,0xBFA1,0xBFA2,0x3F,0xBFA3,0x3F,0x3F,0xC4A8,0x3F,0xD8F3,0x3F,0xD8F1,0xD8E7,0xB7FC,0x3F,0xD8F2,0x3F,0xD8F6,0xD8F5,0xD8F7,0xD8F4},
	set61[] = {1,1,3,1,0xFF,0xFF,1,3,1,1,3,0xFF,3,1,1,1,3,3,3,3,3,1,3,3,0xFF,3,1,1,3,0xFF,3,1,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,3,3,1,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,3,3,3,0xFF,3,0xFF,0xFF,1,1,1,1,0xFF,3,1,0xFF,1,3,3,1,1,3,1,1,1,1,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,1,1,1,0xFF,0xFF,1,3,1,3,0xFF,1,1,0xFF,1,0xFF,1,1,0xFF,0xFF,1,3,0xFF,1,1,1,1,3,1,1,1,1,1,3,0xFF,0xFF,3,3,0xFF,1,3,3,3,1,3,3,0xFF,0xFF,1,0xFF,0xFF,1,3,0xFF,3,1,0xFF,1,1,3,3,1,0xFF,1,3,3,1,1,0xFF,3,3,0xFF,3,3,0xFF,0xFF,0xFF,1,3,0xFF,1,3,1,3,1,1,3,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,3,3,1,0xFF,3,0xFF,1,0xFF,3,3,3,1,0xFF,0xFF,1,1,1,1,1,1,1,1,3,3,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,3,3,0xFF,3,3,1,0xFF,3,1,3,0xFF,3,0xFF,0xFF,3,3,0xFF,3,0xFF,0xFF,1,0xFF,1,0xFF,1,1,1,0xFF,1,0xFF,1,1,1,1},
	en62[] = {0xD8F8,0xBFA4,0x3F,0xBFA5,0xBFA6,0x3F,0x3F,0xBFA7,0xD8F9,0xD8FA,0xCAEA,0x3F,0xD8FC,0xD8FB,0xBDBF,0x3F,0xC0AE,0xB2E6,0xB2FC,0xBFA8,0xD8FD,0xBFA9,0xB0BF,0x3F,0x3F,0x3F,0xC0CC,0xD8FE,0xBFAA,0xECC3,0xD9A1,0xB7E1,0xBFAB,0xD9A2,0xBFAC,0xBFAD,0x3F,0x3F,0xC0EF,0xBFAE,0x3F,0xBFAF,0xD9A3,0xBFB0,0x3F,0x3F,0xD9A4,0xB5BA,0xD9A5,0x3F,0xD9A6,0xD9A7,0xC2D7,0x3F,0x3F,0x3F,0xB8CD,0xBFB1,0x3F,0xCCE1,0x3F,0xBFB2,0x3F,0xCBBC,0xBDEA,0xD9A8,0xBFB3,0xBFB4,0xBFB5,0x3F,0xBFB6,0xC0F0,0xEEBD,0xC8E2,0x3F,0xBCEA,0xBFB7,0xBACD,0xD9A9,0x3F,0xBFB8,0xBFB9,0xBFBA,0xC2C7,0xBFBB,0xCAA7,0xBFBC,0x3F,0xC2F1,0x3F,0xBFBD,0xD9AC,0xBFBE,0x3F,0xD9AA,0x3F,0xD9AD,0x3F,0x3F,0xD9AB,0xBFBF,0x3F,0x3F,0x3F,0xD9AE,0x3F,0x3F,0x3F,0x3F,0xBFC0,0xCAB1,0xBFC1,0x3F,0xB0B7,0x3F,0xBFC2,0x3F,0x3F,0xC9DE,0x3F,0x3F,0xC8E3,0xBFC3,0x3F,0xD9AF,0xBFC4,0xD9B2,0xBEB5,0xB5BB,0x3F,0xD9B0,0xD9B7,0xBEB6,0x3F,0x3F,0x3F,0x3F,0xD9B1,0xC7C4,0x3F,0x3F,0xBFC5,0xBFC6,0xBFC7,0xBFC8,0xCDDE,0xD9B3,0xD9B4,0xD9B8,0xC5EA,0xD9B5,0xB9B3,0xC0DE,0x3F,0x3F,0xD9C6,0xC8B4,0x3F,0xC2F2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBFC9,0x3F,0xBFCA,0x3F,0x3F,0xC8E4,0xDAAD,0x3F,0x3F,0x3F,0x3F,0xCAFA,0x3F,0xBFCB,0x3F,0xC4F1,0xBFCC,0xBFCD,0x3F,0xCBF5,0xBFCE,0xD9BB,0xB2A1,0xC3EA,0xBFCF,0xBFD0,0x3F,0x3F,0xD9C4,0x3F,0xBFD1,0xC3B4,0xD9BE,0xD9C5,0xD9C0,0xD9C7,0xD9C3,0x3F,0xD9C2,0xC7EF,0xBFD2,0xD9BC,0xB2FD,0xD9BA,0xB5F1,0xC2F3,0xD9B6,0xBFD3,0xBFD4,0xD9B9,0xB9B4,0xC0DB,0xBFD5,0xBEB7,0xD9C1,0xC7D2,0x3F,0x3F,0xB5F2,0xB3C8,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBFD6,0x3F,0xB3E7,0xBFA1,0xD9C9,0xD9CE,0x3F,0xD9CA,0xBFD7,0xB7FD,0xBFD8,0xD9CF,0xBBA2,0xB9E9,0x3F,0x3F,0x3F,0x3F,0xBFD9,0xBFDA,0xBDA6,0xD9BD},
	set62[] = {1,3,0xFF,3,3,0xFF,0xFF,3,1,1,1,0xFF,1,1,1,0xFF,1,1,1,3,1,3,1,0xFF,0xFF,0xFF,1,1,3,1,1,1,3,1,3,3,0xFF,0xFF,1,3,0xFF,3,1,3,0xFF,0xFF,1,1,1,0xFF,1,1,1,0xFF,0xFF,0xFF,1,3,0xFF,1,0xFF,3,0xFF,1,1,1,3,3,3,0xFF,3,1,1,1,0xFF,1,3,1,1,0xFF,3,3,3,1,3,1,3,0xFF,1,0xFF,3,1,3,0xFF,1,0xFF,1,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,1,3,0xFF,1,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,1,3,0xFF,1,3,1,1,1,0xFF,1,1,1,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,3,3,3,3,1,1,1,1,1,1,1,1,0xFF,0xFF,1,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,1,3,3,0xFF,1,3,1,1,1,3,3,0xFF,0xFF,1,0xFF,3,1,1,1,1,1,1,0xFF,1,1,3,1,1,1,1,1,1,3,3,1,1,1,3,1,1,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,1,1,1,0xFF,1,3,1,3,1,1,1,0xFF,0xFF,0xFF,0xFF,3,3,1,1},
	en63[] = {0x3F,0xBBFD,0xD9CC,0xBFDB,0xBFDC,0x3F,0x3F,0xBBD8,0xD9CD,0xB0C4,0xBFDD,0xBFDE,0xD9C8,0xBFDF,0x3F,0x3F,0xBFE0,0xC4A9,0x3F,0xBFE1,0x3F,0x3F,0xBFE2,0x3F,0xBFE3,0xB5F3,0x3F,0x3F,0x3F,0x3F,0x3F,0xB6B4,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD9CB,0xB0A7,0xBFE4,0xBFE5,0xBAC3,0x3F,0xBFE6,0x3F,0xBFB6,0x3F,0x3F,0x3F,0x3F,0x3F,0xBFE7,0xBFE8,0x3F,0x3F,0xBFE9,0xC4F2,0x3F,0xBFEA,0xC8D4,0xD9D1,0xC1DE,0x3F,0xBFEB,0xBFEC,0xBFED,0xBFEE,0x3F,0xBFEF,0x3F,0x3F,0xC2AA,0xBFF0,0xBFF1,0xBBAB,0xD9D2,0xBFF2,0xD9D4,0xD9D0,0x3F,0xBFF3,0xBFF4,0xBFF5,0xCAE1,0x3F,0xC4BD,0xBFF6,0x3F,0x3F,0xBFF7,0xC1DC,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBFF8,0xBFF9,0xCAFB,0xBCCE,0xD9E0,0x3F,0xD9DF,0xBFFA,0xBFFB,0xBFF8,0x3F,0x3F,0xBFFC,0xB7FE,0x3F,0xBFFD,0xBFFE,0xD9D9,0xBEB9,0xC0A1,0x3F,0xC6E8,0xC7B1,0xC0A2,0xC0A3,0x3F,0xC0A4,0xD9D7,0x3F,0xC0A5,0xC1DD,0xC0A6,0x3F,0x3F,0xC0A7,0xBCF8,0xD9DC,0xC0A8,0x3F,0xBEB8,0x3F,0xD9D6,0xD9DB,0xC0A9,0x3F,0xC7D3,0x3F,0xC0AA,0xC0AB,0xD9D5,0x3F,0xB7A1,0xC0AC,0xC0AD,0xB3DD,0x3F,0x3F,0xC0AE,0xD9DD,0xCEAB,0xBACE,0xC3B5,0xD9DA,0xC0AF,0xC0DC,0xC0B0,0xB9B5,0xBFE4,0xB1E6,0xC1BC,0xD9D8,0xB5C5,0xC0B1,0xC0B2,0xC0B3,0x3F,0x3F,0xB7C7,0x3F,0xC4CF,0xD9DE,0x3F,0x3F,0x3F,0x3F,0x3F,0xC1DF,0x3F,0xC0B4,0xD9E1,0x3F,0xD9E3,0xC0B5,0x3F,0xC2B7,0xD9E9,0xC0B6,0xD9E4,0x3F,0xC0B7,0xD9E6,0x3F,0x3F,0x3F,0x3F,0xC0B8,0xC9C1,0xC4F3,0xC0B9,0xD9E7,0xC0BA,0xC0BB,0xC0BC,0xCDAC,0x3F,0x3F,0x3F,0xCDC8,0xB4B9,0xC0BD,0x3F,0x3F,0x3F,0xC0BE,0xB0AE,0x3F,0xD9E5,0x3F,0xC0BF,0x3F,0x3F,0x3F,0xD9E2,0xC0C0,0x3F,0xC0C1,0x3F,0xB4F8,0x3F,0x3F,0x3F,0xC0C2,0xC0C3,0xB1E7,0xC0C4,0xD9E8,0x3F,0xC0C5,0xC0C6,0xCDC9,0x3F,0x3F,0x3F,0x3F,0x3F},
	set63[] = {0xFF,1,1,3,3,0xFF,0xFF,1,1,1,3,3,1,3,0xFF,0xFF,3,1,0xFF,3,0xFF,0xFF,3,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,3,3,1,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,3,1,0xFF,3,1,1,1,0xFF,3,3,3,3,0xFF,3,0xFF,0xFF,1,3,3,1,1,3,1,1,0xFF,3,3,3,1,0xFF,1,3,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,1,1,1,0xFF,1,3,3,1,0xFF,0xFF,3,1,0xFF,3,3,1,1,3,0xFF,1,1,3,3,0xFF,3,1,0xFF,3,1,3,0xFF,0xFF,3,1,1,3,0xFF,1,0xFF,1,1,3,0xFF,1,0xFF,3,3,1,0xFF,1,3,3,1,0xFF,0xFF,3,1,1,1,1,1,3,1,3,1,1,1,1,1,1,3,3,3,0xFF,0xFF,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,1,0xFF,1,3,0xFF,1,1,3,1,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,3,1,1,3,1,3,3,3,1,0xFF,0xFF,0xFF,1,1,3,0xFF,0xFF,0xFF,3,1,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,1,3,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,3,3,1,3,1,0xFF,3,3,1,0xFF,0xFF,0xFF,0xFF,0xFF},
	en64[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD9EC,0x3F,0x3F,0xC0C7,0xC0C8,0x3F,0x3F,0xC2BB,0x3F,0xD9F3,0xC0C9,0x3F,0xC0CA,0xD9ED,0xC0CB,0x3F,0xD9EA,0xD9F1,0xC0CC,0x3F,0x3F,0x3F,0xD9D3,0x3F,0xC0CD,0x3F,0xC0CE,0x3F,0xC0CF,0x3F,0xC0D0,0xC0D1,0xD9EE,0x3F,0xD9F2,0xC0D2,0xC0D3,0x3F,0xC8C2,0xC5EB,0x3F,0xC0D4,0xC0D5,0x3F,0x3F,0x3F,0xD9EB,0xC0D6,0xD9EF,0x3F,0x3F,0x3F,0xB7C8,0x3F,0x3F,0xC0D7,0xBAF1,0xC0D8,0x3F,0x3F,0xC0DD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC0D9,0x3F,0x3F,0xD9F7,0xC0DA,0x3F,0xC0DB,0xC0DC,0xC0DD,0xC0DE,0x3F,0x3F,0x3F,0xC5A6,0x3F,0xC0DF,0xC0E0,0xC0E1,0xC0E2,0x3F,0xC0E3,0xC0E4,0xC0E5,0x3F,0xC0E6,0x3F,0x3F,0x3F,0xD9F4,0x3F,0xCBE0,0x3F,0x3F,0x3F,0xC0E7,0x3F,0xD9F5,0x3F,0x3F,0x3F,0xC0E8,0xC0E9,0x3F,0xD9F6,0x3F,0xCCCE,0x3F,0xC0A2,0xC0EA,0x3F,0xC0EB,0x3F,0x3F,0x3F,0x3F,0x3F,0xB7E2,0x3F,0xC0EC,0x3F,0xC0ED,0xD9FD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC0EE,0xC0EF,0xC0F0,0xBBB5,0xD9FA,0x3F,0xD9F9,0x3F,0x3F,0xC0F1,0xC0F2,0xC7B2,0xC0F3,0x3F,0xC0F4,0xC6B5,0xC0F5,0x3F,0xC0F6,0x3F,0xC0F7,0xC5B1,0xD9FB,0xC0F8,0x3F,0xC0F9,0xD9FC,0x3F,0xC9EF,0xC0FA,0xC7C5,0xBBA3,0x3F,0xC0F1,0x3F,0xCBD0,0xC0FB,0x3F,0x3F,0x3F,0x3F,0x3F,0xB3C9,0x3F,0xDAA5,0xD9FE,0xC0FC,0xC0FD,0xC0FE,0x3F,0xCDCA,0xDAA7,0x3F,0xC1A1,0xDAA3,0x3F,0xDAA4,0x3F,0xC1A2,0xC1A3,0xC1A4,0xC1A5,0xC1E0,0xC1A6,0x3F,0xC1A7,0xC1A8,0xDAA2,0x3F,0xD9BF,0xC1A9,0x3F,0xC1AA,0xDAA6,0x3F,0xDAA1,0x3F,0x3F,0x3F,0x3F,0x3F,0xDAAB,0xDAAC,0xC5A7,0xDAAE,0xC1AB,0xC1AC,0xBBA4,0xDAA9,0x3F,0xC1AD,0xC1AE,0x3F,0xB5BC,0xC1AF,0x3F,0xDAAF,0xC1B0,0xDAA8,0xDAB3,0x3F,0xDAB2,0xC1B1,0xDAB1,0xC1B2,0x3F,0x3F,0xDAB4,0xC1B3,0x3F,0xDAB6,0xBEF1,0xC1B4},
	set64[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,3,0xFF,0xFF,1,0xFF,1,3,0xFF,3,1,3,0xFF,1,1,3,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,3,0xFF,3,0xFF,3,3,1,0xFF,1,3,3,0xFF,1,1,0xFF,3,3,0xFF,0xFF,0xFF,1,3,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,1,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,3,0xFF,3,3,3,3,0xFF,0xFF,0xFF,1,0xFF,3,3,3,3,0xFF,3,3,3,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,3,3,0xFF,1,0xFF,1,0xFF,1,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,3,1,1,0xFF,1,0xFF,0xFF,3,3,1,3,0xFF,3,1,3,0xFF,3,0xFF,3,1,1,3,0xFF,3,1,0xFF,1,3,1,1,0xFF,1,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,1,3,3,3,0xFF,1,1,0xFF,3,1,0xFF,1,0xFF,3,3,3,3,1,3,0xFF,3,3,1,0xFF,1,3,0xFF,3,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,1,3,3,1,1,0xFF,3,3,0xFF,1,3,0xFF,1,3,1,1,0xFF,1,3,1,3,0xFF,0xFF,1,3,0xFF,1,1,3},
	en65[] = {0xDAB5,0xC1B5,0x3F,0x3F,0xC1B6,0xDAB9,0x3F,0x3F,0xC1B7,0xC1B8,0xC1B9,0x3F,0x3F,0x3F,0x3F,0xC1BA,0x3F,0x3F,0x3F,0xC1BB,0xC1BC,0x3F,0xC1BD,0x3F,0xDAB7,0xC1BE,0x3F,0xC1BF,0xDAB8,0xD9F0,0xC1C0,0xC1C1,0x3F,0x3F,0xC1C2,0xDABB,0xDABA,0x3F,0xC1C3,0x3F,0x3F,0xC1C4,0xD9F8,0xDABC,0xDAB0,0x3F,0xC1C5,0xBBD9,0x3F,0xC1C6,0x3F,0x3F,0xDABD,0xDABE,0xDAC0,0xDABF,0xDAC1,0xB2FE,0xC1C7,0xB9B6,0xC1C8,0xC1C9,0xCAFC,0xC0AF,0x3F,0x3F,0x3F,0xC1CA,0x3F,0xB8CE,0x3F,0xC1CB,0xDAC3,0xC1CC,0x3F,0x3F,0x3F,0xDAC6,0x3F,0xC9D2,0xC1CD,0xB5DF,0xC1CE,0x3F,0xC1CF,0xDAC5,0xDAC4,0xC7D4,0xDAC7,0xB6B5,0x3F,0x3F,0x3F,0xDAC9,0xDAC8,0xC1D0,0xC1D1,0x3F,0xB4BA,0xBBB6,0x3F,0x3F,0xC6D8,0xC1D2,0x3F,0x3F,0x3F,0xC1D3,0xB7C9,0x3F,0x3F,0x3F,0xBFF4,0x3F,0xDACA,0x3F,0xC0B0,0xC5A8,0x3F,0xC9DF,0xDACB,0x3F,0xC1D4,0x3F,0x3F,0xC1D5,0x3F,0x3F,0x3F,0xC1D6,0xDACC,0xDACD,0x3F,0xC1D7,0x3F,0xCAB8,0xD5DD,0xC0C6,0xC1D8,0x3F,0xC9CC,0x3F,0xBAD8,0x3F,0xC8E5,0xC8C3,0xC1D9,0x3F,0x3F,0xC1DA,0x3F,0xC5CD,0xC1DB,0xCEC1,0x3F,0xDACF,0xBCD0,0xC1DC,0x3F,0xDAD0,0xC1DD,0xB0B6,0x3F,0xC1DE,0xB6D4,0xC0CD,0xC1DF,0xC9E0,0x3F,0x3F,0x3F,0xDAD1,0xBBC2,0xC3C7,0xC1E0,0xBBDB,0xBFB7,0x3F,0xC1E1,0xC1E2,0xC1E3,0x3F,0x3F,0xDAD2,0x3F,0xCAFD,0x3F,0x3F,0xB1F7,0xBBDC,0x3F,0xC1E4,0x3F,0xDAD5,0xC1E5,0xDAD3,0xDAD6,0xCEB9,0xDAD4,0x3F,0xC1E6,0xC1E7,0x3F,0xC0FB,0xDAD7,0x3F,0xC1E8,0xC2B2,0xC1E9,0x3F,0xDAD8,0x3F,0xC1EA,0x3F,0xC1EB,0xB4FA,0xC1EC,0xDADA,0x3F,0xDAD9,0x3F,0x3F,0x3F,0xC1ED,0xDADB,0xDADC,0xB4FB,0x3F,0x3F,0xC6FC,0xC3B6,0xB5EC,0xBBDD,0xC1E1,0x3F,0x3F,0xBDDC,0xB0B0,0x3F,0x3F,0xC1EE,0xDADD,0xC1EF,0x3F,0xC1F0,0xC1F1,0x3F,0x3F,0x3F,0xC1F2,0xB2A2,0xDAE1,0x3F,0x3F,0xC1F3,0xC1F4},
	set65[] = {1,3,0xFF,0xFF,3,1,0xFF,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,3,0xFF,3,0xFF,1,3,0xFF,3,1,1,3,3,0xFF,0xFF,3,1,1,0xFF,3,0xFF,0xFF,3,1,1,1,0xFF,3,1,0xFF,3,0xFF,0xFF,1,1,1,1,1,1,3,1,3,3,1,1,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,3,1,3,0xFF,0xFF,0xFF,1,0xFF,1,3,1,3,0xFF,3,1,1,1,1,1,0xFF,0xFF,0xFF,1,1,3,3,0xFF,1,1,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,1,1,0xFF,1,1,0xFF,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,1,1,0xFF,3,0xFF,1,1,1,3,0xFF,1,0xFF,1,0xFF,1,1,3,0xFF,0xFF,3,0xFF,1,3,1,0xFF,1,1,3,0xFF,1,3,1,0xFF,3,1,1,3,1,0xFF,0xFF,0xFF,1,1,1,3,1,1,0xFF,3,3,3,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,1,1,0xFF,3,0xFF,1,3,1,1,1,1,0xFF,3,3,0xFF,1,1,0xFF,3,1,3,0xFF,1,0xFF,3,0xFF,3,1,3,1,0xFF,1,0xFF,0xFF,0xFF,3,1,1,1,0xFF,0xFF,1,1,1,1,1,0xFF,0xFF,1,1,0xFF,0xFF,3,1,3,0xFF,3,3,0xFF,0xFF,0xFF,3,1,1,0xFF,0xFF,3,3},
	en66[] = {0xC1F5,0x3F,0xB9B7,0xDAE0,0xC1F6,0x3F,0xBAAB,0xBEBA,0xC1F7,0xC1F8,0xDADF,0x3F,0xBEBB,0xC1F9,0xCCC0,0xBAAA,0x3F,0xC1FA,0xC1FB,0xB0D7,0xC0CE,0xC1FC,0xC1FD,0x3F,0x3F,0x3F,0x3F,0x3F,0xDAE6,0xC1FE,0xC2A1,0xC0B1,0xB1C7,0xC2A2,0xC2A3,0xC2A4,0xC2A5,0xBDD5,0xC2A6,0xCBE6,0xBAF2,0xC2A7,0xC2A8,0xC2A9,0xC2AA,0xBEBC,0xC2AB,0xC0A7,0xC2AC,0xC2AD,0x3F,0xC2AE,0xDAE5,0xDAE3,0xDAE4,0xC2B0,0x3F,0xC2AF,0x3F,0x3F,0xC3EB,0x3F,0x3F,0xDBA6,0xC2B1,0xDAEA,0xBBFE,0xB9B8,0xDAE8,0xC2B2,0xC2B3,0x3F,0x3F,0xDAE9,0xC2B4,0xBFB8,0xC2B5,0x3F,0xC2B7,0xDAE7,0x3F,0xC2B6,0xBBAF,0x3F,0x3F,0x3F,0x3F,0xC2B8,0xC2B9,0xC2BA,0x3F,0xC2BB,0xC2BC,0xDAEC,0xDAEB,0xDAF0,0xC2BD,0xC2BE,0xDAF1,0x3F,0xDAED,0x3F,0xB3A2,0xDAEE,0xDAEF,0xC8D5,0xC2C0,0xC2C1,0xC2C2,0x3F,0xC9E1,0xB7CA,0xDAF2,0x3F,0x3F,0xC2C4,0xC0B2,0xC2C5,0xBEBD,0xC2C7,0xC2C8,0xC2C9,0xC3D2,0xC2CA,0xC2CC,0x3F,0xC2C3,0xC2C6,0xC2CB,0xB6C7,0x3F,0xDAF3,0xDAF7,0x3F,0x3F,0xB2CB,0xDAF4,0xDAF6,0x3F,0xC2CD,0xC2CE,0xC2CF,0xDAF5,0x3F,0xC2D0,0xBDEB,0xC2D1,0x3F,0x3F,0x3F,0xC3C8,0xB0C5,0xDAF8,0xC2D2,0xC2D3,0xC2D4,0xC2D5,0xDAF9,0x3F,0xC2D6,0xC2D7,0x3F,0xC4AA,0x3F,0xC2D8,0x3F,0xCEF1,0x3F,0x3F,0x3F,0x3F,0xBBC3,0x3F,0xC2D9,0xCAEB,0x3F,0x3F,0xC2DA,0xC2DB,0x3F,0xCBBD,0xC2DC,0x3F,0x3F,0xDBA2,0xDAFB,0x3F,0xC2DD,0xDAFE,0x3F,0xDAFD,0xC2DE,0xC2DF,0xDAFA,0xC2E0,0xC2E1,0xDBA1,0x3F,0x3F,0xC6DE,0xC2E2,0xDAFC,0x3F,0x3F,0xC2E3,0x3F,0xC2E4,0xC2E5,0x3F,0x3F,0x3F,0x3F,0xC2E6,0x3F,0xDBA3,0x3F,0x3F,0xBDEC,0xDBA4,0xC2E7,0xCDCB,0xC7F8,0x3F,0xC2E8,0xDBA5,0x3F,0x3F,0x3F,0x3F,0x3F,0xDBA7,0x3F,0xC2E9,0xDBA8,0x3F,0xC2EA,0xC2EB,0x3F,0xC2EC,0x3F,0xDBA9,0x3F,0xB6CA,0xB1C8,0xB9B9,0xDBAA,0x3F,0xDBAB,0xBDF1,0xC1E2,0xC2ED,0xC2BF,0xD2D8,0xC1BE,0xC1BD,0xC2D8},
	set66[] = {3,0xFF,1,1,3,0xFF,1,1,3,3,1,0xFF,1,3,1,1,0xFF,3,3,1,1,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,1,1,3,3,3,3,1,3,1,1,3,3,3,3,1,3,1,3,3,0xFF,3,1,1,1,3,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,1,3,1,1,1,1,3,3,0xFF,0xFF,1,3,1,3,0xFF,3,1,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,3,3,3,0xFF,3,3,1,1,1,3,3,1,0xFF,1,0xFF,1,1,1,1,3,3,3,0xFF,1,1,1,0xFF,0xFF,3,1,3,1,3,3,3,1,3,3,0xFF,3,3,3,1,0xFF,1,1,0xFF,0xFF,1,1,1,0xFF,3,3,3,1,0xFF,3,1,3,0xFF,0xFF,0xFF,1,1,1,3,3,3,3,1,0xFF,3,3,0xFF,1,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,1,0xFF,0xFF,3,3,0xFF,1,3,0xFF,0xFF,1,1,0xFF,3,1,0xFF,1,3,3,1,3,3,1,0xFF,0xFF,1,3,1,0xFF,0xFF,3,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,1,1,3,1,1,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,1,0xFF,3,3,0xFF,3,0xFF,1,0xFF,1,1,1,1,0xFF,1,1,1,3,3,1,1,1,1},
	en67[] = {0xBAC7,0x3F,0x3F,0xD0F2,0x3F,0xC2EE,0x3F,0xC2EF,0xB7EE,0xCDAD,0x3F,0xCAFE,0x3F,0xC9FE,0xC2F0,0xDBAC,0x3F,0x3F,0x3F,0xC2F1,0xBAF3,0xC4BF,0xDBAD,0xCFAF,0x3F,0xC2F2,0x3F,0xCBBE,0xC2F3,0xC4AB,0xDBAE,0xB4FC,0xC2F4,0x3F,0xC2F5,0x3F,0x3F,0x3F,0xDBAF,0xDBB0,0xCCDA,0x3F,0xCCA4,0xCBF6,0xCBDC,0xBBA5,0xDBB2,0x3F,0x3F,0xBCEB,0x3F,0xC2F6,0xCBD1,0x3F,0xDBB4,0xDBB7,0xDBB6,0x3F,0xB4F9,0x3F,0x3F,0xB5E0,0xC2F7,0xDBB3,0x3F,0xDBB5,0x3F,0x3F,0x3F,0xC2F8,0xDBB8,0xC2F9,0xC2FA,0xBFF9,0x3F,0x3F,0xC2FB,0x3F,0xCDFB,0xB0C9,0xBAE0,0xC2BC,0x3F,0xBCDD,0xC2FC,0xC2FD,0xBEF3,0x3F,0x3F,0xDBBB,0x3F,0x3F,0xC5CE,0xC2FE,0xDBB9,0xC2AB,0xDBBA,0xBEF2,0xCCDD,0xDBBC,0xDBBD,0xCDE8,0xC3A1,0x3F,0x3F,0x3F,0xDBC2,0x3F,0xC3A2,0xB9BA,0xC3A3,0xC7D5,0xDBBF,0xC5EC,0xDADE,0xDAE2,0xC3A4,0xB5CF,0xC3A5,0xC7C7,0x3F,0x3F,0x3F,0xC3A6,0xDBC1,0x3F,0xBEBE,0xC8C4,0x3F,0xC3A7,0x3F,0x3F,0xC3A8,0xDBC7,0x3F,0xC8FA,0x3F,0xDBBE,0x3F,0xDBC4,0xDBC3,0x3F,0xC3A9,0xC3AA,0xC0CF,0xC3AB,0x3F,0xC3AC,0x3F,0xCBED,0xC3AD,0xCED3,0xC3AE,0xC3AF,0xCBE7,0xC3B0,0xB2CC,0xBBDE,0x3F,0x3F,0xCFC8,0xDBC6,0xBFF5,0x3F,0x3F,0x3F,0xDBC5,0x3F,0x3F,0xDBC0,0x3F,0x3F,0x3F,0x3F,0x3F,0xB8CF,0xC3B1,0xC3B2,0xC3B3,0xDBCC,0xDBCA,0xC3B4,0xB2CD,0xDBC8,0xDBCE,0xDBD4,0x3F,0xC3B5,0xC3B6,0xC3B7,0x3F,0x3F,0xC3B9,0xC2C8,0xC3BA,0xC3BB,0xCAC1,0xC3BC,0xDBD6,0x3F,0xC3BD,0xC3BE,0xC9A2,0x3F,0x3F,0x3F,0xDBD5,0xC7F0,0xCBBF,0xB4BB,0xC3BF,0xC0F7,0xBDC0,0x3F,0x3F,0xC3C0,0xC4D3,0xC3C1,0xCDAE,0x3F,0xC3C2,0xDBD1,0xDBD0,0x3F,0x3F,0xC3C3,0xDBD2,0x3F,0xDBCF,0x3F,0xC3C4,0xDBD7,0x3F,0xDBCD,0x3F,0x3F,0xDBCB,0x3F,0xDBD3,0xDBC9,0xC3C5,0xC3EC,0xC3C6,0xCCF8,0xBCC6,0xBAF4,0xC3C7,0xC3C8,0x3F,0xC3B8,0x3F,0xBABA,0x3F,0x3F,0xCBEF,0xB3C1},
	set67[] = {1,0xFF,0xFF,1,0xFF,3,0xFF,3,1,1,0xFF,1,0xFF,1,3,1,0xFF,0xFF,0xFF,3,1,1,1,1,0xFF,3,0xFF,1,3,1,1,1,3,0xFF,3,0xFF,0xFF,0xFF,1,1,1,0xFF,1,1,1,1,1,0xFF,0xFF,1,0xFF,3,1,0xFF,1,1,1,0xFF,1,0xFF,0xFF,1,3,1,0xFF,1,0xFF,0xFF,0xFF,3,1,3,3,1,0xFF,0xFF,3,0xFF,1,1,1,1,0xFF,1,3,3,1,0xFF,0xFF,1,0xFF,0xFF,1,3,1,1,1,1,1,1,1,1,3,0xFF,0xFF,0xFF,1,0xFF,3,1,3,1,1,1,1,1,3,1,3,1,0xFF,0xFF,0xFF,3,1,0xFF,1,1,0xFF,3,0xFF,0xFF,3,1,0xFF,1,0xFF,1,0xFF,1,1,0xFF,3,3,1,3,0xFF,3,0xFF,1,3,1,3,3,1,3,1,1,0xFF,0xFF,1,1,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,3,1,1,3,1,1,1,1,0xFF,3,3,3,0xFF,0xFF,3,1,3,3,1,3,1,0xFF,3,3,1,0xFF,0xFF,0xFF,1,1,1,1,3,1,1,0xFF,0xFF,3,1,3,1,0xFF,3,1,1,0xFF,0xFF,3,1,0xFF,1,0xFF,3,1,0xFF,1,0xFF,0xFF,1,0xFF,1,1,3,1,3,1,1,1,3,3,0xFF,3,0xFF,1,0xFF,0xFF,1,1},
	en68[] = {0x3F,0x3F,0xC4CE,0xC6CA,0xB1C9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC0F2,0xC3CA,0x3F,0xC0B4,0xB7AA,0x3F,0xC3CB,0x3F,0x3F,0x3F,0xC3CC,0xDBD9,0xC3CD,0x3F,0xB9BB,0xB3FC,0x3F,0x3F,0x3F,0x3F,0xC3CF,0xC3CE,0xDBDB,0xB3F4,0xDBE1,0xC3D0,0xC3D1,0x3F,0xC3D2,0xC3D3,0xC3D4,0xDBDE,0xC3D5,0xC0F3,0x3F,0x3F,0x3F,0xB3CB,0xBAAC,0x3F,0xC3D6,0xB3CA,0xBACF,0x3F,0xC3D7,0xDBDC,0xB7E5,0xB7CB,0xC5ED,0xC3D8,0xC3D9,0xDBDA,0x3F,0xB0C6,0x3F,0xC3DA,0x3F,0xC3DB,0xDBDD,0xDBDF,0x3F,0xB6CD,0xB7AC,0xC3C9,0xB4BC,0xB5CB,0xC3DC,0x3F,0xC3DD,0xC3DE,0xDBE2,0x3F,0xC3DF,0xBAF9,0xCBF1,0x3F,0xBBB7,0x3F,0x3F,0x3F,0xDBE3,0x3F,0x3F,0x3F,0xC9B0,0x3F,0x3F,0x3F,0xC3E0,0x3F,0x3F,0xC3E1,0xC3E2,0xC3E3,0xC3E4,0xC3E5,0x3F,0xDBEF,0xC3E6,0xB2B3,0xDBE4,0x3F,0xC3E7,0xC3E8,0xC3E9,0xC3EA,0x3F,0xDBF5,0xDBE5,0x3F,0xCEC2,0xC3EB,0xDBEC,0xC3EC,0xC7DF,0xC3ED,0x3F,0xC3EE,0x3F,0x3F,0x3F,0x3F,0xDBF4,0x3F,0xDBE7,0x3F,0x3F,0x3F,0xB0B4,0xDBE9,0x3F,0xC3EF,0xB9BC,0xC3F0,0x3F,0xC3F1,0xDBEB,0xC3F2,0xDBEA,0x3F,0xDBE6,0xDBF1,0xC3F3,0xBEBF,0xC3F4,0x3F,0xC3F5,0xD4ED,0xB8E8,0xCDFC,0xC3F6,0xC3F7,0x3F,0x3F,0xDBE8,0xC3F8,0xC4F4,0xB3A3,0xBAAD,0xC3F9,0xDBE0,0x3F,0xDBF0,0xB3E1,0x3F,0x3F,0xDBEE,0xDBF2,0xC3FA,0xC5EE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB4FE,0xC3FB,0xDCB2,0x3F,0xC3FC,0xCCC9,0xDBF7,0xB4FD,0xC3FD,0xDBFE,0x3F,0xC3FE,0xC4A1,0xC4A2,0xCBC0,0xC4A3,0xDCA1,0xDCA3,0xC4A4,0xDCA7,0xDBF9,0xC4A5,0xC3AA,0x3F,0xC4A6,0xC4A7,0x3F,0xC5EF,0xDCAB,0xDBFC,0x3F,0xDCA8,0x3F,0xC4A8,0x3F,0xDCA2,0xC4A9,0x3F,0xC4AA,0xC4AB,0xC4AC,0xC4AD,0xBFB9,0xDCAC,0xC4AE,0xC4AF,0xC0B3,0x3F,0x3F,0xC4B0,0xC4B1,0x3F,0x3F,0xDCAA,0xB4BD,0xC4B2,0xC4B3,0xC4B4,0x3F,0x3F},
	set68[] = {0xFF,0xFF,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,1,1,0xFF,3,0xFF,0xFF,0xFF,3,1,3,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,3,3,1,1,1,3,3,0xFF,3,3,3,1,3,1,0xFF,0xFF,0xFF,1,1,0xFF,3,1,1,0xFF,3,1,1,1,1,3,3,1,0xFF,1,0xFF,3,0xFF,3,1,1,0xFF,1,1,3,1,1,3,0xFF,3,3,1,0xFF,3,1,1,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,3,3,3,3,0xFF,1,3,1,1,0xFF,3,3,3,3,0xFF,1,1,0xFF,1,3,1,3,1,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,1,1,0xFF,3,1,3,0xFF,3,1,3,1,0xFF,1,1,3,1,3,0xFF,3,1,1,1,3,3,0xFF,0xFF,1,3,1,1,1,3,1,0xFF,1,1,0xFF,0xFF,1,1,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,1,0xFF,3,1,1,1,3,1,0xFF,3,3,3,1,3,1,1,3,1,1,3,1,0xFF,3,3,0xFF,1,1,1,0xFF,1,0xFF,3,0xFF,1,3,0xFF,3,3,3,3,1,1,3,3,1,0xFF,0xFF,3,3,0xFF,0xFF,1,1,3,3,3,0xFF,0xFF},
	en69[] = {0xCFD0,0xDBF6,0x3F,0x3F,0xDCA6,0xB0D8,0xC4B5,0x3F,0xDBF8,0xC4B6,0xC4B7,0xCCBA,0xDBFD,0xBFA2,0xC4C7,0xDBF3,0xC4B8,0xC4B9,0xDCA5,0xC4BA,0x3F,0x3F,0xC4BB,0xC4BC,0x3F,0xBFFA,0xDCAF,0xB3F1,0xB8A1,0x3F,0x3F,0x3F,0x3F,0xDCB1,0xDBFA,0xDCB0,0x3F,0xDCA9,0xDBFB,0x3F,0xDCAD,0x3F,0xDCAE,0x3F,0x3F,0x3F,0x3F,0x3F,0xDCBF,0xC4BD,0x3F,0xC4BE,0xC6CE,0xC4BF,0xDCA4,0x3F,0xC4C0,0xDCBB,0x3F,0xC4C1,0x3F,0xDCBD,0x3F,0xC4D8,0x3F,0x3F,0xC4C2,0x3F,0x3F,0xC4C3,0x3F,0x3F,0x3F,0xC4C4,0xCDCC,0x3F,0x3F,0x3F,0xC4C5,0x3F,0x3F,0x3F,0x3F,0xC9F6,0xDCB8,0xC2CA,0x3F,0xC4C6,0x3F,0xDCBE,0xC1BF,0xC4C7,0xDCB5,0xDCC2,0xDCC1,0x3F,0xC6EF,0xDCC0,0xC6EA,0xC4C8,0xC4C9,0xC4CA,0xC4CB,0x3F,0xC4CC,0xC4CD,0xDCC4,0xDCB7,0xC4CE,0xB6C8,0xDCBA,0xBDDD,0xC4CF,0xC4D0,0xC4D1,0xC7E0,0xDCBC,0xB6CB,0x3F,0xDCB4,0xDCB6,0xDCB3,0xC4D2,0xC4D3,0xCFB0,0xB3DA,0xDCB9,0xC4D4,0xC4D5,0xDCC3,0xB3B5,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBAE7,0x3F,0x3F,0xC4D6,0xB1DD,0x3F,0x3F,0xDCD4,0xC4D7,0x3F,0xCFB1,0xDCD7,0xC4D8,0x3F,0xC4D9,0x3F,0x3F,0xBFBA,0xDCD6,0x3F,0x3F,0x3F,0xDCD5,0xC4DA,0x3F,0x3F,0x3F,0xC4DB,0xC4DC,0xDCD2,0xC4DD,0x3F,0x3F,0xC4DE,0x3F,0xC4DF,0xDCC6,0xC4E0,0x3F,0xDCE3,0xDCC5,0x3F,0xDCD8,0x3F,0x3F,0xC4E1,0xC4E2,0x3F,0xC4E3,0xDCD0,0xC4E4,0x3F,0xDCCB,0xDCC8,0x3F,0xDCC9,0x3F,0xDCD1,0x3F,0xC4E5,0x3F,0xF4A2,0xC4E6,0x3F,0xDCCE,0xB9BD,0xC4C8,0xC1E4,0xDCCC,0x3F,0xDCC7,0xC4E7,0x3F,0xDCCA,0x3F,0x3F,0xC4E8,0xC4E9,0xCDCD,0xCBEA,0x3F,0x3F,0x3F,0xDCCF,0xDCD9,0x3F,0x3F,0x3F,0xC4EA,0x3F,0x3F,0xC4EB,0x3F,0xDCE1,0xDCDA,0x3F,0x3F,0xDCE7,0x3F,0xDCE5,0xC4EC,0xC4ED,0x3F,0xC4EE,0xDCE0,0xC4EF,0x3F,0xC4F0,0x3F,0x3F,0x3F,0xDCDF,0x3F,0xC4D0,0x3F,0xC1E5,0xC4F1,0xDCDD},
	set69[] = {1,1,0xFF,0xFF,1,1,3,0xFF,1,3,3,1,1,1,1,1,3,3,1,3,0xFF,0xFF,3,3,0xFF,1,1,1,1,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF,1,1,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,3,1,3,1,0xFF,3,1,0xFF,3,0xFF,1,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF,3,0xFF,1,1,3,1,1,1,0xFF,1,1,1,3,3,3,3,0xFF,3,3,1,1,3,1,1,1,3,3,3,1,1,1,0xFF,1,1,1,3,3,1,1,1,3,3,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,1,0xFF,0xFF,1,3,0xFF,1,1,3,0xFF,3,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,3,3,1,3,0xFF,0xFF,3,0xFF,3,1,3,0xFF,1,1,0xFF,1,0xFF,0xFF,3,3,0xFF,3,1,3,0xFF,1,1,0xFF,1,0xFF,1,0xFF,3,0xFF,1,3,0xFF,1,1,1,1,1,0xFF,1,3,0xFF,1,0xFF,0xFF,3,3,1,1,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,1,1,0xFF,0xFF,1,0xFF,1,3,3,0xFF,3,1,3,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,1,3,1},
	en6A[] = {0xC4F2,0xC4F3,0xDCDB,0xC4F4,0x3F,0xDCE2,0x3F,0x3F,0x3F,0x3F,0xDCE8,0xC8F5,0xDCEE,0x3F,0x3F,0xC4F5,0x3F,0xC4F6,0xDCE9,0xDCEC,0xDCE6,0xC4F7,0x3F,0xC3F4,0x3F,0xC9B8,0xC4F8,0xDCDC,0x3F,0xC4F9,0xDCE4,0xBEC0,0xC4FA,0xCCCF,0xDCF8,0xDCEB,0xC4FB,0x3F,0x3F,0x3F,0xC4FC,0xB8A2,0xB2A3,0xB3DF,0x3F,0x3F,0xDCD3,0x3F,0xC4FD,0x3F,0xC4FE,0x3F,0xC5A1,0xBEC1,0xDCF0,0xC5A2,0xDCF7,0xBCF9,0xB3F2,0xC5A3,0x3F,0xC3AE,0xC5A4,0xC5A5,0x3F,0x3F,0x3F,0x3F,0xDCED,0xC5A6,0xC5A7,0xDCF2,0xDCF6,0xC5A8,0xC5A9,0xB6B6,0x3F,0x3F,0xC5AA,0x3F,0xC5AB,0xC5AC,0xC5AD,0x3F,0x3F,0xC5AE,0xC5AF,0x3F,0xB5CC,0xDCF4,0x3F,0xC5B0,0x3F,0x3F,0x3F,0xB5A1,0x3F,0xC6CB,0xDCF3,0x3F,0xC5B1,0x3F,0xDCF5,0xC5B2,0x3F,0x3F,0xC5B3,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC5B4,0xDCEF,0xC5B5,0x3F,0x3F,0x3F,0x3F,0xDCF1,0x3F,0x3F,0x3F,0x3F,0x3F,0xC5B6,0xB3E0,0xC3C9,0xC5B7,0x3F,0xC5B8,0xDCFC,0x3F,0xC5B9,0xC5BA,0x3F,0xC5BB,0x3F,0xC5BC,0x3F,0xDCFA,0xB8E9,0x3F,0xDCF9,0xC5BD,0x3F,0x3F,0x3F,0x3F,0x3F,0xDDA1,0x3F,0x3F,0x3F,0xC5BE,0xDBD8,0xC5BF,0xC5C0,0xC5C1,0xDCFB,0x3F,0xDCFD,0xDCFE,0x3F,0xC5C2,0x3F,0x3F,0x3F,0x3F,0xDDAC,0xC5C3,0xDDA8,0x3F,0xDBED,0xC5C4,0xC5C5,0xC5C6,0x3F,0xDDA7,0xC5C7,0x3F,0x3F,0x3F,0xDDA6,0x3F,0x3F,0xDDA3,0x3F,0xC5C8,0xC5C9,0xC5CA,0x3F,0xDCEA,0xDDA5,0xDDA4,0x3F,0x3F,0xC5CB,0x3F,0xC5CD,0xC5CC,0x3F,0x3F,0xC5CE,0x3F,0x3F,0x3F,0xC5CF,0xDDAA,0x3F,0xCFA6,0xC5D0,0xC5D1,0xC5D2,0x3F,0x3F,0x3F,0xDDAD,0xB6FB,0xC5D3,0xC5D4,0xDDA9,0xDDAB,0x3F,0x3F,0x3F,0x3F,0xC5D5,0x3F,0x3F,0xC5D6,0xC8A7,0x3F,0xDDAE,0x3F,0xC5D7,0x3F,0x3F,0x3F,0xC5D8,0xC5D9,0xC5DA,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xDDB2,0xDDAF,0xC5DB,0xC5DC,0x3F,0x3F},
	set6A[] = {3,3,1,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF,0xFF,3,0xFF,3,1,1,1,3,0xFF,1,0xFF,1,3,1,0xFF,3,1,1,3,1,1,1,3,0xFF,0xFF,0xFF,3,1,1,1,0xFF,0xFF,1,0xFF,3,0xFF,3,0xFF,3,1,1,3,1,1,1,3,0xFF,1,3,3,0xFF,0xFF,0xFF,0xFF,1,3,3,1,1,3,3,1,0xFF,0xFF,3,0xFF,3,3,3,0xFF,0xFF,3,3,0xFF,1,1,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,1,1,0xFF,3,0xFF,1,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,1,3,0xFF,3,1,0xFF,3,3,0xFF,3,0xFF,3,0xFF,1,1,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,1,3,3,3,1,0xFF,1,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,3,1,0xFF,1,3,3,3,0xFF,1,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,3,3,3,0xFF,1,1,1,0xFF,0xFF,3,0xFF,3,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,1,0xFF,1,3,3,3,0xFF,0xFF,0xFF,1,1,3,3,1,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,1,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,3,3,0xFF,0xFF},
	en6B[] = {0x3F,0x3F,0xC5DD,0xC5DE,0xCDF3,0xDDB0,0xC5DF,0xC5E0,0x3F,0xC5E1,0xDCDE,0x3F,0x3F,0x3F,0x3F,0xC5E2,0xC5E3,0xC5E4,0xDDB3,0x3F,0x3F,0x3F,0xDDB4,0xC5E5,0x3F,0x3F,0x3F,0xC5E6,0x3F,0xB1B5,0xC5E7,0xDDB6,0xB7E7,0xBCA1,0x3F,0xB6D5,0xC5E8,0x3F,0x3F,0xB2A4,0xC5E9,0x3F,0x3F,0xC5EA,0xC5EB,0x3F,0x3F,0xC5EC,0x3F,0x3F,0xCDDF,0x3F,0x3F,0xC5ED,0xC5EE,0xDDB8,0xDDB7,0xDDBA,0xB5BD,0xC5EF,0x3F,0xB6D6,0xB4BE,0xC5F0,0x3F,0x3F,0x3F,0xDDBD,0x3F,0x3F,0xC5F1,0xDDBC,0x3F,0xDDBE,0xC5F2,0x3F,0xB2CE,0xC5F3,0xC3B7,0x3F,0xDDBF,0x3F,0xC5F4,0xB4BF,0xDDC1,0x3F,0xC5F5,0x3F,0xC5F6,0xDDC0,0x3F,0xDDC2,0x3F,0xC5F7,0x3F,0xDDC3,0xC5F8,0xDDC4,0xBBDF,0xC0B5,0xBAA1,0x3F,0xC9F0,0xC5F9,0x3F,0xCAE2,0xCFC4,0xC5FA,0x3F,0x3F,0xC5FB,0xBBF5,0xC5FC,0x3F,0x3F,0xBAD0,0xCEF2,0xC5FD,0x3F,0x3F,0xDDC5,0xDDC6,0x3F,0xBBE0,0x3F,0xC5FE,0xC6A1,0xDDC7,0xDDC8,0x3F,0xC6A2,0xDDCA,0xDDC9,0xC6A3,0xCBD8,0x3F,0x3F,0xBDDE,0xBCEC,0xBBC4,0x3F,0xDDCB,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xDDCD,0xBFA3,0xC6A4,0xDDCC,0x3F,0x3F,0xC6A5,0x3F,0x3F,0xDDCE,0xC6A6,0xC6A7,0x3F,0xC6A8,0xC6A9,0xDDCF,0x3F,0x3F,0x3F,0xC6AA,0xC6AB,0xDDD0,0xDDD1,0xC6AC,0xC6AD,0xC6AE,0xDDD2,0xC6AF,0xDDD4,0xDDD3,0xDDD5,0xB2A5,0xC3CA,0x3F,0xDDD6,0xC6B0,0xC6B1,0xBBA6,0xB3CC,0xDDD7,0xC6B2,0xC6B3,0xC5C2,0xD4CC,0x3F,0x3F,0xC6B4,0xC6B5,0xB5A3,0xDDD8,0x3F,0x3F,0xC6B6,0x3F,0xDDD9,0xC6B7,0xCAEC,0xCBE8,0x3F,0x3F,0x3F,0xC6C7,0xDDDA,0xC8E6,0x3F,0xC6B8,0x3F,0xC8FB,0x3F,0xC6B9,0xCCD3,0x3F,0x3F,0x3F,0xDDDB,0x3F,0xC6BA,0x3F,0xC6BB,0x3F,0x3F,0xC6BC,0xC6BD,0x3F,0x3F,0x3F,0xDDDD,0xDDDC,0x3F,0xC6BE,0xDDDF,0x3F,0xC6BF,0x3F,0xDDDE,0x3F,0x3F,0x3F,0xC6C0,0x3F,0xC6C1,0x3F,0x3F,0x3F,0x3F,0x3F,0xC6C2},
	set6B[] = {0xFF,0xFF,3,3,1,1,3,3,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,3,3,3,1,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,3,0xFF,1,3,1,1,1,0xFF,1,3,0xFF,0xFF,1,3,0xFF,0xFF,3,3,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,3,3,1,1,1,1,3,0xFF,1,1,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,1,0xFF,1,3,0xFF,1,3,1,0xFF,1,0xFF,3,1,1,0xFF,3,0xFF,3,1,0xFF,1,0xFF,3,0xFF,1,3,1,1,1,1,0xFF,1,3,0xFF,1,1,3,0xFF,0xFF,3,1,3,0xFF,0xFF,1,1,3,0xFF,0xFF,1,1,0xFF,1,0xFF,3,3,1,1,0xFF,3,1,1,3,1,0xFF,0xFF,1,1,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,3,1,0xFF,0xFF,3,0xFF,0xFF,1,3,3,0xFF,3,3,1,0xFF,0xFF,0xFF,3,3,1,1,3,3,3,1,3,1,1,1,1,1,0xFF,1,3,3,1,1,1,3,3,1,1,0xFF,0xFF,3,3,1,1,0xFF,0xFF,3,0xFF,1,3,1,1,0xFF,0xFF,0xFF,1,1,1,0xFF,3,0xFF,1,0xFF,3,1,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,3,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,1,1,0xFF,3,1,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,3},
	en6C[] = {0x3F,0x3F,0xC6C3,0x3F,0xC6C4,0xC6C5,0x3F,0x3F,0xDDE1,0xC6C6,0x3F,0x3F,0x3F,0xC6C7,0xC6C8,0xBBE1,0xC6C9,0xCCB1,0xC6CA,0xDDE2,0xDDE3,0x3F,0x3F,0xB5A4,0x3F,0xC6CB,0x3F,0xDDE4,0x3F,0x3F,0x3F,0xC6CC,0x3F,0x3F,0x3F,0xDDE6,0xDDE5,0x3F,0xC6CD,0xC6CE,0xC6CF,0x3F,0x3F,0x3F,0xC6D0,0x3F,0xC6D1,0x3F,0x3F,0x3F,0x3F,0xC6D2,0xBFE5,0xC6D3,0xC6D4,0xC9B9,0xB1CA,0x3F,0xC6D5,0xC6D6,0x3F,0x3F,0xC8C5,0xC6D7,0xC4F5,0xBDC1,0xB5E1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC6D8,0xC6D9,0x3F,0xC6DA,0xC8C6,0xC6DB,0xBCAE,0x3F,0xC6DC,0x3F,0xC6DD,0xDDE8,0x3F,0xB4C0,0x3F,0xC6DE,0xB1F8,0xC6DF,0xC6E0,0xC6F2,0xDDE7,0xB9BE,0xC3D3,0x3F,0xDDE9,0x3F,0x3F,0x3F,0x3F,0xC7B6,0xDDF1,0x3F,0xDDEA,0xC6E1,0x3F,0xC6E2,0x3F,0xC6E3,0xC2C1,0x3F,0xB5E2,0xDDF2,0xC6E4,0x3F,0xC6E5,0x3F,0xC6E6,0xC6E7,0xB7E8,0xC6E8,0x3F,0xB5A5,0xDDF0,0x3F,0x3F,0xDDEE,0xDDEB,0xCDE0,0x3F,0xC6E9,0xC6EA,0xC6EB,0xC4C0,0xC6EC,0x3F,0x3F,0xC6D9,0xDDEC,0x3F,0x3F,0xDDF4,0x3F,0xDDF3,0xB7A3,0xC6ED,0xC6EE,0xB2AD,0xC6EF,0xC6F0,0xBABB,0xDDED,0xDDEF,0xC6F1,0x3F,0x3F,0xC6F2,0x3F,0xCBD7,0xC2F4,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCBF7,0x3F,0x3F,0xDDFC,0x3F,0xC6F3,0xDDFD,0xC6F4,0xB2CF,0xC6F5,0x3F,0x3F,0x3F,0xCAA8,0xCCFD,0xDEA1,0xBCA3,0xBEC2,0xDDF8,0xDDFE,0xB1E8,0x3F,0xB6B7,0xC6F6,0x3F,0xDDF5,0xDDFA,0xC6F7,0x3F,0x3F,0xC0F4,0xC7F1,0x3F,0xC8E7,0xC6F8,0x3F,0xC6F9,0xC6FA,0xC6FB,0xC6FC,0xDDF7,0xC6FD,0xCBA1,0xC6FE,0xDDF9,0x3F,0xDEA4,0xC7A1,0xDEA2,0xC7A2,0xDDFB,0x3F,0x3F,0xC7A3,0xCBA2,0xC7C8,0xB5E3,0x3F,0xC5A5,0x3F,0xC7A4,0xC3ED,0xC7A5,0xDEA5,0xC7A6,0xC7A7,0x3F,0xC7A8,0xDEA3,0xC2D9,0xDDF6,0xC7A9,0xB1CB,0xC7AA,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set6C[] = {0xFF,0xFF,3,0xFF,3,3,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,3,3,1,3,1,3,1,1,0xFF,0xFF,1,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,1,0xFF,3,3,3,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,1,3,3,1,1,0xFF,3,3,0xFF,0xFF,1,3,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,3,1,3,1,0xFF,3,0xFF,3,1,0xFF,1,0xFF,3,1,3,3,1,1,1,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,1,0xFF,1,3,0xFF,3,0xFF,3,1,0xFF,1,1,3,0xFF,3,0xFF,3,3,1,3,0xFF,1,1,0xFF,0xFF,1,1,1,0xFF,3,3,3,1,3,0xFF,0xFF,1,1,0xFF,0xFF,1,0xFF,1,1,3,3,1,3,3,1,1,1,3,0xFF,0xFF,3,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,3,1,3,1,3,0xFF,0xFF,0xFF,1,1,1,1,1,1,1,1,0xFF,1,3,0xFF,1,1,3,0xFF,0xFF,1,1,0xFF,1,3,0xFF,3,3,3,3,1,3,1,3,1,0xFF,1,3,1,3,1,0xFF,0xFF,3,1,1,1,0xFF,1,0xFF,3,1,3,1,3,3,0xFF,3,1,1,1,3,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en6D[] = {0x3F,0x3F,0x3F,0x3F,0xC7AB,0x3F,0x3F,0xC7AC,0x3F,0x3F,0xC7AD,0xCDCE,0xDEB0,0x3F,0xC7AE,0xC7AF,0x3F,0xC7B0,0xDEAF,0xC7B1,0x3F,0x3F,0x3F,0xC0F6,0x3F,0xDEAC,0xC7B2,0xCDEC,0x3F,0x3F,0xC6B6,0xDEA6,0x3F,0x3F,0x3F,0x3F,0x3F,0xC4C5,0xC7B3,0xC7B4,0xC7B5,0xB1CC,0xB9BF,0xDEA9,0x3F,0x3F,0xC7B7,0xC7B8,0x3F,0xC7B9,0xBDA7,0xDEAE,0x3F,0xDEAD,0xDEA8,0x3F,0xDEAB,0xC7BA,0x3F,0xB3E8,0xC7BB,0xDEAA,0xC7C9,0xC7BC,0x3F,0xCEAE,0x3F,0x3F,0xBEF4,0xC0F5,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC7BD,0x3F,0xDEB6,0xDEB4,0x3F,0xC9CD,0x3F,0xC7BE,0xC7BF,0x3F,0xC7C0,0x3F,0xDEB1,0xDEB3,0xC7C1,0xB1BA,0xC7C2,0x3F,0xB9C0,0xCFB2,0x3F,0xB3BD,0x3F,0xC9E2,0xC7C3,0xC7C4,0x3F,0x3F,0x3F,0xCDE1,0x3F,0x3F,0xB3A4,0xBFBB,0xDEB5,0x3F,0x3F,0xC7C5,0x3F,0x3F,0x3F,0x3F,0x3F,0xC7C6,0x3F,0x3F,0xDEBA,0x3F,0xC7C7,0xBEC3,0x3F,0x3F,0x3F,0xCDB0,0x3F,0xDEB7,0x3F,0x3F,0xC7C8,0xC7C9,0xDEB2,0xC7CA,0xDEB8,0xC7CB,0xC7CC,0xC7CD,0xCEDE,0x3F,0xC5F3,0xC6C2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC7CE,0x3F,0xC7CF,0x3F,0x3F,0xB3B6,0x3F,0x3F,0xB1D5,0x3F,0xC7D0,0xDEBE,0x3F,0xC7D1,0xDEC1,0xC7D2,0x3F,0x3F,0xCEC3,0xC7D3,0x3F,0xC7D4,0xCDE4,0x3F,0x3F,0x3F,0xC7D5,0xDEC8,0xDEC2,0xDEBF,0xC7D6,0x3F,0xC7D7,0xCED4,0xDEC5,0x3F,0xC7D8,0xC7D9,0x3F,0xBDCA,0xDEC7,0x3F,0x3F,0xDECC,0xC7DA,0x3F,0xC5F1,0xDECA,0x3F,0xC7DB,0x3F,0xC7DC,0xDEC4,0xC7DD,0xC7DE,0xC3B8,0xC7DF,0x3F,0xDECB,0xC7E0,0xDEC0,0x3F,0xDEC6,0xC7E1,0xDECD,0xB0FC,0xDEC3,0x3F,0xDECE,0xC7E2,0xC7E3,0xBFBC,0x3F,0xBDDF,0xC7E4,0xCAA5,0xC7E5,0xBAAE,0x3F,0xDEBB,0xDEC9,0xC5BA,0xC7E6,0x3F,0x3F,0x3F},
	set6D[] = {0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,0xFF,3,1,1,0xFF,3,3,0xFF,3,1,3,0xFF,0xFF,0xFF,1,0xFF,1,3,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,3,1,1,1,0xFF,0xFF,3,3,0xFF,3,1,1,0xFF,1,1,0xFF,1,3,0xFF,1,3,1,1,3,0xFF,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,1,0xFF,1,0xFF,3,3,0xFF,3,0xFF,1,1,3,1,3,0xFF,1,1,0xFF,1,0xFF,1,3,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,1,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,3,1,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,3,3,1,3,1,3,3,3,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,3,1,0xFF,3,1,3,0xFF,0xFF,1,3,0xFF,3,1,0xFF,0xFF,0xFF,3,1,1,1,3,0xFF,3,1,1,0xFF,3,3,0xFF,1,1,0xFF,0xFF,1,3,0xFF,1,1,0xFF,3,0xFF,3,1,3,3,1,3,0xFF,1,3,1,0xFF,1,3,1,1,1,0xFF,1,3,3,1,0xFF,1,3,1,3,1,0xFF,1,1,1,3,0xFF,0xFF,0xFF},
	en6E[] = {0xC7E7,0x3F,0x3F,0x3F,0xC7E8,0xC0B6,0x3F,0xB3E9,0xBAD1,0xBEC4,0xDEBD,0xBDC2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB7CC,0x3F,0xDEBC,0x3F,0x3F,0x3F,0xDED2,0xBDED,0xB8BA,0x3F,0xDEE1,0xC7E9,0xDEDB,0xB5F4,0xC5CF,0xC7EA,0xDED6,0xDEDF,0xB0AF,0xB1B2,0xC7EB,0x3F,0xB2B9,0x3F,0xDED8,0xC2AC,0xDECF,0xDED1,0xB9C1,0x3F,0x3F,0xC7EC,0x3F,0x3F,0x3F,0xC7ED,0x3F,0xDEE2,0xC7EE,0xDEDD,0xC7EF,0xC7F0,0x3F,0xDED5,0x3F,0x3F,0x3F,0x3F,0xDEDC,0xC7F1,0xC7F2,0x3F,0x3F,0xC7F3,0xC7F4,0xCCAB,0xC7F5,0x3F,0xDEDA,0xDEDE,0xC7F6,0x3F,0xC7F7,0xC7F8,0xC7F9,0xC7FA,0x3F,0xB8D0,0xC7FB,0xBEC5,0x3F,0x3F,0xC3B9,0xC7FC,0xC7FD,0xC7FE,0xDED4,0x3F,0x3F,0xC8A1,0xC8A2,0x3F,0x3F,0x3F,0xCDAF,0xC8A3,0x3F,0x3F,0xDED7,0x3F,0x3F,0xDED0,0xC5F2,0x3F,0x3F,0xDED3,0xC8A4,0x3F,0x3F,0xDED9,0x3F,0x3F,0x3F,0x3F,0xC8A5,0x3F,0xC8A6,0xCFD1,0xBCBE,0xCBFE,0x3F,0xDEE3,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC8AE,0xC8A7,0x3F,0xDEEF,0xB8BB,0x3F,0x3F,0xC8A8,0x3F,0x3F,0xBDE0,0x3F,0xDEE5,0xC8A9,0x3F,0x3F,0xCEAF,0xB9C2,0x3F,0xDEF2,0xC8AA,0x3F,0xB0EE,0x3F,0x3F,0xDEF0,0x3F,0xC8AB,0x3F,0x3F,0xDEE4,0x3F,0x3F,0xC8AC,0xC8AD,0xDEEA,0x3F,0xC8AE,0xDEEC,0xC8AF,0x3F,0x3F,0xCDCF,0xDEE7,0x3F,0x3F,0xC5AE,0xC8B0,0x3F,0xDEE9,0x3F,0xC8B1,0xC8B2,0xC8B3,0xDEF1,0xC8B4,0xDEEB,0xCCC7,0x3F,0xC8B5,0xC8B6,0xDEE6,0xC8B7,0xBCA2,0xDEFE,0xC8B8,0xC8B9,0xC8BA,0x3F,0xB3EA,0x3F,0xDEE8,0xDEED,0xDEEE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC2EC,0xC2DA,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC8BB,0xDEF6,0xC8BC,0xC8BD,0xDEFC,0x3F,0x3F,0xDEFA,0x3F,0xC5A9,0x3F,0x3F,0xDFA3,0xDEF7,0xC8BE,0x3F,0xC8BF,0x3F,0xC8C0,0xDEF8,0xDEE0},
	set6E[] = {3,0xFF,0xFF,0xFF,3,1,0xFF,1,1,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,1,1,1,0xFF,1,3,1,1,1,3,1,1,1,1,3,0xFF,1,0xFF,1,1,1,1,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,1,3,1,3,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,3,3,0xFF,0xFF,3,3,1,3,0xFF,1,1,3,0xFF,3,3,3,3,0xFF,1,3,1,0xFF,0xFF,1,3,3,3,1,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,1,0xFF,0xFF,1,1,0xFF,0xFF,1,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,1,1,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,1,1,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,1,3,0xFF,0xFF,1,1,0xFF,1,3,0xFF,1,0xFF,0xFF,1,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,3,3,1,0xFF,3,1,3,0xFF,0xFF,1,1,0xFF,0xFF,1,3,0xFF,1,0xFF,3,3,3,1,3,1,1,0xFF,3,3,1,3,1,1,3,3,3,0xFF,1,0xFF,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,3,3,1,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,1,1,3,0xFF,3,0xFF,3,1,1},
	en6F[] = {0x3F,0xB5F9,0xC9BA,0x3F,0xC8C1,0x3F,0xBCBF,0x3F,0xC8C2,0xB9F7,0xC8C3,0x3F,0xC8C4,0xC8C5,0x3F,0xCFB3,0x3F,0xDEF4,0x3F,0xDFA2,0xB1E9,0xC1E6,0xC8C6,0x3F,0xC8C7,0x3F,0xC8C8,0xC8C9,0x3F,0x3F,0x3F,0x3F,0xC7F9,0x3F,0xB4C1,0xCEFA,0x3F,0x3F,0xC8CA,0x3F,0x3F,0xC8CB,0xC8CC,0xCCA1,0xC4D2,0xC8D3,0x3F,0xC8CD,0xC8CE,0xDEFB,0xDEFD,0xC8CF,0x3F,0x3F,0xC8D0,0x3F,0xC1B2,0x3F,0x3F,0xC8D1,0xC8D2,0x3F,0xDFA1,0xDEF9,0x3F,0xDEF3,0x3F,0x3F,0x3F,0xB4C3,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC8D4,0x3F,0xC8D5,0xC8D6,0xC8D7,0xB7E9,0x3F,0x3F,0xC8D8,0xDFAF,0xC8D9,0xC8DA,0xDFAA,0xC0F8,0xC8DB,0xC8DC,0xB3E3,0x3F,0xC8DD,0xC8DE,0x3F,0xBDE1,0x3F,0xDFB3,0x3F,0xC8DF,0x3F,0x3F,0x3F,0xC8E0,0xDFAC,0xC4AC,0xDFA9,0xC4D9,0x3F,0x3F,0x3F,0xDFCC,0x3F,0x3F,0x3F,0xDFA6,0x3F,0xDFA5,0x3F,0xDFAE,0xC8E1,0xC8E2,0x3F,0xDFA8,0xDFA7,0xDFAD,0xC8E3,0xC0A1,0x3F,0xDFA4,0xC8E4,0xC8E5,0x3F,0x3F,0xC8E6,0xC8E7,0xC8E8,0xDFB0,0x3F,0xC8E9,0xDFB1,0xC8EA,0xC8EB,0xC8EC,0x3F,0xC8ED,0xB4C2,0x3F,0x3F,0xC8EE,0x3F,0x3F,0x3F,0x3F,0xC8EF,0xC8F0,0xDFB6,0x3F,0xDFB5,0xDFB7,0xC8F1,0xC8F2,0xC8F3,0xC8F4,0x3F,0xDFBA,0x3F,0x3F,0x3F,0xC8F5,0xC8F6,0xC8F7,0xC5C3,0x3F,0xDFB4,0x3F,0xC8F8,0xC8F9,0x3F,0x3F,0xDFB8,0x3F,0x3F,0xC8FA,0x3F,0x3F,0x3F,0xB7E3,0xC2F9,0xDFB2,0xC7BB,0x3F,0xC8FB,0xDFB9,0xC8FC,0xC8FD,0x3F,0xC8FE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xDFBE,0xDFBC,0x3F,0x3F,0xDFBF,0x3F,0xC9A1,0xDFC2,0x3F,0x3F,0xC9A2,0xDFBB,0xB9EA,0xC7A8,0x3F,0x3F,0xDEB9,0x3F,0x3F,0x3F,0xC9A3,0xC9A4,0x3F,0xCDF4,0xDFBD,0x3F,0xDFC1,0xC2F5,0xC9A5,0xDFC0,0x3F,0xDFAB,0x3F,0xC9A6,0xEFE9,0x3F,0x3F,0xC9A7,0xDFC5,0x3F,0xC9A8,0xC9A9,0xDFC9,0x3F},
	set6F[] = {0xFF,1,1,0xFF,3,0xFF,1,0xFF,3,1,3,0xFF,3,3,0xFF,1,0xFF,1,0xFF,1,1,1,3,0xFF,3,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,1,0xFF,0xFF,3,0xFF,0xFF,3,3,1,1,3,0xFF,3,3,1,1,3,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,3,3,0xFF,1,1,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,3,3,1,0xFF,0xFF,3,1,3,3,1,1,3,3,1,0xFF,3,3,0xFF,1,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,3,1,1,1,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,1,3,3,0xFF,1,1,1,3,1,0xFF,1,3,3,0xFF,0xFF,3,3,3,1,0xFF,3,1,3,3,3,0xFF,3,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,3,1,0xFF,1,1,3,3,3,3,0xFF,1,0xFF,0xFF,0xFF,3,3,3,1,0xFF,1,0xFF,3,3,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,1,1,1,0xFF,3,1,3,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,1,0xFF,3,1,0xFF,0xFF,3,1,1,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,3,0xFF,1,1,0xFF,1,1,3,1,0xFF,1,0xFF,3,1,0xFF,0xFF,3,1,0xFF,3,3,1,0xFF},
	en70[] = {0xC9AA,0xDFC7,0x3F,0x3F,0x3F,0xC9AB,0xC9AC,0xC9AD,0x3F,0xDFC3,0x3F,0xDFC4,0x3F,0xC9AE,0x3F,0xDFC8,0x3F,0xDFC6,0x3F,0x3F,0x3F,0xC9CE,0x3F,0xC9AF,0xDFCE,0x3F,0xDFCB,0xDFCA,0x3F,0xDFCD,0xC6D4,0xDFCF,0xC9B0,0x3F,0x3F,0xC9B1,0x3F,0x3F,0xC3F5,0xC2ED,0x3F,0x3F,0x3F,0x3F,0xC0A5,0x3F,0x3F,0xC9B2,0xDFD0,0x3F,0xDFD2,0x3F,0xC9B3,0x3F,0x3F,0xC9B4,0x3F,0xC9B5,0x3F,0x3F,0xC9B6,0x3F,0xDFD1,0x3F,0x3F,0x3F,0x3F,0xC9B7,0xC9B8,0x3F,0x3F,0x3F,0xC9B9,0xC9BA,0xC9BB,0xC9BC,0xDEF5,0x3F,0xC9C1,0x3F,0x3F,0xDFD3,0x3F,0x3F,0xC9BD,0xC9BE,0x3F,0x3F,0xC6E7,0x3F,0x3F,0x3F,0x3F,0xC9BF,0xC9C0,0x3F,0x3F,0x3F,0x3F,0xDFD4,0xC9C2,0xC9C3,0x3F,0x3F,0x3F,0x3F,0x3F,0xB2D0,0xC9C4,0x3F,0xC9C5,0xC5F4,0xB3A5,0x3F,0x3F,0x3F,0x3F,0xC9C6,0xC9C7,0x3F,0xB5E4,0x3F,0x3F,0x3F,0xBCDE,0xBAD2,0xC9C8,0x3F,0x3F,0xC9C9,0x3F,0x3F,0x3F,0xC9CA,0xC9CB,0x3F,0x3F,0xCFA7,0xBFE6,0x3F,0x3F,0x3F,0xB1EA,0x3F,0x3F,0x3F,0xDFD6,0x3F,0xC9CC,0xC9CD,0xC9CE,0xC9CF,0xC9D0,0xDFD5,0x3F,0xC9D1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC9D2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC9D3,0xDFD9,0xC3BA,0xDFDC,0xDFD7,0xC9D4,0xC9D5,0x3F,0xDFDB,0xC9D6,0x3F,0x3F,0xC9D7,0xDFDA,0xC5C0,0xB0D9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCEF5,0x3F,0xC9D8,0xDFDE,0x3F,0x3F,0x3F,0xB1A8,0x3F,0xC9D9,0x3F,0xC9DA,0xC9DB,0xC9DC,0xC9DD,0x3F,0xC9DE,0xDFE0,0x3F,0x3F,0xC9DF,0xDFDF,0x3F,0xDFDD,0x3F,0x3F,0x3F,0x3F,0xC9E0,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xDFD8,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCBA3,0xC9E1,0x3F,0x3F,0xDFE2,0x3F,0x3F},
	set70[] = {3,1,0xFF,0xFF,0xFF,3,3,3,0xFF,1,0xFF,1,0xFF,3,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,3,1,0xFF,1,1,0xFF,1,1,1,3,0xFF,0xFF,3,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,1,0xFF,1,0xFF,3,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,3,3,3,3,1,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,3,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,1,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,3,1,1,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,1,0xFF,0xFF,0xFF,1,1,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,3,3,3,3,3,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,1,1,1,3,3,0xFF,1,3,0xFF,0xFF,3,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,1,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,3,3,3,3,0xFF,3,1,0xFF,0xFF,3,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,1,0xFF,0xFF},
	en71[] = {0x3F,0x3F,0x3F,0xC9E2,0xC9E3,0xC9E4,0xC9E5,0xC9E6,0x3F,0xDFE1,0x3F,0xC9E7,0xC9E8,0x3F,0x3F,0xC9E9,0x3F,0x3F,0x3F,0x3F,0xB1EB,0x3F,0x3F,0x3F,0x3F,0xDFE4,0xCAB2,0x3F,0xDFE3,0x3F,0xC9EA,0x3F,0xC9EB,0xCCB5,0x3F,0x3F,0x3F,0x3F,0xBEC7,0x3F,0x3F,0x3F,0x3F,0xC9EC,0x3F,0xC9ED,0x3F,0xC9EE,0xC9EF,0xC9F0,0x3F,0x3F,0x3F,0x3F,0xC1B3,0x3F,0xC9F1,0x3F,0x3F,0x3F,0xBEC6,0x3F,0x3F,0x3F,0x3F,0xC9F2,0x3F,0x3F,0x3F,0xC9F3,0xC9F4,0xC9F5,0x3F,0xCEFB,0xC9F6,0xC9F7,0xDFEA,0x3F,0xC0F9,0x3F,0xC9F8,0x3F,0xC9F9,0x3F,0x3F,0xDFE6,0xDFEB,0xC9FA,0x3F,0xB1EC,0xC9FB,0x3F,0xC9FC,0x3F,0xC9FD,0x3F,0xC9FE,0x3F,0xDFE9,0x3F,0xC7E1,0xDFE5,0xDFE8,0xBEC8,0xCAA1,0xC8D1,0x3F,0x3F,0xDFEC,0x3F,0xBCD1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCAA2,0x3F,0x3F,0x3F,0xC0FA,0x3F,0x3F,0xCAA3,0x3F,0x3F,0x3F,0xDFEF,0xCAA4,0x3F,0xCAA5,0xDFE7,0x3F,0xB7A7,0x3F,0xCAA6,0x3F,0x3F,0xDFED,0x3F,0x3F,0xCAA7,0x3F,0xCDD0,0xDFF0,0x3F,0x3F,0x3F,0xF4A6,0xCAA8,0xCAA9,0x3F,0x3F,0x3F,0xBDCF,0xCAAA,0x3F,0xCAAB,0x3F,0x3F,0x3F,0x3F,0x3F,0xDFF1,0x3F,0x3F,0x3F,0xDFF2,0x3F,0x3F,0xCAAC,0xCAAD,0xC7AE,0xCAAE,0xCAAF,0x3F,0x3F,0x3F,0x3F,0x3F,0xDFF4,0xCAB0,0x3F,0x3F,0x3F,0xDFF5,0xCAB1,0xCAB2,0xCAB3,0x3F,0xC7B3,0xCAB4,0x3F,0x3F,0x3F,0xC5F5,0xDFF7,0x3F,0xCAB5,0xCAB6,0x3F,0xDFF9,0x3F,0xCED5,0x3F,0xDFF6,0xCAB7,0xDFF8,0xB1ED,0xCAB8,0xDFF3,0x3F,0xCAB9,0xCABA,0x3F,0xCABB,0x3F,0x3F,0xD3DB,0xDFFA,0x3F,0x3F,0x3F,0x3F,0xC1E7,0xBBB8,0xDFFC,0x3F,0x3F,0x3F,0x3F,0xDFFB,0xBFA4,0xD2D9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xDFFD,0x3F,0x3F,0xCABC,0xE0A1,0x3F,0xDFEE,0xDFFE,0x3F,0xCABD,0xE0A2},
	set71[] = {0xFF,0xFF,0xFF,3,3,3,3,3,0xFF,1,0xFF,3,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,1,0xFF,3,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,3,3,0xFF,1,3,3,1,0xFF,1,0xFF,3,0xFF,3,0xFF,0xFF,1,1,3,0xFF,1,3,0xFF,3,0xFF,3,0xFF,3,0xFF,1,0xFF,1,1,1,1,3,1,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,3,0xFF,3,1,0xFF,1,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,1,1,0xFF,0xFF,0xFF,1,3,3,0xFF,0xFF,0xFF,1,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,3,1,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,1,3,3,3,0xFF,1,3,0xFF,0xFF,0xFF,1,1,0xFF,3,3,0xFF,1,0xFF,1,0xFF,1,3,1,1,3,1,0xFF,3,3,0xFF,3,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,1,0xFF,1,1,0xFF,3,1},
	en72[] = {0xCABE,0x3F,0x3F,0x3F,0x3F,0x3F,0xC7FA,0xCABF,0xCAC0,0xCAC1,0x3F,0x3F,0x3F,0xE0A3,0x3F,0x3F,0xE0A4,0x3F,0x3F,0xCAC2,0x3F,0x3F,0x3F,0xCAC3,0x3F,0x3F,0xCAC4,0xE0A5,0x3F,0xCAC5,0x3F,0xCAC6,0x3F,0x3F,0x3F,0x3F,0xCAC7,0x3F,0x3F,0x3F,0xE0A6,0x3F,0xC4DE,0xCAC8,0xE0A8,0xE0A7,0x3F,0xCAC9,0xE0A9,0x3F,0xE0AA,0x3F,0xCACA,0xBCDF,0xC9E3,0x3F,0xCACB,0xCACC,0xCCEC,0xE0AB,0xE0AC,0xC1D6,0xBCA4,0xE0AD,0xE0AE,0xCACD,0xCACE,0xCACF,0x3F,0xCAD0,0xE0AF,0xCAD2,0xC8C7,0x3F,0x3F,0xE0B0,0xC7D7,0x3F,0xCAD1,0xCAD2,0xCAD3,0x3F,0xC4AD,0xCAD4,0x3F,0xCAD5,0xCAD6,0x3F,0xE0B1,0xB2E7,0xCAD7,0xB5ED,0xCAD8,0xCCC6,0xCAD9,0xCCB6,0xCADA,0xB2B4,0xCFB4,0xCADB,0x3F,0x3F,0x3F,0xCBD2,0xCADC,0xCAAA,0x3F,0xCADD,0x3F,0x3F,0xCADE,0xCADF,0x3F,0xCAE0,0xC0B7,0x3F,0xE0B2,0x3F,0x3F,0xCAE1,0xCAE2,0xC6C3,0x3F,0xCAE3,0xCAE4,0xB8A3,0xE0B3,0xCAE5,0xBAD4,0xE0B5,0xE0B4,0x3F,0xCAE6,0x3F,0x3F,0xE0B6,0x3F,0xCAE7,0x3F,0x3F,0x3F,0xCAE8,0xCAE9,0x3F,0x3F,0x3F,0xE0B7,0xCAEA,0x3F,0x3F,0xE0B8,0x3F,0x3F,0x3F,0x3F,0xCAEB,0x3F,0x3F,0x3F,0x3F,0xB5BE,0x3F,0xE0B9,0x3F,0x3F,0x3F,0x3F,0xE0BA,0xCAEC,0x3F,0x3F,0x3F,0xB8A4,0xCAED,0xCAEE,0xC8C8,0x3F,0xCAEF,0xE0BC,0x3F,0xCAF0,0x3F,0xBEF5,0x3F,0x3F,0xE0BB,0x3F,0x3F,0x3F,0x3F,0xCAF1,0x3F,0x3F,0xCAF2,0xB6B8,0xE0BD,0xE0BF,0x3F,0xE0BE,0xCAF3,0x3F,0xCAF4,0x3F,0x3F,0xCAF5,0x3F,0xE0C0,0x3F,0xB8D1,0x3F,0xE0C1,0x3F,0x3F,0xCAF6,0xCAF7,0xB6E9,0xCAF8,0xC1C0,0x3F,0xB9FD,0x3F,0x3F,0x3F,0xCAF9,0xE0C3,0xE0C4,0xE0C2,0x3F,0x3F,0xCAFA,0x3F,0x3F,0x3F,0xBCED,0x3F,0x3F,0xC6C8,0xB6B9,0x3F,0x3F,0x3F,0x3F,0x3F,0xCAFB,0xCAFC,0x3F,0x3F,0xE0C6,0xC3AC,0xE0C5,0xCAFD,0xCAFE,0xCFB5,0xC7E2,0xCBA1,0x3F},
	set72[] = {3,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,1,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,1,3,1,1,0xFF,3,1,0xFF,1,0xFF,3,1,1,0xFF,3,3,1,1,1,1,1,1,1,3,3,3,0xFF,3,1,1,1,0xFF,0xFF,1,1,0xFF,3,3,3,0xFF,1,3,0xFF,3,3,0xFF,1,1,3,1,3,1,3,1,3,1,1,3,0xFF,0xFF,0xFF,1,3,1,0xFF,3,0xFF,0xFF,3,3,0xFF,3,1,0xFF,1,0xFF,0xFF,3,3,1,0xFF,3,3,1,1,3,1,1,1,0xFF,3,0xFF,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,1,3,3,1,0xFF,3,1,0xFF,3,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,1,1,1,0xFF,1,3,0xFF,3,0xFF,0xFF,3,0xFF,1,0xFF,1,0xFF,1,0xFF,0xFF,3,3,1,3,1,0xFF,1,0xFF,0xFF,0xFF,3,1,1,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,1,1,3,3,1,1,3,0xFF},
	en73[] = {0x3F,0x3F,0xCBA2,0x3F,0xCBA3,0xCBA4,0x3F,0xCBA5,0x3F,0x3F,0xE0C9,0xCBA6,0x3F,0xCBA7,0x3F,0x3F,0x3F,0x3F,0xCBA8,0xCBA9,0x3F,0x3F,0xE0CB,0xE0C8,0xCBAA,0xCBAB,0x3F,0xCCD4,0xE0CA,0xE0CC,0xCBAC,0xCEC4,0x3F,0x3F,0xCBAD,0x3F,0xCBAE,0xE0D0,0x3F,0xCBAF,0xCBB0,0xE0CF,0xC3F6,0xC7AD,0xCBB1,0x3F,0xB8A5,0xE0CE,0x3F,0xCBB2,0xCBB3,0x3F,0xE0CD,0xCBB4,0xCDB1,0xCDB2,0x3F,0x3F,0xCBB5,0xCBB6,0x3F,0xCBB7,0xE0D1,0xB1EE,0x3F,0x3F,0x3F,0xCBB8,0xB9F6,0xBBE2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCBB9,0xE0D2,0xE0D3,0xCBBA,0x3F,0xCBBB,0x3F,0x3F,0x3F,0xCBBC,0xE0D5,0xCBBD,0x3F,0x3F,0x3F,0x3F,0xCBBE,0xCBBF,0xCBC0,0xCBC1,0x3F,0x3F,0xBDC3,0x3F,0x3F,0xCBC2,0xCBC3,0xE0D7,0xCBC4,0xE0D6,0xCBC5,0xCBC6,0x3F,0xCBC7,0xCBC8,0xE0D8,0xCBC9,0xB3CD,0x3F,0x3F,0xE0DA,0x3F,0xCBCA,0xE0D9,0xCBCB,0xE0DC,0xE0DB,0xCBCC,0x3F,0x3F,0x3F,0xCBCD,0xCBCE,0x3F,0xCBCF,0xB8BC,0xCBD0,0xCBD1,0xCEA8,0x3F,0xB6CC,0x3F,0xB2A6,0x3F,0x3F,0xCBD2,0x3F,0xCBD3,0x3F,0x3F,0xCBD4,0x3F,0xCBD5,0xB6EA,0xCBD6,0xCBD7,0x3F,0x3F,0x3F,0xCBD8,0x3F,0xCBD9,0xCBDA,0xCBDB,0x3F,0xCBDC,0x3F,0x3F,0xCBDD,0xCBDE,0x3F,0x3F,0xB4E1,0xCBDF,0xCBE0,0x3F,0xCBE1,0x3F,0x3F,0x3F,0x3F,0xCEE8,0xE0DE,0x3F,0xCBE2,0x3F,0xCBE3,0x3F,0xCBE4,0x3F,0xE0E0,0xCBE5,0xCBE6,0x3F,0xCBE7,0xE0E1,0x3F,0xB2D1,0x3F,0x3F,0xCBE8,0xCBE9,0x3F,0xE0DD,0xCBEA,0xBBB9,0xCBEB,0xCBEC,0xC4C1,0xE0DF,0xCBED,0x3F,0x3F,0xCBEE,0xCBEF,0x3F,0x3F,0xCBF0,0x3F,0x3F,0xCBF1,0x3F,0x3F,0x3F,0xCBF2,0xE0E4,0x3F,0xBCEE,0xCBF3,0x3F,0xCBF4,0x3F,0xE0E2,0xCBF5,0xCBF6,0x3F,0xCBF7,0xB7BE,0x3F,0x3F,0xC8C9,0xE0E3,0x3F,0x3F,0xE0FE,0x3F,0x3F,0xCBF8,0xCBF9,0x3F,0xCBFA,0xE0E9,0xCBFB,0xCBFC,0xCBFD,0x3F,0xCBFE,0xB8BD,0xCCA1},
	set73[] = {0xFF,0xFF,3,0xFF,3,3,0xFF,3,0xFF,0xFF,1,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,1,3,3,0xFF,1,1,1,3,1,0xFF,0xFF,3,0xFF,3,1,0xFF,3,3,1,1,1,3,0xFF,1,1,0xFF,3,3,0xFF,1,3,1,1,0xFF,0xFF,3,3,0xFF,3,1,1,0xFF,0xFF,0xFF,3,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,1,3,0xFF,3,0xFF,0xFF,0xFF,3,1,3,0xFF,0xFF,0xFF,0xFF,3,3,3,3,0xFF,0xFF,1,0xFF,0xFF,3,3,1,3,1,3,3,0xFF,3,3,1,3,1,0xFF,0xFF,1,0xFF,3,1,3,1,1,3,0xFF,0xFF,0xFF,3,3,0xFF,3,1,3,3,1,0xFF,1,0xFF,1,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,3,0xFF,3,1,3,3,0xFF,0xFF,0xFF,3,0xFF,3,3,3,0xFF,3,0xFF,0xFF,3,3,0xFF,0xFF,1,3,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,3,0xFF,3,0xFF,3,0xFF,1,3,3,0xFF,3,1,0xFF,1,0xFF,0xFF,3,3,0xFF,1,3,1,3,3,1,1,3,0xFF,0xFF,3,3,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,1,0xFF,1,3,0xFF,3,0xFF,1,3,3,0xFF,3,1,0xFF,0xFF,1,1,0xFF,0xFF,1,0xFF,0xFF,3,3,0xFF,3,1,3,3,3,0xFF,3,1,3},
	en74[] = {0xCCA2,0xCCA3,0x3F,0xB5E5,0xCCA4,0xE0E6,0xCDFD,0xCCA5,0x3F,0xCEB0,0xCCA6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCCA7,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCCA8,0xCCA9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC2F6,0x3F,0xCCAA,0xE0E8,0xCCAB,0x3F,0xCCAC,0xCCAD,0xCCAE,0xCCAF,0xCCB0,0xCCB1,0xCCB2,0xCCB3,0xCCB4,0xCCB5,0xE0EA,0xCED6,0xB6D7,0xC8FC,0xC7CA,0x3F,0x3F,0xCCB6,0xE0EB,0x3F,0x3F,0x3F,0x3F,0xE0ED,0xCCB7,0xE0F0,0x3F,0xCCB8,0xCCB9,0x3F,0xCCBA,0xCCBB,0x3F,0x3F,0x3F,0xCCBC,0x3F,0xCCBD,0x3F,0x3F,0x3F,0xCCBE,0xCCBF,0x3F,0x3F,0xE0EC,0x3F,0xCCC0,0x3F,0xE0EF,0xB8EA,0xB1CD,0xE0F1,0xCCC1,0xBFF0,0xE0EE,0xCEDC,0x3F,0xCCC2,0xE0F4,0xF4A4,0x3F,0xCCC3,0xCCC4,0xCCC5,0xE0F2,0xE0F5,0xCCC6,0x3F,0xCCC7,0xCCC8,0xE0E7,0xE0F3,0xCCC9,0xCCCA,0xBABC,0x3F,0x3F,0xE0F6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE0F7,0x3F,0xCCCB,0xCCCC,0x3F,0xCDFE,0x3F,0xCCCD,0xCCCE,0xCCCF,0x3F,0xCCD0,0x3F,0xE0F8,0x3F,0x3F,0x3F,0xCCD1,0xCCD2,0xCCD3,0xCCD4,0x3F,0x3F,0x3F,0x3F,0x3F,0xCCD5,0xCCD6,0xCCD7,0x3F,0xCCD8,0x3F,0xE0F9,0xCCD9,0xCCDA,0xCCDB,0xE0E5,0xCCDC,0x3F,0x3F,0xCCDD,0xE0FA,0xCCDE,0xCCDF,0xCCE0,0xCCE1,0x3F,0x3F,0xCCE2,0xCCE3,0xB4C4,0xCCE4,0xCCE5,0x3F,0x3F,0xCCE6,0x3F,0x3F,0x3F,0xCCE7,0x3F,0xCCE8,0x3F,0xBCA5,0x3F,0xCCE9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCCEA,0xCCEB,0xE0FB,0x3F,0xCCEC,0x3F,0x3F,0xE0FC,0xCCED,0x3F,0x3F,0xCCEE,0xE0FD,0x3F,0x3F,0x3F,0xCCEF,0x3F,0xCCF0,0xCCF1,0xB1BB,0x3F,0xCCF2,0xCCF3,0xE1A1,0x3F,0xC9BB,0xE1A2,0xCCF4,0x3F,0xB4A4,0xE1A3,0xCCF5,0xE1A4,0xCCF6,0xCCF7,0x3F,0x3F,0xE1A5,0xCCF8,0xE1A7,0xE1A8,0xE1A6,0x3F,0xCCF9,0x3F,0xC9D3,0xE1AA,0xE1A9,0x3F,0xCCFA,0xCCFB,0xCCFC,0x3F,0x3F,0xCCFD},
	set74[] = {3,3,0xFF,1,3,1,1,3,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,1,3,0xFF,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,1,3,1,0xFF,3,3,0xFF,3,3,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,0xFF,3,0xFF,1,1,1,1,3,1,1,1,0xFF,3,1,1,0xFF,3,3,3,1,1,3,0xFF,3,3,1,1,3,3,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,3,0xFF,1,0xFF,3,3,3,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,3,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,3,0xFF,3,0xFF,1,3,3,3,1,3,0xFF,0xFF,3,1,3,3,3,3,0xFF,0xFF,3,3,1,3,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,1,0xFF,3,0xFF,0xFF,1,3,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,3,0xFF,3,3,1,0xFF,3,3,1,0xFF,1,1,3,0xFF,1,1,3,1,3,3,0xFF,0xFF,1,3,1,1,1,0xFF,3,0xFF,1,1,1,0xFF,3,3,3,0xFF,0xFF,3},
	en75[] = {0x3F,0x3F,0x3F,0xE1AC,0xE1AB,0xE1AD,0xCCFE,0x3F,0x3F,0x3F,0x3F,0x3F,0xE1AE,0xE1B0,0xE1AF,0x3F,0x3F,0xB9F9,0xCDA1,0xE1B2,0x3F,0xE1B1,0xCDA2,0xCDA3,0xB4C5,0x3F,0xBFD3,0x3F,0xC5BC,0x3F,0xE1B3,0xC0B8,0xCDA4,0xCDA5,0x3F,0xBBBA,0xCDA6,0xB1F9,0xE1B4,0xCDA7,0xCDD1,0xCDA8,0xCDA9,0xCAE3,0xE1B5,0x3F,0x3F,0xCDAA,0xC5C4,0xCDB3,0xB9C3,0xBFBD,0x3F,0x3F,0xCDAB,0xC3CB,0xD2B4,0xCDAC,0xC4AE,0xB2E8,0xE1B6,0xCDAD,0xCDAE,0xCDAF,0xCDB0,0x3F,0x3F,0xCDB1,0xE1B7,0x3F,0xE1BC,0xCDB2,0xCDB3,0xE1BA,0xE1B9,0xDAC2,0xB3A6,0xE1B8,0xCDB4,0xB0DA,0xCDB5,0xC8AA,0xCDB6,0x3F,0xC8CA,0x3F,0x3F,0xCDB7,0x3F,0xCEB1,0xE1BD,0xE1BB,0xC3DC,0xC0A6,0xCDB8,0xCDB9,0xC8AB,0xCDBA,0xC9AD,0x3F,0xE1BF,0xCEAC,0xB7CD,0xE1C0,0x3F,0xE1BE,0xC8D6,0xE1C1,0x3F,0xE1C2,0x3F,0xCDBB,0xB0DB,0xCDBC,0x3F,0xBEF6,0xE1C7,0x3F,0xE1C4,0xC6ED,0xE1C3,0xCDBD,0xCDBE,0xCDBF,0xCDC0,0xCDC1,0xCDC2,0xB5A6,0x3F,0xCDC3,0xE1CA,0x3F,0x3F,0xCDC4,0xE1C5,0xE1C6,0x3F,0xE1C9,0xE1C8,0xC9A5,0x3F,0x3F,0xC1C2,0xC1C1,0xCDC5,0xB5BF,0xCDC6,0xCDC7,0xE1CB,0xCDC8,0x3F,0x3F,0x3F,0xCDC9,0xE1CC,0x3F,0xCDCA,0xE1CD,0x3F,0x3F,0x3F,0x3F,0xCDCB,0xE1CF,0xCDCC,0xE1CE,0x3F,0x3F,0x3F,0x3F,0x3F,0xB1D6,0x3F,0x3F,0x3F,0x3F,0x3F,0xE1D7,0xC8E8,0xE1D1,0xCDCD,0xE1D3,0x3F,0x3F,0xE1D5,0xBFBE,0xCDCE,0x3F,0xE1D6,0xE1D4,0xBCC0,0xCDCF,0xCDD0,0xCDD1,0xE1D0,0xE1D2,0xCDD2,0xC9C2,0xCDD3,0xBEC9,0x3F,0x3F,0xE1D9,0x3F,0xCDD4,0xE1D8,0xCDD5,0xCDD6,0x3F,0x3F,0xE1DA,0x3F,0xBCA6,0xBAAF,0x3F,0xCDD7,0xC5F7,0xE1DB,0x3F,0xC4CB,0xCDD8,0x3F,0xE1DD,0xCDD9,0xCDDA,0xCDDB,0xCEA1,0xE1DC,0xCDDC,0x3F,0x3F,0xCDDD,0x3F,0xC1E9,0x3F,0x3F,0xCDDE,0x3F,0xCDDF,0xCDE0,0xE1E2,0xCDE1,0xE1E4,0xE1E5,0xC3D4,0x3F,0x3F,0x3F,0x3F,0xCDE2,0xE1E3,0x3F,0xE1E0,0x3F,0xE1DE,0xE1DF},
	set75[] = {0xFF,0xFF,0xFF,1,1,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF,0xFF,1,3,1,0xFF,1,3,3,1,0xFF,1,0xFF,1,0xFF,1,1,3,3,0xFF,1,3,1,1,3,1,3,3,1,1,0xFF,0xFF,3,1,1,1,1,0xFF,0xFF,3,1,1,3,1,1,1,3,3,3,3,0xFF,0xFF,3,1,0xFF,1,3,3,1,1,1,1,1,3,1,3,1,3,0xFF,1,0xFF,0xFF,3,0xFF,1,1,1,1,1,3,3,1,3,1,0xFF,1,1,1,1,0xFF,1,1,1,0xFF,1,0xFF,3,1,3,0xFF,1,1,0xFF,1,1,1,3,3,3,3,3,3,1,0xFF,3,1,0xFF,0xFF,3,1,1,0xFF,1,1,1,0xFF,0xFF,1,1,3,1,3,3,1,3,0xFF,0xFF,0xFF,3,1,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,3,1,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,3,1,0xFF,0xFF,1,1,3,0xFF,1,1,1,3,3,3,1,1,3,1,3,1,0xFF,0xFF,1,0xFF,3,1,3,3,0xFF,0xFF,1,0xFF,1,1,0xFF,3,1,1,0xFF,1,3,0xFF,1,3,3,3,1,1,3,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,3,0xFF,3,3,1,3,1,1,1,0xFF,0xFF,0xFF,0xFF,3,1,0xFF,1,0xFF,1,1},
	en76[] = {0xCDE3,0xE1E1,0xCDE4,0xCDE5,0xCDE6,0x3F,0x3F,0xCDE7,0xCDE8,0xE1E8,0xCDE9,0xE1E6,0xCDEA,0xE1E7,0x3F,0xCDEB,0x3F,0x3F,0xCDEC,0xCDED,0x3F,0xCDEE,0xCDEF,0x3F,0x3F,0xCDF0,0x3F,0xCDF1,0xCDF2,0xCDF3,0xCDF4,0xE1E9,0xE1EB,0xE1EC,0xE1ED,0xCDF5,0xE1EE,0xCDF6,0xCDF7,0xE1EA,0x3F,0xCDF8,0x3F,0x3F,0x3F,0xCDF9,0x3F,0x3F,0xE1F0,0x3F,0xCDFA,0xCDFB,0xE1EF,0xCDFC,0x3F,0x3F,0xCDFD,0xCDFE,0xCEA1,0xE1F1,0xCEA2,0x3F,0x3F,0x3F,0xCEA4,0xCEA5,0xCEC5,0xCEA6,0xCEA7,0xCEA8,0xE1F4,0xE1F2,0xE1F3,0xCEA9,0xCEA3,0xCEAA,0xB4E2,0x3F,0x3F,0x3F,0x3F,0x3F,0xCCFE,0x3F,0x3F,0xCEAB,0xCACA,0x3F,0xE1F6,0xCEAC,0x3F,0x3F,0xE1F5,0x3F,0x3F,0xCEAD,0x3F,0xE1F7,0xE1F8,0x3F,0xCEAE,0xCEAF,0x3F,0xE1FC,0xE1F9,0xE1FA,0xE1FB,0x3F,0xE1FD,0xCEB0,0xCEB1,0xCEB2,0xE1FE,0xCEB3,0xE2A1,0x3F,0xCEB4,0x3F,0xE2A2,0x3F,0xE2A3,0x3F,0xC8AF,0xC5D0,0xE2A4,0xC7F2,0xC9B4,0x3F,0xE2A5,0xCEB5,0x3F,0xE2A6,0xC5AA,0xCEB6,0xB3A7,0xB9C4,0xE2A7,0x3F,0x3F,0xE2A8,0xCEB7,0xCEB8,0xE2A9,0x3F,0xBBA9,0x3F,0x3F,0xE2AB,0x3F,0xCEB9,0xE2AA,0x3F,0x3F,0xE2AC,0xE2AD,0xCEBA,0xCEBB,0xCEBC,0x3F,0xCEBD,0xCEBE,0x3F,0xCEBF,0xCEC0,0xCEC1,0xCEC2,0xCEC3,0xCEC4,0xCEC5,0x3F,0xCEC6,0x3F,0x3F,0xCEC7,0xC8E9,0x3F,0xE2AE,0x3F,0x3F,0x3F,0xE2AF,0x3F,0x3F,0xF3E9,0xE2B0,0xE2B1,0xE2B2,0x3F,0x3F,0xCEC8,0x3F,0xBBAE,0x3F,0xCEC9,0xE2B3,0xC7D6,0x3F,0xCECA,0xCBDF,0x3F,0xB1CE,0xCECB,0xB1D7,0xCECC,0xCECD,0xE2B4,0xCECE,0x3F,0x3F,0x3F,0xE2B6,0x3F,0xCECF,0x3F,0xE2B5,0xC5F0,0x3F,0xCED0,0x3F,0xC0B9,0xDDB9,0x3F,0xE2B7,0xCCC1,0xCED1,0xE2B8,0x3F,0xB4C6,0xC8D7,0xE2B9,0xCED2,0xE2BA,0xCED3,0x3F,0xE2BB,0x3F,0xCED4,0x3F,0xCCDC,0x3F,0xCED5,0xCED6,0xCCD5,0x3F,0xC4BE,0x3F,0xCED7,0x3F,0xC1EA,0xCED8,0x3F,0xE2BD,0xCED9,0x3F,0xBDE2,0x3F},
	set76[] = {3,1,3,3,3,0xFF,0xFF,3,3,1,3,1,3,1,0xFF,3,0xFF,0xFF,3,3,0xFF,3,3,0xFF,0xFF,3,0xFF,3,3,3,3,1,1,1,1,3,1,3,3,1,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,3,3,1,3,0xFF,0xFF,3,3,3,1,3,0xFF,0xFF,0xFF,3,3,1,3,3,3,1,1,1,3,3,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,1,0xFF,1,3,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,1,1,0xFF,3,3,0xFF,1,1,1,1,0xFF,1,3,3,3,1,3,1,0xFF,3,0xFF,1,0xFF,1,0xFF,1,1,1,1,1,0xFF,1,3,0xFF,1,1,3,1,1,1,0xFF,0xFF,1,3,3,1,0xFF,1,0xFF,0xFF,1,0xFF,3,1,0xFF,0xFF,1,1,3,3,3,0xFF,3,3,0xFF,3,3,3,3,3,3,3,0xFF,3,0xFF,0xFF,3,1,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,1,1,1,0xFF,0xFF,3,0xFF,1,0xFF,3,1,1,0xFF,3,1,0xFF,1,3,1,3,3,1,3,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,1,1,0xFF,3,0xFF,1,1,0xFF,1,1,3,1,0xFF,1,1,1,3,1,3,0xFF,1,0xFF,3,0xFF,1,0xFF,3,3,1,0xFF,1,0xFF,3,0xFF,1,3,0xFF,1,3,0xFF,1,0xFF},
	en77[] = {0xCEDA,0xBECA,0x3F,0x3F,0xE2C0,0x3F,0xCEDB,0xE2BF,0xE2BE,0xC8FD,0xCEDC,0xB4C7,0xB8A9,0x3F,0xCEDD,0x3F,0x3F,0x3F,0xCEDE,0x3F,0xCEDF,0xCEE0,0x3F,0xCEE1,0x3F,0xCEE2,0xCEE3,0xE2C6,0xCEE4,0x3F,0xE2C3,0xBFBF,0xCCB2,0x3F,0xCEE5,0x3F,0xE2C2,0xE2C4,0xE2C5,0x3F,0xCEE6,0xE2C1,0x3F,0x3F,0x3F,0xCEE7,0xCEE8,0xCEE9,0x3F,0x3F,0x3F,0x3F,0xCEEA,0xCEEB,0xCEEC,0xE2C7,0xE2C8,0xCEED,0xC4AF,0x3F,0xB4E3,0xCEEE,0xCEEF,0x3F,0xC3E5,0x3F,0xCEF0,0x3F,0x3F,0xCEF1,0xCEF2,0xE2C9,0x3F,0x3F,0xCEF3,0x3F,0x3F,0xCEF4,0xCEF5,0xCEF6,0x3F,0x3F,0xCEF7,0x3F,0x3F,0x3F,0xCEF8,0xCEF9,0x3F,0x3F,0xE2CA,0xE2CD,0xCEFA,0x3F,0xCEFB,0xCEFC,0xCEFD,0xBFE7,0xCEFE,0xC6C4,0xCFA1,0xE2CE,0xCBD3,0xCFA2,0xE2CB,0x3F,0xCFA3,0xE2CC,0xCFA4,0x3F,0x3F,0x3F,0xCFA5,0x3F,0xCFA6,0xCFA7,0xCFA8,0x3F,0x3F,0x3F,0x3F,0xE2D1,0xCFA9,0x3F,0x3F,0xCFAA,0xE2D0,0xE2CF,0xCFAB,0x3F,0x3F,0x3F,0xCFAC,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE2D3,0xCFAD,0xCFAE,0xE2D2,0x3F,0x3F,0xE2D4,0x3F,0x3F,0xCFAF,0xCFB0,0xCFB1,0x3F,0x3F,0x3F,0xCFB2,0x3F,0x3F,0x3F,0xE2D6,0xCFB3,0xE2D5,0x3F,0xCFB4,0x3F,0x3F,0xCACD,0x3F,0xCFB5,0x3F,0x3F,0xCFB6,0x3F,0xBDD6,0xCEC6,0xCFB7,0xCFB8,0xE2D7,0xCFB9,0x3F,0xC6B7,0x3F,0xCFBA,0xE2D8,0x3F,0x3F,0xE2D9,0x3F,0xE2DD,0xE2DB,0xE2DC,0xCFBB,0xE2DA,0x3F,0x3F,0x3F,0xCFBC,0x3F,0x3F,0x3F,0xE2DE,0x3F,0xCFBD,0x3F,0x3F,0x3F,0xE2DF,0x3F,0x3F,0x3F,0xCFBE,0xCFBF,0x3F,0x3F,0xCFC0,0x3F,0xE2E0,0x3F,0xCFC1,0xE2E1,0xCCB7,0xE2E2,0x3F,0xCFC2,0xCFC3,0xCFC4,0x3F,0xCCF0,0xE2E3,0xCFC5,0xC3CE,0xCFC6,0xC7EA,0x3F,0xB6EB,0xCFC7,0x3F,0xCFC8,0xC3BB,0xE2E4,0xB6BA,0xCFC9,0xCFCA,0x3F,0xC0D0,0xCFCB,0x3F,0x3F,0x3F,0xCFCC,0x3F,0x3F,0xCFCD,0xE2E5,0x3F,0x3F,0x3F},
	set77[] = {3,1,0xFF,0xFF,1,0xFF,3,1,1,1,3,1,1,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,3,3,0xFF,3,0xFF,3,3,1,3,0xFF,1,1,1,0xFF,3,0xFF,1,1,1,0xFF,3,1,0xFF,0xFF,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,3,3,3,1,1,3,1,0xFF,1,3,3,0xFF,1,0xFF,3,0xFF,0xFF,3,3,1,0xFF,0xFF,3,0xFF,0xFF,3,3,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,1,3,0xFF,3,3,3,1,3,1,3,1,1,3,1,0xFF,3,1,3,0xFF,0xFF,0xFF,3,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,3,1,1,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,1,0xFF,0xFF,1,0xFF,0xFF,3,3,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,3,1,0xFF,3,0xFF,0xFF,1,0xFF,3,0xFF,0xFF,3,0xFF,1,1,3,3,1,3,0xFF,1,0xFF,3,1,0xFF,0xFF,1,0xFF,1,1,1,3,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,3,0xFF,1,0xFF,3,1,1,1,0xFF,3,3,3,0xFF,1,1,3,1,3,1,0xFF,1,3,0xFF,3,1,1,1,3,3,0xFF,1,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,1,0xFF,0xFF,0xFF},
	en78[] = {0x3F,0x3F,0xBABD,0x3F,0x3F,0xCFCE,0xCFCF,0x3F,0x3F,0xCFD0,0x3F,0x3F,0xE2E6,0xCFD1,0xCFD2,0x3F,0x3F,0xCFD3,0xE2E7,0x3F,0xB8A6,0xBAD5,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCFD4,0x3F,0x3F,0xE2E9,0xCFD5,0xCFD6,0xCFD7,0x3F,0xC5D6,0xBAD6,0xB5CE,0x3F,0x3F,0x3F,0x3F,0x3F,0xCFD8,0xCFD9,0x3F,0xCFDA,0x3F,0xCBA4,0x3F,0xC7CB,0xCFDB,0x3F,0xCFDC,0x3F,0x3F,0xC5D7,0x3F,0x3F,0x3F,0x3F,0xB9DC,0x3F,0x3F,0x3F,0xCFDD,0xCFDE,0xE2EB,0x3F,0xCFDF,0xCFE0,0x3F,0x3F,0x3F,0xCFE1,0x3F,0xCFE2,0x3F,0x3F,0x3F,0xCFE3,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCFE4,0xBECB,0xCFE5,0x3F,0xCFE6,0xCFE7,0x3F,0xCFE8,0xCFE9,0x3F,0x3F,0x3F,0xCFEA,0x3F,0xCFEB,0xCEB2,0xB9C5,0x3F,0xCFEC,0xB8A7,0x3F,0x3F,0xC8A3,0x3F,0xE2ED,0x3F,0x3F,0x3F,0x3F,0x3F,0xCFED,0x3F,0xE2EF,0x3F,0xCFEE,0x3F,0x3F,0xB8EB,0x3F,0x3F,0x3F,0x3F,0xE2EE,0xC4F6,0x3F,0x3F,0xCFEF,0x3F,0xE2F1,0xB3B7,0xE2EC,0xCFF0,0x3F,0xC8EA,0x3F,0xB1B0,0xCFF1,0xBAEC,0x3F,0xCFD2,0xCFF2,0x3F,0xE2F0,0x3F,0x3F,0xCFF4,0xCFF5,0xCFF6,0x3F,0xCFF3,0x3F,0xE2F2,0xCFF7,0x3F,0x3F,0xCACB,0xCFF8,0xC0D9,0xE2F4,0x3F,0xCFF9,0xCFFA,0x3F,0xE2F5,0xCFFB,0xCFFC,0xCFFD,0xCFFE,0x3F,0xE2F3,0x3F,0x3F,0x3F,0x3F,0xB3CE,0xD0A1,0xE2FB,0xD0A2,0xE2FA,0xD0A3,0x3F,0xBCA7,0x3F,0x3F,0x3F,0xE2FC,0xE2F7,0xD0A4,0xD0A5,0xD0A6,0xE2FD,0xE2F8,0xD0A7,0x3F,0xD0A8,0x3F,0xC8D8,0xE2F6,0xD0A9,0xD0AA,0xE2F9,0xD0AB,0xD0AC,0x3F,0x3F,0x3F,0xE3A2,0xD0AE,0x3F,0x3F,0x3F,0xD0AF,0xD0B0,0xD0B1,0x3F,0x3F,0xD0AD,0x3F,0xD0B2,0xE3A1,0xCBE1,0x3F,0xD0B3,0x3F,0xE2FE,0x3F,0x3F,0xB0EB,0x3F,0x3F,0xD0B4,0xD0B5,0xE3A4,0x3F,0xD0B7,0xD0B8,0x3F,0x3F,0xD0B9,0xD0BA,0x3F,0xE3A3,0x3F,0xD0BB},
	set78[] = {0xFF,0xFF,1,0xFF,0xFF,3,3,0xFF,0xFF,3,0xFF,0xFF,1,3,3,0xFF,0xFF,3,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,3,3,3,0xFF,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,3,0xFF,1,0xFF,1,3,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,3,1,0xFF,3,3,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,3,0xFF,3,3,0xFF,3,3,0xFF,0xFF,0xFF,3,0xFF,3,1,1,0xFF,3,1,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,3,0xFF,1,1,1,3,0xFF,1,0xFF,1,3,1,0xFF,1,3,0xFF,1,0xFF,0xFF,3,3,3,0xFF,3,0xFF,1,3,0xFF,0xFF,1,3,1,1,0xFF,3,3,0xFF,1,3,3,3,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,3,1,3,1,3,0xFF,1,0xFF,0xFF,0xFF,1,1,3,3,3,1,1,3,0xFF,3,0xFF,1,1,3,3,1,3,3,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,3,3,3,0xFF,0xFF,3,0xFF,3,1,1,0xFF,3,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,3,3,1,0xFF,3,3,0xFF,0xFF,3,3,0xFF,1,0xFF,3},
	en79[] = {0xD0B6,0xBECC,0x3F,0x3F,0x3F,0x3F,0xD0BC,0xE3A5,0x3F,0x3F,0x3F,0x3F,0xD0BD,0x3F,0xC1C3,0x3F,0xD0BE,0xE3A7,0xE3A6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE3A8,0xD0BF,0x3F,0xD0C0,0x3F,0xD0C1,0xD0C2,0xD0C3,0x3F,0x3F,0x3F,0x3F,0xD0C4,0xE2E8,0xD0C5,0x3F,0xD0C6,0xE2EA,0xE3AA,0xE3A9,0xD0C7,0x3F,0x3F,0x3F,0xD0C8,0x3F,0x3F,0xD0C9,0xD0CA,0x3F,0x3F,0x3F,0x3F,0xBCA8,0xD0CB,0xCEE9,0xD0CC,0xBCD2,0xD0CD,0xE3AB,0xB7B7,0x3F,0x3F,0xD0CE,0xD0CF,0xD0D0,0xB5C0,0xB5A7,0xBBE3,0xD0D1,0xD0D2,0x3F,0x3F,0x3F,0xD0D3,0xCDB4,0xD0D4,0x3F,0xE3B1,0xD0D5,0xE3B0,0xC1C4,0xE3AD,0xD0D6,0x3F,0xE3AF,0xD0D7,0xD0D8,0xBDCB,0xBFC0,0xE3AE,0xE3AC,0x3F,0xC7AA,0x3F,0x3F,0xBECD,0x3F,0xD0D9,0xC9BC,0xD0DA,0x3F,0xD0DB,0x3F,0xBAD7,0x3F,0x3F,0x3F,0x3F,0xD0DC,0x3F,0x3F,0x3F,0x3F,0xC5F8,0x3F,0xD0DD,0xE3B2,0xD0DE,0xD0DF,0x3F,0xD0E0,0xE3B3,0xE3C9,0xB6D8,0x3F,0x3F,0xCFBD,0xC1B5,0x3F,0x3F,0x3F,0x3F,0xE3B4,0xD0E1,0xD0E2,0xB2D2,0xC4F7,0xCAA1,0x3F,0xD0E3,0x3F,0xD0E4,0xD0E5,0xD0E6,0xD0E7,0x3F,0xD0E8,0x3F,0x3F,0xD0E9,0xD0EA,0xE3B5,0x3F,0x3F,0x3F,0xD0EB,0x3F,0x3F,0x3F,0x3F,0xB5FA,0xE3B6,0xD0EC,0xD0ED,0xE3B8,0xD0EE,0x3F,0x3F,0xE3B9,0xD0EF,0xC7A9,0xD0F0,0x3F,0xE3BA,0xD0F1,0x3F,0x3F,0x3F,0xD0F2,0xE3BB,0xE3BC,0xD0F3,0x3F,0xB6D9,0xB2D3,0xC6C5,0xBDA8,0xBBE4,0xD0F4,0x3F,0xD0F5,0x3F,0x3F,0xD0F6,0xD0F7,0xE3BD,0xD0F8,0xBDA9,0x3F,0x3F,0x3F,0xD0F9,0x3F,0xB2CA,0xC9C3,0x3F,0xD0FA,0xE3BE,0xD0FB,0x3F,0xC8EB,0x3F,0xD0FC,0x3F,0x3F,0xD0FD,0xD0FE,0xC1C5,0xD1A1,0xE3C1,0xD1A2,0xE3C2,0xC7E9,0xD1A3,0xBFC1,0xE3BF,0x3F,0xC3E1,0xD1A4,0xD1A5,0xE3C0,0xD1A6,0x3F,0x3F,0xBECE,0xD1A7,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD1A8,0x3F,0x3F,0xB0DC,0xD1A9,0x3F,0x3F,0x3F},
	set79[] = {3,1,0xFF,0xFF,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,3,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,3,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,3,1,3,0xFF,3,1,1,1,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,1,3,1,3,1,3,1,1,0xFF,0xFF,3,3,3,1,1,1,3,3,0xFF,0xFF,0xFF,3,1,3,0xFF,1,3,1,1,1,3,0xFF,1,3,3,1,1,1,1,0xFF,1,0xFF,0xFF,1,0xFF,3,1,3,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,1,3,3,0xFF,3,1,1,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,1,3,3,1,1,1,0xFF,3,0xFF,3,3,3,3,0xFF,3,0xFF,0xFF,3,3,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,1,3,3,1,3,0xFF,0xFF,1,3,1,3,0xFF,1,3,0xFF,0xFF,0xFF,3,1,1,3,0xFF,1,1,1,1,1,3,0xFF,3,0xFF,0xFF,3,3,1,3,1,0xFF,0xFF,0xFF,3,0xFF,1,1,0xFF,3,1,3,0xFF,1,0xFF,3,0xFF,0xFF,3,3,1,3,1,3,1,1,3,1,1,0xFF,1,3,3,1,3,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,3,0xFF,0xFF,0xFF},
	en7A[] = {0xB5A9,0x3F,0xD1AA,0xD1AB,0x3F,0x3F,0x3F,0xD1AC,0xE3C3,0xD1AD,0xD1AE,0xC4F8,0xD1AF,0xE3C4,0xC0C7,0x3F,0x3F,0xD1B0,0x3F,0x3F,0xCCAD,0xD1B1,0x3F,0xC9A3,0xE3C5,0xE3C6,0xC3D5,0xD1B2,0xCEC7,0x3F,0xD1B3,0xE3C8,0xE3C7,0xD1B4,0x3F,0x3F,0x3F,0x3F,0x3F,0xD1B5,0x3F,0x3F,0x3F,0xD1B6,0x3F,0xD1B7,0xBCEF,0xD1B8,0xD1B9,0xE3CA,0xB0F0,0x3F,0xD1BA,0xD1BB,0x3F,0xE3CD,0xD1BC,0xD1BD,0xD1BE,0xE3CB,0xB2D4,0xB7CE,0xE3CC,0xB9C6,0xB9F2,0x3F,0xCAE6,0xE3CE,0xD1BF,0xD1C0,0xCBD4,0xD1C1,0xD1C2,0xE3D0,0x3F,0x3F,0xD1C3,0xC0D1,0xB1CF,0xB2BA,0xB0AC,0x3F,0x3F,0x3F,0x3F,0xD1C4,0xD1C5,0xE3CF,0x3F,0xD1C6,0x3F,0x3F,0xD1C7,0xD1C8,0x3F,0xD1C9,0xD1CA,0xE3D1,0xE3D2,0xBEF7,0x3F,0xD1CB,0x3F,0xD1CC,0x3F,0xE3D3,0xD1CD,0xB3CF,0x3F,0xD1CE,0x3F,0x3F,0xE3D5,0x3F,0x3F,0x3F,0xB7EA,0xD1CF,0xB5E6,0x3F,0xD1D0,0xE3D6,0xB6F5,0x3F,0x3F,0xE3D7,0xD1D1,0xC0FC,0xD1D2,0xC6CD,0xD1D3,0xC0E0,0xBAF5,0xD1D4,0xD1D5,0x3F,0xE3D8,0x3F,0xD1D6,0xD1D7,0x3F,0x3F,0x3F,0x3F,0xD1D8,0xD1D9,0xC3E2,0xC1EB,0xD1DA,0xE3DA,0xE3DC,0xE3D9,0xE3DB,0x3F,0x3F,0x3F,0x3F,0x3F,0xD1DB,0xB7A2,0xD1DC,0x3F,0x3F,0xD1DD,0x3F,0x3F,0x3F,0x3F,0x3F,0xE3DD,0xB7A6,0x3F,0xD1DE,0x3F,0xB5E7,0xCDD2,0xE3DF,0x3F,0x3F,0xD1DF,0x3F,0xD1E0,0xE3E0,0x3F,0x3F,0xD1E1,0xB1AE,0xD1E2,0xD1E3,0x3F,0x3F,0xE3E3,0x3F,0x3F,0x3F,0xB3F6,0xE3E2,0xE3E1,0xD1E4,0xE3E5,0xE3DE,0xD1E5,0xE3E6,0xCEA9,0xD1E6,0xE3E7,0xD1E7,0xE3E8,0x3F,0xD1E8,0xD4F4,0xE3EA,0x3F,0xE3E9,0x3F,0x3F,0x3F,0xE3EB,0xE3EC,0xD1E9,0xCEB5,0xE3ED,0x3F,0xF0EF,0xBECF,0xE3EE,0xE3EF,0xBDD7,0x3F,0xC6B8,0xE3F0,0x3F,0xD1EA,0xD1EB,0xC3A8,0xD1EC,0xD1ED,0xE3F1,0x3F,0xC3BC,0xE3F2,0xD1EE,0x3F,0x3F,0xD1EF,0x3F,0xB6A5,0x3F,0xD1BF,0xC3DD,0xBCB3,0xD1F0,0x3F,0xD1F1,0xD1F2,0xB4C8},
	set7A[] = {1,0xFF,3,3,0xFF,0xFF,0xFF,3,1,3,3,1,3,1,1,0xFF,0xFF,3,0xFF,0xFF,1,3,0xFF,1,1,1,1,3,1,0xFF,3,1,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,3,1,3,3,1,1,0xFF,3,3,0xFF,1,3,3,3,1,1,1,1,1,1,0xFF,1,1,3,3,1,3,3,1,0xFF,0xFF,3,1,1,1,1,0xFF,0xFF,0xFF,0xFF,3,3,1,0xFF,3,0xFF,0xFF,3,3,0xFF,3,3,1,1,1,0xFF,3,0xFF,3,0xFF,1,3,1,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,3,1,0xFF,3,1,1,0xFF,0xFF,1,3,1,3,1,3,1,1,3,3,0xFF,1,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,3,3,1,1,3,1,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,3,0xFF,1,1,1,0xFF,0xFF,3,0xFF,3,1,0xFF,0xFF,3,1,3,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,1,1,3,1,1,3,1,1,3,1,3,1,0xFF,3,1,1,0xFF,1,0xFF,0xFF,0xFF,1,1,3,1,1,0xFF,1,1,1,1,1,0xFF,1,1,0xFF,3,3,1,3,3,1,0xFF,1,1,3,0xFF,0xFF,3,0xFF,1,0xFF,1,1,1,3,0xFF,3,3,1},
	en7B[] = {0x3F,0x3F,0xE3F3,0x3F,0xE4A2,0x3F,0xE3F6,0xD1F3,0xB5E8,0x3F,0xE3F5,0xE4A4,0x3F,0x3F,0x3F,0xE3F4,0x3F,0xBED0,0x3F,0x3F,0xD1F4,0x3F,0x3F,0x3F,0xE3F8,0xE3F9,0x3F,0xC5AB,0x3F,0x3F,0xE3FA,0xD1F5,0xB3DE,0x3F,0x3F,0xD1F6,0x3F,0xBFDA,0xC9E4,0xD1F7,0xE3FC,0xD1F8,0xD1F9,0xD1FA,0xC2E8,0xD1FB,0xD1FC,0xD1FD,0xD1FE,0xD2A1,0x3F,0xE3F7,0xD2A2,0xE3FB,0xE3FD,0x3F,0x3F,0xBAFB,0x3F,0x3F,0x3F,0xD2A3,0x3F,0xD2A4,0xD2A5,0xD2A6,0x3F,0x3F,0x3F,0xE4A6,0xC9AE,0xD2A7,0xC8A6,0xC5F9,0x3F,0xB6DA,0xE4A5,0xE4A3,0xD2A8,0xC8B5,0xE3FE,0xC3DE,0xC5FB,0x3F,0xC5FA,0xD2A9,0xBAF6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE4B8,0x3F,0x3F,0xD2AA,0x3F,0x3F,0x3F,0xD2AB,0xE4A8,0xD2AC,0xE4AA,0x3F,0xD2AD,0xD2AE,0x3F,0xE4AD,0xD2AF,0xE4AE,0xD2B0,0xE4AB,0xE4AC,0xD2B1,0xD2B2,0xE4A9,0xE4A7,0x3F,0xD2B3,0x3F,0x3F,0xE4A1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD2B4,0x3F,0xCACF,0xB2D5,0x3F,0xD2B5,0x3F,0xE4B5,0x3F,0xE4B2,0xD2B6,0xE4B7,0xD2B7,0xD2B8,0xE4B6,0x3F,0xC7F3,0xCCA7,0xD2B9,0xBBBB,0xE4B0,0xE4B9,0xE4B4,0xD2BA,0xE4B3,0xE4AF,0xD2BB,0xE4B1,0xD2BC,0xB4C9,0x3F,0x3F,0x3F,0xD2BD,0x3F,0x3F,0x3F,0x3F,0xC3BD,0x3F,0xD2BE,0xC0FD,0x3F,0xD2BF,0xD2C0,0xC8A2,0xD2C1,0x3F,0xE4BE,0xD2C2,0xD2C3,0x3F,0xC8A4,0x3F,0xD2C4,0xD2C5,0xD2C6,0xD2C7,0x3F,0x3F,0xC0E1,0xE4BB,0xD2C8,0x3F,0xC8CF,0xD2C9,0xE4BF,0xCAD3,0xD2CA,0xC3DB,0xD2CB,0xE4BA,0xE4BC,0x3F,0x3F,0xE4BD,0x3F,0x3F,0x3F,0x3F,0xD2CC,0x3F,0xD2CD,0xD2CE,0x3F,0xD2CF,0xD2D0,0xD2D1,0x3F,0xE4C0,0x3F,0x3F,0xBCC4,0x3F,0x3F,0x3F,0xC6C6,0xE4C5,0xE4C4,0x3F,0xD2D2,0xE4C1,0xD2D3,0x3F,0x3F,0xCFB6,0x3F,0x3F,0x3F,0x3F,0xD2D4,0xE4CA,0xD2D5,0xD2D6,0xE4CE,0xE4CB,0xD2D7,0xD2D8,0xD2D9,0x3F,0xD2DA,0x3F,0xD2DB,0x3F},
	set7B[] = {0xFF,0xFF,1,0xFF,1,0xFF,1,3,1,0xFF,1,1,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,1,0xFF,1,0xFF,0xFF,1,3,1,0xFF,0xFF,3,0xFF,1,1,3,1,3,3,3,1,3,3,3,3,3,0xFF,1,3,1,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,3,3,3,0xFF,0xFF,0xFF,1,1,3,1,1,0xFF,1,1,1,3,1,1,1,1,0xFF,1,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,1,3,1,0xFF,3,3,0xFF,1,3,1,3,1,1,3,3,1,1,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,1,0xFF,3,0xFF,1,0xFF,1,3,1,3,3,1,0xFF,1,1,3,1,1,1,1,3,1,1,3,1,3,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,1,0xFF,3,3,1,3,0xFF,1,3,3,0xFF,1,0xFF,3,3,3,3,0xFF,0xFF,1,1,3,0xFF,1,3,1,1,3,1,3,1,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,3,0xFF,3,3,3,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,1,1,0xFF,3,1,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,1,3,3,1,1,3,3,3,0xFF,3,0xFF,3,0xFF},
	en7C[] = {0xE4C7,0xD2DC,0xD2DD,0xD2DE,0xD2DF,0x3F,0xD2E0,0xE4C8,0x3F,0xD2E1,0x3F,0xD2E2,0xD2E3,0xE4CD,0xD2E4,0xD2E5,0x3F,0xE4C2,0xD2D5,0xE4C9,0xE4C3,0x3F,0x3F,0xE4CC,0x3F,0xD2E6,0x3F,0xD2E7,0x3F,0x3F,0x3F,0xE4D2,0xD2E8,0xB4CA,0x3F,0xE4CF,0x3F,0xD2E9,0xD2EA,0xE4D0,0xD2EB,0x3F,0xE4D1,0xE4D4,0xD2EC,0x3F,0x3F,0x3F,0x3F,0xD2ED,0x3F,0xD2EE,0xD2EF,0x3F,0xD2F0,0xE4D3,0xC8F6,0xD2F1,0xD2F2,0x3F,0x3F,0xE4D5,0xCEFC,0xCAED,0xE4DA,0x3F,0x3F,0xE4D7,0x3F,0x3F,0xD2F3,0x3F,0x3F,0x3F,0xD2F4,0x3F,0xE4D6,0xC0D2,0x3F,0xE4D9,0xE4DB,0xD2F6,0xD2F7,0xD2F8,0xE4D8,0xD2F5,0xE4DF,0x3F,0xE4DC,0xD2F9,0xD2FA,0xD2FB,0xD2FC,0xD2FD,0xD2FE,0xE4DD,0xE4C6,0xD3A1,0x3F,0xD3A2,0xE4DE,0xE4E0,0x3F,0xD3A3,0x3F,0xD3A4,0x3F,0x3F,0xE4E1,0xD3A5,0xD3A6,0x3F,0xD3A7,0x3F,0xD3A8,0xCAC6,0x3F,0xE4E2,0x3F,0x3F,0x3F,0xD3A9,0x3F,0x3F,0xD3AA,0xD3AB,0xCCE2,0x3F,0x3F,0xB6CE,0xB7A9,0xE4E3,0x3F,0x3F,0xD3AC,0xD3AD,0x3F,0xCAB4,0x3F,0xBFE8,0x3F,0xCCB0,0x3F,0xD3AE,0xE4E4,0x3F,0xCEB3,0x3F,0xD3AF,0xC7F4,0x3F,0xC1C6,0xC7B4,0x3F,0x3F,0xBDCD,0x3F,0x3F,0xD3B0,0xB0C0,0xD3B1,0xE4E9,0xE4E7,0x3F,0xE4E5,0xB4A1,0xD3B2,0xBED1,0xE4EA,0x3F,0x3F,0xE4E8,0x3F,0xE4E6,0xE4EE,0x3F,0xD3B3,0xE4ED,0xE4EC,0xE4EB,0x3F,0x3F,0xD3B4,0xD3B5,0x3F,0xE4EF,0xD3B6,0xD3B7,0xD3B8,0xE4F0,0xC0BA,0xD3B9,0xE4F1,0x3F,0xE4F3,0x3F,0xD3BA,0xE4F2,0x3F,0xD3BB,0xD3BC,0xD3BD,0xB8D2,0x3F,0x3F,0xD3BE,0xC1B8,0xD3BF,0x3F,0x3F,0xE4F5,0xD3C0,0xD3C1,0xD3C2,0xC5FC,0xD3C3,0xE4F4,0xD3C4,0xD3C5,0x3F,0xE4F6,0xD3C6,0xCAB5,0xC1EC,0xB9C7,0x3F,0xE4F7,0x3F,0x3F,0x3F,0xD3C7,0xCEC8,0x3F,0xD3C8,0x3F,0xD3C9,0x3F,0x3F,0x3F,0xE4F9,0x3F,0x3F,0xE4FA,0x3F,0xE4FB,0xD3CA,0xE4FC,0x3F,0xBBE5,0x3F,0xE4FD,0xB7CF,0x3F,0x3F,0xB5EA,0x3F},
	set7C[] = {1,3,3,3,3,0xFF,3,1,0xFF,3,0xFF,3,3,1,3,3,0xFF,1,1,1,1,0xFF,0xFF,1,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,1,3,1,0xFF,1,0xFF,3,3,1,3,0xFF,1,1,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,3,0xFF,3,1,1,3,3,0xFF,0xFF,1,1,1,1,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,1,1,0xFF,1,1,3,3,3,1,3,1,0xFF,1,3,3,3,3,3,3,1,1,3,0xFF,3,1,1,0xFF,3,0xFF,3,0xFF,0xFF,1,3,3,0xFF,3,0xFF,3,1,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,3,1,0xFF,0xFF,1,1,1,0xFF,0xFF,3,3,0xFF,1,0xFF,1,0xFF,1,0xFF,3,1,0xFF,1,0xFF,3,1,0xFF,1,1,0xFF,0xFF,1,0xFF,0xFF,3,1,3,1,1,0xFF,1,1,3,1,1,0xFF,0xFF,1,0xFF,1,1,0xFF,3,1,1,1,0xFF,0xFF,3,3,0xFF,1,3,3,3,1,1,3,1,0xFF,1,0xFF,3,1,0xFF,3,3,3,1,0xFF,0xFF,3,1,3,0xFF,0xFF,1,3,3,3,1,3,1,3,3,0xFF,1,3,1,1,1,0xFF,1,0xFF,0xFF,0xFF,3,1,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,1,3,1,0xFF,1,0xFF,1,1,0xFF,0xFF,1,0xFF},
	en7D[] = {0xB5AA,0x3F,0xE5A1,0xD3CB,0xCCF3,0xB9C8,0xE4FE,0xD3CC,0xD3CD,0xD3CE,0xE5A4,0xCCE6,0x3F,0xC7BC,0x3F,0xD3CF,0xC9B3,0xD3D0,0xD3D1,0xD3D2,0xBDE3,0xE5A3,0xD3D3,0xBCD3,0xB9C9,0xBBE6,0xB5E9,0xCAB6,0xE5A2,0xD3D4,0xD3D5,0x3F,0xC1C7,0xCBC2,0xBAF7,0xD3D6,0x3F,0x3F,0xD3D7,0x3F,0x3F,0x3F,0xD3D8,0xBBE7,0xC4DD,0xD3D9,0xE5A7,0xCEDF,0xBAD9,0xD3DA,0xE5A8,0xBFC2,0x3F,0xE5AA,0x3F,0x3F,0x3F,0xBED2,0xBAB0,0x3F,0xD3DB,0xD3DC,0xD3DD,0xE5A9,0xD3DE,0xD3DF,0xBDAA,0xB8BE,0xC1C8,0xE5A5,0xE5AB,0xD3E0,0xD3E1,0x3F,0x3F,0xE5A6,0xB7D0,0xD3E2,0xE5AE,0xE5B2,0xB7EB,0xD3E3,0x3F,0xD3E4,0x3F,0x3F,0xE5AD,0xD3E5,0x3F,0xD3E6,0xD3E7,0xE5B6,0xD3E8,0xD3E9,0xB9CA,0x3F,0x3F,0xCDED,0xB0BC,0xE5B3,0x3F,0xD3EA,0xB5EB,0xD3EB,0xE5B0,0x3F,0xD3EC,0x3F,0x3F,0x3F,0xE5B1,0x3F,0xD3ED,0xC5FD,0xE5AF,0xE5AC,0x3F,0xB3A8,0xC0E4,0x3F,0xD3EE,0xB8A8,0xD3EF,0xD3F0,0x3F,0xE5B8,0x3F,0xD3F1,0x3F,0xD3F2,0xD3F3,0xD3F4,0x3F,0xD3F5,0xD3F6,0x3F,0xD3F7,0xE5B5,0x3F,0xD3F8,0xD3F9,0xD3FA,0x3F,0xE5B7,0x3F,0xD3FB,0x3F,0xE5B4,0x3F,0x3F,0xD3FC,0xD3FD,0x3F,0xB7D1,0xC2B3,0xE5B9,0xC1EE,0xD3FE,0xD4A1,0xE5C6,0x3F,0x3F,0xE5C2,0xE5BC,0x3F,0x3F,0xD4A2,0xD4A3,0x3F,0x3F,0xD4A4,0xE5C0,0xBCFA,0xB0DD,0xE5BB,0xE5C3,0xE5C7,0xB9CB,0xCCD6,0xD4A5,0xC4D6,0xE5BD,0xD4A6,0xD4A7,0xE5C5,0xD4A8,0xE5BA,0xC3BE,0x3F,0xE5BF,0xB0BD,0xCCCA,0x3F,0x3F,0xD4A9,0xD4AA,0xD4AB,0xD4AC,0xD4AD,0xE5BE,0x3F,0x3F,0xB6DB,0xC8EC,0xD4AE,0xD4AF,0xD4B0,0xC1ED,0x3F,0xCED0,0xBDEF,0x3F,0x3F,0xE5EE,0x3F,0xD4B1,0xE5C8,0xD4B2,0xC0FE,0x3F,0xE5C4,0xE5C9,0xE5CB,0x3F,0xC4F9,0xE5CE,0xD4B4,0x3F,0xE5CA,0xD4B5,0xD4B6,0x3F,0xCAD4,0xB4CB,0xD4B7,0xD4B8,0xCCCB,0xD4B9,0x3F,0xB0DE,0x3F,0xD4BA,0xE5CD,0x3F,0xCEFD,0xD4BB,0xD4BC,0x3F,0x3F,0xD4BD,0xD4BE,0xE5CC,0x3F,0x3F,0x3F,0x3F},
	set7D[] = {1,0xFF,1,3,1,1,1,3,3,3,1,1,0xFF,1,0xFF,3,1,3,3,3,1,1,3,1,1,1,1,1,1,3,3,0xFF,1,1,1,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,1,1,3,1,1,1,3,1,1,0xFF,1,0xFF,0xFF,0xFF,1,1,0xFF,3,3,3,1,3,3,1,1,1,1,1,3,3,0xFF,0xFF,1,1,3,1,1,1,3,0xFF,3,0xFF,0xFF,1,3,0xFF,3,3,1,3,3,1,0xFF,0xFF,1,1,1,0xFF,3,1,3,1,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,3,1,1,1,0xFF,1,1,0xFF,3,1,3,3,0xFF,1,0xFF,3,0xFF,3,3,3,0xFF,3,3,0xFF,3,1,0xFF,3,3,3,0xFF,1,0xFF,3,0xFF,1,0xFF,0xFF,3,3,0xFF,1,1,1,1,3,3,1,0xFF,0xFF,1,1,0xFF,0xFF,3,3,0xFF,0xFF,3,1,1,1,1,1,1,1,1,3,1,1,3,3,1,3,1,1,0xFF,1,1,1,0xFF,0xFF,3,3,3,3,3,1,0xFF,0xFF,1,1,3,3,3,1,0xFF,1,1,0xFF,0xFF,1,0xFF,3,1,3,1,0xFF,1,1,1,0xFF,1,1,3,0xFF,1,3,3,0xFF,1,1,3,3,1,3,0xFF,1,0xFF,3,1,0xFF,1,3,3,0xFF,0xFF,3,3,1,0xFF,0xFF,0xFF,0xFF},
	en7E[] = {0xD4B3,0xB1EF,0x3F,0x3F,0xC6EC,0xE5CF,0x3F,0x3F,0xD4BF,0xE5D6,0xE5D0,0xE5D7,0x3F,0x3F,0x3F,0x3F,0xD4C0,0xD4C1,0xE5D3,0x3F,0x3F,0xD4C2,0x3F,0xD4C3,0x3F,0x3F,0x3F,0xC7FB,0xD4C4,0xD4C5,0xBCCA,0xE5D5,0xD4C6,0xE5D2,0xE5D8,0xE5D1,0x3F,0x3F,0xBDC4,0xD4C7,0xD4C8,0x3F,0x3F,0xCBA5,0xD4C9,0xD4CA,0xBDCC,0xD4CB,0x3F,0xE5D4,0xE5E0,0xD4CC,0x3F,0xE5DC,0xD4CD,0xE5DF,0x3F,0xE5DD,0xE5E1,0xE5DB,0x3F,0xE5C1,0xC0D3,0xD4CE,0x3F,0xC8CB,0x3F,0xE5DE,0xD4CF,0xD4D0,0xE5D9,0xD4D1,0x3F,0x3F,0xC1A1,0xB7D2,0x3F,0xBDAB,0xD4D2,0x3F,0xD4D3,0x3F,0xD4D4,0x3F,0xBFA5,0xC1B6,0xE5E4,0x3F,0xD4D5,0xE5E6,0xE5E7,0x3F,0x3F,0xE5E3,0xE5E5,0xD4D6,0x3F,0xD4D7,0xD4D8,0x3F,0x3F,0xD4D9,0xE5DA,0xE5E2,0x3F,0xE5EA,0xE5E9,0xD4DA,0x3F,0xCBFA,0xD4DB,0xD4DC,0xB7AB,0x3F,0x3F,0xD4DD,0x3F,0x3F,0x3F,0x3F,0xD4DE,0xE5E8,0x3F,0xE5EC,0xE5EB,0xE5EF,0xD4DF,0xE5F1,0x3F,0xD4E0,0xBBBC,0xE5ED,0x3F,0x3F,0xD4E1,0xD4E2,0xE5F2,0xE5F3,0xD4E3,0x3F,0xE5F4,0xD4E4,0xE5FA,0xC5BB,0xE5F6,0xD4E5,0xE5F5,0xE5F7,0xE5F8,0xD4E6,0xE5F9,0x3F,0xD4E7,0x3F,0xD4E8,0xE5FB,0xE5FC,0xD4E9,0xD4EA,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set7E[] = {3,1,0xFF,0xFF,1,1,0xFF,0xFF,3,1,1,1,0xFF,0xFF,0xFF,0xFF,3,3,1,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,1,3,3,1,1,3,1,1,1,0xFF,0xFF,1,3,3,0xFF,0xFF,1,3,3,1,3,0xFF,1,1,3,0xFF,1,3,1,0xFF,1,1,1,0xFF,1,1,3,0xFF,1,0xFF,1,3,3,1,3,0xFF,0xFF,1,1,0xFF,1,3,0xFF,3,0xFF,3,0xFF,1,1,1,0xFF,3,1,1,0xFF,0xFF,1,1,3,0xFF,3,3,0xFF,0xFF,3,1,1,0xFF,1,1,3,0xFF,1,3,3,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,1,0xFF,1,1,1,3,1,0xFF,3,1,1,0xFF,0xFF,3,3,1,1,3,0xFF,1,3,1,1,1,3,1,1,1,3,1,0xFF,3,0xFF,3,1,1,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en7F[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB4CC,0x3F,0xE5FD,0x3F,0xE5FE,0xD4EC,0xD4EB,0xD4ED,0xD4EE,0xD4EF,0x3F,0x3F,0x3F,0xD4F0,0xD4F1,0xE6A1,0x3F,0xD4F2,0x3F,0x3F,0x3F,0x3F,0xE6A2,0xE6A3,0xE6A4,0xD4F3,0xE6A5,0xE6A6,0xD4F4,0xD4F5,0xE6A8,0xE6A7,0x3F,0x3F,0xE6A9,0x3F,0x3F,0xD4F6,0xD4F7,0xD4F8,0x3F,0xE6AA,0xE6AB,0xD4F9,0x3F,0xD4FA,0xD4FB,0xD4FC,0xD4FD,0xE6AE,0xE6AC,0xE6AD,0xBAE1,0xB7D3,0x3F,0xD4FE,0xC3D6,0x3F,0xC8B3,0xD5A1,0xBDF0,0x3F,0x3F,0xC7CD,0x3F,0xC8ED,0xE6AF,0xD8ED,0x3F,0x3F,0x3F,0xD5A2,0xD5A3,0xD5A4,0xD5A5,0x3F,0xE6B0,0xE6B2,0x3F,0xCDE5,0xE6B1,0xE6B4,0xE6B3,0x3F,0xCDD3,0xD5A6,0xE6B5,0xD5A7,0xC8FE,0xD5A8,0xD5A9,0xD5AA,0x3F,0x3F,0xE6B6,0x3F,0xD5AB,0xD5AC,0x3F,0x3F,0xE6B9,0x3F,0xD5AD,0xE6B8,0xE6B7,0x3F,0x3F,0xD5AE,0xD5AF,0xE6BA,0xB7B2,0x3F,0xD5B0,0x3F,0xC1A2,0xB5C1,0xD5B1,0x3F,0x3F,0xD5B2,0xE6BE,0xE6BB,0x3F,0x3F,0xE6BC,0x3F,0xD5B3,0x3F,0xE6BF,0x3F,0xE6C0,0xE6BD,0x3F,0x3F,0xD5B4,0xB1A9,0x3F,0xD5B5,0xD5B6,0xB2A7,0x3F,0xD5B7,0x3F,0xE6C2,0xE6C3,0x3F,0xD5B8,0x3F,0xE6C4,0x3F,0xCDE2,0x3F,0xD5B9,0xD5BA,0x3F,0x3F,0xBDAC,0x3F,0xE6C6,0xE6C5,0x3F,0x3F,0x3F,0x3F,0x3F,0xD5BB,0x3F,0x3F,0x3F,0xD5BC,0xBFE9,0xE6C7,0x3F,0xD5BD,0x3F,0xD5BE,0xE6C8,0x3F,0xD5BF,0xE6C9,0x3F,0xB4E5,0xD5C0,0x3F,0xD5C1,0xD5C2,0xB4CD,0x3F,0xD5C3,0xE6CA,0x3F,0x3F,0x3F,0x3F,0x3F,0xE6CB,0xD5C4,0xCBDD,0xCDE3,0xD5C5,0xD5C6,0xD5C7},
	set7F[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,1,3,3,3,3,3,0xFF,0xFF,0xFF,3,3,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,1,1,3,1,1,3,3,1,1,0xFF,0xFF,1,0xFF,0xFF,3,3,3,0xFF,1,1,3,0xFF,3,3,3,3,1,1,1,1,1,0xFF,3,1,0xFF,1,3,1,0xFF,0xFF,1,0xFF,1,1,1,0xFF,0xFF,0xFF,3,3,3,3,0xFF,1,1,0xFF,1,1,1,1,0xFF,1,3,1,3,1,3,3,3,0xFF,0xFF,1,0xFF,3,3,0xFF,0xFF,1,0xFF,3,1,1,0xFF,0xFF,3,3,1,1,0xFF,3,0xFF,1,1,3,0xFF,0xFF,3,1,1,0xFF,0xFF,1,0xFF,3,0xFF,1,0xFF,1,1,0xFF,0xFF,3,1,0xFF,3,3,1,0xFF,3,0xFF,1,1,0xFF,3,0xFF,1,0xFF,1,0xFF,3,3,0xFF,0xFF,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,1,1,0xFF,3,0xFF,3,1,0xFF,3,1,0xFF,1,3,0xFF,3,3,1,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,1,1,3,3,3},
	en80[] = {0xCDD4,0xCFB7,0x3F,0xB9CD,0xE6CE,0xBCD4,0xE6CD,0xD5C8,0xD5C9,0x3F,0xD5CA,0xE6CF,0xBCA9,0xD5CB,0xD5CC,0xD5CD,0xC2D1,0xD5CE,0xE6D0,0xD5CF,0xD5D0,0xB9CC,0xD5D1,0xCCD7,0xE6D1,0xE6D2,0x3F,0x3F,0xE6D3,0xD5D2,0xD5D3,0xD5D4,0xD5D5,0xE6D4,0x3F,0x3F,0xD5D6,0x3F,0xD5D7,0x3F,0xE6D5,0x3F,0x3F,0x3F,0xD5D8,0x3F,0xD5D9,0x3F,0xD5DA,0x3F,0x3F,0xBCAA,0xD5DB,0xD5DC,0xCCED,0xD5DD,0x3F,0xD5DE,0xD5DF,0xE6D7,0xD5E0,0xC3BF,0xD5E1,0xE6D6,0xD5E2,0x3F,0x3F,0x3F,0xD5E3,0x3F,0xE6D9,0x3F,0x3F,0x3F,0xE6D8,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE6DA,0x3F,0x3F,0x3F,0xC0BB,0x3F,0xE6DB,0x3F,0xE6DC,0x3F,0x3F,0x3F,0xCAB9,0xE6DD,0xD5E4,0xC1EF,0xE6DE,0x3F,0xD5E5,0x3F,0xD5E6,0x3F,0xE6DF,0x3F,0x3F,0x3F,0x3F,0xD5E7,0x3F,0xCEFE,0xE6E2,0xD5E8,0xE6E1,0xE6E0,0xC4B0,0xD5E9,0xE6E3,0xBFA6,0x3F,0xE6E4,0x3F,0x3F,0x3F,0xE6E5,0xCFB8,0xE6E6,0x3F,0xD5EA,0x3F,0x3F,0xE6E7,0xE6E9,0xE6E8,0xC8A5,0xD5EB,0xC6F9,0x3F,0xCFBE,0xC8A9,0x3F,0xD5EC,0x3F,0x3F,0x3F,0x3F,0xE6EB,0x3F,0x3F,0xBED3,0x3F,0xC9AA,0x3F,0xE6EC,0xE6EA,0xD5ED,0xB4CE,0xD5EE,0x3F,0x3F,0xB8D4,0xBBE8,0x3F,0x3F,0xC8EE,0xD5EF,0xD5F0,0x3F,0xB8AA,0xCBC3,0xD5F1,0xE6EF,0xE6ED,0x3F,0xB9CE,0x3F,0xB9CF,0xB0E9,0x3F,0xBAE8,0x3F,0x3F,0x3F,0xD5F2,0xD5F3,0xC7D9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB0DF,0xE6F4,0x3F,0xC3C0,0x3F,0xD5F4,0x3F,0x3F,0x3F,0xC7D8,0xD5F5,0xC2DB,0xD5F6,0x3F,0x3F,0xD5F7,0x3F,0xD5F8,0xD5F9,0xE6F6,0xD5FA,0xD5FB,0xE6F2,0xE6F5,0xE6F0,0x3F,0xE6F3,0xCBA6,0x3F,0xD5FC,0xB8D5,0x3F,0x3F,0xB0FD,0xE6F1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD5FD,0xD5FE,0xE6F8,0xD6A1,0xE6F9,0xD6A2,0xD6A3,0xC6B9,0x3F,0xD6A4,0x3F,0xB6BB,0xD6A5,0xD6A6,0x3F,0xE7A6,0xC7BD,0xD6A7,0x3F},
	set80[] = {1,1,0xFF,1,1,1,1,3,3,0xFF,3,1,1,3,3,3,1,3,1,3,3,1,3,1,1,1,0xFF,0xFF,1,3,3,3,3,1,0xFF,0xFF,3,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,3,0xFF,0xFF,1,3,3,1,3,0xFF,3,3,1,3,1,3,1,3,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,1,1,3,1,1,0xFF,3,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,1,3,1,1,1,3,1,1,0xFF,1,0xFF,0xFF,0xFF,1,1,1,0xFF,3,0xFF,0xFF,1,1,1,1,3,1,0xFF,1,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,1,0xFF,1,1,3,1,3,0xFF,0xFF,1,1,0xFF,0xFF,1,3,3,0xFF,1,1,3,1,1,0xFF,1,0xFF,1,1,0xFF,1,0xFF,0xFF,0xFF,3,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,1,3,1,3,0xFF,0xFF,3,0xFF,3,3,1,3,3,1,1,1,0xFF,1,1,0xFF,3,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,1,3,1,3,3,1,0xFF,3,0xFF,1,3,3,0xFF,1,1,3,0xFF},
	en81[] = {0x3F,0x3F,0xBBE9,0xD6A8,0x3F,0xB6BC,0xC0C8,0xCFC6,0xCCAE,0xE6F7,0xC0D4,0xD6A9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD6AA,0xD6AB,0xD6AC,0x3F,0xB5D3,0xE6FA,0xD6AD,0x3F,0xD6AE,0x3F,0xD6AF,0x3F,0x3F,0xE6FC,0xD6B0,0x3F,0x3F,0xD6B1,0x3F,0xE6FB,0x3F,0x3F,0xD6B2,0x3F,0x3F,0xE6FD,0xD6B3,0xC3A6,0x3F,0xC7BE,0x3F,0xD6B4,0x3F,0x3F,0x3F,0xC4B1,0xD6B5,0x3F,0xD6B6,0x3F,0xE7A3,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD6B7,0xE7A2,0xD6B8,0x3F,0x3F,0xD6B9,0xE6FE,0xD6BA,0x3F,0xBFD5,0x3F,0xC9E5,0xE7A5,0xD6BB,0xE7A4,0xB9D0,0xCFD3,0x3F,0xD6BC,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE7B5,0xD6BD,0xD6BE,0x3F,0x3F,0x3F,0xE7A9,0xE7AA,0xD6BF,0xD6C0,0xD6C1,0x3F,0xBCF0,0x3F,0xD6C2,0xE7A8,0xD6C3,0xB9F8,0xE7A7,0x3F,0x3F,0xE7AB,0x3F,0x3F,0xD6C4,0xC4B2,0xCAA2,0xC1A3,0x3F,0x3F,0x3F,0x3F,0xC2DC,0xE7AF,0xD6C5,0xE7B0,0xE7AC,0xD6C7,0xD6C8,0xD6C9,0x3F,0xE7AD,0x3F,0xE7AE,0xD6CA,0x3F,0x3F,0xD6CB,0xB9D1,0xD6C6,0x3F,0x3F,0xE7B6,0x3F,0xE7B2,0xD6CC,0x3F,0xD6CD,0x3F,0xC9E6,0xD6CE,0xCBEC,0xC9A8,0xD6CF,0x3F,0xE7B1,0x3F,0xD6D0,0xE7B4,0xE7B3,0x3F,0x3F,0x3F,0xCBC4,0xE7B7,0x3F,0x3F,0x3F,0x3F,0xD6D1,0x3F,0xE7B8,0x3F,0xD6D2,0xC1B7,0xD6D3,0xE7B9,0x3F,0x3F,0xE7BB,0x3F,0xE7BF,0xD6D4,0x3F,0xE7BC,0xE7BA,0xC7BF,0xE7BD,0x3F,0xE7BE,0xD6D6,0x3F,0xD6D7,0xB2B2,0x3F,0xE7C5,0xE7C0,0xD6D8,0xD6D5,0x3F,0xE7C1,0xD6D9,0xD6DA,0x3F,0xE7C2,0x3F,0xC2A1,0x3F,0xD6DB,0x3F,0xD6DC,0xE7C4,0xE7C3,0xE7C6,0xD6DD,0x3F,0xD6DE,0xD6DF,0xE7C7,0xE7C8,0xD6E0,0x3F,0xBFC3,0xD6E1,0xB2E9,0x3F,0xE7C9,0xCED7,0x3F,0xBCAB,0xD6E2,0xD6E3,0xBDAD,0x3F,0x3F,0xD6E4,0xD6E5,0xD6E6,0xBBEA,0xC3D7,0xD6E7,0xD6E8,0x3F,0xD6E9,0xD6EA,0xE7CA,0xE7CB,0xB1B1,0xD6EB,0xE7CC,0xD6EC},
	set81[] = {0xFF,0xFF,1,3,0xFF,1,1,1,1,1,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,3,0xFF,1,1,3,0xFF,3,0xFF,3,0xFF,0xFF,1,3,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,1,3,1,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,1,3,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,3,0xFF,0xFF,3,1,3,0xFF,1,0xFF,1,1,3,1,1,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,0xFF,0xFF,0xFF,1,1,3,3,3,0xFF,1,0xFF,3,1,3,1,1,0xFF,0xFF,1,0xFF,0xFF,3,1,1,1,0xFF,0xFF,0xFF,0xFF,1,1,3,1,1,3,3,3,0xFF,1,0xFF,1,3,0xFF,0xFF,3,1,3,0xFF,0xFF,1,0xFF,1,3,0xFF,3,0xFF,1,3,1,1,3,0xFF,1,0xFF,3,1,1,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,3,1,3,1,0xFF,0xFF,1,0xFF,1,3,0xFF,1,1,1,1,0xFF,1,3,0xFF,3,1,0xFF,1,1,3,3,0xFF,1,3,3,0xFF,1,0xFF,1,0xFF,3,0xFF,3,1,1,1,3,0xFF,3,3,1,1,3,0xFF,1,3,1,0xFF,1,1,0xFF,1,3,3,1,0xFF,0xFF,3,3,3,1,1,3,3,0xFF,3,3,1,1,1,3,1,3},
	en82[] = {0xD6ED,0xE7CD,0xE7CE,0xD6EE,0x3F,0xE7CF,0x3F,0xE7D0,0xB6BD,0xDAAA,0xE7D1,0x3F,0xC0E5,0xE7D2,0xBCCB,0xD6EF,0xE7D3,0x3F,0xD0B0,0xD6F0,0xD6F1,0x3F,0xE7D4,0xCADE,0xB4DC,0xD6F2,0xD6F3,0xC1A4,0xBDD8,0xD6F4,0xC9F1,0xBDAE,0x3F,0xD6F5,0xD6F6,0x3F,0x3F,0x3F,0x3F,0x3F,0xD6F7,0xE7D5,0xB9D2,0xE7D6,0xC8CC,0x3F,0xE7E4,0x3F,0x3F,0x3F,0xD6F8,0xE7D8,0xD6F9,0xC2C9,0xC7F5,0xB8BF,0xE7D7,0xC1A5,0xD6FA,0x3F,0x3F,0x3F,0x3F,0x3F,0xE7D9,0x3F,0x3F,0xD6FB,0xD6FC,0xD6FD,0xD6FE,0xC4FA,0x3F,0x3F,0x3F,0xD7A1,0x3F,0x3F,0xD7A2,0xD7A3,0x3F,0xD7A4,0x3F,0x3F,0x3F,0x3F,0xD7A5,0x3F,0xE7DB,0xE7DA,0xE7DD,0x3F,0xD7A6,0xE7DC,0x3F,0xE7DE,0xD7A7,0x3F,0xE7E0,0xD7A8,0xE7DF,0x3F,0xB4CF,0xD7A9,0xE7E1,0x3F,0xE7E2,0xE7E3,0x3F,0xD7AA,0xBAB1,0xCEC9,0x3F,0xE7E5,0xBFA7,0x3F,0xD7AB,0x3F,0xB1F0,0xE7E6,0xE7E7,0x3F,0x3F,0xD7AC,0x3F,0xD7AD,0xE7E8,0xD7AE,0xD7AF,0xD7B0,0x3F,0xD7B1,0xD7B2,0x3F,0x3F,0xD7B3,0x3F,0xD7B4,0xD7B5,0xB0F2,0x3F,0xE7E9,0xD7B6,0x3F,0x3F,0xD7B7,0xE7EA,0x3F,0xD7B8,0x3F,0xD7B9,0x3F,0xD7BA,0xC9E7,0xD7BB,0xD7BC,0x3F,0xBCC7,0x3F,0xE7EC,0xD7BD,0xD7BE,0x3F,0xD7BF,0xD7C0,0xB3A9,0xB0B2,0xD7C1,0xD7C2,0xD7C3,0xD7C4,0xE7EB,0xE7EE,0xC7CE,0xD7C5,0xBFC4,0xD7C6,0xB2D6,0xD7C7,0xCBA7,0xD7C8,0x3F,0x3F,0xD7C9,0xB7DD,0xB6DC,0xD7CA,0xE7ED,0xD7CB,0xB2EA,0xD7CC,0xD7CD,0x3F,0x3F,0x3F,0x3F,0x3F,0xB4A3,0xD7CE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD7CF,0xB1F1,0xE7F2,0xCEEA,0xC2DD,0xD7D0,0x3F,0xC9C4,0x3F,0xE7FE,0xD7D1,0xB2D7,0xE7FC,0x3F,0xE7FA,0xE7F1,0xD7D2,0xE7EF,0xD7D3,0xE7F0,0xD7D4,0xBCE3,0xB6EC,0xC3F7,0xD7D5,0x3F,0xD7D6,0xC6D1,0x3F,0xD7D7,0x3F,0xD7D8,0x3F,0xB1D1,0x3F,0xE7F4,0xE7F3,0x3F,0xD7D9,0xD7DA,0x3F,0xE7F9,0xE7F5,0xE7F8,0x3F,0xD7DB,0xD7DC,0x3F},
	set82[] = {3,1,1,3,0xFF,1,0xFF,1,1,1,1,0xFF,1,1,1,3,1,0xFF,1,3,3,0xFF,1,1,1,3,3,1,1,3,1,1,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,1,1,1,0xFF,1,0xFF,0xFF,0xFF,3,1,3,1,1,1,1,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,3,3,3,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,1,1,0xFF,3,1,0xFF,1,3,0xFF,1,3,1,0xFF,1,3,1,0xFF,1,1,0xFF,3,1,1,0xFF,1,1,0xFF,3,0xFF,1,1,1,0xFF,0xFF,3,0xFF,3,1,3,3,3,0xFF,3,3,0xFF,0xFF,3,0xFF,3,3,1,0xFF,1,3,0xFF,0xFF,3,1,0xFF,3,0xFF,3,0xFF,3,1,3,3,0xFF,1,0xFF,1,3,3,0xFF,3,3,1,1,3,3,3,3,1,1,1,3,1,3,1,3,1,3,0xFF,0xFF,3,1,1,3,1,3,1,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,1,1,1,3,0xFF,1,0xFF,1,3,1,1,0xFF,1,1,3,1,3,1,3,1,1,1,3,0xFF,3,1,0xFF,3,0xFF,3,0xFF,1,0xFF,1,1,0xFF,3,3,0xFF,1,1,1,0xFF,3,3,0xFF},
	en83[] = {0xD7DD,0xD7DE,0xCCD0,0xE7F7,0xB2D8,0xB3FD,0xE7FB,0xD7DF,0xD7E0,0xE7FD,0xD7E1,0xD7E2,0x3F,0x3F,0xB7D4,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE8A3,0xE8AC,0xE8AD,0x3F,0x3F,0xD7E4,0xB0AB,0xD7E5,0xD7E6,0xD7E7,0x3F,0xD7E8,0xD7E9,0xE8B4,0x3F,0x3F,0x3F,0x3F,0xB0F1,0x3F,0x3F,0xE8AB,0xD7EA,0xD7EB,0xD7EC,0xE8AA,0xD7ED,0xE8A5,0xE8A4,0xD7EE,0xE8A2,0xE8A1,0xC3E3,0xD7EF,0xC2FB,0xE8A7,0xD7F0,0x3F,0xD7F1,0xD7F2,0x3F,0x3F,0xE8A6,0x3F,0xD7F3,0xD7F4,0xD7F5,0xE8A9,0x3F,0xD7F6,0x3F,0xC1F0,0xB7D5,0x3F,0x3F,0xD7F7,0xD7F8,0xB1C1,0xE8A8,0xD7F9,0xB9D3,0xD8BE,0xD7E3,0xD7FA,0xD7FB,0xD7FC,0xC1F1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD7FD,0x3F,0x3F,0xE8BA,0x3F,0xE8BB,0x3F,0xB2D9,0xD7FE,0x3F,0x3F,0xB2AE,0xE8B8,0xD8A1,0x3F,0xD8A2,0xD8A3,0x3F,0xD8A4,0x3F,0xD8A5,0xE8AE,0xD8A6,0xE8B6,0x3F,0xE8BD,0xE8B7,0x3F,0x3F,0xD8A7,0xE8B5,0x3F,0x3F,0x3F,0xD8A8,0xE7F6,0xD8A9,0xD8AA,0xE8B3,0x3F,0xD8AB,0xD8AC,0xE8AF,0xD8AD,0xD8AE,0xD8AF,0xB4D0,0xE8B1,0xE8BC,0x3F,0xE8B2,0x3F,0x3F,0x3F,0xD8B0,0xD8B1,0xE8BE,0xD8B2,0xE8B0,0xC7FC,0xD8B3,0xD8CC,0x3F,0x3F,0x3F,0xCDE9,0x3F,0x3F,0x3F,0xE8B9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE8CF,0xD8B4,0xD8B5,0xD8B6,0xE8C7,0x3F,0x3F,0x3F,0xBFFB,0x3F,0xD8B7,0x3F,0xD8B8,0xB5C6,0x3F,0xB6DD,0x3F,0xE8C2,0xD8B9,0xD8BA,0xD8BB,0x3F,0xB2DB,0xD8BC,0x3F,0xBED4,0x3F,0xE8C5,0x3F,0x3F,0x3F,0xBADA,0xD8BD,0x3F,0xC5D1,0xE8CA,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD8BF,0xCAEE,0xD8C0,0xE8C1,0x3F,0x3F,0x3F,0xB2DA,0xB8D6,0xC9A9,0xE8CB,0x3F,0xE8BF,0x3F,0xD8C1,0xE8C8,0xD8C2,0xD8C3,0x3F,0xE8D2,0xD8C4,0xE8C3,0x3F,0x3F},
	set83[] = {3,3,1,1,1,1,1,3,3,1,3,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF,0xFF,3,1,3,3,3,0xFF,3,3,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,3,3,3,1,3,1,1,3,1,1,1,3,1,1,3,0xFF,3,3,0xFF,0xFF,1,0xFF,3,3,3,1,0xFF,3,0xFF,1,1,0xFF,0xFF,3,3,1,1,3,1,3,3,3,3,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,1,0xFF,1,3,0xFF,0xFF,1,1,3,0xFF,3,3,0xFF,3,0xFF,3,1,3,1,0xFF,1,1,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,3,1,3,3,1,0xFF,3,3,1,3,3,3,1,1,1,0xFF,1,0xFF,0xFF,0xFF,3,3,1,3,1,1,3,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,3,1,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,3,1,0xFF,1,0xFF,1,3,3,3,0xFF,1,3,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,1,3,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,3,1,0xFF,0xFF,0xFF,1,1,1,1,0xFF,1,0xFF,3,1,3,3,0xFF,1,3,1,0xFF,0xFF},
	en84[] = {0x3F,0xD8C5,0x3F,0xE8C4,0xC6BA,0x3F,0xD8C6,0xE8C9,0x3F,0x3F,0xD8C7,0xE8C6,0xCBA8,0xE8CC,0xB0E0,0xD8C8,0x3F,0xD8C9,0x3F,0xE8C0,0x3F,0xD8CA,0x3F,0x3F,0x3F,0xD8CB,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE8CE,0x3F,0xE8CD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC7EB,0xE8D4,0x3F,0xE8DF,0x3F,0x3F,0xD8CD,0x3F,0xB3FE,0x3F,0x3F,0x3F,0xE8E2,0x3F,0x3F,0xE8D0,0xD8CE,0x3F,0x3F,0xE8D5,0xCDEE,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD8CF,0xE8DE,0xD8D0,0xD8D1,0xCDD5,0xD8D2,0x3F,0x3F,0xD8D3,0xCEAA,0xD8D4,0x3F,0xD8D5,0xD8D6,0x3F,0x3F,0x3F,0xD8D7,0xC3F8,0xD8D8,0xD8D9,0xD8DA,0xB3EB,0xD8DB,0x3F,0x3F,0x3F,0xD8DC,0xC9F2,0xE8E4,0xC6A1,0xD8DD,0xD8DE,0xB0B1,0xD8DF,0x3F,0xE8DD,0xD8E0,0xE8D9,0xC1F2,0xE8D3,0xE8DB,0xE8E0,0xD8E1,0xC7AC,0x3F,0xD8E2,0xD8E3,0xB0AA,0xD8E4,0xE8D8,0xD8E5,0xE8E1,0xC9F8,0x3F,0xD8E6,0xD8E7,0x3F,0x3F,0x3F,0xD8E8,0xE8DC,0x3F,0xE8D7,0xD8E9,0x3F,0x3F,0x3F,0x3F,0x3F,0xBED5,0x3F,0x3F,0x3F,0x3F,0xBDAF,0x3F,0xD8EA,0xD8EB,0xBCAC,0xD8EC,0x3F,0x3F,0x3F,0xCCD8,0x3F,0x3F,0xC9C7,0x3F,0xD8ED,0xE8E7,0x3F,0xE8F0,0x3F,0x3F,0x3F,0x3F,0xD8EE,0x3F,0xD8EF,0xD8F0,0xD8F1,0x3F,0x3F,0xE8DA,0x3F,0xD8F2,0x3F,0xD8F3,0xB3F7,0x3F,0xD8F4,0x3F,0x3F,0x3F,0xBEF8,0xE8E5,0xD8F5,0xE8EA,0xC1F3,0xD8F6,0xD8F7,0xE8E6,0xD8F8,0xE8ED,0xD8F9,0x3F,0xC3DF,0x3F,0xE8EE,0xD8FA,0xD8FB,0xCDD6,0xE8E3,0xB3B8,0xD8FC,0xE8E9,0x3F,0xD8FD,0xE8EC,0xCCAC,0x3F,0xD8FE,0x3F,0x3F,0xE8EF,0x3F,0x3F,0xE8E8,0xE8EB,0x3F,0xD9A1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xD9A2,0x3F,0x3F,0xD9A3,0x3F,0xCBA9,0x3F,0xCFA1,0xD9A4,0xD9A5,0xD9A6,0xD9A7,0x3F,0xE8F3,0x3F,0x3F,0xD9A8,0x3F,0x3F,0xD9AA,0xD9AB,0xE8FA,0xD9AC,0x3F,0xE8F2},
	set84[] = {0xFF,3,0xFF,1,1,0xFF,3,1,0xFF,0xFF,3,1,1,1,1,3,0xFF,3,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,1,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,3,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,3,3,1,3,0xFF,0xFF,3,1,3,0xFF,3,3,0xFF,0xFF,0xFF,3,1,3,3,3,1,3,0xFF,0xFF,0xFF,3,1,1,1,3,3,1,3,0xFF,1,3,1,1,1,1,1,3,1,0xFF,3,3,1,3,1,3,1,1,0xFF,3,3,0xFF,0xFF,0xFF,3,1,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,3,1,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,3,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,3,3,0xFF,0xFF,1,0xFF,3,0xFF,3,1,0xFF,3,0xFF,0xFF,0xFF,1,1,3,1,1,3,3,1,3,1,3,0xFF,1,0xFF,1,3,3,1,1,1,3,1,0xFF,3,1,1,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,1,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,1,0xFF,1,3,3,3,3,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,3,3,1,3,0xFF,1},
	en85[] = {0xBCC3,0x3F,0xD9AD,0xD9AE,0x3F,0x3F,0xE8D1,0xD9AF,0x3F,0x3F,0x3F,0x3F,0xD9B0,0x3F,0xD9B1,0x3F,0xD9B2,0xCACE,0x3F,0xCCA2,0xE8F9,0xE8F8,0x3F,0xE8F4,0xE8F5,0x3F,0xB1B6,0x3F,0xD9B3,0x3F,0xD9B4,0xE8F7,0x3F,0xE8F1,0xD9B5,0xD9B6,0xD9B7,0xD9B8,0xC4D5,0xD9B9,0x3F,0x3F,0xD9BA,0xD9BB,0xE8F6,0xB0FE,0x3F,0xD9BC,0x3F,0x3F,0xD9A9,0xD9BD,0xD9BE,0xC2A2,0xD9BF,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCAC3,0x3F,0xD9C0,0xE8FB,0xE9A1,0x3F,0xC8D9,0x3F,0x3F,0xD9C1,0x3F,0xE8FE,0xBED6,0xBCC9,0xE9A3,0x3F,0x3F,0xB6BE,0xD9C2,0xD9C3,0xD9C4,0xD9C5,0xD9C6,0x3F,0xE9A4,0xD9C7,0xC9F9,0xE8FD,0xD9C8,0xE8D6,0x3F,0xD9C9,0xD9CA,0xD9CB,0xD9CC,0xD9CD,0xD9CE,0xD9CF,0xE8FC,0xD9D0,0x3F,0x3F,0x3F,0xCFCF,0xC6A2,0xC9F3,0xD9D1,0x3F,0xE9AB,0x3F,0xD9D2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE9B1,0x3F,0xD9D3,0xD9D4,0xD9D5,0x3F,0xD9D6,0xE9B2,0xD9D7,0xE9A5,0xD9D8,0x3F,0x3F,0xC7F6,0xD9D9,0xD9DA,0xE9AF,0xE9A7,0xD9DB,0xE9A9,0xD9DC,0xD9DD,0x3F,0x3F,0xD9DE,0xE9B3,0xE9A8,0x3F,0xD9DF,0xE9AC,0x3F,0x3F,0xB1F2,0xD9E0,0xC6E5,0x3F,0xE9AD,0xE9B0,0xD9E1,0x3F,0xD9E2,0xD9E3,0x3F,0xD9E4,0x3F,0xE9A6,0xD9E5,0xC1A6,0xD9E6,0xE9AA,0xBBA7,0xBFC5,0xB7B0,0xCCF4,0xD9F4,0xCCF9,0xBDF2,0x3F,0x3F,0x3F,0x3F,0xD9E7,0x3F,0xD9E8,0xD9E9,0xD9EA,0xE9B7,0xE9B5,0x3F,0xD9EB,0xD9EC,0xD9ED,0xD9EE,0x3F,0xCFCE,0xD9EF,0x3F,0x3F,0x3F,0x3F,0xD9F0,0x3F,0xE9B4,0xD9F1,0xD9F2,0x3F,0xCDF5,0xD9F3,0xE9B6,0xE9B8,0x3F,0x3F,0x3F,0x3F,0xE9B9,0x3F,0x3F,0xD9F5,0x3F,0xD9F6,0x3F,0xE9BC,0xE9BA,0x3F,0xD9F7,0xD9F8,0x3F,0x3F,0x3F,0xC6A3,0xE9BB,0xD9F9,0x3F,0xD9FA,0xC8CD,0xE9AE,0x3F,0x3F,0xD9FB,0x3F,0x3F,0x3F,0x3F,0x3F,0xD9FC,0x3F,0x3F,0xD9FD,0xBDF3,0x3F,0xE9BD,0xE9C2,0xC1F4,0xD9FE,0x3F,0xE9C1,0xDAA1},
	set85[] = {1,0xFF,3,3,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,3,1,0xFF,1,1,1,0xFF,1,1,0xFF,1,0xFF,3,0xFF,3,1,0xFF,1,3,3,3,3,1,3,0xFF,0xFF,3,3,1,1,0xFF,3,0xFF,0xFF,3,3,3,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,1,1,0xFF,1,0xFF,0xFF,3,0xFF,1,1,1,1,0xFF,0xFF,1,3,3,3,3,3,0xFF,1,3,1,1,3,1,0xFF,3,3,3,3,3,3,3,1,3,0xFF,0xFF,0xFF,1,1,1,3,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,3,3,0xFF,3,1,3,1,3,0xFF,0xFF,1,3,3,1,1,3,1,3,3,0xFF,0xFF,3,1,1,0xFF,3,1,0xFF,0xFF,1,3,1,0xFF,1,1,3,0xFF,3,3,0xFF,3,0xFF,1,3,1,3,1,1,1,1,1,3,1,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,3,3,1,1,0xFF,3,3,3,3,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,3,3,0xFF,1,3,1,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,3,0xFF,1,1,0xFF,3,3,0xFF,0xFF,0xFF,1,1,3,0xFF,3,1,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,1,0xFF,1,1,1,3,0xFF,1,3},
	en86[] = {0xDAA2,0x3F,0xE9A2,0x3F,0xDAA3,0xDAA4,0xE9C3,0xC1C9,0x3F,0x3F,0xE9BE,0xE9C0,0x3F,0xDAA5,0xDAA6,0x3F,0xDAA7,0xDAA8,0xDAA9,0xE9BF,0x3F,0x3F,0xDDB1,0xDDA2,0xDAAA,0xDAAB,0xE9C5,0xDAAC,0x3F,0x3F,0xDAAD,0x3F,0x3F,0xDAAE,0xE9C4,0x3F,0x3F,0x3F,0x3F,0xDAAF,0x3F,0xDAB0,0x3F,0x3F,0x3F,0xCDF6,0x3F,0xE2BC,0xE9C6,0x3F,0x3F,0x3F,0x3F,0x3F,0xDAB1,0x3F,0xDAB2,0x3F,0xDAB3,0x3F,0xDAB4,0xDAB5,0x3F,0xE9C7,0xDAB6,0xB8E6,0xDAB7,0x3F,0x3F,0x3F,0xDAB8,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE9C8,0xB8D7,0x3F,0xB5D4,0x3F,0xDAB9,0xDABA,0xE9CA,0xD1DD,0xDABB,0xDABC,0xDABD,0xDABE,0xB5F5,0x3F,0xCEBA,0xDABF,0xB6F3,0xE9CB,0xDAC0,0xDAC1,0xDAC2,0xDAC3,0xDAC4,0x3F,0x3F,0xE9CC,0x3F,0xDAC5,0x3F,0xC3EE,0xDAC6,0x3F,0x3F,0xDAC7,0x3F,0xE9CD,0x3F,0x3F,0x3F,0xDAC8,0xDAC9,0xDACA,0x3F,0xC6FA,0xDACB,0xB0BA,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xDAED,0x3F,0xB2E3,0xE9D2,0xE9D3,0xDACC,0x3F,0x3F,0x3F,0xDACD,0x3F,0xE9CE,0x3F,0xBBBD,0xDACE,0x3F,0xDACF,0x3F,0xDAD0,0x3F,0xDAD1,0x3F,0x3F,0x3F,0x3F,0xDAD2,0x3F,0xE9CF,0xC7C2,0x3F,0xDAD3,0xDAD4,0xDAD5,0xE9D0,0xE9D1,0xE9DB,0x3F,0xDAD6,0x3F,0xE9D5,0xE9D8,0xDAD7,0x3F,0xDAD8,0xDAD9,0xDADA,0xE9D4,0xDADB,0xDADC,0xDADD,0x3F,0x3F,0x3F,0x3F,0x3F,0xDADE,0xDADF,0xDAE0,0x3F,0xDAE1,0xE9D6,0xDAE2,0xE9D7,0xBCD8,0x3F,0xE9D9,0x3F,0xC3C1,0x3F,0xB7D6,0xB3C2,0x3F,0x3F,0xDAE3,0xDAE4,0x3F,0xE9DC,0xDAE5,0x3F,0xDAE6,0x3F,0xB3BF,0xDAE7,0xE9E1,0xDAE8,0x3F,0xE9DD,0xE9E0,0xDAE9,0x3F,0x3F,0xDAEA,0xC8BA,0xDAEB,0x3F,0xDAEC,0x3F,0xE9DE,0x3F,0x3F,0xE9DF,0xC9C8,0xC8DA,0xE9E2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC2FD,0xE9EC,0xDAEE,0xE9E8,0xDAEF,0xDAF0,0xB2EB,0x3F},
	set86[] = {3,0xFF,1,0xFF,3,3,1,1,0xFF,0xFF,1,1,0xFF,3,3,0xFF,3,3,3,1,0xFF,0xFF,1,1,3,3,1,3,0xFF,0xFF,3,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,3,0xFF,3,3,0xFF,1,3,3,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,1,0xFF,3,3,1,1,3,3,3,3,1,0xFF,1,3,1,1,3,3,3,3,3,0xFF,0xFF,1,0xFF,3,0xFF,1,3,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,3,3,3,0xFF,1,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,1,1,3,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,1,3,0xFF,3,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,1,0xFF,3,3,3,1,1,1,0xFF,3,0xFF,1,1,3,0xFF,3,3,3,1,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,3,0xFF,3,1,3,1,1,0xFF,1,0xFF,1,0xFF,1,1,0xFF,0xFF,3,3,0xFF,1,3,0xFF,3,0xFF,1,3,1,3,0xFF,1,1,3,0xFF,0xFF,3,1,3,0xFF,3,0xFF,1,0xFF,0xFF,1,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,3,1,3,3,1,0xFF},
	en87[] = {0xE9E6,0x3F,0xCBAA,0xE9E7,0xDAF1,0xDAF2,0xE9E4,0xDAF3,0xE9E5,0xE9EA,0xE9ED,0xDAF4,0x3F,0xE9EB,0xDAF5,0xDAF6,0xDAF7,0xE9E9,0xE9E3,0xDAF8,0xDAF9,0x3F,0x3F,0x3F,0xC3D8,0xDAFA,0xE9F4,0x3F,0xCCAA,0x3F,0xDAFB,0xDAFC,0x3F,0xDAFD,0x3F,0xDAFE,0x3F,0xE9F2,0x3F,0x3F,0xDBA1,0xE9F3,0x3F,0x3F,0x3F,0x3F,0xDBA2,0xDBA3,0x3F,0xDBA4,0xDBA5,0x3F,0xE9EE,0x3F,0x3F,0xE9F0,0x3F,0xDBA6,0xDBA7,0xE9F1,0xDBA8,0xDBA9,0xDBAA,0xE9EF,0xDBAB,0x3F,0x3F,0xDBAC,0x3F,0xDBAD,0x3F,0x3F,0x3F,0xC0E6,0x3F,0xCFB9,0xE9F8,0xDBAE,0xE9F9,0x3F,0x3F,0x3F,0x3F,0xEAA1,0x3F,0xBFAA,0x3F,0xE9FB,0xDBAF,0xE9FE,0x3F,0x3F,0x3F,0xDBB0,0x3F,0xE9F6,0xE9F5,0xDBB1,0x3F,0xEAA2,0xDBB2,0xDBB3,0xB2DC,0x3F,0xE9FC,0x3F,0xEAA3,0x3F,0x3F,0x3F,0xE9FD,0xDBB4,0x3F,0xDBB5,0xDBB6,0x3F,0xE9FA,0x3F,0xC4B3,0x3F,0xE9F7,0x3F,0x3F,0xDBB7,0x3F,0x3F,0x3F,0xC7E8,0x3F,0x3F,0xEAA7,0xDBB8,0xDBB9,0xDBBA,0xDBBB,0xDBBC,0xDBBD,0xDBBE,0x3F,0xDBBF,0xDBC0,0xCDBB,0x3F,0x3F,0xDBC1,0x3F,0x3F,0xDBC2,0x3F,0xDBC3,0x3F,0xDBC4,0xDBC5,0xDBC6,0x3F,0x3F,0x3F,0x3F,0xDBC7,0xEAA6,0xDBC8,0x3F,0xEAA5,0xDBC9,0x3F,0x3F,0x3F,0xDBCA,0x3F,0x3F,0x3F,0xEAAE,0xDBCB,0xDBCC,0xDBCD,0xEAA8,0x3F,0xDBCE,0x3F,0xEAB0,0x3F,0xDBCF,0x3F,0x3F,0x3F,0x3F,0xCDE6,0xEAB3,0x3F,0xEAAA,0xDBD0,0xDBD1,0xEAAB,0xDBD2,0x3F,0x3F,0xEAAF,0x3F,0xEAB2,0xEAB1,0xDBD3,0xDBD4,0xDBD5,0xEAA9,0x3F,0x3F,0xDBD6,0x3F,0xEAAC,0x3F,0xEABD,0x3F,0x3F,0xDBD7,0xDBD8,0x3F,0x3F,0xDBD9,0xDBDA,0x3F,0xDBDB,0x3F,0x3F,0xDBDC,0xEAB6,0x3F,0xDBDD,0xDBDE,0xDBDF,0x3F,0x3F,0x3F,0x3F,0x3F,0xDBE0,0xDBE1,0x3F,0xDBE2,0x3F,0xEAB4,0x3F,0xDBE3,0xEAB5,0xDBE4,0x3F,0x3F,0xEABA,0xEABB,0xDBE5,0xB3AA,0xDBE6,0xB5C2,0x3F,0x3F,0xEAB9,0xDBE7},
	set87[] = {1,0xFF,1,1,3,3,1,3,1,1,1,3,0xFF,1,3,3,3,1,1,3,3,0xFF,0xFF,0xFF,1,3,1,0xFF,1,0xFF,3,3,0xFF,3,0xFF,3,0xFF,1,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,3,3,0xFF,1,0xFF,0xFF,1,0xFF,3,3,1,3,3,3,1,3,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,1,1,3,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,1,3,1,0xFF,0xFF,0xFF,3,0xFF,1,1,3,0xFF,1,3,3,1,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,1,3,0xFF,3,3,0xFF,1,0xFF,1,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,3,3,3,3,3,3,3,0xFF,3,3,1,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,3,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,3,1,3,0xFF,1,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,3,3,3,1,0xFF,3,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,1,3,3,1,3,0xFF,0xFF,1,0xFF,1,1,3,3,3,1,0xFF,0xFF,3,0xFF,1,0xFF,1,0xFF,0xFF,3,3,0xFF,0xFF,3,3,0xFF,3,0xFF,0xFF,3,1,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,3,0xFF,1,0xFF,3,1,3,0xFF,0xFF,1,1,3,1,3,1,0xFF,0xFF,1,3},
	en88[] = {0x3F,0xDBE8,0x3F,0xDBE9,0x3F,0xEAA4,0xDBEA,0x3F,0x3F,0xDBEB,0xDBEC,0xDBED,0x3F,0xEAB8,0xEABC,0xEAB7,0xDBEE,0xEABE,0xDBF0,0xDBF1,0xDBF2,0xEAC0,0xEABF,0x3F,0xDBF3,0xDBEF,0xDBF4,0xDBF5,0xDBF6,0x3F,0xDBF7,0xDBF8,0x3F,0xEAC2,0xEAC1,0xE9DA,0x3F,0x3F,0x3F,0xEAC6,0xDBF9,0x3F,0x3F,0x3F,0x3F,0xDBFA,0xDBFB,0x3F,0xDBFC,0xEAC3,0xDBFD,0x3F,0x3F,0xDBFE,0xEAC4,0x3F,0x3F,0xEAC5,0xDCA1,0xEAC7,0xDCA2,0x3F,0x3F,0x3F,0xB7EC,0xDCA3,0xEAC9,0xDCA4,0xEAC8,0xDCA5,0xBDB0,0x3F,0xDCA6,0xDCA7,0xDCA8,0xDCA9,0xB9D4,0xDEA7,0xDCAA,0x3F,0x3F,0xDCAB,0xEACA,0xBDD1,0x3F,0xDCAC,0xDCAD,0xB3B9,0xDCAE,0xEACB,0xDCAF,0xB1D2,0xDCB0,0xBED7,0xEACC,0xDCB1,0xDCB2,0xB9D5,0xEACD,0xB0E1,0xDCB3,0x3F,0x3F,0x3F,0xC9BD,0xDCB4,0x3F,0xEACE,0x3F,0x3F,0x3F,0x3F,0xBFEA,0xDCB5,0xEAD5,0x3F,0x3F,0xEAD2,0x3F,0xC3EF,0x3F,0xDCB6,0x3F,0xDCB7,0x3F,0xEAD3,0xEAD0,0xB6DE,0xDCB8,0xEACF,0xEAD6,0x3F,0x3F,0x3F,0x3F,0x3F,0xB7B6,0x3F,0x3F,0xC2DE,0x3F,0xEADC,0x3F,0x3F,0x3F,0x3F,0xEAD8,0x3F,0x3F,0x3F,0xC2B5,0xEAD7,0xDCB9,0xEADA,0xDCBA,0xDCBB,0xDCBC,0x3F,0xEAD1,0xDCBD,0xDCBE,0x3F,0xEADB,0x3F,0xEADD,0x3F,0x3F,0x3F,0xDCBF,0x3F,0xDCC0,0xC8EF,0x3F,0x3F,0xEAD9,0x3F,0xEADE,0xEAE0,0x3F,0x3F,0xB8D3,0xEAD4,0x3F,0xB0C1,0x3F,0x3F,0xDCC1,0x3F,0x3F,0xDCC2,0xDCC3,0xEADF,0xDCC4,0xBADB,0xCEF6,0xEAE1,0xEAE2,0xC1F5,0x3F,0x3F,0x3F,0x3F,0xDCC5,0xDCC6,0xDCC7,0xDCC8,0xDCC9,0xCEA2,0x3F,0xDCCA,0xDCCB,0xDCCC,0xEAE3,0xCDB5,0x3F,0x3F,0xEAE4,0xEAE5,0x3F,0xDCCD,0xCAE4,0xEAE6,0xDCCE,0xBAC0,0x3F,0xCEA3,0x3F,0x3F,0x3F,0x3F,0x3F,0xDCCF,0xEAEB,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xDCD0,0xDCD1,0xDCD2,0xEAEC,0xBED8,0xEAEA,0xDCD3,0x3F,0xDCD4,0xCDE7,0xEAE7,0x3F,0x3F,0xEAE9,0xC0BD,0xBFFE,0x3F},
	set88[] = {0xFF,3,0xFF,3,0xFF,1,3,0xFF,0xFF,3,3,3,0xFF,1,1,1,3,1,3,3,3,1,1,0xFF,3,3,3,3,3,0xFF,3,3,0xFF,1,1,1,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,3,1,3,0xFF,0xFF,3,1,0xFF,0xFF,1,3,1,3,0xFF,0xFF,0xFF,1,3,1,3,1,3,1,0xFF,3,3,3,3,1,1,3,0xFF,0xFF,3,1,1,0xFF,3,3,1,3,1,3,1,3,1,1,3,3,1,1,1,3,0xFF,0xFF,0xFF,1,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,3,1,0xFF,0xFF,1,0xFF,1,0xFF,3,0xFF,3,0xFF,1,1,1,3,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,1,3,1,3,3,3,0xFF,1,3,3,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,3,1,0xFF,0xFF,1,0xFF,1,1,0xFF,0xFF,1,1,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,3,3,1,3,1,1,1,1,1,0xFF,0xFF,0xFF,0xFF,3,3,3,3,3,1,0xFF,3,3,3,1,1,0xFF,0xFF,1,1,0xFF,3,1,1,3,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,3,1,1,1,3,0xFF,3,1,1,0xFF,0xFF,1,1,1,0xFF},
	en89[] = {0x3F,0xDCD5,0xEAE8,0x3F,0xEAED,0x3F,0xDCD6,0xCAA3,0x3F,0x3F,0xEAEF,0x3F,0xEAEE,0xDCD7,0xDCD8,0xDCD9,0xB3EC,0x3F,0xCBAB,0xEAF0,0x3F,0xDCDA,0xDCDB,0x3F,0xDCDC,0xDCDD,0xDCDE,0x3F,0xDCDF,0xEAFC,0xEAF2,0x3F,0xDCE0,0x3F,0x3F,0x3F,0x3F,0xEAF3,0xDCE1,0xDCE2,0xDCE3,0x3F,0xEAF4,0xEAF5,0x3F,0x3F,0x3F,0x3F,0xDCE4,0xDCE5,0xDCE6,0x3F,0x3F,0xDCE7,0xEAF9,0x3F,0xEAFA,0xDCE8,0xDCE9,0xEAF8,0x3F,0x3F,0xDCEA,0x3F,0xDCEB,0xEAF6,0xDCEC,0xEAF1,0xEAF7,0xDCED,0xDCEE,0x3F,0x3F,0xDCEF,0x3F,0x3F,0xEAFB,0xF0B7,0x3F,0xDCF0,0x3F,0x3F,0xDCF1,0x3F,0x3F,0x3F,0xB2A8,0xDCF2,0x3F,0x3F,0xDCF3,0xDCF4,0xDCF5,0x3F,0xEAFE,0xB6DF,0xEAFD,0xDCF6,0xDCF7,0xDCF8,0xEBA2,0x3F,0xEBA1,0x3F,0x3F,0x3F,0xEBA4,0xDCF9,0x3F,0xEBA3,0xDCFA,0xEBA5,0xDCFB,0x3F,0xBDB1,0xDCFC,0xEBA6,0xDCFD,0x3F,0xEBA7,0x3F,0x3F,0xDCFE,0xDDA1,0xDDA2,0xDDA3,0xEBA8,0xC0BE,0x3F,0xCDD7,0x3F,0xEBA9,0x3F,0x3F,0xCAA4,0xC7C6,0xEBAA,0xDDA4,0xEBAB,0xB8AB,0x3F,0xDDA5,0x3F,0xB5AC,0xDDA6,0x3F,0x3F,0xEBAC,0xDDA7,0xDDA8,0xBBEB,0xC7C1,0xEBAD,0x3F,0xB3D0,0xDDA9,0xDDAA,0x3F,0x3F,0xDDAB,0xDDAC,0xEBAE,0x3F,0x3F,0x3F,0xDDAD,0xEBB0,0xCDF7,0x3F,0xEBAF,0xBFC6,0x3F,0xEBB1,0x3F,0x3F,0xEBB2,0xDDAE,0x3F,0xEBB3,0xB4D1,0xDDAF,0xDDB0,0xDDB1,0xDDB2,0x3F,0x3F,0xEBB4,0x3F,0xDDB3,0xEBB5,0x3F,0xEBB6,0xEBB7,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB3D1,0x3F,0xDDB4,0xDDB5,0xDDB6,0xDDB7,0xDDB8,0x3F,0xEBB8,0x3F,0xEBB9,0xEBBA,0x3F,0x3F,0x3F,0x3F,0x3F,0xB2F2,0x3F,0xDDB9,0xBFA8,0xEBBB,0x3F,0xDDBA,0x3F,0xDDBB,0x3F,0xDDBC,0x3F,0x3F,0x3F,0xDDBD,0x3F,0xDDBE,0xEBBC,0x3F,0xDDBF,0x3F,0xEBBD,0xDDC0,0x3F,0x3F,0x3F,0xDDC1,0x3F,0xDDC2},
	set89[] = {0xFF,3,1,0xFF,1,0xFF,3,1,0xFF,0xFF,1,0xFF,1,3,3,3,1,0xFF,1,1,0xFF,3,3,0xFF,3,3,3,0xFF,3,1,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,3,3,3,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,3,3,3,0xFF,0xFF,3,1,0xFF,1,3,3,1,0xFF,0xFF,3,0xFF,3,1,3,1,1,3,3,0xFF,0xFF,3,0xFF,0xFF,1,1,0xFF,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,3,3,3,0xFF,1,1,1,3,3,3,1,0xFF,1,0xFF,0xFF,0xFF,1,3,0xFF,1,3,1,3,0xFF,1,3,1,3,0xFF,1,0xFF,0xFF,3,3,3,3,1,1,0xFF,1,0xFF,1,0xFF,0xFF,1,1,1,3,1,1,0xFF,3,0xFF,1,3,0xFF,0xFF,1,3,3,1,1,1,0xFF,1,3,3,0xFF,0xFF,3,3,1,0xFF,0xFF,0xFF,3,1,1,0xFF,1,1,0xFF,1,0xFF,0xFF,1,3,0xFF,1,1,3,3,3,3,0xFF,0xFF,1,0xFF,3,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,3,3,3,3,0xFF,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,1,1,0xFF,3,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,3,1,0xFF,3,0xFF,1,3,0xFF,0xFF,0xFF,3,0xFF,3},
	en8A[] = {0xB8C0,0x3F,0xC4FB,0xEBBE,0xDDC3,0xDDC4,0x3F,0xDDC5,0xB7D7,0x3F,0xBFD6,0x3F,0xEBC1,0x3F,0xC6A4,0xDDC6,0xEBC0,0xDDC7,0xDDC8,0xB7B1,0xDDC9,0xDDCA,0xEBBF,0xC2F7,0xB5AD,0x3F,0x3F,0xEBC2,0x3F,0xEBC3,0xDDCB,0xBED9,0xDDCC,0x3F,0xDDCD,0xB7ED,0xDDCE,0xEBC4,0xDDCF,0x3F,0x3F,0x3F,0xCBAC,0xDDD0,0xDDD1,0xC0DF,0x3F,0xDDD2,0x3F,0xB5F6,0x3F,0xCCF5,0xC1CA,0xDDD3,0xEBC5,0xDDD4,0x3F,0x3F,0xBFC7,0xC3F0,0xBEDA,0xDDD5,0xDDD6,0x3F,0xDDD7,0xEBC6,0x3F,0xDDD8,0x3F,0xDDD9,0xEBC9,0xDDDA,0xEBCA,0xDDDB,0x3F,0x3F,0x3F,0xDDDC,0xDDDD,0x3F,0xBABE,0xC2C2,0xEBC8,0xDDDE,0xBEDB,0xC9BE,0xDDDF,0xDDE0,0xDDE1,0x3F,0x3F,0xEBC7,0xDDE2,0xDDE3,0xBBEC,0x3F,0xB1D3,0xDDE4,0xEBCE,0xB7D8,0x3F,0xDDE5,0xBBEE,0xDDE6,0x3F,0xBBED,0x3F,0xCFCD,0xEBCD,0xEBCC,0xC1A7,0x3F,0xB5CD,0xCFC3,0xB3BA,0xBEDC,0x3F,0xDDE7,0xDDE8,0xDDE9,0x3F,0xDDEA,0xDDEB,0xDDEC,0xEBCB,0x3F,0xDDED,0xDDEE,0xDDEF,0x3F,0xEBD0,0xDDF0,0xEBD1,0xEBCF,0xDDF1,0xB8D8,0x3F,0xCDC0,0x3F,0xDDF2,0xBBEF,0xC7A7,0x3F,0xDDF3,0xDDF4,0xEBD4,0xDDF5,0xC0C0,0x3F,0xC3C2,0xDDF6,0xDDF7,0xCDB6,0xDDF8,0xEBD7,0x3F,0x3F,0x3F,0xB8EC,0xDDF9,0xC0BF,0xEBD3,0x3F,0xEBD8,0xB8ED,0xEBD5,0xEBD6,0xDDFA,0xEBD2,0xDDFB,0x3F,0x3F,0xC0E2,0xC6C9,0xDDFC,0xDDFD,0xC3AF,0x3F,0xB2DD,0xDDFE,0x3F,0x3F,0xDEA1,0xDEA2,0x3F,0xC8F0,0x3F,0xDEA3,0xB5C3,0x3F,0xDEA4,0xC4B4,0x3F,0x3F,0xEBDB,0xDEA5,0xEBD9,0x3F,0xDEA6,0xC3CC,0xDEA7,0xDEA8,0xDEA9,0xC0C1,0xB4D2,0xEBDA,0x3F,0xBFDB,0x3F,0xDEAA,0xCECA,0xDEAB,0xDEAC,0xDEAD,0xCFC0,0xDEAE,0x3F,0x3F,0xEBDC,0xEBE7,0xC4B5,0xDEAF,0xEBE6,0xDEB0,0xEBE3,0xEBEB,0xEBE4,0x3F,0xEBE0,0x3F,0xC4FC,0xEBDF,0x3F,0x3F,0x3F,0xEBDD,0xDEB1,0xCDA1,0xBBF0,0x3F,0xDEB2,0xEBE1,0x3F,0xEBDE,0xDEB3,0xDEB4,0xDEB5,0xEBE5,0xBDF4,0x3F,0xB8C1,0x3F,0xDEB6,0x3F,0xC2FA,0xDEB7},
	set8A[] = {1,0xFF,1,1,3,3,0xFF,3,1,0xFF,1,0xFF,1,0xFF,1,3,1,3,3,1,3,3,1,1,1,0xFF,0xFF,1,0xFF,1,3,1,3,0xFF,3,1,3,1,3,0xFF,0xFF,0xFF,1,3,3,1,0xFF,3,0xFF,1,0xFF,1,1,3,1,3,0xFF,0xFF,1,1,1,3,3,0xFF,3,1,0xFF,3,0xFF,3,1,3,1,3,0xFF,0xFF,0xFF,3,3,0xFF,1,1,1,3,1,1,3,3,3,0xFF,0xFF,1,3,3,1,0xFF,1,3,1,1,0xFF,3,1,3,0xFF,1,0xFF,1,1,1,1,0xFF,1,1,1,1,0xFF,3,3,3,0xFF,3,3,3,1,0xFF,3,3,3,0xFF,1,3,1,1,3,1,0xFF,1,0xFF,3,1,1,0xFF,3,3,1,3,1,0xFF,1,3,3,1,3,1,0xFF,0xFF,0xFF,1,3,1,1,0xFF,1,1,1,1,3,1,3,0xFF,0xFF,1,1,3,3,1,0xFF,1,3,0xFF,0xFF,3,3,0xFF,1,0xFF,3,1,0xFF,3,1,0xFF,0xFF,1,3,1,0xFF,3,1,3,3,3,1,1,1,0xFF,1,0xFF,3,1,3,3,3,1,3,0xFF,0xFF,1,1,1,3,1,3,1,1,1,0xFF,1,0xFF,1,1,0xFF,0xFF,0xFF,1,3,1,1,0xFF,3,1,0xFF,1,3,3,3,1,1,0xFF,1,0xFF,3,0xFF,1,3},
	en8B[] = {0xCBC5,0xB1DA,0xB0E2,0x3F,0xC6A5,0xDEB8,0xDEB9,0xEBE9,0x3F,0x3F,0xDEBF,0xDEBA,0xEBE8,0x3F,0xC6E6,0x3F,0xEBED,0xDEBB,0x3F,0x3F,0xEBE2,0x3F,0xEBEC,0xEBEE,0x3F,0xB8AC,0xEBEA,0xB9D6,0xDEBC,0xBCD5,0xDEBD,0xDEBE,0xEBEF,0xCDD8,0x3F,0x3F,0x3F,0x3F,0xEBF2,0x3F,0xEBF5,0x3F,0x3F,0xEBF3,0xC9B5,0xDEC0,0x3F,0x3F,0xDEC1,0x3F,0x3F,0xEBF0,0x3F,0x3F,0x3F,0xDEC2,0x3F,0xB6E0,0x3F,0x3F,0xDEC3,0x3F,0xEBF4,0x3F,0x3F,0xEBF6,0xDEC4,0xDEC5,0xDEC6,0xDEC7,0xDEC8,0x3F,0xDEC9,0xEBFA,0x3F,0x3F,0xEBF7,0xDECE,0xEBF9,0xEBF8,0x3F,0x3F,0xDECA,0xDECB,0xDECC,0x3F,0xEBFB,0x3F,0xBCB1,0xDECD,0xEBFD,0xEBFC,0xC9E8,0x3F,0xDECF,0xECA1,0x3F,0x3F,0x3F,0xDED0,0x3F,0x3F,0xB7D9,0x3F,0x3F,0x3F,0x3F,0xEBFE,0xECA2,0xDED1,0x3F,0xECA3,0xB5C4,0xE6C1,0xBEF9,0x3F,0xECA4,0x3F,0xDED2,0xB8EE,0xDED3,0xDED4,0x3F,0x3F,0xDED5,0xECA5,0xDED6,0x3F,0xECA6,0xDED7,0x3F,0xBBBE,0xDED8,0xDED9,0x3F,0x3F,0x3F,0x3F,0xDACE,0xDEDA,0xECA7,0xDEDB,0xECA8,0xDEDC,0xBDB2,0x3F,0xECA9,0xECAA,0xDEDD,0xDEDE,0xECAB,0x3F,0x3F,0xECAC,0xECAD,0x3F,0xDEDF,0x3F,0xDEE0,0xDEE1,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set8B[] = {1,1,1,0xFF,1,3,3,1,0xFF,0xFF,3,3,1,0xFF,1,0xFF,1,3,0xFF,0xFF,1,0xFF,1,1,0xFF,1,1,1,3,1,3,3,1,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,1,1,3,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,1,3,3,3,3,3,0xFF,3,1,0xFF,0xFF,1,3,1,1,0xFF,0xFF,3,3,3,0xFF,1,0xFF,1,3,1,1,1,0xFF,3,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,1,3,0xFF,1,1,1,1,0xFF,1,0xFF,3,1,3,3,0xFF,0xFF,3,1,3,0xFF,1,3,0xFF,1,3,3,0xFF,0xFF,0xFF,0xFF,1,3,1,3,1,3,1,0xFF,1,1,3,3,1,0xFF,0xFF,1,1,0xFF,3,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en8C[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC3AB,0xDEE2,0xDEE3,0xECAE,0x3F,0x3F,0xDEE4,0xDEE5,0xECB0,0x3F,0xECAF,0x3F,0x3F,0x3F,0xDEE6,0xC6A6,0xDEE7,0xECB1,0xDEE8,0xCBAD,0xDEE9,0xECB2,0x3F,0xECB3,0xDEEA,0xECB4,0xDEEB,0x3F,0xDEEC,0xDEED,0xECB5,0x3F,0xDEEE,0xDEEF,0xDEF2,0xC6DA,0xDEF0,0x3F,0xDEF1,0x3F,0x3F,0x3F,0xBEDD,0xECB6,0xDEF3,0xDEF4,0x3F,0xDEF5,0x3F,0xDEF6,0xDEF7,0xB9EB,0xD0AE,0xECB7,0xDEF8,0x3F,0x3F,0x3F,0x3F,0x3F,0xDEF9,0x3F,0xDEFA,0xDEFB,0x3F,0xECB8,0xC9BF,0xECB9,0xDEFC,0xECC1,0x3F,0xDEFD,0x3F,0x3F,0x3F,0xECBA,0x3F,0x3F,0xECBC,0xDEFE,0xDFA1,0x3F,0xECBB,0xECBD,0xDFA2,0xCBC6,0xECBE,0xECBF,0x3F,0xDFA3,0x3F,0xDFA4,0xDFA5,0xECC0,0x3F,0x3F,0x3F,0xECC2,0xDFA6,0x3F,0xDFA7,0xDFA8,0xB3AD,0xC4E7,0x3F,0xC9E9,0xBAE2,0xB9D7,0x3F,0xDFA9,0x3F,0x3F,0xC9CF,0xB2DF,0xC8CE,0xECC5,0xB4D3,0xC0D5,0xECC4,0xECC9,0xC3F9,0xCCE3,0x3F,0xECC7,0xECC8,0xB5AE,0x3F,0xECCA,0xC7E3,0xC2DF,0xDFAA,0xDFAB,0xC8F1,0xC5BD,0xECC6,0x3F,0xCBC7,0xB2EC,0xECCC,0xCFA8,0xC4C2,0xCFC5,0xDFAC,0xDFAD,0xBBF1,0xECCB,0xDFAE,0xC2B1,0xDFAF,0x3F,0xECDC,0xC1A8,0xDFB0,0x3F,0xC6F8,0x3F,0xC9D0,0x3F,0xDFB2,0xDFB1,0x3F,0x3F,0xDFB3,0xECCF,0xBBBF,0xBBF2,0xDFB4,0xBEDE,0x3F,0xC7E5,0xDFB5,0xB8AD,0xECCE,0xECCD,0x3F,0xC9EA,0x3F,0xDFB6,0x3F,0xBCC1,0x3F,0xDFB7,0xC5D2,0x3F,0xDFB8,0xDFB9,0x3F,0xDFBA,0x3F,0x3F,0xDFBB,0x3F,0xDFBC,0xDFBD,0x3F,0xECD1,0xECD2,0xB9D8,0xECD0,0xDFBE,0xDFBF},
	set8C[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,1,0xFF,0xFF,3,3,1,0xFF,1,0xFF,0xFF,0xFF,3,1,3,1,3,1,3,1,0xFF,1,3,1,3,0xFF,3,3,1,0xFF,3,3,3,1,3,0xFF,3,0xFF,0xFF,0xFF,1,1,3,3,0xFF,3,0xFF,3,3,1,1,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,3,0xFF,1,1,1,3,1,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,3,3,0xFF,1,1,3,1,1,1,0xFF,3,0xFF,3,3,1,0xFF,0xFF,0xFF,1,3,0xFF,3,3,1,1,0xFF,1,1,1,0xFF,3,0xFF,0xFF,1,1,1,1,1,1,1,1,1,1,0xFF,1,1,1,0xFF,1,1,1,3,3,1,1,1,0xFF,1,1,1,1,1,1,3,3,1,1,3,1,3,0xFF,1,1,3,0xFF,1,0xFF,1,0xFF,3,3,0xFF,0xFF,3,1,1,1,3,1,0xFF,1,3,1,1,1,0xFF,1,0xFF,3,0xFF,1,0xFF,3,1,0xFF,3,3,0xFF,3,0xFF,0xFF,3,0xFF,3,3,0xFF,1,1,1,1,3,3},
	en8D[] = {0x3F,0xDFC0,0x3F,0xDFC1,0xECD3,0xECD4,0x3F,0xECD6,0xC2A3,0xDFC2,0xECD5,0xB4E6,0x3F,0xECD8,0x3F,0xECD7,0xECD9,0x3F,0xDFC3,0xECDB,0xECDD,0x3F,0xECDE,0xDFC4,0x3F,0x3F,0x3F,0xDFC5,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC0D6,0xDFC6,0xBCCF,0xECDF,0x3F,0xDFC7,0x3F,0xB3D2,0xDFC8,0xECE0,0xDFC9,0x3F,0xC1F6,0xECE1,0x3F,0xECE2,0xC9EB,0x3F,0x3F,0xB5AF,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xDFCA,0x3F,0xECE3,0xDFCB,0x3F,0xDFCC,0xC4B6,0x3F,0x3F,0xDFCD,0x3F,0xB1DB,0x3F,0x3F,0xDFCE,0x3F,0x3F,0xDFCF,0xDFD0,0x3F,0x3F,0x3F,0xDFD1,0x3F,0x3F,0x3F,0xECE4,0x3F,0x3F,0x3F,0x3F,0xDFD2,0xDFD3,0xDFD4,0x3F,0x3F,0xBCF1,0x3F,0x3F,0xDFD5,0x3F,0xBFF6,0x3F,0x3F,0xDFD6,0xDFD7,0x3F,0x3F,0xDFD8,0x3F,0x3F,0xDFD9,0xC2AD,0x3F,0xDFDA,0x3F,0xDFDB,0x3F,0xDFDC,0xECE7,0xDFDD,0xDFEF,0x3F,0xECE6,0x3F,0xDFDE,0x3F,0xECE5,0x3F,0x3F,0xDFDF,0xDFE0,0xDFE1,0xDFE2,0x3F,0xDFE3,0xECED,0xECEB,0x3F,0xDFE4,0xECE8,0x3F,0xDFE5,0x3F,0x3F,0xDFE6,0xDFE7,0xECEA,0xDFE8,0x3F,0xDFE9,0xECE9,0xECEC,0x3F,0xB5F7,0x3F,0xECF0,0x3F,0xC0D7,0x3F,0xECF1,0xDFEA,0xDFEB,0x3F,0xDFEC,0xB8D9,0x3F,0xECEE,0xECEF,0xDFED,0x3F,0x3F,0xCFA9,0xDFEE,0xDFF0,0xDFF1,0xC4B7,0xDFF2,0xC1A9,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xECF2,0xDFF3,0x3F,0xECF5},
	set8D[] = {0xFF,3,0xFF,3,1,1,0xFF,1,1,3,1,1,0xFF,1,0xFF,1,1,0xFF,3,1,1,0xFF,1,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,1,1,0xFF,3,0xFF,1,3,1,3,0xFF,1,1,0xFF,1,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,3,0xFF,3,1,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,3,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,3,3,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,3,3,0xFF,0xFF,3,0xFF,0xFF,3,1,0xFF,3,0xFF,3,0xFF,3,1,3,3,0xFF,1,0xFF,3,0xFF,1,0xFF,0xFF,3,3,3,3,0xFF,3,1,1,0xFF,3,1,0xFF,3,0xFF,0xFF,3,3,1,3,0xFF,3,1,1,0xFF,1,0xFF,1,0xFF,1,0xFF,1,3,3,0xFF,3,1,0xFF,1,1,3,0xFF,0xFF,1,3,3,3,1,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,1},
	en8E[] = {0x3F,0xDFF4,0x3F,0x3F,0xDFF5,0xDFF6,0xDFF7,0x3F,0xECF3,0xECF4,0xCDD9,0xDFF8,0x3F,0x3F,0x3F,0xC6A7,0xECF8,0xDFF9,0x3F,0x3F,0xDFFA,0x3F,0xDFFB,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xECF6,0xECF7,0xECF9,0xDFFC,0xDFFD,0xDFFE,0xE0A1,0x3F,0x3F,0xE0A2,0xE0A3,0x3F,0x3F,0xEDA9,0x3F,0x3F,0x3F,0x3F,0x3F,0xECFC,0xE0A4,0x3F,0xE0A5,0xECFD,0xECFB,0xE0A6,0xE0A7,0xE0A8,0xE0A9,0x3F,0x3F,0x3F,0xE0AA,0x3F,0x3F,0xE0AB,0xE0AC,0xECFA,0x3F,0xC4FD,0x3F,0x3F,0xEDA1,0xEDA5,0xEDA2,0xECFE,0xE0AD,0xEDA3,0xE0AE,0xE0AF,0xE0B0,0xEDA4,0x3F,0x3F,0x3F,0xE0B1,0xEDAB,0x3F,0x3F,0x3F,0xEDA6,0x3F,0xE0B2,0xE0B3,0xE0B4,0xE0B5,0xC0D8,0xEDA8,0xE0B6,0xE0B7,0xEDAA,0xEDA7,0x3F,0x3F,0x3F,0x3F,0xE0B8,0x3F,0x3F,0xE0B9,0xE0BA,0x3F,0xE0BB,0xE0BC,0xE0BD,0xEDAD,0x3F,0xBDB3,0x3F,0xEDAC,0x3F,0x3F,0xE0BE,0xE0BF,0xE0C0,0xEDAE,0x3F,0x3F,0x3F,0x3F,0xEDAF,0xE0C1,0xE0C2,0xEDB2,0xEDB1,0x3F,0xEDB0,0x3F,0xE0C3,0xEDB4,0xEDB3,0x3F,0xCCF6,0x3F,0x3F,0xE0C4,0xEDB6,0xE0C5,0xEDB5,0xEDB7,0xE0C6,0x3F,0x3F,0x3F,0xEDB8,0xE0C7,0xE0C8,0x3F,0xE0C9,0xE0CA,0x3F,0x3F,0xEDBA,0xE0CB,0x3F,0x3F,0x3F,0x3F,0xE0CC,0x3F,0xE0CD,0xEDB9,0xBFC8,0xEDBB,0xE0CE,0xE0CF,0xB6ED,0xEDBC,0xEDBE,0x3F,0xE0D0,0x3F,0xE0D1,0x3F,0x3F,0x3F,0x3F,0xE0D2,0xE0D3,0x3F,0x3F,0xEDBF,0x3F,0xE0D4,0xE0D5,0x3F,0xE0D6,0xE0D7,0xEDC0,0xEDBD,0xE0D8,0xEDC1,0x3F,0xBCD6,0xEDC2,0xB5B0,0xB7B3,0x3F,0xE0D9,0x3F,0xE0DA,0xB8AE,0x3F,0xE0DB,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xEDC3,0xE0DC,0x3F,0x3F,0xC6F0,0x3F,0x3F,0xC5BE,0xEDC4,0x3F,0x3F,0x3F,0x3F,0xE0DD,0x3F,0x3F,0xEDC7,0x3F,0xE0E4,0xE0DE,0x3F,0xE0DF,0xE0E0,0x3F,0x3F,0x3F,0x3F,0x3F,0xE0E1,0xBCB4,0xE0E2,0xE0E3,0xEDC6,0xEDC5,0xB7DA,0xEDC8,0x3F},
	set8E[] = {0xFF,3,0xFF,0xFF,3,3,3,0xFF,1,1,1,3,0xFF,0xFF,0xFF,1,1,3,0xFF,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,3,3,3,3,0xFF,0xFF,3,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,3,1,1,3,3,3,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,3,1,0xFF,1,0xFF,0xFF,1,1,1,1,3,1,3,3,3,1,0xFF,0xFF,0xFF,3,1,0xFF,0xFF,0xFF,1,0xFF,3,3,3,3,1,1,3,3,1,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,3,0xFF,3,3,3,1,0xFF,1,0xFF,1,0xFF,0xFF,3,3,3,1,0xFF,0xFF,0xFF,0xFF,1,3,3,1,1,0xFF,1,0xFF,3,1,1,0xFF,1,0xFF,0xFF,3,1,3,1,1,3,0xFF,0xFF,0xFF,1,3,3,0xFF,3,3,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,1,1,1,3,3,1,1,1,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,0xFF,3,3,0xFF,3,3,1,1,3,1,0xFF,1,1,1,1,0xFF,3,0xFF,3,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,0xFF,1,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,3,3,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,3,3,1,1,1,1,0xFF},
	en8F[] = {0xE0E5,0x3F,0xE0E6,0xB3D3,0x3F,0xEDCA,0x3F,0xE0E7,0xE0E8,0xBADC,0xEDC9,0x3F,0xEDD2,0x3F,0x3F,0xE0E9,0xE0EA,0x3F,0xEDCC,0xEDCE,0xCAE5,0xEDCB,0xE0EB,0xE0EC,0xE0ED,0xEDCD,0x3F,0xEDD1,0xEDCF,0xB5B1,0xE0EE,0xEDD0,0xE0EF,0xE0F0,0x3F,0xE0F1,0x3F,0xE0F2,0xEDD3,0xE0F3,0xE0F4,0xC7DA,0xCED8,0x3F,0xE0F5,0xE0F6,0xE0F7,0xBDB4,0x3F,0x3F,0x3F,0xEDD4,0xE0F8,0xE0F9,0xE0FA,0xE0FB,0xCDA2,0xEDD6,0xE0FC,0xEDD5,0x3F,0x3F,0xEDD9,0xCDC1,0xE0FD,0xE0FE,0xEDD8,0xE1A1,0xB3ED,0xEDD7,0xEDDC,0xE1A2,0x3F,0xEDDB,0x3F,0x3F,0xEDDA,0xC5B2,0xEDDD,0xE1A3,0x3F,0xE1A4,0xE1A5,0xE1A6,0xE1A7,0xE1A8,0x3F,0xEDDE,0xE1A9,0x3F,0x3F,0x3F,0xEDDF,0xE1AA,0xE1AB,0xB9EC,0x3F,0xB7A5,0xEDE0,0xEDE1,0xEDE2,0xE1AC,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBFC9,0xEDE3,0xE1AD,0xBCAD,0xEDE4,0xE1AE,0xE1AF,0x3F,0xEDE5,0xE1B0,0xE1B1,0xE1B2,0xD2A1,0xD1FE,0x3F,0x3F,0x3F,0x3F,0xEDE6,0xE5F0,0xEDE7,0xC3A4,0xBFAB,0xC7C0,0x3F,0x3F,0xE1B3,0xE1B4,0xEDE8,0xE1B5,0x3F,0xCAD5,0xC4D4,0xB9FE,0x3F,0xE1B6,0xC3A9,0xE1B7,0xE1B8,0xB1AA,0x3F,0xCBF8,0xBFD7,0xE1B9,0x3F,0x3F,0x3F,0xE1BA,0xE1BB,0x3F,0xE1BC,0xB7DE,0x3F,0xE1BD,0xB6E1,0xE1BE,0xE1BF,0xCAD6,0xE1C0,0x3F,0x3F,0x3F,0x3F,0xEDE9,0x3F,0x3F,0x3F,0x3F,0x3F,0xE1C1,0x3F,0xEDEB,0xE1C2,0xE1C3,0xEDEA,0xB2E0,0x3F,0xE1C4,0xC6F6,0xEDEC,0xC7F7,0x3F,0xC5B3,0xE1C5,0xEDED,0xBDD2,0xE1C6,0x3F,0x3F,0xEDEF,0xE1C7,0xE1C8,0xCCC2,0xEDFE,0xEDF1,0xEDF2,0xE1C9,0x3F,0xC4C9,0xE1CA,0x3F},
	set8F[] = {3,0xFF,3,1,0xFF,1,0xFF,3,3,1,1,0xFF,1,0xFF,0xFF,3,3,0xFF,1,1,1,1,3,3,3,1,0xFF,1,1,1,3,1,3,3,0xFF,3,0xFF,3,1,3,3,1,1,0xFF,3,3,3,1,0xFF,0xFF,0xFF,1,3,3,3,3,1,1,3,1,0xFF,0xFF,1,1,3,3,1,3,1,1,1,3,0xFF,1,0xFF,0xFF,1,1,1,3,0xFF,3,3,3,3,3,0xFF,1,3,0xFF,0xFF,0xFF,1,3,3,1,0xFF,1,1,1,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,3,1,1,3,3,0xFF,1,3,3,3,1,1,0xFF,0xFF,0xFF,0xFF,1,1,1,1,1,1,0xFF,0xFF,3,3,1,3,0xFF,1,1,1,0xFF,3,1,3,3,1,0xFF,1,1,3,0xFF,0xFF,0xFF,3,3,0xFF,3,1,0xFF,3,1,3,3,1,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,3,3,1,1,0xFF,3,1,1,1,0xFF,1,3,1,1,3,0xFF,0xFF,1,3,3,1,1,1,1,3,0xFF,1,3,0xFF},
	en90[] = {0xC2E0,0xC1F7,0xE1CB,0xC6A8,0xE1CC,0xEDF0,0xB5D5,0x3F,0xE1CD,0x3F,0x3F,0xEDF9,0xE1CE,0xEDF6,0xEEA5,0xC6A9,0xC3E0,0xEDF3,0x3F,0xC4FE,0xC5D3,0xEDF4,0xEDF8,0xBFE0,0xE1CF,0xC7E7,0xC4CC,0xE1D0,0x3F,0xC0C2,0xEDF7,0xC2AE,0xC2A4,0xEDF5,0xB0A9,0xCFA2,0x3F,0x3F,0x3F,0xEDFA,0xE1D1,0xE1D2,0xE1D4,0x3F,0xE1D5,0xE1D6,0xC2E1,0xE1D3,0x3F,0xBDB5,0xBFCA,0xE1D7,0xE1D8,0xEDFC,0xEDFB,0xE1D9,0xB0EF,0xEDFD,0x3F,0x3F,0xC9AF,0x3F,0xEEA7,0xE1DA,0x3F,0xC6DB,0xBFEB,0xE1DB,0xE1DC,0xC3D9,0x3F,0xB6F8,0x3F,0xEEA6,0xCDB7,0xB1BF,0xE1DD,0xCAD7,0xB2E1,0xEEA1,0xEEA2,0xEEA3,0xEEA4,0xC6BB,0xC3A3,0xB0E3,0xEEA8,0x3F,0xEEA9,0xF4A3,0x3F,0xE1DE,0xC2BD,0xE1DF,0xEEAA,0x3F,0xB1F3,0xC1CC,0xE1E0,0xB8AF,0x3F,0xCDDA,0xE1E1,0xE1E2,0xEEAB,0xC5AC,0x3F,0x3F,0xE1E3,0xC1F8,0xBCD7,0xEEAC,0xE1E4,0x3F,0xEEAF,0x3F,0xE1E5,0xBDE5,0xEEAD,0xC1AB,0xC1AA,0xE1E6,0xB0E4,0x3F,0xCECB,0xEEB1,0x3F,0xC8F2,0xEEB3,0xEEB2,0xEEB0,0xE3E4,0xB4D4,0xE1E7,0x3F,0xEDEE,0xE1E8,0xEEB5,0xEEB4,0xE1E9,0xE1EA,0x3F,0xE1EB,0xEEB6,0xE1EC,0xCDB8,0x3F,0x3F,0x3F,0xE1ED,0x3F,0xE1EE,0xE1EF,0xE1F0,0x3F,0xE1F1,0x3F,0x3F,0x3F,0x3F,0xE1F2,0xE1F3,0xE1F4,0xC6E1,0x3F,0xE1F5,0xCBAE,0x3F,0xEEB7,0x3F,0xBCD9,0x3F,0x3F,0x3F,0x3F,0xEEB8,0xE1F6,0xEEB9,0xE1F7,0xE1F8,0xE1F9,0xEEBA,0xE1FA,0x3F,0xC5A1,0x3F,0x3F,0x3F,0x3F,0xE1FB,0xE1FD,0x3F,0x3F,0xB0EA,0x3F,0xE1FE,0xE2A1,0xE2A2,0x3F,0xE2A3,0xE2A4,0x3F,0xB9D9,0x3F,0xE1FC,0x3F,0xCFBA,0x3F,0x3F,0x3F,0xE2AD,0x3F,0x3F,0xE2A5,0x3F,0xE2A6,0xE2A7,0xE2A8,0x3F,0xEEBE,0xE2A9,0xE2AA,0x3F,0xE2AB,0x3F,0xB7B4,0xEEBB,0x3F,0xEEBC,0xE2AC,0x3F,0x3F,0xC9F4,0x3F,0x3F,0xE2AF,0x3F,0xB3D4,0x3F,0xE2B0,0xE2B1,0x3F,0x3F,0x3F,0xE2B2,0xCDB9,0xE2AE,0xB6BF,0x3F,0x3F,0x3F,0x3F,0x3F,0xC5D4,0xE2B3,0xE2B4},
	set90[] = {1,1,3,1,3,1,1,0xFF,3,0xFF,0xFF,1,3,1,1,1,1,1,0xFF,1,1,1,1,1,3,1,1,3,0xFF,1,1,1,1,1,1,1,0xFF,0xFF,0xFF,1,3,3,3,0xFF,3,3,1,3,0xFF,1,1,3,3,1,1,3,1,1,0xFF,0xFF,1,0xFF,1,3,0xFF,1,1,3,3,1,0xFF,1,0xFF,1,1,1,3,1,1,1,1,1,1,1,1,1,1,0xFF,1,1,0xFF,3,1,3,1,0xFF,1,1,3,1,0xFF,1,3,3,1,1,0xFF,0xFF,3,1,1,1,3,0xFF,1,0xFF,3,1,1,1,1,3,1,0xFF,1,1,0xFF,1,1,1,1,1,1,3,0xFF,1,3,1,1,3,3,0xFF,3,1,3,1,0xFF,0xFF,0xFF,3,0xFF,3,3,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,3,3,1,0xFF,3,1,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,3,1,3,3,3,1,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,0xFF,3,3,3,0xFF,3,3,0xFF,1,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,3,3,3,0xFF,1,3,3,0xFF,3,0xFF,1,1,0xFF,1,3,0xFF,0xFF,1,0xFF,0xFF,3,0xFF,1,0xFF,3,3,0xFF,0xFF,0xFF,3,1,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3},
	en91[] = {0xE2B5,0x3F,0xEEBF,0x3F,0xE2B6,0xE2B7,0xE2B8,0x3F,0xE2B9,0x3F,0x3F,0x3F,0x3F,0xE2BA,0x3F,0x3F,0xE2BB,0x3F,0xEEC0,0x3F,0xE2BC,0x3F,0xE2BD,0xE2BE,0xE2BF,0xEEC1,0xE2C0,0x3F,0xE2C1,0x3F,0xE2C2,0x3F,0xE2C3,0x3F,0xE2C5,0xE2C6,0x3F,0xE2C4,0x3F,0xE2C7,0x3F,0xE2C8,0x3F,0x3F,0x3F,0xC5A2,0xE2C9,0xE2CA,0xEEC3,0xE2CB,0xEEC2,0x3F,0xE2CC,0x3F,0xE2CD,0xE2CE,0x3F,0xE2CF,0xE2D0,0x3F,0xE2D1,0xE2D2,0x3F,0x3F,0x3F,0x3F,0x3F,0xE2D3,0x3F,0x3F,0x3F,0xE2D4,0xE2D5,0xC6D3,0xEEC4,0xBDB6,0xBCE0,0xC7DB,0xC3F1,0xE2D6,0x3F,0x3F,0xBCF2,0xE2D7,0xBFEC,0x3F,0xEEC5,0xE2D8,0xEEC6,0xE2D9,0xE2DA,0xE2DB,0x3F,0x3F,0x3F,0x3F,0x3F,0xE2DC,0xBFDD,0xEEC7,0xE2DD,0xEEC8,0x3F,0xE2DE,0x3F,0xEEC9,0xCDEF,0x3F,0xBDB7,0xE2DF,0x3F,0x3F,0x3F,0x3F,0xEECB,0xEECA,0xE2E0,0xB9DA,0x3F,0xB9F3,0xBBC0,0xE2E1,0xE2E2,0xE2E3,0x3F,0x3F,0x3F,0x3F,0x3F,0xE2E4,0xEECE,0xE2E5,0x3F,0xE2E6,0xE2E7,0xBDE6,0x3F,0xEECD,0xE2E8,0xEECC,0x3F,0xC2E9,0xE2E9,0x3F,0xB8EF,0xE2EA,0xC0C3,0xE2EB,0xE2EC,0xE2ED,0x3F,0xC8B0,0xE2EE,0x3F,0x3F,0x3F,0xBDB9,0x3F,0xE2EF,0x3F,0x3F,0xE2F0,0xEECF,0x3F,0xBEDF,0x3F,0xE2F1,0x3F,0xE2F2,0x3F,0xEED2,0xEED0,0xE2F3,0xE2F4,0xE2F5,0xEED1,0xE2F6,0xE2F7,0xE2F8,0xE2F9,0xEED4,0xEED3,0xE2FA,0x3F,0xBEFA,0x3F,0xEED5,0xE2FB,0xE2FC,0xE2FD,0x3F,0xE2FE,0xEED6,0xEED7,0xE3A1,0xE3A2,0x3F,0xE3A3,0xC8D0,0xBAD3,0xBCE1,0xEED8,0x3F,0xEED9,0xCEA4,0xBDC5,0xCCEE,0xCECC,0xEEDA,0xB6E2,0x3F,0xE3A4,0xE3A5,0x3F,0xEEDB,0xE3A6,0xC5A3,0xE3A7,0xE3A8,0xEEDE,0xB3F8,0xBFCB,0xE3A9,0xEEDC,0x3F,0xEEDD,0x3F,0xC4E0,0xE3AA,0xE3AB,0xCBD5,0xB6FC,0x3F,0xE3AC,0xE3AD,0x3F,0xE3AE,0xE3AF,0xE3B0,0xE3B1,0xE3B2,0xE3B3,0x3F,0x3F,0x3F,0xEEE0,0xEEE1,0xE3B4,0x3F,0xE3B5,0x3F,0xE3B6,0xEEDF,0xE3B7,0x3F,0xEEE3},
	set91[] = {3,0xFF,1,0xFF,3,3,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,1,0xFF,3,0xFF,3,3,3,1,3,0xFF,3,0xFF,3,0xFF,3,0xFF,3,3,0xFF,3,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,1,3,3,1,3,1,0xFF,3,0xFF,3,3,0xFF,3,3,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,3,1,1,1,1,1,1,3,0xFF,0xFF,1,3,1,0xFF,1,3,1,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,1,3,1,0xFF,3,0xFF,1,1,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,1,1,3,1,0xFF,1,1,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,3,0xFF,3,3,1,0xFF,1,3,1,0xFF,1,3,0xFF,1,3,1,3,3,3,0xFF,1,3,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,0xFF,3,1,0xFF,1,0xFF,3,0xFF,3,0xFF,1,1,3,3,3,1,3,3,3,3,1,1,3,0xFF,1,0xFF,1,3,3,3,0xFF,3,1,1,3,3,0xFF,3,1,1,1,1,0xFF,1,1,1,1,1,1,1,0xFF,3,3,0xFF,1,3,1,3,3,1,1,1,3,1,0xFF,1,0xFF,1,3,3,1,1,0xFF,3,3,0xFF,3,3,3,3,3,3,0xFF,0xFF,0xFF,1,1,3,0xFF,3,0xFF,3,1,3,0xFF,1},
	en92[] = {0xE3B8,0xE3B9,0x3F,0x3F,0xE3BA,0xE3BB,0xE3BC,0xE3BD,0x3F,0xE3BE,0xE3BF,0x3F,0xE3C0,0xC6DF,0xB3C3,0x3F,0xE3C1,0xEEE7,0xE3C2,0xE3C3,0xEEE4,0xEEE6,0xE3C4,0x3F,0xE3C5,0x3F,0x3F,0x3F,0xE3C6,0xE3C7,0xEEE2,0x3F,0x3F,0x3F,0x3F,0xE3C8,0xE3C9,0xE3CA,0xE3CB,0x3F,0xE3CC,0xEFCF,0x3F,0x3F,0xEEE5,0x3F,0xE3CD,0xE3CE,0xE3CF,0x3F,0x3F,0xE3D0,0xCEEB,0xE3D1,0xE3D2,0xB8DA,0xE3D3,0xE3D4,0xE3D5,0x3F,0xE3D6,0x3F,0xE3D7,0xEEEF,0xE3D8,0x3F,0xE3D9,0xE3DA,0xC5B4,0xEEEA,0xE3DB,0xE3DC,0xEEED,0xEEEB,0xE3DD,0xEEF0,0x3F,0xE3DE,0xE3DF,0xE3E0,0xEEF1,0xE3E1,0x3F,0x3F,0x3F,0x3F,0x3F,0xEEE9,0xE3E2,0xE3E3,0xEEF6,0xB1F4,0xE3E4,0xE3E5,0xEEE8,0x3F,0xE3E6,0xE3E7,0xC8AD,0x3F,0xEEEC,0xE3E8,0xBEE0,0xE3E9,0xE3EA,0xE3EB,0x3F,0x3F,0x3F,0x3F,0xE3EC,0xE3ED,0xE3EE,0xB9DB,0x3F,0x3F,0x3F,0xE3EF,0xE3F0,0xE3F1,0xE3F2,0xE3F3,0x3F,0xE3F4,0xE3F5,0xE3F6,0xCBC8,0xE3F7,0xB6E4,0x3F,0x3F,0xBDC6,0x3F,0xC6BC,0x3F,0x3F,0xE3F8,0xE3F9,0xE3FA,0x3F,0x3F,0xE3FB,0xE3FC,0x3F,0x3F,0xC1AD,0xE3FD,0xEEF4,0x3F,0xEEEE,0xEEF3,0xE3FE,0xCCC3,0xE4A1,0xC4B8,0xEEF5,0xEEF2,0x3F,0x3F,0xE4A2,0xE4A3,0x3F,0x3F,0x3F,0xE4A4,0xE4A5,0x3F,0xE4A6,0xE4A7,0x3F,0x3F,0xE4A8,0x3F,0xC1AC,0x3F,0xE4A9,0x3F,0x3F,0xE4AA,0x3F,0x3F,0x3F,0xE4AB,0xEEF9,0xE4AC,0xEEF8,0xE4AD,0xE4AE,0xE4AF,0xE4B0,0x3F,0xE4B1,0xE4B2,0xE4B3,0xE4B4,0xE4B5,0x3F,0xE4B6,0xE4B7,0xE4B8,0xE4B9,0x3F,0x3F,0xE4BA,0xE4BB,0xE4BC,0xE4BD,0xEEF7,0xE4BE,0x3F,0xCBAF,0xE4BF,0x3F,0xE4C0,0x3F,0xE4C1,0xE4C2,0xE4C3,0x3F,0x3F,0xE4C4,0xE4C5,0x3F,0xE4C6,0xE4C7,0xE4C8,0x3F,0xE4C9,0xBDFB,0xE4CA,0x3F,0xE4CB,0xE4CC,0xEEFA,0xCADF,0x3F,0xE4CD,0xB1D4,0xE4CE,0x3F,0xE4CF,0x3F,0xC9C6,0xC3F2,0x3F,0x3F,0x3F,0x3F,0xB5F8,0xE4D0,0xEEFC,0xE4D1,0xB9DD,0x3F,0x3F,0xE4D2},
	set92[] = {3,3,0xFF,0xFF,3,3,3,3,0xFF,3,3,0xFF,3,1,1,0xFF,3,1,3,3,1,1,3,0xFF,3,0xFF,0xFF,0xFF,3,3,1,0xFF,0xFF,0xFF,0xFF,3,3,3,3,0xFF,3,1,0xFF,0xFF,1,0xFF,3,3,3,0xFF,0xFF,3,1,3,3,1,3,3,3,0xFF,3,0xFF,3,1,3,0xFF,3,3,1,1,3,3,1,1,3,1,0xFF,3,3,3,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,1,1,3,3,1,0xFF,3,3,1,0xFF,1,3,1,3,3,3,0xFF,0xFF,0xFF,0xFF,3,3,3,1,0xFF,0xFF,0xFF,3,3,3,3,3,0xFF,3,3,3,1,3,1,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,3,3,3,0xFF,0xFF,3,3,0xFF,0xFF,1,3,1,0xFF,1,1,3,1,3,1,1,1,0xFF,0xFF,3,3,0xFF,0xFF,0xFF,3,3,0xFF,3,3,0xFF,0xFF,3,0xFF,1,0xFF,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,1,3,1,3,3,3,3,0xFF,3,3,3,3,3,0xFF,3,3,3,3,0xFF,0xFF,3,3,3,3,1,3,0xFF,1,3,0xFF,3,0xFF,3,3,3,0xFF,0xFF,3,3,0xFF,3,3,3,0xFF,3,1,3,0xFF,3,3,1,1,0xFF,3,1,3,0xFF,3,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,1,3,1,3,1,0xFF,0xFF,3},
	en93[] = {0xE4D3,0x3F,0xE4D4,0x3F,0x3F,0x3F,0xBBAC,0x3F,0xE4D5,0x3F,0x3F,0x3F,0x3F,0xE4D6,0x3F,0xEEFB,0xBFED,0xE4D7,0x3F,0x3F,0xE4D8,0xE4D9,0x3F,0x3F,0xBFEE,0xEFA1,0xEFA3,0x3F,0xE4DA,0xE4DB,0xE4DC,0xE4DD,0xBEFB,0xE4DE,0xEFA2,0xEFA4,0xE4DF,0xE4E0,0xB6D3,0xE4E1,0xC9C5,0xE4E2,0xE4E3,0xBCE2,0xCFA3,0x3F,0xEEFE,0xBAF8,0x3F,0x3F,0xCFBF,0xE4E4,0xE4E5,0xEFA6,0xE4E6,0xE4E7,0x3F,0x3F,0xEFA5,0xEFA7,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xEEFD,0x3F,0x3F,0xE4E8,0xE4E9,0xE4EA,0x3F,0xC6E9,0x3F,0xC5D5,0x3F,0x3F,0xE4EB,0xE4EC,0xE4ED,0x3F,0xC4D7,0xE4EE,0xEFAC,0xE4EF,0xE4F0,0x3F,0xE4F1,0xC3C3,0xEFA8,0x3F,0xE4F2,0x3F,0xEFA9,0x3F,0x3F,0x3F,0xE4F3,0xE4F4,0x3F,0xE4F5,0x3F,0xE4F6,0xE4F7,0x3F,0xB7AD,0xE4F8,0xEFAB,0xE4F9,0xE4FA,0xE4FB,0x3F,0xE4FC,0xE4FD,0xB8B0,0xE4FE,0x3F,0x3F,0x3F,0xE5A1,0x3F,0xEFAA,0xE5A2,0xBEE1,0xE5A3,0xE5A4,0xE5A5,0xE5A6,0x3F,0x3F,0x3F,0x3F,0x3F,0xE5A7,0x3F,0xE5A8,0xE5A9,0xB3F9,0xE5AA,0x3F,0xE5AB,0x3F,0x3F,0xE5AC,0x3F,0xEFB0,0xE5AD,0xBABF,0xC1F9,0xE5AE,0x3F,0xC4CA,0xE5AF,0x3F,0x3F,0xE5B0,0x3F,0x3F,0xE5B1,0x3F,0xE5B2,0xE5B3,0x3F,0xE5B4,0xB3BB,0xE5B5,0xE5BB,0x3F,0xE5B6,0xEFAE,0xEFAF,0xC4C3,0x3F,0xEFAD,0x3F,0x3F,0x3F,0xE5B7,0xE5B8,0xE5B9,0x3F,0x3F,0xEFB1,0xE5BA,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE5BC,0x3F,0xEFB7,0xE5BD,0xE5BE,0xE5BF,0xE5C0,0xEFBA,0xE5C1,0xE5C2,0xE5C3,0xE5C4,0xE5C5,0x3F,0x3F,0xEFB9,0xC5AD,0x3F,0xE5C6,0x3F,0x3F,0xEFB2,0xEFB3,0xEFB6,0xE5C7,0x3F,0x3F,0xE5C8,0xEFB8,0xE5C9,0xE5CA,0x3F,0xB6C0,0xE5CB,0x3F,0xEFBB,0xEFB5,0xE5CC,0xE5CD,0xEFB4,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xE5CF,0xE5D0,0xE5CE,0xE5D1,0xE5D2,0x3F,0xE5D3,0x3F,0x3F},
	set93[] = {3,0xFF,3,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,1,3,0xFF,0xFF,3,3,0xFF,0xFF,1,1,1,0xFF,3,3,3,3,1,3,1,1,3,3,1,3,1,3,3,1,1,0xFF,1,1,0xFF,0xFF,1,3,3,1,3,3,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,3,3,0xFF,1,0xFF,1,0xFF,0xFF,3,3,3,0xFF,1,3,1,3,3,0xFF,3,1,1,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,3,3,0xFF,3,0xFF,3,3,0xFF,1,3,1,3,3,3,0xFF,3,3,1,3,0xFF,0xFF,0xFF,3,0xFF,1,3,1,3,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,3,1,3,0xFF,3,0xFF,0xFF,3,0xFF,1,3,1,1,3,0xFF,1,3,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,3,3,0xFF,3,1,3,3,0xFF,3,1,1,1,0xFF,1,0xFF,0xFF,0xFF,3,3,3,0xFF,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,3,3,3,3,1,3,3,3,3,3,0xFF,0xFF,1,1,0xFF,3,0xFF,0xFF,1,1,1,3,0xFF,0xFF,3,1,3,3,0xFF,1,3,0xFF,1,1,3,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,3,3,3,0xFF,3,0xFF,0xFF},
	en94[] = {0x3F,0xE5D4,0xE5D5,0xEFBF,0xE5D6,0x3F,0x3F,0xEFC0,0xE5D7,0xE5D8,0x3F,0x3F,0x3F,0xE5D9,0xE5DA,0xE5DB,0xEFC1,0x3F,0x3F,0xEFBE,0xEFBD,0xE5DC,0xE5DD,0xE5DE,0xBEE2,0xC6AA,0xEFBC,0x3F,0x3F,0x3F,0x3F,0xE5DF,0x3F,0xEFC5,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xEFC3,0x3F,0x3F,0xE5E0,0xE5E1,0x3F,0xE5E2,0xE5E3,0xE5E4,0xE5E5,0xEFC4,0xEFC2,0x3F,0xC2F8,0x3F,0xEFC6,0xE5E6,0x3F,0xE5E8,0x3F,0xE5E7,0x3F,0xEFC7,0x3F,0xE5E9,0xEFC9,0xE5EA,0x3F,0x3F,0xE5EB,0x3F,0xE5EC,0x3F,0xE5ED,0x3F,0x3F,0x3F,0x3F,0xB4D5,0xEFC8,0xCCFA,0x3F,0xE5EE,0x3F,0x3F,0x3F,0xE5EF,0xEFD4,0xEFCA,0xE5F0,0x3F,0xEFCD,0xE5F1,0xEFCB,0xE5F2,0xEFCC,0xE5F3,0x3F,0x3F,0x3F,0x3F,0xE5F4,0x3F,0xEFCE,0xE5F5,0x3F,0xE5F6,0xE5F7,0xE5F8,0xEFD0,0xE5F9,0xE5FA,0x3F,0x3F,0xEFD1,0x3F,0xEFD2,0x3F,0x3F,0x3F,0x3F,0xEFD5,0xEFD3,0xEFD6,0xEFD8,0x3F,0xEFD7,0x3F,0xE5FC,0xE5FB,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set94[] = {0xFF,3,3,1,3,0xFF,0xFF,1,3,3,0xFF,0xFF,0xFF,3,3,3,1,0xFF,0xFF,1,1,3,3,3,1,1,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,3,0xFF,3,3,3,3,1,1,0xFF,1,0xFF,1,3,0xFF,3,0xFF,3,0xFF,1,0xFF,3,1,3,0xFF,0xFF,3,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF,3,0xFF,0xFF,0xFF,3,1,1,3,0xFF,1,3,1,3,1,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,3,0xFF,3,3,3,1,3,3,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,1,1,1,0xFF,1,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en95[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC4B9,0xE5FD,0xE5FE,0x3F,0x3F,0x3F,0x3F,0xE6A1,0x3F,0xCCE7,0x3F,0xEFD9,0xC1AE,0xE6A2,0x3F,0x3F,0xEFDA,0xE6A3,0xCAC4,0xEFDB,0xB3AB,0xE6A4,0xE6A5,0xE6A6,0xB1BC,0x3F,0xB4D7,0x3F,0xB4D6,0xEFDC,0x3F,0xEFDD,0x3F,0xEFDE,0xEFDF,0x3F,0x3F,0x3F,0xE6A7,0xE6A8,0xE6A9,0xEFE0,0xE6AA,0xB4D8,0xB3D5,0xB9DE,0xC8B6,0xE6AB,0xEFE2,0xEFE1,0xE6AC,0x3F,0xE6AD,0xE6AE,0xEFE3,0x3F,0x3F,0x3F,0x3F,0xB1DC,0x3F,0xE6AF,0x3F,0xE6B0,0x3F,0x3F,0xEFE6,0xE6B1,0xEFE5,0xEFE4,0xE6B2,0xEFE7,0xE6B3,0x3F,0x3F,0x3F,0xEFEA,0x3F,0x3F,0xE6B4,0xB0C7,0xE6B5,0xE6B6,0xEFE8,0xE6B7,0xEFEC,0xEFEB,0x3F,0x3F,0xE6B8,0xE6B9,0xE6BA,0xE6BB,0xEFEE,0xEFED,0xEFEF,0x3F,0xC6AE,0xE6BC,0xE6BD,0x3F,0xEFF0,0xE6BE,0xE6BF,0xE6C0,0xE6C1,0xEFF1,0xEFF3,0x3F,0xE6C2,0xEFF2,0xE6C3,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set95[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,0xFF,1,1,3,0xFF,0xFF,1,3,1,1,1,3,3,3,1,0xFF,1,0xFF,1,1,0xFF,1,0xFF,1,1,0xFF,0xFF,0xFF,3,3,3,1,3,1,1,1,1,3,1,1,3,0xFF,3,3,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,3,0xFF,0xFF,1,3,1,1,3,1,3,0xFF,0xFF,0xFF,1,0xFF,0xFF,3,1,3,3,1,3,1,1,0xFF,0xFF,3,3,3,3,1,1,1,0xFF,1,3,3,0xFF,1,3,3,3,3,1,1,0xFF,3,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en96[] = {0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC9EC,0xE6C4,0xE6C5,0x3F,0x3F,0xEFF4,0xE6C6,0x3F,0xE6C7,0xE6C8,0xE6C9,0x3F,0xEFF5,0x3F,0xBAE5,0x3F,0xE6CA,0x3F,0xEFF6,0xEFF7,0x3F,0xE6CB,0xCBC9,0xE6CC,0x3F,0x3F,0x3F,0xE6CD,0xE6CE,0xE6CF,0xE6D0,0xC1CB,0xE6D1,0xE6D2,0x3F,0xB0A4,0xC2CB,0xE6D3,0xEFF8,0x3F,0xC9ED,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xEFFB,0xEFF9,0xB9DF,0x3F,0xEFFA,0xB8C2,0x3F,0xE6D4,0x3F,0xE6D5,0x3F,0xE6D6,0xE6D7,0xE6D8,0x3F,0x3F,0xCAC5,0xEFFD,0xF0A1,0xEFFE,0xF0A2,0x3F,0xE6D9,0xB1A1,0xBFD8,0xBDFC,0xB4D9,0xF0A3,0x3F,0x3F,0x3F,0xC7E6,0x3F,0xF0A5,0x3F,0xE6DA,0x3F,0xB1A2,0x3F,0xF0A4,0xC4C4,0xE6DB,0xCECD,0xC6AB,0xEFFC,0xCEA6,0x3F,0xB8B1,0xE6DC,0xE6DD,0xCDDB,0xE6DE,0xE6DF,0x3F,0xE6E0,0xE6E1,0xE6E2,0xE6E3,0xB6F9,0xCEB4,0x3F,0xB7A8,0xE6E4,0xC2E2,0xE7A1,0x3F,0xF0A6,0xB3AC,0xBFEF,0x3F,0xE6E5,0x3F,0x3F,0xB3D6,0xF0A8,0xE6E6,0xF0A9,0xF0A7,0xB7E4,0xE6E7,0xBADD,0xBEE3,0xE6E8,0x3F,0xE6E9,0xB1A3,0x3F,0x3F,0xCED9,0xE6EA,0xE6EB,0xE6EC,0xF0AB,0xEEAE,0xE6ED,0xF0AA,0x3F,0x3F,0x3F,0xE6EE,0xE6EF,0xF0AE,0xF0AC,0xF0AD,0xE6F0,0xF0AF,0x3F,0xF0B0,0xCEEC,0xF0B1,0xF0B2,0xE6F1,0xC0C9,0xC8BB,0x3F,0x3F,0x3F,0xBFFD,0xB4E7,0x3F,0x3F,0xCDBA,0xB2ED,0xBDB8,0xB8DB,0x3F,0xF0B5,0xE6F2,0xF0B4,0xBBF3,0xF0B6,0xF0B3,0x3F,0x3F,0xBBA8,0xE6F3,0x3F,0x3F,0xF0BA,0xEAAD,0x3F,0xE6F5,0xD2D6,0xE6F6,0xBFF7,0xF0B8,0xE6F7,0xE6F8,0xE6F9,0x3F,0x3F,0xCEA5,0xC6F1,0x3F,0x3F,0x3F,0x3F,0xB1AB,0xE6FA,0xC0E3,0xBCB6,0x3F,0x3F,0x3F,0xE6FB,0xCAB7,0xE6FC,0xB1C0,0x3F,0x3F,0x3F,0xCEED,0xCDEB,0x3F,0xF0BB,0xE6FD,0xC5C5,0x3F,0x3F,0x3F,0x3F},
	set96[] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,3,0xFF,0xFF,1,3,0xFF,3,3,3,0xFF,1,0xFF,1,0xFF,3,0xFF,1,1,0xFF,3,1,3,0xFF,0xFF,0xFF,3,3,3,3,1,3,3,0xFF,1,1,3,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF,1,1,0xFF,3,0xFF,3,0xFF,3,3,3,0xFF,0xFF,1,1,1,1,1,0xFF,3,1,1,1,1,1,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,3,0xFF,1,0xFF,1,1,3,1,1,1,1,0xFF,1,3,3,1,3,3,0xFF,3,3,3,3,1,1,0xFF,1,3,1,1,0xFF,1,1,1,0xFF,3,0xFF,0xFF,1,1,3,1,1,1,3,1,1,3,0xFF,3,1,0xFF,0xFF,1,3,3,3,1,1,3,1,0xFF,0xFF,0xFF,3,3,1,1,1,3,1,0xFF,1,1,1,1,3,1,1,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,1,1,1,1,0xFF,1,3,1,1,1,1,0xFF,0xFF,1,3,0xFF,0xFF,1,1,0xFF,3,1,3,1,1,3,3,3,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,1,3,1,1,0xFF,0xFF,0xFF,3,1,3,1,0xFF,0xFF,0xFF,1,1,0xFF,1,3,1,0xFF,0xFF,0xFF,0xFF},
	en97[] = {0xBCFB,0x3F,0xE6FE,0xE7A1,0xF0BC,0xE7A2,0xF0BD,0xBFCC,0xF0BE,0xE7A3,0xCEEE,0x3F,0x3F,0xF0B9,0xF0C0,0xF0C2,0x3F,0xF0C1,0x3F,0xF0BF,0x3F,0x3F,0xF0C3,0x3F,0x3F,0xF0C4,0xE7A4,0xE7A5,0xC1FA,0xE7A6,0xB2E2,0x3F,0x3F,0xE7A7,0xE7A8,0xE7A9,0xF0C5,0x3F,0x3F,0xCCB8,0xE7AA,0x3F,0xF0C6,0x3F,0x3F,0x3F,0x3F,0x3F,0xF0C7,0xE7AB,0xCFAA,0xE7AC,0x3F,0x3F,0x3F,0x3F,0xDBB1,0xF0C8,0x3F,0x3F,0x3F,0xF0C9,0xF0CA,0x3F,0x3F,0xE7AD,0xF0CE,0xE7AE,0xF0CB,0x3F,0xF0CC,0x3F,0xF0CD,0xF0CF,0xE7AF,0x3F,0x3F,0x3F,0xE7B0,0xE7B1,0x3F,0x3F,0xC0C4,0x3F,0x3F,0xE7B2,0xCCF7,0xE7B3,0xE7B4,0xC0C5,0xE7B5,0xE7B6,0xF0D0,0x3F,0xC8F3,0x3F,0xF0D1,0xF3D3,0xCCCC,0xE7B7,0xF0D2,0x3F,0xF0D3,0xE7B8,0xF0D4,0xB3D7,0xE7B9,0xF0D6,0x3F,0xBFD9,0xE7BA,0x3F,0x3F,0xF0D7,0x3F,0xE7BB,0xB7A4,0x3F,0xE7BC,0xE7BD,0xE7BE,0xF0D8,0xF0DC,0xE7BF,0xF0DA,0xE7C0,0x3F,0xE7C1,0xE7C2,0xF0DB,0x3F,0x3F,0xB3F3,0xF0D9,0xF0DD,0x3F,0x3F,0xE7C3,0x3F,0xF0DE,0x3F,0xB0C8,0x3F,0xF0DF,0xF0E0,0x3F,0x3F,0x3F,0x3F,0xE7C4,0xE7C5,0xE7C6,0xBEE4,0xE7C7,0xE7C8,0x3F,0xF0E1,0x3F,0xE7C9,0xE7CA,0xB5C7,0x3F,0xE7CB,0xF0E4,0x3F,0x3F,0xF0E3,0x3F,0xF0E2,0x3F,0x3F,0xEBF1,0xE7CC,0xCADC,0xE7CD,0x3F,0x3F,0xE7CE,0xE7CF,0xF0E5,0xF0E6,0xE7D0,0xE7D1,0x3F,0xE7D2,0xE7D3,0xE7D4,0x3F,0xE7D5,0x3F,0xE7D6,0xE7D7,0x3F,0xE7D8,0x3F,0xF0E7,0xE7D9,0xE7DA,0xF0E8,0xE7DB,0xF0E9,0xE7DC,0xE7DD,0xF0EA,0xE7DE,0xE7DF,0xE7E0,0x3F,0xE7E1,0xE7E2,0x3F,0xB4DA,0xE7E3,0x3F,0x3F,0xE7E4,0xE7E5,0xE7E6,0x3F,0xE7EA,0xF0EB,0xE7E7,0xE7E8,0x3F,0xE7E9,0xE7EB,0x3F,0x3F,0xE7EC,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xF0EC,0xC7A3,0xE7ED,0x3F,0xE7EE,0xF0EE,0xB2BB,0xE7EF,0xF0F1,0xF0F0,0xE7F0,0xE7F1,0x3F,0xE7F2,0xB1A4,0x3F,0x3F,0x3F,0xB6C1},
	set97[] = {1,0xFF,3,3,1,3,1,1,1,3,1,0xFF,0xFF,1,1,1,0xFF,1,0xFF,1,0xFF,0xFF,1,0xFF,0xFF,1,3,3,1,3,1,0xFF,0xFF,3,3,3,1,0xFF,0xFF,1,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,1,3,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,3,1,3,1,0xFF,1,0xFF,1,1,3,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,0xFF,0xFF,3,1,3,3,1,3,3,1,0xFF,1,0xFF,1,1,1,3,1,0xFF,1,3,1,1,3,1,0xFF,1,3,0xFF,0xFF,1,0xFF,3,1,0xFF,3,3,3,1,1,3,1,3,0xFF,3,3,1,0xFF,0xFF,1,1,1,0xFF,0xFF,3,0xFF,1,0xFF,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,3,3,3,1,3,3,0xFF,1,0xFF,3,3,1,0xFF,3,1,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,1,3,1,3,0xFF,0xFF,3,3,1,1,3,3,0xFF,3,3,3,0xFF,3,0xFF,3,3,0xFF,3,0xFF,1,3,3,1,3,1,3,3,1,3,3,3,0xFF,3,3,0xFF,1,3,0xFF,0xFF,3,3,3,0xFF,3,1,3,3,0xFF,3,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,3,0xFF,3,1,1,3,1,1,3,3,0xFF,3,1,0xFF,0xFF,0xFF,1},
	en98[] = {0x3F,0xCAC7,0xC4BA,0xBAA2,0x3F,0xB9E0,0xBDE7,0xE7F3,0xBFDC,0x3F,0xE7F4,0x3F,0xF0F3,0xE7F6,0xE7F7,0xF0F2,0xCDC2,0xB4E8,0xC8D2,0xC6DC,0xE7F8,0x3F,0xE7F9,0xBFFC,0xCECE,0xE7F5,0xB7DB,0x3F,0xE7FA,0x3F,0xE7FB,0x3F,0xE7FC,0xF0F6,0x3F,0xE7FD,0xF0F5,0xE8A8,0xE7FE,0x3F,0x3F,0x3F,0x3F,0xE8A1,0xCBCB,0xC6AC,0xE8A2,0xE8A3,0xE8A4,0x3F,0xE8A5,0xE8A6,0xB1D0,0xE8A7,0x3F,0xF0F7,0xF0F4,0x3F,0x3F,0xC9D1,0xCDEA,0xF0F8,0xE8A9,0x3F,0x3F,0x3F,0x3F,0x3F,0xE8AA,0x3F,0xF0F9,0xE8AB,0x3F,0x3F,0xE8AC,0xF0FB,0xC2EA,0xB3DB,0xB3DC,0xF0FA,0x3F,0xE8AD,0xE8AE,0xE8AF,0xB4E9,0xB8B2,0xE8B0,0xE8B1,0xB4EA,0xE8B2,0xE8B3,0xC5BF,0x3F,0x3F,0xCEE0,0x3F,0x3F,0x3F,0xE8B4,0xE8B5,0x3F,0xE8B6,0xE8B7,0xB8DC,0x3F,0x3F,0xE8B8,0xF0FC,0xE8B9,0x3F,0x3F,0xF0FD,0xF0FE,0xF1A1,0x3F,0xF1A3,0xF1A2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC9F7,0x3F,0xF1A4,0xE8BA,0x3F,0xE8BB,0xE8BC,0xF1A5,0xE8BD,0xF1A6,0x3F,0x3F,0xE8BE,0x3F,0xF1A7,0xE8BF,0xE8C0,0x3F,0xE8C1,0xE8C2,0x3F,0x3F,0x3F,0xE8C3,0x3F,0x3F,0xE8C4,0xF1A9,0xF1A8,0xE8C5,0xF1AA,0x3F,0xE8C6,0x3F,0x3F,0x3F,0xE8C7,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC8F4,0xE6CC,0x3F,0x3F,0xBFA9,0x3F,0xE8C8,0xB5B2,0xE8C9,0x3F,0xE8CA,0xE8CB,0xE8CC,0x3F,0xF1AB,0xE8CD,0xF1AC,0x3F,0xD2AC,0xDDBB,0xC8D3,0x3F,0x3F,0xB0FB,0xE8CE,0xB0BB,0x3F,0xE8CF,0x3F,0x3F,0x3F,0x3F,0x3F,0xBBF4,0xCBB0,0xBEFE,0x3F},
	set98[] = {0xFF,1,1,1,0xFF,1,1,3,1,0xFF,3,0xFF,1,3,3,1,1,1,1,1,3,0xFF,3,1,1,3,1,0xFF,3,0xFF,3,0xFF,3,1,0xFF,3,1,3,3,0xFF,0xFF,0xFF,0xFF,3,1,1,3,3,3,0xFF,3,3,1,3,0xFF,1,1,0xFF,0xFF,1,1,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,1,3,0xFF,0xFF,3,1,1,1,1,1,0xFF,3,3,3,1,1,3,3,1,3,3,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,3,3,0xFF,3,3,1,0xFF,0xFF,3,1,3,0xFF,0xFF,1,1,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,3,0xFF,3,3,1,3,1,0xFF,0xFF,3,0xFF,1,3,3,0xFF,3,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,1,1,3,1,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,0xFF,1,0xFF,3,1,3,0xFF,3,3,3,0xFF,1,3,1,0xFF,1,1,1,0xFF,0xFF,1,3,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,0xFF},
	en99[] = {0x3F,0x3F,0xE8D0,0xF1AD,0x3F,0xCCDF,0x3F,0xE8D1,0xE8D2,0xF1AE,0xCDDC,0x3F,0xB1C2,0x3F,0x3F,0x3F,0xBBC1,0xE8D3,0xF1AF,0xB2EE,0xF1B0,0xE8D4,0xE8D5,0xE8D6,0xF1B1,0x3F,0xE8D7,0xE8D8,0xE8D9,0xF1B3,0xF1B4,0xE8DA,0xF1B6,0xF1B2,0xE8DB,0x3F,0xF1B5,0x3F,0xE8DC,0xE8DD,0xB4DB,0x3F,0x3F,0xE8DE,0xF1B7,0x3F,0xF1B8,0x3F,0x3F,0xE8DF,0xE8E0,0xE8E1,0xE8E2,0xE8E3,0x3F,0x3F,0x3F,0xE8E4,0xE8E5,0xE8E6,0xE8E7,0xF1B9,0xF1BA,0x3F,0xE8E8,0xE8E9,0xF1BB,0x3F,0x3F,0xF1BD,0xE8EA,0xE8EB,0xE8EC,0xF1BC,0x3F,0xF1BF,0xF1C2,0xE8ED,0xE8EE,0x3F,0xF1BE,0xF1C0,0xF1C1,0x3F,0xE8EF,0xF1C3,0x3F,0xB6C2,0xE8F0,0xE8F1,0x3F,0xE8F2,0xE8F3,0x3F,0xE8F4,0xE8F5,0xE8F6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xBCF3,0xF1C4,0xF1C5,0xB9E1,0x3F,0xE8F7,0x3F,0xE8F8,0x3F,0xE8F9,0x3F,0x3F,0x3F,0x3F,0x3F,0xF1C6,0xE8FA,0x3F,0xB3BE,0x3F,0x3F,0x3F,0xC7CF,0xF1C7,0xF1C8,0x3F,0xE8FB,0xE8FC,0xE8FD,0xC3DA,0xC6EB,0xE8FE,0x3F,0x3F,0x3F,0xE9A1,0xE9A2,0x3F,0xF1C9,0xE9A3,0x3F,0xE9A4,0x3F,0xC7FD,0x3F,0xE9A5,0xC2CC,0xB1D8,0xB6EE,0x3F,0xB6EF,0xE9A6,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC3F3,0xF1CE,0xB6F0,0xE9A7,0xE9A8,0xB2EF,0x3F,0x3F,0xF1CD,0xE9A9,0xE9AA,0xF1CB,0xE9AB,0xF1CC,0xE9AC,0xF1CA,0x3F,0x3F,0xF1D8,0x3F,0x3F,0x3F,0x3F,0xE9AD,0x3F,0x3F,0xE9AE,0xE9AF,0xE9B0,0xF1CF,0xF1D0,0x3F,0xE9B1,0xF1D1,0xF1D2,0x3F,0xE9B2,0xE9B3,0x3F,0x3F,0xF1D4,0xE9B4,0x3F,0xF1D3,0x3F,0xE9B5,0xE9B6,0xBDD9},
	set99[] = {0xFF,0xFF,3,1,0xFF,1,0xFF,3,3,1,1,0xFF,1,0xFF,0xFF,0xFF,1,3,1,1,1,3,3,3,1,0xFF,3,3,3,1,1,3,1,1,3,0xFF,1,0xFF,3,3,1,0xFF,0xFF,3,1,0xFF,1,0xFF,0xFF,3,3,3,3,3,0xFF,0xFF,0xFF,3,3,3,3,1,1,0xFF,3,3,1,0xFF,0xFF,1,3,3,3,1,0xFF,1,1,3,3,0xFF,1,1,1,0xFF,3,1,0xFF,1,3,3,0xFF,3,3,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,1,0xFF,3,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,0xFF,1,0xFF,0xFF,0xFF,1,1,1,0xFF,3,3,3,1,1,3,0xFF,0xFF,0xFF,3,3,0xFF,1,3,0xFF,3,0xFF,1,0xFF,3,1,1,1,0xFF,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,1,3,3,1,0xFF,0xFF,1,3,3,1,3,1,3,1,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,3,3,1,1,0xFF,3,1,1,0xFF,3,3,0xFF,0xFF,1,3,0xFF,1,0xFF,3,3,1},
	en9A[] = {0x3F,0xF1D5,0xE9B7,0xE9B8,0xE9B9,0xF1D7,0x3F,0x3F,0x3F,0x3F,0x3F,0xE9BA,0xE9BB,0x3F,0xB5B3,0xF1D6,0xE9BC,0xE9BD,0xC1FB,0xB8B3,0x3F,0x3F,0xE9BE,0x3F,0x3F,0xF1D9,0x3F,0x3F,0x3F,0x3F,0xE9BF,0x3F,0xE9C0,0x3F,0xE9C1,0xE9C2,0xE9C3,0x3F,0x3F,0xE9C4,0xC2CD,0x3F,0x3F,0xF1DA,0x3F,0xE9C5,0xE9C6,0x3F,0xC6AD,0x3F,0x3F,0xE9C7,0x3F,0xE9C8,0xE9C9,0xF1DB,0xE9CA,0x3F,0x3F,0x3F,0x3F,0x3F,0xF1E0,0x3F,0xF1DE,0xE9CC,0xF1DD,0xF1DF,0xE9CD,0xF1DC,0x3F,0xE9CB,0x3F,0x3F,0xE9CE,0xE9CF,0xE9D0,0xF1E2,0xE9D1,0x3F,0x3F,0xE9D2,0x3F,0x3F,0xE9D3,0xF1E1,0xE9D4,0xF1E4,0x3F,0x3F,0xB6C3,0xF1E3,0x3F,0xE9D5,0x3F,0xF1E5,0x3F,0x3F,0xF1E6,0x3F,0xF1E8,0xF1E7,0x3F,0x3F,0x3F,0xF1E9,0xF1EB,0xF1EA,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xB9FC,0x3F,0xE9D6,0x3F,0xE9D7,0xF1EC,0xE9D8,0xE9D9,0xF1ED,0x3F,0xE9DA,0x3F,0xE9DB,0xE9DC,0xE9DD,0x3F,0xB3BC,0xE9DE,0x3F,0xE9DF,0xF1EE,0x3F,0xE9E0,0xE9E1,0xF1EF,0xE9E2,0x3F,0xE9E3,0xBFF1,0x3F,0xE9E4,0x3F,0xE9E5,0x3F,0x3F,0x3F,0x3F,0x3F,0xE9E6,0xF1F0,0xE9E7,0xF1F1,0xE9E8,0xF1F2,0xF1F3,0xE9E9,0xE9EA,0xE9EB,0xB9E2,0x3F,0x3F,0xE9EC,0xE9ED,0x3F,0xF1F4,0xF1F5,0xE9EE,0x3F,0xF1F6,0xF1F7,0xE9EF,0xE9F0,0xF1F8,0xE9F1,0x3F,0xE9F2,0xC8B1,0xF1FA,0xE9F3,0xC9A6,0xF1FB,0xF1F9,0x3F,0xF1FD,0xE9F4,0xE9F5,0xF1FC,0xE9F6,0x3F,0xF1FE,0x3F,0xE9F7,0xE9F8,0xF2A1,0x3F,0xE9F9,0x3F,0xE9FA},
	set9A[] = {0xFF,1,3,3,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,1,1,3,3,1,1,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,3,0xFF,3,0xFF,3,3,3,0xFF,0xFF,3,1,0xFF,0xFF,1,0xFF,3,3,0xFF,1,0xFF,0xFF,3,0xFF,3,3,1,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,3,1,1,3,1,0xFF,3,0xFF,0xFF,3,3,3,1,3,0xFF,0xFF,3,0xFF,0xFF,3,1,3,1,0xFF,0xFF,1,1,0xFF,3,0xFF,1,0xFF,0xFF,1,0xFF,1,1,0xFF,0xFF,0xFF,1,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,3,1,3,3,1,0xFF,3,0xFF,3,3,3,0xFF,1,3,0xFF,3,1,0xFF,3,3,1,3,0xFF,3,1,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,3,1,3,1,1,3,3,3,1,0xFF,0xFF,3,3,0xFF,1,1,3,0xFF,1,1,3,3,1,3,0xFF,3,1,1,3,1,1,1,0xFF,1,3,3,1,3,0xFF,1,0xFF,3,3,1,0xFF,3,0xFF,3},
	en9B[] = {0xE9FB,0xE9FC,0xE9FD,0xE9FE,0xEAA1,0xEAA2,0xF2A2,0x3F,0xEAA3,0xEAA4,0x3F,0xEAA5,0xEAA6,0xEAA7,0xEAA8,0x3F,0xEAA9,0x3F,0xEAAA,0x3F,0x3F,0x3F,0xEAAB,0x3F,0xF2A3,0xEAAC,0xF2A4,0xEAAD,0xEAAE,0x3F,0x3F,0xF2A5,0xEAAF,0x3F,0xF2A6,0xF2A7,0x3F,0xF2A8,0xEAB0,0xF2A9,0xF2AA,0xF2AB,0xF2AC,0xEAB1,0x3F,0xEAB2,0xF2AD,0xF2AE,0x3F,0xDDB5,0xF2AF,0xEAB3,0xEAB4,0xEAB5,0x3F,0xEAB6,0x3F,0xEAB7,0xEAB8,0xE4F8,0xB5B4,0xEAB9,0x3F,0x3F,0x3F,0xB3A1,0xBAB2,0xF2B1,0xF2B0,0xCCA5,0x3F,0x3F,0xEABA,0x3F,0x3F,0xEABB,0xEABC,0xF2B3,0xF2B4,0xF2B2,0x3F,0xF2B5,0x3F,0x3F,0xCBE2,0xEABD,0xEABE,0xEABF,0xF2B6,0x3F,0xB5FB,0xEAC0,0x3F,0x3F,0xEAC1,0x3F,0x3F,0xEAC2,0x3F,0xEAC3,0x3F,0xEAC4,0xEAC5,0x3F,0xEAC6,0x3F,0xEAC7,0xEAC8,0xEAC9,0xEACA,0xEACB,0xCFA5,0x3F,0x3F,0x3F,0xEACC,0xF2B7,0xEACD,0x3F,0xEACE,0xEACF,0xEAD0,0x3F,0x3F,0x3F,0x3F,0x3F,0xEAD1,0xEAD2,0x3F,0x3F,0xF2B9,0xEAD3,0xEAD4,0xEAD5,0xEAD6,0x3F,0xEAD7,0xEAD8,0xEAD9,0x3F,0xEADA,0xB0BE,0xEADB,0xEADC,0xF2BA,0xCAAB,0xF2B8,0xEADD,0x3F,0xF2BB,0xF2BC,0x3F,0x3F,0xEADE,0x3F,0x3F,0xEADF,0xEAE0,0xF2BD,0xF2BE,0x3F,0x3F,0x3F,0x3F,0x3F,0xEAE1,0xEAE2,0xF2BF,0xEAE3,0xCBEE,0xBBAD,0xEAE4,0xBAFA,0xC1AF,0x3F,0xEAE5,0xEAE6,0xEAE7,0x3F,0xF2C0,0x3F,0x3F,0xEAE8,0xEAE9,0xF2C3,0x3F,0xEAEA,0xEAEB,0x3F,0xEAEC,0xEAED,0xF2C1,0xEAEE,0x3F,0x3F,0x3F,0x3F,0xF2C4,0xEAEF,0xEAF0,0xB8F1,0xF2C2,0x3F,0x3F,0x3F,0xEAF1,0xF2C5,0xEAF2,0xF2C6,0xF2C7,0x3F,0xF2CB,0x3F,0xBBAA,0xEAF3,0xEAF4,0x3F,0x3F,0xC2E4,0x3F,0xEAF5,0x3F,0xEAF6,0x3F,0xF2CC,0xF2C9,0xF2C8,0xF2CA,0xEAF7,0x3F,0xEAF8,0xB7DF,0x3F,0xEAF9,0xEAFA,0x3F,0x3F,0x3F,0xEAFB,0xF2D0,0xF2CF,0xF2CE,0xEAFC,0x3F,0xB0B3,0x3F,0xEAFD,0xEAFE,0xEBA1,0xEBA2,0x3F,0x3F,0xEBA3,0x3F,0xEBA4},
	set9B[] = {3,3,3,3,3,3,1,0xFF,3,3,0xFF,3,3,3,3,0xFF,3,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,1,3,1,3,3,0xFF,0xFF,1,3,0xFF,1,1,0xFF,1,3,1,1,1,1,3,0xFF,3,1,1,0xFF,1,1,3,3,3,0xFF,3,0xFF,3,3,1,1,3,0xFF,0xFF,0xFF,1,1,1,1,1,0xFF,0xFF,3,0xFF,0xFF,3,3,1,1,1,0xFF,1,0xFF,0xFF,1,3,3,3,1,0xFF,1,3,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,3,0xFF,3,3,0xFF,3,0xFF,3,3,3,3,3,1,0xFF,0xFF,0xFF,3,1,3,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,3,3,3,3,0xFF,3,3,3,0xFF,3,1,3,3,1,1,1,3,0xFF,1,1,0xFF,0xFF,3,0xFF,0xFF,3,3,1,1,0xFF,0xFF,0xFF,0xFF,0xFF,3,3,1,3,1,1,3,1,1,0xFF,3,3,3,0xFF,1,0xFF,0xFF,3,3,1,0xFF,3,3,0xFF,3,3,1,3,0xFF,0xFF,0xFF,0xFF,1,3,3,1,1,0xFF,0xFF,0xFF,3,1,3,1,1,0xFF,1,0xFF,1,3,3,0xFF,0xFF,1,0xFF,3,0xFF,3,0xFF,1,1,1,1,3,0xFF,3,1,0xFF,3,3,0xFF,0xFF,0xFF,3,1,1,1,3,0xFF,1,0xFF,3,3,3,3,0xFF,0xFF,3,0xFF,3},
	en9C[] = {0xEBA5,0x3F,0xEBA6,0x3F,0xF2DA,0x3F,0xF2D6,0x3F,0xF2D7,0xF2D3,0xF2D9,0xEBA7,0xF2D5,0xB3E2,0x3F,0xEBA8,0xCFCC,0xEBA9,0xF2D8,0xF2D4,0xF2D2,0xF2D1,0xEBAA,0x3F,0xEBAB,0xEBAC,0xEBAD,0xF2DC,0xEBAE,0x3F,0xEBAF,0x3F,0x3F,0xF2DF,0xEBB0,0xEBB1,0xF2DE,0xF2DD,0xEBB2,0xEBB3,0xEBB4,0xEBB5,0xEBB6,0x3F,0x3F,0xC9C9,0xF2DB,0xB0F3,0xF2E0,0xEBB7,0xF2E2,0x3F,0x3F,0xEBB8,0xEBB9,0xEBBA,0x3F,0xB3EF,0xF2CD,0xB1B7,0x3F,0xEBBB,0xF2E4,0x3F,0x3F,0xEBBC,0x3F,0xEBBD,0xEBBE,0xEBBF,0xF2E3,0xF2E1,0xC3AD,0xEBC0,0xEBC1,0x3F,0x3F,0x3F,0xEBC2,0xEBC3,0xEBC4,0x3F,0xCBF0,0xEBC5,0xEBC6,0x3F,0xEBC7,0xCEDA,0xEBC8,0x3F,0xF2E5,0xEBC9,0xEBD0,0xEBCA,0xEBCB,0xEBCC,0xF2E6,0x3F,0x3F,0xEBCD,0x3F,0x3F,0x3F,0xF2E7,0xEBD2,0xEBCE,0xEBCF,0xEBD1,0x3F,0x3F,0xEBD3,0x3F,0xEBD4,0x3F,0xEBD5,0x3F,0x3F,0xEBD6,0xF2E8,0xEBD7,0xF2E9,0x3F,0x3F,0xEBD8,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xC4BB,0xEBD9,0xF2EA,0x3F,0xC8B7,0x3F,0xF2EF,0xF2EB,0x3F,0x3F,0x3F,0xF2EC,0x3F,0xEBDA,0xCBB1,0xCCC4,0x3F,0xC6D0,0xEBDB,0x3F,0xEBDC,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set9C[] = {3,0xFF,3,0xFF,1,0xFF,1,0xFF,1,1,1,3,1,1,0xFF,3,1,3,1,1,1,1,3,0xFF,3,3,3,1,3,0xFF,3,0xFF,0xFF,1,3,3,1,1,3,3,3,3,3,0xFF,0xFF,1,1,1,1,3,1,0xFF,0xFF,3,3,3,0xFF,1,1,1,0xFF,3,1,0xFF,0xFF,3,0xFF,3,3,3,1,1,1,3,3,0xFF,0xFF,0xFF,3,3,3,0xFF,1,3,3,0xFF,3,1,3,0xFF,1,3,3,3,3,3,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,1,3,3,3,3,0xFF,0xFF,3,0xFF,3,0xFF,3,0xFF,0xFF,3,1,3,1,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,3,1,0xFF,1,0xFF,1,1,0xFF,0xFF,0xFF,1,0xFF,3,1,1,0xFF,1,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	en9D[] = {0x3F,0x3F,0xEBDE,0xF2F0,0x3F,0x3F,0xF2F1,0xC6BE,0xF2EE,0xF2ED,0x3F,0xEBDD,0x3F,0x3F,0xB2AA,0x3F,0x3F,0xEBDF,0xF2F9,0x3F,0x3F,0xF2F8,0x3F,0xEBE0,0xEBE1,0x3F,0x3F,0xB1F5,0xEBE2,0xEBE3,0xEBE4,0xF2F6,0x3F,0x3F,0x3F,0xF2F5,0x3F,0x3F,0xF2F3,0x3F,0xB3FB,0x3F,0xF2F2,0xBCB2,0xB2A9,0x3F,0x3F,0xEBE5,0xEBE6,0x3F,0xEBE7,0xEBE8,0xEBE9,0x3F,0x3F,0x3F,0x3F,0x3F,0xEBEA,0xB9E3,0xEBEB,0xEBED,0xF2FC,0xF2FB,0x3F,0xF2FA,0xEBEE,0xEBEF,0xF2F7,0xEBEC,0xF2FD,0xEBF0,0xF2FE,0x3F,0xEBF1,0x3F,0x3F,0x3F,0x3F,0x3F,0xF3A5,0xF3A4,0x3F,0xEBF2,0xEBF3,0x3F,0x3F,0x3F,0x3F,0xF3A6,0x3F,0x3F,0xB1AD,0xF3A1,0xF3A2,0xEBF4,0xB9F4,0xCCB9,0xEBF6,0xEBF5,0xF3A3,0xEBF7,0x3F,0x3F,0x3F,0xEBF8,0xEBF9,0xEBFA,0xCBB2,0x3F,0x3F,0xF3AB,0xEBFB,0x3F,0xF3A7,0x3F,0x3F,0x3F,0xEBFC,0xEBFD,0x3F,0x3F,0xF3AC,0xEBFE,0xECA1,0x3F,0xECA2,0x3F,0x3F,0x3F,0x3F,0xECA3,0xECA4,0x3F,0xECA5,0xF3A9,0x3F,0xF3A8,0xECA6,0x3F,0x3F,0xECA7,0xECA8,0xB7DC,0x3F,0x3F,0xECA9,0xECAA,0x3F,0xECAB,0xECAC,0xECAD,0xECAE,0x3F,0xF3AD,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xECAF,0x3F,0x3F,0xF3AE,0x3F,0x3F,0x3F,0x3F,0xF3AF,0xECB0,0xF3AA,0xECB1,0x3F,0xECB2,0xF2F4,0x3F,0xECB3,0xF3B0,0x3F,0xC4E1,0xECB4,0x3F,0x3F,0xF3B4,0xECB5,0xF3B5,0xF3B3,0xECB6,0x3F,0x3F,0xECB7,0x3F,0xF3B2,0xF3B8,0xECB8,0xF3B1,0x3F,0xF3B6,0xECB9,0x3F,0xECBA,0xECBB,0x3F,0x3F,0x3F,0x3F,0xF3B7,0x3F,0x3F,0x3F,0xF3BA,0xECBC,0xECBD,0xECBE,0xECBF,0x3F,0xF3B9,0xECC0,0x3F,0x3F,0x3F,0xECC1,0xECC2,0xECC3,0x3F,0x3F,0x3F,0x3F,0xECC4,0xF3BC,0xECC5,0x3F,0xECC6,0x3F,0xECC7,0x3F,0xF3BD,0xECC8,0xF3BE,0xECC9,0x3F,0xCFC9,0xECCA,0xECCB,0x3F,0x3F,0x3F,0xF3BB,0xC2EB,0xBAED,0x3F,0x3F,0xF3BF,0xECCC,0x3F},
	set9D[] = {0xFF,0xFF,3,1,0xFF,0xFF,1,1,1,1,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,3,1,0xFF,0xFF,1,0xFF,3,3,0xFF,0xFF,1,3,3,3,1,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,0xFF,1,0xFF,1,1,1,0xFF,0xFF,3,3,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,0xFF,3,1,3,3,1,1,0xFF,1,3,3,1,3,1,3,1,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,1,1,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,1,1,3,1,1,3,3,1,3,0xFF,0xFF,0xFF,3,3,3,1,0xFF,0xFF,1,3,0xFF,1,0xFF,0xFF,0xFF,3,3,0xFF,0xFF,1,3,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,3,0xFF,3,1,0xFF,1,3,0xFF,0xFF,3,3,1,0xFF,0xFF,3,3,0xFF,3,3,3,3,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,1,0xFF,0xFF,0xFF,0xFF,1,3,1,3,0xFF,3,1,0xFF,3,1,0xFF,1,3,0xFF,0xFF,1,3,1,1,3,0xFF,0xFF,3,0xFF,1,1,3,1,0xFF,1,3,0xFF,3,3,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,0xFF,1,3,3,3,3,0xFF,1,3,0xFF,0xFF,0xFF,3,3,3,0xFF,0xFF,0xFF,0xFF,3,1,3,0xFF,3,0xFF,3,0xFF,1,3,1,3,0xFF,1,3,3,0xFF,0xFF,0xFF,1,1,1,0xFF,0xFF,1,3,0xFF},
	en9E[] = {0x3F,0x3F,0xECCE,0x3F,0x3F,0x3F,0x3F,0xECCF,0x3F,0x3F,0xECCD,0x3F,0x3F,0x3F,0xECD0,0x3F,0xECD1,0xECD2,0xECD3,0x3F,0x3F,0xECD4,0xECD5,0x3F,0x3F,0xECD6,0xF3C0,0xF3C1,0xECD7,0xECD8,0xF3C2,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xF3C3,0x3F,0x3F,0xB8B4,0xF3C4,0xECD9,0xECDA,0xECDB,0xF3C5,0x3F,0xBCAF,0xECDC,0xF3C6,0xECDD,0xECDE,0xECDF,0xECE0,0x3F,0xECE1,0xF3C7,0x3F,0x3F,0xF3C8,0xF3C9,0x3F,0xECE2,0xECE3,0x3F,0xF3CC,0xF3CA,0xCFBC,0x3F,0xF3CB,0xECE4,0xCEEF,0xECE5,0x3F,0x3F,0xECE6,0x3F,0xF3CD,0xECE7,0xCEDB,0x3F,0x3F,0x3F,0x3F,0xECE8,0xF3CE,0xC7FE,0x3F,0xECE9,0xF3CF,0xF3D1,0x3F,0xECEA,0xF3D2,0xECEB,0xECEC,0xECED,0x3F,0x3F,0xECEE,0xECEF,0xECF0,0x3F,0x3F,0xF3D0,0xB9ED,0xCCCD,0xCBE3,0xD6F7,0x3F,0xDDE0,0xCBFB,0x3F,0x3F,0x3F,0x3F,0xB2AB,0x3F,0xECF1,0x3F,0xECF2,0x3F,0x3F,0xECF3,0xF3D4,0xB5D0,0xF3D5,0xF3D6,0xF3D7,0x3F,0xB9F5,0x3F,0xF3D8,0xECF4,0x3F,0x3F,0xE0D4,0xCCDB,0x3F,0xC2E3,0xF3D9,0xF3DB,0xF3DA,0xECF5,0xF3DC,0x3F,0x3F,0x3F,0xECF6,0xF3DD,0x3F,0xECF7,0xF3DE,0x3F,0x3F,0x3F,0xECF8,0xECF9,0xECFA,0xF3DF,0xECFB,0xECFC,0xECFD,0x3F,0xF3E0,0xECFE,0xF3E1,0xF3E2,0xEDA1,0xF3E3,0x3F,0xF3E4,0xF3E5,0xF3E6,0x3F,0xEDA2},
	set9E[] = {0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,0xFF,3,3,3,0xFF,0xFF,3,3,0xFF,0xFF,3,1,1,3,3,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,0xFF,1,1,3,3,3,1,0xFF,1,3,1,3,3,3,3,0xFF,3,1,0xFF,0xFF,1,1,0xFF,3,3,0xFF,1,1,1,0xFF,1,3,1,3,0xFF,0xFF,3,0xFF,1,3,1,0xFF,0xFF,0xFF,0xFF,3,1,1,0xFF,3,1,1,0xFF,3,1,3,3,3,0xFF,0xFF,3,3,3,0xFF,0xFF,1,1,1,1,1,0xFF,1,1,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,0xFF,3,0xFF,0xFF,3,1,1,1,1,1,0xFF,1,0xFF,1,3,0xFF,0xFF,1,1,0xFF,1,1,1,1,3,1,0xFF,0xFF,0xFF,3,1,0xFF,3,1,0xFF,0xFF,0xFF,3,3,3,1,3,3,3,0xFF,1,3,1,1,3,1,0xFF,1,1,1,0xFF,3},
	en9F[] = {0x3F,0x3F,0xEDA3,0xEDA4,0x3F,0x3F,0x3F,0xF3E7,0xF3E8,0xEDA5,0x3F,0x3F,0x3F,0x3F,0xC5A4,0xEDA6,0xEDA7,0xEDA8,0xEDA9,0xB8DD,0xEDAA,0xF3EA,0xEDAB,0xEDAC,0x3F,0xEDAD,0xEDAE,0xEDAF,0x3F,0x3F,0x3F,0xEDB0,0xC1CD,0xF3EB,0xEDB1,0x3F,0x3F,0x3F,0xEDB2,0x3F,0x3F,0x3F,0xEDB3,0xEDB4,0xF3EC,0x3F,0x3F,0xEDB5,0x3F,0xEDB6,0xEDB7,0x3F,0xEDB8,0x3F,0x3F,0xEDB9,0x3F,0xEDBA,0xEDBB,0xC9A1,0xEDBC,0xEDBD,0xF3ED,0xEDBE,0x3F,0xEDBF,0x3F,0xEDC0,0xEDC1,0xEDC2,0xEDC3,0xEDC4,0x3F,0x3F,0xF3EE,0xE3B7,0x3F,0x3F,0xECDA,0xF0ED,0x3F,0x3F,0xF3EF,0xEDC5,0xF3F0,0xEDC6,0xEDC7,0xEDC8,0xEDC9,0x3F,0xEDCA,0x3F,0x3F,0xEDCB,0xEDCC,0xF3F2,0xF3F3,0xF3F4,0xCEF0,0xF3F1,0x3F,0x3F,0xF3F5,0xF3F6,0xEDCD,0xEDCE,0xF3F8,0x3F,0xF3F7,0xEDCF,0xEDD0,0xEDD1,0xEDD2,0xEDD3,0xF3FA,0xEDD4,0x3F,0xEDD5,0xF3FB,0xF3F9,0x3F,0x3F,0xEDD6,0x3F,0x3F,0xEDD7,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xCEB6,0x3F,0xEDD8,0xEDD9,0xEDDA,0xEDDB,0x3F,0xEDDC,0xF3FC,0xEDDD,0xEDDE,0x3F,0x3F,0x3F,0x3F,0xF3FD,0xE3D4,0xEDDF,0x3F,0xF3FE,0xEDE0,0xEDE1,0xEDE2,0x3F,0xEDE3,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	set9F[] = {0xFF,0xFF,3,3,0xFF,0xFF,0xFF,1,1,3,0xFF,0xFF,0xFF,0xFF,1,3,3,3,3,1,3,1,3,3,0xFF,3,3,3,0xFF,0xFF,0xFF,3,1,1,3,0xFF,0xFF,0xFF,3,0xFF,0xFF,0xFF,3,3,1,0xFF,0xFF,3,0xFF,3,3,0xFF,3,0xFF,0xFF,3,0xFF,3,3,1,3,3,1,3,0xFF,3,0xFF,3,3,3,3,3,0xFF,0xFF,1,1,0xFF,0xFF,1,1,0xFF,0xFF,1,3,1,3,3,3,3,0xFF,3,0xFF,0xFF,3,3,1,1,1,1,1,0xFF,0xFF,1,1,3,3,1,0xFF,1,3,3,3,3,3,1,3,0xFF,3,1,1,0xFF,0xFF,3,0xFF,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,3,3,3,3,0xFF,3,1,3,3,0xFF,0xFF,0xFF,0xFF,1,1,3,0xFF,1,3,3,3,0xFF,3,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	enFF[] = {0x3F,0xA1AA,0x3F,0xA1F4,0xA1F0,0xA1F3,0xA1F5,0x3F,0xA1CA,0xA1CB,0xA1F6,0xA1DC,0xA1A4,0x3F,0xA1A5,0xA1BF,0xA3B0,0xA3B1,0xA3B2,0xA3B3,0xA3B4,0xA3B5,0xA3B6,0xA3B7,0xA3B8,0xA3B9,0xA1A7,0xA1A8,0xA1E3,0xA1E1,0xA1E4,0xA1A9,0xA1F7,0xA3C1,0xA3C2,0xA3C3,0xA3C4,0xA3C5,0xA3C6,0xA3C7,0xA3C8,0xA3C9,0xA3CA,0xA3CB,0xA3CC,0xA3CD,0xA3CE,0xA3CF,0xA3D0,0xA3D1,0xA3D2,0xA3D3,0xA3D4,0xA3D5,0xA3D6,0xA3D7,0xA3D8,0xA3D9,0xA3DA,0xA1CE,0x3F,0xA1CF,0xA1B0,0xA1B2,0xA1AE,0xA3E1,0xA3E2,0xA3E3,0xA3E4,0xA3E5,0xA3E6,0xA3E7,0xA3E8,0xA3E9,0xA3EA,0xA3EB,0xA3EC,0xA3ED,0xA3EE,0xA3EF,0xA3F0,0xA3F1,0xA3F2,0xA3F3,0xA3F4,0xA3F5,0xA3F6,0xA3F7,0xA3F8,0xA3F9,0xA3FA,0xA1D0,0xA1C3,0xA1D1,0x3F,0x3F,0x3F,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0xA1B1,0x3F,0xA1EF,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F},
	setFF[] = {0xFF,1,0xFF,1,1,1,1,0xFF,1,1,1,1,1,0xFF,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xFF,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0xFF,0xFF,0xFF,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,1,0xFF,1,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
	*encode[] = {en00,en01,en02,en03,en04,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,en20,en21,en22,en23,enXX,en25,en26,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,en30,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,en4E,en4F,en50,en51,en52,en53,en54,en55,en56,en57,en58,en59,en5A,en5B,en5C,en5D,en5E,en5F,en60,en61,en62,en63,en64,en65,en66,en67,en68,en69,en6A,en6B,en6C,en6D,en6E,en6F,en70,en71,en72,en73,en74,en75,en76,en77,en78,en79,en7A,en7B,en7C,en7D,en7E,en7F,en80,en81,en82,en83,en84,en85,en86,en87,en88,en89,en8A,en8B,en8C,en8D,en8E,en8F,en90,en91,en92,en93,en94,en95,en96,en97,en98,en99,en9A,en9B,en9C,en9D,en9E,en9F,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enXX,enFF,},
	*code_set[] = {set00,set01,set02,set03,set04,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,set20,set21,set22,set23,setXX,set25,set26,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,set30,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,set4E,set4F,set50,set51,set52,set53,set54,set55,set56,set57,set58,set59,set5A,set5B,set5C,set5D,set5E,set5F,set60,set61,set62,set63,set64,set65,set66,set67,set68,set69,set6A,set6B,set6C,set6D,set6E,set6F,set70,set71,set72,set73,set74,set75,set76,set77,set78,set79,set7A,set7B,set7C,set7D,set7E,set7F,set80,set81,set82,set83,set84,set85,set86,set87,set88,set89,set8A,set8B,set8C,set8D,set8E,set8F,set90,set91,set92,set93,set94,set95,set96,set97,set98,set99,set9A,set9B,set9C,set9D,set9E,set9F,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setXX,setFF,};
static const unsigned short
	which_code_set[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,},
	decode_set1_A1[] = {0x3000,0x3001,0x3002,0xFF0C,0xFF0E,0x30FB,0xFF1A,0xFF1B,0xFF1F,0xFF01,0x309B,0x309C,0xB4,0xFF40,0xA8,0xFF3E,0xFFE3,0xFF3F,0x30FD,0x30FE,0x309D,0x309E,0x3003,0x4EDD,0x3005,0x3006,0x3007,0x30FC,0x2015,0x2010,0xFF0F,0x5C,0x301C,0x2016,0xFF5C,0x2026,0x2025,0x2018,0x2019,0x201C,0x201D,0xFF08,0xFF09,0x3014,0x3015,0xFF3B,0xFF3D,0xFF5B,0xFF5D,0x3008,0x3009,0x300A,0x300B,0x300C,0x300D,0x300E,0x300F,0x3010,0x3011,0xFF0B,0x2212,0xB1,0xD7,0xF7,0xFF1D,0x2260,0xFF1C,0xFF1E,0x2266,0x2267,0x221E,0x2234,0x2642,0x2640,0xB0,0x2032,0x2033,0x2103,0xFFE5,0xFF04,0xA2,0xA3,0xFF05,0xFF03,0xFF06,0xFF0A,0xFF20,0xA7,0x2606,0x2605,0x25CB,0x25CF,0x25CE,0x25C7},
	decode_set1_A2[] = {0x25C6,0x25A1,0x25A0,0x25B3,0x25B2,0x25BD,0x25BC,0x203B,0x3012,0x2192,0x2190,0x2191,0x2193,0x3013,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2208,0x220B,0x2286,0x2287,0x2282,0x2283,0x222A,0x2229,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2227,0x2228,0xAC,0x21D2,0x21D4,0x2200,0x2203,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2220,0x22A5,0x2312,0x2202,0x2207,0x2261,0x2252,0x226A,0x226B,0x221A,0x223D,0x221D,0x2235,0x222B,0x222C,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x212B,0x2030,0x266F,0x266D,0x266A,0x2020,0x2021,0xB6,0x0,0x0,0x0,0x0,0x25EF},
	decode_set1_A3[] = {0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF10,0xFF11,0xFF12,0xFF13,0xFF14,0xFF15,0xFF16,0xFF17,0xFF18,0xFF19,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF21,0xFF22,0xFF23,0xFF24,0xFF25,0xFF26,0xFF27,0xFF28,0xFF29,0xFF2A,0xFF2B,0xFF2C,0xFF2D,0xFF2E,0xFF2F,0xFF30,0xFF31,0xFF32,0xFF33,0xFF34,0xFF35,0xFF36,0xFF37,0xFF38,0xFF39,0xFF3A,0x0,0x0,0x0,0x0,0x0,0x0,0xFF41,0xFF42,0xFF43,0xFF44,0xFF45,0xFF46,0xFF47,0xFF48,0xFF49,0xFF4A,0xFF4B,0xFF4C,0xFF4D,0xFF4E,0xFF4F,0xFF50,0xFF51,0xFF52,0xFF53,0xFF54,0xFF55,0xFF56,0xFF57,0xFF58,0xFF59,0xFF5A,0x0,0x0,0x0,0x0},
	decode_set1_A4[] = {0x3041,0x3042,0x3043,0x3044,0x3045,0x3046,0x3047,0x3048,0x3049,0x304A,0x304B,0x304C,0x304D,0x304E,0x304F,0x3050,0x3051,0x3052,0x3053,0x3054,0x3055,0x3056,0x3057,0x3058,0x3059,0x305A,0x305B,0x305C,0x305D,0x305E,0x305F,0x3060,0x3061,0x3062,0x3063,0x3064,0x3065,0x3066,0x3067,0x3068,0x3069,0x306A,0x306B,0x306C,0x306D,0x306E,0x306F,0x3070,0x3071,0x3072,0x3073,0x3074,0x3075,0x3076,0x3077,0x3078,0x3079,0x307A,0x307B,0x307C,0x307D,0x307E,0x307F,0x3080,0x3081,0x3082,0x3083,0x3084,0x3085,0x3086,0x3087,0x3088,0x3089,0x308A,0x308B,0x308C,0x308D,0x308E,0x308F,0x3090,0x3091,0x3092,0x3093,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_A5[] = {0x30A1,0x30A2,0x30A3,0x30A4,0x30A5,0x30A6,0x30A7,0x30A8,0x30A9,0x30AA,0x30AB,0x30AC,0x30AD,0x30AE,0x30AF,0x30B0,0x30B1,0x30B2,0x30B3,0x30B4,0x30B5,0x30B6,0x30B7,0x30B8,0x30B9,0x30BA,0x30BB,0x30BC,0x30BD,0x30BE,0x30BF,0x30C0,0x30C1,0x30C2,0x30C3,0x30C4,0x30C5,0x30C6,0x30C7,0x30C8,0x30C9,0x30CA,0x30CB,0x30CC,0x30CD,0x30CE,0x30CF,0x30D0,0x30D1,0x30D2,0x30D3,0x30D4,0x30D5,0x30D6,0x30D7,0x30D8,0x30D9,0x30DA,0x30DB,0x30DC,0x30DD,0x30DE,0x30DF,0x30E0,0x30E1,0x30E2,0x30E3,0x30E4,0x30E5,0x30E6,0x30E7,0x30E8,0x30E9,0x30EA,0x30EB,0x30EC,0x30ED,0x30EE,0x30EF,0x30F0,0x30F1,0x30F2,0x30F3,0x30F4,0x30F5,0x30F6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_A6[] = {0x391,0x392,0x393,0x394,0x395,0x396,0x397,0x398,0x399,0x39A,0x39B,0x39C,0x39D,0x39E,0x39F,0x3A0,0x3A1,0x3A3,0x3A4,0x3A5,0x3A6,0x3A7,0x3A8,0x3A9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3B1,0x3B2,0x3B3,0x3B4,0x3B5,0x3B6,0x3B7,0x3B8,0x3B9,0x3BA,0x3BB,0x3BC,0x3BD,0x3BE,0x3BF,0x3C0,0x3C1,0x3C3,0x3C4,0x3C5,0x3C6,0x3C7,0x3C8,0x3C9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_A7[] = {0x410,0x411,0x412,0x413,0x414,0x415,0x401,0x416,0x417,0x418,0x419,0x41A,0x41B,0x41C,0x41D,0x41E,0x41F,0x420,0x421,0x422,0x423,0x424,0x425,0x426,0x427,0x428,0x429,0x42A,0x42B,0x42C,0x42D,0x42E,0x42F,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x430,0x431,0x432,0x433,0x434,0x435,0x451,0x436,0x437,0x438,0x439,0x43A,0x43B,0x43C,0x43D,0x43E,0x43F,0x440,0x441,0x442,0x443,0x444,0x445,0x446,0x447,0x448,0x449,0x44A,0x44B,0x44C,0x44D,0x44E,0x44F,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_A8[] = {0x2500,0x2502,0x250C,0x2510,0x2518,0x2514,0x251C,0x252C,0x2524,0x2534,0x253C,0x2501,0x2503,0x250F,0x2513,0x251B,0x2517,0x2523,0x2533,0x252B,0x253B,0x254B,0x2520,0x252F,0x2528,0x2537,0x253F,0x251D,0x2530,0x2525,0x2538,0x2542,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_A9[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_AA[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_AB[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_AC[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_AD[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_AE[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_AF[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_B0[] = {0x4E9C,0x5516,0x5A03,0x963F,0x54C0,0x611B,0x6328,0x59F6,0x9022,0x8475,0x831C,0x7A50,0x60AA,0x63E1,0x6E25,0x65ED,0x8466,0x82A6,0x9BF5,0x6893,0x5727,0x65A1,0x6271,0x5B9B,0x59D0,0x867B,0x98F4,0x7D62,0x7DBE,0x9B8E,0x6216,0x7C9F,0x88B7,0x5B89,0x5EB5,0x6309,0x6697,0x6848,0x95C7,0x978D,0x674F,0x4EE5,0x4F0A,0x4F4D,0x4F9D,0x5049,0x56F2,0x5937,0x59D4,0x5A01,0x5C09,0x60DF,0x610F,0x6170,0x6613,0x6905,0x70BA,0x754F,0x7570,0x79FB,0x7DAD,0x7DEF,0x80C3,0x840E,0x8863,0x8B02,0x9055,0x907A,0x533B,0x4E95,0x4EA5,0x57DF,0x80B2,0x90C1,0x78EF,0x4E00,0x58F1,0x6EA2,0x9038,0x7A32,0x8328,0x828B,0x9C2F,0x5141,0x5370,0x54BD,0x54E1,0x56E0,0x59FB,0x5F15,0x98F2,0x6DEB,0x80E4,0x852D},
	decode_set1_B1[] = {0x9662,0x9670,0x96A0,0x97FB,0x540B,0x53F3,0x5B87,0x70CF,0x7FBD,0x8FC2,0x96E8,0x536F,0x9D5C,0x7ABA,0x4E11,0x7893,0x81FC,0x6E26,0x5618,0x5504,0x6B1D,0x851A,0x9C3B,0x59E5,0x53A9,0x6D66,0x74DC,0x958F,0x5642,0x4E91,0x904B,0x96F2,0x834F,0x990C,0x53E1,0x55B6,0x5B30,0x5F71,0x6620,0x66F3,0x6804,0x6C38,0x6CF3,0x6D29,0x745B,0x76C8,0x7A4E,0x9834,0x82F1,0x885B,0x8A60,0x92ED,0x6DB2,0x75AB,0x76CA,0x99C5,0x60A6,0x8B01,0x8D8A,0x95B2,0x698E,0x53AD,0x5186,0x5712,0x5830,0x5944,0x5BB4,0x5EF6,0x6028,0x63A9,0x63F4,0x6CBF,0x6F14,0x708E,0x7114,0x7159,0x71D5,0x733F,0x7E01,0x8276,0x82D1,0x8597,0x9060,0x925B,0x9D1B,0x5869,0x65BC,0x6C5A,0x7525,0x51F9,0x592E,0x5965,0x5F80,0x5FDC},
	decode_set1_B2[] = {0x62BC,0x65FA,0x6A2A,0x6B27,0x6BB4,0x738B,0x7FC1,0x8956,0x9D2C,0x9D0E,0x9EC4,0x5CA1,0x6C96,0x837B,0x5104,0x5C4B,0x61B6,0x81C6,0x6876,0x7261,0x4E59,0x4FFA,0x5378,0x6069,0x6E29,0x7A4F,0x97F3,0x4E0B,0x5316,0x4EEE,0x4F55,0x4F3D,0x4FA1,0x4F73,0x52A0,0x53EF,0x5609,0x590F,0x5AC1,0x5BB6,0x5BE1,0x79D1,0x6687,0x679C,0x67B6,0x6B4C,0x6CB3,0x706B,0x73C2,0x798D,0x79BE,0x7A3C,0x7B87,0x82B1,0x82DB,0x8304,0x8377,0x83EF,0x83D3,0x8766,0x8AB2,0x5629,0x8CA8,0x8FE6,0x904E,0x971E,0x868A,0x4FC4,0x5CE8,0x6211,0x7259,0x753B,0x81E5,0x82BD,0x86FE,0x8CC0,0x96C5,0x9913,0x99D5,0x4ECB,0x4F1A,0x89E3,0x56DE,0x584A,0x58CA,0x5EFB,0x5FEB,0x602A,0x6094,0x6062,0x61D0,0x6212,0x62D0,0x6539},
	decode_set1_B3[] = {0x9B41,0x6666,0x68B0,0x6D77,0x7070,0x754C,0x7686,0x7D75,0x82A5,0x87F9,0x958B,0x968E,0x8C9D,0x51F1,0x52BE,0x5916,0x54B3,0x5BB3,0x5D16,0x6168,0x6982,0x6DAF,0x788D,0x84CB,0x8857,0x8A72,0x93A7,0x9AB8,0x6D6C,0x99A8,0x86D9,0x57A3,0x67FF,0x86CE,0x920E,0x5283,0x5687,0x5404,0x5ED3,0x62E1,0x64B9,0x683C,0x6838,0x6BBB,0x7372,0x78BA,0x7A6B,0x899A,0x89D2,0x8D6B,0x8F03,0x90ED,0x95A3,0x9694,0x9769,0x5B66,0x5CB3,0x697D,0x984D,0x984E,0x639B,0x7B20,0x6A2B,0x6A7F,0x68B6,0x9C0D,0x6F5F,0x5272,0x559D,0x6070,0x62EC,0x6D3B,0x6E07,0x6ED1,0x845B,0x8910,0x8F44,0x4E14,0x9C39,0x53F6,0x691B,0x6A3A,0x9784,0x682A,0x515C,0x7AC3,0x84B2,0x91DC,0x938C,0x565B,0x9D28,0x6822,0x8305,0x8431},
	decode_set1_B4[] = {0x7CA5,0x5208,0x82C5,0x74E6,0x4E7E,0x4F83,0x51A0,0x5BD2,0x520A,0x52D8,0x52E7,0x5DFB,0x559A,0x582A,0x59E6,0x5B8C,0x5B98,0x5BDB,0x5E72,0x5E79,0x60A3,0x611F,0x6163,0x61BE,0x63DB,0x6562,0x67D1,0x6853,0x68FA,0x6B3E,0x6B53,0x6C57,0x6F22,0x6F97,0x6F45,0x74B0,0x7518,0x76E3,0x770B,0x7AFF,0x7BA1,0x7C21,0x7DE9,0x7F36,0x7FF0,0x809D,0x8266,0x839E,0x89B3,0x8ACC,0x8CAB,0x9084,0x9451,0x9593,0x9591,0x95A2,0x9665,0x97D3,0x9928,0x8218,0x4E38,0x542B,0x5CB8,0x5DCC,0x73A9,0x764C,0x773C,0x5CA9,0x7FEB,0x8D0B,0x96C1,0x9811,0x9854,0x9858,0x4F01,0x4F0E,0x5371,0x559C,0x5668,0x57FA,0x5947,0x5B09,0x5BC4,0x5C90,0x5E0C,0x5E7E,0x5FCC,0x63EE,0x673A,0x65D7,0x65E2,0x671F,0x68CB,0x68C4},
	decode_set1_B5[] = {0x6A5F,0x5E30,0x6BC5,0x6C17,0x6C7D,0x757F,0x7948,0x5B63,0x7A00,0x7D00,0x5FBD,0x898F,0x8A18,0x8CB4,0x8D77,0x8ECC,0x8F1D,0x98E2,0x9A0E,0x9B3C,0x4E80,0x507D,0x5100,0x5993,0x5B9C,0x622F,0x6280,0x64EC,0x6B3A,0x72A0,0x7591,0x7947,0x7FA9,0x87FB,0x8ABC,0x8B70,0x63AC,0x83CA,0x97A0,0x5409,0x5403,0x55AB,0x6854,0x6A58,0x8A70,0x7827,0x6775,0x9ECD,0x5374,0x5BA2,0x811A,0x8650,0x9006,0x4E18,0x4E45,0x4EC7,0x4F11,0x53CA,0x5438,0x5BAE,0x5F13,0x6025,0x6551,0x673D,0x6C42,0x6C72,0x6CE3,0x7078,0x7403,0x7A76,0x7AAE,0x7B08,0x7D1A,0x7CFE,0x7D66,0x65E7,0x725B,0x53BB,0x5C45,0x5DE8,0x62D2,0x62E0,0x6319,0x6E20,0x865A,0x8A31,0x8DDD,0x92F8,0x6F01,0x79A6,0x9B5A,0x4EA8,0x4EAB,0x4EAC},
	decode_set1_B6[] = {0x4F9B,0x4FA0,0x50D1,0x5147,0x7AF6,0x5171,0x51F6,0x5354,0x5321,0x537F,0x53EB,0x55AC,0x5883,0x5CE1,0x5F37,0x5F4A,0x602F,0x6050,0x606D,0x631F,0x6559,0x6A4B,0x6CC1,0x72C2,0x72ED,0x77EF,0x80F8,0x8105,0x8208,0x854E,0x90F7,0x93E1,0x97FF,0x9957,0x9A5A,0x4EF0,0x51DD,0x5C2D,0x6681,0x696D,0x5C40,0x66F2,0x6975,0x7389,0x6850,0x7C81,0x50C5,0x52E4,0x5747,0x5DFE,0x9326,0x65A4,0x6B23,0x6B3D,0x7434,0x7981,0x79BD,0x7B4B,0x7DCA,0x82B9,0x83CC,0x887F,0x895F,0x8B39,0x8FD1,0x91D1,0x541F,0x9280,0x4E5D,0x5036,0x53E5,0x533A,0x72D7,0x7396,0x77E9,0x82E6,0x8EAF,0x99C6,0x99C8,0x99D2,0x5177,0x611A,0x865E,0x55B0,0x7A7A,0x5076,0x5BD3,0x9047,0x9685,0x4E32,0x6ADB,0x91E7,0x5C51,0x5C48},
	decode_set1_B7[] = {0x6398,0x7A9F,0x6C93,0x9774,0x8F61,0x7AAA,0x718A,0x9688,0x7C82,0x6817,0x7E70,0x6851,0x936C,0x52F2,0x541B,0x85AB,0x8A13,0x7FA4,0x8ECD,0x90E1,0x5366,0x8888,0x7941,0x4FC2,0x50BE,0x5211,0x5144,0x5553,0x572D,0x73EA,0x578B,0x5951,0x5F62,0x5F84,0x6075,0x6176,0x6167,0x61A9,0x63B2,0x643A,0x656C,0x666F,0x6842,0x6E13,0x7566,0x7A3D,0x7CFB,0x7D4C,0x7D99,0x7E4B,0x7F6B,0x830E,0x834A,0x86CD,0x8A08,0x8A63,0x8B66,0x8EFD,0x981A,0x9D8F,0x82B8,0x8FCE,0x9BE8,0x5287,0x621F,0x6483,0x6FC0,0x9699,0x6841,0x5091,0x6B20,0x6C7A,0x6F54,0x7A74,0x7D50,0x8840,0x8A23,0x6708,0x4EF6,0x5039,0x5026,0x5065,0x517C,0x5238,0x5263,0x55A7,0x570F,0x5805,0x5ACC,0x5EFA,0x61B2,0x61F8,0x62F3,0x6372},
	decode_set1_B8[] = {0x691C,0x6A29,0x727D,0x72AC,0x732E,0x7814,0x786F,0x7D79,0x770C,0x80A9,0x898B,0x8B19,0x8CE2,0x8ED2,0x9063,0x9375,0x967A,0x9855,0x9A13,0x9E78,0x5143,0x539F,0x53B3,0x5E7B,0x5F26,0x6E1B,0x6E90,0x7384,0x73FE,0x7D43,0x8237,0x8A00,0x8AFA,0x9650,0x4E4E,0x500B,0x53E4,0x547C,0x56FA,0x59D1,0x5B64,0x5DF1,0x5EAB,0x5F27,0x6238,0x6545,0x67AF,0x6E56,0x72D0,0x7CCA,0x88B4,0x80A1,0x80E1,0x83F0,0x864E,0x8A87,0x8DE8,0x9237,0x96C7,0x9867,0x9F13,0x4E94,0x4E92,0x4F0D,0x5348,0x5449,0x543E,0x5A2F,0x5F8C,0x5FA1,0x609F,0x68A7,0x6A8E,0x745A,0x7881,0x8A9E,0x8AA4,0x8B77,0x9190,0x4E5E,0x9BC9,0x4EA4,0x4F7C,0x4FAF,0x5019,0x5016,0x5149,0x516C,0x529F,0x52B9,0x52FE,0x539A,0x53E3,0x5411},
	decode_set1_B9[] = {0x540E,0x5589,0x5751,0x57A2,0x597D,0x5B54,0x5B5D,0x5B8F,0x5DE5,0x5DE7,0x5DF7,0x5E78,0x5E83,0x5E9A,0x5EB7,0x5F18,0x6052,0x614C,0x6297,0x62D8,0x63A7,0x653B,0x6602,0x6643,0x66F4,0x676D,0x6821,0x6897,0x69CB,0x6C5F,0x6D2A,0x6D69,0x6E2F,0x6E9D,0x7532,0x7687,0x786C,0x7A3F,0x7CE0,0x7D05,0x7D18,0x7D5E,0x7DB1,0x8015,0x8003,0x80AF,0x80B1,0x8154,0x818F,0x822A,0x8352,0x884C,0x8861,0x8B1B,0x8CA2,0x8CFC,0x90CA,0x9175,0x9271,0x783F,0x92FC,0x95A4,0x964D,0x9805,0x9999,0x9AD8,0x9D3B,0x525B,0x52AB,0x53F7,0x5408,0x58D5,0x62F7,0x6FE0,0x8C6A,0x8F5F,0x9EB9,0x514B,0x523B,0x544A,0x56FD,0x7A40,0x9177,0x9D60,0x9ED2,0x7344,0x6F09,0x8170,0x7511,0x5FFD,0x60DA,0x9AA8,0x72DB,0x8FBC},
	decode_set1_BA[] = {0x6B64,0x9803,0x4ECA,0x56F0,0x5764,0x58BE,0x5A5A,0x6068,0x61C7,0x660F,0x6606,0x6839,0x68B1,0x6DF7,0x75D5,0x7D3A,0x826E,0x9B42,0x4E9B,0x4F50,0x53C9,0x5506,0x5D6F,0x5DE6,0x5DEE,0x67FB,0x6C99,0x7473,0x7802,0x8A50,0x9396,0x88DF,0x5750,0x5EA7,0x632B,0x50B5,0x50AC,0x518D,0x6700,0x54C9,0x585E,0x59BB,0x5BB0,0x5F69,0x624D,0x63A1,0x683D,0x6B73,0x6E08,0x707D,0x91C7,0x7280,0x7815,0x7826,0x796D,0x658E,0x7D30,0x83DC,0x88C1,0x8F09,0x969B,0x5264,0x5728,0x6750,0x7F6A,0x8CA1,0x51B4,0x5742,0x962A,0x583A,0x698A,0x80B4,0x54B2,0x5D0E,0x57FC,0x7895,0x9DFA,0x4F5C,0x524A,0x548B,0x643E,0x6628,0x6714,0x67F5,0x7A84,0x7B56,0x7D22,0x932F,0x685C,0x9BAD,0x7B39,0x5319,0x518A,0x5237},
	decode_set1_BB[] = {0x5BDF,0x62F6,0x64AE,0x64E6,0x672D,0x6BBA,0x85A9,0x96D1,0x7690,0x9BD6,0x634C,0x9306,0x9BAB,0x76BF,0x6652,0x4E09,0x5098,0x53C2,0x5C71,0x60E8,0x6492,0x6563,0x685F,0x71E6,0x73CA,0x7523,0x7B97,0x7E82,0x8695,0x8B83,0x8CDB,0x9178,0x9910,0x65AC,0x66AB,0x6B8B,0x4ED5,0x4ED4,0x4F3A,0x4F7F,0x523A,0x53F8,0x53F2,0x55E3,0x56DB,0x58EB,0x59CB,0x59C9,0x59FF,0x5B50,0x5C4D,0x5E02,0x5E2B,0x5FD7,0x601D,0x6307,0x652F,0x5B5C,0x65AF,0x65BD,0x65E8,0x679D,0x6B62,0x6B7B,0x6C0F,0x7345,0x7949,0x79C1,0x7CF8,0x7D19,0x7D2B,0x80A2,0x8102,0x81F3,0x8996,0x8A5E,0x8A69,0x8A66,0x8A8C,0x8AEE,0x8CC7,0x8CDC,0x96CC,0x98FC,0x6B6F,0x4E8B,0x4F3C,0x4F8D,0x5150,0x5B57,0x5BFA,0x6148,0x6301,0x6642},
	decode_set1_BC[] = {0x6B21,0x6ECB,0x6CBB,0x723E,0x74BD,0x75D4,0x78C1,0x793A,0x800C,0x8033,0x81EA,0x8494,0x8F9E,0x6C50,0x9E7F,0x5F0F,0x8B58,0x9D2B,0x7AFA,0x8EF8,0x5B8D,0x96EB,0x4E03,0x53F1,0x57F7,0x5931,0x5AC9,0x5BA4,0x6089,0x6E7F,0x6F06,0x75BE,0x8CEA,0x5B9F,0x8500,0x7BE0,0x5072,0x67F4,0x829D,0x5C61,0x854A,0x7E1E,0x820E,0x5199,0x5C04,0x6368,0x8D66,0x659C,0x716E,0x793E,0x7D17,0x8005,0x8B1D,0x8ECA,0x906E,0x86C7,0x90AA,0x501F,0x52FA,0x5C3A,0x6753,0x707C,0x7235,0x914C,0x91C8,0x932B,0x82E5,0x5BC2,0x5F31,0x60F9,0x4E3B,0x53D6,0x5B88,0x624B,0x6731,0x6B8A,0x72E9,0x73E0,0x7A2E,0x816B,0x8DA3,0x9152,0x9996,0x5112,0x53D7,0x546A,0x5BFF,0x6388,0x6A39,0x7DAC,0x9700,0x56DA,0x53CE,0x5468},
	decode_set1_BD[] = {0x5B97,0x5C31,0x5DDE,0x4FEE,0x6101,0x62FE,0x6D32,0x79C0,0x79CB,0x7D42,0x7E4D,0x7FD2,0x81ED,0x821F,0x8490,0x8846,0x8972,0x8B90,0x8E74,0x8F2F,0x9031,0x914B,0x916C,0x96C6,0x919C,0x4EC0,0x4F4F,0x5145,0x5341,0x5F93,0x620E,0x67D4,0x6C41,0x6E0B,0x7363,0x7E26,0x91CD,0x9283,0x53D4,0x5919,0x5BBF,0x6DD1,0x795D,0x7E2E,0x7C9B,0x587E,0x719F,0x51FA,0x8853,0x8FF0,0x4FCA,0x5CFB,0x6625,0x77AC,0x7AE3,0x821C,0x99FF,0x51C6,0x5FAA,0x65EC,0x696F,0x6B89,0x6DF3,0x6E96,0x6F64,0x76FE,0x7D14,0x5DE1,0x9075,0x9187,0x9806,0x51E6,0x521D,0x6240,0x6691,0x66D9,0x6E1A,0x5EB6,0x7DD2,0x7F72,0x66F8,0x85AF,0x85F7,0x8AF8,0x52A9,0x53D9,0x5973,0x5E8F,0x5F90,0x6055,0x92E4,0x9664,0x50B7,0x511F},
	decode_set1_BE[] = {0x52DD,0x5320,0x5347,0x53EC,0x54E8,0x5546,0x5531,0x5617,0x5968,0x59BE,0x5A3C,0x5BB5,0x5C06,0x5C0F,0x5C11,0x5C1A,0x5E84,0x5E8A,0x5EE0,0x5F70,0x627F,0x6284,0x62DB,0x638C,0x6377,0x6607,0x660C,0x662D,0x6676,0x677E,0x68A2,0x6A1F,0x6A35,0x6CBC,0x6D88,0x6E09,0x6E58,0x713C,0x7126,0x7167,0x75C7,0x7701,0x785D,0x7901,0x7965,0x79F0,0x7AE0,0x7B11,0x7CA7,0x7D39,0x8096,0x83D6,0x848B,0x8549,0x885D,0x88F3,0x8A1F,0x8A3C,0x8A54,0x8A73,0x8C61,0x8CDE,0x91A4,0x9266,0x937E,0x9418,0x969C,0x9798,0x4E0A,0x4E08,0x4E1E,0x4E57,0x5197,0x5270,0x57CE,0x5834,0x58CC,0x5B22,0x5E38,0x60C5,0x64FE,0x6761,0x6756,0x6D44,0x72B6,0x7573,0x7A63,0x84B8,0x8B72,0x91B8,0x9320,0x5631,0x57F4,0x98FE},
	decode_set1_BF[] = {0x62ED,0x690D,0x6B96,0x71ED,0x7E54,0x8077,0x8272,0x89E6,0x98DF,0x8755,0x8FB1,0x5C3B,0x4F38,0x4FE1,0x4FB5,0x5507,0x5A20,0x5BDD,0x5BE9,0x5FC3,0x614E,0x632F,0x65B0,0x664B,0x68EE,0x699B,0x6D78,0x6DF1,0x7533,0x75B9,0x771F,0x795E,0x79E6,0x7D33,0x81E3,0x82AF,0x85AA,0x89AA,0x8A3A,0x8EAB,0x8F9B,0x9032,0x91DD,0x9707,0x4EBA,0x4EC1,0x5203,0x5875,0x58EC,0x5C0B,0x751A,0x5C3D,0x814E,0x8A0A,0x8FC5,0x9663,0x976D,0x7B25,0x8ACF,0x9808,0x9162,0x56F3,0x53A8,0x9017,0x5439,0x5782,0x5E25,0x63A8,0x6C34,0x708A,0x7761,0x7C8B,0x7FE0,0x8870,0x9042,0x9154,0x9310,0x9318,0x968F,0x745E,0x9AC4,0x5D07,0x5D69,0x6570,0x67A2,0x8DA8,0x96DB,0x636E,0x6749,0x6919,0x83C5,0x9817,0x96C0,0x88FE},
	decode_set1_C0[] = {0x6F84,0x647A,0x5BF8,0x4E16,0x702C,0x755D,0x662F,0x51C4,0x5236,0x52E2,0x59D3,0x5F81,0x6027,0x6210,0x653F,0x6574,0x661F,0x6674,0x68F2,0x6816,0x6B63,0x6E05,0x7272,0x751F,0x76DB,0x7CBE,0x8056,0x58F0,0x88FD,0x897F,0x8AA0,0x8A93,0x8ACB,0x901D,0x9192,0x9752,0x9759,0x6589,0x7A0E,0x8106,0x96BB,0x5E2D,0x60DC,0x621A,0x65A5,0x6614,0x6790,0x77F3,0x7A4D,0x7C4D,0x7E3E,0x810A,0x8CAC,0x8D64,0x8DE1,0x8E5F,0x78A9,0x5207,0x62D9,0x63A5,0x6442,0x6298,0x8A2D,0x7A83,0x7BC0,0x8AAC,0x96EA,0x7D76,0x820C,0x8749,0x4ED9,0x5148,0x5343,0x5360,0x5BA3,0x5C02,0x5C16,0x5DDD,0x6226,0x6247,0x64B0,0x6813,0x6834,0x6CC9,0x6D45,0x6D17,0x67D3,0x6F5C,0x714E,0x717D,0x65CB,0x7A7F,0x7BAD,0x7DDA},
	decode_set1_C1[] = {0x7E4A,0x7FA8,0x817A,0x821B,0x8239,0x85A6,0x8A6E,0x8CCE,0x8DF5,0x9078,0x9077,0x92AD,0x9291,0x9583,0x9BAE,0x524D,0x5584,0x6F38,0x7136,0x5168,0x7985,0x7E55,0x81B3,0x7CCE,0x564C,0x5851,0x5CA8,0x63AA,0x66FE,0x66FD,0x695A,0x72D9,0x758F,0x758E,0x790E,0x7956,0x79DF,0x7C97,0x7D20,0x7D44,0x8607,0x8A34,0x963B,0x9061,0x9F20,0x50E7,0x5275,0x53CC,0x53E2,0x5009,0x55AA,0x58EE,0x594F,0x723D,0x5B8B,0x5C64,0x531D,0x60E3,0x60F3,0x635C,0x6383,0x633F,0x63BB,0x64CD,0x65E9,0x66F9,0x5DE3,0x69CD,0x69FD,0x6F15,0x71E5,0x4E89,0x75E9,0x76F8,0x7A93,0x7CDF,0x7DCF,0x7D9C,0x8061,0x8349,0x8358,0x846C,0x84BC,0x85FB,0x88C5,0x8D70,0x9001,0x906D,0x9397,0x971C,0x9A12,0x50CF,0x5897,0x618E},
	decode_set1_C2[] = {0x81D3,0x8535,0x8D08,0x9020,0x4FC3,0x5074,0x5247,0x5373,0x606F,0x6349,0x675F,0x6E2C,0x8DB3,0x901F,0x4FD7,0x5C5E,0x8CCA,0x65CF,0x7D9A,0x5352,0x8896,0x5176,0x63C3,0x5B58,0x5B6B,0x5C0A,0x640D,0x6751,0x905C,0x4ED6,0x591A,0x592A,0x6C70,0x8A51,0x553E,0x5815,0x59A5,0x60F0,0x6253,0x67C1,0x8235,0x6955,0x9640,0x99C4,0x9A28,0x4F53,0x5806,0x5BFE,0x8010,0x5CB1,0x5E2F,0x5F85,0x6020,0x614B,0x6234,0x66FF,0x6CF0,0x6EDE,0x80CE,0x817F,0x82D4,0x888B,0x8CB8,0x9000,0x902E,0x968A,0x9EDB,0x9BDB,0x4EE3,0x53F0,0x5927,0x7B2C,0x918D,0x984C,0x9DF9,0x6EDD,0x7027,0x5353,0x5544,0x5B85,0x6258,0x629E,0x62D3,0x6CA2,0x6FEF,0x7422,0x8A17,0x9438,0x6FC1,0x8AFE,0x8338,0x51E7,0x86F8,0x53EA},
	decode_set1_C3[] = {0x53E9,0x4F46,0x9054,0x8FB0,0x596A,0x8131,0x5DFD,0x7AEA,0x8FBF,0x68DA,0x8C37,0x72F8,0x9C48,0x6A3D,0x8AB0,0x4E39,0x5358,0x5606,0x5766,0x62C5,0x63A2,0x65E6,0x6B4E,0x6DE1,0x6E5B,0x70AD,0x77ED,0x7AEF,0x7BAA,0x7DBB,0x803D,0x80C6,0x86CB,0x8A95,0x935B,0x56E3,0x58C7,0x5F3E,0x65AD,0x6696,0x6A80,0x6BB5,0x7537,0x8AC7,0x5024,0x77E5,0x5730,0x5F1B,0x6065,0x667A,0x6C60,0x75F4,0x7A1A,0x7F6E,0x81F4,0x8718,0x9045,0x99B3,0x7BC9,0x755C,0x7AF9,0x7B51,0x84C4,0x9010,0x79E9,0x7A92,0x8336,0x5AE1,0x7740,0x4E2D,0x4EF2,0x5B99,0x5FE0,0x62BD,0x663C,0x67F1,0x6CE8,0x866B,0x8877,0x8A3B,0x914E,0x92F3,0x99D0,0x6A17,0x7026,0x732A,0x82E7,0x8457,0x8CAF,0x4E01,0x5146,0x51CB,0x558B,0x5BF5},
	decode_set1_C4[] = {0x5E16,0x5E33,0x5E81,0x5F14,0x5F35,0x5F6B,0x5FB4,0x61F2,0x6311,0x66A2,0x671D,0x6F6E,0x7252,0x753A,0x773A,0x8074,0x8139,0x8178,0x8776,0x8ABF,0x8ADC,0x8D85,0x8DF3,0x929A,0x9577,0x9802,0x9CE5,0x52C5,0x6357,0x76F4,0x6715,0x6C88,0x73CD,0x8CC3,0x93AE,0x9673,0x6D25,0x589C,0x690E,0x69CC,0x8FFD,0x939A,0x75DB,0x901A,0x585A,0x6802,0x63B4,0x69FB,0x4F43,0x6F2C,0x67D8,0x8FBB,0x8526,0x7DB4,0x9354,0x693F,0x6F70,0x576A,0x58F7,0x5B2C,0x7D2C,0x722A,0x540A,0x91E3,0x9DB4,0x4EAD,0x4F4E,0x505C,0x5075,0x5243,0x8C9E,0x5448,0x5824,0x5B9A,0x5E1D,0x5E95,0x5EAD,0x5EF7,0x5F1F,0x608C,0x62B5,0x633A,0x63D0,0x68AF,0x6C40,0x7887,0x798E,0x7A0B,0x7DE0,0x8247,0x8A02,0x8AE6,0x8E44,0x9013},
	decode_set1_C5[] = {0x90B8,0x912D,0x91D8,0x9F0E,0x6CE5,0x6458,0x64E2,0x6575,0x6EF4,0x7684,0x7B1B,0x9069,0x93D1,0x6EBA,0x54F2,0x5FB9,0x64A4,0x8F4D,0x8FED,0x9244,0x5178,0x586B,0x5929,0x5C55,0x5E97,0x6DFB,0x7E8F,0x751C,0x8CBC,0x8EE2,0x985B,0x70B9,0x4F1D,0x6BBF,0x6FB1,0x7530,0x96FB,0x514E,0x5410,0x5835,0x5857,0x59AC,0x5C60,0x5F92,0x6597,0x675C,0x6E21,0x767B,0x83DF,0x8CED,0x9014,0x90FD,0x934D,0x7825,0x783A,0x52AA,0x5EA6,0x571F,0x5974,0x6012,0x5012,0x515A,0x51AC,0x51CD,0x5200,0x5510,0x5854,0x5858,0x5957,0x5B95,0x5CF6,0x5D8B,0x60BC,0x6295,0x642D,0x6771,0x6843,0x68BC,0x68DF,0x76D7,0x6DD8,0x6E6F,0x6D9B,0x706F,0x71C8,0x5F53,0x75D8,0x7977,0x7B49,0x7B54,0x7B52,0x7CD6,0x7D71,0x5230},
	decode_set1_C6[] = {0x8463,0x8569,0x85E4,0x8A0E,0x8B04,0x8C46,0x8E0F,0x9003,0x900F,0x9419,0x9676,0x982D,0x9A30,0x95D8,0x50CD,0x52D5,0x540C,0x5802,0x5C0E,0x61A7,0x649E,0x6D1E,0x77B3,0x7AE5,0x80F4,0x8404,0x9053,0x9285,0x5CE0,0x9D07,0x533F,0x5F97,0x5FB3,0x6D9C,0x7279,0x7763,0x79BF,0x7BE4,0x6BD2,0x72EC,0x8AAD,0x6803,0x6A61,0x51F8,0x7A81,0x6934,0x5C4A,0x9CF6,0x82EB,0x5BC5,0x9149,0x701E,0x5678,0x5C6F,0x60C7,0x6566,0x6C8C,0x8C5A,0x9041,0x9813,0x5451,0x66C7,0x920D,0x5948,0x90A3,0x5185,0x4E4D,0x51EA,0x8599,0x8B0E,0x7058,0x637A,0x934B,0x6962,0x99B4,0x7E04,0x7577,0x5357,0x6960,0x8EDF,0x96E3,0x6C5D,0x4E8C,0x5C3C,0x5F10,0x8FE9,0x5302,0x8CD1,0x8089,0x8679,0x5EFF,0x65E5,0x4E73,0x5165},
	decode_set1_C7[] = {0x5982,0x5C3F,0x97EE,0x4EFB,0x598A,0x5FCD,0x8A8D,0x6FE1,0x79B0,0x7962,0x5BE7,0x8471,0x732B,0x71B1,0x5E74,0x5FF5,0x637B,0x649A,0x71C3,0x7C98,0x4E43,0x5EFC,0x4E4B,0x57DC,0x56A2,0x60A9,0x6FC3,0x7D0D,0x80FD,0x8133,0x81BF,0x8FB2,0x8997,0x86A4,0x5DF4,0x628A,0x64AD,0x8987,0x6777,0x6CE2,0x6D3E,0x7436,0x7834,0x5A46,0x7F75,0x82AD,0x99AC,0x4FF3,0x5EC3,0x62DD,0x6392,0x6557,0x676F,0x76C3,0x724C,0x80CC,0x80BA,0x8F29,0x914D,0x500D,0x57F9,0x5A92,0x6885,0x6973,0x7164,0x72FD,0x8CB7,0x58F2,0x8CE0,0x966A,0x9019,0x877F,0x79E4,0x77E7,0x8429,0x4F2F,0x5265,0x535A,0x62CD,0x67CF,0x6CCA,0x767D,0x7B94,0x7C95,0x8236,0x8584,0x8FEB,0x66DD,0x6F20,0x7206,0x7E1B,0x83AB,0x99C1,0x9EA6},
	decode_set1_C8[] = {0x51FD,0x7BB1,0x7872,0x7BB8,0x8087,0x7B48,0x6AE8,0x5E61,0x808C,0x7551,0x7560,0x516B,0x9262,0x6E8C,0x767A,0x9197,0x9AEA,0x4F10,0x7F70,0x629C,0x7B4F,0x95A5,0x9CE9,0x567A,0x5859,0x86E4,0x96BC,0x4F34,0x5224,0x534A,0x53CD,0x53DB,0x5E06,0x642C,0x6591,0x677F,0x6C3E,0x6C4E,0x7248,0x72AF,0x73ED,0x7554,0x7E41,0x822C,0x85E9,0x8CA9,0x7BC4,0x91C6,0x7169,0x9812,0x98EF,0x633D,0x6669,0x756A,0x76E4,0x78D0,0x8543,0x86EE,0x532A,0x5351,0x5426,0x5983,0x5E87,0x5F7C,0x60B2,0x6249,0x6279,0x62AB,0x6590,0x6BD4,0x6CCC,0x75B2,0x76AE,0x7891,0x79D8,0x7DCB,0x7F77,0x80A5,0x88AB,0x8AB9,0x8CBB,0x907F,0x975E,0x98DB,0x6A0B,0x7C38,0x5099,0x5C3E,0x5FAE,0x6787,0x6BD8,0x7435,0x7709,0x7F8E},
	decode_set1_C9[] = {0x9F3B,0x67CA,0x7A17,0x5339,0x758B,0x9AED,0x5F66,0x819D,0x83F1,0x8098,0x5F3C,0x5FC5,0x7562,0x7B46,0x903C,0x6867,0x59EB,0x5A9B,0x7D10,0x767E,0x8B2C,0x4FF5,0x5F6A,0x6A19,0x6C37,0x6F02,0x74E2,0x7968,0x8868,0x8A55,0x8C79,0x5EDF,0x63CF,0x75C5,0x79D2,0x82D7,0x9328,0x92F2,0x849C,0x86ED,0x9C2D,0x54C1,0x5F6C,0x658C,0x6D5C,0x7015,0x8CA7,0x8CD3,0x983B,0x654F,0x74F6,0x4E0D,0x4ED8,0x57E0,0x592B,0x5A66,0x5BCC,0x51A8,0x5E03,0x5E9C,0x6016,0x6276,0x6577,0x65A7,0x666E,0x6D6E,0x7236,0x7B26,0x8150,0x819A,0x8299,0x8B5C,0x8CA0,0x8CE6,0x8D74,0x961C,0x9644,0x4FAE,0x64AB,0x6B66,0x821E,0x8461,0x856A,0x90E8,0x5C01,0x6953,0x98A8,0x847A,0x8557,0x4F0F,0x526F,0x5FA9,0x5E45,0x670D},
	decode_set1_CA[] = {0x798F,0x8179,0x8907,0x8986,0x6DF5,0x5F17,0x6255,0x6CB8,0x4ECF,0x7269,0x9B92,0x5206,0x543B,0x5674,0x58B3,0x61A4,0x626E,0x711A,0x596E,0x7C89,0x7CDE,0x7D1B,0x96F0,0x6587,0x805E,0x4E19,0x4F75,0x5175,0x5840,0x5E63,0x5E73,0x5F0A,0x67C4,0x4E26,0x853D,0x9589,0x965B,0x7C73,0x9801,0x50FB,0x58C1,0x7656,0x78A7,0x5225,0x77A5,0x8511,0x7B86,0x504F,0x5909,0x7247,0x7BC7,0x7DE8,0x8FBA,0x8FD4,0x904D,0x4FBF,0x52C9,0x5A29,0x5F01,0x97AD,0x4FDD,0x8217,0x92EA,0x5703,0x6355,0x6B69,0x752B,0x88DC,0x8F14,0x7A42,0x52DF,0x5893,0x6155,0x620A,0x66AE,0x6BCD,0x7C3F,0x83E9,0x5023,0x4FF8,0x5305,0x5446,0x5831,0x5949,0x5B9D,0x5CF0,0x5CEF,0x5D29,0x5E96,0x62B1,0x6367,0x653E,0x65B9,0x670B},
	decode_set1_CB[] = {0x6CD5,0x6CE1,0x70F9,0x7832,0x7E2B,0x80DE,0x82B3,0x840C,0x84EC,0x8702,0x8912,0x8A2A,0x8C4A,0x90A6,0x92D2,0x98FD,0x9CF3,0x9D6C,0x4E4F,0x4EA1,0x508D,0x5256,0x574A,0x59A8,0x5E3D,0x5FD8,0x5FD9,0x623F,0x66B4,0x671B,0x67D0,0x68D2,0x5192,0x7D21,0x80AA,0x81A8,0x8B00,0x8C8C,0x8CBF,0x927E,0x9632,0x5420,0x982C,0x5317,0x50D5,0x535C,0x58A8,0x64B2,0x6734,0x7267,0x7766,0x7A46,0x91E6,0x52C3,0x6CA1,0x6B86,0x5800,0x5E4C,0x5954,0x672C,0x7FFB,0x51E1,0x76C6,0x6469,0x78E8,0x9B54,0x9EBB,0x57CB,0x59B9,0x6627,0x679A,0x6BCE,0x54E9,0x69D9,0x5E55,0x819C,0x6795,0x9BAA,0x67FE,0x9C52,0x685D,0x4EA6,0x4FE3,0x53C8,0x62B9,0x672B,0x6CAB,0x8FC4,0x4FAD,0x7E6D,0x9EBF,0x4E07,0x6162,0x6E80},
	decode_set1_CC[] = {0x6F2B,0x8513,0x5473,0x672A,0x9B45,0x5DF3,0x7B95,0x5CAC,0x5BC6,0x871C,0x6E4A,0x84D1,0x7A14,0x8108,0x5999,0x7C8D,0x6C11,0x7720,0x52D9,0x5922,0x7121,0x725F,0x77DB,0x9727,0x9D61,0x690B,0x5A7F,0x5A18,0x51A5,0x540D,0x547D,0x660E,0x76DF,0x8FF7,0x9298,0x9CF4,0x59EA,0x725D,0x6EC5,0x514D,0x68C9,0x7DBF,0x7DEC,0x9762,0x9EBA,0x6478,0x6A21,0x8302,0x5984,0x5B5F,0x6BDB,0x731B,0x76F2,0x7DB2,0x8017,0x8499,0x5132,0x6728,0x9ED9,0x76EE,0x6762,0x52FF,0x9905,0x5C24,0x623B,0x7C7E,0x8CB0,0x554F,0x60B6,0x7D0B,0x9580,0x5301,0x4E5F,0x51B6,0x591C,0x723A,0x8036,0x91CE,0x5F25,0x77E2,0x5384,0x5F79,0x7D04,0x85AC,0x8A33,0x8E8D,0x9756,0x67F3,0x85AE,0x9453,0x6109,0x6108,0x6CB9,0x7652},
	decode_set1_CD[] = {0x8AED,0x8F38,0x552F,0x4F51,0x512A,0x52C7,0x53CB,0x5BA5,0x5E7D,0x60A0,0x6182,0x63D6,0x6709,0x67DA,0x6E67,0x6D8C,0x7336,0x7337,0x7531,0x7950,0x88D5,0x8A98,0x904A,0x9091,0x90F5,0x96C4,0x878D,0x5915,0x4E88,0x4F59,0x4E0E,0x8A89,0x8F3F,0x9810,0x50AD,0x5E7C,0x5996,0x5BB9,0x5EB8,0x63DA,0x63FA,0x64C1,0x66DC,0x694A,0x69D8,0x6D0B,0x6EB6,0x7194,0x7528,0x7AAF,0x7F8A,0x8000,0x8449,0x84C9,0x8981,0x8B21,0x8E0A,0x9065,0x967D,0x990A,0x617E,0x6291,0x6B32,0x6C83,0x6D74,0x7FCC,0x7FFC,0x6DC0,0x7F85,0x87BA,0x88F8,0x6765,0x83B1,0x983C,0x96F7,0x6D1B,0x7D61,0x843D,0x916A,0x4E71,0x5375,0x5D50,0x6B04,0x6FEB,0x85CD,0x862D,0x89A7,0x5229,0x540F,0x5C65,0x674E,0x68A8,0x7406,0x7483},
	decode_set1_CE[] = {0x75E2,0x88CF,0x88E1,0x91CC,0x96E2,0x9678,0x5F8B,0x7387,0x7ACB,0x844E,0x63A0,0x7565,0x5289,0x6D41,0x6E9C,0x7409,0x7559,0x786B,0x7C92,0x9686,0x7ADC,0x9F8D,0x4FB6,0x616E,0x65C5,0x865C,0x4E86,0x4EAE,0x50DA,0x4E21,0x51CC,0x5BEE,0x6599,0x6881,0x6DBC,0x731F,0x7642,0x77AD,0x7A1C,0x7CE7,0x826F,0x8AD2,0x907C,0x91CF,0x9675,0x9818,0x529B,0x7DD1,0x502B,0x5398,0x6797,0x6DCB,0x71D0,0x7433,0x81E8,0x8F2A,0x96A3,0x9C57,0x9E9F,0x7460,0x5841,0x6D99,0x7D2F,0x985E,0x4EE4,0x4F36,0x4F8B,0x51B7,0x52B1,0x5DBA,0x601C,0x73B2,0x793C,0x82D3,0x9234,0x96B7,0x96F6,0x970A,0x9E97,0x9F62,0x66A6,0x6B74,0x5217,0x52A3,0x70C8,0x88C2,0x5EC9,0x604B,0x6190,0x6F23,0x7149,0x7C3E,0x7DF4,0x806F},
	decode_set1_CF[] = {0x84EE,0x9023,0x932C,0x5442,0x9B6F,0x6AD3,0x7089,0x8CC2,0x8DEF,0x9732,0x52B4,0x5A41,0x5ECA,0x5F04,0x6717,0x697C,0x6994,0x6D6A,0x6F0F,0x7262,0x72FC,0x7BED,0x8001,0x807E,0x874B,0x90CE,0x516D,0x9E93,0x7984,0x808B,0x9332,0x8AD6,0x502D,0x548C,0x8A71,0x6B6A,0x8CC4,0x8107,0x60D1,0x67A0,0x9DF2,0x4E99,0x4E98,0x9C10,0x8A6B,0x85C1,0x8568,0x6900,0x6E7E,0x7897,0x8155,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_D0[] = {0x5F0C,0x4E10,0x4E15,0x4E2A,0x4E31,0x4E36,0x4E3C,0x4E3F,0x4E42,0x4E56,0x4E58,0x4E82,0x4E85,0x8C6B,0x4E8A,0x8212,0x5F0D,0x4E8E,0x4E9E,0x4E9F,0x4EA0,0x4EA2,0x4EB0,0x4EB3,0x4EB6,0x4ECE,0x4ECD,0x4EC4,0x4EC6,0x4EC2,0x4ED7,0x4EDE,0x4EED,0x4EDF,0x4EF7,0x4F09,0x4F5A,0x4F30,0x4F5B,0x4F5D,0x4F57,0x4F47,0x4F76,0x4F88,0x4F8F,0x4F98,0x4F7B,0x4F69,0x4F70,0x4F91,0x4F6F,0x4F86,0x4F96,0x5118,0x4FD4,0x4FDF,0x4FCE,0x4FD8,0x4FDB,0x4FD1,0x4FDA,0x4FD0,0x4FE4,0x4FE5,0x501A,0x5028,0x5014,0x502A,0x5025,0x5005,0x4F1C,0x4FF6,0x5021,0x5029,0x502C,0x4FFE,0x4FEF,0x5011,0x5006,0x5043,0x5047,0x6703,0x5055,0x5050,0x5048,0x505A,0x5056,0x506C,0x5078,0x5080,0x509A,0x5085,0x50B4,0x50B2},
	decode_set1_D1[] = {0x50C9,0x50CA,0x50B3,0x50C2,0x50D6,0x50DE,0x50E5,0x50ED,0x50E3,0x50EE,0x50F9,0x50F5,0x5109,0x5101,0x5102,0x5116,0x5115,0x5114,0x511A,0x5121,0x513A,0x5137,0x513C,0x513B,0x513F,0x5140,0x5152,0x514C,0x5154,0x5162,0x7AF8,0x5169,0x516A,0x516E,0x5180,0x5182,0x56D8,0x518C,0x5189,0x518F,0x5191,0x5193,0x5195,0x5196,0x51A4,0x51A6,0x51A2,0x51A9,0x51AA,0x51AB,0x51B3,0x51B1,0x51B2,0x51B0,0x51B5,0x51BD,0x51C5,0x51C9,0x51DB,0x51E0,0x8655,0x51E9,0x51ED,0x51F0,0x51F5,0x51FE,0x5204,0x520B,0x5214,0x520E,0x5227,0x522A,0x522E,0x5233,0x5239,0x524F,0x5244,0x524B,0x524C,0x525E,0x5254,0x526A,0x5274,0x5269,0x5273,0x527F,0x527D,0x528D,0x5294,0x5292,0x5271,0x5288,0x5291,0x8FA8},
	decode_set1_D2[] = {0x8FA7,0x52AC,0x52AD,0x52BC,0x52B5,0x52C1,0x52CD,0x52D7,0x52DE,0x52E3,0x52E6,0x98ED,0x52E0,0x52F3,0x52F5,0x52F8,0x52F9,0x5306,0x5308,0x7538,0x530D,0x5310,0x530F,0x5315,0x531A,0x5323,0x532F,0x5331,0x5333,0x5338,0x5340,0x5346,0x5345,0x4E17,0x5349,0x534D,0x51D6,0x535E,0x5369,0x536E,0x5918,0x537B,0x5377,0x5382,0x5396,0x53A0,0x53A6,0x53A5,0x53AE,0x53B0,0x53B6,0x53C3,0x7C12,0x96D9,0x53DF,0x66FC,0x71EE,0x53EE,0x53E8,0x53ED,0x53FA,0x5401,0x543D,0x5440,0x542C,0x542D,0x543C,0x542E,0x5436,0x5429,0x541D,0x544E,0x548F,0x5475,0x548E,0x545F,0x5471,0x5477,0x5470,0x5492,0x547B,0x5480,0x5476,0x5484,0x5490,0x5486,0x54C7,0x54A2,0x54B8,0x54A5,0x54AC,0x54C4,0x54C8,0x54A8},
	decode_set1_D3[] = {0x54AB,0x54C2,0x54A4,0x54BE,0x54BC,0x54D8,0x54E5,0x54E6,0x550F,0x5514,0x54FD,0x54EE,0x54ED,0x54FA,0x54E2,0x5539,0x5540,0x5563,0x554C,0x552E,0x555C,0x5545,0x5556,0x5557,0x5538,0x5533,0x555D,0x5599,0x5580,0x54AF,0x558A,0x559F,0x557B,0x557E,0x5598,0x559E,0x55AE,0x557C,0x5583,0x55A9,0x5587,0x55A8,0x55DA,0x55C5,0x55DF,0x55C4,0x55DC,0x55E4,0x55D4,0x5614,0x55F7,0x5616,0x55FE,0x55FD,0x561B,0x55F9,0x564E,0x5650,0x71DF,0x5634,0x5636,0x5632,0x5638,0x566B,0x5664,0x562F,0x566C,0x566A,0x5686,0x5680,0x568A,0x56A0,0x5694,0x568F,0x56A5,0x56AE,0x56B6,0x56B4,0x56C2,0x56BC,0x56C1,0x56C3,0x56C0,0x56C8,0x56CE,0x56D1,0x56D3,0x56D7,0x56EE,0x56F9,0x5700,0x56FF,0x5704,0x5709},
	decode_set1_D4[] = {0x5708,0x570B,0x570D,0x5713,0x5718,0x5716,0x55C7,0x571C,0x5726,0x5737,0x5738,0x574E,0x573B,0x5740,0x574F,0x5769,0x57C0,0x5788,0x5761,0x577F,0x5789,0x5793,0x57A0,0x57B3,0x57A4,0x57AA,0x57B0,0x57C3,0x57C6,0x57D4,0x57D2,0x57D3,0x580A,0x57D6,0x57E3,0x580B,0x5819,0x581D,0x5872,0x5821,0x5862,0x584B,0x5870,0x6BC0,0x5852,0x583D,0x5879,0x5885,0x58B9,0x589F,0x58AB,0x58BA,0x58DE,0x58BB,0x58B8,0x58AE,0x58C5,0x58D3,0x58D1,0x58D7,0x58D9,0x58D8,0x58E5,0x58DC,0x58E4,0x58DF,0x58EF,0x58FA,0x58F9,0x58FB,0x58FC,0x58FD,0x5902,0x590A,0x5910,0x591B,0x68A6,0x5925,0x592C,0x592D,0x5932,0x5938,0x593E,0x7AD2,0x5955,0x5950,0x594E,0x595A,0x5958,0x5962,0x5960,0x5967,0x596C,0x5969},
	decode_set1_D5[] = {0x5978,0x5981,0x599D,0x4F5E,0x4FAB,0x59A3,0x59B2,0x59C6,0x59E8,0x59DC,0x598D,0x59D9,0x59DA,0x5A25,0x5A1F,0x5A11,0x5A1C,0x5A09,0x5A1A,0x5A40,0x5A6C,0x5A49,0x5A35,0x5A36,0x5A62,0x5A6A,0x5A9A,0x5ABC,0x5ABE,0x5ACB,0x5AC2,0x5ABD,0x5AE3,0x5AD7,0x5AE6,0x5AE9,0x5AD6,0x5AFA,0x5AFB,0x5B0C,0x5B0B,0x5B16,0x5B32,0x5AD0,0x5B2A,0x5B36,0x5B3E,0x5B43,0x5B45,0x5B40,0x5B51,0x5B55,0x5B5A,0x5B5B,0x5B65,0x5B69,0x5B70,0x5B73,0x5B75,0x5B78,0x6588,0x5B7A,0x5B80,0x5B83,0x5BA6,0x5BB8,0x5BC3,0x5BC7,0x5BC9,0x5BD4,0x5BD0,0x5BE4,0x5BE6,0x5BE2,0x5BDE,0x5BE5,0x5BEB,0x5BF0,0x5BF6,0x5BF3,0x5C05,0x5C07,0x5C08,0x5C0D,0x5C13,0x5C20,0x5C22,0x5C28,0x5C38,0x5C39,0x5C41,0x5C46,0x5C4E,0x5C53},
	decode_set1_D6[] = {0x5C50,0x5C4F,0x5B71,0x5C6C,0x5C6E,0x4E62,0x5C76,0x5C79,0x5C8C,0x5C91,0x5C94,0x599B,0x5CAB,0x5CBB,0x5CB6,0x5CBC,0x5CB7,0x5CC5,0x5CBE,0x5CC7,0x5CD9,0x5CE9,0x5CFD,0x5CFA,0x5CED,0x5D8C,0x5CEA,0x5D0B,0x5D15,0x5D17,0x5D5C,0x5D1F,0x5D1B,0x5D11,0x5D14,0x5D22,0x5D1A,0x5D19,0x5D18,0x5D4C,0x5D52,0x5D4E,0x5D4B,0x5D6C,0x5D73,0x5D76,0x5D87,0x5D84,0x5D82,0x5DA2,0x5D9D,0x5DAC,0x5DAE,0x5DBD,0x5D90,0x5DB7,0x5DBC,0x5DC9,0x5DCD,0x5DD3,0x5DD2,0x5DD6,0x5DDB,0x5DEB,0x5DF2,0x5DF5,0x5E0B,0x5E1A,0x5E19,0x5E11,0x5E1B,0x5E36,0x5E37,0x5E44,0x5E43,0x5E40,0x5E4E,0x5E57,0x5E54,0x5E5F,0x5E62,0x5E64,0x5E47,0x5E75,0x5E76,0x5E7A,0x9EBC,0x5E7F,0x5EA0,0x5EC1,0x5EC2,0x5EC8,0x5ED0,0x5ECF},
	decode_set1_D7[] = {0x5ED6,0x5EE3,0x5EDD,0x5EDA,0x5EDB,0x5EE2,0x5EE1,0x5EE8,0x5EE9,0x5EEC,0x5EF1,0x5EF3,0x5EF0,0x5EF4,0x5EF8,0x5EFE,0x5F03,0x5F09,0x5F5D,0x5F5C,0x5F0B,0x5F11,0x5F16,0x5F29,0x5F2D,0x5F38,0x5F41,0x5F48,0x5F4C,0x5F4E,0x5F2F,0x5F51,0x5F56,0x5F57,0x5F59,0x5F61,0x5F6D,0x5F73,0x5F77,0x5F83,0x5F82,0x5F7F,0x5F8A,0x5F88,0x5F91,0x5F87,0x5F9E,0x5F99,0x5F98,0x5FA0,0x5FA8,0x5FAD,0x5FBC,0x5FD6,0x5FFB,0x5FE4,0x5FF8,0x5FF1,0x5FDD,0x60B3,0x5FFF,0x6021,0x6060,0x6019,0x6010,0x6029,0x600E,0x6031,0x601B,0x6015,0x602B,0x6026,0x600F,0x603A,0x605A,0x6041,0x606A,0x6077,0x605F,0x604A,0x6046,0x604D,0x6063,0x6043,0x6064,0x6042,0x606C,0x606B,0x6059,0x6081,0x608D,0x60E7,0x6083,0x609A},
	decode_set1_D8[] = {0x6084,0x609B,0x6096,0x6097,0x6092,0x60A7,0x608B,0x60E1,0x60B8,0x60E0,0x60D3,0x60B4,0x5FF0,0x60BD,0x60C6,0x60B5,0x60D8,0x614D,0x6115,0x6106,0x60F6,0x60F7,0x6100,0x60F4,0x60FA,0x6103,0x6121,0x60FB,0x60F1,0x610D,0x610E,0x6147,0x613E,0x6128,0x6127,0x614A,0x613F,0x613C,0x612C,0x6134,0x613D,0x6142,0x6144,0x6173,0x6177,0x6158,0x6159,0x615A,0x616B,0x6174,0x616F,0x6165,0x6171,0x615F,0x615D,0x6153,0x6175,0x6199,0x6196,0x6187,0x61AC,0x6194,0x619A,0x618A,0x6191,0x61AB,0x61AE,0x61CC,0x61CA,0x61C9,0x61F7,0x61C8,0x61C3,0x61C6,0x61BA,0x61CB,0x7F79,0x61CD,0x61E6,0x61E3,0x61F6,0x61FA,0x61F4,0x61FF,0x61FD,0x61FC,0x61FE,0x6200,0x6208,0x6209,0x620D,0x620C,0x6214,0x621B},
	decode_set1_D9[] = {0x621E,0x6221,0x622A,0x622E,0x6230,0x6232,0x6233,0x6241,0x624E,0x625E,0x6263,0x625B,0x6260,0x6268,0x627C,0x6282,0x6289,0x627E,0x6292,0x6293,0x6296,0x62D4,0x6283,0x6294,0x62D7,0x62D1,0x62BB,0x62CF,0x62FF,0x62C6,0x64D4,0x62C8,0x62DC,0x62CC,0x62CA,0x62C2,0x62C7,0x629B,0x62C9,0x630C,0x62EE,0x62F1,0x6327,0x6302,0x6308,0x62EF,0x62F5,0x6350,0x633E,0x634D,0x641C,0x634F,0x6396,0x638E,0x6380,0x63AB,0x6376,0x63A3,0x638F,0x6389,0x639F,0x63B5,0x636B,0x6369,0x63BE,0x63E9,0x63C0,0x63C6,0x63E3,0x63C9,0x63D2,0x63F6,0x63C4,0x6416,0x6434,0x6406,0x6413,0x6426,0x6436,0x651D,0x6417,0x6428,0x640F,0x6467,0x646F,0x6476,0x644E,0x652A,0x6495,0x6493,0x64A5,0x64A9,0x6488,0x64BC},
	decode_set1_DA[] = {0x64DA,0x64D2,0x64C5,0x64C7,0x64BB,0x64D8,0x64C2,0x64F1,0x64E7,0x8209,0x64E0,0x64E1,0x62AC,0x64E3,0x64EF,0x652C,0x64F6,0x64F4,0x64F2,0x64FA,0x6500,0x64FD,0x6518,0x651C,0x6505,0x6524,0x6523,0x652B,0x6534,0x6535,0x6537,0x6536,0x6538,0x754B,0x6548,0x6556,0x6555,0x654D,0x6558,0x655E,0x655D,0x6572,0x6578,0x6582,0x6583,0x8B8A,0x659B,0x659F,0x65AB,0x65B7,0x65C3,0x65C6,0x65C1,0x65C4,0x65CC,0x65D2,0x65DB,0x65D9,0x65E0,0x65E1,0x65F1,0x6772,0x660A,0x6603,0x65FB,0x6773,0x6635,0x6636,0x6634,0x661C,0x664F,0x6644,0x6649,0x6641,0x665E,0x665D,0x6664,0x6667,0x6668,0x665F,0x6662,0x6670,0x6683,0x6688,0x668E,0x6689,0x6684,0x6698,0x669D,0x66C1,0x66B9,0x66C9,0x66BE,0x66BC},
	decode_set1_DB[] = {0x66C4,0x66B8,0x66D6,0x66DA,0x66E0,0x663F,0x66E6,0x66E9,0x66F0,0x66F5,0x66F7,0x670F,0x6716,0x671E,0x6726,0x6727,0x9738,0x672E,0x673F,0x6736,0x6741,0x6738,0x6737,0x6746,0x675E,0x6760,0x6759,0x6763,0x6764,0x6789,0x6770,0x67A9,0x677C,0x676A,0x678C,0x678B,0x67A6,0x67A1,0x6785,0x67B7,0x67EF,0x67B4,0x67EC,0x67B3,0x67E9,0x67B8,0x67E4,0x67DE,0x67DD,0x67E2,0x67EE,0x67B9,0x67CE,0x67C6,0x67E7,0x6A9C,0x681E,0x6846,0x6829,0x6840,0x684D,0x6832,0x684E,0x68B3,0x682B,0x6859,0x6863,0x6877,0x687F,0x689F,0x688F,0x68AD,0x6894,0x689D,0x689B,0x6883,0x6AAE,0x68B9,0x6874,0x68B5,0x68A0,0x68BA,0x690F,0x688D,0x687E,0x6901,0x68CA,0x6908,0x68D8,0x6922,0x6926,0x68E1,0x690C,0x68CD},
	decode_set1_DC[] = {0x68D4,0x68E7,0x68D5,0x6936,0x6912,0x6904,0x68D7,0x68E3,0x6925,0x68F9,0x68E0,0x68EF,0x6928,0x692A,0x691A,0x6923,0x6921,0x68C6,0x6979,0x6977,0x695C,0x6978,0x696B,0x6954,0x697E,0x696E,0x6939,0x6974,0x693D,0x6959,0x6930,0x6961,0x695E,0x695D,0x6981,0x696A,0x69B2,0x69AE,0x69D0,0x69BF,0x69C1,0x69D3,0x69BE,0x69CE,0x5BE8,0x69CA,0x69DD,0x69BB,0x69C3,0x69A7,0x6A2E,0x6991,0x69A0,0x699C,0x6995,0x69B4,0x69DE,0x69E8,0x6A02,0x6A1B,0x69FF,0x6B0A,0x69F9,0x69F2,0x69E7,0x6A05,0x69B1,0x6A1E,0x69ED,0x6A14,0x69EB,0x6A0A,0x6A12,0x6AC1,0x6A23,0x6A13,0x6A44,0x6A0C,0x6A72,0x6A36,0x6A78,0x6A47,0x6A62,0x6A59,0x6A66,0x6A48,0x6A38,0x6A22,0x6A90,0x6A8D,0x6AA0,0x6A84,0x6AA2,0x6AA3},
	decode_set1_DD[] = {0x6A97,0x8617,0x6ABB,0x6AC3,0x6AC2,0x6AB8,0x6AB3,0x6AAC,0x6ADE,0x6AD1,0x6ADF,0x6AAA,0x6ADA,0x6AEA,0x6AFB,0x6B05,0x8616,0x6AFA,0x6B12,0x6B16,0x9B31,0x6B1F,0x6B38,0x6B37,0x76DC,0x6B39,0x98EE,0x6B47,0x6B43,0x6B49,0x6B50,0x6B59,0x6B54,0x6B5B,0x6B5F,0x6B61,0x6B78,0x6B79,0x6B7F,0x6B80,0x6B84,0x6B83,0x6B8D,0x6B98,0x6B95,0x6B9E,0x6BA4,0x6BAA,0x6BAB,0x6BAF,0x6BB2,0x6BB1,0x6BB3,0x6BB7,0x6BBC,0x6BC6,0x6BCB,0x6BD3,0x6BDF,0x6BEC,0x6BEB,0x6BF3,0x6BEF,0x9EBE,0x6C08,0x6C13,0x6C14,0x6C1B,0x6C24,0x6C23,0x6C5E,0x6C55,0x6C62,0x6C6A,0x6C82,0x6C8D,0x6C9A,0x6C81,0x6C9B,0x6C7E,0x6C68,0x6C73,0x6C92,0x6C90,0x6CC4,0x6CF1,0x6CD3,0x6CBD,0x6CD7,0x6CC5,0x6CDD,0x6CAE,0x6CB1,0x6CBE},
	decode_set1_DE[] = {0x6CBA,0x6CDB,0x6CEF,0x6CD9,0x6CEA,0x6D1F,0x884D,0x6D36,0x6D2B,0x6D3D,0x6D38,0x6D19,0x6D35,0x6D33,0x6D12,0x6D0C,0x6D63,0x6D93,0x6D64,0x6D5A,0x6D79,0x6D59,0x6D8E,0x6D95,0x6FE4,0x6D85,0x6DF9,0x6E15,0x6E0A,0x6DB5,0x6DC7,0x6DE6,0x6DB8,0x6DC6,0x6DEC,0x6DDE,0x6DCC,0x6DE8,0x6DD2,0x6DC5,0x6DFA,0x6DD9,0x6DE4,0x6DD5,0x6DEA,0x6DEE,0x6E2D,0x6E6E,0x6E2E,0x6E19,0x6E72,0x6E5F,0x6E3E,0x6E23,0x6E6B,0x6E2B,0x6E76,0x6E4D,0x6E1F,0x6E43,0x6E3A,0x6E4E,0x6E24,0x6EFF,0x6E1D,0x6E38,0x6E82,0x6EAA,0x6E98,0x6EC9,0x6EB7,0x6ED3,0x6EBD,0x6EAF,0x6EC4,0x6EB2,0x6ED4,0x6ED5,0x6E8F,0x6EA5,0x6EC2,0x6E9F,0x6F41,0x6F11,0x704C,0x6EEC,0x6EF8,0x6EFE,0x6F3F,0x6EF2,0x6F31,0x6EEF,0x6F32,0x6ECC},
	decode_set1_DF[] = {0x6F3E,0x6F13,0x6EF7,0x6F86,0x6F7A,0x6F78,0x6F81,0x6F80,0x6F6F,0x6F5B,0x6FF3,0x6F6D,0x6F82,0x6F7C,0x6F58,0x6F8E,0x6F91,0x6FC2,0x6F66,0x6FB3,0x6FA3,0x6FA1,0x6FA4,0x6FB9,0x6FC6,0x6FAA,0x6FDF,0x6FD5,0x6FEC,0x6FD4,0x6FD8,0x6FF1,0x6FEE,0x6FDB,0x7009,0x700B,0x6FFA,0x7011,0x7001,0x700F,0x6FFE,0x701B,0x701A,0x6F74,0x701D,0x7018,0x701F,0x7030,0x703E,0x7032,0x7051,0x7063,0x7099,0x7092,0x70AF,0x70F1,0x70AC,0x70B8,0x70B3,0x70AE,0x70DF,0x70CB,0x70DD,0x70D9,0x7109,0x70FD,0x711C,0x7119,0x7165,0x7155,0x7188,0x7166,0x7162,0x714C,0x7156,0x716C,0x718F,0x71FB,0x7184,0x7195,0x71A8,0x71AC,0x71D7,0x71B9,0x71BE,0x71D2,0x71C9,0x71D4,0x71CE,0x71E0,0x71EC,0x71E7,0x71F5,0x71FC},
	decode_set1_E0[] = {0x71F9,0x71FF,0x720D,0x7210,0x721B,0x7228,0x722D,0x722C,0x7230,0x7232,0x723B,0x723C,0x723F,0x7240,0x7246,0x724B,0x7258,0x7274,0x727E,0x7282,0x7281,0x7287,0x7292,0x7296,0x72A2,0x72A7,0x72B9,0x72B2,0x72C3,0x72C6,0x72C4,0x72CE,0x72D2,0x72E2,0x72E0,0x72E1,0x72F9,0x72F7,0x500F,0x7317,0x730A,0x731C,0x7316,0x731D,0x7334,0x732F,0x7329,0x7325,0x733E,0x734E,0x734F,0x9ED8,0x7357,0x736A,0x7368,0x7370,0x7378,0x7375,0x737B,0x737A,0x73C8,0x73B3,0x73CE,0x73BB,0x73C0,0x73E5,0x73EE,0x73DE,0x74A2,0x7405,0x746F,0x7425,0x73F8,0x7432,0x743A,0x7455,0x743F,0x745F,0x7459,0x7441,0x745C,0x7469,0x7470,0x7463,0x746A,0x7476,0x747E,0x748B,0x749E,0x74A7,0x74CA,0x74CF,0x74D4,0x73F1},
	decode_set1_E1[] = {0x74E0,0x74E3,0x74E7,0x74E9,0x74EE,0x74F2,0x74F0,0x74F1,0x74F8,0x74F7,0x7504,0x7503,0x7505,0x750C,0x750E,0x750D,0x7515,0x7513,0x751E,0x7526,0x752C,0x753C,0x7544,0x754D,0x754A,0x7549,0x755B,0x7546,0x755A,0x7569,0x7564,0x7567,0x756B,0x756D,0x7578,0x7576,0x7586,0x7587,0x7574,0x758A,0x7589,0x7582,0x7594,0x759A,0x759D,0x75A5,0x75A3,0x75C2,0x75B3,0x75C3,0x75B5,0x75BD,0x75B8,0x75BC,0x75B1,0x75CD,0x75CA,0x75D2,0x75D9,0x75E3,0x75DE,0x75FE,0x75FF,0x75FC,0x7601,0x75F0,0x75FA,0x75F2,0x75F3,0x760B,0x760D,0x7609,0x761F,0x7627,0x7620,0x7621,0x7622,0x7624,0x7634,0x7630,0x763B,0x7647,0x7648,0x7646,0x765C,0x7658,0x7661,0x7662,0x7668,0x7669,0x766A,0x7667,0x766C,0x7670},
	decode_set1_E2[] = {0x7672,0x7676,0x7678,0x767C,0x7680,0x7683,0x7688,0x768B,0x768E,0x7696,0x7693,0x7699,0x769A,0x76B0,0x76B4,0x76B8,0x76B9,0x76BA,0x76C2,0x76CD,0x76D6,0x76D2,0x76DE,0x76E1,0x76E5,0x76E7,0x76EA,0x862F,0x76FB,0x7708,0x7707,0x7704,0x7729,0x7724,0x771E,0x7725,0x7726,0x771B,0x7737,0x7738,0x7747,0x775A,0x7768,0x776B,0x775B,0x7765,0x777F,0x777E,0x7779,0x778E,0x778B,0x7791,0x77A0,0x779E,0x77B0,0x77B6,0x77B9,0x77BF,0x77BC,0x77BD,0x77BB,0x77C7,0x77CD,0x77D7,0x77DA,0x77DC,0x77E3,0x77EE,0x77FC,0x780C,0x7812,0x7926,0x7820,0x792A,0x7845,0x788E,0x7874,0x7886,0x787C,0x789A,0x788C,0x78A3,0x78B5,0x78AA,0x78AF,0x78D1,0x78C6,0x78CB,0x78D4,0x78BE,0x78BC,0x78C5,0x78CA,0x78EC},
	decode_set1_E3[] = {0x78E7,0x78DA,0x78FD,0x78F4,0x7907,0x7912,0x7911,0x7919,0x792C,0x792B,0x7940,0x7960,0x7957,0x795F,0x795A,0x7955,0x7953,0x797A,0x797F,0x798A,0x799D,0x79A7,0x9F4B,0x79AA,0x79AE,0x79B3,0x79B9,0x79BA,0x79C9,0x79D5,0x79E7,0x79EC,0x79E1,0x79E3,0x7A08,0x7A0D,0x7A18,0x7A19,0x7A20,0x7A1F,0x7980,0x7A31,0x7A3B,0x7A3E,0x7A37,0x7A43,0x7A57,0x7A49,0x7A61,0x7A62,0x7A69,0x9F9D,0x7A70,0x7A79,0x7A7D,0x7A88,0x7A97,0x7A95,0x7A98,0x7A96,0x7AA9,0x7AC8,0x7AB0,0x7AB6,0x7AC5,0x7AC4,0x7ABF,0x9083,0x7AC7,0x7ACA,0x7ACD,0x7ACF,0x7AD5,0x7AD3,0x7AD9,0x7ADA,0x7ADD,0x7AE1,0x7AE2,0x7AE6,0x7AED,0x7AF0,0x7B02,0x7B0F,0x7B0A,0x7B06,0x7B33,0x7B18,0x7B19,0x7B1E,0x7B35,0x7B28,0x7B36,0x7B50},
	decode_set1_E4[] = {0x7B7A,0x7B04,0x7B4D,0x7B0B,0x7B4C,0x7B45,0x7B75,0x7B65,0x7B74,0x7B67,0x7B70,0x7B71,0x7B6C,0x7B6E,0x7B9D,0x7B98,0x7B9F,0x7B8D,0x7B9C,0x7B9A,0x7B8B,0x7B92,0x7B8F,0x7B5D,0x7B99,0x7BCB,0x7BC1,0x7BCC,0x7BCF,0x7BB4,0x7BC6,0x7BDD,0x7BE9,0x7C11,0x7C14,0x7BE6,0x7BE5,0x7C60,0x7C00,0x7C07,0x7C13,0x7BF3,0x7BF7,0x7C17,0x7C0D,0x7BF6,0x7C23,0x7C27,0x7C2A,0x7C1F,0x7C37,0x7C2B,0x7C3D,0x7C4C,0x7C43,0x7C54,0x7C4F,0x7C40,0x7C50,0x7C58,0x7C5F,0x7C64,0x7C56,0x7C65,0x7C6C,0x7C75,0x7C83,0x7C90,0x7CA4,0x7CAD,0x7CA2,0x7CAB,0x7CA1,0x7CA8,0x7CB3,0x7CB2,0x7CB1,0x7CAE,0x7CB9,0x7CBD,0x7CC0,0x7CC5,0x7CC2,0x7CD8,0x7CD2,0x7CDC,0x7CE2,0x9B3B,0x7CEF,0x7CF2,0x7CF4,0x7CF6,0x7CFA,0x7D06},
	decode_set1_E5[] = {0x7D02,0x7D1C,0x7D15,0x7D0A,0x7D45,0x7D4B,0x7D2E,0x7D32,0x7D3F,0x7D35,0x7D46,0x7D73,0x7D56,0x7D4E,0x7D72,0x7D68,0x7D6E,0x7D4F,0x7D63,0x7D93,0x7D89,0x7D5B,0x7D8F,0x7D7D,0x7D9B,0x7DBA,0x7DAE,0x7DA3,0x7DB5,0x7DC7,0x7DBD,0x7DAB,0x7E3D,0x7DA2,0x7DAF,0x7DDC,0x7DB8,0x7D9F,0x7DB0,0x7DD8,0x7DDD,0x7DE4,0x7DDE,0x7DFB,0x7DF2,0x7DE1,0x7E05,0x7E0A,0x7E23,0x7E21,0x7E12,0x7E31,0x7E1F,0x7E09,0x7E0B,0x7E22,0x7E46,0x7E66,0x7E3B,0x7E35,0x7E39,0x7E43,0x7E37,0x7E32,0x7E3A,0x7E67,0x7E5D,0x7E56,0x7E5E,0x7E59,0x7E5A,0x7E79,0x7E6A,0x7E69,0x7E7C,0x7E7B,0x7E83,0x7DD5,0x7E7D,0x8FAE,0x7E7F,0x7E88,0x7E89,0x7E8C,0x7E92,0x7E90,0x7E93,0x7E94,0x7E96,0x7E8E,0x7E9B,0x7E9C,0x7F38,0x7F3A},
	decode_set1_E6[] = {0x7F45,0x7F4C,0x7F4D,0x7F4E,0x7F50,0x7F51,0x7F55,0x7F54,0x7F58,0x7F5F,0x7F60,0x7F68,0x7F69,0x7F67,0x7F78,0x7F82,0x7F86,0x7F83,0x7F88,0x7F87,0x7F8C,0x7F94,0x7F9E,0x7F9D,0x7F9A,0x7FA3,0x7FAF,0x7FB2,0x7FB9,0x7FAE,0x7FB6,0x7FB8,0x8B71,0x7FC5,0x7FC6,0x7FCA,0x7FD5,0x7FD4,0x7FE1,0x7FE6,0x7FE9,0x7FF3,0x7FF9,0x98DC,0x8006,0x8004,0x800B,0x8012,0x8018,0x8019,0x801C,0x8021,0x8028,0x803F,0x803B,0x804A,0x8046,0x8052,0x8058,0x805A,0x805F,0x8062,0x8068,0x8073,0x8072,0x8070,0x8076,0x8079,0x807D,0x807F,0x8084,0x8086,0x8085,0x809B,0x8093,0x809A,0x80AD,0x5190,0x80AC,0x80DB,0x80E5,0x80D9,0x80DD,0x80C4,0x80DA,0x80D6,0x8109,0x80EF,0x80F1,0x811B,0x8129,0x8123,0x812F,0x814B},
	decode_set1_E7[] = {0x968B,0x8146,0x813E,0x8153,0x8151,0x80FC,0x8171,0x816E,0x8165,0x8166,0x8174,0x8183,0x8188,0x818A,0x8180,0x8182,0x81A0,0x8195,0x81A4,0x81A3,0x815F,0x8193,0x81A9,0x81B0,0x81B5,0x81BE,0x81B8,0x81BD,0x81C0,0x81C2,0x81BA,0x81C9,0x81CD,0x81D1,0x81D9,0x81D8,0x81C8,0x81DA,0x81DF,0x81E0,0x81E7,0x81FA,0x81FB,0x81FE,0x8201,0x8202,0x8205,0x8207,0x820A,0x820D,0x8210,0x8216,0x8229,0x822B,0x8238,0x8233,0x8240,0x8259,0x8258,0x825D,0x825A,0x825F,0x8264,0x8262,0x8268,0x826A,0x826B,0x822E,0x8271,0x8277,0x8278,0x827E,0x828D,0x8292,0x82AB,0x829F,0x82BB,0x82AC,0x82E1,0x82E3,0x82DF,0x82D2,0x82F4,0x82F3,0x82FA,0x8393,0x8303,0x82FB,0x82F9,0x82DE,0x8306,0x82DC,0x8309,0x82D9},
	decode_set1_E8[] = {0x8335,0x8334,0x8316,0x8332,0x8331,0x8340,0x8339,0x8350,0x8345,0x832F,0x832B,0x8317,0x8318,0x8385,0x839A,0x83AA,0x839F,0x83A2,0x8396,0x8323,0x838E,0x8387,0x838A,0x837C,0x83B5,0x8373,0x8375,0x83A0,0x8389,0x83A8,0x83F4,0x8413,0x83EB,0x83CE,0x83FD,0x8403,0x83D8,0x840B,0x83C1,0x83F7,0x8407,0x83E0,0x83F2,0x840D,0x8422,0x8420,0x83BD,0x8438,0x8506,0x83FB,0x846D,0x842A,0x843C,0x855A,0x8484,0x8477,0x846B,0x84AD,0x846E,0x8482,0x8469,0x8446,0x842C,0x846F,0x8479,0x8435,0x84CA,0x8462,0x84B9,0x84BF,0x849F,0x84D9,0x84CD,0x84BB,0x84DA,0x84D0,0x84C1,0x84C6,0x84D6,0x84A1,0x8521,0x84FF,0x84F4,0x8517,0x8518,0x852C,0x851F,0x8515,0x8514,0x84FC,0x8540,0x8563,0x8558,0x8548},
	decode_set1_E9[] = {0x8541,0x8602,0x854B,0x8555,0x8580,0x85A4,0x8588,0x8591,0x858A,0x85A8,0x856D,0x8594,0x859B,0x85EA,0x8587,0x859C,0x8577,0x857E,0x8590,0x85C9,0x85BA,0x85CF,0x85B9,0x85D0,0x85D5,0x85DD,0x85E5,0x85DC,0x85F9,0x860A,0x8613,0x860B,0x85FE,0x85FA,0x8606,0x8622,0x861A,0x8630,0x863F,0x864D,0x4E55,0x8654,0x865F,0x8667,0x8671,0x8693,0x86A3,0x86A9,0x86AA,0x868B,0x868C,0x86B6,0x86AF,0x86C4,0x86C6,0x86B0,0x86C9,0x8823,0x86AB,0x86D4,0x86DE,0x86E9,0x86EC,0x86DF,0x86DB,0x86EF,0x8712,0x8706,0x8708,0x8700,0x8703,0x86FB,0x8711,0x8709,0x870D,0x86F9,0x870A,0x8734,0x873F,0x8737,0x873B,0x8725,0x8729,0x871A,0x8760,0x875F,0x8778,0x874C,0x874E,0x8774,0x8757,0x8768,0x876E,0x8759},
	decode_set1_EA[] = {0x8753,0x8763,0x876A,0x8805,0x87A2,0x879F,0x8782,0x87AF,0x87CB,0x87BD,0x87C0,0x87D0,0x96D6,0x87AB,0x87C4,0x87B3,0x87C7,0x87C6,0x87BB,0x87EF,0x87F2,0x87E0,0x880F,0x880D,0x87FE,0x87F6,0x87F7,0x880E,0x87D2,0x8811,0x8816,0x8815,0x8822,0x8821,0x8831,0x8836,0x8839,0x8827,0x883B,0x8844,0x8842,0x8852,0x8859,0x885E,0x8862,0x886B,0x8881,0x887E,0x889E,0x8875,0x887D,0x88B5,0x8872,0x8882,0x8897,0x8892,0x88AE,0x8899,0x88A2,0x888D,0x88A4,0x88B0,0x88BF,0x88B1,0x88C3,0x88C4,0x88D4,0x88D8,0x88D9,0x88DD,0x88F9,0x8902,0x88FC,0x88F4,0x88E8,0x88F2,0x8904,0x890C,0x890A,0x8913,0x8943,0x891E,0x8925,0x892A,0x892B,0x8941,0x8944,0x893B,0x8936,0x8938,0x894C,0x891D,0x8960,0x895E},
	decode_set1_EB[] = {0x8966,0x8964,0x896D,0x896A,0x896F,0x8974,0x8977,0x897E,0x8983,0x8988,0x898A,0x8993,0x8998,0x89A1,0x89A9,0x89A6,0x89AC,0x89AF,0x89B2,0x89BA,0x89BD,0x89BF,0x89C0,0x89DA,0x89DC,0x89DD,0x89E7,0x89F4,0x89F8,0x8A03,0x8A16,0x8A10,0x8A0C,0x8A1B,0x8A1D,0x8A25,0x8A36,0x8A41,0x8A5B,0x8A52,0x8A46,0x8A48,0x8A7C,0x8A6D,0x8A6C,0x8A62,0x8A85,0x8A82,0x8A84,0x8AA8,0x8AA1,0x8A91,0x8AA5,0x8AA6,0x8A9A,0x8AA3,0x8AC4,0x8ACD,0x8AC2,0x8ADA,0x8AEB,0x8AF3,0x8AE7,0x8AE4,0x8AF1,0x8B14,0x8AE0,0x8AE2,0x8AF7,0x8ADE,0x8ADB,0x8B0C,0x8B07,0x8B1A,0x8AE1,0x8B16,0x8B10,0x8B17,0x8B20,0x8B33,0x97AB,0x8B26,0x8B2B,0x8B3E,0x8B28,0x8B41,0x8B4C,0x8B4F,0x8B4E,0x8B49,0x8B56,0x8B5B,0x8B5A,0x8B6B},
	decode_set1_EC[] = {0x8B5F,0x8B6C,0x8B6F,0x8B74,0x8B7D,0x8B80,0x8B8C,0x8B8E,0x8B92,0x8B93,0x8B96,0x8B99,0x8B9A,0x8C3A,0x8C41,0x8C3F,0x8C48,0x8C4C,0x8C4E,0x8C50,0x8C55,0x8C62,0x8C6C,0x8C78,0x8C7A,0x8C82,0x8C89,0x8C85,0x8C8A,0x8C8D,0x8C8E,0x8C94,0x8C7C,0x8C98,0x621D,0x8CAD,0x8CAA,0x8CBD,0x8CB2,0x8CB3,0x8CAE,0x8CB6,0x8CC8,0x8CC1,0x8CE4,0x8CE3,0x8CDA,0x8CFD,0x8CFA,0x8CFB,0x8D04,0x8D05,0x8D0A,0x8D07,0x8D0F,0x8D0D,0x8D10,0x9F4E,0x8D13,0x8CCD,0x8D14,0x8D16,0x8D67,0x8D6D,0x8D71,0x8D73,0x8D81,0x8D99,0x8DC2,0x8DBE,0x8DBA,0x8DCF,0x8DDA,0x8DD6,0x8DCC,0x8DDB,0x8DCB,0x8DEA,0x8DEB,0x8DDF,0x8DE3,0x8DFC,0x8E08,0x8E09,0x8DFF,0x8E1D,0x8E1E,0x8E10,0x8E1F,0x8E42,0x8E35,0x8E30,0x8E34,0x8E4A},
	decode_set1_ED[] = {0x8E47,0x8E49,0x8E4C,0x8E50,0x8E48,0x8E59,0x8E64,0x8E60,0x8E2A,0x8E63,0x8E55,0x8E76,0x8E72,0x8E7C,0x8E81,0x8E87,0x8E85,0x8E84,0x8E8B,0x8E8A,0x8E93,0x8E91,0x8E94,0x8E99,0x8EAA,0x8EA1,0x8EAC,0x8EB0,0x8EC6,0x8EB1,0x8EBE,0x8EC5,0x8EC8,0x8ECB,0x8EDB,0x8EE3,0x8EFC,0x8EFB,0x8EEB,0x8EFE,0x8F0A,0x8F05,0x8F15,0x8F12,0x8F19,0x8F13,0x8F1C,0x8F1F,0x8F1B,0x8F0C,0x8F26,0x8F33,0x8F3B,0x8F39,0x8F45,0x8F42,0x8F3E,0x8F4C,0x8F49,0x8F46,0x8F4E,0x8F57,0x8F5C,0x8F62,0x8F63,0x8F64,0x8F9C,0x8F9F,0x8FA3,0x8FAD,0x8FAF,0x8FB7,0x8FDA,0x8FE5,0x8FE2,0x8FEA,0x8FEF,0x9087,0x8FF4,0x9005,0x8FF9,0x8FFA,0x9011,0x9015,0x9021,0x900D,0x901E,0x9016,0x900B,0x9027,0x9036,0x9035,0x9039,0x8FF8},
	decode_set1_EE[] = {0x904F,0x9050,0x9051,0x9052,0x900E,0x9049,0x903E,0x9056,0x9058,0x905E,0x9068,0x906F,0x9076,0x96A8,0x9072,0x9082,0x907D,0x9081,0x9080,0x908A,0x9089,0x908F,0x90A8,0x90AF,0x90B1,0x90B5,0x90E2,0x90E4,0x6248,0x90DB,0x9102,0x9112,0x9119,0x9132,0x9130,0x914A,0x9156,0x9158,0x9163,0x9165,0x9169,0x9173,0x9172,0x918B,0x9189,0x9182,0x91A2,0x91AB,0x91AF,0x91AA,0x91B5,0x91B4,0x91BA,0x91C0,0x91C1,0x91C9,0x91CB,0x91D0,0x91D6,0x91DF,0x91E1,0x91DB,0x91FC,0x91F5,0x91F6,0x921E,0x91FF,0x9214,0x922C,0x9215,0x9211,0x925E,0x9257,0x9245,0x9249,0x9264,0x9248,0x9295,0x923F,0x924B,0x9250,0x929C,0x9296,0x9293,0x929B,0x925A,0x92CF,0x92B9,0x92B7,0x92E9,0x930F,0x92FA,0x9344,0x932E},
	decode_set1_EF[] = {0x9319,0x9322,0x931A,0x9323,0x933A,0x9335,0x933B,0x935C,0x9360,0x937C,0x936E,0x9356,0x93B0,0x93AC,0x93AD,0x9394,0x93B9,0x93D6,0x93D7,0x93E8,0x93E5,0x93D8,0x93C3,0x93DD,0x93D0,0x93C8,0x93E4,0x941A,0x9414,0x9413,0x9403,0x9407,0x9410,0x9436,0x942B,0x9435,0x9421,0x943A,0x9441,0x9452,0x9444,0x945B,0x9460,0x9462,0x945E,0x946A,0x9229,0x9470,0x9475,0x9477,0x947D,0x945A,0x947C,0x947E,0x9481,0x947F,0x9582,0x9587,0x958A,0x9594,0x9596,0x9598,0x9599,0x95A0,0x95A8,0x95A7,0x95AD,0x95BC,0x95BB,0x95B9,0x95BE,0x95CA,0x6FF6,0x95C3,0x95CD,0x95CC,0x95D5,0x95D4,0x95D6,0x95DC,0x95E1,0x95E5,0x95E2,0x9621,0x9628,0x962E,0x962F,0x9642,0x964C,0x964F,0x964B,0x9677,0x965C,0x965E},
	decode_set1_F0[] = {0x965D,0x965F,0x9666,0x9672,0x966C,0x968D,0x9698,0x9695,0x9697,0x96AA,0x96A7,0x96B1,0x96B2,0x96B0,0x96B4,0x96B6,0x96B8,0x96B9,0x96CE,0x96CB,0x96C9,0x96CD,0x894D,0x96DC,0x970D,0x96D5,0x96F9,0x9704,0x9706,0x9708,0x9713,0x970E,0x9711,0x970F,0x9716,0x9719,0x9724,0x972A,0x9730,0x9739,0x973D,0x973E,0x9744,0x9746,0x9748,0x9742,0x9749,0x975C,0x9760,0x9764,0x9766,0x9768,0x52D2,0x976B,0x9771,0x9779,0x9785,0x977C,0x9781,0x977A,0x9786,0x978B,0x978F,0x9790,0x979C,0x97A8,0x97A6,0x97A3,0x97B3,0x97B4,0x97C3,0x97C6,0x97C8,0x97CB,0x97DC,0x97ED,0x9F4F,0x97F2,0x7ADF,0x97F6,0x97F5,0x980F,0x980C,0x9838,0x9824,0x9821,0x9837,0x983D,0x9846,0x984F,0x984B,0x986B,0x986F,0x9870},
	decode_set1_F1[] = {0x9871,0x9874,0x9873,0x98AA,0x98AF,0x98B1,0x98B6,0x98C4,0x98C3,0x98C6,0x98E9,0x98EB,0x9903,0x9909,0x9912,0x9914,0x9918,0x9921,0x991D,0x991E,0x9924,0x9920,0x992C,0x992E,0x993D,0x993E,0x9942,0x9949,0x9945,0x9950,0x994B,0x9951,0x9952,0x994C,0x9955,0x9997,0x9998,0x99A5,0x99AD,0x99AE,0x99BC,0x99DF,0x99DB,0x99DD,0x99D8,0x99D1,0x99ED,0x99EE,0x99F1,0x99F2,0x99FB,0x99F8,0x9A01,0x9A0F,0x9A05,0x99E2,0x9A19,0x9A2B,0x9A37,0x9A45,0x9A42,0x9A40,0x9A43,0x9A3E,0x9A55,0x9A4D,0x9A5B,0x9A57,0x9A5F,0x9A62,0x9A65,0x9A64,0x9A69,0x9A6B,0x9A6A,0x9AAD,0x9AB0,0x9ABC,0x9AC0,0x9ACF,0x9AD1,0x9AD3,0x9AD4,0x9ADE,0x9ADF,0x9AE2,0x9AE3,0x9AE6,0x9AEF,0x9AEB,0x9AEE,0x9AF4,0x9AF1,0x9AF7},
	decode_set1_F2[] = {0x9AFB,0x9B06,0x9B18,0x9B1A,0x9B1F,0x9B22,0x9B23,0x9B25,0x9B27,0x9B28,0x9B29,0x9B2A,0x9B2E,0x9B2F,0x9B32,0x9B44,0x9B43,0x9B4F,0x9B4D,0x9B4E,0x9B51,0x9B58,0x9B74,0x9B93,0x9B83,0x9B91,0x9B96,0x9B97,0x9B9F,0x9BA0,0x9BA8,0x9BB4,0x9BC0,0x9BCA,0x9BB9,0x9BC6,0x9BCF,0x9BD1,0x9BD2,0x9BE3,0x9BE2,0x9BE4,0x9BD4,0x9BE1,0x9C3A,0x9BF2,0x9BF1,0x9BF0,0x9C15,0x9C14,0x9C09,0x9C13,0x9C0C,0x9C06,0x9C08,0x9C12,0x9C0A,0x9C04,0x9C2E,0x9C1B,0x9C25,0x9C24,0x9C21,0x9C30,0x9C47,0x9C32,0x9C46,0x9C3E,0x9C5A,0x9C60,0x9C67,0x9C76,0x9C78,0x9CE7,0x9CEC,0x9CF0,0x9D09,0x9D08,0x9CEB,0x9D03,0x9D06,0x9D2A,0x9D26,0x9DAF,0x9D23,0x9D1F,0x9D44,0x9D15,0x9D12,0x9D41,0x9D3F,0x9D3E,0x9D46,0x9D48},
	decode_set1_F3[] = {0x9D5D,0x9D5E,0x9D64,0x9D51,0x9D50,0x9D59,0x9D72,0x9D89,0x9D87,0x9DAB,0x9D6F,0x9D7A,0x9D9A,0x9DA4,0x9DA9,0x9DB2,0x9DC4,0x9DC1,0x9DBB,0x9DB8,0x9DBA,0x9DC6,0x9DCF,0x9DC2,0x9DD9,0x9DD3,0x9DF8,0x9DE6,0x9DED,0x9DEF,0x9DFD,0x9E1A,0x9E1B,0x9E1E,0x9E75,0x9E79,0x9E7D,0x9E81,0x9E88,0x9E8B,0x9E8C,0x9E92,0x9E95,0x9E91,0x9E9D,0x9EA5,0x9EA9,0x9EB8,0x9EAA,0x9EAD,0x9761,0x9ECC,0x9ECE,0x9ECF,0x9ED0,0x9ED4,0x9EDC,0x9EDE,0x9EDD,0x9EE0,0x9EE5,0x9EE8,0x9EEF,0x9EF4,0x9EF6,0x9EF7,0x9EF9,0x9EFB,0x9EFC,0x9EFD,0x9F07,0x9F08,0x76B7,0x9F15,0x9F21,0x9F2C,0x9F3E,0x9F4A,0x9F52,0x9F54,0x9F63,0x9F5F,0x9F60,0x9F61,0x9F66,0x9F67,0x9F6C,0x9F6A,0x9F77,0x9F72,0x9F76,0x9F95,0x9F9C,0x9FA0},
	decode_set1_F4[] = {0x582F,0x69C7,0x9059,0x7464,0x51DC,0x7199,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_F5[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_F6[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_F7[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_F8[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set1_F9[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0},
	decode_set1_FA[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0},
	decode_set1_FB[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0},
	decode_set1_FC[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0},
	decode_set1_FD[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0},
	decode_set1_FE[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD},
	*decode_set1[] = {decode_set1_A1,decode_set1_A2,decode_set1_A3,decode_set1_A4,decode_set1_A5,decode_set1_A6,decode_set1_A7,decode_set1_A8,decode_set1_A9,decode_set1_AA,decode_set1_AB,decode_set1_AC,decode_set1_AD,decode_set1_AE,decode_set1_AF,decode_set1_B0,decode_set1_B1,decode_set1_B2,decode_set1_B3,decode_set1_B4,decode_set1_B5,decode_set1_B6,decode_set1_B7,decode_set1_B8,decode_set1_B9,decode_set1_BA,decode_set1_BB,decode_set1_BC,decode_set1_BD,decode_set1_BE,decode_set1_BF,decode_set1_C0,decode_set1_C1,decode_set1_C2,decode_set1_C3,decode_set1_C4,decode_set1_C5,decode_set1_C6,decode_set1_C7,decode_set1_C8,decode_set1_C9,decode_set1_CA,decode_set1_CB,decode_set1_CC,decode_set1_CD,decode_set1_CE,decode_set1_CF,decode_set1_D0,decode_set1_D1,decode_set1_D2,decode_set1_D3,decode_set1_D4,decode_set1_D5,decode_set1_D6,decode_set1_D7,decode_set1_D8,decode_set1_D9,decode_set1_DA,decode_set1_DB,decode_set1_DC,decode_set1_DD,decode_set1_DE,decode_set1_DF,decode_set1_E0,decode_set1_E1,decode_set1_E2,decode_set1_E3,decode_set1_E4,decode_set1_E5,decode_set1_E6,decode_set1_E7,decode_set1_E8,decode_set1_E9,decode_set1_EA,decode_set1_EB,decode_set1_EC,decode_set1_ED,decode_set1_EE,decode_set1_EF,decode_set1_F0,decode_set1_F1,decode_set1_F2,decode_set1_F3,decode_set1_F4,decode_set1_F5,decode_set1_F6,decode_set1_F7,decode_set1_F8,decode_set1_F9,decode_set1_FA,decode_set1_FB,decode_set1_FC,decode_set1_FD,decode_set1_FE,},
	decode_set3_A1[] = {0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_A2[] = {0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2D8,0x2C7,0xB8,0x2D9,0x2DD,0xAF,0x2DB,0x2DA,0x7E,0x384,0x385,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xA1,0xA6,0xBF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xBA,0xAA,0xA9,0xAE,0x2122,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xA4,0x2116,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_A3[] = {0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_A4[] = {0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_A5[] = {0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_A6[] = {0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x386,0x388,0x389,0x38A,0x3AA,0x0,0x38C,0x0,0x38E,0x3AB,0x0,0x38F,0x0,0x0,0x0,0x0,0x3AC,0x3AD,0x3AE,0x3AF,0x3CA,0x390,0x3CC,0x3C2,0x3CD,0x3CB,0x3B0,0x3CE,0x0,0x0},
	decode_set3_A7[] = {0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x402,0x403,0x404,0x405,0x406,0x407,0x408,0x409,0x40A,0x40B,0x40C,0x40D,0x40E,0x40F,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x452,0x453,0x454,0x455,0x456,0x457,0x458,0x459,0x45A,0x45B,0x45C,0x45E,0x45F},
	decode_set3_A8[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_A9[] = {0xC6,0x110,0x0,0x126,0x0,0x132,0x0,0x141,0x13F,0x0,0x14A,0xD8,0x152,0x0,0x166,0xDE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xE6,0x111,0xF0,0x127,0x131,0x133,0x138,0x142,0x140,0x149,0x14B,0xF8,0x153,0xDF,0x167,0xFE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_AA[] = {0xC1,0xC0,0xC4,0xC2,0x102,0x1CD,0x100,0x104,0xC5,0xC3,0x106,0x108,0x10C,0xC7,0x10A,0x10E,0xC9,0xC8,0xCB,0xCA,0x11A,0x116,0x112,0x118,0x0,0x11C,0x11E,0x122,0x120,0x124,0xCD,0xCC,0xCF,0xCE,0x1CF,0x130,0x12A,0x12E,0x128,0x134,0x136,0x139,0x13D,0x13B,0x143,0x147,0x145,0xD1,0xD3,0xD2,0xD6,0xD4,0x1D1,0x150,0x14C,0xD5,0x154,0x158,0x156,0x15A,0x15C,0x160,0x15E,0x164,0x162,0xDA,0xD9,0xDC,0xDB,0x16C,0x1D3,0x170,0x16A,0x172,0x16E,0x168,0x1D7,0x1DB,0x1D9,0x1D5,0x174,0xDD,0x178,0x176,0x179,0x17D,0x17B,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_AB[] = {0xE1,0xE0,0xE4,0xE2,0x103,0x1CE,0x101,0x105,0xE5,0xE3,0x107,0x109,0x10D,0xE7,0x10B,0x10F,0xE9,0xE8,0xEB,0xEA,0x11B,0x117,0x113,0x119,0x1F5,0x11D,0x11F,0x0,0x121,0x125,0xED,0xEC,0xEF,0xEE,0x1D0,0x0,0x12B,0x12F,0x129,0x135,0x137,0x13A,0x13E,0x13C,0x144,0x148,0x146,0xF1,0xF3,0xF2,0xF6,0xF4,0x1D2,0x151,0x14D,0xF5,0x155,0x159,0x157,0x15B,0x15D,0x161,0x15F,0x165,0x163,0xFA,0xF9,0xFC,0xFB,0x16D,0x1D4,0x171,0x16B,0x173,0x16F,0x169,0x1D8,0x1DC,0x1DA,0x1D6,0x175,0xFD,0xFF,0x177,0x17A,0x17E,0x17C,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_AC[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_AD[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_AE[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_AF[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_B0[] = {0x4E02,0x4E04,0x4E05,0x4E0C,0x4E12,0x4E1F,0x4E23,0x4E24,0x4E28,0x4E2B,0x4E2E,0x4E2F,0x4E30,0x4E35,0x4E40,0x4E41,0x4E44,0x4E47,0x4E51,0x4E5A,0x4E5C,0x4E63,0x4E68,0x4E69,0x4E74,0x4E75,0x4E79,0x4E7F,0x4E8D,0x4E96,0x4E97,0x4E9D,0x4EAF,0x4EB9,0x4EC3,0x4ED0,0x4EDA,0x4EDB,0x4EE0,0x4EE1,0x4EE2,0x4EE8,0x4EEF,0x4EF1,0x4EF3,0x4EF5,0x4EFD,0x4EFE,0x4EFF,0x4F00,0x4F02,0x4F03,0x4F08,0x4F0B,0x4F0C,0x4F12,0x4F15,0x4F16,0x4F17,0x4F19,0x4F2E,0x4F31,0x4F60,0x4F33,0x4F35,0x4F37,0x4F39,0x4F3B,0x4F3E,0x4F40,0x4F42,0x4F48,0x4F49,0x4F4B,0x4F4C,0x4F52,0x4F54,0x4F56,0x4F58,0x4F5F,0x4F63,0x4F6A,0x4F6C,0x4F6E,0x4F71,0x4F77,0x4F78,0x4F79,0x4F7A,0x4F7D,0x4F7E,0x4F81,0x4F82,0x4F84},
	decode_set3_B1[] = {0x4F85,0x4F89,0x4F8A,0x4F8C,0x4F8E,0x4F90,0x4F92,0x4F93,0x4F94,0x4F97,0x4F99,0x4F9A,0x4F9E,0x4F9F,0x4FB2,0x4FB7,0x4FB9,0x4FBB,0x4FBC,0x4FBD,0x4FBE,0x4FC0,0x4FC1,0x4FC5,0x4FC6,0x4FC8,0x4FC9,0x4FCB,0x4FCC,0x4FCD,0x4FCF,0x4FD2,0x4FDC,0x4FE0,0x4FE2,0x4FF0,0x4FF2,0x4FFC,0x4FFD,0x4FFF,0x5000,0x5001,0x5004,0x5007,0x500A,0x500C,0x500E,0x5010,0x5013,0x5017,0x5018,0x501B,0x501C,0x501D,0x501E,0x5022,0x5027,0x502E,0x5030,0x5032,0x5033,0x5035,0x5040,0x5041,0x5042,0x5045,0x5046,0x504A,0x504C,0x504E,0x5051,0x5052,0x5053,0x5057,0x5059,0x505F,0x5060,0x5062,0x5063,0x5066,0x5067,0x506A,0x506D,0x5070,0x5071,0x503B,0x5081,0x5083,0x5084,0x5086,0x508A,0x508E,0x508F,0x5090},
	decode_set3_B2[] = {0x5092,0x5093,0x5094,0x5096,0x509B,0x509C,0x509E,0x509F,0x50A0,0x50A1,0x50A2,0x50AA,0x50AF,0x50B0,0x50B9,0x50BA,0x50BD,0x50C0,0x50C3,0x50C4,0x50C7,0x50CC,0x50CE,0x50D0,0x50D3,0x50D4,0x50D8,0x50DC,0x50DD,0x50DF,0x50E2,0x50E4,0x50E6,0x50E8,0x50E9,0x50EF,0x50F1,0x50F6,0x50FA,0x50FE,0x5103,0x5106,0x5107,0x5108,0x510B,0x510C,0x510D,0x510E,0x50F2,0x5110,0x5117,0x5119,0x511B,0x511C,0x511D,0x511E,0x5123,0x5127,0x5128,0x512C,0x512D,0x512F,0x5131,0x5133,0x5134,0x5135,0x5138,0x5139,0x5142,0x514A,0x514F,0x5153,0x5155,0x5157,0x5158,0x515F,0x5164,0x5166,0x517E,0x5183,0x5184,0x518B,0x518E,0x5198,0x519D,0x51A1,0x51A3,0x51AD,0x51B8,0x51BA,0x51BC,0x51BE,0x51BF,0x51C2},
	decode_set3_B3[] = {0x51C8,0x51CF,0x51D1,0x51D2,0x51D3,0x51D5,0x51D8,0x51DE,0x51E2,0x51E5,0x51EE,0x51F2,0x51F3,0x51F4,0x51F7,0x5201,0x5202,0x5205,0x5212,0x5213,0x5215,0x5216,0x5218,0x5222,0x5228,0x5231,0x5232,0x5235,0x523C,0x5245,0x5249,0x5255,0x5257,0x5258,0x525A,0x525C,0x525F,0x5260,0x5261,0x5266,0x526E,0x5277,0x5278,0x5279,0x5280,0x5282,0x5285,0x528A,0x528C,0x5293,0x5295,0x5296,0x5297,0x5298,0x529A,0x529C,0x52A4,0x52A5,0x52A6,0x52A7,0x52AF,0x52B0,0x52B6,0x52B7,0x52B8,0x52BA,0x52BB,0x52BD,0x52C0,0x52C4,0x52C6,0x52C8,0x52CC,0x52CF,0x52D1,0x52D4,0x52D6,0x52DB,0x52DC,0x52E1,0x52E5,0x52E8,0x52E9,0x52EA,0x52EC,0x52F0,0x52F1,0x52F4,0x52F6,0x52F7,0x5300,0x5303,0x530A,0x530B},
	decode_set3_B4[] = {0x530C,0x5311,0x5313,0x5318,0x531B,0x531C,0x531E,0x531F,0x5325,0x5327,0x5328,0x5329,0x532B,0x532C,0x532D,0x5330,0x5332,0x5335,0x533C,0x533D,0x533E,0x5342,0x534C,0x534B,0x5359,0x535B,0x5361,0x5363,0x5365,0x536C,0x536D,0x5372,0x5379,0x537E,0x5383,0x5387,0x5388,0x538E,0x5393,0x5394,0x5399,0x539D,0x53A1,0x53A4,0x53AA,0x53AB,0x53AF,0x53B2,0x53B4,0x53B5,0x53B7,0x53B8,0x53BA,0x53BD,0x53C0,0x53C5,0x53CF,0x53D2,0x53D3,0x53D5,0x53DA,0x53DD,0x53DE,0x53E0,0x53E6,0x53E7,0x53F5,0x5402,0x5413,0x541A,0x5421,0x5427,0x5428,0x542A,0x542F,0x5431,0x5434,0x5435,0x5443,0x5444,0x5447,0x544D,0x544F,0x545E,0x5462,0x5464,0x5466,0x5467,0x5469,0x546B,0x546D,0x546E,0x5474,0x547F},
	decode_set3_B5[] = {0x5481,0x5483,0x5485,0x5488,0x5489,0x548D,0x5491,0x5495,0x5496,0x549C,0x549F,0x54A1,0x54A6,0x54A7,0x54A9,0x54AA,0x54AD,0x54AE,0x54B1,0x54B7,0x54B9,0x54BA,0x54BB,0x54BF,0x54C6,0x54CA,0x54CD,0x54CE,0x54E0,0x54EA,0x54EC,0x54EF,0x54F6,0x54FC,0x54FE,0x54FF,0x5500,0x5501,0x5505,0x5508,0x5509,0x550C,0x550D,0x550E,0x5515,0x552A,0x552B,0x5532,0x5535,0x5536,0x553B,0x553C,0x553D,0x5541,0x5547,0x5549,0x554A,0x554D,0x5550,0x5551,0x5558,0x555A,0x555B,0x555E,0x5560,0x5561,0x5564,0x5566,0x557F,0x5581,0x5582,0x5586,0x5588,0x558E,0x558F,0x5591,0x5592,0x5593,0x5594,0x5597,0x55A3,0x55A4,0x55AD,0x55B2,0x55BF,0x55C1,0x55C3,0x55C6,0x55C9,0x55CB,0x55CC,0x55CE,0x55D1,0x55D2},
	decode_set3_B6[] = {0x55D3,0x55D7,0x55D8,0x55DB,0x55DE,0x55E2,0x55E9,0x55F6,0x55FF,0x5605,0x5608,0x560A,0x560D,0x560E,0x560F,0x5610,0x5611,0x5612,0x5619,0x562C,0x5630,0x5633,0x5635,0x5637,0x5639,0x563B,0x563C,0x563D,0x563F,0x5640,0x5641,0x5643,0x5644,0x5646,0x5649,0x564B,0x564D,0x564F,0x5654,0x565E,0x5660,0x5661,0x5662,0x5663,0x5666,0x5669,0x566D,0x566F,0x5671,0x5672,0x5675,0x5684,0x5685,0x5688,0x568B,0x568C,0x5695,0x5699,0x569A,0x569D,0x569E,0x569F,0x56A6,0x56A7,0x56A8,0x56A9,0x56AB,0x56AC,0x56AD,0x56B1,0x56B3,0x56B7,0x56BE,0x56C5,0x56C9,0x56CA,0x56CB,0x56CF,0x56D0,0x56CC,0x56CD,0x56D9,0x56DC,0x56DD,0x56DF,0x56E1,0x56E4,0x56E5,0x56E6,0x56E7,0x56E8,0x56F1,0x56EB,0x56ED},
	decode_set3_B7[] = {0x56F6,0x56F7,0x5701,0x5702,0x5707,0x570A,0x570C,0x5711,0x5715,0x571A,0x571B,0x571D,0x5720,0x5722,0x5723,0x5724,0x5725,0x5729,0x572A,0x572C,0x572E,0x572F,0x5733,0x5734,0x573D,0x573E,0x573F,0x5745,0x5746,0x574C,0x574D,0x5752,0x5762,0x5765,0x5767,0x5768,0x576B,0x576D,0x576E,0x576F,0x5770,0x5771,0x5773,0x5774,0x5775,0x5777,0x5779,0x577A,0x577B,0x577C,0x577E,0x5781,0x5783,0x578C,0x5794,0x5797,0x5799,0x579A,0x579C,0x579D,0x579E,0x579F,0x57A1,0x5795,0x57A7,0x57A8,0x57A9,0x57AC,0x57B8,0x57BD,0x57C7,0x57C8,0x57CC,0x57CF,0x57D5,0x57DD,0x57DE,0x57E4,0x57E6,0x57E7,0x57E9,0x57ED,0x57F0,0x57F5,0x57F6,0x57F8,0x57FD,0x57FE,0x57FF,0x5803,0x5804,0x5808,0x5809,0x57E1},
	decode_set3_B8[] = {0x580C,0x580D,0x581B,0x581E,0x581F,0x5820,0x5826,0x5827,0x582D,0x5832,0x5839,0x583F,0x5849,0x584C,0x584D,0x584F,0x5850,0x5855,0x585F,0x5861,0x5864,0x5867,0x5868,0x5878,0x587C,0x587F,0x5880,0x5881,0x5887,0x5888,0x5889,0x588A,0x588C,0x588D,0x588F,0x5890,0x5894,0x5896,0x589D,0x58A0,0x58A1,0x58A2,0x58A6,0x58A9,0x58B1,0x58B2,0x58C4,0x58BC,0x58C2,0x58C8,0x58CD,0x58CE,0x58D0,0x58D2,0x58D4,0x58D6,0x58DA,0x58DD,0x58E1,0x58E2,0x58E9,0x58F3,0x5905,0x5906,0x590B,0x590C,0x5912,0x5913,0x5914,0x8641,0x591D,0x5921,0x5923,0x5924,0x5928,0x592F,0x5930,0x5933,0x5935,0x5936,0x593F,0x5943,0x5946,0x5952,0x5953,0x5959,0x595B,0x595D,0x595E,0x595F,0x5961,0x5963,0x596B,0x596D},
	decode_set3_B9[] = {0x596F,0x5972,0x5975,0x5976,0x5979,0x597B,0x597C,0x598B,0x598C,0x598E,0x5992,0x5995,0x5997,0x599F,0x59A4,0x59A7,0x59AD,0x59AE,0x59AF,0x59B0,0x59B3,0x59B7,0x59BA,0x59BC,0x59C1,0x59C3,0x59C4,0x59C8,0x59CA,0x59CD,0x59D2,0x59DD,0x59DE,0x59DF,0x59E3,0x59E4,0x59E7,0x59EE,0x59EF,0x59F1,0x59F2,0x59F4,0x59F7,0x5A00,0x5A04,0x5A0C,0x5A0D,0x5A0E,0x5A12,0x5A13,0x5A1E,0x5A23,0x5A24,0x5A27,0x5A28,0x5A2A,0x5A2D,0x5A30,0x5A44,0x5A45,0x5A47,0x5A48,0x5A4C,0x5A50,0x5A55,0x5A5E,0x5A63,0x5A65,0x5A67,0x5A6D,0x5A77,0x5A7A,0x5A7B,0x5A7E,0x5A8B,0x5A90,0x5A93,0x5A96,0x5A99,0x5A9C,0x5A9E,0x5A9F,0x5AA0,0x5AA2,0x5AA7,0x5AAC,0x5AB1,0x5AB2,0x5AB3,0x5AB5,0x5AB8,0x5ABA,0x5ABB,0x5ABF},
	decode_set3_BA[] = {0x5AC4,0x5AC6,0x5AC8,0x5ACF,0x5ADA,0x5ADC,0x5AE0,0x5AE5,0x5AEA,0x5AEE,0x5AF5,0x5AF6,0x5AFD,0x5B00,0x5B01,0x5B08,0x5B17,0x5B34,0x5B19,0x5B1B,0x5B1D,0x5B21,0x5B25,0x5B2D,0x5B38,0x5B41,0x5B4B,0x5B4C,0x5B52,0x5B56,0x5B5E,0x5B68,0x5B6E,0x5B6F,0x5B7C,0x5B7D,0x5B7E,0x5B7F,0x5B81,0x5B84,0x5B86,0x5B8A,0x5B8E,0x5B90,0x5B91,0x5B93,0x5B94,0x5B96,0x5BA8,0x5BA9,0x5BAC,0x5BAD,0x5BAF,0x5BB1,0x5BB2,0x5BB7,0x5BBA,0x5BBC,0x5BC0,0x5BC1,0x5BCD,0x5BCF,0x5BD6,0x5BD7,0x5BD8,0x5BD9,0x5BDA,0x5BE0,0x5BEF,0x5BF1,0x5BF4,0x5BFD,0x5C0C,0x5C17,0x5C1E,0x5C1F,0x5C23,0x5C26,0x5C29,0x5C2B,0x5C2C,0x5C2E,0x5C30,0x5C32,0x5C35,0x5C36,0x5C59,0x5C5A,0x5C5C,0x5C62,0x5C63,0x5C67,0x5C68,0x5C69},
	decode_set3_BB[] = {0x5C6D,0x5C70,0x5C74,0x5C75,0x5C7A,0x5C7B,0x5C7C,0x5C7D,0x5C87,0x5C88,0x5C8A,0x5C8F,0x5C92,0x5C9D,0x5C9F,0x5CA0,0x5CA2,0x5CA3,0x5CA6,0x5CAA,0x5CB2,0x5CB4,0x5CB5,0x5CBA,0x5CC9,0x5CCB,0x5CD2,0x5CDD,0x5CD7,0x5CEE,0x5CF1,0x5CF2,0x5CF4,0x5D01,0x5D06,0x5D0D,0x5D12,0x5D2B,0x5D23,0x5D24,0x5D26,0x5D27,0x5D31,0x5D34,0x5D39,0x5D3D,0x5D3F,0x5D42,0x5D43,0x5D46,0x5D48,0x5D55,0x5D51,0x5D59,0x5D4A,0x5D5F,0x5D60,0x5D61,0x5D62,0x5D64,0x5D6A,0x5D6D,0x5D70,0x5D79,0x5D7A,0x5D7E,0x5D7F,0x5D81,0x5D83,0x5D88,0x5D8A,0x5D92,0x5D93,0x5D94,0x5D95,0x5D99,0x5D9B,0x5D9F,0x5DA0,0x5DA7,0x5DAB,0x5DB0,0x5DB4,0x5DB8,0x5DB9,0x5DC3,0x5DC7,0x5DCB,0x5DD0,0x5DCE,0x5DD8,0x5DD9,0x5DE0,0x5DE4},
	decode_set3_BC[] = {0x5DE9,0x5DF8,0x5DF9,0x5E00,0x5E07,0x5E0D,0x5E12,0x5E14,0x5E15,0x5E18,0x5E1F,0x5E20,0x5E2E,0x5E28,0x5E32,0x5E35,0x5E3E,0x5E4B,0x5E50,0x5E49,0x5E51,0x5E56,0x5E58,0x5E5B,0x5E5C,0x5E5E,0x5E68,0x5E6A,0x5E6B,0x5E6C,0x5E6D,0x5E6E,0x5E70,0x5E80,0x5E8B,0x5E8E,0x5EA2,0x5EA4,0x5EA5,0x5EA8,0x5EAA,0x5EAC,0x5EB1,0x5EB3,0x5EBD,0x5EBE,0x5EBF,0x5EC6,0x5ECC,0x5ECB,0x5ECE,0x5ED1,0x5ED2,0x5ED4,0x5ED5,0x5EDC,0x5EDE,0x5EE5,0x5EEB,0x5F02,0x5F06,0x5F07,0x5F08,0x5F0E,0x5F19,0x5F1C,0x5F1D,0x5F21,0x5F22,0x5F23,0x5F24,0x5F28,0x5F2B,0x5F2C,0x5F2E,0x5F30,0x5F34,0x5F36,0x5F3B,0x5F3D,0x5F3F,0x5F40,0x5F44,0x5F45,0x5F47,0x5F4D,0x5F50,0x5F54,0x5F58,0x5F5B,0x5F60,0x5F63,0x5F64,0x5F67},
	decode_set3_BD[] = {0x5F6F,0x5F72,0x5F74,0x5F75,0x5F78,0x5F7A,0x5F7D,0x5F7E,0x5F89,0x5F8D,0x5F8F,0x5F96,0x5F9C,0x5F9D,0x5FA2,0x5FA7,0x5FAB,0x5FA4,0x5FAC,0x5FAF,0x5FB0,0x5FB1,0x5FB8,0x5FC4,0x5FC7,0x5FC8,0x5FC9,0x5FCB,0x5FD0,0x5FD1,0x5FD2,0x5FD3,0x5FD4,0x5FDE,0x5FE1,0x5FE2,0x5FE8,0x5FE9,0x5FEA,0x5FEC,0x5FED,0x5FEE,0x5FEF,0x5FF2,0x5FF3,0x5FF6,0x5FFA,0x5FFC,0x6007,0x600A,0x600D,0x6013,0x6014,0x6017,0x6018,0x601A,0x601F,0x6024,0x602D,0x6033,0x6035,0x6040,0x6047,0x6048,0x6049,0x604C,0x6051,0x6054,0x6056,0x6057,0x605D,0x6061,0x6067,0x6071,0x607E,0x607F,0x6082,0x6086,0x6088,0x608A,0x608E,0x6091,0x6093,0x6095,0x6098,0x609D,0x609E,0x60A2,0x60A4,0x60A5,0x60A8,0x60B0,0x60B1,0x60B7},
	decode_set3_BE[] = {0x60BB,0x60BE,0x60C2,0x60C4,0x60C8,0x60C9,0x60CA,0x60CB,0x60CE,0x60CF,0x60D4,0x60D5,0x60D9,0x60DB,0x60DD,0x60DE,0x60E2,0x60E5,0x60F2,0x60F5,0x60F8,0x60FC,0x60FD,0x6102,0x6107,0x610A,0x610C,0x6110,0x6111,0x6112,0x6113,0x6114,0x6116,0x6117,0x6119,0x611C,0x611E,0x6122,0x612A,0x612B,0x6130,0x6131,0x6135,0x6136,0x6137,0x6139,0x6141,0x6145,0x6146,0x6149,0x615E,0x6160,0x616C,0x6172,0x6178,0x617B,0x617C,0x617F,0x6180,0x6181,0x6183,0x6184,0x618B,0x618D,0x6192,0x6193,0x6197,0x6198,0x619C,0x619D,0x619F,0x61A0,0x61A5,0x61A8,0x61AA,0x61AD,0x61B8,0x61B9,0x61BC,0x61C0,0x61C1,0x61C2,0x61CE,0x61CF,0x61D5,0x61DC,0x61DD,0x61DE,0x61DF,0x61E1,0x61E2,0x61E7,0x61E9,0x61E5},
	decode_set3_BF[] = {0x61EC,0x61ED,0x61EF,0x6201,0x6203,0x6204,0x6207,0x6213,0x6215,0x621C,0x6220,0x6222,0x6223,0x6227,0x6229,0x622B,0x6239,0x623D,0x6242,0x6243,0x6244,0x6246,0x624C,0x6250,0x6251,0x6252,0x6254,0x6256,0x625A,0x625C,0x6264,0x626D,0x626F,0x6273,0x627A,0x627D,0x628D,0x628E,0x628F,0x6290,0x62A6,0x62A8,0x62B3,0x62B6,0x62B7,0x62BA,0x62BE,0x62BF,0x62C4,0x62CE,0x62D5,0x62D6,0x62DA,0x62EA,0x62F2,0x62F4,0x62FC,0x62FD,0x6303,0x6304,0x630A,0x630B,0x630D,0x6310,0x6313,0x6316,0x6318,0x6329,0x632A,0x632D,0x6335,0x6336,0x6339,0x633C,0x6341,0x6342,0x6343,0x6344,0x6346,0x634A,0x634B,0x634E,0x6352,0x6353,0x6354,0x6358,0x635B,0x6365,0x6366,0x636C,0x636D,0x6371,0x6374,0x6375},
	decode_set3_C0[] = {0x6378,0x637C,0x637D,0x637F,0x6382,0x6384,0x6387,0x638A,0x6390,0x6394,0x6395,0x6399,0x639A,0x639E,0x63A4,0x63A6,0x63AD,0x63AE,0x63AF,0x63BD,0x63C1,0x63C5,0x63C8,0x63CE,0x63D1,0x63D3,0x63D4,0x63D5,0x63DC,0x63E0,0x63E5,0x63EA,0x63EC,0x63F2,0x63F3,0x63F5,0x63F8,0x63F9,0x6409,0x640A,0x6410,0x6412,0x6414,0x6418,0x641E,0x6420,0x6422,0x6424,0x6425,0x6429,0x642A,0x642F,0x6430,0x6435,0x643D,0x643F,0x644B,0x644F,0x6451,0x6452,0x6453,0x6454,0x645A,0x645B,0x645C,0x645D,0x645F,0x6460,0x6461,0x6463,0x646D,0x6473,0x6474,0x647B,0x647D,0x6485,0x6487,0x648F,0x6490,0x6491,0x6498,0x6499,0x649B,0x649D,0x649F,0x64A1,0x64A3,0x64A6,0x64A8,0x64AC,0x64B3,0x64BD,0x64BE,0x64BF},
	decode_set3_C1[] = {0x64C4,0x64C9,0x64CA,0x64CB,0x64CC,0x64CE,0x64D0,0x64D1,0x64D5,0x64D7,0x64E4,0x64E5,0x64E9,0x64EA,0x64ED,0x64F0,0x64F5,0x64F7,0x64FB,0x64FF,0x6501,0x6504,0x6508,0x6509,0x650A,0x650F,0x6513,0x6514,0x6516,0x6519,0x651B,0x651E,0x651F,0x6522,0x6526,0x6529,0x652E,0x6531,0x653A,0x653C,0x653D,0x6543,0x6547,0x6549,0x6550,0x6552,0x6554,0x655F,0x6560,0x6567,0x656B,0x657A,0x657D,0x6581,0x6585,0x658A,0x6592,0x6595,0x6598,0x659D,0x65A0,0x65A3,0x65A6,0x65AE,0x65B2,0x65B3,0x65B4,0x65BF,0x65C2,0x65C8,0x65C9,0x65CE,0x65D0,0x65D4,0x65D6,0x65D8,0x65DF,0x65F0,0x65F2,0x65F4,0x65F5,0x65F9,0x65FE,0x65FF,0x6600,0x6604,0x6608,0x6609,0x660D,0x6611,0x6612,0x6615,0x6616,0x661D},
	decode_set3_C2[] = {0x661E,0x6621,0x6622,0x6623,0x6624,0x6626,0x6629,0x662A,0x662B,0x662C,0x662E,0x6630,0x6631,0x6633,0x6639,0x6637,0x6640,0x6645,0x6646,0x664A,0x664C,0x6651,0x664E,0x6657,0x6658,0x6659,0x665B,0x665C,0x6660,0x6661,0x66FB,0x666A,0x666B,0x666C,0x667E,0x6673,0x6675,0x667F,0x6677,0x6678,0x6679,0x667B,0x6680,0x667C,0x668B,0x668C,0x668D,0x6690,0x6692,0x6699,0x669A,0x669B,0x669C,0x669F,0x66A0,0x66A4,0x66AD,0x66B1,0x66B2,0x66B5,0x66BB,0x66BF,0x66C0,0x66C2,0x66C3,0x66C8,0x66CC,0x66CE,0x66CF,0x66D4,0x66DB,0x66DF,0x66E8,0x66EB,0x66EC,0x66EE,0x66FA,0x6705,0x6707,0x670E,0x6713,0x6719,0x671C,0x6720,0x6722,0x6733,0x673E,0x6745,0x6747,0x6748,0x674C,0x6754,0x6755,0x675D},
	decode_set3_C3[] = {0x6766,0x676C,0x676E,0x6774,0x6776,0x677B,0x6781,0x6784,0x678E,0x678F,0x6791,0x6793,0x6796,0x6798,0x6799,0x679B,0x67B0,0x67B1,0x67B2,0x67B5,0x67BB,0x67BC,0x67BD,0x67F9,0x67C0,0x67C2,0x67C3,0x67C5,0x67C8,0x67C9,0x67D2,0x67D7,0x67D9,0x67DC,0x67E1,0x67E6,0x67F0,0x67F2,0x67F6,0x67F7,0x6852,0x6814,0x6819,0x681D,0x681F,0x6828,0x6827,0x682C,0x682D,0x682F,0x6830,0x6831,0x6833,0x683B,0x683F,0x6844,0x6845,0x684A,0x684C,0x6855,0x6857,0x6858,0x685B,0x686B,0x686E,0x686F,0x6870,0x6871,0x6872,0x6875,0x6879,0x687A,0x687B,0x687C,0x6882,0x6884,0x6886,0x6888,0x6896,0x6898,0x689A,0x689C,0x68A1,0x68A3,0x68A5,0x68A9,0x68AA,0x68AE,0x68B2,0x68BB,0x68C5,0x68C8,0x68CC,0x68CF},
	decode_set3_C4[] = {0x68D0,0x68D1,0x68D3,0x68D6,0x68D9,0x68DC,0x68DD,0x68E5,0x68E8,0x68EA,0x68EB,0x68EC,0x68ED,0x68F0,0x68F1,0x68F5,0x68F6,0x68FB,0x68FC,0x68FD,0x6906,0x6909,0x690A,0x6910,0x6911,0x6913,0x6916,0x6917,0x6931,0x6933,0x6935,0x6938,0x693B,0x6942,0x6945,0x6949,0x694E,0x6957,0x695B,0x6963,0x6964,0x6965,0x6966,0x6968,0x6969,0x696C,0x6970,0x6971,0x6972,0x697A,0x697B,0x697F,0x6980,0x698D,0x6992,0x6996,0x6998,0x69A1,0x69A5,0x69A6,0x69A8,0x69AB,0x69AD,0x69AF,0x69B7,0x69B8,0x69BA,0x69BC,0x69C5,0x69C8,0x69D1,0x69D6,0x69D7,0x69E2,0x69E5,0x69EE,0x69EF,0x69F1,0x69F3,0x69F5,0x69FE,0x6A00,0x6A01,0x6A03,0x6A0F,0x6A11,0x6A15,0x6A1A,0x6A1D,0x6A20,0x6A24,0x6A28,0x6A30,0x6A32},
	decode_set3_C5[] = {0x6A34,0x6A37,0x6A3B,0x6A3E,0x6A3F,0x6A45,0x6A46,0x6A49,0x6A4A,0x6A4E,0x6A50,0x6A51,0x6A52,0x6A55,0x6A56,0x6A5B,0x6A64,0x6A67,0x6A6A,0x6A71,0x6A73,0x6A7E,0x6A81,0x6A83,0x6A86,0x6A87,0x6A89,0x6A8B,0x6A91,0x6A9B,0x6A9D,0x6A9E,0x6A9F,0x6AA5,0x6AAB,0x6AAF,0x6AB0,0x6AB1,0x6AB4,0x6ABD,0x6ABE,0x6ABF,0x6AC6,0x6AC9,0x6AC8,0x6ACC,0x6AD0,0x6AD4,0x6AD5,0x6AD6,0x6ADC,0x6ADD,0x6AE4,0x6AE7,0x6AEC,0x6AF0,0x6AF1,0x6AF2,0x6AFC,0x6AFD,0x6B02,0x6B03,0x6B06,0x6B07,0x6B09,0x6B0F,0x6B10,0x6B11,0x6B17,0x6B1B,0x6B1E,0x6B24,0x6B28,0x6B2B,0x6B2C,0x6B2F,0x6B35,0x6B36,0x6B3B,0x6B3F,0x6B46,0x6B4A,0x6B4D,0x6B52,0x6B56,0x6B58,0x6B5D,0x6B60,0x6B67,0x6B6B,0x6B6E,0x6B70,0x6B75,0x6B7D},
	decode_set3_C6[] = {0x6B7E,0x6B82,0x6B85,0x6B97,0x6B9B,0x6B9F,0x6BA0,0x6BA2,0x6BA3,0x6BA8,0x6BA9,0x6BAC,0x6BAD,0x6BAE,0x6BB0,0x6BB8,0x6BB9,0x6BBD,0x6BBE,0x6BC3,0x6BC4,0x6BC9,0x6BCC,0x6BD6,0x6BDA,0x6BE1,0x6BE3,0x6BE6,0x6BE7,0x6BEE,0x6BF1,0x6BF7,0x6BF9,0x6BFF,0x6C02,0x6C04,0x6C05,0x6C09,0x6C0D,0x6C0E,0x6C10,0x6C12,0x6C19,0x6C1F,0x6C26,0x6C27,0x6C28,0x6C2C,0x6C2E,0x6C33,0x6C35,0x6C36,0x6C3A,0x6C3B,0x6C3F,0x6C4A,0x6C4B,0x6C4D,0x6C4F,0x6C52,0x6C54,0x6C59,0x6C5B,0x6C5C,0x6C6B,0x6C6D,0x6C6F,0x6C74,0x6C76,0x6C78,0x6C79,0x6C7B,0x6C85,0x6C86,0x6C87,0x6C89,0x6C94,0x6C95,0x6C97,0x6C98,0x6C9C,0x6C9F,0x6CB0,0x6CB2,0x6CB4,0x6CC2,0x6CC6,0x6CCD,0x6CCF,0x6CD0,0x6CD1,0x6CD2,0x6CD4,0x6CD6},
	decode_set3_C7[] = {0x6CDA,0x6CDC,0x6CE0,0x6CE7,0x6CE9,0x6CEB,0x6CEC,0x6CEE,0x6CF2,0x6CF4,0x6D04,0x6D07,0x6D0A,0x6D0E,0x6D0F,0x6D11,0x6D13,0x6D1A,0x6D26,0x6D27,0x6D28,0x6C67,0x6D2E,0x6D2F,0x6D31,0x6D39,0x6D3C,0x6D3F,0x6D57,0x6D5E,0x6D5F,0x6D61,0x6D65,0x6D67,0x6D6F,0x6D70,0x6D7C,0x6D82,0x6D87,0x6D91,0x6D92,0x6D94,0x6D96,0x6D97,0x6D98,0x6DAA,0x6DAC,0x6DB4,0x6DB7,0x6DB9,0x6DBD,0x6DBF,0x6DC4,0x6DC8,0x6DCA,0x6DCE,0x6DCF,0x6DD6,0x6DDB,0x6DDD,0x6DDF,0x6DE0,0x6DE2,0x6DE5,0x6DE9,0x6DEF,0x6DF0,0x6DF4,0x6DF6,0x6DFC,0x6E00,0x6E04,0x6E1E,0x6E22,0x6E27,0x6E32,0x6E36,0x6E39,0x6E3B,0x6E3C,0x6E44,0x6E45,0x6E48,0x6E49,0x6E4B,0x6E4F,0x6E51,0x6E52,0x6E53,0x6E54,0x6E57,0x6E5C,0x6E5D,0x6E5E},
	decode_set3_C8[] = {0x6E62,0x6E63,0x6E68,0x6E73,0x6E7B,0x6E7D,0x6E8D,0x6E93,0x6E99,0x6EA0,0x6EA7,0x6EAD,0x6EAE,0x6EB1,0x6EB3,0x6EBB,0x6EBF,0x6EC0,0x6EC1,0x6EC3,0x6EC7,0x6EC8,0x6ECA,0x6ECD,0x6ECE,0x6ECF,0x6EEB,0x6EED,0x6EEE,0x6EF9,0x6EFB,0x6EFD,0x6F04,0x6F08,0x6F0A,0x6F0C,0x6F0D,0x6F16,0x6F18,0x6F1A,0x6F1B,0x6F26,0x6F29,0x6F2A,0x6F2F,0x6F30,0x6F33,0x6F36,0x6F3B,0x6F3C,0x6F2D,0x6F4F,0x6F51,0x6F52,0x6F53,0x6F57,0x6F59,0x6F5A,0x6F5D,0x6F5E,0x6F61,0x6F62,0x6F68,0x6F6C,0x6F7D,0x6F7E,0x6F83,0x6F87,0x6F88,0x6F8B,0x6F8C,0x6F8D,0x6F90,0x6F92,0x6F93,0x6F94,0x6F96,0x6F9A,0x6F9F,0x6FA0,0x6FA5,0x6FA6,0x6FA7,0x6FA8,0x6FAE,0x6FAF,0x6FB0,0x6FB5,0x6FB6,0x6FBC,0x6FC5,0x6FC7,0x6FC8,0x6FCA},
	decode_set3_C9[] = {0x6FDA,0x6FDE,0x6FE8,0x6FE9,0x6FF0,0x6FF5,0x6FF9,0x6FFC,0x6FFD,0x7000,0x7005,0x7006,0x7007,0x700D,0x7017,0x7020,0x7023,0x702F,0x7034,0x7037,0x7039,0x703C,0x7043,0x7044,0x7048,0x7049,0x704A,0x704B,0x7054,0x7055,0x705D,0x705E,0x704E,0x7064,0x7065,0x706C,0x706E,0x7075,0x7076,0x707E,0x7081,0x7085,0x7086,0x7094,0x7095,0x7096,0x7097,0x7098,0x709B,0x70A4,0x70AB,0x70B0,0x70B1,0x70B4,0x70B7,0x70CA,0x70D1,0x70D3,0x70D4,0x70D5,0x70D6,0x70D8,0x70DC,0x70E4,0x70FA,0x7103,0x7104,0x7105,0x7106,0x7107,0x710B,0x710C,0x710F,0x711E,0x7120,0x712B,0x712D,0x712F,0x7130,0x7131,0x7138,0x7141,0x7145,0x7146,0x7147,0x714A,0x714B,0x7150,0x7152,0x7157,0x715A,0x715C,0x715E,0x7160},
	decode_set3_CA[] = {0x7168,0x7179,0x7180,0x7185,0x7187,0x718C,0x7192,0x719A,0x719B,0x71A0,0x71A2,0x71AF,0x71B0,0x71B2,0x71B3,0x71BA,0x71BF,0x71C0,0x71C1,0x71C4,0x71CB,0x71CC,0x71D3,0x71D6,0x71D9,0x71DA,0x71DC,0x71F8,0x71FE,0x7200,0x7207,0x7208,0x7209,0x7213,0x7217,0x721A,0x721D,0x721F,0x7224,0x722B,0x722F,0x7234,0x7238,0x7239,0x7241,0x7242,0x7243,0x7245,0x724E,0x724F,0x7250,0x7253,0x7255,0x7256,0x725A,0x725C,0x725E,0x7260,0x7263,0x7268,0x726B,0x726E,0x726F,0x7271,0x7277,0x7278,0x727B,0x727C,0x727F,0x7284,0x7289,0x728D,0x728E,0x7293,0x729B,0x72A8,0x72AD,0x72AE,0x72B1,0x72B4,0x72BE,0x72C1,0x72C7,0x72C9,0x72CC,0x72D5,0x72D6,0x72D8,0x72DF,0x72E5,0x72F3,0x72F4,0x72FA,0x72FB},
	decode_set3_CB[] = {0x72FE,0x7302,0x7304,0x7305,0x7307,0x730B,0x730D,0x7312,0x7313,0x7318,0x7319,0x731E,0x7322,0x7324,0x7327,0x7328,0x732C,0x7331,0x7332,0x7335,0x733A,0x733B,0x733D,0x7343,0x734D,0x7350,0x7352,0x7356,0x7358,0x735D,0x735E,0x735F,0x7360,0x7366,0x7367,0x7369,0x736B,0x736C,0x736E,0x736F,0x7371,0x7377,0x7379,0x737C,0x7380,0x7381,0x7383,0x7385,0x7386,0x738E,0x7390,0x7393,0x7395,0x7397,0x7398,0x739C,0x739E,0x739F,0x73A0,0x73A2,0x73A5,0x73A6,0x73AA,0x73AB,0x73AD,0x73B5,0x73B7,0x73B9,0x73BC,0x73BD,0x73BF,0x73C5,0x73C6,0x73C9,0x73CB,0x73CC,0x73CF,0x73D2,0x73D3,0x73D6,0x73D9,0x73DD,0x73E1,0x73E3,0x73E6,0x73E7,0x73E9,0x73F4,0x73F5,0x73F7,0x73F9,0x73FA,0x73FB,0x73FD},
	decode_set3_CC[] = {0x73FF,0x7400,0x7401,0x7404,0x7407,0x740A,0x7411,0x741A,0x741B,0x7424,0x7426,0x7428,0x7429,0x742A,0x742B,0x742C,0x742D,0x742E,0x742F,0x7430,0x7431,0x7439,0x7440,0x7443,0x7444,0x7446,0x7447,0x744B,0x744D,0x7451,0x7452,0x7457,0x745D,0x7462,0x7466,0x7467,0x7468,0x746B,0x746D,0x746E,0x7471,0x7472,0x7480,0x7481,0x7485,0x7486,0x7487,0x7489,0x748F,0x7490,0x7491,0x7492,0x7498,0x7499,0x749A,0x749C,0x749F,0x74A0,0x74A1,0x74A3,0x74A6,0x74A8,0x74A9,0x74AA,0x74AB,0x74AE,0x74AF,0x74B1,0x74B2,0x74B5,0x74B9,0x74BB,0x74BF,0x74C8,0x74C9,0x74CC,0x74D0,0x74D3,0x74D8,0x74DA,0x74DB,0x74DE,0x74DF,0x74E4,0x74E8,0x74EA,0x74EB,0x74EF,0x74F4,0x74FA,0x74FB,0x74FC,0x74FF,0x7506},
	decode_set3_CD[] = {0x7512,0x7516,0x7517,0x7520,0x7521,0x7524,0x7527,0x7529,0x752A,0x752F,0x7536,0x7539,0x753D,0x753E,0x753F,0x7540,0x7543,0x7547,0x7548,0x754E,0x7550,0x7552,0x7557,0x755E,0x755F,0x7561,0x756F,0x7571,0x7579,0x757A,0x757B,0x757C,0x757D,0x757E,0x7581,0x7585,0x7590,0x7592,0x7593,0x7595,0x7599,0x759C,0x75A2,0x75A4,0x75B4,0x75BA,0x75BF,0x75C0,0x75C1,0x75C4,0x75C6,0x75CC,0x75CE,0x75CF,0x75D7,0x75DC,0x75DF,0x75E0,0x75E1,0x75E4,0x75E7,0x75EC,0x75EE,0x75EF,0x75F1,0x75F9,0x7600,0x7602,0x7603,0x7604,0x7607,0x7608,0x760A,0x760C,0x760F,0x7612,0x7613,0x7615,0x7616,0x7619,0x761B,0x761C,0x761D,0x761E,0x7623,0x7625,0x7626,0x7629,0x762D,0x7632,0x7633,0x7635,0x7638,0x7639},
	decode_set3_CE[] = {0x763A,0x763C,0x764A,0x7640,0x7641,0x7643,0x7644,0x7645,0x7649,0x764B,0x7655,0x7659,0x765F,0x7664,0x7665,0x766D,0x766E,0x766F,0x7671,0x7674,0x7681,0x7685,0x768C,0x768D,0x7695,0x769B,0x769C,0x769D,0x769F,0x76A0,0x76A2,0x76A3,0x76A4,0x76A5,0x76A6,0x76A7,0x76A8,0x76AA,0x76AD,0x76BD,0x76C1,0x76C5,0x76C9,0x76CB,0x76CC,0x76CE,0x76D4,0x76D9,0x76E0,0x76E6,0x76E8,0x76EC,0x76F0,0x76F1,0x76F6,0x76F9,0x76FC,0x7700,0x7706,0x770A,0x770E,0x7712,0x7714,0x7715,0x7717,0x7719,0x771A,0x771C,0x7722,0x7728,0x772D,0x772E,0x772F,0x7734,0x7735,0x7736,0x7739,0x773D,0x773E,0x7742,0x7745,0x7746,0x774A,0x774D,0x774E,0x774F,0x7752,0x7756,0x7757,0x775C,0x775E,0x775F,0x7760,0x7762},
	decode_set3_CF[] = {0x7764,0x7767,0x776A,0x776C,0x7770,0x7772,0x7773,0x7774,0x777A,0x777D,0x7780,0x7784,0x778C,0x778D,0x7794,0x7795,0x7796,0x779A,0x779F,0x77A2,0x77A7,0x77AA,0x77AE,0x77AF,0x77B1,0x77B5,0x77BE,0x77C3,0x77C9,0x77D1,0x77D2,0x77D5,0x77D9,0x77DE,0x77DF,0x77E0,0x77E4,0x77E6,0x77EA,0x77EC,0x77F0,0x77F1,0x77F4,0x77F8,0x77FB,0x7805,0x7806,0x7809,0x780D,0x780E,0x7811,0x781D,0x7821,0x7822,0x7823,0x782D,0x782E,0x7830,0x7835,0x7837,0x7843,0x7844,0x7847,0x7848,0x784C,0x784E,0x7852,0x785C,0x785E,0x7860,0x7861,0x7863,0x7864,0x7868,0x786A,0x786E,0x787A,0x787E,0x788A,0x788F,0x7894,0x7898,0x78A1,0x789D,0x789E,0x789F,0x78A4,0x78A8,0x78AC,0x78AD,0x78B0,0x78B1,0x78B2,0x78B3},
	decode_set3_D0[] = {0x78BB,0x78BD,0x78BF,0x78C7,0x78C8,0x78C9,0x78CC,0x78CE,0x78D2,0x78D3,0x78D5,0x78D6,0x78E4,0x78DB,0x78DF,0x78E0,0x78E1,0x78E6,0x78EA,0x78F2,0x78F3,0x7900,0x78F6,0x78F7,0x78FA,0x78FB,0x78FF,0x7906,0x790C,0x7910,0x791A,0x791C,0x791E,0x791F,0x7920,0x7925,0x7927,0x7929,0x792D,0x7931,0x7934,0x7935,0x793B,0x793D,0x793F,0x7944,0x7945,0x7946,0x794A,0x794B,0x794F,0x7951,0x7954,0x7958,0x795B,0x795C,0x7967,0x7969,0x796B,0x7972,0x7979,0x797B,0x797C,0x797E,0x798B,0x798C,0x7991,0x7993,0x7994,0x7995,0x7996,0x7998,0x799B,0x799C,0x79A1,0x79A8,0x79A9,0x79AB,0x79AF,0x79B1,0x79B4,0x79B8,0x79BB,0x79C2,0x79C4,0x79C7,0x79C8,0x79CA,0x79CF,0x79D4,0x79D6,0x79DA,0x79DD,0x79DE},
	decode_set3_D1[] = {0x79E0,0x79E2,0x79E5,0x79EA,0x79EB,0x79ED,0x79F1,0x79F8,0x79FC,0x7A02,0x7A03,0x7A07,0x7A09,0x7A0A,0x7A0C,0x7A11,0x7A15,0x7A1B,0x7A1E,0x7A21,0x7A27,0x7A2B,0x7A2D,0x7A2F,0x7A30,0x7A34,0x7A35,0x7A38,0x7A39,0x7A3A,0x7A44,0x7A45,0x7A47,0x7A48,0x7A4C,0x7A55,0x7A56,0x7A59,0x7A5C,0x7A5D,0x7A5F,0x7A60,0x7A65,0x7A67,0x7A6A,0x7A6D,0x7A75,0x7A78,0x7A7E,0x7A80,0x7A82,0x7A85,0x7A86,0x7A8A,0x7A8B,0x7A90,0x7A91,0x7A94,0x7A9E,0x7AA0,0x7AA3,0x7AAC,0x7AB3,0x7AB5,0x7AB9,0x7ABB,0x7ABC,0x7AC6,0x7AC9,0x7ACC,0x7ACE,0x7AD1,0x7ADB,0x7AE8,0x7AE9,0x7AEB,0x7AEC,0x7AF1,0x7AF4,0x7AFB,0x7AFD,0x7AFE,0x7B07,0x7B14,0x7B1F,0x7B23,0x7B27,0x7B29,0x7B2A,0x7B2B,0x7B2D,0x7B2E,0x7B2F,0x7B30},
	decode_set3_D2[] = {0x7B31,0x7B34,0x7B3D,0x7B3F,0x7B40,0x7B41,0x7B47,0x7B4E,0x7B55,0x7B60,0x7B64,0x7B66,0x7B69,0x7B6A,0x7B6D,0x7B6F,0x7B72,0x7B73,0x7B77,0x7B84,0x7B89,0x7B8E,0x7B90,0x7B91,0x7B96,0x7B9B,0x7B9E,0x7BA0,0x7BA5,0x7BAC,0x7BAF,0x7BB0,0x7BB2,0x7BB5,0x7BB6,0x7BBA,0x7BBB,0x7BBC,0x7BBD,0x7BC2,0x7BC5,0x7BC8,0x7BCA,0x7BD4,0x7BD6,0x7BD7,0x7BD9,0x7BDA,0x7BDB,0x7BE8,0x7BEA,0x7BF2,0x7BF4,0x7BF5,0x7BF8,0x7BF9,0x7BFA,0x7BFC,0x7BFE,0x7C01,0x7C02,0x7C03,0x7C04,0x7C06,0x7C09,0x7C0B,0x7C0C,0x7C0E,0x7C0F,0x7C19,0x7C1B,0x7C20,0x7C25,0x7C26,0x7C28,0x7C2C,0x7C31,0x7C33,0x7C34,0x7C36,0x7C39,0x7C3A,0x7C46,0x7C4A,0x7C55,0x7C51,0x7C52,0x7C53,0x7C59,0x7C5A,0x7C5B,0x7C5C,0x7C5D,0x7C5E},
	decode_set3_D3[] = {0x7C61,0x7C63,0x7C67,0x7C69,0x7C6D,0x7C6E,0x7C70,0x7C72,0x7C79,0x7C7C,0x7C7D,0x7C86,0x7C87,0x7C8F,0x7C94,0x7C9E,0x7CA0,0x7CA6,0x7CB0,0x7CB6,0x7CB7,0x7CBA,0x7CBB,0x7CBC,0x7CBF,0x7CC4,0x7CC7,0x7CC8,0x7CC9,0x7CCD,0x7CCF,0x7CD3,0x7CD4,0x7CD5,0x7CD7,0x7CD9,0x7CDA,0x7CDD,0x7CE6,0x7CE9,0x7CEB,0x7CF5,0x7D03,0x7D07,0x7D08,0x7D09,0x7D0F,0x7D11,0x7D12,0x7D13,0x7D16,0x7D1D,0x7D1E,0x7D23,0x7D26,0x7D2A,0x7D2D,0x7D31,0x7D3C,0x7D3D,0x7D3E,0x7D40,0x7D41,0x7D47,0x7D48,0x7D4D,0x7D51,0x7D53,0x7D57,0x7D59,0x7D5A,0x7D5C,0x7D5D,0x7D65,0x7D67,0x7D6A,0x7D70,0x7D78,0x7D7A,0x7D7B,0x7D7F,0x7D81,0x7D82,0x7D83,0x7D85,0x7D86,0x7D88,0x7D8B,0x7D8C,0x7D8D,0x7D91,0x7D96,0x7D97,0x7D9D},
	decode_set3_D4[] = {0x7D9E,0x7DA6,0x7DA7,0x7DAA,0x7DB3,0x7DB6,0x7DB7,0x7DB9,0x7DC2,0x7DC3,0x7DC4,0x7DC5,0x7DC6,0x7DCC,0x7DCD,0x7DCE,0x7DD7,0x7DD9,0x7E00,0x7DE2,0x7DE5,0x7DE6,0x7DEA,0x7DEB,0x7DED,0x7DF1,0x7DF5,0x7DF6,0x7DF9,0x7DFA,0x7E08,0x7E10,0x7E11,0x7E15,0x7E17,0x7E1C,0x7E1D,0x7E20,0x7E27,0x7E28,0x7E2C,0x7E2D,0x7E2F,0x7E33,0x7E36,0x7E3F,0x7E44,0x7E45,0x7E47,0x7E4E,0x7E50,0x7E52,0x7E58,0x7E5F,0x7E61,0x7E62,0x7E65,0x7E6B,0x7E6E,0x7E6F,0x7E73,0x7E78,0x7E7E,0x7E81,0x7E86,0x7E87,0x7E8A,0x7E8D,0x7E91,0x7E95,0x7E98,0x7E9A,0x7E9D,0x7E9E,0x7F3C,0x7F3B,0x7F3D,0x7F3E,0x7F3F,0x7F43,0x7F44,0x7F47,0x7F4F,0x7F52,0x7F53,0x7F5B,0x7F5C,0x7F5D,0x7F61,0x7F63,0x7F64,0x7F65,0x7F66,0x7F6D},
	decode_set3_D5[] = {0x7F71,0x7F7D,0x7F7E,0x7F7F,0x7F80,0x7F8B,0x7F8D,0x7F8F,0x7F90,0x7F91,0x7F96,0x7F97,0x7F9C,0x7FA1,0x7FA2,0x7FA6,0x7FAA,0x7FAD,0x7FB4,0x7FBC,0x7FBF,0x7FC0,0x7FC3,0x7FC8,0x7FCE,0x7FCF,0x7FDB,0x7FDF,0x7FE3,0x7FE5,0x7FE8,0x7FEC,0x7FEE,0x7FEF,0x7FF2,0x7FFA,0x7FFD,0x7FFE,0x7FFF,0x8007,0x8008,0x800A,0x800D,0x800E,0x800F,0x8011,0x8013,0x8014,0x8016,0x801D,0x801E,0x801F,0x8020,0x8024,0x8026,0x802C,0x802E,0x8030,0x8034,0x8035,0x8037,0x8039,0x803A,0x803C,0x803E,0x8040,0x8044,0x8060,0x8064,0x8066,0x806D,0x8071,0x8075,0x8081,0x8088,0x808E,0x809C,0x809E,0x80A6,0x80A7,0x80AB,0x80B8,0x80B9,0x80C8,0x80CD,0x80CF,0x80D2,0x80D4,0x80D5,0x80D7,0x80D8,0x80E0,0x80ED,0x80EE},
	decode_set3_D6[] = {0x80F0,0x80F2,0x80F3,0x80F6,0x80F9,0x80FA,0x80FE,0x8103,0x810B,0x8116,0x8117,0x8118,0x811C,0x811E,0x8120,0x8124,0x8127,0x812C,0x8130,0x8135,0x813A,0x813C,0x8145,0x8147,0x814A,0x814C,0x8152,0x8157,0x8160,0x8161,0x8167,0x8168,0x8169,0x816D,0x816F,0x8177,0x8181,0x8190,0x8184,0x8185,0x8186,0x818B,0x818E,0x8196,0x8198,0x819B,0x819E,0x81A2,0x81AE,0x81B2,0x81B4,0x81BB,0x81CB,0x81C3,0x81C5,0x81CA,0x81CE,0x81CF,0x81D5,0x81D7,0x81DB,0x81DD,0x81DE,0x81E1,0x81E4,0x81EB,0x81EC,0x81F0,0x81F1,0x81F2,0x81F5,0x81F6,0x81F8,0x81F9,0x81FD,0x81FF,0x8200,0x8203,0x820F,0x8213,0x8214,0x8219,0x821A,0x821D,0x8221,0x8222,0x8228,0x8232,0x8234,0x823A,0x8243,0x8244,0x8245,0x8246},
	decode_set3_D7[] = {0x824B,0x824E,0x824F,0x8251,0x8256,0x825C,0x8260,0x8263,0x8267,0x826D,0x8274,0x827B,0x827D,0x827F,0x8280,0x8281,0x8283,0x8284,0x8287,0x8289,0x828A,0x828E,0x8291,0x8294,0x8296,0x8298,0x829A,0x829B,0x82A0,0x82A1,0x82A3,0x82A4,0x82A7,0x82A8,0x82A9,0x82AA,0x82AE,0x82B0,0x82B2,0x82B4,0x82B7,0x82BA,0x82BC,0x82BE,0x82BF,0x82C6,0x82D0,0x82D5,0x82DA,0x82E0,0x82E2,0x82E4,0x82E8,0x82EA,0x82ED,0x82EF,0x82F6,0x82F7,0x82FD,0x82FE,0x8300,0x8301,0x8307,0x8308,0x830A,0x830B,0x8354,0x831B,0x831D,0x831E,0x831F,0x8321,0x8322,0x832C,0x832D,0x832E,0x8330,0x8333,0x8337,0x833A,0x833C,0x833D,0x8342,0x8343,0x8344,0x8347,0x834D,0x834E,0x8351,0x8355,0x8356,0x8357,0x8370,0x8378},
	decode_set3_D8[] = {0x837D,0x837F,0x8380,0x8382,0x8384,0x8386,0x838D,0x8392,0x8394,0x8395,0x8398,0x8399,0x839B,0x839C,0x839D,0x83A6,0x83A7,0x83A9,0x83AC,0x83BE,0x83BF,0x83C0,0x83C7,0x83C9,0x83CF,0x83D0,0x83D1,0x83D4,0x83DD,0x8353,0x83E8,0x83EA,0x83F6,0x83F8,0x83F9,0x83FC,0x8401,0x8406,0x840A,0x840F,0x8411,0x8415,0x8419,0x83AD,0x842F,0x8439,0x8445,0x8447,0x8448,0x844A,0x844D,0x844F,0x8451,0x8452,0x8456,0x8458,0x8459,0x845A,0x845C,0x8460,0x8464,0x8465,0x8467,0x846A,0x8470,0x8473,0x8474,0x8476,0x8478,0x847C,0x847D,0x8481,0x8485,0x8492,0x8493,0x8495,0x849E,0x84A6,0x84A8,0x84A9,0x84AA,0x84AF,0x84B1,0x84B4,0x84BA,0x84BD,0x84BE,0x84C0,0x84C2,0x84C7,0x84C8,0x84CC,0x84CF,0x84D3},
	decode_set3_D9[] = {0x84DC,0x84E7,0x84EA,0x84EF,0x84F0,0x84F1,0x84F2,0x84F7,0x8532,0x84FA,0x84FB,0x84FD,0x8502,0x8503,0x8507,0x850C,0x850E,0x8510,0x851C,0x851E,0x8522,0x8523,0x8524,0x8525,0x8527,0x852A,0x852B,0x852F,0x8533,0x8534,0x8536,0x853F,0x8546,0x854F,0x8550,0x8551,0x8552,0x8553,0x8556,0x8559,0x855C,0x855D,0x855E,0x855F,0x8560,0x8561,0x8562,0x8564,0x856B,0x856F,0x8579,0x857A,0x857B,0x857D,0x857F,0x8581,0x8585,0x8586,0x8589,0x858B,0x858C,0x858F,0x8593,0x8598,0x859D,0x859F,0x85A0,0x85A2,0x85A5,0x85A7,0x85B4,0x85B6,0x85B7,0x85B8,0x85BC,0x85BD,0x85BE,0x85BF,0x85C2,0x85C7,0x85CA,0x85CB,0x85CE,0x85AD,0x85D8,0x85DA,0x85DF,0x85E0,0x85E6,0x85E8,0x85ED,0x85F3,0x85F6,0x85FC},
	decode_set3_DA[] = {0x85FF,0x8600,0x8604,0x8605,0x860D,0x860E,0x8610,0x8611,0x8612,0x8618,0x8619,0x861B,0x861E,0x8621,0x8627,0x8629,0x8636,0x8638,0x863A,0x863C,0x863D,0x8640,0x8642,0x8646,0x8652,0x8653,0x8656,0x8657,0x8658,0x8659,0x865D,0x8660,0x8661,0x8662,0x8663,0x8664,0x8669,0x866C,0x866F,0x8675,0x8676,0x8677,0x867A,0x868D,0x8691,0x8696,0x8698,0x869A,0x869C,0x86A1,0x86A6,0x86A7,0x86A8,0x86AD,0x86B1,0x86B3,0x86B4,0x86B5,0x86B7,0x86B8,0x86B9,0x86BF,0x86C0,0x86C1,0x86C3,0x86C5,0x86D1,0x86D2,0x86D5,0x86D7,0x86DA,0x86DC,0x86E0,0x86E3,0x86E5,0x86E7,0x8688,0x86FA,0x86FC,0x86FD,0x8704,0x8705,0x8707,0x870B,0x870E,0x870F,0x8710,0x8713,0x8714,0x8719,0x871E,0x871F,0x8721,0x8723},
	decode_set3_DB[] = {0x8728,0x872E,0x872F,0x8731,0x8732,0x8739,0x873A,0x873C,0x873D,0x873E,0x8740,0x8743,0x8745,0x874D,0x8758,0x875D,0x8761,0x8764,0x8765,0x876F,0x8771,0x8772,0x877B,0x8783,0x8784,0x8785,0x8786,0x8787,0x8788,0x8789,0x878B,0x878C,0x8790,0x8793,0x8795,0x8797,0x8798,0x8799,0x879E,0x87A0,0x87A3,0x87A7,0x87AC,0x87AD,0x87AE,0x87B1,0x87B5,0x87BE,0x87BF,0x87C1,0x87C8,0x87C9,0x87CA,0x87CE,0x87D5,0x87D6,0x87D9,0x87DA,0x87DC,0x87DF,0x87E2,0x87E3,0x87E4,0x87EA,0x87EB,0x87ED,0x87F1,0x87F3,0x87F8,0x87FA,0x87FF,0x8801,0x8803,0x8806,0x8809,0x880A,0x880B,0x8810,0x8819,0x8812,0x8813,0x8814,0x8818,0x881A,0x881B,0x881C,0x881E,0x881F,0x8828,0x882D,0x882E,0x8830,0x8832,0x8835},
	decode_set3_DC[] = {0x883A,0x883C,0x8841,0x8843,0x8845,0x8848,0x8849,0x884A,0x884B,0x884E,0x8851,0x8855,0x8856,0x8858,0x885A,0x885C,0x885F,0x8860,0x8864,0x8869,0x8871,0x8879,0x887B,0x8880,0x8898,0x889A,0x889B,0x889C,0x889F,0x88A0,0x88A8,0x88AA,0x88BA,0x88BD,0x88BE,0x88C0,0x88CA,0x88CB,0x88CC,0x88CD,0x88CE,0x88D1,0x88D2,0x88D3,0x88DB,0x88DE,0x88E7,0x88EF,0x88F0,0x88F1,0x88F5,0x88F7,0x8901,0x8906,0x890D,0x890E,0x890F,0x8915,0x8916,0x8918,0x8919,0x891A,0x891C,0x8920,0x8926,0x8927,0x8928,0x8930,0x8931,0x8932,0x8935,0x8939,0x893A,0x893E,0x8940,0x8942,0x8945,0x8946,0x8949,0x894F,0x8952,0x8957,0x895A,0x895B,0x895C,0x8961,0x8962,0x8963,0x896B,0x896E,0x8970,0x8973,0x8975,0x897A},
	decode_set3_DD[] = {0x897B,0x897C,0x897D,0x8989,0x898D,0x8990,0x8994,0x8995,0x899B,0x899C,0x899F,0x89A0,0x89A5,0x89B0,0x89B4,0x89B5,0x89B6,0x89B7,0x89BC,0x89D4,0x89D5,0x89D6,0x89D7,0x89D8,0x89E5,0x89E9,0x89EB,0x89ED,0x89F1,0x89F3,0x89F6,0x89F9,0x89FD,0x89FF,0x8A04,0x8A05,0x8A07,0x8A0F,0x8A11,0x8A12,0x8A14,0x8A15,0x8A1E,0x8A20,0x8A22,0x8A24,0x8A26,0x8A2B,0x8A2C,0x8A2F,0x8A35,0x8A37,0x8A3D,0x8A3E,0x8A40,0x8A43,0x8A45,0x8A47,0x8A49,0x8A4D,0x8A4E,0x8A53,0x8A56,0x8A57,0x8A58,0x8A5C,0x8A5D,0x8A61,0x8A65,0x8A67,0x8A75,0x8A76,0x8A77,0x8A79,0x8A7A,0x8A7B,0x8A7E,0x8A7F,0x8A80,0x8A83,0x8A86,0x8A8B,0x8A8F,0x8A90,0x8A92,0x8A96,0x8A97,0x8A99,0x8A9F,0x8AA7,0x8AA9,0x8AAE,0x8AAF,0x8AB3},
	decode_set3_DE[] = {0x8AB6,0x8AB7,0x8ABB,0x8ABE,0x8AC3,0x8AC6,0x8AC8,0x8AC9,0x8ACA,0x8AD1,0x8AD3,0x8AD4,0x8AD5,0x8AD7,0x8ADD,0x8ADF,0x8AEC,0x8AF0,0x8AF4,0x8AF5,0x8AF6,0x8AFC,0x8AFF,0x8B05,0x8B06,0x8B0B,0x8B11,0x8B1C,0x8B1E,0x8B1F,0x8B0A,0x8B2D,0x8B30,0x8B37,0x8B3C,0x8B42,0x8B43,0x8B44,0x8B45,0x8B46,0x8B48,0x8B52,0x8B53,0x8B54,0x8B59,0x8B4D,0x8B5E,0x8B63,0x8B6D,0x8B76,0x8B78,0x8B79,0x8B7C,0x8B7E,0x8B81,0x8B84,0x8B85,0x8B8B,0x8B8D,0x8B8F,0x8B94,0x8B95,0x8B9C,0x8B9E,0x8B9F,0x8C38,0x8C39,0x8C3D,0x8C3E,0x8C45,0x8C47,0x8C49,0x8C4B,0x8C4F,0x8C51,0x8C53,0x8C54,0x8C57,0x8C58,0x8C5B,0x8C5D,0x8C59,0x8C63,0x8C64,0x8C66,0x8C68,0x8C69,0x8C6D,0x8C73,0x8C75,0x8C76,0x8C7B,0x8C7E,0x8C86},
	decode_set3_DF[] = {0x8C87,0x8C8B,0x8C90,0x8C92,0x8C93,0x8C99,0x8C9B,0x8C9C,0x8CA4,0x8CB9,0x8CBA,0x8CC5,0x8CC6,0x8CC9,0x8CCB,0x8CCF,0x8CD6,0x8CD5,0x8CD9,0x8CDD,0x8CE1,0x8CE8,0x8CEC,0x8CEF,0x8CF0,0x8CF2,0x8CF5,0x8CF7,0x8CF8,0x8CFE,0x8CFF,0x8D01,0x8D03,0x8D09,0x8D12,0x8D17,0x8D1B,0x8D65,0x8D69,0x8D6C,0x8D6E,0x8D7F,0x8D82,0x8D84,0x8D88,0x8D8D,0x8D90,0x8D91,0x8D95,0x8D9E,0x8D9F,0x8DA0,0x8DA6,0x8DAB,0x8DAC,0x8DAF,0x8DB2,0x8DB5,0x8DB7,0x8DB9,0x8DBB,0x8DC0,0x8DC5,0x8DC6,0x8DC7,0x8DC8,0x8DCA,0x8DCE,0x8DD1,0x8DD4,0x8DD5,0x8DD7,0x8DD9,0x8DE4,0x8DE5,0x8DE7,0x8DEC,0x8DF0,0x8DBC,0x8DF1,0x8DF2,0x8DF4,0x8DFD,0x8E01,0x8E04,0x8E05,0x8E06,0x8E0B,0x8E11,0x8E14,0x8E16,0x8E20,0x8E21,0x8E22},
	decode_set3_E0[] = {0x8E23,0x8E26,0x8E27,0x8E31,0x8E33,0x8E36,0x8E37,0x8E38,0x8E39,0x8E3D,0x8E40,0x8E41,0x8E4B,0x8E4D,0x8E4E,0x8E4F,0x8E54,0x8E5B,0x8E5C,0x8E5D,0x8E5E,0x8E61,0x8E62,0x8E69,0x8E6C,0x8E6D,0x8E6F,0x8E70,0x8E71,0x8E79,0x8E7A,0x8E7B,0x8E82,0x8E83,0x8E89,0x8E90,0x8E92,0x8E95,0x8E9A,0x8E9B,0x8E9D,0x8E9E,0x8EA2,0x8EA7,0x8EA9,0x8EAD,0x8EAE,0x8EB3,0x8EB5,0x8EBA,0x8EBB,0x8EC0,0x8EC1,0x8EC3,0x8EC4,0x8EC7,0x8ECF,0x8ED1,0x8ED4,0x8EDC,0x8EE8,0x8EEE,0x8EF0,0x8EF1,0x8EF7,0x8EF9,0x8EFA,0x8EED,0x8F00,0x8F02,0x8F07,0x8F08,0x8F0F,0x8F10,0x8F16,0x8F17,0x8F18,0x8F1E,0x8F20,0x8F21,0x8F23,0x8F25,0x8F27,0x8F28,0x8F2C,0x8F2D,0x8F2E,0x8F34,0x8F35,0x8F36,0x8F37,0x8F3A,0x8F40,0x8F41},
	decode_set3_E1[] = {0x8F43,0x8F47,0x8F4F,0x8F51,0x8F52,0x8F53,0x8F54,0x8F55,0x8F58,0x8F5D,0x8F5E,0x8F65,0x8F9D,0x8FA0,0x8FA1,0x8FA4,0x8FA5,0x8FA6,0x8FB5,0x8FB6,0x8FB8,0x8FBE,0x8FC0,0x8FC1,0x8FC6,0x8FCA,0x8FCB,0x8FCD,0x8FD0,0x8FD2,0x8FD3,0x8FD5,0x8FE0,0x8FE3,0x8FE4,0x8FE8,0x8FEE,0x8FF1,0x8FF5,0x8FF6,0x8FFB,0x8FFE,0x9002,0x9004,0x9008,0x900C,0x9018,0x901B,0x9028,0x9029,0x902F,0x902A,0x902C,0x902D,0x9033,0x9034,0x9037,0x903F,0x9043,0x9044,0x904C,0x905B,0x905D,0x9062,0x9066,0x9067,0x906C,0x9070,0x9074,0x9079,0x9085,0x9088,0x908B,0x908C,0x908E,0x9090,0x9095,0x9097,0x9098,0x9099,0x909B,0x90A0,0x90A1,0x90A2,0x90A5,0x90B0,0x90B2,0x90B3,0x90B4,0x90B6,0x90BD,0x90CC,0x90BE,0x90C3},
	decode_set3_E2[] = {0x90C4,0x90C5,0x90C7,0x90C8,0x90D5,0x90D7,0x90D8,0x90D9,0x90DC,0x90DD,0x90DF,0x90E5,0x90D2,0x90F6,0x90EB,0x90EF,0x90F0,0x90F4,0x90FE,0x90FF,0x9100,0x9104,0x9105,0x9106,0x9108,0x910D,0x9110,0x9114,0x9116,0x9117,0x9118,0x911A,0x911C,0x911E,0x9120,0x9125,0x9122,0x9123,0x9127,0x9129,0x912E,0x912F,0x9131,0x9134,0x9136,0x9137,0x9139,0x913A,0x913C,0x913D,0x9143,0x9147,0x9148,0x914F,0x9153,0x9157,0x9159,0x915A,0x915B,0x9161,0x9164,0x9167,0x916D,0x9174,0x9179,0x917A,0x917B,0x9181,0x9183,0x9185,0x9186,0x918A,0x918E,0x9191,0x9193,0x9194,0x9195,0x9198,0x919E,0x91A1,0x91A6,0x91A8,0x91AC,0x91AD,0x91AE,0x91B0,0x91B1,0x91B2,0x91B3,0x91B6,0x91BB,0x91BC,0x91BD,0x91BF},
	decode_set3_E3[] = {0x91C2,0x91C3,0x91C5,0x91D3,0x91D4,0x91D7,0x91D9,0x91DA,0x91DE,0x91E4,0x91E5,0x91E9,0x91EA,0x91EC,0x91ED,0x91EE,0x91EF,0x91F0,0x91F1,0x91F7,0x91F9,0x91FB,0x91FD,0x9200,0x9201,0x9204,0x9205,0x9206,0x9207,0x9209,0x920A,0x920C,0x9210,0x9212,0x9213,0x9216,0x9218,0x921C,0x921D,0x9223,0x9224,0x9225,0x9226,0x9228,0x922E,0x922F,0x9230,0x9233,0x9235,0x9236,0x9238,0x9239,0x923A,0x923C,0x923E,0x9240,0x9242,0x9243,0x9246,0x9247,0x924A,0x924D,0x924E,0x924F,0x9251,0x9258,0x9259,0x925C,0x925D,0x9260,0x9261,0x9265,0x9267,0x9268,0x9269,0x926E,0x926F,0x9270,0x9275,0x9276,0x9277,0x9278,0x9279,0x927B,0x927C,0x927D,0x927F,0x9288,0x9289,0x928A,0x928D,0x928E,0x9292,0x9297},
	decode_set3_E4[] = {0x9299,0x929F,0x92A0,0x92A4,0x92A5,0x92A7,0x92A8,0x92AB,0x92AF,0x92B2,0x92B6,0x92B8,0x92BA,0x92BB,0x92BC,0x92BD,0x92BF,0x92C0,0x92C1,0x92C2,0x92C3,0x92C5,0x92C6,0x92C7,0x92C8,0x92CB,0x92CC,0x92CD,0x92CE,0x92D0,0x92D3,0x92D5,0x92D7,0x92D8,0x92D9,0x92DC,0x92DD,0x92DF,0x92E0,0x92E1,0x92E3,0x92E5,0x92E7,0x92E8,0x92EC,0x92EE,0x92F0,0x92F9,0x92FB,0x92FF,0x9300,0x9302,0x9308,0x930D,0x9311,0x9314,0x9315,0x931C,0x931D,0x931E,0x931F,0x9321,0x9324,0x9325,0x9327,0x9329,0x932A,0x9333,0x9334,0x9336,0x9337,0x9347,0x9348,0x9349,0x9350,0x9351,0x9352,0x9355,0x9357,0x9358,0x935A,0x935E,0x9364,0x9365,0x9367,0x9369,0x936A,0x936D,0x936F,0x9370,0x9371,0x9373,0x9374,0x9376},
	decode_set3_E5[] = {0x937A,0x937D,0x937F,0x9380,0x9381,0x9382,0x9388,0x938A,0x938B,0x938D,0x938F,0x9392,0x9395,0x9398,0x939B,0x939E,0x93A1,0x93A3,0x93A4,0x93A6,0x93A8,0x93AB,0x93B4,0x93B5,0x93B6,0x93BA,0x93A9,0x93C1,0x93C4,0x93C5,0x93C6,0x93C7,0x93C9,0x93CA,0x93CB,0x93CC,0x93CD,0x93D3,0x93D9,0x93DC,0x93DE,0x93DF,0x93E2,0x93E6,0x93E7,0x93F9,0x93F7,0x93F8,0x93FA,0x93FB,0x93FD,0x9401,0x9402,0x9404,0x9408,0x9409,0x940D,0x940E,0x940F,0x9415,0x9416,0x9417,0x941F,0x942E,0x942F,0x9431,0x9432,0x9433,0x9434,0x943B,0x943F,0x943D,0x9443,0x9445,0x9448,0x944A,0x944C,0x9455,0x9459,0x945C,0x945F,0x9461,0x9463,0x9468,0x946B,0x946D,0x946E,0x946F,0x9471,0x9472,0x9484,0x9483,0x9578,0x9579},
	decode_set3_E6[] = {0x957E,0x9584,0x9588,0x958C,0x958D,0x958E,0x959D,0x959E,0x959F,0x95A1,0x95A6,0x95A9,0x95AB,0x95AC,0x95B4,0x95B6,0x95BA,0x95BD,0x95BF,0x95C6,0x95C8,0x95C9,0x95CB,0x95D0,0x95D1,0x95D2,0x95D3,0x95D9,0x95DA,0x95DD,0x95DE,0x95DF,0x95E0,0x95E4,0x95E6,0x961D,0x961E,0x9622,0x9624,0x9625,0x9626,0x962C,0x9631,0x9633,0x9637,0x9638,0x9639,0x963A,0x963C,0x963D,0x9641,0x9652,0x9654,0x9656,0x9657,0x9658,0x9661,0x966E,0x9674,0x967B,0x967C,0x967E,0x967F,0x9681,0x9682,0x9683,0x9684,0x9689,0x9691,0x9696,0x969A,0x969D,0x969F,0x96A4,0x96A5,0x96A6,0x96A9,0x96AE,0x96AF,0x96B3,0x96BA,0x96CA,0x96D2,0x5DB2,0x96D8,0x96DA,0x96DD,0x96DE,0x96DF,0x96E9,0x96EF,0x96F1,0x96FA,0x9702},
	decode_set3_E7[] = {0x9703,0x9705,0x9709,0x971A,0x971B,0x971D,0x9721,0x9722,0x9723,0x9728,0x9731,0x9733,0x9741,0x9743,0x974A,0x974E,0x974F,0x9755,0x9757,0x9758,0x975A,0x975B,0x9763,0x9767,0x976A,0x976E,0x9773,0x9776,0x9777,0x9778,0x977B,0x977D,0x977F,0x9780,0x9789,0x9795,0x9796,0x9797,0x9799,0x979A,0x979E,0x979F,0x97A2,0x97AC,0x97AE,0x97B1,0x97B2,0x97B5,0x97B6,0x97B8,0x97B9,0x97BA,0x97BC,0x97BE,0x97BF,0x97C1,0x97C4,0x97C5,0x97C7,0x97C9,0x97CA,0x97CC,0x97CD,0x97CE,0x97D0,0x97D1,0x97D4,0x97D7,0x97D8,0x97D9,0x97DD,0x97DE,0x97E0,0x97DB,0x97E1,0x97E4,0x97EF,0x97F1,0x97F4,0x97F7,0x97F8,0x97FA,0x9807,0x980A,0x9819,0x980D,0x980E,0x9814,0x9816,0x981C,0x981E,0x9820,0x9823,0x9826},
	decode_set3_E8[] = {0x982B,0x982E,0x982F,0x9830,0x9832,0x9833,0x9835,0x9825,0x983E,0x9844,0x9847,0x984A,0x9851,0x9852,0x9853,0x9856,0x9857,0x9859,0x985A,0x9862,0x9863,0x9865,0x9866,0x986A,0x986C,0x98AB,0x98AD,0x98AE,0x98B0,0x98B4,0x98B7,0x98B8,0x98BA,0x98BB,0x98BF,0x98C2,0x98C5,0x98C8,0x98CC,0x98E1,0x98E3,0x98E5,0x98E6,0x98E7,0x98EA,0x98F3,0x98F6,0x9902,0x9907,0x9908,0x9911,0x9915,0x9916,0x9917,0x991A,0x991B,0x991C,0x991F,0x9922,0x9926,0x9927,0x992B,0x9931,0x9932,0x9933,0x9934,0x9935,0x9939,0x993A,0x993B,0x993C,0x9940,0x9941,0x9946,0x9947,0x9948,0x994D,0x994E,0x9954,0x9958,0x9959,0x995B,0x995C,0x995E,0x995F,0x9960,0x999B,0x999D,0x999F,0x99A6,0x99B0,0x99B1,0x99B2,0x99B5},
	decode_set3_E9[] = {0x99B9,0x99BA,0x99BD,0x99BF,0x99C3,0x99C9,0x99D3,0x99D4,0x99D9,0x99DA,0x99DC,0x99DE,0x99E7,0x99EA,0x99EB,0x99EC,0x99F0,0x99F4,0x99F5,0x99F9,0x99FD,0x99FE,0x9A02,0x9A03,0x9A04,0x9A0B,0x9A0C,0x9A10,0x9A11,0x9A16,0x9A1E,0x9A20,0x9A22,0x9A23,0x9A24,0x9A27,0x9A2D,0x9A2E,0x9A33,0x9A35,0x9A36,0x9A38,0x9A47,0x9A41,0x9A44,0x9A4A,0x9A4B,0x9A4C,0x9A4E,0x9A51,0x9A54,0x9A56,0x9A5D,0x9AAA,0x9AAC,0x9AAE,0x9AAF,0x9AB2,0x9AB4,0x9AB5,0x9AB6,0x9AB9,0x9ABB,0x9ABE,0x9ABF,0x9AC1,0x9AC3,0x9AC6,0x9AC8,0x9ACE,0x9AD0,0x9AD2,0x9AD5,0x9AD6,0x9AD7,0x9ADB,0x9ADC,0x9AE0,0x9AE4,0x9AE5,0x9AE7,0x9AE9,0x9AEC,0x9AF2,0x9AF3,0x9AF5,0x9AF9,0x9AFA,0x9AFD,0x9AFF,0x9B00,0x9B01,0x9B02,0x9B03},
	decode_set3_EA[] = {0x9B04,0x9B05,0x9B08,0x9B09,0x9B0B,0x9B0C,0x9B0D,0x9B0E,0x9B10,0x9B12,0x9B16,0x9B19,0x9B1B,0x9B1C,0x9B20,0x9B26,0x9B2B,0x9B2D,0x9B33,0x9B34,0x9B35,0x9B37,0x9B39,0x9B3A,0x9B3D,0x9B48,0x9B4B,0x9B4C,0x9B55,0x9B56,0x9B57,0x9B5B,0x9B5E,0x9B61,0x9B63,0x9B65,0x9B66,0x9B68,0x9B6A,0x9B6B,0x9B6C,0x9B6D,0x9B6E,0x9B73,0x9B75,0x9B77,0x9B78,0x9B79,0x9B7F,0x9B80,0x9B84,0x9B85,0x9B86,0x9B87,0x9B89,0x9B8A,0x9B8B,0x9B8D,0x9B8F,0x9B90,0x9B94,0x9B9A,0x9B9D,0x9B9E,0x9BA6,0x9BA7,0x9BA9,0x9BAC,0x9BB0,0x9BB1,0x9BB2,0x9BB7,0x9BB8,0x9BBB,0x9BBC,0x9BBE,0x9BBF,0x9BC1,0x9BC7,0x9BC8,0x9BCE,0x9BD0,0x9BD7,0x9BD8,0x9BDD,0x9BDF,0x9BE5,0x9BE7,0x9BEA,0x9BEB,0x9BEF,0x9BF3,0x9BF7,0x9BF8},
	decode_set3_EB[] = {0x9BF9,0x9BFA,0x9BFD,0x9BFF,0x9C00,0x9C02,0x9C0B,0x9C0F,0x9C11,0x9C16,0x9C18,0x9C19,0x9C1A,0x9C1C,0x9C1E,0x9C22,0x9C23,0x9C26,0x9C27,0x9C28,0x9C29,0x9C2A,0x9C31,0x9C35,0x9C36,0x9C37,0x9C3D,0x9C41,0x9C43,0x9C44,0x9C45,0x9C49,0x9C4A,0x9C4E,0x9C4F,0x9C50,0x9C53,0x9C54,0x9C56,0x9C58,0x9C5B,0x9C5D,0x9C5E,0x9C5F,0x9C63,0x9C69,0x9C6A,0x9C5C,0x9C6B,0x9C68,0x9C6E,0x9C70,0x9C72,0x9C75,0x9C77,0x9C7B,0x9CE6,0x9CF2,0x9CF7,0x9CF9,0x9D0B,0x9D02,0x9D11,0x9D17,0x9D18,0x9D1C,0x9D1D,0x9D1E,0x9D2F,0x9D30,0x9D32,0x9D33,0x9D34,0x9D3A,0x9D3C,0x9D45,0x9D3D,0x9D42,0x9D43,0x9D47,0x9D4A,0x9D53,0x9D54,0x9D5F,0x9D63,0x9D62,0x9D65,0x9D69,0x9D6A,0x9D6B,0x9D70,0x9D76,0x9D77,0x9D7B},
	decode_set3_EC[] = {0x9D7C,0x9D7E,0x9D83,0x9D84,0x9D86,0x9D8A,0x9D8D,0x9D8E,0x9D92,0x9D93,0x9D95,0x9D96,0x9D97,0x9D98,0x9DA1,0x9DAA,0x9DAC,0x9DAE,0x9DB1,0x9DB5,0x9DB9,0x9DBC,0x9DBF,0x9DC3,0x9DC7,0x9DC9,0x9DCA,0x9DD4,0x9DD5,0x9DD6,0x9DD7,0x9DDA,0x9DDE,0x9DDF,0x9DE0,0x9DE5,0x9DE7,0x9DE9,0x9DEB,0x9DEE,0x9DF0,0x9DF3,0x9DF4,0x9DFE,0x9E0A,0x9E02,0x9E07,0x9E0E,0x9E10,0x9E11,0x9E12,0x9E15,0x9E16,0x9E19,0x9E1C,0x9E1D,0x9E7A,0x9E7B,0x9E7C,0x9E80,0x9E82,0x9E83,0x9E84,0x9E85,0x9E87,0x9E8E,0x9E8F,0x9E96,0x9E98,0x9E9B,0x9E9E,0x9EA4,0x9EA8,0x9EAC,0x9EAE,0x9EAF,0x9EB0,0x9EB3,0x9EB4,0x9EB5,0x9EC6,0x9EC8,0x9ECB,0x9ED5,0x9EDF,0x9EE4,0x9EE7,0x9EEC,0x9EED,0x9EEE,0x9EF0,0x9EF1,0x9EF2,0x9EF5},
	decode_set3_ED[] = {0x9EF8,0x9EFF,0x9F02,0x9F03,0x9F09,0x9F0F,0x9F10,0x9F11,0x9F12,0x9F14,0x9F16,0x9F17,0x9F19,0x9F1A,0x9F1B,0x9F1F,0x9F22,0x9F26,0x9F2A,0x9F2B,0x9F2F,0x9F31,0x9F32,0x9F34,0x9F37,0x9F39,0x9F3A,0x9F3C,0x9F3D,0x9F3F,0x9F41,0x9F43,0x9F44,0x9F45,0x9F46,0x9F47,0x9F53,0x9F55,0x9F56,0x9F57,0x9F58,0x9F5A,0x9F5D,0x9F5E,0x9F68,0x9F69,0x9F6D,0x9F6E,0x9F6F,0x9F70,0x9F71,0x9F73,0x9F75,0x9F7A,0x9F7D,0x9F8F,0x9F90,0x9F91,0x9F92,0x9F94,0x9F96,0x9F97,0x9F9E,0x9FA1,0x9FA2,0x9FA3,0x9FA5,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_EE[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_EF[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_F0[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_F1[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_F2[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_F3[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_F4[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_F5[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_F6[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_F7[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_F8[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0,0x0},
	decode_set3_F9[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0,0x0},
	decode_set3_FA[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0,0x0},
	decode_set3_FB[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0,0x0},
	decode_set3_FC[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0,0x0},
	decode_set3_FD[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD,0x0},
	decode_set3_FE[] = {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFFFD},
	*decode_set3[] = {decode_set3_A1,decode_set3_A2,decode_set3_A3,decode_set3_A4,decode_set3_A5,decode_set3_A6,decode_set3_A7,decode_set3_A8,decode_set3_A9,decode_set3_AA,decode_set3_AB,decode_set3_AC,decode_set3_AD,decode_set3_AE,decode_set3_AF,decode_set3_B0,decode_set3_B1,decode_set3_B2,decode_set3_B3,decode_set3_B4,decode_set3_B5,decode_set3_B6,decode_set3_B7,decode_set3_B8,decode_set3_B9,decode_set3_BA,decode_set3_BB,decode_set3_BC,decode_set3_BD,decode_set3_BE,decode_set3_BF,decode_set3_C0,decode_set3_C1,decode_set3_C2,decode_set3_C3,decode_set3_C4,decode_set3_C5,decode_set3_C6,decode_set3_C7,decode_set3_C8,decode_set3_C9,decode_set3_CA,decode_set3_CB,decode_set3_CC,decode_set3_CD,decode_set3_CE,decode_set3_CF,decode_set3_D0,decode_set3_D1,decode_set3_D2,decode_set3_D3,decode_set3_D4,decode_set3_D5,decode_set3_D6,decode_set3_D7,decode_set3_D8,decode_set3_D9,decode_set3_DA,decode_set3_DB,decode_set3_DC,decode_set3_DD,decode_set3_DE,decode_set3_DF,decode_set3_E0,decode_set3_E1,decode_set3_E2,decode_set3_E3,decode_set3_E4,decode_set3_E5,decode_set3_E6,decode_set3_E7,decode_set3_E8,decode_set3_E9,decode_set3_EA,decode_set3_EB,decode_set3_EC,decode_set3_ED,decode_set3_EE,decode_set3_EF,decode_set3_F0,decode_set3_F1,decode_set3_F2,decode_set3_F3,decode_set3_F4,decode_set3_F5,decode_set3_F6,decode_set3_F7,decode_set3_F8,decode_set3_F9,decode_set3_FA,decode_set3_FB,decode_set3_FC,decode_set3_FD,decode_set3_FE,};


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Aug 11 1997
		Changed en00 to leave '~' and '\\' unchanged (previous values were
		illegal anyway)
 */
