/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:			C.all/plog/src/popc_declare.ph
 > Purpose:			Identifier declarations for POPC in this directory
 > Author:			Robert John Duncan, Jul 15 1993
 > Documentation:
 > Related Files:
 */

compile_mode:pop11 +strict;

library_declare_section '$usepop/pop/plog/src/'

;;; Make \ an alphabeticiser
12 -> item_chartype(`\\`, itemread);

;;; Standard include files
#_INCLUDE 'prolog.ph'
#_INCLUDE 'builtins.ph'
#_INCLUDE 'syntax.ph'

;;; Special declarations
section prolog;

;;; Record classes:
constant
	predicate_record_key,
	prolog_variable_tok_key;

constant procedure (
	pred_ident,
	pred_alias,
	pred_functor,
	pred_arity,
	pred_tag,
	pred_system,
	pred_dynamic,
	pred_notext,
	pred_hidden,
	pred_spied,
);

;;; Incremental properties:
constant procedure (
	inline_expansion,
	predicate_table,
	prefix_prec,
	prefix_rprec,
	postfix_prec,
	postfix_lprec,
	infix_prec,
	infix_rprec,
	infix_lprec,
);

lconstant macro PRECEDENCE_TABLE = [newproperty([], 64, ^NOPREC, "perm")];

declare_incremental property (
	inline_expansion = newproperty([], 64, false, "perm"),
	predicate_table = newanyproperty([], 100, 1, 90, false, false, "tmparg",
		false, false),
	prefix_prec = PRECEDENCE_TABLE,
	prefix_rprec = PRECEDENCE_TABLE,
	postfix_prec = PRECEDENCE_TABLE,
	postfix_lprec = PRECEDENCE_TABLE,
	infix_prec = PRECEDENCE_TABLE,
	infix_rprec = PRECEDENCE_TABLE,
	infix_lprec = PRECEDENCE_TABLE,
);

;;; References generated by the Prolog compiler:
constant procedure (
	format0,
	prolog_interpreter,
	prolog_doeval,
	prolog_atom,
	prolog_write,
	inline_name,
	inline_functor,
	inline_univ,
	tell,
	format,
	see,
);

vars
	current_input,
	current_output,
	readenv,
	wascut;

;;; Predicates defined in section prolog:
constant procedure (
	append\/3,
	bad_goal\/1,
	declare_clauses\/2,
	declare_dynamic\/2,
	declare_export\/2,
	declare_global\/2,
	declare_hidden\/2,
	declare_import\/2,
	declare_no_clauses\/2,
	declare_revealed\/2,
	declare_static\/2,
	declare_system_predicate\/2,
	declare_user_predicate\/2,
	member\/2,
	predicate_spec\/3,
	predicate_spec_error\/1,
	prolog_bindvars\/1,
	prolog_dcgand\/3,
	prolog_dcglhs\/4,
	prolog_dcgor\/4,
	prolog_dcgrhs\/4,
	prolog_disjunction\/2,
	prolog_flatconj\/2,
	prolog_flatconj\/3,
	prolog_hide\/1,
	prolog_islist\/1,
	prolog_reveal\/1,
	prolog_tag\/4,
);

endsection;

end_library_declare_section;
