/* --- Copyright University of Sussex 1998. All rights reserved. ----------
 > File:			C.power/src/drop_code.ph
 > Purpose:			Code-planting macros
 > Author:			John Gibson, Apr  6 1998
 */

#_INCLUDE 'registers.ph'

define :inline lconstant _ConsOp(Op, XOp, LoBit);
	_int( (Op << 26) || (XOp << 1) || LoBit )
enddefine;

define :inline lconstant _ConsCBrOp(_BO, _CRBit);
	_int( (16 << 26) || (_pint(_BO) << 21) || (_pint(_CRBit) << 16) )
enddefine;

lconstant macro (

		;;; opcodes
	_OP_ldui	= _ConsOp(32, 0, 0),		;;; D
	_OP_lduiu	= _ConsOp(33, 0, 0),		;;; D
	_OP_sti		= _ConsOp(36, 0, 0),		;;; D
	_OP_stiu	= _ConsOp(37, 0, 0),		;;; D
	_OP_ldub	= _ConsOp(34, 0, 0),		;;; D
	_OP_stb		= _ConsOp(38, 0, 0),		;;; D
	_OP_ldus	= _ConsOp(40, 0, 0),		;;; D
	_OP_ldss	= _ConsOp(42, 0, 0),		;;; D
	_OP_sts		= _ConsOp(44, 0, 0),		;;; D
	_OP_lda		= _ConsOp(14, 0, 0),		;;; D
	_OP_addi	= _OP_lda,
	_OP_ldah	= _ConsOp(15, 0, 0),		;;; D (addis)
	_OP_cmpwi	= _ConsOp(11, 0, 0),		;;; D
	_OP_cmplwi	= _ConsOp(10, 0, 0),		;;; D
	_OP_andi\.	= _ConsOp(28, 0, 0),		;;; DR
	_OP_ori		= _ConsOp(24, 0, 0),		;;; DR

	_OP_b		= _ConsOp(18, 0, 0),		;;; I
	_OP_bla		= _ConsOp(18, 1, 1),		;;; I
	_OP_bc		= _ConsOp(16, 0, 0),		;;; B

	_OP_add		= _ConsOp(31, 266, 0),		;;; X
	_OP_sub		= _ConsOp(31,  40, 0),		;;; X (actually, subf)
	_OP_cmpw	= _ConsOp(31,   0, 0),		;;; X
	_OP_cmplw	= _ConsOp(31,  32, 0),		;;; X
	_OP_or		= _ConsOp(31, 444, 0),		;;; XR
	_OP_srawi	= _ConsOp(31, 824, 0),		;;; XR
	_OP_slwi	= _ConsOp(21,   0, 0),		;;; XR (rlwinm)

	_OP_crandc	= _ConsOp(19, 129, 0),		;;; X
	_OP_bcctr	= _ConsOp(19, 528, 0),		;;; X
	_OP_bcctrl	= _ConsOp(19, 528, 1),		;;; X
	_OP_bclr	= _ConsOp(19,  16, 0),		;;; X

	_OP_mfspr	= _ConsOp(31, 339, 0),		;;; XFX
	_OP_mtspr	= _ConsOp(31, 467, 0),		;;; XFX

	;;; special register encodings
	_SPR_LR		= _2:0100000000,			;;; link reg
	_SPR_CTR	= _2:0100100000,			;;; count reg

	;;; Condition Register fields
	_CR0		= _2:000,
	_CR1		= _2:100,

	;;; Condition Register bits
	_CR0_lt		= _0,
	_CR0_gt		= _1,
	_CR0_eq		= _2,
	_CR1_lt		= _4,

	;;; Branch Option field
	_BO_dCTR_NZERO_AND_NOT_- = _2:00000,
	_BO_dCTR_NZERO_AND_NOT_+ = _2:00001,
	_BO_dCTR_ZERO_AND_NOT_-	 = _2:00010,
	_BO_dCTR_ZERO_AND_NOT_+	 = _2:00011,
	_BO_IF_NOT_-			 = _2:00100,
	_BO_IF_NOT_+			 = _2:00101,
	_BO_dCTR_NZERO_AND_-	 = _2:01000,
	_BO_dCTR_NZERO_AND_+	 = _2:01001,
	_BO_dCTR_ZERO_AND_-		 = _2:01010,
	_BO_dCTR_ZERO_AND_+		 = _2:01011,
	_BO_IF_-				 = _2:01100,
	_BO_IF_+				 = _2:01101,
	_BO_dCTR_NZERO_-		 = _2:10000,
	_BO_dCTR_NZERO_+		 = _2:10001,
	_BO_dCTR_ZERO_-			 = _2:10010,
	_BO_dCTR_ZERO_+			 = _2:10011,
	_BO_ALWAYS				 = _2:10100,

	;;; conditional branch opcodes on CR0
	_OP_beq		= _ConsCBrOp(_BO_IF_-,		_CR0_eq),
	_OP_beq_+	= _ConsCBrOp(_BO_IF_+,		_CR0_eq),
	_OP_bne		= _ConsCBrOp(_BO_IF_NOT_-,	_CR0_eq),
	_OP_bgt		= _ConsCBrOp(_BO_IF_-,		_CR0_gt),
	_OP_ble		= _ConsCBrOp(_BO_IF_NOT_-,	_CR0_gt),
	_OP_blt		= _ConsCBrOp(_BO_IF_-,		_CR0_lt),
	_OP_bge		= _ConsCBrOp(_BO_IF_NOT_-,	_CR0_lt),

	_R0			= _0,

	;;; popints are shifted left to accord with word scaling
	WORD_SHIFT	= integer_length(_pint(@@(w)++)) - 1,	;;; = 2 or 3
);


#_IF ##(w)[_1|d] = _1

lconstant macro (
	_OP_ldW		= ?,
	_OP_stW		= ?,
);

#_ELSE

lconstant macro (
	_OP_ldW		= _OP_ldui,
	_OP_ldWu	= _OP_lduiu,
	_OP_stW		= _OP_sti,
	_OP_stWu	= _OP_stiu,
	_OP_cmpW	= _OP_cmpw,
	_OP_cmpWi	= _OP_cmpwi,
	_OP_cmplW	= _OP_cmplw,
	_OP_cmplWi	= _OP_cmplwi,
);

#_ENDIF

lconstant macro (
	;;; double arg opcodes
	_OPS_add	= [_OP_add, _OP_addi],
	_OPS_sub	= [_OP_sub, _],				;;; subi never used
	_OPS_cmpW	= [_OP_cmpW, _OP_cmpWi],
	_OPS_cmplW	= [_OP_cmplW, _OP_cmplWi],
);


define :inline lconstant _D_inst(_Op, _Rval, _Disp, _Raddr);
	(_Disp _bimask _:16:FFFF) _biset
		( _shift(_Rval, _21) _biset _shift(_Raddr, _16) _biset _Op )
enddefine;

define :inline lconstant _X_inst(_Op, _F1, _F2, _F3);
	_Op _biset _shift(_F3, _11) _biset _shift(_F1, _21) _biset _shift(_F2, _16)
enddefine;

define :inline lconstant _XR_inst(_Op, _Rdst, _Rsrc1, _Rsrc2);
	_X_inst(_Op, _Rsrc1, _Rdst, _Rsrc2)
enddefine;

define :inline lconstant _XFX_inst(_Op, _Spec, _Rval);
	_shift(_Rval, _21) _biset _shift(_Spec, _11) _biset _Op
enddefine;

define :inline lconstant _B_inst(_Op, _Disp);
	(_Disp _bimask _:16:FFFF) _biset _Op
enddefine;

define :inline lconstant _I_inst(_Op, _Disp);
	(_Disp _bimask _:16:3FFFFFF) _biset _Op
enddefine;
