/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:			S.powaix/src/registers.ph
 > Purpose:			Logical names for Power(PC) registers (AIX)
 > Author:			John Gibson, Jan 13 1998
 */

lconstant macro (
	REG_PREFIX	= '',
	FREG_PREFIX	= '',

	RGsp		= 1,		;;; system stack pointer
	RGtoc		= 2,		;;; table of contents

	RGchain		= 3,		;;; chain_reg
	RGt7		= 4,		;;; temp 7 - 0
	RGt6		= 5,
	RGt5		= 6,
	RGt4		= 7,
	RGt3		= 8,
	RGt2		= 9,
	RGt1		= 10,
	RGt0		= 11,		;;; temp 0

	RGusp		= 12,		;;; user stack pointer

	;;; (AIX locals, 13-31)
	RGfalse		= 13,		;;; <false>
	RGsvb		= 14,		;;; special var block pointer
	RGpb		= 15,		;;; procedure base

	RGpl0		= 16,		;;; pop locals 0 - 10
	RGpl1		= 17,
	RGpl2		= 18,
	RGpl3		= 19,
	RGpl4		= 20,
	RGpl5		= 21,
	RGpl6		= 22,
	RGpl7		= 23,
	RGpl8		= 24,
	RGpl9		= 25,
	RGpl10		= 26,

	RGnpl0		= 27,		;;; nonpop locals 0 - 4
	RGnpl1		= 28,
	RGnpl2		= 29,
	RGnpl3		= 30,
	RGnpl4		= 31,
);
