/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            C.power/src/syscomp/genproc.p
 > Purpose:
 > Author:          John Gibson, Jan 14 1998
 */

/* -------------------------------------------------------------------------

				GENERATE PROCEDURE CODE -- POWER(PC) SYSTEMS

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

section $-Popas$-M_trans;

constant
		procedure (auto_operand, reg_in_operand, immediate_operand,
		commute_test, negate_test, perm_const_opnd, perm_constp_opnd,
		perm_var_opnd, cons_access_opnd, perm_const_of_svb_opnd)
	;

vars
		current_pdr_label, current_pdr_exec_label,
		false_immediate, true_immediate, nil_immediate
	;

	/****************************************************************
	* This file is contained entirely in section Genproc, and must  *
	*   define all the exports to section M_trans listed below.     *
	****************************************************************/

section Genproc =>

		/*	M-opcode Procedures */
		M_ADD,
		M_ASH,
		M_BIC,
		M_BIM,
		M_BIS,
		M_BIT,
		M_BRANCH,
		M_BRANCH_std,
		M_BRANCH_ON,
		M_BRANCH_ON_INT,
		M_CALL,
		M_CALL_WITH_RETURN,
		M_CALLSUB,
		M_CHAIN,
		M_CHAINSUB,
		M_CLOSURE,
		M_CMP,
		M_CMPKEY,
		M_CREATE_SF,
		M_END,
		M_ERASE,
		M_LABEL,
		M_LOGCOM,
		M_MOVE,
		M_MOVEbit,
		M_MOVEsbit,
		M_MULT,
		M_NEG,
		M_PADD,
		M_PADD_TEST,
		M_PCMP,
		M_PLOG_IFNOT_ATOM,
		M_PLOG_TERM_SWITCH,
		M_PSUB,
		M_PSUB_TEST,
		M_PTR_ADD_OFFS,
		M_PTR_CMP,
		M_PTR_SUB,
		M_PTR_SUB_OFFS,
		M_RETURN,
		M_SETSTKLEN,
		M_SUB,
		M_TEST,
		M_UNWIND_SF,
		M_UPDbit,

		/*	Registers */
		SP,
		USP,
		USP_+,
		-_USP,
		i_USP,
;;;		i_USP_+,			;;; these two are optional
;;;		ii_USP,
		WK_ADDR_REG_1,
		WK_ADDR_REG_2,
		WK_REG,
		CHAIN_REG,
		SPECIAL_VAR_BLOCK_REG,
		PROCEDURE_BASE_REG,

		/*	Register Lists */
		nonpop_registers,
		pop_registers,

		/*	Register Procedures */
		reglabel,
		regnumber,
		autoidreg,

		/*	M-code Mapping of Subroutines */
		mc_inline_conditions_list,
		mc_inline_procs_list,

		/*	Procedures Needed by m_optimise */
		cvt_pop_subscript,
		can_defer_opnd,
		pdr_index_opnd,

		/*	Procedure to Generate Code */
		mc_code_generator,

		/* Booleans */
		USE_NEW_M_OPERANDS,
		UNWIND_FRAME_SAVES_PB,
		BRANCH_ON_ALLOWS_BASE,
	;


;;; --- REGISTERS ---------------------------------------------------------

#_INCLUDE '../registers.ph'		;;; maps RG_ names to numbers

	/* set up regnumber and reglabel properties */
define regnumber	= newassoc([]) enddefine;
define reglabel		= newassoc([]) enddefine;

procedure;
	lvars n, l;
	for n from 0 to 31 do
		consword(REG_PREFIX sys_>< n) -> l;
		n -> regnumber(l);
		l -> reglabel(n)
	endfor
endprocedure();


	;;; assign negative reg numbers to dummy registers
-1	 -> regnumber("WK_REG");
-2	 -> regnumber("WK_ADDR_REG_1");
-3	 -> regnumber("WK_ADDR_REG_2");

lconstant
	RT0		= reglabel(RGt0),
	RT1		= reglabel(RGt1),
	RT2		= reglabel(RGt2),
	RT3		= reglabel(RGt3),
	RT4		= reglabel(RGt4),
	RT5		= reglabel(RGt5),
	RT6		= reglabel(RGt6),
	RT7		= reglabel(RGt7),
	RCHAIN	= reglabel(RGchain),
	RFALSE	= reglabel(RGfalse),
	SVB		= reglabel(RGsvb),
	PB		= reglabel(RGpb),

	R0		= reglabel(0),	;;; zero source ____only in address mode (yuk)
	;



;;;-------- DEFINITIONS FOR TRANSLATING VM CODE TO MODEL ASSEMBLER --------

	/*	m_trans.p requires the definition of
			SP, USP, USP_+, -_USP and i_USP.
	*/

constant
	SP		= reglabel(RGsp),	;;; system stack pointer
	USP		= reglabel(RGusp),	;;; user stack pointer
	i_USP	= {^USP 0},			;;; top of user stack
	-_USP	= {^USP ^false},	;;; user stack autodecrement
	USP_+	= {^USP ^true},		;;; user stack autoincrement

	macro UNWIND_FRAME_SAVES_PB = true,
	;;; required when UNWIND_FRAME_SAVES_PB is true
	PROCEDURE_BASE_REG = PB,
	;


	/*	WK_REG is used by m_optimise for eliminating stack pushes and pops
		between successive instructions
	*/
constant
	WK_REG = "WK_REG";


	/*	WK_ADDR_REG_1 and 2 are used by m_optimise for building field
		access operands (ie of the the form {^reg ^offset} ) when an existing
		operand cannot be deferred directly (can_defer_operand having
		returned false for it). 1 is used for source operands, 2 for
		destination operands
	*/
constant
	WK_ADDR_REG_1 = "WK_ADDR_REG_1",
	WK_ADDR_REG_2 = "WK_ADDR_REG_2";


	/*	CHAIN_REG is the register used to save procedure operands for in-line
		chaining, and must not be corrupted by M_UNWIND_SF (ideally it should
		be an address register). It is also used to save return addresses for
		out-of-line chaining thru the subroutines _syschain and _sysncchain.
	*/
constant
	CHAIN_REG	= reglabel(RGchain);


	/*	SPECIAL_VAR_BLOCK_REG is optional; if defined, it's assumed to
		hold the address of _special_var_block.
	*/
constant
	SPECIAL_VAR_BLOCK_REG	= SVB;


	/*	m_optimise needs lists of pop and nonpop registers,
		in order of allocation; these lists start with a list of
		registers that should be local to every procedure.
		It also needs the properties regnumber and reglabel.
	*/
constant
	pop_registers		= [[] ^RGpl0 ^RGpl1 ^RGpl2 ^RGpl3 ^RGpl4 ^RGpl5
							  ^RGpl6 ^RGpl7 ^RGpl8 ^RGpl9 ^RGpl10],
	nonpop_registers	= [[] ^RGnpl0 ^RGnpl1 ^RGnpl2 ^RGnpl3 ^RGnpl4];


	/*	The procedure autoidreg is used by m_optimise in deciding
		whether a register can be used for autoincrement/decrement operands,
		ie of the form {^reg ^boolean}.
	*/
identof("regnumber") -> identof("autoidreg");


	/*	Setting this true means generate typed M-code vector operands for
		short and and byte memory access/updates (instead of the old
		M_MOVE(s)b/s and M_UPDb/s instructions). The operands have the form

			{____base ______offset ____type}

		where ____type is T_BYTE, T_SGN_BYTE, T_SHORT or T_SGN_SHORT (word access
		operands are always length 2). As well as a register, ____base may a
		string (i.e. absolute address), in which case any offset is
		concatenated onto the string and ______offset is 0.
	*/
constant macro USE_NEW_M_OPERANDS = true;

	/*	Setting this true means M_BRANCH_ON(_INT) instructions allow
		an optional extra element to specify the base integer (defaults to 1).
	*/
constant macro BRANCH_ON_ALLOWS_BASE = true;


	/*	can_defer_operand is used by m_optimise to create a field access
		operand from an existing operand, ie accessing/updating the datum
		of type _______acctype at offset ____offs from the pointer held in the operand.
		(Takes 4 args with USE_NEW_M_OPERANDS true.)
	*/
define can_defer_opnd(opnd, offs, acctype, upd);
	lvars opnd, acctype, offs, upd;
	if isref(opnd) then
		;;; immediate label
		fast_cont(opnd) -> opnd
	elseunless regnumber(opnd) then
		return(false)
	endif;
	chain(opnd, offs, acctype, cons_access_opnd)
enddefine;

define lconstant wof = nonop fi_*(% WORD_OFFS %) enddefine;

	/*	pdr_index_opnd is used by m_trans.p for creating operands to
		push/call values from procedure headers (not used in closures).
	*/
define pdr_index_opnd(fld_index);
	lvars fld_index;
	cons_access_opnd(PB, fld_index.wof, T_WORD)
enddefine;



;;; --- M-CODE TRANSLATION PROCEDURES ----------------------------------------

define lconstant test_opcode = newassoc([%
	[LT  [blt]],	[LEQ  [ble]],
	[GT  [bgt]],	[GEQ  [bge]],
	[ULT  [blt]],	[ULEQ  [ble]],
	[UGT  [bgt]],	[UGEQ  [bge]],
	[EQ  [beq]],	[NEQ  [bne]],
	[NEG [blt]],	[POS  [bge]],
	[OVF [bso]],	[NOVF [bns]],
%])
enddefine;


lconstant macro POPINT0 = popint(0);

lvars
		m_codelist, m_instr, last_ipair, instr_list, new_literals,
		closure_frozlist,
		unique_labels = false,
	;


define lconstant placei() with_nargs 1;
	() :: [] ->> f_tl(last_ipair) -> last_ipair
enddefine;

	;;; for non-nil instruction list
define lconstant placel(list);
	lvars list;
	list -> f_tl(last_ipair);
	until f_tl(list) == [] do f_tl(list) -> list enduntil;
	list -> last_ipair
enddefine;

define lconstant place1();
	placei(consvector(1))
enddefine;

define lconstant place2();
	placei(consvector(2))
enddefine;

define lconstant place3();
	placei(consvector(3))
enddefine;

define lconstant place4();
	placei(consvector(4))
enddefine;

define lconstant place5();
	placei(consvector(5))
enddefine;


lconstant
	;;; what dummy registers with -ve numbers are actually allocated to
	dummy_reg_alloc = writeable initv(3),

	OP_label	= [label],
	OP_b		= [b],
	OP_bl		= [bl],
	OP_ba		= [ba],
	OP_bla		= [bla],
	OP_bctrl	= [bctrl],
	OP_bctr		= [bctr],

	OP_ldI		= [lwz],
	OP_ldIu		= [lwzu],
	OP_stI		= [stw],
	OP_stIu		= [stwu],
	OP_ldA		= "la",
	OP_ldAH		= "addis",
	OP_blr		= [blr],
	;

#_IF WORD_BITS==DOUBLE_BITS
lconstant
	OP_ldW		= OP_ldq,
	OP_stW		= OP_stq,
	OP_negW		= "negq",
	OP_mulW		= "mulq",
;
#_ELSE
lconstant
	OP_ldW		= OP_ldI,
	OP_ldWu		= OP_ldIu,
	OP_stW		= OP_stI,
	OP_stWu		= OP_stIu,
	OP_negW		= "negl",
	OP_mulW		= "mull",
;
#_ENDIF

define lconstant update_op =
	newassoc([[^OP_ldW ^OP_ldWu] [^OP_stW ^OP_stWu]])
enddefine;


lvars
	;;; temp register queue
	tmpreg_list = [],

	;;; literal register queue
	litreg_list = [],

	;;; running userstack difference
	curr_stack_diff,
	;

define lconstant is_store_op(op);
	if ispair(op) then fast_front(op) -> op endif;
	isstartstring('st', op)
enddefine;

define lconstant make_update_op(op) -> uop;
	unless update_op(op) ->> uop then
		if ispair(op) then
			(fast_front(op) <> "u") :: []
		else
			op <> "u"
		endif ->> uop -> update_op(op)
	endunless
enddefine;

define lconstant init_reg();
	sys_grbg_list(tmpreg_list);
	[^RT0 ^RT3 ^RT4 ^RT5 ^RT6 ^RT7] -> tmpreg_list;
	false, false, false -> explode(dummy_reg_alloc);
	sys_grbg_list(litreg_list);
	[] -> litreg_list
enddefine;

define lconstant free_reg(reg);
	lvars reg, pair;
	returnunless(reg);
	if fast_lmember(reg, tmpreg_list) then
		mishap(0, 'SYSTEM ERROR IN free_reg')
	endif;
	tmpreg_list nc_<> (reg :: []) -> tmpreg_list
enddefine;

define lconstant get_free_litreg();
	lvars l = litreg_list, lst = false, lp;
	until l == [] do
		f_tl(f_tl(l)) -> lp;
		unless f_hd(lp) then
			f_tl(lp) -> if lst then f_tl(lst) else litreg_list endif;
			return(f_hd(l))
		endunless;
		lp -> lst;
		f_tl(lp) -> l
	enduntil;
	false
enddefine;

define lconstant alloc_reg() -> reg;
	lvars reg;
	if tmpreg_list /== [] then
		sys_grbg_destpair(tmpreg_list) -> (reg, tmpreg_list)
	elseunless get_free_litreg() ->> reg then
		mishap(0, 'SYSTEM ERROR IN alloc_reg')
	endif
enddefine;

define lconstant trans_reg(opnd, isdst) -> opnd;
	lvars opnd, isdst, i, reg;
	returnunless((regnumber(opnd) ->> i) and i fi_< 0);
	-i -> i;
	f_subv(i,dummy_reg_alloc) -> reg;
	if isdst == true or isdst and not(reg) then
		free_reg(reg);
		alloc_reg() ->> opnd -> f_subv(i,dummy_reg_alloc)
	elseunless reg ->> opnd then
		mishap(0, 'SYSTEM ERROR IN trans_reg')
	endif
enddefine;

define lconstant exclude_reg(reg);
	lvars reg;
	unless fast_lmember(reg, tmpreg_list) then
		mishap(0, 'SYSTEM ERROR IN exclude_reg')
	endunless;
	fast_ncdelete(reg, tmpreg_list) -> tmpreg_list
enddefine;

define lconstant dealloc_dummy_reg();
	lvars i, v = dummy_reg_alloc;
	fast_for i to 3 do
		free_reg(f_subv(i,v));
		false -> f_subv(i,v)
	endfor;
	litreg_list -> i;
	until i == [] do
		free_reg(f_dest(i) -> i);
		f_tl(f_tl(i)) -> i
	enduntil;
	sys_grbg_list(litreg_list);
	[] -> litreg_list
enddefine;

define lconstant fast_=_lmember(item, list);
	lvars list, item;
	until list == [] do
		returnif(fast_front(list) = item) (list);
		fast_back(list) -> list
	enduntil;
	false
enddefine;

define lconstant fast_nmember(item, list);
	lvars list, item, n = 1;
	until list == [] do
		returnif(fast_front(list) = item) (n);
		fast_back(list) -> list;
		n fi_+ 1 -> n
	enduntil;
	false
enddefine;

define lconstant consregacc(reg, offs) -> opnd;
	lvars reg, offs, opnd, procedure prop;

	define lconstant USP_prop = newproperty([], 4, false, false) enddefine;
	define lconstant SP_prop = newproperty([], 4, false, false) enddefine;
	define lconstant PB_prop = newproperty([], 4, false, false) enddefine;

	if     reg == USP then USP_prop -> prop
	elseif reg == SP then  SP_prop -> prop
	elseif reg == PB then  PB_prop -> prop
	else
		return(consvector(reg, offs, 2) -> opnd)
	endif;
	unless prop(offs) ->> opnd then
		consvector(reg, offs, 2) ->> opnd -> prop(offs)
	endunless
enddefine;

define lconstant load_literal(reg, lit);
	lvars reg, lit, lab, n, id;

	define ld_pb_opnd(/*op, reg, lab*/);
		consref(/*lab*/);
		place3()
	enddefine;

	define within_range(lab);
		lvars lab, offs;
		(asm_label_offsets(lab) ->> offs)
		and (offs>>2)-subscrv(asmseg_nonwriteable,asm_seg_offsets) >= -16:8000
		and offs&&3 == asmseg_nonwriteable
	enddefine;

	define load_lit(lit);
		lvars lab;
		unless (pdr_literal_label(lit) ->> lab)
		and (within_range(lab) or fast_=_lmember(lit,new_literals)) then
			new_literals nc_<> (lit :: []) -> new_literals;
			nextlab() ->> lab -> pdr_literal_label(lit)
		endunless;
		ld_pb_opnd(OP_ldW, reg, lab)
	enddefine;

	if isref(lit) then
		fast_cont(lit) -> lit;
;;;		if islabel(lit) &&/=_0 LAB_EXTERN then
;;;			;;; put external labels in writeable mem
;;;			unless pdr_literal_label(lit) ->> id then
;;;				new_lex_id(true, "lex") -> id;		;;; true = nonpop
;;;				lit -> idval(id);
;;;				id -> pdr_literal_label(lit);
;;;			endunless;
;;;			genstructure(id) -> lit;
;;;			load_lit(lit);
;;;			place3(OP_ldW, reg, consregacc(reg, 0));
;;;			return
;;;		endif
	endif;
	if lit == current_pdr_label then
		unless reg == PB then ld_pb_opnd(OP_ldA, reg, lit) endunless
	elseif within_range(lit) then
		ld_pb_opnd(OP_ldA, reg, lit)
	else
		if closure_frozlist and fast_nmember(lit, closure_frozlist) ->> n then
			place3(OP_ldW, reg,
					consregacc(PB, wof(field_##("PD_CLOS_FROZVALS")+n-1) ));
			return
		endif;
		load_lit(lit)
	endif
enddefine;

	;;; Get a register to cache a literal in
define lconstant get_litreg(lit, alloc);
	lvars l = litreg_list, lp, lit, reg, alloc;
	until l == [] do
		if (f_dest(f_tl(l)) -> lp) = lit then
			true -> f_hd(lp);
			return(f_hd(l))
		endif;
		f_tl(lp) -> l
	enduntil;
	returnunless(alloc) (false);

	alloc_reg() -> reg;
	load_literal(reg, lit);
	litreg_list nc_<> [^reg ^lit ^true] -> litreg_list;
	reg
enddefine;

define lconstant set_litreg_unused();
	lvars l = litreg_list, lp, n = -2;
	until l == [] do
		f_tl(f_tl(l)) -> lp;
		false -> f_hd(lp);
		f_tl(lp) -> l;
		n fi_+ 1 -> n
	enduntil;
	fast_repeat n times free_reg(get_free_litreg()) endrepeat
enddefine;

define lconstant normalise_int(i) -> i;
	lvars i, ilen = integer_length(i);
	if ilen >= WORD_BITS then
		if ilen == WORD_BITS and i > 0 then
			;;; allow 'unsigned' WORD_BITS value as -ve
			i || #_< -1<<WORD_BITS >_# -> i
		else
			mishap(i, 1, 'INTEGER OPERAND TOO LARGE')
		endif
	endif
enddefine;

define lconstant place_regacc(Op, Rval, Disp, Raddr);
	lvars Op, Rval, Disp, Raddr, Rtmp, sgn, hi, store;
	lconstant HIMASK = -1 << 16;

	define lconstant regacc_inst(Op, Rval, Disp, Raddr);
		if Op == OP_ldAH or Op == "ori" then
			chain(Op, Rval, Raddr, Disp, place4)
		else
			chain(Op, Rval, consregacc(Raddr, Disp), place3)
		endif
	enddefine;

	if isintegral(Disp) then
		normalise_int(Disp) -> Disp;
#_IF WORD_BITS==DOUBLE_BITS
		unless integer_length(Disp) < INT_BITS then
			mishap(Disp, 1, 'INTEGER DISPLACEMENT TOO LARGE')
		endunless
#_ENDIF
	endif;

	if isintegral(Disp) and (Disp >> 15 ->> sgn) /== 0 and sgn /== -1 then
		;;; hi part is not simple sign-extension of lo part
		sgn >> 1 -> hi;
		if Op == OP_ldA and Disp &&=_0 16:FFFF then
			hi -> Disp;
			OP_ldAH -> Op
		else
			is_store_op(Op) -> store;
			if store then alloc_reg() else Rval endif -> Rtmp;
			if Op == OP_ldA and Raddr == R0 then
				;;; can use "ori" for lo 16 bits
				"ori" -> Op;
				Disp &&~~ HIMASK
			elseif sgn &&/=_0 1 then
				;;; lo will be sign-extended to negative, effectively
				;;; subtracting 1 from hi -- add 1 to compensate
				if hi /== 16:7FFF then
					hi+1 -> hi
				else
					;;; adding 1 would overflow, so need a 3rd instruction
					regacc_inst(OP_ldAH, Rtmp, 1, Raddr);
					Rtmp -> Raddr
				endif;
				Disp || HIMASK
			else
				Disp &&~~ HIMASK
			endif -> Disp;
			regacc_inst(OP_ldAH, Rtmp, hi, Raddr);
			Rtmp -> Raddr;
			if store then free_reg(Rtmp) endif
		endif
	endif;

	regacc_inst(Op, Rval, Disp, Raddr)
enddefine;

define lconstant stack_adjust();
	if curr_stack_diff /== 0 then
		place_regacc(OP_ldA, USP, curr_stack_diff, USP);
		0 -> curr_stack_diff
	endif
enddefine;

define lconstant place_label(lab);
	lvars lab;
	place2(OP_label, lab)
enddefine;

lconstant procedure (
	isreg		= isword,
	isaccess	= isvector,
	);

define lconstant mem_access_type(opnd);
	lvars opnd;
	if isstring(opnd) then
		T_WORD
	elseif isaccess(opnd) then
		if datalength(opnd) == 2 then T_WORD else f_subv(3, opnd) endif
	else
		false
	endif
enddefine;

define lconstant isabs(opnd);
	lvars opnd, hi, lo;
	(isstring(opnd) or isaccess(opnd) and isstring(f_subv(1,opnd) ->> opnd))
	and opnd
enddefine;

	;;; get an already-cached address operand
define lconstant get_cached_opnd(opnd);
	lvars opnd, lab, reg;
	if isabs(opnd) ->> lab then
		if get_litreg(lab, false) ->> reg then
			cons_access_opnd(reg, 0, mem_access_type(opnd))
		else
			opnd
		endif
	else
		get_litreg(opnd, false) or opnd
	endif
enddefine;

define lconstant get_us_offset(opnd) -> offs;
	lvars offs, opnd;
	unless f_subv(2,opnd) ->> offs then
		;;; false = -_USP
		curr_stack_diff fi_- WORD_OFFS ->> offs -> curr_stack_diff
	elseif offs == true then
		;;; true = USP_+
		curr_stack_diff -> offs;
		offs fi_+ WORD_OFFS -> curr_stack_diff
	else
		curr_stack_diff fi_+ offs -> offs
	endunless
enddefine;

define lconstant place_test(test, lab);
	stack_adjust();
	place2(test_opcode(test), lab)
enddefine;


;;; --- LOAD AND STORE OPERANDS -------------------------------------------

define lconstant type_opcodes = newassoc([%
	[^T_BYTE		{[lbz]		[stb]}],
	[^T_SGN_BYTE	{[lbz]		[stb]}],
	[^T_SHORT		{[lhz]		[sth]}],
	[^T_SGN_SHORT	{[lha]		[sth]}],
#_IF WORD_BITS==DOUBLE_BITS
	[^T_INT			{^OP_ldI	^OP_stI}],
	[^T_SGN_INT		{^OP_ldI	^OP_stI}],
	[^T_DOUBLE		{^OP_ldq	^OP_stq}],
#_ELSE
	[^T_INT			{^OP_ldI	^OP_stI}],
;;;	[^T_INT_DOUBLE	{^OP_ldI	^OP_stq}],
#_ENDIF
%])
enddefine;


define lconstant load_src(dst_reg, opnd) -> (dst_reg, dst_tmp);
	lvars reg, offs, inc, lab, type;
	dlvars dst_reg, dst_tmp = false;

	define lconstant get_dst();
		if dst_reg then
			trans_reg(dst_reg, true)
		else
			alloc_reg() ->> dst_tmp
		endif -> dst_reg
	enddefine;


	if isreg(opnd) then
		if opnd == USP then stack_adjust() endif;
		trans_reg(opnd, false) -> dst_reg

	elseif isintegral(opnd) then
		get_dst();
#_IF WORD_BITS==DOUBLE_BITS
		if integer_length(normalise_int(opnd) ->> opnd) >= INT_BITS then
			load_literal(dst_reg, opnd);
			return
		endif;
#_ENDIF
		place_regacc(OP_ldA, dst_reg, opnd, R0)
	elseif opnd = false_immediate then
		RFALSE -> dst_reg
	elseif opnd = true_immediate or opnd = nil_immediate then
		wof(datasize(false)) -> inc;
		if opnd = nil_immediate then inc fi_+ inc -> inc endif;
		get_dst();
		place_regacc(OP_ldA, dst_reg, inc, RFALSE)
	elseif isref(opnd) then
		;;; address constant
		if get_litreg(opnd, not(dst_reg)) ->> reg then
			reg -> dst_reg
		else
			get_dst();
			load_literal(dst_reg, opnd)
		endif
	elseif mem_access_type(opnd) ->> type then
		false -> inc;
		if isabs(opnd) ->> lab then
			;;; absolute address
			0 -> offs;
			get_litreg(lab, true) -> reg
		else
			f_subv(2,opnd) -> offs;
			if (trans_reg(f_subv(1,opnd), false) ->> reg) == USP then
				;;; userstack access
				get_us_offset(opnd) -> offs
			elseif isboolean(offs) then
				;;; predecr/postincr
				t_offset(type, false) -> inc;		;;; data size
				if offs then 0 else -inc ->> inc endif -> offs
			endif
		endif;
		get_dst();
		lvars opcodes = type_opcodes(type);
		place_regacc(subscrv(1,opcodes), dst_reg, offs, reg);
		if type == T_SGN_BYTE then
			place4("slwi", dst_reg, dst_reg, 24);
			place4("srawi", dst_reg, dst_reg, 24);
		endif;
		if inc then place_regacc(OP_ldA, reg, inc, reg) endif
	else
		mishap(opnd, 1, 'INVALID SOURCE OPERAND IN M-INSTRUCTION')
	endif
enddefine;

define lconstant store_dst(src_reg, opnd, src_istmp);
	lvars	opnd, reg, src_reg, offs, lab, type, inc, save, src_istmp,
			used_tmp = false;

	if isreg(opnd) then
		trans_reg(opnd, true) -> opnd;
		if opnd == USP then
			0 -> curr_stack_diff
		endif;
		return(false, opnd, used_tmp)
	elseunless mem_access_type(opnd) ->> type then
		mishap(opnd, 1, 'INVALID DESTINATION OPERAND IN M-INSTRUCTION')
	endif;

	lvars opcode = subscrv(2,type_opcodes(type));
	last_ipair -> save;
	if isabs(opnd) ->> lab then
		;;; absolute address
		0 -> offs;
		get_litreg(lab, true) -> reg
	else
		f_subv(2,opnd) -> offs;
		if (trans_reg(f_subv(1,opnd), false) ->> reg) == USP then
			;;; userstack access
			get_us_offset(opnd) -> offs;
			unless f_subv(2,opnd) or offs == 0 then
				make_update_op(opcode) -> opcode;
				0 -> curr_stack_diff
			endunless
		elseif isboolean(offs) then
			;;; predecr/postincr
			t_offset(type, false) -> inc;		;;; data size
			if offs then
				-inc -> offs;
				place_regacc(OP_ldA, reg, inc, reg)
			else
				-inc -> offs;
				make_update_op(opcode) -> opcode
			endif
		endif
	endif;
	unless src_reg then
		alloc_reg() ->> src_reg ->> src_istmp -> used_tmp
	endunless;
	place_regacc(opcode, src_reg, offs, reg);
	(f_tl(save), src_reg, used_tmp);
	[] -> f_tl(save);
	save -> last_ipair
enddefine;


;;; --- MOVE INSTRUCTIONS --------------------------------------------------

define lconstant do_move(src, dst);
	lvars src, reg, dst, tmp;
	returnif(src = dst or (src == USP_+ and dst == -_USP));
	if isreg(dst) then
		load_src(dst, src) -> (reg, );
		trans_reg(dst, "undef") -> dst;
		if reg /== dst then place3("mr", dst, reg) endif;
		if dst == USP then 0 -> curr_stack_diff endif
	else
		if isreg(src) then
			trans_reg(src, false), false
		else
			get_cached_opnd(dst) -> dst;
			load_src(false, src)
		endif -> (src, tmp);
		placel(store_dst(src, dst, tmp) -> (,));
		free_reg(tmp)
	endif
enddefine;

define M_MOVE();
	do_move(f_subv(2, m_instr), f_subv(3, m_instr))
enddefine;

define lconstant move_wkreg_result(dst, reg);
	lvars dst;
	exclude_reg(reg);
	if isreg(dst) then
		reg :: tmpreg_list -> tmpreg_list;
		do_move(reg, dst)
	else
		do_move(reg, dst);
		free_reg(reg)
	endif
enddefine;

define lconstant move_rt0_result = move_wkreg_result(% RT0 %) enddefine;

define lconstant call_or_chain_reg(reg, iscall);
	stack_adjust();
	place2("mtctr", reg);			;;; move to count reg
	place1(if iscall then OP_bctrl else OP_bctr endif);
	dealloc_dummy_reg()
enddefine;

define lconstant call_or_chain_lab(lab, iscall);
	stack_adjust();
	place2(if iscall then OP_bl else OP_b endif, lab);
	dealloc_dummy_reg()
enddefine;

	;;; {M_MOVE(s)bit _________fieldsize _______bitoffs ___ptr ___dst}
define lconstant get_bitfield(routine);
	lvars routine, (, fieldsize, bitoffs, ptr, dst) = explode(m_instr);
#_IF DEF NO_ABS_CALLS
	load_literal(RCHAIN, symlabel(routine));
#_ENDIF
	do_move(fieldsize, RT2);
	do_move(bitoffs, RT1);
	do_move(ptr, RT0);
#_IF DEF NO_ABS_CALLS
	call_or_chain_reg(RCHAIN, true);
#_ELSE
	stack_adjust();
	place2(OP_bl, symlabel(routine));
	dealloc_dummy_reg();
#_ENDIF
	move_rt0_result(dst)
enddefine;

define M_MOVEbit	= get_bitfield(%"\^_bfield"%)  enddefine;
define M_MOVEsbit	= get_bitfield(%"\^_sbfield"%) enddefine;

	;;; {M_UPDbit _________fieldsize _______bitoffs ___ptr ___src}
define M_UPDbit();
	lvars (, fieldsize, bitoffs, ptr, src) = explode(m_instr);
#_IF DEF NO_ABS_CALLS
	load_literal(RCHAIN, symlabel("\^_ubfield"));
#_ENDIF
	do_move(fieldsize, RT2);
	do_move(bitoffs, RT1);
	if src /== USP_+ then do_move(src, -_USP) endif;
	do_move(ptr, RT0);
#_IF DEF NO_ABS_CALLS
	call_or_chain_reg(RCHAIN, true)
#_ELSE
	stack_adjust();
	place2(OP_bl, symlabel("\^_ubfield"));
	dealloc_dummy_reg();
#_ENDIF
enddefine;

define M_ERASE();
	lvars src = f_subv(2, m_instr), tmp;
	if auto_operand(src) then
		do_move(src, alloc_reg() ->> tmp);
		free_reg(tmp)
	endif
enddefine;


;;; --- ARITH INSTRUCTIONS ---------------------------------------------

lvars
	arith3_do_stkadjust = false,
;

define lconstant do_arith3(src2, src1, dst, op);
	lvars storel, tmp, tmp1, tmp2, tmp3, dot = false;

	if isword(op) and last(op) == `.` then
		allbutlast(1,op) -> op;
		true -> dot
	endif;

	;;; first replace any cached address operand in ____src1
	;;; or ___dst so it's not overwritten by loading ____src2, etc
	get_cached_opnd(src1) -> src1;
	if dst then get_cached_opnd(dst) -> dst endif;

	;;; load src operands into registers, etc


	define get_immediate(int, op);
		lvars i, signed, newop;
		returnunless(fast_lmember(op, [add and or xor slw sraw cmpw cmplw]))
												(false);
		op == "cmpw" or op == "add" -> signed;
		unless signed then int &&~~ (-1 << WORD_BITS) -> int endunless;
		int -> i;
		if i &&=_0 16:FFFF and i /== 0 and not(isstartstring("cmp", op)) then
			i >> 16 -> i;
			op <> "is"
		else
			op <> "i"
		endif -> newop;
		if signed then
			;;; signed
			returnif(-16:8000 <= i and i <= 16:7FFF) (i, false, newop, true)
		else
			;;; unsigned
			returnif(0 <= i and i <= 16:FFFF) (i, false, newop, true);

			define contig_bits(int);
				lvars i = int &&~~ (-1 << WORD_BITS), int = i;
				returnif(i == 0) (false);
				i + (1<<integer_leastbit(i)) -> i;
				i &&~~ (i-1) = i and int
			enddefine;

			returnif(op == "and" and int /== 0
					and (contig_bits(int) or contig_bits(~~int)))
						(int, false, "rlwinm", true);
		endif;
		false
	enddefine;

	if isintegral(src2) then
		normalise_int(src2) -> src2;
		if op == "sub" then
			-src2 -> src2;
			"add" -> op
		elseif op == "andc" then
			~~src2 -> src2;
			"and" -> op
		endif;
		if get_immediate(src2, op) then
			() -> op
		else
			load_src(false, src2)
		endif
	else
		load_src(false, src2)
	endif -> (src2, tmp2);

	load_src(false, src1) -> (src1, tmp1);

	if arith3_do_stkadjust then stack_adjust() endif;

	if dst then
		;;; get destination reg and possible store instruction
		tmp1 or tmp2 -> tmp;
		store_dst(tmp, dst, tmp)
	else
		false, false, false
	endif -> (storel, dst, tmp3);

	;;; place operation
	if isprocedure(op) then
		op(src1, src2, dst)
	else
		;;; __op is opcode
		lvars aop = op;
		if op == "sub" then "subc" -> aop endif;
		if dot or op == "andi" or op == "andis" then aop <> "." -> aop endif;
		if op == "rlwinm" then
			place5(aop, dst, src1, 0, src2)
		else
			place4(aop, dst or 0, src1, src2)
		endif
	endif;

	;;; and store if necessary
	if storel then placel(storel) endif;

	free_reg(tmp1); free_reg(tmp2); free_reg(tmp3);
enddefine;

define lconstant arith3_instr(op);
	do_arith3(explode(m_instr), op) ->	/*Mpdr*/
enddefine;

define M_ADD	= arith3_instr(% "add" %)  enddefine;
define M_SUB	= arith3_instr(% "sub" %)  enddefine;
define M_BIS	= arith3_instr(% "or" %)   enddefine;
define M_BIM	= arith3_instr(% "and" %)  enddefine;
define M_BIC	= arith3_instr(% "andc" %) enddefine;

define lconstant arith2_instr(op);
	lvars (, src, dst) = explode(m_instr), storel, tmp, tmp2;
	if isintegral(src) then
		if op == "neg" then -src else ~~src endif -> src;
		do_move(src, dst);
		return
	endif;

	load_src(false, src) -> (src, tmp);
	;;; get destination reg and possible store instruction
	store_dst(tmp, dst, tmp) -> (storel, dst, tmp2);

	;;; place operation
	place3(op, dst, src);
	;;; and store if necessary
	if storel then placel(storel) endif;

	free_reg(tmp); free_reg(tmp2);
enddefine;

define M_NEG	= arith2_instr(% "neg" %) enddefine;
define M_LOGCOM	= arith2_instr(% "not" %) enddefine;

define lconstant ptr_arith_instr(op);
	lvars op;
	do_arith3(explode(m_instr), op) -> (/*Mpdr*/, /*type*/)
enddefine;

define M_PTR_ADD_OFFS	= ptr_arith_instr(% "add" %) enddefine;
define M_PTR_SUB_OFFS 	= ptr_arith_instr(% "sub" %) enddefine;
define M_PTR_SUB		= ptr_arith_instr(% "sub" %) enddefine;

define M_ASH();
	lvars (, shift, src, dst) = explode(m_instr), op;

	define lconstant varshift(src, shift_src, dst);
		lvars tmp1 = alloc_reg(), lab = genlab(), tmp2 = false, d;
		place3("neg\.", tmp1, shift_src);		;;; negate and test into tmp1
		if dst == src then dup(alloc_reg()) else dst, false endif -> (d, tmp2);
		place4("slw", d, src, shift_src);
		place2([ble], lab);
		place4("sraw", d, src, tmp1);
		place_label(lab);
		if tmp2 then place3("mr", dst, tmp2) endif;
		free_reg(tmp1);
		free_reg(tmp2);
	enddefine;

	if isinteger(shift) then
		"slw" -> op;
		if shift fi_< 0 then "sraw" -> op, -shift -> shift endif
	else
		varshift -> op
	endif;
	do_arith3(shift, src, dst, op)
enddefine;

define M_MULT();
	lvars (_, src2, src1, dst) = explode(m_instr);
	get_cached_opnd(src1) -> src1;
	do_move(src2, RCHAIN);		;;; = R3
	do_move(src1, RT7);			;;; = R4
	place2(OP_bla, '.__mull');	;;; uses R0, R3, R4. Result in R4
	dealloc_dummy_reg();
	move_wkreg_result(dst, RT7)
enddefine;


;;; --- POP ARITHMETIC ------------------------------------------------

define lconstant do_parith3(src2, src1, dst, op, ovf_test, lab);
	lvars n, src2, src1, dst, op, ovf_test, lab, general = false;

	define lconstant parith(src1, src2, dst);
		lvars src1, src2, dst, tmp1 = false;
		if general then
			place4("addi", alloc_reg()->>tmp1, src2, -POPINT0);
			tmp1 -> src2
		endif;
		if op == "sub" then "subc" -> op endif;
		place4(if ovf_test then op <> "'o.'" else op endif, dst, src1, src2);
		free_reg(tmp1)
	enddefine;

	if isintegral(src2) then
		src2 - POPINT0 -> src2
	elseif isintegral(src1) then
		if op == "sub" then
			;;; subtracting
			src1 + POPINT0 -> n;
			if src1 > 0 and integer_length(n) fi_>= WORD_BITS then
				;;; adding tags to it overflows
				true -> general
			else
				n -> src1
			endif
		else
			;;; adding
			src1 - POPINT0 -> src1
		endif
	else
		true -> general
	endif;

	do_arith3(src2, src1, dst, if ovf_test or general then parith
								else op
								endif);

	if ovf_test then place_test(ovf_test, lab) endif
enddefine;

define lconstant parith3_instr(op);
	lvars op;
	do_parith3(explode(m_instr), op, false, false) -> /*Mpdr*/
enddefine;

define M_PADD	= parith3_instr(% "add" %) enddefine;
define M_PSUB	= parith3_instr(% "sub" %) enddefine;

define lconstant parith_test_instr(op);
	lvars test, lab, op;
	do_parith3(explode(m_instr) -> (test, lab), -_USP, op, test, lab)
											-> /*Mpdr*/
enddefine;

define M_PADD_TEST	= parith_test_instr(% "add" %) enddefine;
define M_PSUB_TEST	= parith_test_instr(% "sub" %) enddefine;


;;; --- TEST/COMPARE/BIT TEST INSTRUCTIONS -----------------------------------

define lconstant do_test(src, test, lab);
	lvars (src, tmp) = load_src(false, src);
	place4("cmpwi", 0, src, 0);
	place_test(test, lab);
	free_reg(tmp)
enddefine;

define M_TEST();
	do_test(explode(m_instr)) -> /*Mpdr*/
enddefine;

define lconstant do_arith_test(src2, src1, test, lab, op);
	lvars dst = R0;
	if op == "cmpw" or op == "cmplw" then
		if isintegral(src1) then
			(src1, src2) -> (src2, src1)
		else
			commute_test(test) -> test
		endif;
		if test(1) == `U` then "cmplw" -> op endif;
		false -> dst
	endif;

	if mem_access_type(src1) or mem_access_type(src2) then
		dlocal arith3_do_stkadjust = true;
	endif;
	do_arith3(src2, src1, dst, op);
	place_test(test, lab)
enddefine;

define M_CMP();
	do_arith_test(explode(m_instr), "cmpw") -> /*Mpdr*/
enddefine;

define M_PCMP	= M_CMP enddefine;		;;; compare popints is the same

define M_BIT();
	do_arith_test(explode(m_instr), "and\.") -> /*Mpdr*/
enddefine;

	;;; compare pointers -- same as integers for all types
define M_PTR_CMP();
	M_CMP() -> /* Mpdr, type already erased */
enddefine;

define M_CMPKEY();
	lvars	(, key, src, test, lab) = explode(m_instr), tlab, key_opnd,
			tmp1, tmp2, wasmem;

	if test == "EQ" then genlab() else lab endif -> tlab;
	unless isintegral(key) then get_cached_opnd(key) -> key endunless;
	mem_access_type(src) -> wasmem;
	load_src(false, src) -> (src, tmp1);
	if wasmem then stack_adjust() endif;
	do_arith_test(1, src, "NEQ", tlab, "and\.");

	cons_access_opnd(src, field_##("KEY").wof, T_WORD) -> key_opnd;

	if isintegral(key) then
		;;; testing flag(s) nonzero in K_FLAGS field
		load_src(tmp1, key_opnd) -> (src, tmp2);
		do_arith_test(key,
			cons_access_opnd(src, field_##("K_FLAGS")*INT_OFFS, T_INT),
										negate_test(test), lab, "and\.");
		free_reg(tmp2)
	else
		;;; test for specific key
		do_arith_test(key, key_opnd, test, lab, "cmpw")
	endif;
	free_reg(tmp1);
	if test == "EQ" then place_label(tlab) endif
enddefine;


;;; --- OTHER BRANCH INSTRUCTIONS -------------------------------------

define M_BRANCH();
	stack_adjust();
	place2(OP_b, f_subv(2,m_instr))
enddefine;

	;;; Branch instruction of standard size
define M_BRANCH_std();
	place2(OP_b, f_subv(2,m_instr))
enddefine;

define lconstant do_branch_on(isint);
	lvars	isint, lim, src, srctmp, tmp1 = alloc_reg(), tmp2 = alloc_reg(),
			afterlab = genlab(), pclab = genlab(), lab, base_subscr, base,
			lablist = f_subv(3,m_instr), org_src;

	if isint then 4 else 5 endif -> base_subscr;
	if datalength(m_instr) == base_subscr then
		f_subv(base_subscr,m_instr)
	else
		1
	endif -> base;

	load_src(false, f_subv(2,m_instr)) -> (src, srctmp);
	src -> org_src;
	stack_adjust();
	unless 0 <= base and base <= 4 then
		do_arith3(if isint then base else base<<WORD_SHIFT endif, src,
								tmp1 ->> src, "sub");
		0 -> base
	endunless;

	listlength(lablist)+base-1 -> lim;
	unless isint then popint(lim) -> lim endunless;
	do_arith3(lim, src, false, "cmplw");

	place2(OP_bl, pclab);				;;; addr of pclab in link reg
	place_label(pclab);

#_IF WORD_BITS==DOUBLE_BITS
#_ELSE
	;;; 6-7 instructions after pclab
	if isint then place4("slwi", tmp1, src, 2), tmp1 -> src endif;
	place4("addi", tmp1, src, if isint then 7 else 6 endif * 4);
#_ENDIF
	place2("mflr", tmp2);				;;; addr of pclab in tmp2
	place4("add", tmp1, tmp2, tmp1);
	place2("mtctr", tmp1);				;;; to count reg
	place1([blectr\+]);					;;; ignores bits 0,1
	place2(OP_b, afterlab);				;;; if out of range

	;;; first the branches for trapping arg values < ____base
	until base == 0 do
		place2(OP_b, afterlab);
		base-1 -> base
	enduntil;
	;;; now the ones for the allowable values
	for lab in lablist do place2(OP_b, lab) endfor;

	place_label(afterlab);

	unless isint or f_subv(4,m_instr) then
		;;; if popint with no "else" label, push arg back onto stack
		;;; (as argument to error procedure)
		do_move(org_src, -_USP)
	endunless;
	free_reg(srctmp); free_reg(tmp1); free_reg(tmp2);
enddefine;

define M_BRANCH_ON		= do_branch_on(% false %) enddefine;
define M_BRANCH_ON_INT	= do_branch_on(% true %) enddefine;


;;; --- CALL INSTRUCTIONS ------------------------------------------------

define lconstant pop_call_or_chain(iscall);
	lvars	src = f_subv(2,m_instr), iscall, lab, tmp, xoffs, infile,
			pbval = false;
	if perm_const_of_svb_opnd(src) ->> tmp then
		src -> pbval;
		tmp -> src
	endif;
	if isref(src) then
		;;; constant
		fast_cont(src) -> src;
		execlabof(src, true) -> lab;
		islabel(src) &&/=_0 LAB_OF_STRUCT -> infile;
#_IF DEF NO_ABS_CALLS
		if infile then
#_ENDIF
			;;; defined in current file
			if pbval then
				do_move(pbval, PB)
			else
				load_literal(PB, src)
			endif;
			call_or_chain_lab(lab, iscall);
			return;
#_IF DEF NO_ABS_CALLS
		endif;
#_ENDIF

		load_literal(alloc_reg()->>tmp, lab);
		load_literal(PB, src);

	else
		alloc_reg() -> tmp;
		field_##("PD_EXECUTE").wof -> xoffs;
		if isreg(src) then
			place_regacc(OP_ldW, tmp, xoffs, trans_reg(src,false));
			do_move(src, PB)
		else
			do_move(src, PB);
			place_regacc(OP_ldW, tmp, xoffs, PB)
		endif
	endif;
	call_or_chain_reg(tmp, iscall);
	free_reg(tmp)
enddefine;

define M_CALL	= pop_call_or_chain(% true %)  enddefine;

define M_CHAIN();
	unless closure_frozlist then dealloc_dummy_reg() endunless;
	pop_call_or_chain(false)
enddefine;

	;;; {M_CALL_WITH_RETURN ________pdr-opnd ___________return-addr}
define M_CALL_WITH_RETURN();
	do_move(f_subv(3,m_instr), R0);		;;; set return address in r0
	place2("mtlr", R0);					;;; then in link reg
	M_CHAIN()							;;; chain to procedure
enddefine;

define lconstant subroutine_call(src, excl_rt0);
	lvars src, excl_rt0, tmp;
#_IF not(DEF NO_ABS_CALLS)
	if perm_const_of_svb_opnd(src) ->> tmp then tmp -> src endif;
	if isref(src) then
		;;; constant
		call_or_chain_lab(fast_cont(src), true);
		return
	endif;
#_ENDIF

	if excl_rt0 then
		;;; has an arg in rt0
		dealloc_dummy_reg(); exclude_reg(RT0)
	endif;
	load_src(false, src) -> (src, tmp);
	call_or_chain_reg(src, true);
	free_reg(tmp);
	if excl_rt0 then free_reg(RT0) endif
enddefine;

	;;; {M_CALLSUB  _______________subroutine_opnd  _________________________upto-3-args-to-go-in-regs}
	;;; (subroutine is always a constant when reg args present, but
	;;; may be an SVB operand)
define M_CALLSUB();
	lvars l = datalength(m_instr);
	if l == 5 then
		do_move(f_subv(3,m_instr), RT2)							;;; arg_reg_2
	endif;
	if l fi_>= 4 then do_move(f_subv(l-1,m_instr), RT1) endif;	;;; arg_reg_1
	if l fi_>= 3 then do_move(f_subv(l,  m_instr), RT0) endif;	;;; arg_reg_0
	subroutine_call(f_subv(2,m_instr), l fi_>= 3)
enddefine;

define M_CHAINSUB();
	lvars src = f_subv(2,m_instr), tmp;
	dealloc_dummy_reg();
#_IF not(DEF NO_ABS_CALLS)
	if perm_const_of_svb_opnd(src) ->> tmp then tmp -> src endif;
	if isref(src) then
		;;; constant
		;;; restore caller's pb from SF_OWNER
		place_regacc(OP_ldW, PB, field_##("SF_OWNER").wof, SP);
		call_or_chain_lab(fast_cont(src), false);
		return
	endif;
#_ENDIF

	load_src(false, src) -> (src, tmp);
	;;; restore caller's pb from SF_OWNER
	place_regacc(OP_ldW, PB, field_##("SF_OWNER").wof, SP);
	call_or_chain_reg(src, false);
	free_reg(tmp);
enddefine;

define M_LABEL();
	stack_adjust();
	dealloc_dummy_reg();
	OP_label -> f_subv(1,m_instr);
	placei(m_instr)
enddefine;


;;; --- SPECIAL INSTRUCTIONS --------------------------------------------

	;;; {M_CLOSURE ________frozvals ___________pdpart-opnd}
define M_CLOSURE();
	lvars	f, l, offs, (, frozvals, pdpart_opnd) = explode(m_instr),
			nfroz = listlength(frozvals);

	;;; M-code to push frozvals and call pdpart.
	;;; If closure is non-writeable, ___________pdpart_opnd
	;;; is an immediate operand for the pdpart procedure.

	[%	if nfroz fi_> 16 then
			;;; just give clos to Exec_closure
			{% M_MOVE, PB, -_USP %};
			perm_constp_opnd([Sys Exec_closure], false) -> pdpart_opnd
		elseif pdpart_opnd then
			;;; closure non-writeable, can bypass stored frozvals
			frozvals -> closure_frozlist;
			fast_for f in frozvals do
				unless isintegral(f) then
					if fast_=_lmember(f, unique_labels) ->> l then
						f_hd(f_tl(l))
					else
						consref(f)
					endif -> f
				endunless;
				{% M_MOVE, f, -_USP %}
			endfor
		else
			;;; must use stored frozvals
			field_##("PD_CLOS_FROZVALS").wof -> offs;
			fast_repeat nfroz times
				{% M_MOVE, consregacc(PB, offs), -_USP %};
				offs+WORD_OFFS -> offs
			endrepeat;
			consregacc(PB, field_##("PD_CLOS_PDPART").wof) -> pdpart_opnd
		endif;
		{% M_CHAIN, pdpart_opnd %}
	%] -> l;
	f_hd(l) ->> m_instr -> f_hd(m_codelist);
	f_tl(l) nc_<> f_tl(m_codelist) -> f_tl(m_codelist);
	chain(f_subv(1, m_instr))
enddefine;

	;;; {M_SETSTKLEN  ________________________offset-of-stack-increase  ___________________popint-saved-stklen}
	;;; ______offset is always a constant integer
define M_SETSTKLEN();
	lvars (, offs, sl_opnd) = explode(m_instr), lab;
	dlocal arith3_do_stkadjust = true;

	;;; _userhi - ___________________popint-saved-stklen -> rt0
	do_arith3(sl_opnd, perm_var_opnd([\^_userhi]), RT0, "sub");
	;;; rt0 - (______offset-POPINT0) -> rt0 = desired value of USP
	;;; (-POPINT0 accounts for the popint bits in _______sl_opnd)
	do_arith3(offs-POPINT0, RT0, RT0, "sub");
	;;; branch around call if equal
	do_arith_test(USP, RT0, "EQ", genlab()->>lab, "cmplw");
	;;; else call _setstklen_diff with arg in rt0 (and CR0 set)
	subroutine_call(perm_const_opnd([\^_setstklen_diff]), true);
	place_label(lab)
enddefine;


;;; --- PROLOG INSTRUCTIONS ----------------------------------------------

	;;; {M_PLOG_IFNOT_ATOM _________ifnot-lab}
	;;; (follows a call of _prolog_unify_atom)
define M_PLOG_IFNOT_ATOM();
	place_test("NEQ", f_subv(2,m_instr))
enddefine;

	;;; {M_PLOG_TERM_SWITCH  ________fail-lab  _______var-lab  ______________________dst-for-drop-thru-case}
	;;; (follows a call of _prolog_pair_switch/ _prolog_term_switch)
define M_PLOG_TERM_SWITCH();
	place_test("GT", f_subv(3,m_instr));	;;; _______var-lab if CR0-gt set
	place_test("NEQ", f_subv(2,m_instr));	;;; ________fail-lab if CR0-eq clear
	;;; else deref'ed pair/term in arg_reg_0 (rt0)
	move_rt0_result(f_subv(4,m_instr))
enddefine;


;;; --- ENTRY/EXIT CODE --------------------------------------------------

lblock

lvars
	Ndlocal, Nreg, Npopreg, Nstkvar, Npopstkvar, dlocal_labs, frame_offs
	;

define lconstant sr_reg_code(op, spoffs) -> spoffs;
	lvars op, spoffs;

	define lconstant sr_regs(n, rlist, spoffs) -> spoffs;
		lvars rlist = fast_back(rlist), n, spoffs;
		while n > 0 do
			place_regacc(op, reglabel(fast_subscrl(n,rlist)), spoffs, SP);
			n-1 -> n;
			spoffs+WORD_OFFS -> spoffs
		endwhile
	enddefine;

	;;; pop regs
	sr_regs(Npopreg, pop_registers, spoffs) -> spoffs;
	;;; nonpop regs
	sr_regs(Nreg-Npopreg, nonpop_registers, spoffs) -> spoffs
enddefine;

	;;; {M_CREATE_SF __________reg-locals  _______Npopreg  ________Nstkvars  ___________Npopstkvars
	;;;								___________dlocal-labs  ______________ident-reg_spec }
	;;; Generate code to construct stack frame -- this sets up values
	;;; to be used by later M_UNWIND_SF.
define M_CREATE_SF();
	lvars	n, spoffs, pboffs, reg_locals, reg_spec_id;

	explode(m_instr) -> (, reg_locals, Npopreg, Nstkvar, Npopstkvar,
							dlocal_labs, reg_spec_id);

	listlength(reg_locals) -> Nreg;
	listlength(dlocal_labs) -> Ndlocal;

	;;; register spec in PD_REGMASK is switch offset to within TNP+1 blocks
	;;; of cascaded instructions which store/load the pop registers and then
	;;; branch to store/load the corresponding nonpop registers. Each block is
	;;; TP*2+1 instructions. (See aprocess.s)
	lconstant
		TNP		= listlength(nonpop_registers)-1,
		TP		= listlength(pop_registers)-1,
		PBLKLEN = TP*2 + 1;

	( (TNP-(Nreg-Npopreg))*PBLKLEN + (TP-Npopreg)*2
			+ 5			;;; 5 instrs from pc label to regcode
	) * 4 -> idval(reg_spec_id);


	wof(field_##("SF_LOCALS")) -> spoffs;
	spoffs fi_+ wof(Nstkvar fi_+ Ndlocal fi_+ Nreg
						fi_- field_##("SF_RETURN_ADDR")) -> frame_offs;

	place2("mflr", RT4);			;;; link reg -> rt4

	;;; save my address and decrement sp for stack frame
	place_regacc(OP_stWu, PB, -frame_offs, SP);

	;;; skip nonpop stack lvars
	spoffs + wof(Nstkvar-Npopstkvar) -> spoffs;

	;;; initialise pop stack lvars to popint 0
	if Npopstkvar /== 0 then
		place3("li", RT0, popint(0));
		repeat Npopstkvar times
			place_regacc(OP_stW, RT0, spoffs, SP);
			spoffs+WORD_OFFS -> spoffs
		endrepeat
	endif;

	;;; save dynamic local identifiers
	Ndlocal -> n;
	wof(field_##("PD_TABLE")+n) -> pboffs;
	while n > 0 do
		pboffs-WORD_OFFS -> pboffs;
		place_regacc(OP_ldW, RT0, pboffs, PB);
		if n == 1 then
			place_regacc(OP_ldW, RT0, 0, RT0);		;;; ID_VALOF
			place_regacc(OP_stW, RT0, spoffs, SP);
			n-1 -> n
		else
			pboffs-WORD_OFFS -> pboffs;
			place_regacc(OP_ldW, RT1, pboffs, PB);
			place_regacc(OP_ldW, RT0, 0, RT0);		;;; ID_VALOF
			place_regacc(OP_ldW, RT1, 0, RT1);		;;; ID_VALOF
			place_regacc(OP_stW, RT0, spoffs, SP);
			spoffs+WORD_OFFS -> spoffs;
			place_regacc(OP_stW, RT1, spoffs, SP);
			n-2 -> n
		endif;
		spoffs+WORD_OFFS -> spoffs
	endwhile;

	;;; save registers
	sr_reg_code(OP_stW, spoffs) -> spoffs;

	;;; save caller's return
	place_regacc(OP_stW, RT4, spoffs, SP);
enddefine;

	;;; return from procedure
define M_RETURN();
	;;; restore caller's pb from SF_OWNER
	place_regacc(OP_ldW, PB, 0, SP);
	stack_adjust();
	;;; return to link register
	place1(OP_blr);
	dealloc_dummy_reg()
enddefine;

	;;; {M_UNWIND_SF}
	;;; generate code to unwind stack frame (musn't use CHAIN_REG)
	;;; Uses lvar dlocal_labs set up by previous M_CREATE_SF
define M_UNWIND_SF();
	lvars	n, spoffs = wof(field_##("SF_LOCALS")+Nstkvar), pboffs;

	;;; restore dynamic local identifiers
	Ndlocal -> n;
	wof(field_##("PD_TABLE")+n) -> pboffs;
	while n > 0 do
		pboffs-WORD_OFFS -> pboffs;
		place_regacc(OP_ldW, RT0, pboffs, PB);
		place_regacc(OP_ldW, RT1, spoffs, SP);
		spoffs+WORD_OFFS -> spoffs;
		if n == 1 then
			place_regacc(OP_stW, RT1, 0, RT0);		;;; ID_VALOF
			n-1 -> n
		else
			pboffs-WORD_OFFS -> pboffs;
			place_regacc(OP_ldW, RT2, pboffs, PB);
			place_regacc(OP_ldW, RT3, spoffs, SP);
			spoffs+WORD_OFFS -> spoffs;
			place_regacc(OP_stW, RT1, 0, RT0);		;;; ID_VALOF
			place_regacc(OP_stW, RT3, 0, RT2);		;;; ID_VALOF
			n-2 -> n
		endif
	endwhile;

	;;; restore registers
	sr_reg_code(OP_ldW, spoffs) -> spoffs;

	;;; restore caller's return
	place_regacc(OP_ldW, RT4, spoffs, SP);

	f_tl(m_codelist) -> n;
	if n /== [] and subscrv(1,f_hd(n)->>n) == M_RETURN then
		;;; restore caller's pb from SF_OWNER and increment SP
		place_regacc(OP_ldWu, PB, frame_offs, SP);
		stack_adjust();
		place2("mtlr", RT4);			;;; rt4 -> link reg
		;;; return to link register
		place1(OP_blr);
		dealloc_dummy_reg();
		f_tl(f_tl(m_codelist)) -> f_tl(m_codelist)
	else
		;;; increment sp to erase stack frame
		place_regacc(OP_ldA, SP, frame_offs, SP);
		place2("mtlr", RT4)			;;; rt4 -> link reg
	endif
enddefine;

endlblock;


	;;; end of code
define M_END = identfn(%%) enddefine;


	;;; translate M-code to Alpha assembler
define lconstant code_trans(m_clist) -> (instr_list, new_literals);
	lvars	opcode, m_clist;
	dlocal	m_codelist, m_instr, instr_list, last_ipair,
			curr_stack_diff	= 0, new_literals = [], closure_frozlist = false;

	;;; start of code label
	[{^OP_label ^current_pdr_exec_label}] ->> instr_list -> last_ipair;
#_IF DEF VMS
	place3([\.base], PB, current_pdr_label);
#_ENDIF
	init_reg();
	for m_codelist on m_clist do
		f_hd(m_codelist) -> m_instr;
		if isprocedure(f_subv(1,m_instr) ->> opcode) then
			set_litreg_unused();
			opcode()
		else
			mishap(opcode, 1, 'UNKNOWN M-OPCODE')
		endif
	endfor
enddefine;

;;; ------------------------------------------------------------------------

define lconstant code_optimise(codelist) -> codelist;
	lvars	codelist, lastl, lastop = false, l, instr, op, lsrc1, lsrc2, ldst,
			raddr, rval, v1, v2;

	define lconstant operands(i) -> (dst, src1, src2);
		lvars i, src1, src2 = false, dst, op, len = datalength(i);
		explode(i);
		if len == 2 then
			;;; m{t,f}{l,ct}r
			() -> (op, dst);
			if isstartstring('mt', op) then false, dst -> (dst, src1) endif
		elseif len == 3 then
			() -> (op, dst, src1);
			if fast_lmember(op, #_< [^OP_ldI /*OP_ldL*/ ^OP_stI ^OP_stIu
									/*OP_stL*/ ^OP_ldA] >_#)
			then
				if isvector(src1) then f_subv(1,src1) else PB endif -> src1
			else
				unless isword(src1) then false -> src1 endunless
			endif
		elseif len == 4 then
			() -> (_, dst, src1, src2)
		else
			() -> (_, dst, src1, _, src2)
		endif;
		if src2 and not(isword(src2)) then false -> src2 endif
	enddefine;

	fast_for l on codelist do
		f_hd(l) -> instr;
		f_subv(1,instr) -> op;
		;;; try to move a preceding arith instruction or store to after
		;;; a load (move a store only if load is off PB)
		if (op==OP_ldI /* or op==OP_ldL */)
		and (isword(lastop) or lastop==OP_stI or lastop==OP_stIu
				/*or lastop==OP_stL*/)
		then
			operands(f_hd(lastl)) -> (ldst, lsrc1, lsrc2);
			operands(instr) -> (rval, raddr, _);
			if (isword(lastop) or raddr == PB
				or (raddr == SVB and lsrc1 /== SVB))
			and ldst /== raddr and ldst /== rval
			and lsrc1 /== rval and lsrc2 /== rval
			and (lastop /== OP_stIu or lsrc1 /== raddr)
			then
				;;; move
				f_hd(lastl), instr -> (f_hd(l), f_hd(lastl));
				if f_tl(l) /== [] and f_subv(1,f_hd(f_tl(l))) == OP_ldI then
					false -> lastop;
					nextloop
				else
					lastop -> op
				endif
			endif
		elseif op == OP_stIu and lastop == OP_stIu
		and (f_subv(3,f_hd(lastl)) -> v1, f_subv(3,instr) -> v2,
				f_subv(1,v1) == f_subv(1,v2))
		then
			;;; stIu Rx, offs1(Ra), stIu Ry, offs2(Ra) becomes
			;;; stu Rx, offs1(Ra), stIu Ry, (offs1+offs2)(Ra)
			OP_stI -> f_subv(1,f_hd(lastl));
			copy(v2) ->> v2 -> f_subv(3,instr);
			f_subv(2,v1) + f_subv(2,v2) -> f_subv(2,v2)
		endif;
		l -> lastl; op -> lastop
	endfor
enddefine;

;;; --- GENERATE OUTPUT CODE -----------------------------------------------

define lconstant outopnd(opnd, opcode, comment) -> comment;
	lvars opnd, reg, dis, opcode, comment;
	if isintegral(opnd) then
		opnd, '%p'
	elseif isaccess(opnd) then
		f_subv(1,opnd) -> reg;
		f_subv(2,opnd) -> dis;
		if opcode == "addis" then	dis, reg, '%p, %p'
;;; BUG IN ASSEMBLER: (___reg) DOES NOT ASSEMBLE AS 0(___reg)
;;;		elseif dis == 0 then 		reg, '(%p)'
		else						reg, dis, '%p(%p)'
		endif
	elseif isref(opnd) then
		fast_cont(opnd) -> comment;
		PB, asm_label_diff(comment, current_pdr_label), '%p(%p)'
	else
		opnd, '%p'
	endif;
	asmf_printf()
enddefine;

define lconstant outinst(inst);
	lvars n, l, op, inst, comment = false;
	f_subv(1,inst) -> op;
	if op == OP_label then outlab(f_subv(2,inst)); return endif;
	if ispair(op) then f_hd(op) -> op endif;
	asmf_printf(op, '\t%p\t');
	datalength(inst) -> l;
	fast_for n from 2 to l fi_- 1 do
		outopnd(f_subv(n, inst), op, comment) -> comment;
		asmf_charout(`,`), asmf_charout(`\s`)
	endfor;
	unless l == 1 then
		outopnd(f_subv(l, inst), op, comment) -> comment
	endunless;
	if comment then asmf_printf(comment, '\t# %p') endif;
	asmf_charout(`\n`);
	subscrv(current_asm_segment,asm_seg_offsets) fi_+ 4
				-> subscrv(current_asm_segment,asm_seg_offsets)
enddefine;


;;; --- GENERATING CODE ------------------------------------------------

	/*	Generate assembler code for a procedure -- called by m_trans
		The global variables

			current_pdr_label, current_pdr_exec_label

		contain the current procedure's label and start-of-code label
		_______hdr_len is the length in words preceding the code.
	*/
define mc_code_generator(codelist, hdr_len) -> (gencode, pdr_len);
	lvars codelist, hdr_len, pdr_len, new_lits;
	lconstant procedure gencode;

	unless unique_labels then
		[%	symlabel("false"), false_immediate,
			symlabel("true"), true_immediate,
			symlabel("nil"), nil_immediate
		%] -> unique_labels
	endunless;

	;;; process codelist
	code_trans(codelist) -> (codelist, new_lits);	;;; translate to assembler
	code_optimise(codelist) -> codelist;

	;;; expression for procedure header length in words
	hdr_len + listlength(new_lits) -> pdr_len;

	;;; code generator
	define lconstant gencode();
		lvars lit, lab;
		fast_for lit in new_lits do
			asm_outlab(pdr_literal_label(lit));
			asm_outword(lit, 1)
		endfor;

		asmseg_code -> current_asm_segment;
		asm_startinstr();
		applist(codelist, outinst);			;;; produce output code
;;;		asm_align_double()
	enddefine
enddefine;


;;; --- OTHER DEFINITIONS NEEDED BY m_trans.p ---------------------------


	/*	M-code tables for machine-dependent in-line subroutines.
		These are added to the corresponding properties in m_trans.p
	*/
constant

	mc_inline_procs_list = [
	[ \^_ptr_to_offs	[{^M_ERASE ^USP_+}]]		;;; erases type, leaves ptr
	[ \^_offs_to_ptr	[{^M_ERASE ^USP_+}]]		;;; erases type, leaves ptr
	[ \^_int			[{^M_ASH ^(-WORD_SHIFT) ^USP_+ ^ -_USP}]]
	[ \^_pint			[{^M_ASH ^WORD_SHIFT ^USP_+ ^ -_USP}
						 {^M_ADD 2:11 ^USP_+ ^ -_USP}]]
	[ \^_por			[{^M_BIS ^USP_+ ^USP_+ ^ -_USP}]]
	[ \^_pand			[{^M_BIM ^USP_+ ^USP_+ ^ -_USP}]]
	[ \^_mksimple		[{^M_ADD 2:01 ^USP_+ ^ -_USP}]]
	[ \^_mkcompound		[{^M_SUB 2:01 ^USP_+ ^ -_USP}]]
	[ \^_mksimple2		[{^M_ADD 2:11 ^USP_+ ^ -_USP}]]
	[ \^_mkcompound2	[{^M_SUB 2:11 ^USP_+ ^ -_USP}]]

	],

	mc_inline_conditions_list = [
	[ \^_iscompound		{^M_BIT  2:01   ^USP_+ EQ  ?}	]
	[ \^_issimple		{^M_BIT  2:01   ^USP_+ NEQ ?}	]
	[ \^_issimple2		{^M_BIT	 2:10	^USP_+ NEQ ?}	]
	[ \^_isinteger		{^M_BIT  2:10   ^USP_+ NEQ ?}	]
	[ \^_isaddress		{^M_BIT  ^(WORD_OFFS-1) ^USP_+ EQ  ?}	]
	],
;


	/*	Procedure to convert a pop integer subscript to an appropriate offset
		for the data type being accessed, used by OP_SUBV in m_trans.p to
		compile code for fast_subscrv, vectorclass field accesses, etc.
			_____scale is the scale for the data type involved; the results are
		the M-code instructions (if any) necessary to convert the subscript
		on top of the stack to an offset, plus a constant correction to be
		added.
	*/
define cvt_pop_subscript(scale);
	lvars pow, scale;
	if is_power2(scale) ->> pow then
		;;; pow-WORD_SHIFT accounts for popint being shifted left by WORD_SHIFT
		unless (pow-WORD_SHIFT ->> pow) == 0 then
			{^M_ASH ^pow ^USP_+ ^ -_USP}
		endunless,
		-(POPINT0 << pow)	;;; additive correction to remove popint bits
	else
		;;; just convert to sysint and multiply
		{^M_ASH ^(-WORD_SHIFT) ^USP_+ ^ -_USP},		;;; _int()
		{^M_MULT ^scale ^USP_+ ^ -_USP},
		0 						;;; no correction necessary
	endif
enddefine;


endsection;		/* Genproc */

endsection;		/* $-Popas$-M_trans */
