/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 * File:		S.sun3/src/aextern.s
 * Purpose:
 * Author:		John Gibson (see revisions)
 */

;;; ---------------- USER EXTERNAL CALLS / CALLBACK ----------------------

#_<

#_INCLUDE 'declare.ph'
#_INCLUDE 'external.ph'
#_INCLUDE 'numbers.ph'

lconstant macro (
	_SAVED_SP	= [I_LAB(Sys$-Extern$- _saved_sp)],
	_SAVED_USP	= [I_LAB(Sys$-Extern$- _saved_usp)],

	_KEY		= @@KEY,
	_K_EXTERN_TYPE	= @@K_EXTERN_TYPE,
	_XP_PTR  	= @@XP_PTR,
	_DD_1		= @@DD_1,
	_DD_2		= @@DD_2,
	_BGI_LENGTH	= @@BGI_LENGTH,
	_BGI_SLICES	= @@BGI_SLICES,
	_EFC_FUNC	= @@EFC_FUNC,
	_EFC_ARG	= @@EFC_ARG,
	_EFC_ARG_DEST	= @@EFC_ARG_DEST,
	);

>_#

/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.text

	;;;    _call_external(____arg1, ..., ____argN, _N, _______routine, _________fltsingle)
	;;;
	;;; Call an external procedure, moving args from userstack
	;;; to stack and converting -- for users. Must be capable of
	;;; dealing with callback.
	;;;    Bit N set in the _________fltsingle arg says pass the Nth arg as a
	;;; single float if it's a (d)decimal (otherwise pass (d)decimals
	;;; as doubles). Note that bit 31 governs all args from 32nd onwards.

DEF_C_LAB (_call_external)

	lea	sp@(4), a0		;;; ptr to caller's stack frame
	movl	a0, _SAVED_SP 		;;; save for callback/exceptions

	movl	a6@+, d5		;;; _________fltsingle arg in d5
	movl	a6@+, d3		;;; _______routine in d3
	movl	a6@+, d2		;;; argument count _N in d2
	beq	9$			;;; no args
	moveq	#32, d0
	subl	d2, d0			;;; 32 - _N
	bles	15$			;;; br if _N >= 32
	asll	d0, d5			;;; shift _________fltsingle bit for last arg
	bras	15$			;;; up to sign bit

1$:     cmpl	#32, d2			;;; still on or after 32nd arg?
	bges	15$			;;; br if so, don't shift
	asll	#1, d5			;;; next _________fltsingle bit up to sign bit

15$:	movl	a6@+, d0		;;; next arg
	;;; the following instruction tests AND CLEARS bit 0
	bclr	#0, d0			;;; structure pointer? (clear bit 0)
	beqs	3$			;;; br if so

	;;; integer or single decimal
	btst	#1, d0			;;; integer?
	beqs	2$			;;; br if decimal
	;;; integer
	asrl	#2, d0			;;; cvt integer to m/c int
	movl	d0, sp@-
	bras	8$

2$:	;;; decimal -- pass as double float unless _________fltsingle bit set
	tstl	d5			;;; _________fltsingle bit (sign bit) set?
	bmis	25$			;;; yes -- pass as single
	;;; convert to double
	jsr	Vstod			;;; convert to double in d0, d1
	movl	d1, sp@-		;;; push ls half
25$:	movl	d0, sp@-		;;; and ms half
	bras	8$

	;;; structure pointer -- get K_EXTERN_TYPE field
3$:	movl	d0, a0
	movl	a0@(_KEY), a1		;;; key
	movb	a1@(_K_EXTERN_TYPE), d0	;;; type
	bnes	4$			;;; br if nonzero
	;;; EXTERN_TYPE_NORMAL (0) -- just pass pointer
	movl	a0, sp@-
	bras	8$

4$:	subqb	#_:EXTERN_TYPE_DEREF, d0
	bnes	5$
	;;; pass word field at pointer (e.g. external pointer)
	movl	a0@, sp@-		;;; pass dereferenced word
	bras	8$

5$:	subqb	#_:EXTERN_TYPE_DDEC-_:EXTERN_TYPE_DEREF, d0
	bnes	6$
	;;; ddecimal -- pass as double unless _________fltsingle bit set
	tstl	d5			;;; _________fltsingle bit (sign bit) set?
	bmis	55$			;;; yes -- pass as single
	movl	a0@(_DD_2), sp@-	;;; push ls half
	movl	a0@(_DD_1), sp@-	;;; and ms half
	bras	8$
	;;; convert to single
55$:	movl	a0@(_DD_2), d1		;;; ls half
	movl	a0@(_DD_1), d0		;;; ms half
	jsr	Vdtos			;;; convert to single in d0
	movl	d0, sp@-		;;; push it
	bras	8$

6$:	;;; else must be biginteger (EXTERN_TYPE_BIGINT)
	;;; pass least significant 32 bits
#_IF "BIGINT_SPEC".valof == "short"
	;;; must be at least 2 slices
	movl	a0@(_BGI_SLICES), d1	;;; ls 2 slices in wrong order
	swap	d1			;;; now right, but need to lose bit 15
	lslw	#1, d1			;;; bottom 15 up 1
	asrl	#1, d1			;;; everything down 1 (could sign-extend)
	movl	d1, sp@-
	moveq	#2, d0
	cmpl	a0@(_BGI_LENGTH), d0	;;; only 2 slices?
	beqs	8$			;;; OK if so
	movb	a0@(_BGI_SLICES+5), d0	;;; bottom byte of 3rd slice
	lslb	#6, d0			;;; ls 2 bits to top of byte
#_ELSE
	movl	a0@(_BGI_SLICES), sp@-	;;; ls slice to stack
	moveq	#1, d0
	cmpl	a0@(_BGI_LENGTH), d0	;;; only 1 slice?
	beqs	8$			;;; OK if so
	movb	a0@(_BGI_SLICES+7), d0	;;; bottom byte of 2nd slice
	lslb	#7, d0			;;; ls bit to top of byte
#_ENDIF
	addb	d0, sp@			;;; add to top byte
	;;; drop thru to 8$

	;;; test more args
8$:	subql	#1, d2
	bne	1$			;;; more to come


	;;; args done -- call the procedure
9$:	movl	a6, _SAVED_USP		;;; save user sp for callback

	;;; NEXT INSTRUCTION ENABLES ASYNC CALLBACK
	movl	sp, ___pop_in_user_extern ;;; any nonzero value will do
	jsr	a2@(0, d3:L)		;;; over to the procedure
	;;; NEXT INSTRUCTION DISABLES ASYNC CALLBACK
	clrl	___pop_in_user_extern

	movl	_SAVED_USP, a6 		;;; regain user sp

	;;; set result_struct with possible float result from
	;;; d0,d1 in first 2 words and possible word result from d0 in last
	lea	C_LAB(Sys$-Extern$-result_struct), a0
	movl	d0, a0@+		;;; float result
	movl	d1, a0@+
	movl	d0, a0@			;;; word result

	movl	_SAVED_SP, a0
	lea	a0@(-4), sp		;;; reset sp to return addr
	clrl	_SAVED_SP		;;; says no longer in extern call
	rts				;;; return


;;; --- EXTERNAL FUNCTION CLOSURES --------------------------------------

	;;; (exfunc closure address) + 6 on top of stack
	;;; assign EFC_ARG to EFC_ARG_DEST and chain EFC_FUNC

DEF_C_LAB(Sys$- _exfunc_clos_action)

	movl	sp@+, a0		;;; addr of after jsr
	movl	a0@(_EFC_ARG_DEST-6), a1 ;;; -6 gives address of rec
	movl	a0@(_EFC_ARG-6), a1@	;;; assign arg to destination
	movl	a0@(_EFC_FUNC-6), a0	;;; funct exptr to chain to
	movl	a0@, a0			;;; deref
	jmp	a0@			;;; chain to func


;;; --- INTERFACE ROUTINE FOR EXTERNAL CALLBACK ------------------------------

	;;; C Synopsis:
	;;;
	;;; 	int _pop_external_callback(argp)
	;;; 	unsigned argp[];
	;;;
	;;; (where argp[0] is the function code for -Callback-)

.globl __pop_external_callback
__pop_external_callback:
	;;; for indirect weak reference
DEF_C_LAB(Sys$- _external_callback_func)
	moveml  #0x7ffe, sp@-		;;; save all regs except sp,d0 (14 words)
	;;; 3 word dummy stack frame to hold SF_NEXT_SEG_SP and SF_NEXT_SEG_HI
	lea	sp@(-3*4), sp
	movl	___pop_in_user_extern, d7 ;;; save this and restore at end

	;;; NEXT INSTRUCTION DISABLES ASYNC CALLBACK
	clrl	___pop_in_user_extern

	;;; set registers
	subl	a2, a2			;;; a2 always zero
	movl	#C_LAB(false), d4	;;; d4 always false
	movl	d4, d5			;;; set pop lvar regs to sensible
	movl	d4, d6			;;; values, i.e. false

	movl	_SAVED_USP, a6		;;; regain saved user sp
	movl	sp@((3+14+1)*4), a6@-	;;; push argp

	clrl	a6@-			;;; just pass 0
	jsr	XC_LAB(Sys$-Extern$-Callback)

	movl	a6@+, d0		;;; return status
	movl	a6, _SAVED_USP		;;; resave user sp for _call_external

	;;; NEXT INSTRUCTION ENABLES ASYNC CALLBACK
	movl	d7, ___pop_in_user_extern ;;; set back to value on entry

	lea	sp@(3*4), sp		;;; erase dummy stack frame
	moveml  sp@+, #0x7ffe		;;; restore all registers except sp,d0
	rts				;;; return into external code




/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 17 1995
	Moved definition of Extern$- _r*esult_struct to extern_ptr.p as
	Extern$-result_struct
--- John Gibson, Oct 20 1994
	No longer necessary for _call_external to save the pop registers
	(d5, d6), or for callback to do anything other than set them to
	false.
--- John Gibson, Nov 10 1993
	Made _pop_external_callback set __pop_in_user_extern back to the same
	value it had on entry
--- John Gibson, May 19 1993
	Template part of exfunc closures now generated by POPC, which
	jumps to the _exfunc_clos_action code in this file.
--- John Gibson, Dec 18 1992
	Moved pop_ex*func_arg to c_core.c (otherwise it's undefined if this
	file is not extracted)
--- John Gibson, Aug  6 1992
	Changed _call_external to take _________fltsingle arg whose Nth bit
	specifies the treatment of (d)decimals for the Nth arg
--- John Gibson, Jan 19 1991
	Added setting and clearing of ___pop_in_user_extern (tested nonzero
	by signal handler in c_core.c to determine whether asynchronous
	callback is allowed)
--- John Gibson, Nov 19 1990
	Added pop label for _pop_external_callback.
	Removed functions for getting interrupt/disable flag info
	(replaced by pointer constants in asignals.s)
--- John Gibson, Nov 13 1990
	_call_external now doesn't return the result structure on the
	stack, so the procedures calling it have to push
	Sys$-Extern$- _r*esult_struct explicitly (this is so the result isn't
	left on the stack when the return address from _call_external is
	changed for abnormal exit).
	_pop_external_callback now receives and passes on a status return
	from Callback.
--- John Gibson, Sep  5 1990
	Added exfunc closure stuff
--- Roger Evans, Jul  3 1990 added pop_interrupt_disabled
--- John Gibson, May 20 1990
	Removed _pop_mishap
--- John Gibson, May 14 1990
	_call_external now returns pointer to 3-word array, first
	2 words of which are possible single/double float result, 3rd word
	is possible result of any other kind.
--- John Gibson, Apr 28 1990
	Moved _call_sys to asignals.s (so this file is purely 'optional'
	external stuff).
--- John Gibson, Apr 11 1990
	Added callback routine
--- John Gibson, Mar 14 1990
	_call_external rewritten to use K_EXTERN_TYPE field, including
	coping with biginteger args.
--- Ian Rogers, Jan 16 1990
	Added pop_mishap for XPOP
--- Ian Rogers, Jan 15 1990
	Removed DEF XPOP code from around pop_interrupt_pending
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- Roger Evans, Aug  7 1989
	Added pop_interrupt_pending for XPOP
--- Rob Duncan, Apr  4 1989
	Replaced SUN_RELEASE with SUNOS
--- John Gibson, Aug 22 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Aug 21 1988
	SunOS-4 no longer needs to call -Mem_break_changed-.
--- John Gibson, Feb  9 1988
	ddecimal_key now in section Sys
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
