/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 * File:            S.sun3/src/afloat.s
 * Purpose:
 * Author:          John Gibson (see revisions)
 */

/**************************************************************************
 *                                                                        *
 *                            afloat.s                                    *
 *                     for Sun 68000 under unix                           *
 *                                                                        *
 *                                                                        *
 **************************************************************************/

#_<

#_INCLUDE 'declare.ph'

constant
	procedure Sys$-Float_qrem
	;

lconstant macro (
	_DD_1	= @@DD_1,
	_DD_2	= @@DD_2,
	);

>_#

/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.text

	;;; copy a double float from one address to another
DEF_C_LAB (_pfcopy)
	movl	a6@+, a0		;;; source addr
	movl	a6@+, a1		;;; dest addr
	movl	a0@+, a1@+
	movl	a0@, a1@
	rts

	;;; routine to single-float a decimal
DEF_C_LAB(_pf_sfloat_dec)
	movl	a6@+, d0		;;; fetch decimal
	subql	#1, d0			;;; convert to float
	movl	d0, a6@-		;;; push result
	rts


	;;; routines to float sysints, decimals and ddecimals
DEF_C_LAB (_pf_dfloat_int)
	movl	a6@+, d2		;;; address for result
	movl	a6@+, d0		;;; the integer
	jsr     Vfltd			;;; d0 float into d0, d1
	movl	d2, a0
	movl	d0, a0@+		;;; mslw of result
	movl	d1, a0@			;;; lslw of result
	rts

DEF_C_LAB (_pf_dfloat_dec)
	movl	a6@+, d2		;;; address for result
	movl	a6@+, d0		;;; the decimal
	subql	#1, d0			;;; clear low bit
	jsr	Vstod			;;; cvt to double
	movl	d2, a0
	movl	d0, a0@+		;;; mslw of result
	movl	d1, a0@			;;; lslw of result
	rts

DEF_C_LAB (_pf_dfloat_ddec)
	movl	a6@+, a0		;;; address for result
	movl    a6@+, a1		;;; the ddecimal
	movl    a1@(_DD_1), a0@+	;;; move fields to result
	movl	a1@(_DD_2), a0@		;;; and the next one
	rts


	;;; -----------------------------------------------------------------
	;;; _PFABS, _PFNEGATE -- monadic double floating arith
	;;; uses:
	;;;       top ->   operand address
	;;; results:	 in memory
	;;;       operand contains result
	;;; registers blown:
	;;;       D0      (loading bay)
	;;; -----------------------------------------------------------------
DEF_C_LAB (_pfabs)
	movl	a6@+, a0		;;; operand address
	bclr    #7, a0@			;;; clear the sign bit in ms byte
	rts

DEF_C_LAB (_pfnegate)
	movl	a6@+, a0		;;; operand address
	bchg    #7, a0@			;;; change the sign bit
	rts

DEF_C_LAB (_pfmult)
	movl	#Vmuld, d2
	bras	pfarith2

DEF_C_LAB (_pfdiv)
	movl	#Vdivd, d2
	bras	pfarith2

DEF_C_LAB (_pfsub)
	movl	#Vsubd, d2
	bras	pfarith2

DEF_C_LAB (_pfadd)
	movl	#Vaddd, d2

pfarith2:
	movl	a6@+, a0		;;; source address (2nd arg)
	movl	a6@, a1			;;; dest address (1st arg)
	movl	a1@+, d0		;;; first arg mslw
	movl	a1@, d1			;;; first arg lslw
	jsr     a2@(0, d2:L)		;;; d0,d1 <op> a0@ -> d0, d1
	movl	a6@, a1			;;; 1st arg (dest addr) again
	movl	d0, a1@+		;;; result ms into destination
	movl	d1, a1@			;;; result ls into destination
	;;; test for overflow operand (exponent = 2047)
	andl	#0x7FF00000, d0
	cmpl	#0x7FF00000, d0
	beqs	1$			;;; false if overflow
	movl	#C_LAB(true), a6@	;;; return true
	rts
1$:	movl	d4, a6@			;;; return false
	rts

DEF_C_LAB (_pfqrem)
	jmp	XC_LAB(Sys$-Float_qrem)	;;; just chain to Float_qrem


	;;; -----------------------------------------------------------------
	;;; FALSE1, TRUE1 -- stack a boolean and return
	;;; uses:	    --
	;;; used by:	 ??
	;;; arguments:    none
	;;; results:	 on pop stack
	;;;       top ->  true or false
	;;; registers blown: none
	;;; -----------------------------------------------------------------
false1:
	movl	d4, a6@-		;;; stack a false
	rts

true1:
	movl	#C_LAB(true), a6@-	;;; stack a true
	rts


	;;; -----------------------------------------------------------------
	;;; _PFSGR, _PFSGEQ, _PFEQ -- double floating compares
	;;; uses:	    C library function Vcmpd, boolean returns
	;;; arguments:    on user stack
	;;;       top -> arg2 address
	;;;              arg1 address
	;;; results:	 on pop stack
	;;;       top ->  true or false
	;;; registers blown: none
	;;; -----------------------------------------------------------------

DEF_C_LAB (_pfsgr)
	movl	a6@+, a0		;;; 2nd arg address
	movl	a6@+, a1		;;; 1st arg address
	movl	a1@+, d0		;;; 1st arg mslw to d0
	movl	a1@, d1			;;; 1st arg lslw to d1
	jsr	Vcmpd			;;; compare - sets flags
	bgts	true1			;;; result in flags
	bras	false1

DEF_C_LAB (_pfsgreq)
	movl	a6@+, a0		;;; 2nd arg address
	movl	a6@+, a1		;;; 1st arg address
	movl	a1@+, d0		;;; 1st arg mslw to d0
	movl	a1@, d1			;;; 1st arg lslw to d1
	jsr	Vcmpd			;;; compare - sets flags
	bges	true1			;;; result in flags
	bras	false1

DEF_C_LAB (_pfeq)
	movl	a6@+, a1		;;; arg2 address
	movl	a6@+, a0		;;; arg1 address
	cmpml   a0@+, a1@+		;;; first longword same?
	bnes	false1			;;; no, return false
	cmpml   a0@+, a1@+		;;; second longword same?
	bnes	false1			;;; nope
	bras	true1			;;; yep

	;;; test double float negative (genuinely, i.e. not -0.0)
DEF_C_LAB (_pfneg)
	movl	a6@+, a0		;;; arg address
	movl	a0@+, d0		;;; ms part
	bpls	false1			;;; false if sign bit not 1
	asll	#1, d0			;;; remove sign bit
	bnes	true1			;;; else neg if ms non-zero
	tstl	a0@			;;; else neg if ls part non-zero
	bnes	true1
	bras	false1

	;;; test double float zero (i.e. including -0.0)
DEF_C_LAB (_pfzero)
	movl	a6@+, a0		;;; arg address
	movl	a0@+, d0
	asll	#1, d0			;;; remove sign bit
	bnes	false1
	tstl	a0@			;;; else neg if ls part non-zero
	bnes	false1
	bras	true1

	;;; _pf_cvt_to_dec(_dfaddr) -> decimal or <false>
	;;; convert double to decimal (rounded to 21 bit mantissa)
DEF_C_LAB (_pf_cvt_to_dec)
	movl	a6@, a0			;;; source address
	movl	a0@+, d0		;;; ms part
	movl	a0@, d1			;;; ls part
	;;; set bits to force rounding of 22nd bit of mantissa in all
	;;; cases except where tied and 21st bit is 0 (even)
	cmpl	#0x40000000, d1
	beqs	1$			;;; tied and even, won't round
	orl	#0x38000000, d1		;;; else set 23rd, 24th, 25th bits
1$:	jsr	Vdtos			;;; convert to single in d0
	movl	d0, d1
	swap	d1
	andw	#0x7f80, d1		;;; exponent
	beqs	2$			;;; br if 0.0
	cmpw	#0x7f80, d1
	beq	false2s			;;; overflow if exponent = 255
	andb	#0xfc, d0		;;; clear tag bits
	addql	#1, d0			;;; make into pop decimal
	movl	d0, a6@			;;; return result
	rts
2$:	movl	#1, a6@			;;; return 0.0
	rts

DEF_C_LAB (_pf_cvt_to_ddec)
	movl    a6@+, a1		;;; the result ddecimal
	movl	a6@+, a0		;;; source double float address
	movw	a0@, d0
	andw	#0x7ff0, d0		;;; exponent
	bnes	1$			;;; leave alone if non-zero
	clrl	a1@(_DD_1)		;;; make truly 0 if zero exponent
	clrl	a1@(_DD_2)
	rts
1$:	movl    a0@+, a1@(_DD_1)	;;; move fields to result
	movl	a0@, a1@(_DD_2)
	rts

;;; ---- Routines to extract/update sfloat and dfloat field values

	;;; _pf_extend_s_to_d(_dfaddr) -> _dfaddr or <false>
	;;; extend single at _dfaddr into double (where single could
	;;; be Inf or NaN)
DEF_C_LAB (_pf_extend_s_to_d)
	movl	a6@, a0			;;; _dfaddr
	movl	a0@, d0			;;; the single
	movl	d0, d1
	swap	d1
	andw	#0x7f80, d1		;;; 8 bit exponent
	cmpw	#0x7f80, d1		;;; all ones (Inf or NaN)?
	beqs	false2s			;;; return false if so
	jsr	Vstod			;;; else convert to double in d0, d1
	movl	a6@, a0			;;; _dfaddr again
	movl	d0, a0@+		;;; move result in
	movl	d1, a0@
	rts

	;;; _pf_check_d(_dfaddr) -> _dfaddr or <false>
	;;; check double at _dfaddr (where double could be Inf or NaN)
DEF_C_LAB (_pf_check_d)
	movl	a6@, a0			;;; _dfaddr
	movw	a0@, d0			;;; word with exponent
	andw	#0x7ff0, d0		;;; mask out 11 bit exponent
	cmpw	#0x7ff0, d0		;;; all ones (Inf or NaN)?
	beqs	false2s			;;; return false if so
	rts				;;; else OK

	;;; _pf_round_d_to_s(_dfaddr) -> _dfaddr or <false>
	;;; round double to single back into _dfaddr
DEF_C_LAB (_pf_round_d_to_s)
	movl	a6@, a0			;;; source address
	movl	a0@+, d0		;;; ms part
	movl	a0@, d1			;;; ls part
	jsr	Vdtos			;;; convert to single in d0
	movl	d0, d1
	swap	d1
	andw	#0x7f80, d1		;;; 8 bit exponent
	cmpw	#0x7f80, d1
	beqs	false2s			;;; overflow if exponent all ones
	movl	a6@, a0			;;; source address now dest addr
	movl	d0, a0@			;;; move top longword
	rts				;;; return



	;;; -----------------------------------------------------------------
	;;; _PF_INTOF -- return integer part of double floating number
	;;; gives either an integer and ttrue,  or false if too big
	;;; uses:	    Vintd (from C library)
	;;; used by:	 intof
	;;; arguments:    on stack
	;;;       top -> arg address
	;;; results:	 on pop stack
	;;;       top ->  integer and true, or false
	;;; registers blown:
	;;;       D0      mslw of number
	;;;       D1      lslw
	;;;       D2      storage for mslw
	;;;       D3      storage for lslw
	;;;       D4      exponent of number
	;;; -----------------------------------------------------------------
DEF_C_LAB (_pf_intof)
	movl	a6@+, a0		;;; address of double float arg
	movw	a0@, d0			;;; word containing exponent
	lsrw	#4, d0			;;; exponent now right justified
	andw	#0x7FF, d0		;;; and out exponent
	cmpw	#1022+31, d0		;;; more than 31 integer bits?
	bhis    false2			;;; yes - would overflow integer
	;;; doesn't overflow integer
dofix:	movl	a0@+, d0		;;; ms part
	movl	a0@, d1			;;; ls part
	jsr	Vintd			;;; get truncated int
	movl	d0, a6@-		;;; stack result
	bras	true2			;;; and return true


	;;; -----------------------------------------------------------------
	;;; FALSE2, TRUE2 -- stack a boolean and return
	;;; uses:	    --
	;;; used by:	 ??
	;;; arguments:    none
	;;; results:	 on pop stack
	;;;       top ->  true or false
	;;; registers blown: none
	;;; -----------------------------------------------------------------
false2:
	movl	d4, a6@-		;;; stack a false
	rts

false2s:
	movl	d4, a6@			;;; replace top with false
	rts

true2:
	movl	#C_LAB(true), a6@-	;;; stack a true
	rts

true2s:
	movl	#C_LAB(true), a6@	;;; replace top with true
	rts

	;;; -----------------------------------------------------------------
	;;; _PFMODF -- get frac and int parts of double float
	;;; uses:	 C library - _modf
	;;; arguments:    on stack
	;;;       top -> address of source
	;;;	       address for frac part
	;;; results:	 int part back in arg
	;;;                frac at given address
	;;; registers blown:
	;;;       D0      (most significant part of operand)
	;;;       D1      (least significant part of operand)
	;;; -----------------------------------------------------------------
DEF_C_LAB (_pfmodf)
	movl	a6@+, a0		;;; address of source arg
	movl	a0, sp@-		;;; also to receive int part
	movl	a0@(4), sp@-		;;; stack double float arg
	movl	a0@, sp@-
	;;; Sun version of _modf doesn't deal properly with negative numbers
	bclr	#7, sp@			;;; clear and test -ve bit
	bnes	2$			;;; br if was negative
	jsr     _modf			;;; get frac part as double float
1$:	lea	sp@(12), sp		;;; clear stack
	movl	a6@+, a0		;;; address for frac
	movl	d0, a0@+		;;; high part
	movl	d1, a0@			;;; low part
	rts
	;;; negative version
2$:	jsr	_modf
	movl	sp@(8), a0		;;; pointer to int part
	bset	#7, a0@			;;; negate int part
	bset	#31, d0			;;; negate frac part
	bras	1$


	;;; -----------------------------------------------------------------
	;;; get and set exponent E of a double float, where E is
	;;; the number of bits needed for the integer part, e.g. 1 for 1.0,
	;;; 0 for 0.5, -1 for 0.05, etc.

DEF_C_LAB (_pf_expof)
	movl	a6@, a0			;;; address of dfloat
	movw	a0@, d0			;;; first word of it
	lsrw	#4, d0			;;; IEEE exponent at bottom
	andl	#0x7ff, d0		;;; mask it out as long
	subl	#1022, d0		;;; get E
	movl	d0, a6@			;;; return it
	rts

DEF_C_LAB(-> _pf_expof)
	movl	a6@+, a0		;;; address of dfloat
	movl	a6@, d0			;;; E value
	addl	#1022, d0		;;; get IEEE expoenent
	bles	false2s			;;; underflow if 0 or neg
	cmpl	#0x7ff, d0		;;; overflow (>= 2047) ?
	bges	false2s			;;; return false if so
	lslw	#4, d0			;;; left 4
	movw	a0@, d1			;;; first word of dfloat
	andw	#0x800f, d1		;;; mask all but exponent
	orw	d1, d0			;;; or to new exponent
	movw	d0, a0@			;;; put back
	bras	true2s			;;; return true


/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 25 1995
	Removed _m*ath1/2 subroutines (library math functions now called
	via _extern)
--- John Gibson, Mar 25 1991
	_pf_extend_s_to_d changed to check for externally-generated Infs/NaNs
	and return boolean result; _pf_check_d added to do same for doubles.
--- John Gibson, Mar  8 1990
	Replaced old C-library float function names (fv...i) with new ones
	(V...d).
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- Roger Evans, Aug  7 1989
	Added _pf_sfloat_dec
--- John Gibson, Jan 15 1989
	Replaced use of UC_LAB etc for updater with -> before pathname
--- John Gibson, Aug 24 1988
	Made _pf_cvt_to_dec do rounding correctly (i.e. according to IEEE
	standard of rounding the 'tie' case to make the next bit even).
--- John Gibson, Aug 22 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Feb 10 1988
	-Ddec_qrem- now -Sys$-Float_qrem-
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- John Gibson, Sep 21 1987
	Added _pf_cvt_to_ddec, which absorbs the function of _pf_normalise
	(also renamed _pf_cvt_to_decimal as _pf_cvt_to_dec for compatibility).
 */
