/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 * File:	S.sun3/src/amisc.s
 * Purpose:
 * Author:	John Gibson (see revisions)
 */

/**************************************************************************
 *									  *
 *				amisc.s					  *
 *			for 68000 under unix				  *
 *									  *
 **************************************************************************/

#_<

#_INCLUDE 'declare.ph'

vars
	_call_stack_lim, _plog_trail_sp, _plog_trail_lim
	;

section $-Sys;

constant
	procedure (Call_overflow, User_overflow, Callstack_reset,
	Conspair, Plog$-Area_overflow, Async_raise_signal)
	;

endsection;

lconstant macro (
	_KEY		= @@KEY,
	_K_APPLY	= @@K_APPLY,
	_RF_CONT	= @@RF_CONT,
	_PD_EXECUTE	= @@PD_EXECUTE,
	_PD_EXIT	= @@PD_EXIT,
	_PD_FRAME_LEN	= @@PD_FRAME_LEN,
	_PD_UPDATER	= @@PD_UPDATER,
	_P_FRONT	= @@P_FRONT,
	_P_BACK		= @@P_BACK,
	_SF_OWNER	= @@SF_OWNER,
	_V_BYTES	= @@V_BYTES,
	);

>_#


/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/


	.text

	;;; -----------------------------------------------------------------
	;;; _POPENTER -- call a pop procedure
	;;; normal checking entry
	;;; uses:	appnum$, appstruct$
	;;; used by:
	;;; assumptions:
	;;;	A2 must be zero
	;;; arguments:
	;;;	D0	pop object to apply
	;;; results:
	;;; registers blown:
	;;;	D0	(object)
	;;;	A0	(various addresses)
	;;; -----------------------------------------------------------------

	;;; normal checking entry
DEF_C_LAB (_popenter)
	btst	#0, d0		;;; isnumber?
	bnes	appnum$		;;; branch if so
	movl	d0, a0
	cmpl	#C_LAB(procedure_key), a0@(_KEY) ;;; object has procedure key?
	bnes	appstruct$	;;; nope, so jump
	movl	a0@, a0		;;; get execute address
	jmp	a0@		;;; ... and run it

	;;; applying a number! run key apply proc
appnum$:
	movl	d0,a6@-		;;; stack num
	movl	C_LAB(integer_key)+_K_APPLY, a0  ;;; ref of integer key apply
	btst	#1,d0		;;; isinteger?
	bnes	1$		;;; branch if so
	movl	C_LAB(weakref decimal_key)+_K_APPLY, a0  ;;; ref of decimal key apply
1$: 	movl	a0@(_RF_CONT), a0 ;;; key apply proc
	movl	a0@, a0		;;; execute address
	jmp 	a0@		;;; run it

	;;; applying a structure -- run key apply proc
appstruct$:
	movl	d0, a6@-	;;; stack structure
	movl	a0@(_KEY), a0	;;; get key of structure
	movl	a0@(_K_APPLY), a0	;;; get ref of key_apply proc
	movl	a0@(_RF_CONT), a0	;;; proc
	movl	a0@, a0		;;; execute address
	jmp	a0@		;;; execute it


	;;; -----------------------------------------------------------------
	;;; _CHECKPLOGALL -- check prolog stacks
	;;; _CHECKALL	-- check normal stacks
	;;; _CHECKINTERRUPT -- check for interrupt flag set
	;;; used by:	??
	;;; arguments:	none
	;;; results:	none
	;;; registers blown:
	;;;	A0
	;;; -----------------------------------------------------------------

DEF_C_LAB (_checkplogall)
	lea	C_LAB(_special_var_block), a0
	movl	a0@(_SVB_OFFS(_plog_trail_sp)), d0
	cmpl	a0@(_SVB_OFFS(_plog_trail_lim)), d0	;;; trail overflow?
	bcss	checkall_cmp			;;; nope, its okay
	jmp	XC_LAB(weakref[prologvar_key] Sys$-Plog$-Area_overflow)	;;; fix it up

DEF_C_LAB (_checkall)
	lea 	C_LAB(_special_var_block), a0
checkall_cmp:
	cmpl	a0@(_SVB_OFFS(_call_stack_lim)), sp	;;; system stack okay?
	bcss	3$				;;; branch if too long
	cmpl	a0@(_SVB_OFFS(_userlim)), a6	;;; user stack okay?
	bcss	4$				;;; branch if too long
1$:	tstl	a0@(_SVB_OFFS(_trap))		;;; signals pending?
	bnes	5$				;;; branch if so
2$:	rts					;;; everything okay - return

3$:	btst	#1,I_LAB(_disable)+3		;;; stack checks disabled?
	bnes	1$				;;; continue if so
	jmp	XC_LAB(Sys$-Call_overflow)	;;; else fix it up
4$:	btst	#1,I_LAB(_disable)+3		;;; stack checks disabled?
	bnes	1$				;;; continue if so
	jmp	XC_LAB(Sys$-User_overflow)	;;; else fix it up
5$:	btst	#0, I_LAB(_disable)+3		;;; signals disabled?
	bnes	2$				;;; return if so
	jmp	XC_LAB(Sys$-Async_raise_signal)	;;; chain this to handle signal


DEF_C_LAB (_checkinterrupt)
	tstl	I_LAB(_trap)		;;; signals pending?
	bnes	C_LAB(_checkall)	;;; jump if so
	rts				;;; else return

;;; ---------------------------------------------------------------------------

	;;; ------------------------------------------------------------------
	;;; Unwind the current stack frame, by jumping into the procedure's
	;;; exit code. This subroutine is called immediately after executing
	;;; an M_UNWIND operation, so that the (unwanted) return address into
	;;; the procedure being unwound is above this subroutine's return
	;;; address on the call stack.
	;;; The procedure's exit code finishes with an "rts", and we
	;;; replace the return address into the NEXT caller with the return from
	;;; this subroutine, but saving the former in CHAIN_REG (= d0) from
	;;; whence it can be restored with an M_CALL_WITH_RETURN operation.
DEF_C_LAB (_unwind_frame)
	movl	sp@(8), a0		;;; caller procedure
	moveq	#0, d0
	movb	a0@(_PD_FRAME_LEN), d0  ;;; stack frame length in words
	aslw	#2, d0			;;; now in bytes
	lea	sp@(4, d0:W), a1	;;; addr of return addr into NEXT caller
	movl	a1@, d0			;;; save in CHAIN_REG
	movl	sp@, a1@		;;; replace with my return
	addql	#8, sp			;;; erase my return and unwanted return
	movl	a0@(_PD_EXIT), a0	;;; PD_EXIT addr of procedure
	jmp	a0@			;;; go into procedure exit code

	;;; ------------------------------------------------------------------
	;;; Routines to chain a procedure, either directly or out of the
	;;; current caller. These are executed as a result of displacing a stack
	;;; frame return address with their address and then returning with an
	;;; "rts"; in the case of _syschain, the displaced return is saved in
	;;; CHAIN_REG.
DEF_C_LAB (_syschain_caller)
	subql	#4, sp			;;; need dummy return address for _unwind_frame
	bsrs	C_LAB(_unwind_frame)	;;; pop frame for caller
DEF_C_LAB (_syschain)
	movl	d0, sp@-		;;; reinstate return address from CHAIN_REG
	movl	a6@+, d0		;;; procedure to chain on user stack
	bra 	C_LAB(_popenter)	;;; run it

	;;; The same, but with no check for procedure
DEF_C_LAB (_sysncchain_caller)
	subql	#4, sp	;;; need dummy return address for _unwind_frame
	bsrs	C_LAB(_unwind_frame)	;;; pop frame for caller
DEF_C_LAB (_sysncchain)
	movl	d0, sp@-	;;; reinstate return address from CHAIN_REG
	movl	a6@+, a0	;;; address of procedure
	movl	a0@, a0		;;; PD_EXECUTE address
	jmp	a0@		;;; do it


;;; -------------------------------------------------------------------------

	;;; -----------------------------------------------------------------
	;;; _POPUENTER, _POPUNCENTER -- run updater of item
	;;; can be a procedure, or an arbitrary object, which is updated.
	;;; integers and decimals are checked for specially, because they aren't
	;;; pointers.  _popuncenter only checks that the updater exists,
	;;; _popuenter checks for the type of the object.
	;;; uses:	upnum$  update a number
	;;;	upstr$  update a structure
	;;;	upexc$  update complainer
	;;;	upkapp$ updater key apply
	;;; used by:	everything
	;;; assumptions:  a2 zero
	;;; arguments:
	;;;	D0	pop object to be applied as updater
	;;; results:	none
	;;; registers blown:
	;;;	D0	(unchanged throughout)
	;;;	A0	(various addresses during mass indirection)
	;;; -----------------------------------------------------------------

DEF_C_LAB (_popuenter)
	btst	#0,d0			;;; isnumber
	bnes	upnum$			;;; yes -- update number
	cmpl	#C_LAB(procedure_key),a2@(_KEY,d0:L) ;;; a procedure
	bnes	upstr$			;;; no -- update structure

	;;; fall through if procedure
DEF_C_LAB (_popuncenter)
	movl	a2@(_PD_UPDATER,d0:L), a0	;;; get updater
	cmpl	d4, a0		;;; is it false?
	beqs	upexc$		;;; yes, complain
	movl	a0@, a0		;;; fetch the execute address
	jmp	a0@		;;; and hope to it

	;;; updater was false
upexc$: movl	d0, a6@-		;;; stack object
	jmp	XC_LAB(-> Sys$-Exec_nonpd) ;;; run exception procedure

	;;; applying number as updater
upnum$: movl	C_LAB(integer_key)+_K_APPLY, a0  ;;; integer key apply in ref
	btst	#1,d0			;;; test for integer/decimal
	bnes	upkapp$			;;; branch if integer
	movl	C_LAB(weakref decimal_key)+_K_APPLY, a0  ;;; decimal key apply in ref
	bras	upkapp$			;;; do it

	;;; updating a structure
upstr$: movl	a2@(_KEY,d0:L), a0	;;; key of object -> a0
	movl	a0@(_K_APPLY), a0	;;; app part in ref -> a0

upkapp$:
	movl	a0@(_RF_CONT), a0	;;; cont -> a0
	movl	a0@(_PD_UPDATER), a0	;;; fetch the updater
	cmpl	d4, a0			;;; is there one?
	beqs	upexc$			;;; nope -- jump
	movl	d0, a6@-		;;; give as arg to key apply proc
	movl	a0@, a0			;;; get the execute field
	jmp	a0@			;;; and hop to it



	;;; erase 1 longword from the call stack and chain Callstack_reset
	;;; (used by Callstack_reset in cleaning up)
DEF_C_LAB (_erase_sp_1)
	movl	sp@+, sp@			;;; push return address up one
	jmp	XC_LAB(Sys$-Callstack_reset)	;;; try again

	;;; -----------------------------------------------------------------
	;;; _NEXTFRAME -- get next stack frame
	;;; pointer assumed to aim at owner
	;;; uses:	--
	;;; arguments:	on pop stack
	;;;	top ->  frame pointer
	;;; results:	on pop stack
	;;;	top ->  pointer to next frame's owner
	;;; registers blown:
	;;;	D0	(this frame)
	;;;	D1	(frame length -- byte)
	;;;	A0	(address of owner)
	;;; -----------------------------------------------------------------
DEF_C_LAB (_nextframe)
	movl	a6@, a0			;;; frame pointer
	movl	a0@(_SF_OWNER), a1  	;;; owner address
	moveq	#0, d0			;;; clean rest of longword
	movb	a1@(_PD_FRAME_LEN), d0  ;;; frame size in longwords
	aslw	#2,d0			;;; now bytes
	addl	a0, d0			;;; + pointer = pointer to next
	movl	d0, a6@			;;; and put on stack
	rts

	;;; -----------------------------------------------------------------
	;;; _SUBSS -- fast routines for subscripting string
	;;; uses:	--
	;;; used by:	fast_subscrs
	;;; arguments: on pop stack
	;;;	top ->  address of string
	;;;	pop integer subscript
	;;; results: on pop stack
	;;;	top ->  character, as a pop integer
	;;; registers blown:
	;;;	D0	popint subscript/character
	;;;	A0	string
	;;; -----------------------------------------------------------------
DEF_C_LAB (_subss)
	movl	a6@+, a0	;;; address of string
	movl	a6@, d0		;;; pop int subscript
	asrl	#2, d0		;;; now a machine integer
	moveq	#0, d1		;;; make the top part zeros
	movb	a0@(_V_BYTES-1,d0:L), d1	;;; fish out the char
	aslw	#2, d1		;;; soon to be (gasp) ...
	addqw	#3, d1		;;; ... a POP INTEGER!
	movl	d1, a6@		;;; on the stack
	rts

	;;; -----------------------------------------------------------------
	;;; _U_SUBSS -- fast update for subscrs
	;;; uses:	---
	;;; used by:	fast_subscrs updater
	;;; arguments:	on pop stack
	;;;	top ->  address of string
	;;;	subscript as pop integer
	;;;	character as pop integer
	;;; results:	none
	;;; registers blown:
	;;;	D0	(pop integer subscript)
	;;;	D1	(character)
	;;;	A0	(string address)
	;;; -----------------------------------------------------------------
DEF_C_LAB(-> _subss)
DEF_C_LAB (_u_subss)
	movl	a6@+, a0	;;; address of string
	movl	a6@+, d0	;;; pop integer subscript
	asrl	#2, d0		;;; now a machine integer
	movl	a6@+, d1	;;; the character
	asrl	#2, d1		;;; now a machine integer
	movb	d1, a0@(_V_BYTES-1,d0:L)	;;; insert it
	rts

	;;; =================================================================
	;;;	P R E D I C A T E S
	;;; each performs given function, returns true or false.  one argument
	;;; is left on the pop stack afterwards.
	;;;
	;;; _ISPOINTER	item is a pop pointer
	;;; _ISNONPOINTER item isn't a pop pointer
	;;; _ISPINT	item is a pop integer
	;;; _HASKEY	given key is key of given object
	;;; _BITST	mask bits of two items with AND
	;;; _GR	unsigned integer >
	;;; _GREQ	unsigned integer >=
	;;; _LT	unsigned integer <
	;;; _LTEQ	unsigned integer <=
	;;; _SGR	signed integer >
	;;; _SGREQ	signed integer >=
	;;; _SLT	signed integer <
	;;; _SLTEQ	signed integer <=
	;;; _NT	item is false
	;;; _NEQ	two items are equal
	;;; _EQ	two items aren't equal
	;;; _ZERO	item is zero
	;;; _NEG	integer is negative
	;;;
	;;; assumptions:
	;;;	a2 is zero
	;;; arguments: on pop stack
	;;;	top ->  one item
	;;;	another item	(possibly missing)
	;;; results: on pop stack
	;;;	top ->  <boolean>
	;;;	one argument
	;;; registers blown:
	;;;	D0
	;;;	D1
	;;; -----------------------------------------------------------------

DEF_C_LAB (_iscompound)
	btst	#0,a6@(3)	;;; bottom bit clear means pointer
	beqs	true1
	bras	false1

DEF_C_LAB (_issimple)
	btst	#0,a6@(3)	;;; bottom bit set means nonpointer
	bnes	true1
	bras	false1

DEF_C_LAB (_isinteger)
	btst	#1,a6@(3)	;;; bit1 set means pop integer
	bnes	true1
	bras	false1

	;;; item has given key ----------------------------------------------
	;;; top item on stack is the key of second item?
DEF_C_LAB (_haskey)
	movl	a6@+, d0	;;; the key
	movl	a6@, d1		;;; the object
	btst	#0, d1		;;; branch if popnum
	bnes	false1
	cmpl	a2@(_KEY,d1:L), d0  ;;; key = keyof(object)?
	beqs	true1
	bras	false1

	;;; bitwise AND two items -------------------------------------------
DEF_C_LAB 4 (_bitst)
	movl	a6@+,d0		;;; get first object
	andl	a6@,d0		;;; AND them
	bnes	true1		;;; true if any bits set in both
	bras	false1

	;;; -----------------------------------------------------------------
	;;; TRUE1, FALSE1 -- replace top of stack with a boolean; return
	;;; uses:	--
	;;; used by:	booleans
	;;; arguments:	none
	;;; results:	on pop stack
	;;;	top ->  <true> or <false>
	;;; registers blown:	none
	;;; -----------------------------------------------------------------

	;;; return false ----------------------------------------------------
false1: movl	d4, a6@
	rts
false1s:
	movl	d4, a6@-	;;; stack it
	rts

	;;; return true -----------------------------------------------------
true1:  movl	#C_LAB(true),a6@
	rts
true1s: movl	#C_LAB(true),a6@-	;;; stack it
	rts

	;;; unsigned greater than -------------------------------------------
DEF_C_LAB 6 (_gr)
	cmpml	a6@+,a6@+
	bhis	true1s
	bras	false1s

	;;; unsigned greater than or equal ----------------------------------
DEF_C_LAB 6 (_greq)
	cmpml	a6@+,a6@+
	bccs	true1s
	bras	false1s

	;;; unsigned less than ----------------------------------------------
DEF_C_LAB 6 (_lt)
	cmpml	a6@+,a6@+
	bcss	true1s
	bras	false1s

	;;; unsigned less than or equal -------------------------------------
DEF_C_LAB 6 (_lteq)
	cmpml	a6@+,a6@+
	blss	true1s
	bras	false1s

	;;; signed greater than ---------------------------------------------
DEF_C_LAB 6 (_sgr)
	cmpml	a6@+,a6@+
	bgts	true1s
	bras	false1s

	;;; signed greater than or equal ------------------------------------
DEF_C_LAB 6 (_sgreq)
	cmpml	a6@+,a6@+
	bges	true1s
	bras	false1s

	;;; signed less than ------------------------------------------------
DEF_C_LAB 6 (_slt)
	cmpml	a6@+,a6@+
	blts	true1s
	bras	false1s

	;;; signed less than or equal ---------------------------------------
DEF_C_LAB 6 (_slteq)
	cmpml	a6@+,a6@+
	bles	true1s
	bras	false1s

	;;; boolean NOT -----------------------------------------------------
DEF_C_LAB (_not)
	cmpl	a6@, d4
	beqs	true1
	bras	false1

	;;; not equal (pop identity) ----------------------------------------
DEF_C_LAB 7 (_neq)
	cmpml	a6@+,a6@+
	bnes	true1s
	bras	false1s

	;;; equal (pop identity) --------------------------------------------
DEF_C_LAB 7 (_eq)
	cmpml	a6@+,a6@+
	beqs	true1s
	bras	false1s

	;;; machine zero ----------------------------------------------------
DEF_C_LAB (_zero)
	tstl	a6@
	beqs	true1
	bras	false1

	;;; negative --------------------------------------------------------
DEF_C_LAB (_neg)
	tstl	a6@
	bmis	true1
	bras	false1

	;;; -----------------------------------------------------------------
	;;; _DATAKEY -- get key of any pop object
	;;; bottom bits of pop objects: pointer 00, integer 11, decimal 01
	;;; uses:	--
	;;; used by:	??
	;;; arguments: on pop stack
	;;;	top ->  pop object
	;;; results: on pop stack
	;;;	top ->  the key
	;;; registers blown:
	;;;	A0
	;;; -----------------------------------------------------------------
DEF_C_LAB (_datakey)
	movl	a6@,d0		;;; the object from the stack
	btst	#0,d0		;;; bottom bit
	bnes	1$		;;; branch if it isn't pointer
	;;; bottom bit is zero
	movl	a2@(_KEY,d0:L),a6@  ;;; stack its key
	rts			;;; return
	;;; bottom bit is 1
1$:	btst	#1,d0
	beqs	2$		;;; branch if decimal
	;;; bit 1 is 1
	movl	#C_LAB(integer_key),a6@  ;;; put integer key
	rts			;;; return
	;;; bit 1 is zero
2$:	movl	#C_LAB(weakref decimal_key),a6@  ;;; decimal key
	rts			;;; return


	;;; optimise subroutine for "conspair"
DEF_C_LAB (_conspair)
	lea	I_LAB(Sys$- _free_pairs), a1
	movl	a1@, d0			;;; get free pair list
	btst	#0, d0			;;; if simple, then none left
	bnes	1$
	movl	d0, a0
	movl	a0@(_P_BACK), a1@	;;; move the next back to _free_pairs
	movl	a6@+, a0@(_P_BACK)	;;; init back
	movl	a6@, a0@(_P_FRONT)	;;; init front
	movl	a0, a6@			;;; return the pair
	rts
1$:	jmp	XC_LAB(Sys$-Conspair)	;;; none left, chain to Conspair

	;;; -----------------------------------------------------------------
	;;; _LOCC -- search string for character
	;;; uses:	--
	;;; used by:	(possibly will be used where VAX locc is used)
	;;; arguments:	on pop stack
	;;;	top ->  character
	;;;	length of string
	;;;	address of string
	;;; results: on pop stack
	;;;	top ->  offset to character in string, or -1
	;;; registers blown:
	;;;	D0
	;;;	D1
	;;;	D2
	;;;	A0
	;;; -----------------------------------------------------------------
DEF_C_LAB (_locc)
	movl	a6@+,d0		;;; character
	movl	a6@+,d1		;;; length of string
	movl	a6@,a0		;;; address of string
	movl	a0,d2		;;; copy of address
1$:	subql	#1,d1		;;; one less to look at
	blts	3$		;;; found end of string?
	cmpb	a0@+,d0		;;; look for character
	bnes	1$		;;; loop if not found
	;;; found it
	;;; a0 -> matched char + 1
	;;; d2 is original address
2$:	subql	#1, a0		;;; address of char
	subl	d2, a0		;;; offset to char
	movl	a0, a6@		;;; ... stacked
	rts			;;; return
3$:	;;; didn't find it
	movl	#-1,a6@		;;; minus 1 overwrites start address
	rts

	;;; -----------------------------------------------------------------
	;;; _SKPC -- skip string for character
	;;; uses:	--
	;;; used by:	(possibly will be used where VAX skpc is used)
	;;; arguments:	on pop stack
	;;;	top ->  character
	;;;	length of string
	;;;	address of string
	;;; results: on pop stack
	;;;	top ->  offset to different character in string, or -1
	;;; registers blown:
	;;;	D0
	;;;	D1
	;;;	D2
	;;;	A0
	;;; -----------------------------------------------------------------
DEF_C_LAB (_skpc)
	movl	a6@+,d0		;;; character
	movl	a6@+,d1		;;; length of string
	movl	a6@,a0		;;; address of string
	movl	a0,d2		;;; copy of address
1$:	subql	#1,d1		;;; one less to look at
	blts	3$		;;; found end of string?
	cmpb	a0@+,d0		;;; look for character
	beqs	1$		;;; loop if found
	;;; found something else
	;;; a0 -> matched char + 1
	;;; d2 is original address
2$:	subql	#1, a0		;;; address of char
	subl	d2, a0		;;; offset to char
	movl	a0, a6@		;;; ... stacked
	rts			;;; return
3$:	;;; didn't find anything else
	movl	#-1,a6@		;;; minus 1 overwrites start address
	rts


;;; --------------------------------------------------------------------------

	;;; move the user stack up or down
DEF_C_LAB (_move_userstack)
	movl	a6@+, d2		;;; amount to shift in bytes
	movl	I_LAB(_userhi), d0	;;; old userhi
	subl	a6, d0			;;; length of userstack to move in d0
	movl	a6, a0			;;; u/s top in a0 - moving from here
	addl	d2, I_LAB(_userhi)	;;; new userhi
	movl	a6, a1
	addl	d2, a1			;;; where moving to in a1
	movl	a1, a6			;;; is new userstack pointer
	jmp	movchars_la		;;; move the user stack and return

;;; -------------------------------------------------------------------------

	;;; Set registers for pop environment
.globl reset_pop_reg_environ
reset_pop_reg_environ:
	;;; set constant registers
	movl	#0, a2			;;; a2 must always be zero
	movl	#C_LAB(false), d4	;;; d4 must always be false
	;;; set pop lvar registers to sensible values (false)
	movl	d4, d5			;;; pop lvar
	movl	d4, d6			;;; and the other one
	rts


/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 10 1997
	Removed _mt*chc subroutine
--- John Gibson, Oct 18 1994
	free*pairs -> _free_pairs
--- John Gibson, Nov 10 1993
	Renamed amisc.s and moved the main routine to amain.s
--- John Gibson, Oct  2 1992
	Got rid of _c*mpc_order
--- John Gibson, Sep 25 1990
	Fixed bug in _unwind_frame where sp was being incremented over 2
	words on the stack and then relying on accessing the first of those
	at -ve offset. This failed if a signal interrupted, since signal
	handler stack frame overwrote anything below sp.
--- John Gibson, May 15 1990
	Changed _checkall so that -Async_raise_signal- not called
	when _disable interrupt bit set (also now doesn't clear _trap
	if it is called).
--- John Gibson, Dec  7 1989
	Changes for new pop pointers (explicit offsets for RF_CONT,P_FRONT)
--- John Gibson, Nov 29 1989
	Added reset_pop_reg_environ
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Jan 15 1989
	Replaced use of UC_LAB etc for updater with -> before pathname
--- John Gibson, Sep  2 1988
	Replaced _SVB macros with _SVB_OFFS(identifier name)
--- John Gibson, Aug 22 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jun  3 1988
	Added name Sys$-_entry_point to _main (used by poplink to force
	inclusion of this routine).
--- John Gibson, Apr 18 1988
	Array routines moved to aarith.s
--- Roger Evans, Apr 18 1988
	moved Async_raise_signal to section Sys
--- Roger Evans, Mar 22 1988 Installed signal handling code
--- John Gibson, Feb  9 1988
	integer_key and decimal_key now in section Sys.
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
