/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 * File:            S.sun3/src/aprolog.s
 * Purpose:
 * Author:          John Gibson (see revisions)
 */

;;; --------------------- ROUTINES FOR PROLOG -------------------------------

#_<

#_INCLUDE 'declare.ph'

constant
	procedure (Sys$-Plog$-Assign_pair, Sys$-Plog$-New_var),
	_checkplogall
	;

vars
	_plog_trail_sp, _plog_next_var, _plog_contn_sp, _plog_contn_top,
	_plog_save_contn_sp, _plog_trail_barrier, _plog_trail_lim,
	_call_stack_lim
	;

lconstant macro (
	_KEY		= @@KEY,
	_PGV_CONT	= @@PGV_CONT,
	_PGV_SIZE	= @@(struct PLOGVAR)++,
	_PGT_FUNCTOR	= @@PGT_FUNCTOR,
	_PGT_LENGTH	= @@PGT_LENGTH,
	_P_FRONT	= @@P_FRONT,
	_P_BACK		= @@P_BACK,
	_SF_PLGSV_CONTN_TOP	= @@SF_PLGSV_CONTN_TOP,
	_SF_PLGSV_NEXT_VAR	= @@SF_PLGSV_NEXT_VAR,
	_SF_PLGSV_TRAIL_SP	= @@SF_PLGSV_TRAIL_SP,
	);

>_#


/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.text

	;;; Save the prolog continuation stack, trail and next free var
	;;; in the corresponding saved locations. Then do stack overflow and
	;;; interrupt checks.
DEF_C_LAB (_prolog_save_check)
	lea	C_LAB(_special_var_block), a0
	;;; save next var
	movl	a0@(_SVB_OFFS(_plog_next_var)), sp@(4+_SF_PLGSV_NEXT_VAR)
	;;; save trail end pointer, relative to trail barrier
	movl	a0@(_SVB_OFFS(_plog_trail_sp)), d0
	movl	d0, d1					;;; save for later
	subl	a0@(_SVB_OFFS(_plog_trail_barrier)), d0	;;; make relative
	movl	d0, sp@(4+_SF_PLGSV_TRAIL_SP)
	;;; save continuation stack top and pointer
	;;; save_contn_sp is a dynamic local (see plogcore.p)
	movl	a0@(_SVB_OFFS(_plog_contn_sp)), a0@(_SVB_OFFS(_plog_save_contn_sp))
	movl	a0@(_SVB_OFFS(_plog_contn_top)), sp@(4+_SF_PLGSV_CONTN_TOP)
	;;; do checks
	cmpl    a0@(_SVB_OFFS(_plog_trail_lim)), d1	;;; trail overflow?
	bccs	1$				;;; branch if so
	cmpl    a0@(_SVB_OFFS(_call_stack_lim)), sp	;;; system stack okay?
	bcss	1$				;;; branch if too long
	cmpl    a0@(_SVB_OFFS(_userlim)), a6	;;; user stack okay?
	bcss	1$				;;; branch if too long
	tstl	a0@(_SVB_OFFS(_trap))		;;; signals pending?
	bnes    1$				;;; branch if so
	rts					;;; everything okay - return
1$:	jmp	C_LAB(_checkplogall)		;;; else redo checks


	;;; restore the contn stack and next free var from the current
	;;; saved values, and unwind the trail back to the saved position,
	;;; resetting vars to undef
DEF_C_LAB (_prolog_restore)
	lea	C_LAB(_special_var_block), a1
	;;; restore next var
	movl	sp@(4+_SF_PLGSV_NEXT_VAR), a1@(_SVB_OFFS(_plog_next_var))

	;;; restore contn top and pointer
	movl	a1@(_SVB_OFFS(_plog_save_contn_sp)), a1@(_SVB_OFFS(_plog_contn_sp))
	movl	sp@(4+_SF_PLGSV_CONTN_TOP), a1@(_SVB_OFFS(_plog_contn_top))

	;;; restore trail end pointer, setting plogvars back to undef
	movl	sp@(4+_SF_PLGSV_TRAIL_SP), a0
	addl	a1@(_SVB_OFFS(_plog_trail_barrier)), a0
	movl	a1@(_SVB_OFFS(_plog_trail_sp)), d0	;;; current end
	cmpl	d0, a0				;;; reached end?
	bccs	2$				;;; br if so
	movl	a0, a1@(_SVB_OFFS(_plog_trail_sp))	;;; set new end
1$:	movl	a0@+, a1			;;; the var
	movl	a1, a1@(_PGV_CONT)		;;; put var into its own PGV_CONT
	cmpl	d0, a0				;;; reached end?
	bcss	1$				;;; br if not
2$:	rts

	;;; unify against atom. arg in d0, atom in d1
DEF_C_LAB (_prolog_unify_atom)
	movl	#C_LAB(prologvar_key), d2	;;; get the key into a reg
1$:	btst	#0, d0			;;; item is simple?
	bnes	2$			;;; go if so
	movl	d0, a0			;;; get to A reg
	cmpl	a0@(_KEY), d2		;;; item is plogvar?
	bnes	2$			;;; no: compare item
	movl	a0@(_PGV_CONT), d0	;;; deref one link of plogvar
	cmpl	d0, a0			;;; cont(item) == item? (end of chain)
	bnes	1$			;;; not undef -- go for more
	movl	d1, a0@(_PGV_CONT)	;;; assign atom to cont
	lea	I_LAB(_plog_trail_sp), a0
	movl	a0@, a1			;;; get trail pointer
	movl	d0, a1@+		;;; push variable
	movl	a1, a0@			;;; put trail pointer back
	moveq	#0, d0			;;; leave flags set equal
	rts
	;;; item is nonvar (in d0)
2$:	cmpl	d0, d1			;;; leave flags set for equal/not equal
	rts


	;;; prolog pair switch
	;;; arg is in d0
DEF_C_LAB (_prolog_pair_switch)
	movl	#C_LAB(prologvar_key), d1	;;; get the key into a reg
1$:	btst	#0, d0			;;; item is simple?
	bnes	3$			;;; go if so
	movl	d0, a0			;;; get to A reg
	cmpl	a0@(_KEY), d1		;;; item is plogvar?
	bnes	2$			;;; go if no: dereffed to non-variable
	movl	a0@(_PGV_CONT), d0	;;; deref one link of plogvar
	cmpl	d0, a0			;;; cont(item) == item? (end of chain)
	bnes	1$			;;; not undef, go for more
	;;; undef var - push it and return flags set to greater than
	movl	d0, a6@-		;;; sets flags (addr is > 0)
	rts
	;;; compound item
2$:	cmpl	#C_LAB(pair_key), a0@(_KEY) ;;; is pair?
	bnes	3$			;;; no
	;;; pair - return flags set to equal (already are)
	rts
	;;; anything else - return flags set to less than
3$:	moveq	#-1, d1			;;; set less than
	rts

	;;; just like pair_switch but checks functor and length (== arity + 1)
	;;; arg is in d0, functor in d1, popint length in d2
DEF_C_LAB (_prolog_term_switch)
	movl	#C_LAB(prologvar_key), d3	;;; get the key into a reg
1$:	btst	#0, d0			;;; item is simple?
	bnes	3$			;;; go if so, return notvar, notfunc
	movl	d0, a0			;;; get to A reg
	cmpl	a0@(_KEY), d3		;;; item is plogvar?
	bnes	2$			;;; go if no: dereffed to non variable
	movl	a0@(_PGV_CONT), d0	;;; deref one link of plogvar
	cmpl	d0, a0			;;; cont(item) == item? (end of chain)
	bnes	1$			;;; not undef, go for more
	;;; undef var - push it and return flags set to greater than
	movl	d0, a6@-		;;; sets flags (addr is > 0)
	rts
	;;; compound item
2$:	cmpl	#C_LAB(prologterm_key), a0@(_KEY) ;;; isprologterm?
	bnes	3$			;;; if not go return notfunctor, notvar
	cmpl	a0@(_PGT_FUNCTOR), d1	;;; is right functor?
	bnes	3$			;;; if not go return notfunctor, notvar
	asrl	#2, d2			;;; convert length to sysint
	cmpl	a0@(_PGT_LENGTH), d2	;;; right length?
	bnes	3$			;;; if not go return notfunctor, notvar
	;;; correct term - return flags set to equal (already are)
	rts
	;;; anything else - return flags set to less than
3$:	moveq	#-1, d1			;;; set less than
	rts

	;;; assign to a prolog variable
DEF_C_LAB (_prolog_assign)
	movl	a6@+, d0		;;; item into d0
	bras	plog_assign

DEF_C_LAB (_prolog_assign_pair)
	lea	I_LAB(Sys$- _free_pairs), a1
	movl	a1@, d0			;;; get free pair list
	btst	#0, d0			;;; if simple, then none left
	bnes	nopair
	movl	d0, a0
	movl	a0@(_P_BACK), a1@	;;; move the next back to _free_pairs
	movl	a6@+, a0@(_P_BACK)	;;; init back
	movl	a6@+, a0@(_P_FRONT)	;;; init front
	;;; assign item in d0 to var and push on trail
plog_assign:
	movl	a6@+, a0		;;; prolog var into a0
	movl	d0, a0@(_PGV_CONT)	;;; do the assign
	movl	I_LAB(_plog_trail_sp), a1	;;; trail stack pointer
	movl	a0, a1@+			;;; push var on stack
	movl	a1, I_LAB(_plog_trail_sp)	;;; update pointer
	rts

	;;; none left, chain this for more
nopair:	jmp	XC_LAB(Sys$-Plog$-Assign_pair)


;;; --- OPTIONAL ASSEMBLER CODE ----------------------------------------------
;;; optional assembler optimised stuff, for code normally in pop.
;;; see bottom of syscomp/sysdefs.p for when this is used
;;; and plogcore.p, plogterms.p for equivalent pop code

	;;; dereference a chain of prolog variables
DEF_C_LAB (_prolog_deref)
	movl	a6@, d0			;;; get item
	movl	#C_LAB(prologvar_key), d1	;;; get the key into a reg
1$:	btst	#0, d0			;;; item is simple?
	bnes	3$			;;; go if so
	movl	d0, a0			;;; get to A reg
	cmpl	a0@(_KEY), d1		;;; item is plogvar?
	bnes	3$			;;; no: return item
	movl	a0@(_PGV_CONT), d0	;;; deref one link of plogvar
	cmpl	d0, a0			;;; cont(item) == item? (end of chain)
	bnes	1$			;;; no -- go back for more
3$:	movl	d0, a6@			;;; return dereffed item
	rts

	;;; return a new prolog variable from the free block, unless no
	;;; more space -- then use pop New_var, which allocates space.
DEF_C_LAB (_prolog_newvar)
	lea	I_LAB(_plog_next_var), a1
	movl	a1@, a0			;;; next var in block
	cmpl	#C_LAB(ref_key), a0@(_KEY)	;;; end-of-block reference?
	beqs	1$			;;; branch if so
	movl	a0, a0@(_PGV_CONT)	;;; make this one undef
	movl	a0, a6@-		;;; and return it
	addql	#_PGV_SIZE, a0		;;; address of next var
	movl	a0, a1@			;;; move on to next
	rts
1$:	jmp	XC_LAB(Sys$-Plog$-New_var)	;;; call this for some more


/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct 18 1994
	free*pairs -> _free_pairs
--- John Gibson, Dec  7 1989
	Changes for new pop pointers (explicit use of PGV_CONT)
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Apr  9 1989
	Prolog_newvar, Prolog_assign_pair renamed into section Sys$-Plog
--- John Gibson, Sep  2 1988
	Replaced _SVB macros with _SVB_OFFS(identifier name)
--- John Gibson, Aug 22 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
