/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.68000/src/array_cons.p
 > Purpose:			Constructing array procedures (68K version)
 > Author:          John Gibson (see revisions)
 > Related Files:   C.68000/src/ass.p, C.all/src/arrays.p
 */


#_INCLUDE 'declare.ph'

global constant
		_array_sub
	;


;;; ---------------------------------------------------------------------

section $-Sys;

	/*	Construct a raw array procedure. _________tabsize is the word offset size of
		the array params starting at PD_ARRAY_TABLE.
	*/
define Array$-Cons(_tabsize) -> _arrayp;
	lvars _tabsize, _arrayp, _drop_ptr, _size;

	;;; macros for dropping longs and shorts at _drop_ptr
	lconstant macro (
		_LONG	= [_drop_ptr!(l)++ -> _drop_ptr],
		_SHORT	= [_drop_ptr!(s)++ -> _drop_ptr]
		);

	;;; get procedure record -- 4 words of code
	@@PD_ARRAY_TABLE{_tabsize} _add @@(w)[_4] _sub @@POPBASE -> _size;
	Get_store(_size) -> _arrayp;

	;;; initialise some of procedure header
	##(w){_size} -> _arrayp!PD_LENGTH;
	_0 	   ->> _arrayp!PD_REGMASK
		   ->> _arrayp!PD_NUM_STK_VARS
		   ->> _arrayp!PD_NUM_PSTK_VARS
		   ->> _arrayp!PD_NLOCALS
		   ->  _arrayp!PD_GC_SCAN_LEN;
	##SF_LOCALS -> _arrayp!PD_GC_OFFSET_LEN;
	##SF_LOCALS _sub ##SF_RETURN_ADDR -> _arrayp!PD_FRAME_LEN;

	;;; start of code
	_arrayp@PD_ARRAY_TABLE{_tabsize} ->> _drop_ptr -> _arrayp!PD_EXECUTE;

	;;; owner address for stack frame
	_16:487A					-> _SHORT;	;;; pea pc@(d)
	@@(w){_arrayp, _drop_ptr}	-> _SHORT; 	;;; proc addr

	;;; call the array subscript routine
	;;; (picks up parameters from PD_ARRAY_TABLE, stacks computed
	;;; subscript and PD_ARRAY_VECTOR, and then chains PD_ARRAY_SUBSCR_PDR)
	_16:4EB9					-> _SHORT;	;;; jsr abs
	_array_sub					-> _LONG;

	;;; remove stack frame and return
	_drop_ptr -> _arrayp!PD_EXIT;	;;; pointer to exit code
	_16:588F					-> _SHORT;	;;; addql #4, sp
	_16:4E75					-> _SHORT;	;;; rts
enddefine;

endsection;		/* $-Sys */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 30 1994
		Simplified so that this machine-specific file now only has to
		construct a procedure with a stack frame and a call to _array_sub
		(_array_sub  picks up the parameters from PD_ARRAY_TABLE; these are
		planted by the machine-independent Get in arrays.p)
--- John Gibson, Feb  5 1989
		Initialisation of some procedure headrer fields moved to
		-newanyarray-
--- John Gibson, Mar 21 1988
		Rewrote to use _SHORT and _LONG macros to plant code rather than
		using ass.p procedures
--- John Gibson, Mar  8 1988
		Moved this out of partapply.p
 */
