/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 > File:            C.68000/src/pdr_compose.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 */

;;; --------------- COMPOSITION OF 2 PROCEDURES (68K) ----------------------

#_INCLUDE 'declare.ph'

;;; ---------------------------------------------------------------------

section $-Sys;

	;;; macros for dropping longs and shorts at _drop_ptr
lconstant macro (
	LONG	= [_drop_ptr!(l)++ -> _drop_ptr],
	SHORT	= [_drop_ptr!(s)++ -> _drop_ptr]
	);


	/*	Construct a raw procedure for composition of two procedures
		-- used by <>
	*/
define Cons_pcomposite() -> _comp;
	lvars _comp, _drop_ptr, _offs, _size;

	@@PD_COMPOSITE_TABLE[_6] _sub @@POPBASE -> _size;	;;; 6 longwords of code
	Get_store(_size) -> _comp;

	;;; initialise some of header
	##(w){_size} -> _comp!PD_LENGTH;
	_0		->> _comp!PD_REGMASK
			->> _comp!PD_NLOCALS
			->> _comp!PD_NUM_STK_VARS
			->> _comp!PD_NUM_PSTK_VARS
			->  _comp!PD_GC_SCAN_LEN;
	##SF_LOCALS -> _comp!PD_GC_OFFSET_LEN;
	##SF_LOCALS _sub ##SF_RETURN_ADDR  -> _comp!PD_FRAME_LEN;

	;;; start of instructions
	_comp@PD_COMPOSITE_TABLE ->> _drop_ptr -> _comp!PD_EXECUTE;

	;;; stack frame
	_16:487A -> SHORT;						;;; pea pc@(d)
	@@(w){_comp, _drop_ptr} -> SHORT;		;;; proc addr

	;;; plant code to call PD_COMPOSITE_P1 then PD_COMPOSITE_P2
	_0 -> _offs;
	fast_repeat 2 times
		;;; get PD_EXECUTE field - depends on the offset of this field
		;;; being 0. Can then do jsb (r0) instead of jsb @PD_EXECUTE(r0)
		_16:207A -> SHORT;					;;; movl pc@(d), a0
		@@(w){_comp@PD_COMPOSITE_P1{_offs}, _drop_ptr} -> SHORT;
		_16:2050 -> SHORT;					;;; movl a0@, a0
		_16:4E90 -> SHORT;					;;; jsr a0@
		@@(w)[_1] -> _offs
	endfast_repeat;

	_drop_ptr -> _comp!PD_EXIT;				;;; pointer to exit code
	_16:588F -> SHORT;						;;; addql #4, sp
	_16:4E75 -> SHORT						;;; rts
enddefine;

endsection;		/* $-Sys */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 12 1989
		Changed procedure name and moved common code to data_concat.p
--- John Gibson, Apr  1 1988
		Moved out of partapply.p
--- John Gibson, Mar 21 1988
		Rewrote to use SHORT and LONG macros to plant code rather than
		using ass.p procedures
 */
