/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.68000/src/syscomp/genproc.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 */

/* -------------------------------------------------------------------------

				GENERATE PROCEDURE CODE -- M68000 SYSTEMS
			(BLEASDALE-UNIX, HP9000 UX  & SUN-BERKELEY 4.2 UNIX)

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

section $-Popas$-M_trans;

global constant
		procedure (auto_operand, reg_in_operand, immediate_operand,
		commute_test, negate_test, perm_const_opnd),
	;

global vars
		current_pdr_label, current_pdr_exec_label, false_immediate
	;

	/****************************************************************
	* This file is contained entirely in section Genproc, and must  *
	*   define all the exports to section M_trans listed below.     *
	****************************************************************/

section Genproc =>

		/*	M-opcode Procedures */
		M_ADD
		M_ASH
		M_BIC
		M_BIM
		M_BIS
		M_BIT
		M_BRANCH
		M_BRANCH_std
		M_BRANCH_ON
		M_BRANCH_ON_INT
		M_CALL
		M_CALL_WITH_RETURN
		M_CALLSUB
		M_CHAIN
		M_CHAINSUB
		M_CLOSURE
		M_CMP
		M_CMPKEY
		M_CREATE_SF
		M_END
		M_ERASE
		M_LABEL
		M_LOGCOM
		M_MOVE
		M_MOVEb
		M_MOVEbit
		M_MOVEs
		M_MOVEsb
		M_MOVEsbit
		M_MOVEss
		M_MULT
		M_NEG
		M_PADD
		M_PADD_TEST
		M_PCMP
		M_PLOG_IFNOT_ATOM
		M_PLOG_TERM_SWITCH
		M_PSUB
		M_PSUB_TEST
		M_PTR_ADD_OFFS
		M_PTR_CMP
		M_PTR_SUB
		M_PTR_SUB_OFFS
		M_RETURN
		M_SETSTKLEN
		M_SUB
		M_TEST
		M_UNWIND_SF
		M_UPDb
		M_UPDbit
		M_UPDs

		/*	Registers */
		SP
		USP
		USP_+
		-_USP
		i_USP
;;;		i_USP_+			;;; these two are optional
;;;		ii_USP
		WK_ADDR_REG_1
		WK_ADDR_REG_2
		WK_REG
		CHAIN_REG

		/*	Register Lists */
		nonpop_registers
		pop_registers

		/*	Register Procedures */
		reglabel
		regnumber
		autoidreg

		/*	M-code Mapping of Subroutines */
		mc_inline_conditions_list
		mc_inline_procs_list

		/*	Procedures Needed by -m_optimise- etc */
		cvt_pop_subscript
		can_defer_opnd
		pdr_index_opnd

		/*	Procedure to Generate Code */
		mc_code_generator
	;


;;; --- REGISTERS ---------------------------------------------------------

	;;; registers -- these are numbered by their mask bits, i.e.
	;;; 0-7 = d0-d7, 8-15 = a0-a7

;;;---- Register Use --------------------------------------------------------
;;;  0 d0		working					8  a0		working
;;;  1 d1		working					9  a1		working
;;;  2 d2		working					10  a2		0
;;;  3 d3		working					11  a3		non-pop lvar
;;;  4 d4		address of false		12  a4		non-pop lvar
;;;  5 d5		pop lvar				13  a5		non-pop lvar
;;;  6 d6		pop lvar				14  a6		pop user stack pointer
;;;  7 d7		non-pop lvar			15  a7		stack pointer


constant
	RD0		= "d0",
	RD1		= "d1",
	RD2		= "d2",
	RD3		= "d3",
	RD_FALSE= "d4",
	RA0		= "a0",
	RA1		= "a1",
	RA_ZERO	= "a2",
	USP		= "a6",				;;; user stack pointer
	SP		= "a7",
	PC		= "pc",
	i_RA0	= {^RA0 0},
	-_RA0	= {^RA0 ^false},
	RA0_+	= {^RA0 ^true},
	i_RA1	= {^RA1 0},
	i_USP	= {^USP 0},			;;; top of user stack
	-_USP	= {^USP ^false},	;;; user stack autodecrement
	USP_+	= {^USP ^true},		;;; user stack autoincrement
	-_SP	= {^SP ^false},
	SP_+	= {^SP ^true},
		;


;;;-------- DEFINITIONS FOR TRANSLATING VM CODE TO MODEL ASSEMBLER --------

	/*	m_trans.p requires the definition of

			SP, USP, USP_+, -_USP and i_USP

		(It can also use ii_USP and i_USP_+ if these are available.)

	*/


	/*	WK_REG is used by -m_optimise- for eliminating stack pushes and pops
		between successive instructions
	*/
constant
	WK_REG = RD0;


	/*	WK_ADDR_REG_1 and 2 are used by -m_optimise- for building field
		access operands (ie of the the form {^reg ^offset} ) when an existing
		operand cannot be deferred directly ("can_defer_operand" having
		returned false for it). 1 is used for source operands, 2 for
		destination operands
	*/
constant
	WK_ADDR_REG_1 = RA0,
	WK_ADDR_REG_2 = RA1;


	/*	CHAIN_REG is the register used to save procedure operands for in-line
		chaining, and must not be corrupted by M_UNWIND_SF (ideally it should
		be an address register). It is also used to save return addresses for
		out-of-line chaining thru the subroutines _syschain and _sysncchain.
	*/
constant
	CHAIN_REG	= RD0;


	/*	-m_optimise- needs lists of pop and nonpop registers,
		in order of allocation; these lists start with a list of
		registers that should be local to every procedure.
		It also needs the properties -regnumber- and -reglabel-.
	*/
constant
	pop_registers		= [[] 5 6],
	nonpop_registers	= [[] 11 12 13 7];

define regnumber	= newassoc([]) enddefine;
define reglabel		= newassoc([]) enddefine;

	/* set up -regnumber- and -reglabel- properties */
procedure();
	lvars n, l;
	for n from 0 to 15 do
		consword(if n >= 8 then 'a' >< (n-8) else 'd' >< n endif) -> l;
		n -> regnumber(l);
		l -> reglabel(n);
	endfor
endprocedure();

define addressreg(x); lvars x; regnumber(x) and x(1) == `a` enddefine;
define datareg(x); lvars x; regnumber(x) and x(1) == `d` enddefine;


	/*	The procedure "autoidreg" is used by -m_optimise- in deciding
		whether a register can be used for autoincrement/decrement operands,
		ie of the form {^reg ^boolean}
	*/
identof("addressreg") -> identof("autoidreg");


	/*	can_defer_operand is used by -m_optimise- to create a field access
		operand from an existing operand, ie accessing the datum at offset
		"offs" from the pointer held in the operand
	*/
define can_defer_opnd(opnd, offs, upd);
	lvars opnd, offs, upd;
	if regnumber(opnd) then
		if datareg(opnd)
		and (not(isinteger(offs)) or offs > 127 or offs < -128) then
			;;; offset unknown or too big to use a2@(offs, dn:L)
			false
		else
			{^opnd ^offs}
		endif
	elseif isref(opnd) then
		;;; immediate label
		fast_cont(opnd), if offs/==0 then <> '+' >< offs endif
	else
		false
	endif
enddefine;

define lconstant wof = nonop fi_*(% WORD_OFFS %) enddefine;

	/*	pdr_index_opnd is used by m_trans.p for creating operands to
		push/call values from procedure headers.
	*/
define pdr_index_opnd(fld_index);
	lvars label, fld_index;
	current_pdr_label label_+ fld_index.wof -> label;
	{%PC, label <> '-.-2' %}	;;; location counter is `.`
enddefine;



;;; --- M-CODE TRANSLATION PROCEDURES ----------------------------------------

lconstant procedure
	test_opcode = newassoc([
		[EQ  beq]  [NEQ  bne]
		[LT  bgt]  [LEQ  bge]  [GT  blt]  [GEQ  ble]
		[ULT bhi]  [ULEQ bcc]  [UGT bcs]  [UGEQ bls]
		[NEG bmi]  [POS  bpl]
		[OVF bvs]  [NOVF bvc]
		]);


lvars
	m_codelist, m_instr, lasti, ilist,
	;


define lconstant c_placei() with_nargs 1;
	() :: [] ->> if lasti then f_tl(lasti) else ilist endif -> lasti;
enddefine;

define lconstant c_place();
	c_placei(consvector())
enddefine;

define lconstant c_label(lab);
	lvars lab;
	c_place("label", lab, 2)
enddefine;

define lconstant c_long(val);
	lvars val;
	c_place("\.long", val, 2)
enddefine;

define lconstant altwkreg(x);
	lvars x;
	if reg_in_operand(x) == RD0 then RD1 else RD0 endif
enddefine;

define lconstant byte_addr_at(n, x);
	lvars x, n, offs;
	if isstring(x) then
		return(x <> '+' >< n)
	elseif isvector(x) then
		unless isboolean(x(2) ->> offs) then
			return({%x(1), n+offs%})
		endunless
	endif;
	false
enddefine;

define lconstant quickint(x);
	lvars x;
	isinteger(x) and -127 fi_<= x and x fi_<= 127
enddefine;

define lconstant c_move(x, y);
	lvars x, y, opcode, last, lx, ly;
	returnif(x = y or (x == USP_+ and y == -_USP));
	if lasti and (f_hd(lasti) ->> last)(1) == "movl" then
		last(2) -> lx; last(3) -> ly;
		returnif(x = ly and y = lx);
	endif;
	if x = false_immediate then RD_FALSE -> x endif;
	"movl" -> opcode;
	if quickint(x) then
		;;; use moveq
		if x == 0 then
			RA_ZERO -> x
		elseif datareg(y) then
			"moveq" -> opcode
		else
			c_place("moveq", x, RD3 ->> x, 3)
		endif
	endif;
	c_place(opcode, x, y, 3)
enddefine;

define lconstant c_arith(bitop, opcode, quickop, src2, src1, dst);
	lvars src2, src1, dst, org_dst = dst, xreg, subtract, substack2, bitop,
		opcode, quickop, procedure allowedreg
		;
	opcode == "subl" -> subtract;
	subtract and src2 == USP_+ and src1 == USP_+ -> substack2;
	if bitop then
		if addressreg(dst) then RD0 -> dst endif;
		if src2 = dst then src2, src1 -> src2 -> src1 endif;
		datareg
	elseif substack2 then
		datareg
	else
		regnumber
	endif -> allowedreg;
	if src1 = dst then
		unless datareg(src2) or immediate_operand(src2) or allowedreg(dst) then
			c_move(src2, altwkreg(dst) ->> src2)
		endunless;
	else
		if (src2 == RD0 or src2 == RD1) and not(subtract) then
			src2, src1 -> src2 ->> src1 -> dst
		else
			reg_in_operand(src2) -> xreg;
			if allowedreg(dst) and dst /== xreg then
				dst
			elseif xreg == RD0 then
				RD1
			else
				RD0
			endif -> dst
		endif
	endif;
	if quickint(src2) then
		if quickop and 1 fi_<= src2 and src2 fi_<= 8 then
			;;; use the quick version
			quickop -> opcode
		endif;
		if not(bitop) and addressreg(org_dst) and regnumber(src1)
		and (opcode /== quickop or (dst /= org_dst and src1 /= dst)) then
			if subtract then -src2 -> src2 endif;
			c_place("lea", {^src1 ^src2}, org_dst, 3);
			return
		else
			c_move(src1, dst);
			unless opcode == quickop then
				c_move(src2, RD2 ->> src2)
			endunless
		endif
	else
		c_move(src1, dst);
		if bitop and addressreg(src2) then
			c_move(src2, RD1 ->> src2)
		endif
	endif;
	c_place(opcode, src2, dst, 3);
	if substack2 then c_place("negl", dst, 2) endif;
	c_move(dst, org_dst)
enddefine;

define lconstant c_arith3();
	lvars src2, src1, dst;
	explode(m_instr) -> dst -> src1 -> src2 -> ;
	c_arith(src2, src1, dst)
enddefine;

define M_ADD	= c_arith3(%false, "addl", "addql"%) enddefine;
define M_SUB	= c_arith3(%false, "subl", "subql"%) enddefine;

define lconstant c_parith(opcode, quickop);
	lvars src2, src1, dst, opcode, quickop;
	explode(m_instr) -> dst -> src1 -> src2 -> ;
	if isintegral(src2) then
		src2-3 -> src2
	else
		c_move(src2, altwkreg(src1) ->> src2);
		c_place("subql", 3, src2, 3)
	endif;
	c_arith(false, opcode, quickop, src2, src1, dst)
enddefine;

define M_PADD	= c_parith(%"addl", "addql"%) enddefine;
define M_PSUB	= c_parith(%"subl", "subql"%) enddefine;

define lconstant c_ptr_arith(opcode, quickop);
	lvars opcode, quickop, offs_ptr, ptr, dst;
	explode(m_instr) -> dst -> ptr -> offs_ptr -> /* type */ ->;
	if opcode == "addl" and offs_ptr = dst then
		ptr, offs_ptr -> ptr -> offs_ptr	;;; commutes
	endif;
	c_arith(false, opcode, quickop, offs_ptr, ptr, dst)
enddefine;

define M_PTR_ADD_OFFS	= c_ptr_arith(%"addl", "addql"%) enddefine;
define M_PTR_SUB_OFFS 	= c_ptr_arith(%"subl", "subql"%) enddefine;
define M_PTR_SUB		= c_ptr_arith(%"subl", "subql"%) enddefine;

define M_MULT();
	lvars x, y, z;
	explode(m_instr) -> z -> y -> x ->;
	if y == i_USP and z == i_USP then
		USP_+ -> y; -_USP -> z
	endif;
	c_move(y, -_USP);
	c_move(x, -_USP);
	c_place("jsr", symlabel("\^_mult"), 2);
	c_move(USP_+, z)
enddefine;

define M_BIS	= c_arith3(%true, "orl", false%) enddefine;
define M_BIM	= c_arith3(%true, "andl", false%) enddefine;

define M_BIC();
	lvars x, y;
	f_subv(2, m_instr) -> x;
	f_subv(3, m_instr) -> y;
	if isintegral(x) then
		~~x -> x
	else
		c_move(x, altwkreg(y) ->> x);
		c_place("notl", x, 2)
	endif;
	x -> f_subv(2, m_instr);
	M_BIM()
enddefine;

define M_MOVE();
	c_move(f_subv(2, m_instr), f_subv(3, m_instr))
enddefine;

define lconstant c_movetol(opcode, signed);
	lvars x, y, reg, opcode, signed;
	explode(m_instr) -> y -> x ->;
	if datareg(y) then
		y
	elseif reg_in_operand(x) == RD0 then
		RD1
	else
		RD0
	endif -> reg;
	if signed then
		c_place(opcode, x, reg, 3);
		if opcode=="movb" then c_place("extw", reg, 2) endif;
		c_place("extl", reg, 2);
	else
		c_move(0, reg);
		c_place(opcode, x, reg, 3);
	endif;
	c_move(reg, y);
enddefine;

define lconstant c_movefroml(opcode);
	lvars x, opcode;
	m_instr(2) -> x;
	unless datareg(x) then
		c_move(x, RD0 ->> x)
	endunless;
	c_place(opcode, x, m_instr(3), 3);
enddefine;


define M_MOVEb	= c_movetol(%"movb", false%) enddefine;
define M_MOVEs	= c_movetol(%"movw", false%) enddefine;
define M_MOVEsb	= c_movetol(%"movb", true%)  enddefine;
define M_MOVEss	= c_movetol(%"movw", true%)  enddefine;
define M_UPDb	= c_movefroml(%"movb"%) 	 enddefine;
define M_UPDs	= c_movefroml(%"movw"%) 	 enddefine;


	;;; {M_MOVE(s)bit <fieldsize> <bitoffs> <ptr> <dst>}
define lconstant get_bitfield(routine);
	lvars fieldsize, dst, ptr, bitoffs, routine;
	explode(m_instr) -> dst -> ptr -> bitoffs -> fieldsize -> ;
	c_move(fieldsize, RD1);
	c_move(bitoffs, RD0);
	c_move(ptr, RA0);
	c_place("jsr", symlabel(routine), 2);
	c_move(RD0, dst)
enddefine;

define M_MOVEbit	= get_bitfield(%"\^_bfield"%)  enddefine;
define M_MOVEsbit	= get_bitfield(%"\^_sbfield"%) enddefine;

	;;; {M_UPDbit <fieldsize> <bitoffs> <ptr> <src>}
define M_UPDbit();
	lvars fieldsize, src, ptr, bitoffs;
	explode(m_instr) -> src -> ptr -> bitoffs -> fieldsize -> ;
	c_move(src, -_USP);
	c_move(fieldsize, RD1);
	c_move(bitoffs, RD0);
	c_move(ptr, RA0);
	c_place("jsr", symlabel("\^_ubfield"), 2)
enddefine;

define M_ASH();
	lvars x, y, z, opcode, reg;
	explode(m_instr) -> z -> y -> x ->;
	if isintegral(x) then
		"asll" -> opcode;
		if x < 0 then
			"asrl" -> opcode; -x -> x
		elseif x == 1 and regnumber(z) then
			c_move(y, z);
			c_place("addl", z, z, 3);
			return
		endif;
		if x > 8 then
			c_move(x, RD1 ->> x);
		endif;
		if datareg(z) then z else RD0 endif -> reg;
		c_move(y, reg);
		c_place(opcode, x, reg, 3);
		c_move(reg, z);
	else
		c_move(y, -_USP);
		c_move(x, -_USP);
		c_place("jsr", symlabel("\^_shift"), 2);
		c_move(USP_+, z);
	endif
enddefine;

define lconstant negcom(opcode);
	lvars x, y, reg, opcode;
	explode(m_instr) -> y -> x ->;
	if x = y and not(addressreg(x)) then
		c_place(opcode, x, 2)
	else
		if datareg(y) then y else RD0 endif -> reg;
		c_move(x, reg);
		c_place(opcode, reg, 2);
		c_move(reg, y);
	endif
enddefine;

define M_NEG	= negcom(%"negl"%) enddefine;
define M_LOGCOM	= negcom(%"notl"%) enddefine;

define M_ERASE();
	lvars x = m_instr(2);
	if auto_operand(x) then
		c_place("tstl", x, 2)
	endif;
enddefine;

define lconstant c_tst(x);
	lvars i, x;
	if addressreg(x) or immediate_operand(x) then
		c_move(x, RD0)			;;; move sets the flags
	elseunless lasti
	and (f_hd(lasti) -> i, f_subv(datalength(i), i) = x)
	and not(auto_operand(x) or lmember(f_subv(1,i), [movb movw]))
	then
		c_place("tstl", x, 2)
	;;; else last instruction has operand as destination, so flags already set
	endif
enddefine;

define M_TEST();
	c_tst(m_instr(2));
	c_place(test_opcode(m_instr(3)), m_instr(4), 2)
enddefine;

define lconstant c_cmp(x, y, test, lab);
	lvars x, y, test, lab, op;
	if x = false_immediate then RD_FALSE -> x endif;
	if x == 0 and (test == "EQ" or test == "NEQ") then
		;;; turn it into a M_TEST
		c_tst(y)
	else
		if quickint(x) then
			c_move(x, altwkreg(y) ->> x)
		endif;
		"cmpl" -> op;
		if x == USP_+ and y == USP_+ then
			"cmpml" -> op
		elseunless immediate_operand(x) or regnumber(y) then
			if immediate_operand(y) or regnumber(x) then
				x, y -> x -> y;
				commute_test(test) -> test
			else
				c_move(y, altwkreg(x) ->> y)
			endif;
		endif;
		c_place(op, x, y, 3)
	endif;
	c_place(test_opcode(test), lab, 2)
enddefine;

define M_CMP();
	lvars x, y, test, lab;
	explode(m_instr) -> lab -> test -> y -> x -> ;
	c_cmp(x, y, test, lab)
enddefine;

	;;; compare popints
constant procedure M_PCMP = M_CMP;

	;;; compare pointers -- same as integers for all types
define M_PTR_CMP();
	lvars x, y, test, lab;
	explode(m_instr) -> lab -> test -> y -> x -> /* type */ -> ;
	c_cmp(x, y, test, lab)
enddefine;

define lconstant c_bit_test(x, y, test, lab);
	lvars x, y, test, lab, bit, z;
	if isintegral(x) and x &&~~ (x-1) == x and x /== 0 then
		;;; single bit
		if (integer_leastbit(x) ->> bit) == #_< WORD_BITS-1 >_# then
			;;; testing sign bit, use a "tstl"
			if test=="EQ" then "POS" else "NEG" endif -> test;
			c_tst(y)
		else
			if byte_addr_at(3 - bit div 8, y) ->> z then
				z -> y;
				bit rem 8 -> bit
			elseunless datareg(y) then
				c_move(y, RD0 ->> y)
			endif;
			c_place("btst", bit, y, 3)
		endif
	else
		c_arith(true, "andl", false, x, y, RD0)
	endif;
	c_place(test_opcode(test), lab, 2)
enddefine;

define M_BIT();
	c_bit_test(explode(m_instr)) -> ;
enddefine;

define M_CMPKEY();
	lvars x, test, lab, tlab, key, key_opnd;
	explode(m_instr) -> (, key, x, test, lab);
	unless datareg(x) then
		c_move(x, RD0 ->> x)
	endunless;
	if test == "EQ" then genlab() else lab endif -> tlab;
	c_place("btst", 0, x, 3);
	c_place("bne", tlab, 2);
	{% x, field_##("KEY").wof %} -> key_opnd;
	if isintegral(key) then
		;;; testing flag(s) nonzero in K_FLAGS field
		c_move(key_opnd, RD0);
		c_bit_test(key, {% RD0, field_##("K_FLAGS").wof %},
												negate_test(test), lab)
	else
		;;; test for specific key
		c_cmp(key, key_opnd, test, lab)
	endif;
	if test == "EQ" then c_label(tlab) endif
enddefine;

define lconstant c_parith_test(opcode);
	lvars opcode;
	c_move(m_instr(3), -_USP);
	c_move(m_instr(2), RD1);
	c_place("subql", 3, RD1, 3);
	c_place(opcode, RD1, i_USP, 3);
	c_place(test_opcode(m_instr(4)), m_instr(5), 2)
enddefine;

define M_PADD_TEST	= c_parith_test(%"addl"%) enddefine;
define M_PSUB_TEST	= c_parith_test(%"subl"%) enddefine;

define M_BRANCH();
	;;; see if redundant
	unless lasti and lmember(f_hd(lasti)(1), [jmp bra bras]) then
		c_place("bra", f_subv(2, m_instr), 2)
	endunless;
enddefine;

	;;; Branch instruction of standard size (2 bytes).
	;;; Using "bra\s" as the opcode prevents optimisation to "bras"
define M_BRANCH_std();
	c_place("bra\s", f_subv(2, m_instr), 2)
enddefine;

define M_BRANCH_ON();
	lvars opnd, lab, afterlab;
	m_instr(2) -> opnd;
	unless regnumber(opnd) then
		c_move(opnd, RD0 ->> opnd)
	endunless;
	genlab() -> afterlab;
	c_place("cmpl", popint(listlength(m_instr(3))), opnd, 3);
	c_place("bhi", afterlab, 2);		;;; go after if out of range
	c_place("jmp", {^PC -1 ^opnd}, 2);
	;;; use "bra\s" for the branch opcodes, which prints the same but
	;;; will not be converted to a "bras" by condbr
	;;; first the branch for trapping arg value 0
	c_place("bra\s", afterlab, 2);
	;;; now the ones for the allowable values
	for lab in m_instr(3) do
		c_place("bra\s", lab, 2);
	endfor;
	c_label(afterlab);
	unless m_instr(4) then
		;;; if no "else" label, push arg back onto stack
		;;; (as argument to error procedure)
		c_move(opnd, -_USP)
	endunless
enddefine;

define M_BRANCH_ON_INT();
	lvars opnd, lab, afterlab;
	c_move(m_instr(2), RD0 ->> opnd);
	genlab() -> afterlab;
	c_place("cmpl", listlength(m_instr(3)), opnd, 3);
	c_place("bhi", afterlab, 2);		;;; go after if out of range
	c_place("lslw", 2, opnd, 3);		;;; will never be bigger than a word
	c_place("jmp", {^PC 2 ^opnd}, 2);
	;;; use "bra\s" for the branch opcodes, which prints the same but
	;;; will not be converted to a "bras" by condbr
	;;; first the branch for trapping arg value 0
	c_place("bra\s", afterlab, 2);
	;;; now the ones for the allowable values
	for lab in m_instr(3) do
		c_place("bra\s", lab, 2)
	endfor;
	c_label(afterlab)
enddefine;

define lconstant getexecop(opnd, is_subr) -> eopnd;
	lvars opnd, eopnd, is_subr;
	unless can_defer_opnd(opnd, 0, false) ->> eopnd then
		c_move(opnd, RA0);
		i_RA0 -> eopnd
	endunless;
	unless is_subr then
		;;; pop procedure call (offset of PD_EXECUTE field is 0)
		getexecop(eopnd, true) -> eopnd
	endunless
enddefine;

define lconstant pop_call_or_chain(opcode, alt);
	lvars opnd, lab, opcode, alt;
	m_instr(2) -> opnd;
	if isref(opnd) then
		;;; constant
		fast_cont(opnd) -> opnd;
		execlabof(opnd, true) -> lab;
		if islabel(opnd) && LAB_OF_STRUCT /== 0
		and file_total_bytecount fi_< 16:4000 	;;; kludge for very big files
		then
			;;; defined in this file -- use "bsr" or "bra"
			alt -> opcode
		endif
	else
		getexecop(opnd, false) -> lab
	endif;
	c_place(opcode, lab, 2)
enddefine;

define M_CALL	= pop_call_or_chain(%"jsr", "bsr"%) enddefine;
define M_CHAIN	= pop_call_or_chain(%"jmp", "bra"%) enddefine;

	;;; {M_CALL_WITH_RETURN <pdr_opnd> <return addr>}
define M_CALL_WITH_RETURN();
	c_move(f_subv(3,m_instr), -_SP);		;;; push return address
	M_CHAIN()							;;; chain to procedure
enddefine;

	;;; {M_CALLSUB <subroutine_opnd> <upto 3 args to go in regs>}
	;;; (subroutine is always a constant when reg args present)
define M_CALLSUB();
	lvars l = datalength(m_instr);
	if l  ==   5 then c_move(f_subv(3,  m_instr), RD2) endif;	;;; arg_reg_2
	if l fi_>= 4 then c_move(f_subv(l-1,m_instr), RD1) endif;	;;; arg_reg_1
	if l fi_>= 3 then c_move(f_subv(l,  m_instr), RD0) endif;	;;; arg_reg_0
	c_place("jsr", getexecop(f_subv(2,m_instr), true), 2)
enddefine;

	;;; {M_CHAINSUB <subroutine_opnd>}
define M_CHAINSUB();
	c_place("jmp", getexecop(f_subv(2,m_instr), true), 2)
enddefine;


define M_LABEL();
	"label" -> f_subv(1, m_instr);
	c_placei(m_instr)
enddefine;


;;; --- SPECIAL INSTRUCTIONS --------------------------------------------

	;;; {M_CLOSURE <frozvals> <pdpart opnd>}
define M_CLOSURE();
	lvars Nfrozvals, frozvals, pdpart_opnd, froz_addr;
	explode(m_instr) -> pdpart_opnd -> frozvals -> ;
	listlength(frozvals) -> Nfrozvals;

	if Nfrozvals fi_> 16 then
		;;; just give clos to Exec_closure
		c_place("lea", pdr_index_opnd(0), RA0, 3);
		c_move(RA0, -_USP);
		perm_const_opnd([Sys Exec_closure]) -> pdpart_opnd
	else
		;;; code to push frozvals
		pdr_index_opnd(field_##("PD_CLOS_FROZVALS")) -> froz_addr;
		if Nfrozvals == 1 then
			c_move(froz_addr, -_USP)
		elseunless Nfrozvals == 0 then
			c_place("lea", froz_addr, RA0, 3);
			fast_repeat Nfrozvals times
				c_move(RA0_+, -_USP)
			endfast_repeat
		endif
	endif;

	;;; code to chain pdpart -- if closure is non-writeable, pdpart_opnd
	;;; is an immediate operand for the pdpart procedure
	{%M_CHAIN,	if pdpart_opnd then
					pdpart_opnd
				else
					pdr_index_opnd(field_##("PD_CLOS_PDPART"))
				endif%} -> m_instr;
	M_CHAIN()
enddefine;

	;;; {M_SETSTKLEN <offset of stack increase> <popint saved stklen opnd>}
	;;; offset is always a constant integer
define M_SETSTKLEN();
	lvars sl_opnd, offs, lab;
	explode(m_instr) -> sl_opnd -> offs -> ;
	;;; userhi - popint stklen -> d0
	c_arith(false, "subl", "subql", sl_opnd, identlabel("\^_userhi"), RD0);
	;;; d0 - (offs-3) -> d0 = desired value of USP
	;;; (-3 accounts for the popint bits in sl_opnd)
	c_arith(false, if offs == 0 then "addl", "addql", 3
				   else "subl", "subql", offs-3
				   endif, RD0, RD0);
	c_place("cmpl", USP, RD0, 3);
	c_place("beq", genlab()->>lab, 2);
	c_place("jsr", perm_const_lab([\^_setstklen_diff]), 2);
	c_label(lab)
enddefine;


;;; --- PROLOG INSTRUCTIONS ----------------------------------------------

	;;; {M_PLOG_IFNOT_ATOM <ifnot_lab>}
	;;; (follows a call of _prolog_unify_atom)
define M_PLOG_IFNOT_ATOM();
	c_place("bne", f_subv(2,m_instr), 2)
enddefine;

	;;; {M_PLOG_TERM_SWITCH <fail_lab> <var_lab> <dst for drop thru case>}
	;;; (follows a call of _prolog_pair_switch/_prolog_term_switch)
define M_PLOG_TERM_SWITCH();
	c_place("bgt", f_subv(3,m_instr), 2);	;;; var_lab if greater than
	c_place("blt", f_subv(2,m_instr), 2);	;;; fail_lab if less than
	;;; else deref'ed pair/term in arg_reg_0
	c_move(RD0, f_subv(4,m_instr))
enddefine;


;;; --- CREATE/UNWIND STACK FRAME ----------------------------------------

lblock

lvars
	Ndlocals, Nregs, Nstkvars, r_regmask, s_regmask, dlocal_labs,
	;

	;;; {M_CREATE_SF <reg_locals> <Npopreg> <Nstkvars> <Npopstkvars>
	;;;								<dlocal_labs> <ident reg_spec> }
	;;; Generate code to construct stack frame -- this sets up values
	;;; to be used by later M_UNWIND_SF.
define M_CREATE_SF();
	lvars n, l, bit, reg_locals, reg_spec_id, Npopregs, Npopstkvars;

	explode(m_instr) -> reg_spec_id -> dlocal_labs
					-> Npopstkvars -> Nstkvars -> Npopregs -> reg_locals -> ;
	listlength(dlocal_labs) -> Ndlocals;
	listlength(reg_locals) -> Nregs;

	;;; create save and restore register masks from reg locals
	0 ->> r_regmask -> s_regmask;
	fast_for n in reg_locals do
		r_regmask || (1 << n) -> r_regmask;
		s_regmask || (1 << (15-n)) -> s_regmask
	endfast_for;

	;;; Reg spec to go in PD_REGMASK is switch offset to 6-byte register
	;;; save/restore code section (see aprocess.s).
	;;; This is returned in idval(reg_spec_id)
	( (Nregs-Npopregs) * length(pop_registers) + Npopregs ) * 6
											->  idval(reg_spec_id);

#_IF DEF STACK_PROBES
	;;; plant tstb instruction to make sure stack extended
	;;; - unless procedure has no locals
	unless Nregs == 0 and Nstkvars == 0 and Ndlocals == 0 then
		c_place("tstb", {%SP, -256.wof%}, 2)
	endunless;
#_ENDIF
	;;; stack registers
	if Nregs <= 2 then
		;;; do them individually
		15 -> n;
		1 << n -> bit;
		until bit == 0 do
			if r_regmask && bit /== 0 then
				c_move(reglabel(n), -_SP)
			endif;
			bit >> 1 -> bit;
			n-1 -> n
		enduntil
	else
		;;; use mask
		c_place("moveml", s_regmask, -_SP, 3)
	endif;
	;;; stack dynamic locals
	if Ndlocals == 1 then
		c_move(f_hd(dlocal_labs), -_SP);
	elseunless Ndlocals == 0 then
		c_place("lea", pdr_index_opnd(field_##("PD_TABLE")), RA0, 3);
		fast_repeat Ndlocals times
			c_move(RA0_+, RA1);
			c_move(i_RA1, -_SP)
		endfast_repeat
	endif;
	;;; stack-allocated vars
	if Npopstkvars /== 0 then
		c_move(popint(0), RD0);
		fast_repeat Npopstkvars times	;;; pop ones - have to be initialised
			c_move(RD0, -_SP)
		endfast_repeat
	endif;
	if Nstkvars /== Npopstkvars then		;;; some nonpop ones
		(Nstkvars-Npopstkvars).wof -> n;
		c_place(if n>8 then "subl" else "subql" endif, n, SP, 3)
	endif;
	;;; owner address
	c_place("pea", pdr_index_opnd(0), 2)
enddefine;

	;;; {M_UNWIND_SF}
	;;; generate code to unwind stack frame (musn't use CHAIN_REG = d0)
	;;; Uses lvar values set up by previous M_CREATE_SF
define M_UNWIND_SF();
	lvars n, l, bit;
	;;; remove stack-allocated vars and owner address
	(Nstkvars+1).wof -> n;
	c_place(if n>8 then "lea", {^SP ^n}  else "addql", n endif, SP, 3);
	;;; unstack dynamic locals
	if Ndlocals == 1 then
		c_move(SP_+, f_hd(dlocal_labs));
	elseunless Ndlocals == 0 then
		c_place("lea", pdr_index_opnd(field_##("PD_TABLE")+Ndlocals), RA0, 3);
		fast_repeat Ndlocals times
			c_move(-_RA0, RA1);
			c_move(SP_+, i_RA1)
		endfast_repeat
	endif;
	;;; restore registers
	if Nregs <= 2 then
		;;; do individually
		0 -> n;
		1 -> bit;
		until n == 16 do
			if r_regmask && bit /== 0 then
				c_move(SP_+, reglabel(n))
			endif;
			bit << 1 -> bit;
			n+1 -> n
		enduntil
	else
		;;; use mask
		c_place("moveml", SP_+, r_regmask, 3)
	endif
enddefine;

endlblock;

;;; -----------------------------------------------------------------------

	;;; return from procedure
define M_RETURN();
	c_place("rts", 1)
enddefine;

	;;; end of code
define M_END = identfn(%%) enddefine;


	;;; translate M-code to 68000 assembler
define lconstant c_translate(m_clist) -> ilist;
	lvars opcode, m_clist;
	dlocal m_codelist, m_instr, ilist, lasti = false;
	c_label(current_pdr_exec_label);	;;; execute label
	fast_for m_codelist on m_clist do
		f_hd(m_codelist) -> m_instr;
		if isprocedure(f_subv(1, m_instr) ->> opcode) then
			opcode()
		else
			mishap(opcode, 1, 'UNKNOWN M-OPCODE')
		endif
	endfast_for
enddefine;


;;; --- DEAL WITH CONDITIONAL BRANCH INSTRUCTIONS -------------------------

lconstant procedure
	negate_test_opcode =
		newassoc([
				[beq bne]  [bne beq]
				[blt bge]  [ble bgt]  [bgt ble]  [bge blt]
				[bls bhi]  [bhi bls]  [bcs bcc]  [bcc bcs]
				[bmi bpl]  [bpl bmi]
				[bvs bvc]  [bvc bvs]
		]);

lvars bytecount;

	;;; count the length of an operand in bytes
define lconstant countop(x, opcode);
	lvars c, x, reg, offs, opcode;
	if regnumber(x) then
		;;; register
		return
	elseif immediate_operand(x) then
		;;; immmediate (integer or ref) - depends on the opcode
		if lmember(opcode, [moveq addql subql asll asrl lsll lsrl roll rorl
								aslw asrw lslw lsrw rolw rorw])
		then
			return
		elseif lmember(opcode, [moveml bchg bclr bset btst link]) then
			bytecount fi_+ 2 -> bytecount
		else
			opcode(datalength(opcode)) -> c;	;;; data length subscript
			if c == `w` or c == `b` then 2
			elseif c == `l` then 4
			else
				mishap(opcode,1,'COUNTOP: FUNNY OPCODE')
			endif fi_+ bytecount -> bytecount
		endif
	elseif isvector(x) then
		f_subv(1, x) -> reg;
		f_subv(2, x) -> offs;
		unless isboolean(offs) or (offs == 0 and reg(1)==`a`) then
			;;; displacement, long index - 1 extension word
			bytecount fi_+ 2 -> bytecount
		endunless
	else
		;;; absolute long - 2 extension words
		bytecount fi_+ 4 -> bytecount
	endif
enddefine;

lconstant procedure (
	isshortbranch = lmember(%[bccs bcss beqs bges bgts bhis bles blss blts
								bmis bnes bpls bras bsrs bvcs bvss]%),
	isbranch	= lmember(%[bcc bcs beq bge bgt bhi ble bls blt
								bmi bne bpl bra bra\s bsr bvc bvs]%),
	);

	;;; count the length of an instruction in bytes
define lconstant countinst(inst);
	lvars opcode, n, inst;
	f_subv(1, inst) -> opcode;
	returnif(opcode == "label");
	if opcode == "\.long" then
		bytecount fi_+ 4 -> bytecount
	else
		bytecount fi_+ 2 -> bytecount;	;;; 1 word for the basic instruction
		if isbranch(opcode) then
			;;; word-displacement branch instruction
			bytecount fi_+ 2 -> bytecount
		elseunless isshortbranch(opcode) then
			;;; not short branch
			fast_for n from 2 to datalength(inst) do
				countop(f_subv(n,inst), opcode)
			endfast_for
		endif
	endif
enddefine;

define lconstant findlab(lab, clist, pdr);
	lvars x, lab, clist, procedure pdr;
	until (f_hd(clist) -> x; f_subv(1,x)=="label" and f_subv(2,x)==lab) do
		pdr(x);
		f_tl(clist) -> clist;
		if clist==[] then return(false) endif
	enduntil;
	clist
enddefine;

define lconstant condbr(org_codelist);
	lvars l, inst, lab, lab2, info, opcode, org_codelist;
	dlocal bytecount;
	f_hd(m_codelist) -> inst;
	f_subv(1, inst) -> opcode;
	f_subv(datalength(inst), inst) -> lab;				;;; the label to find
	islabel(lab) -> info;
	unless negate_test_opcode(opcode)
	or (opcode == "bra" and info && LAB_PROC_INNER /== 0) then
		return
	endunless;

	0 -> bytecount;
	if info && LAB_BACKWARD /== 0				;;; definitely backward
	or not(findlab(lab, f_tl(m_codelist), countinst))
	then
		unless findlab(lab, org_codelist, erase) ->> l then return endunless;
		f_tl(l) -> l;
		0 -> bytecount;
		until l == m_codelist do
			countinst(f_dest(l) -> l)
		enduntil;
		countinst(inst)
	endif;
	if bytecount == 0 then
		;;; branch to is to a label immediately following -- can remove
		f_dest(f_tl(m_codelist)) -> f_tl(m_codelist) -> f_hd(m_codelist)
	elseif bytecount <= 127 then
		;;; can use short form
		opcode <> "s" -> f_subv(1, inst)
	endif
enddefine;

define lconstant docondbr(m_codelist) -> org_codelist;
	lvars org_codelist;
	dlocal m_codelist;
	m_codelist -> org_codelist;
	until m_codelist == [] do
		condbr(org_codelist);
		f_tl(m_codelist) -> m_codelist
	enduntil
enddefine;


;;; --- GENERATE OUTPUT CODE -----------------------------------------------

#_IF DEF HP9000

define lconstant outopnd(opnd, opcode);
	lvars opnd, reg, offs, opcode;
	if isintegral(opnd) then
		opnd, '&%p'
	elseif isref(opnd) then
		fast_cont(opnd), '&%p'
	elseif regnumber(opnd) then
		opnd, '%%%p'
	elseunless isvector(opnd) then
		opnd, '%p'
	else
		f_subv(1, opnd) -> reg;
		f_subv(2, opnd) -> offs;
		if datalength(opnd) == 3 then
			f_subv(3, opnd), reg, offs, '%p(%%%p,%%%p.l)'
		else
			if isboolean(offs) then
				reg, if offs then '(%%%p)+' else '-(%%%p)' endif
			elseif reg(1) == `d` then
				reg, RA_ZERO, offs, '%p(%%%p,%%%p.l)'
			elseif offs == 0 then
				reg, '(%%%p)'
			else
				reg, offs, '%p(%%%p)'
			endif
		endif
	endif;
	asmf_printf()
enddefine;

define lconstant print_opcode(inst);
	lvars trans, inst;
	lconstant op_trans = newassoc([
		[addl	'add.l']	[addql	'addq.l']	[andl	'and.l']	[asll	'asl.l']
		[aslw	'asl.w']	[asrl	'asr.l']	[asrw	'asr.w']	[bcc	'bcc.w']
		[bccs	'bcc.b']	[bchg	'bchg']		[bclr	'bclr']		[bcs	'bcs.w']
		[bcss	'bcs.b']	[beq	'beq.w']	[beqs	'beq.b']	[bge	'bge.w']
		[bges	'bge.b']	[bgt	'bgt.w']	[bgts	'bgt.b']	[bhi	'bhi.w']
		[bhis	'bhi.b']	[ble	'ble.w']	[bles	'ble.b']	[bls	'bls.w']
		[blss	'bls.b']	[blt	'blt.w']	[blts	'blt.b']	[bmi	'bmi.w']
		[bmis	'bmi.b']	[bne	'bne.w']	[bnes	'bne.b']	[bpl	'bpl.w']
		[bpls	'bpl.b']	[bra	'bra.w']	[bra\s	'bra.w']	[bras	'bra.b']
		[bset	'bset']		[bsr	'bsr.w']	[bsrs	'bsr.b']	[btst	'btst']
		[bvc	'bvc.w']	[bvcs	'bvc.b']	[bvs	'bvs.w']	[bvss	'bvs.b']
		[clrl	'clr.l']	[clrw	'clr.w']	[cmpl  ['cmp.l']]	[cmpml ['cmpm.l']]
		[extl	'ext.l']	[extw	'ext.w']	[jmp	'jmp']		[jsr	'jsr']
		[lea	'lea']		[link	'link']		[lsll	'lsl.l']	[lslw	'lsl.w']
		[lsrl	'lsr.l']	[lsrw	'lsr.w']	[movb	'mov.b']	[moveml	'movm.l']
		[moveq	'movq']		[movl	'mov.l']	[movw	'mov.w']	[negl	'neg.l']
		[notl	'not.l']	[orl	'or.l']		[pea	'pea']		[roll	'rol.l']
		[rolw	'rol.w']	[rorl	'ror.l']	[rorw	'ror.w']	[rts	'rts']
		[subl	'sub.l']	[subql	'subq.l']	[tstb	'tst.b']	[tstl	'tst.l']
		[tstw	'tst.w']	[unlk	'unlk']
		]);

	unless op_trans(f_subv(1, inst)) ->> trans then
		mishap(f_subv(1,inst), 1, 'NO HP TRANSLATION FOR OPCODE')
	elseif ispair(trans) then
		;;; cmp type instruction -- reverse operands
		f_subv(2,inst), f_subv(3,inst) -> f_subv(2,inst) -> f_subv(3,inst);
		fast_front(trans)
	else
		trans
	endunless
enddefine;


#_ELSEIF DEF SUN or DEF BLEASDALE

define lconstant outopnd(opnd, opcode);
	lvars opnd, reg, offs, opcode;
	if isintegral(opnd) then
		opnd, '#%p'
	elseif isref(opnd) then
		fast_cont(opnd), '#%p'
	elseunless isvector(opnd) then
#_IF DEF SUN
		if isbranch(opcode) or isshortbranch(opcode) or regnumber(opnd) then
			opnd, '%p'
		else
			;;; make the Sun assembler produce an absolute address
			opnd, '%p:L'
		endif;
#_ELSE
		opnd, '%p'
#_ENDIF
	else
		f_subv(1, opnd) -> reg;
		f_subv(2, opnd) -> offs;
		if datalength(opnd) == 3 then
			f_subv(3, opnd), offs, reg, '%p@(%p,%p:l)'
		else
			if isboolean(offs) then
				reg, if offs then '%p@+' else '%p@-' endif
			elseif reg(1) == `d` then
				reg, offs, RA_ZERO, '%p@(%p, %p:l)'
			elseif offs == 0 then
				reg, '%p@'
			else
				offs, reg, '%p@(%p)'
			endif
		endif
	endif;
	asmf_printf()
enddefine;

define lconstant print_opcode(inst);
	lvars inst;
	f_subv(1, inst)
enddefine;

#_ELSE ERROR
#_ENDIF


define lconstant outinst(inst);
	lvars n, l, inst, opcode = f_subv(1, inst);
	if opcode == "label" then
		outlab(f_subv(2, inst));
		return
	elseif opcode == "\.long" then
		asm_outword(f_subv(2, inst), 1)
	else
		asmf_printf(print_opcode(inst), '\t%p\t');
		datalength(inst) -> l;
		fast_for n from 2 to l fi_- 1 do
			outopnd(f_subv(n, inst), opcode);
			asmf_charout(`,`)
		endfast_for;
		unless l == 1 then outopnd(f_subv(l, inst), opcode) endunless;
		asmf_charout(`\n`)
	endif;
	;;; accumulate in total code length
	countinst(inst)
enddefine;


;;; --- GENERATING CODE -------------------------------------------------

	/*	Generate assembler code for a procedure -- called by m_trans
		The global variables
			current_pdr_label, current_pdr_exec_label
		contain the current procedure's label and start-of-code label
		-hdr_len- is the length in words preceding the code.
	*/
define mc_code_generator(codelist, hdr_len) -> (gencode, pdr_len);
	lvars r, codelist, hdr_len, pdr_len;
	lconstant procedure gencode;

	;;; process codelist
	c_translate(codelist) -> codelist;	;;; translate to 68K assembler
	docondbr(codelist) -> codelist;		;;; deal with relative branches

	;;; produce code generator
	genlab() -> pdr_len;				;;; label for pdr len

	define lconstant gencode();
		lvars len;
		dlocal bytecount = 0;			;;; accumulates code length
		applist(codelist, outinst);		;;; produce output code
		if bytecount &&/=_0 2 then
			;;; code is odd number of words long
			;;; extra word needed to longword align it
			asm_outshort(0, 1);
			bytecount fi_+ 2 -> bytecount
		endif;
		;;; length in words of procedure
		hdr_len + (bytecount>>2) -> len;
		outlabset(pdr_len, len);
		file_total_bytecount + (len<<2) -> file_total_bytecount
	enddefine
enddefine;


;;; --- OTHER DEFINITIONS NEEDED BY m_trans.p ---------------------------


	/*	M-code tables for machine-dependent in-line subroutines.
		These are added to the corresponding properties in m_trans.p
	*/
constant

	mc_inline_procs_list = [
	[ \^_ptr_to_offs	[{^M_ERASE ^USP_+}]]		;;; erases type, leaves ptr
	[ \^_offs_to_ptr	[{^M_ERASE ^USP_+}]]		;;; erases type, leaves ptr
	[ \^_int			[{^M_ASH -2 ^USP_+ ^ -_USP}]]
	[ \^_pint			[{^M_ASH  2 ^USP_+ ^ -_USP} {^M_ADD 3 ^USP_+ ^ -_USP}]]
	[ \^_por			[{^M_BIS ^USP_+ ^USP_+ ^ -_USP}]]
	[ \^_pand			[{^M_BIM ^USP_+ ^USP_+ ^ -_USP}]]
	[ \^_mksimple		[{^M_ADD 1 ^USP_+ ^ -_USP}]]
	[ \^_mkcompound		[{^M_SUB 1 ^USP_+ ^ -_USP}]]
	[ \^_mksimple2		[{^M_ADD 3 ^USP_+ ^ -_USP}]]
	[ \^_mkcompound2	[{^M_SUB 3 ^USP_+ ^ -_USP}]]
	],

	mc_inline_conditions_list = [
	[ \^_iscompound		{^M_BIT  2:01   ^USP_+ EQ  ?}	]
	[ \^_issimple		{^M_BIT  2:01   ^USP_+ NEQ ?}	]
	[ \^_issimple2		{^M_BIT	 2:10	^USP_+ NEQ ?}	]
	[ \^_isinteger		{^M_BIT  2:10   ^USP_+ NEQ ?}	]
	[ \^_isaddress		{^M_BIT  2:11   ^USP_+ EQ  ?}	]
	],
;


	/*	Procedure to convert a pop integer subscript to an appropriate offset
		for the data type being accessed, used by OP_SUBV in m_trans.p to
		compile code for fast_subscrv, vectorclass field accesses, etc.
			-scale- is the scale for the data type involved; the results are
		the M-code instructions (if any) necessary to convert the subscript
		on top of the stack to an offset, plus a constant correction to be
		added.
	*/
define cvt_pop_subscript(scale);
	lvars pow, scale;
	if is_power2(scale) ->> pow then
		;;; pow-2 accounts for popint being shifted left 2
		unless (pow-2 ->> pow) == 0 then
			{^M_ASH ^pow ^USP_+ ^ -_USP}
		endunless,
		-(popint(0) << pow)		;;; additive correction to remove popint bits
	else
		;;; just convert to sysint and multiply
		{^M_ASH -2 ^USP_+ ^ -_USP},		;;; _int()
		{^M_MULT ^scale ^USP_+ ^ -_USP},
		0 						;;; no correction necessary
	endif
enddefine;


endsection;		/* Genproc */

endsection;		/* $-Popas$-M_trans */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 31 1994
		Removed M_AR*RAY_SUB (no longer necessary)
--- John Gibson, Sep  1 1993
		Added dirty kludge to pop_call_or_chain to stop "bsr" being used
		when brach offset may be bigger than 16 bits in very big files
--- John Gibson, Sep 28 1992
		Changed M_CLOSURE to call Exec_closure for more than 16 frozvals
--- John Gibson, Jan  8 1992
		Added _por and _pand to mc_inline_procs_list
--- John Gibson, Jan  2 1992
		Changed M_CMPKEY to allow key arg to be an integer specifying
		flag(s) to be tested in K_FLAGS field
--- John Gibson, Jan 11 1990
		Added -hdr_len- arg to -mc_code_generator-
--- John Gibson, Nov 29 1989
		Removed optional code for F*ALSE_AT_0 (no longer possible
		when pop pointers address 3rd word).
--- John Gibson, Jun  7 1989
		Included common.ph
--- John Gibson, May 17 1989
		Changed all references to subroutine names to begin with \^_
		(Ctrl-_) instead of _.
		Replaced all uses of @ and @@ with calls to field_## on the
		name of the field (converted to word offset where necessary).
		-pdr_offset_opnd- replaced by -pdr_index_opnd-, which now takes
		a pop integer index instead of a sysint offset.
--- John Gibson, Apr 26 1989
		Added M_SETSTKLEN, M_PLOG_IFNOT_ATOM and M_PLOG_TERM_SWITCH.
		Changed M_CALLSUB to include any register arguments as part of the
		instruction; removed references to ARG_REG_0.
--- John Gibson, Mar 23 1989
		-addr_add_pop_subscr- replaced with -cvt_pop_subscript-.
--- John Gibson, Feb 15 1989
		Added M_AR*RAY_SUB
--- John Gibson, Feb 13 1989
		Improved interface from m_trans.p:
			Now only one code-generating procedure -mc_code_generator-,
		closure code being dealt with by the M_CLOSURE instruction.
			Additional procedure -pdr_index_opnd- required by m_trans
		for references to words in procedure header data
--- John Gibson, Aug  2 1988
		Added bitfield M-instructions.
--- John Gibson, Apr 22 1988
		Changed for new HP assembler
--- John Gibson, Feb  5 1988
		Replaced use of -syssynonym- with -identof-, etc
--- John Gibson, Jan 15 1988
		Undid last change
 */
