/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            S.sun3/src/syscomp/sysdefs.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 */

/* -------------------------------------------------------------------------

				DEFINITIONS FOR MACHINE/OPERATING SYSTEM

--------------------------------------------------------------------------*/

section;

global constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; --- SYSTEM NAME -----------------------------------------------------

	MACHINE			= [[sun3]],
	SUN 			= true,
	SUN3			= true,


;;; --- MACHINE = MC 68020 -----------------------------------------------

	PROCESSOR		= [[68020]],	;;; type of cpu
	M68K_VERSION	= 68020,		;;; 680000 version

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	INT_ALIGN_BITS	= 16,			;;; alignment in bits for int access
	DOUBLE_ALIGN_BITS= 16,			;;; alignment in bits for double access

	CODE_POINTER_TYPE = "short",	;;; type of pointer to machine code
	BIT_POINTER_TYPE  = "byte",		;;; type of pointer for bitfield access
	BIG_ENDIAN		= true,


;;; --- OPERATING SYSTEM = SUNOS (Unix BSD 4.2) ----------------------

	SUNOS			= 4.1,
	POSIX1			= 198808,
	OPERATING_SYSTEM = [[unix sunos ^SUNOS posix {^POSIX1}]],	;;; type of os
	UNIX			= true,
	BERKELEY		= 4.2,
	BSD_MMAP		= true,			;;; has -mmap- and -mprotect- facilities
	BSD_MPROTECT	= true,
	BSD_VFORK		= true,			;;; has working -vfork-

	VPAGE_OFFS		= 16:2000,		;;; word address offset of a virtual page
	SEGMENT_OFFS	= 16:20000,		;;; word address offset of a segment
	LOWEST_ADDRESS	= 16:2000,		;;; lowest pop structure address
	UNIX_USRSTACK	= 16:0F000000,	;;; end of stack (as USRSTACK in <sys/vmparam.h> etc)

	;;; Procedures to get and set the memory break and return the REAL end of
	;;; memory. (We always need the real end to ensure that the end of the
	;;; user stack is always at the true end of memory, so that user stack
	;;; underflow produces a memory access violation.)

	GET_REAL_BREAK =
		[procedure(); _extern sbrk(_0)@(b.r->vpage) endprocedure],

	SET_REAL_BREAK =
		[procedure(_break) -> _break;
			lvars _break = _break@(w.r->vpage);
			if _extern brk(_break@(w->b)) == _-1 then
				_-1 -> _break
			endif
		endprocedure],


;;; --- OTHER ------------------------------------------------------------


	;;; list of procedures to be optimised as subroutine calls
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]

	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],

	;;; Old-style I_PUSH/POP_FIELD(_ADDR) instructions in ass.p
	OLD_FIELD_INSTRUCTIONS = true,

);


endsection;		/* $- */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov  4 1996
		Added OLD_FIELD_INSTRUCTIONS. Removed is* procedures from
		SUBROUTINE_OPTIMISE_LIST (no longer required).
--- John Gibson, Mar 30 1995
		Added BIG_ENDIAN
--- John Gibson, Mar 21 1995
		Standard machine data type definitions are now in mcdata.p
--- John Gibson, Feb 28 1995
		Added POSIX1 and "posix" entry in OPERATING_SYSTEM, removed H*ERTZ
--- John Gibson, Oct 22 1992
		Changed P*OPC to POPC_SYSDEFS_LOADED
--- Robert John Duncan, Jun 23 1992
		Added BSD_VFORK
--- John Gibson, Dec 11 1990
		SUNOS 4.1
--- John Gibson, Aug 31 1989
		Added UNIX_USRSTACK
--- John Gibson, Aug 24 1989
		Removed S*IGNALS
--- Rob Duncan, Apr  3 1989
		Added MACHINE definition; changed OPERATING_SYSTEM to include
		"sunos" and renamed SUN_RELEASE as SUNOS
--- Rob Duncan, Oct  6 1988
		Added BSD_MPROTECT flag
--- Roger Evans, Sep 26 1988
		Added POPC definition
--- John Gibson, Aug  5 1988
		Added DOUBLE declarations
--- John Gibson, Apr 20 1988
		Changed BIGINT_SPEC to "int" (aarith.s for Sun3 now uses 68020
		instructions, so bigints can be ints rather than shorts).
 */
