/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:			C.all/lib/objectclass/rt/failure.p
 > Purpose:			Objectclass runtime support
 > Author:			Robert John Duncan, Sep 29 1995
 */
compile_mode:pop11 +strict;

	;;; this will be generated by the objectclass linker
vars procedure $-fail_generic;

section $-objectclass;

;;; report_failure:
;;;     report failure of a method call, i.e when no method part has
;;;     been found which matches the classes of the supplied arguments.

define report_failure(m, upd);
	lvars arity = pdnargs(m);
	lvars args = conslist(min(stacklength(), arity));
	mishap(
		consstring(#|
			procedure();
				dlocal cucharout = identfn;
				printf('Method "%p" %pfailed', [%
					m.pdprops, if upd then 'updater ' else nullstring endif
				%]);
			endprocedure()
		|#),
		args);
enddefine;

;;; failure:
;;;     called from a generic procedure when no method part has been
;;;     found which matches the classes of the supplied arguments. The
;;;     default value of fail_generic calls report_failure defined
;;;     above.

define failure();
	chain(caller(1), fail_generic);
enddefine;
;;;
define updaterof failure();
	chain(caller(1), updater(fail_generic));
enddefine;

endsection;		/* $-objectclass */
