/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 * File:            S.sun3/src/aarith.s
 * Purpose:
 * Author:          John Gibson (see revisions)
 */

/**************************************************************************
 *                                                                        *
 *                            aarith.s                                    *
 *                        arithmetic routines                             *
 *                           for 68020				          *
 *                                                                        *
 **************************************************************************/

#_<

#_INCLUDE 'declare.ph'

constant
	procedure Sys$-Array$-Sub_error
	;

lconstant macro (
	_PD_ARRAY_TABLE		= @@PD_ARRAY_TABLE,
	_PD_ARRAY_VECTOR	= @@PD_ARRAY_VECTOR,
	_PD_ARRAY_SUBSCR_PDR	= @@PD_ARRAY_SUBSCR_PDR,
	);

>_#

/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.text

;;; --- LOGICAL BIT ROUTINES ------------------------------------------------

DEF_C_LAB 4 (_biset)
	movl	a6@+, d0
	orl	d0, a6@
	rts

DEF_C_LAB 4 (_biclear)
	movl	a6@+, d0
	notl	d0
	andl	d0, a6@
	rts

DEF_C_LAB 4 (_bimask)
	movl	a6@+, d0
	andl	d0, a6@
	rts

DEF_C_LAB 4 (_bixor)
	movl	a6@+, d0
	eorl	d0, a6@
	rts

;;; ------------------------------------------------------------------------

DEF_C_LAB 4 (_mult)
	movl	a6@+, d0		;;; integer 2
	mulsl	a6@, d0			;;; times integer 1 into d0
	movl	d0, a6@			;;; return result
	rts

;;; ------------------------------------------------------------------------

	;;; integer divide
DEF_C_LAB 4 (_div)
	movl	a6@+, d0		;;; divisor
	movl	a6@, d1			;;; dividend
	divsll	d0, d2:d1		;;; quot -> d1, rem -> d2
	movl	d2, a6@			;;; return remainder
	movl	d1, a6@-		;;; and quotient
	rts

	;;; integer divide, quotient only
DEF_C_LAB 2 (_divq)
	movl	a6@+, d0		;;; divisor
	movl	a6@, d1			;;; dividend
	divsll	d0, d2:d1		;;; quot -> d1, rem -> d2
	movl	d1, a6@			;;; return quotient
	rts

;;; ------------------------------------------------------------------------

	;;; pop integer multiply
DEF_C_LAB 4 (_pmult)
	movl	a6@+,d0			;;; popint 2
	asrl	#2, d0			;;; make machine int
	movl	a6@, d1			;;; popint 1
	subql	#3, d1			;;; clear popint bits
	mulsl	d1, d0
	addql	#3, d0			;;; restore result to popint
	movl	d0, a6@			;;; return it
	rts

	;;; and with overflow test
DEF_C_LAB (_pmult_testovf)
	movl	a6@+,d0			;;; popint 2
	asrl	#2, d0			;;; make machine int
	movl	a6@, d1			;;; popint 1
	subql	#3, d1			;;; clear popint bits
	mulsl	d1, d0			;;; product -> d0
	bvss	1$			;;; return false if overflow
	addql	#3, d0			;;; restore result to popint
	movl	d0, a6@			;;; return it
	movl    #C_LAB(true), a6@-	;;; and true
	rts
1$:	addql	#3, d0			;;; restore result to popint
	movl	d0, a6@			;;; return it
	movl	d4, a6@-		;;; return false
	rts

;;; ------------------------------------------------------------------------

	;;; replace tos with false and return
false2:	movl	d4, a6@
	rts

;;; ------------------------------------------------------------------------

	;;; pop integer divide
DEF_C_LAB 4 (_pdiv)
	movl	a6@+, d0		;;; divisor
	asrl	#2, d0			;;; convert to sysint
	movl	a6@, d1			;;; dividend
	asrl	#2, d1			;;; convert to sysint
	divsll	d0, d2:d1		;;; quot -> d1, rem -> d2
	asll    #2, d2			;;; convert remainder to popint
	addql	#3, d2
	movl	d2, a6@
	asll    #2, d1			;;; convert quotient to popint
	addql	#3, d1
	movl	d1, a6@-
	rts

;;; ------------------------------------------------------------------------

	;;; convert int to popint, with overflow test
DEF_C_LAB (_pint_testovf)
	movl	a6@, d0
	asll	#2, d0
	bvss	false2			;;; false for overflow
	addql	#3, d0
	movl	d0, a6@
	movl	#C_LAB(true), a6@-
	rts

;;; ------------------------------------------------------------------------

	;;; shift popint left, with overflow test
DEF_C_LAB (_pshift_testovf)
	movl	a6@+, d0		;;; +ve shift amount
	movl	a6@, d1			;;; the pop integer
	eorl	#3, d1			;;; clear popint bits
	beqs	1$			;;; no overflow if 0
	cmpl	#30, d0			;;; shift >= 30 bits?
	bge	false2			;;; overflow if so
	asll	d0, d1			;;; else do the shift
	bvs	false2			;;; false for overflow
	orb	#3, d1			;;; reset popint bits
	movl	d1, a6@			;;; return it
1$:	movl	#C_LAB(true), a6@-	;;; and true
	rts


;;; --- BIGINTEGER ARITHMETIC --------------------------------------------

	;;; multiply two long slices to get double length result
	;;; _emul(multiplicand, multiplier) -> high -> low
DEF_C_LAB (_emul)
DEF_C_LAB (_posword_emul)
	movl	a6@+, d0		;;; multiplier
	mulsl	a6@, d1:d0		;;; * multiplicand, lo->d0, hi->d1
	asll	#1, d1			;;; shift up hi part
	bclr	#31, d0			;;; clear bit 31 in lo part
	beqs	1$			;;; branch if wasn't set
	addql	#1, d1			;;; else transfer up to hi part
1$:	movl	d0, a6@			;;; return lo part
	movl	d1, a6@-		;;; and hi part
	rts


	;;; divide double dividend by single longword slice
	;;; _ediv(high, low, divisor) -> quotient -> remainder
DEF_C_LAB (_ediv)
	movl	a6@+, d0		;;; signed divisor
	movl	a6@+, d1		;;; dividend lo
	movl	a6@, d2			;;; dividend hi
	asrl	#1, d2			;;; shift down hi
	bccs	1$			;;; branch if bit 0 wasn't 1
	bset	#31, d1			;;; transfer bit 0 down to lo bit 31
1$:	divsl	d0, d2:d1		;;; divide, rem->d2, quot->d1
	movl	d2, a6@			;;; return remainder
	movl	d1, a6@-		;;; and quoitent
	rts


	;;; multiply a biginteger by a signed value into a destination bigint
	;;; _bgi_mult(multiplier, saddr, slim, daddr) -> nextdest -> carry
DEF_C_LAB (_bgi_mult)
	movl	a6@+, a1		;;; dest addr
	movl	a6@+, d4		;;; source limit
	movl	a6@+, a0		;;; source addr
	moveq	#0, d2			;;; clear last carry slice
	moveq	#0, d3			;;; use d3 as zero data reg

1$:	movl	a0@+, d0		;;; next source slice -> d0
	mulsl	a6@, d1:d0		;;; * multiplier, lo -> d0, hi -> d1
	;;; add in carry
	tstl	d2			;;; carry negative?
	bpls	2$			;;; branch if not
	subql	#1, d1			;;; else subtract 1 to account for sign
2$:	addl	d2, d0			;;; add last carry slice to lo
	addxl	d3, d1			;;; add extend bit to result hi

	asll	#1, d1			;;; shift up hi
	bclr	#31, d0			;;; clear bit 31 in lo part
	beqs	3$			;;; branch if wasn't set
	addql	#1, d1			;;; else transfer up to hi part

3$:	movl	d0, a1@+		;;; store lo at next destination
	movl	d1, d2			;;; hi becomes next carry
	cmpl	d4, a0			;;; reached source limit?
	bcss	1$			;;; next if not

	movl	d2, a6@			;;; return carry slice
	movl	a1, a6@-		;;; and next destination
	movl	#C_LAB(false), d4	;;; restore d4 to false
	rts

	;;; multiply a biginteger by a signed value and add
	;;; into a destination bigint
	;;; _bgi_mult_add(value, saddr, slim, sdaddr) -> nextdest -> carry
DEF_C_LAB (_bgi_mult_add)
	movl	a6@+, a1		;;; dest addr
	movl	a6@+, d4		;;; source limit
	movl	a6@+, a0		;;; source addr
	moveq	#0, d2			;;; clear last carry slice
	moveq	#0, d3			;;; use d3 as zero data reg

1$:	movl	a0@+, d0		;;; next source slice -> d0
	mulsl	a6@, d1:d0		;;; * multiplier, lo -> d0, hi -> d1
	;;; add carry
	tstl	d2			;;; carry negative?
	bpls	2$			;;; branch if not
	subql	#1, d1			;;; else hi -1 to account for sign
2$:	addl	d2, d0			;;; add last carry slice to lo
	addxl	d3, d1			;;; add extend bit to result hi
	;;; add destination slice
	movl	a1@, d2			;;; dest slice
	bpls	3$			;;; branch if not negative
	subql	#1, d1			;;; else hi -1 to account for sign
3$:	addl	d2, d0			;;; add dest slice to lo
	addxl	d3, d1			;;; add extend bit to result hi

	asll	#1, d1			;;; shift up hi
	bclr	#31, d0			;;; clear bit 31 in lo part
	beqs	4$			;;; branch if wasn't set
	addql	#1, d1			;;; else transfer up to hi part

4$:	movl	d0, a1@+		;;; store lo at next destination
	movl	d1, d2			;;; hi becomes next carry
	cmpl	d4, a0			;;; reached source limit?
	bcss	1$			;;; next if not

	movl	d2, a6@			;;; return carry slice
	movl	a1, a6@-		;;; and next destination
	movl	#C_LAB(false), d4	;;; restore d4 to false
	rts


	;;; divide a biginteger by a signed value into a destination bigint
	;;; _bgi_div(divisor, saddr, slim, dlim) -> remainder
DEF_C_LAB (_bgi_div)
	movl	a6@+, a1		;;; dest limit addr
	movl	a6@+, a0		;;; source limit
	movl	a6@+, d3		;;; source start addr

	moveq	#0, d1			;;; zero hi
	movl	a0@-, d0		;;; ms (signed) slice of source into lo
	bpls	2$			;;; do first divide
	moveq	#-1, d1			;;; sign extension in hi part
	bras	2$			;;; do first divide

1$:	movl	a0@-, d0		;;; next (+ve) source slice in lo part
	asrl	#1, d1			;;; shift down remainder, now hi part
	bccs	2$			;;; branch if bit 0 wasn't set
	bset	#31, d0			;;; else set bit 31 in lo
2$:	divsl	a6@, d1:d0		;;; div by divisor quot->d0, rem->d1
	movl	d0, a1@-		;;; store quot in dest (can be -ve)
	cmpl	d3, a0			;;; reached source start?
	bhis	1$			;;; next if not

	movl	d1, a6@			;;; return last remainder
	rts


;;; --- COMPUTE ARRAY SUBSCRIPTS -----------------------------------------

	;;; compute an array total subscript
DEF_C_LAB (_array_sub)
	movl	sp@(4), a0	;;; array procedure address
	lea	a0@(_PD_ARRAY_TABLE), a0	;;; start of params
	movl	a0@+, d4	;;; init total subscript from 1st word
	bras	3$

1$:	movl	a6@+, d1	;;; next dimension subscript
	btst	#1, d1		;;; pop integer?
	beqs	4$		;;; error if not
	subl	a0@+, d1	;;; subtract lower bound
	cmpl	d0, d1		;;; compare with length
	bccs	4$		;;; error if subscript >= length unsigned
	movl	a0@+, d0	;;; dimension scaling factor
	beqs	2$		;;; zero means 1, so no multiply needed
	mulul	d0, d1		;;; times subscript
2$:	addl	d1, d4		;;; add to total
3$:	movl	a0@+, d0	;;; length in next dimension
	bnes	1$		;;; continue unless zero

	;;; finished -- push total subscript to stack, push array vector
	;;; to stack, and then chain subscripting procedure
	movl	d4, a6@-		;;; subscript
	movl	#C_LAB(false), d4	;;; restore d4 to false
	movl	sp@(4), a0		;;; array procedure again
	movl	a0@(_PD_ARRAY_VECTOR), a6@-	;;; array vector
	movl	a0@(_PD_ARRAY_SUBSCR_PDR), a0	;;; subscr procedure
	movl	a0@, a0			;;; execute address
	jmp	a0@			;;; chain it

	;;; subscript not popint or too big/small
4$:	tstl	a6@-			;;; get bad subscript on top of stack
	movl	#C_LAB(false), d4	;;; restore d4 to false
	jmp	XC_LAB(weakref Sys$-Array$-Sub_error)	;;; error procedure


/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 30 1994
	Changes to _array_sub
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Dec  2 1988
	Added _divq
--- John Gibson, Aug 22 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Apr 20 1988
	New version using 68020 multiply/divide instructions.
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- Aled Morris, Oct  4 1987 fixed bug in _posword_emul, replacing a6@(1)
	with a6@(2) since displacements must be specified in bytes, not in the
	units of the operation (words, in these 2 cases).
	See bugreport "aarons@tsuna.uucp.20"
 */
