/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 * File:	    S.sun3/src/amove.s
 * Purpose:
 * Author:	    John Gibson, Jul 26 1987 (see revisions)
 * Documentation:
 * Related Files:
 */

/**************************************************************************
 *									  *
 *			       amove.s					  *
 *			 for 68000 under unix				  *
 *									  *
 **************************************************************************/

#_<

#_INCLUDE 'declare.ph'

>_#

/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	.text

	;;; -----------------------------------------------------------------
	;;; compare two byte regions of the same length
DEF_C_LAB (_bcmp)
	movl	a6@+, a1		;;; region2 address
	movl	a6@+, a0		;;; region1 address
	movl	a6@, d0			;;; length in bytes
1$:	subql	#1, d0			;;; one less to do
	blts	2$			;;; true if done
	cmpmb	a0@+, a1@+		;;; compare a byte
	beqs	1$			;;; loop if same
	movl	#C_LAB(false), a6@	;;; false for different
	rts
2$:	movl	#C_LAB(true), a6@	;;; true for same
	rts

	;;; -----------------------------------------------------------------
	;;; compare two word regions of the same length
DEF_C_LAB (_scmp)
	movl	a6@+, a1		;;; region2 address
	movl	a6@+, a0		;;; region1 address
	movl	a6@, d0			;;; length in bytes
1$:	subql	#2, d0			;;; one less to do
	blts	2$			;;; true if done
	cmpmw	a0@+, a1@+		;;; compare a word
	beqs	1$			;;; loop if same
	movl	#C_LAB(false), a6@	;;; false for different
	rts
2$:	movl	#C_LAB(true), a6@	;;; true for same
	rts

	;;; -----------------------------------------------------------------
	;;; compare two longword regions of the same length
DEF_C_LAB (_icmp)
DEF_C_LAB (_cmp)
	movl	a6@+, a1		;;; region2 address
	movl	a6@+, a0		;;; region1 address
	movl	a6@, d0			;;; length in bytes
1$:	subql	#4, d0			;;; one less to do
	blts	2$			;;; true if done
	cmpml	a0@+, a1@+		;;; compare a longword
	beqs	1$			;;; loop if same
	movl	#C_LAB(false), a6@	;;; false for different
	rts
2$:	movl	#C_LAB(true), a6@	;;; true for same
	rts


	;;; -----------------------------------------------------------------
	;;; move longwords, quick version
	;;; if source and destination blocks overlap, this routine only works
	;;; when moving downwards.  only copies whole longwords, and can
	;;; assume that they are word aligned.
DEF_C_LAB (_moveq)
	movl	a6@+, a1		;;; there
	movl	a6@+, a0		;;; here
	movl	a6@, d0			;;; byte count
	beqs	999$			;;; done if zero count
	addl	a1, d0			;;; d0 is one longword past last dest
	cmpl	a0, a1			;;; no offset?
	bnes	1$			;;; beam up if so
	movl	d0, a6@			;;; stack next dest
	rts				;;; return

1$:	movl	a0@+, a1@+		;;; move one longword
	cmpl	a1, d0			;;; done?
	bnes	1$			;;; loop onwards
999$:	movl	a1, a6@			;;; new 'there'
	rts

	;;; -----------------------------------------------------------------
	;;; _BMOVE -- general copy memory
	;;; this is just movchars, but with the arguments on the stack:
	;;; uses:		movchars
	;;; used by:
	;;; arguments:	on pop stack
	;;;	top ->	destination address
	;;;		source address
	;;;		length in bytes
	;;; results:	on pop stack
	;;;	top ->	next destination address
	;;; registers blown: (all by movchars)
	;;;	D0
	;;;	D1
	;;;	D2
	;;;	A0
	;;;	A1
	;;; -----------------------------------------------------------------
DEF_C_LAB (_bmove)
DEF_C_LAB (_smove)
	movl	a6@+, a1		;;; there
	movl	a6@+, a0		;;; here
	movl	a6@, d0			;;; length in bytes
	movl	d0, d1			;;; calculate next destination
	addl	a1, d1
	movl	d1, a6@			;;; leave on pop stack
	bras	movchars		;;; do the move

	;;; -----------------------------------------------------------------
	;;; longword version
DEF_C_LAB (_imove)
DEF_C_LAB (_dmove)
DEF_C_LAB (_move)
	movl	a6@+, a1		;;; there
	movl	a6@+, a0		;;; here
	movl	a6@, d0			;;; length in bytes
	movl	d0, d1			;;; calculate next destination
	addl	a1, d1
	movl	d1, a6@			;;; leave on pop stack
	bras	movchars_la		;;; do the move


	;;; -----------------------------------------------------------------
	;;; MOVCHARS -- general purpose memory move
	;;; handles any size of move in any direction.
	;;; used by: _bmove
	;;; arguments:
	;;;	D0	length in bytes
	;;;	A0	source address
	;;;	A1	destination address
	;;; results: none
	;;; registers blown:
	;;;	D0	(length, in longwords)
	;;;	D1	(extra length, 0, 1, 2, or 3 bytes)
	;;;	D2	(bottom byte of source, for alignment check)
	;;;	D3	(bottom byte of dest, for bit tests)
	;;;	A0	(source)
	;;;	A1	(dest address)
	;;; -----------------------------------------------------------------
	.globl movchars
movchars:
	movw	a0, d2			;;; source pointer
	movw	a1, d3			;;; dest pointer
	orb	d3, d2			;;; or together all bits 0, 1
	orb	d0, d2
	andb	#3, d2			;;; any non longword aligned?
	bnes	movbbb			;;; misaligned -> byte by byte

	;;; longword aligned
.globl movchars_la
movchars_la:
	tstl	d0			;;; zero chars to move?
	beqs	999$			;;; beam up if none
	cmpl	a0, a1			;;; going up or down?
	beqs	999$			;;; home now if no offset
	bhis	10$			;;; branch if a1 > a0
	;;; going down
1$:	movl	a0@+, a1@+		;;; move one lw
	subql	#4, d0			;;; 4 bytes less to go
	bnes	1$			;;; and again
	rts				;;; back to vienna
	;;; going up
10$:	lea	a0@(0,d0:L), a0		;;; point to one past last source char
	lea	a1@(0,d0:L), a1		;;; point to one past last dest char
20$:	movl	a0@-, a1@-		;;; move one lw
	subql	#4, d0			;;; 4 bytes less
	bnes	20$			;;; around we go
999$:	rts				;;; back to vienna

	;;; -----------------------------------------------------------------
	;;; MOVBBB -- move memory byte by byte
	;;; this is for when a block move has source and destination pointers
	;;; do not have the same word alignment, that is, one is word aligned
	;;; and one isn't.
	;;; uses:
	;;; used by:	movchars
	;;; arguments:
	;;;	D0	length
	;;;	A0	source
	;;;	A1	dest
	;;; results:	none
	;;; registers blown:
	;;;	D0	(length, zero on exit)
	;;;	A0	(source)
	;;;	A1	(dest)
	;;; -----------------------------------------------------------------
movbbb: tstl	d0			;;; no characters?
	beqs	999$			;;; home now if none
	cmpl	a0, a1			;;; going up or down?
	beqs	999$			;;; home now if no offset
	bhis	10$			;;; branch if a1 > a0
	;;; going down
1$:	movb	a0@+, a1@+		;;; move one sob
	subql	#1, d0			;;; one less to go
	bnes	1$			;;; and again
	rts				;;; return
	;;; going up
10$:	lea	a0@(0,d0:L), a0		;;; point to one past last source char
	lea	a1@(0,d0:L), a1		;;; point to one past last dest char
20$:	movb	a0@-, a1@-		;;; move one of the sobs
	subql	#1, d0			;;; one less
	bnes	20$			;;; around we go
999$:	rts				;;; return


	;;; -----------------------------------------------------------------
	;;; fill a region of bytes with a given byte
DEF_C_LAB (_bfill)
	movl	a6@+, a0		;;; there
	movl	a6@+, d0		;;; length in bytes
	movl	a6@+, d1		;;; the byte
	bras	2$
1$:	movb	d1, a0@+		;;; move one sob
2$:	subql	#1, d0			;;; one less to go
	bges	1$			;;; and again
	rts

	;;; -----------------------------------------------------------------
	;;; fill a region of longwords with a given longword
DEF_C_LAB (_ifill)
DEF_C_LAB (_fill)
	movl	a6@+, a0		;;; there
	movl	a6@+, d0		;;; length in bytes
	movl	a6@+, d1		;;; the longword
	bras	2$
1$:	movl	d1, a0@+		;;; move one sob
2$:	subql	#4, d0			;;; one less to go
	bges	1$			;;; and again
	rts


;;; ------------------------------------------------------------------------

	;;; _move_callstack(_woffs, _limaddr)
DEF_C_LAB(_move_callstack)
	movl	a6@+, d0	;;; limit address for part to move
	subl	sp, d0		;;; number of bytes to move in d0
	movl	a6@+, d1	;;; number of bytes to shift UP by
	lea	sp@(0,d1:L), a1	;;; + sp = destination address in a1
	movl	sp, a0		;;; source address in a0
	movl	a1, sp		;;; new sp after move
#_IF DEF STACK_PROBES
	tstb	sp@(-64)
#_ENDIF
	bra	movchars_la	;;; sp points to return address after

	;;; -----------------------------------------------------------------
	;;; _SHIFT -- shift a register left by signed number
	;;; uses:		--
	;;; used by:	??
	;;; arguments:	on pop stack
	;;;	top ->	number
	;;;		item
	;;; results:	on pop stack
	;;;	top ->	result
	;;; registers blown:
	;;;	D0	(amount to shift)
	;;;	D1	(item being shifted)
	;;; -----------------------------------------------------------------
DEF_C_LAB (_shift)
	movl	a6@+, d0		;;; amount to shift by
	movl	a6@, d1			;;; item to shift
	tstl	d0
	bpls	1$			;;; shifting left
	negl	d0			;;; absolute value
	asrl	d0, d1			;;; shift it right
	movl	d1, a6@			;;; put it back
	rts
1$:	asll	d0, d1			;;; shift it left, zeroes in
	movl	d1, a6@			;;; put it back
	rts



	;;; access an unsigned bit field
DEF_C_LAB (_bfield)
	moveq	#32, d2
	subb	d1, d2			;;; 32-W = field shift down in d2
	moveq	#31, d1
	andb	d0, d1			;;; get bitoffs within start word
	asrl	#5, d0			;;; get offset
	lsll	#2, d0			;;; to start word
	addl	d0, a0			;;; add to struct addr in a0
	movl	a0@, d0			;;; first word into d0
	lsll	d1, d0			;;; shift 1st word bits to top
	cmpb	d1, d2			;;; bits below field >= 0?
	bges	1$			;;; br if so
	moveq	#32, d3
	subb	d1, d3			;;; 32-bitoffs (no of bits in 1st word)
	movl	a0@(4), d1		;;; get 2nd longword
	lsrl	d3, d1			;;; 2nd word down by that
	orl	d1, d0			;;; or in rest of field
1$:	lsrl	d2, d0			;;; bring down to bottom (32-W)
	rts

	;;; access a signed bit field (same except for last shift down)
DEF_C_LAB (_sbfield)
	moveq	#32, d2
	subb	d1, d2			;;; 32-W = field shift down in d2
	moveq	#31, d1
	andb	d0, d1			;;; get bitoffs within start word
	asrl	#5, d0			;;; get offset
	lsll	#2, d0			;;; to start word
	addl	d0, a0			;;; add to struct addr in a0
	movl	a0@, d0			;;; first word into d0
	lsll	d1, d0			;;; shift 1st word bits to top
	cmpb	d1, d2			;;; bits below field >= 0?
	bges	1$			;;; br if so
	moveq	#32, d3
	subb	d1, d3			;;; 32-bitoffs (no of bits in 1st word)
	movl	a0@(4), d1		;;; get 2nd longword
	lsrl	d3, d1			;;; 2nd word down by that
	orl	d1, d0			;;; or in rest of field
1$:	asrl	d2, d0			;;; sign extend to bottom (32-W)
	rts

	;;; update a bit field
DEF_C_LAB (_ubfield)
	moveq	#32, d2
	subb	d1, d2			;;; 32-W = field shift down in d2
	moveq	#31, d1
	andb	d0, d1			;;; get bitoffs within start word
	asrl	#5, d0			;;; get offset
	lsll	#2, d0			;;; to start word
	addl	d0, a0			;;; add to struct addr in a0
	moveq	#-1, d4
	lsll	d2, d4			;;; left by 32-W = W bits at top
	lsrl	d1, d4			;;; right by bitoffs = field mask
	movl	a6@+, d3		;;; new value for field
	subb	d1, d2			;;; 32-W-bitoffs (bits below field)
	bmis	1$			;;; br if not all in 1st word
	lsll	d2, d3			;;; if so, shift up new value
	bras	2$

	;;; field occupies second longword
1$:	moveq	#32, d0
	addb	d2, d0			;;; 32 - num of overshoot bits
	movl	d3, d1
	lsll	d0, d1			;;; get new value bits at top
	movl	a0@(4), d0		;;; get 2nd word
	negb	d2			;;; number of overshoot bits
	lsll	d2, d0			;;; clear those
	lsrl	d2, d0			;;; at top of old value
	orl	d1, d0			;;; or in new top bits
	movl	d0, a0@(4)		;;; update in 2nd word
	lsrl	d2, d3			;;; remove overshoot from new value

2$:	movl	a0@, d0			;;; first word into d0
	andl	d4, d3			;;; mask new field
	notl	d4			;;; complement mask
	andl	d4, d0			;;; remove old field
	orl	d3, d0			;;; insert new field
	movl	d0, a0@			;;; store it
	movl	#C_LAB(false), d4
	rts


	;;; multiply vector subscript by element size to get offset
	;;; popint subscript in d0, fieldsize in d1
	;;; result in d0
DEF_C_LAB (_vecsub_mult)
	lsrl	#2, d0			;;; convert subscript to m/c int
	subql	#1, d0			;;; correct base
	cmpb	#1, d1			;;; fieldsize is 1?
	beqs	1$			;;; done if so
	movl	d0, d2
	mulu	d1, d0			;;; ls of subscript times size in d0
	swap	d2			;;; ms part in bottom
	tstw	d2			;;; zero?
	beqs	1$			;;; finished if so
	mulu	d1, d2
	swap	d2			;;; assume ms part of this is zero
	addl	d2, d0
1$:	rts


/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Apr  6 1995
	Added _icmp, _imove, _dmove, _ifill as equivalent to word versions
--- John Gibson, Dec 12 1989
	_vecsub_mult no longer adds vector base offset
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Aug 22 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Aug  2 1988
	_movebits removed (replaced by Sys$-Move_bits in movebits.p)
--- John Gibson, Aug  2 1988
	Rewrote _bfield, _sbfield and _ubfield so that they only
	need the field size as argument (instead of the field shift
	and mask).
--- John Gibson, Mar  4 1988
	Replaced _move_restore_frame and _expand_plog_area with
	_move_callstack
--- John Gibson, Feb 14 1988
	Subroutines _movetabtrans_in/out no longer needed (replaced with
	sysPOP procedures in vdfileio.p).
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- John Gibson, Jul 26 1987
	Removed _vedscanline (-vedrefreshtail- rewritten to do without it).
 */
