/* --- Copyright University of Sussex 1991. All rights reserved. ----------
 * File:	S.sun3/src/aprocess.s
 * Purpose:
 * Author:	John Gibson (see revisions)
 */


;;; -------- ROUTINES TO HANDLE PROCESS CALL STACK SWAPPING ------------------

#_<

#_INCLUDE 'declare.ph'
#_INCLUDE 'process.ph'

lconstant macro (
	_ID_VALOF		= @@ID_VALOF,
	_PD_EXIT		= @@PD_EXIT,
	_PD_FLAGS		= @@PD_FLAGS,
	_PD_NLOCALS 		= @@PD_NLOCALS,
	_PD_NUM_STK_VARS	= @@PD_NUM_STK_VARS,
	_PD_FRAME_LEN		= @@PD_FRAME_LEN,
	_PD_REGMASK 		= @@PD_REGMASK,
	_PD_TABLE		= @@PD_TABLE,
	_PS_CALLSTACK_LIM	= @@PS_CALLSTACK_LIM,
	_PS_CALLSTACK_PARTIAL	= @@PS_CALLSTACK_PARTIAL,
	_PS_FLAGS		= @@PS_FLAGS,
	_PS_PARTIAL_RETURN 	= @@PS_PARTIAL_RETURN,
	_PS_STATE		= @@PS_STATE,
	);

>_#


/********************* wrapping structures ***********************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

	/***************************************************
	*  N.B. Because signals can interrupt on any       *
	*  instruction, -sp- must never be `out of phase', *
	*  i.e. pointing above data that's still wanted.   *
	****************************************************/


	.text

	;;; size of an I_BRANCH_std instruction, i.e. a "bra"
BRANCH_std = 4


	;;; swap out the callstack for a process
DEF_C_LAB (_swap_out_callstack)
	movl	a6@+, a0		;;; the process
	movl	a0, process		;;; save it here
	movl	a0@(_PS_CALLSTACK_LIM), a2  ;;; limit of saved callstack
	movl	a0@(_PS_STATE), d3	;;; start of saved callstack
	movl	a6, sav_a6		;;; save a6
	bra	sotest

soloop: movl	sp@+, d2		;;; return address
	movl	sp@+, a1		;;; owner procedure address
	subl	a1, d2			;;; make return address relative

	;;; test if has dlocal expression code to run
	moveq	#_:M_PD_PROC_DLEXPR_CODE, d0
	andb	a1@(_PD_FLAGS), d0
	bne	sobrk			;;; yes -- break out to run code

	;;; (continue here after break)
socont:
	moveq	#0, d0
	movb	a1@(_PD_FRAME_LEN), d0	;;; length of stack frame in words
	subqb	#2, d0			;;; -2 for owner and return addr
	aslw	#2, d0			;;; offset in bytes
	movl	a2, a0			;;; save end for saving registers
	subl	d0, a2			;;; a2 = start of saved values

	;;; save registers
	movw	a1@(_PD_REGMASK), d1	;;; 6-byte code section offset
	jmp	pc@(2, d1:W)		;;; jump to it
					;;;  pop	nonpop
	bras	1$			;;; -- --	-- -- -- --
	nop
	nop
	movl	d5, a0@-		;;; d5 --	-- -- -- --
	bras	1$
	nop
	moveml  #0x0600,a0@-		;;; d5 d6	-- -- -- --
	bras	1$
	movl	a3, a0@-		;;; -- --	a3 -- -- --
	bras	1$
	nop
	moveml  #0x0410,a0@-		;;; d5 --	a3 -- -- --
	bras	1$
	moveml  #0x0610,a0@-		;;; d5 d6	a3 -- -- --
	bras	1$
	moveml  #0x0018,a0@-		;;; -- --	a3 a4 -- --
	bras	1$
	moveml  #0x0418,a0@-		;;; d5 --	a3 a4 -- --
	bras	1$
	moveml  #0x0618,a0@-		;;; d5 d6	a3 a4 -- --
	bras	1$
	moveml  #0x001c,a0@-		;;; -- --	a3 a4 a5 --
	bras	1$
	moveml  #0x041c,a0@-		;;; d5 --	a3 a4 a5 --
	bras	1$
	moveml  #0x061c,a0@-		;;; d5 d6	a3 a4 a5 --
	bras	1$
	moveml  #0x011c,a0@-		;;; -- --	a3 a4 a5 d7
	bras	1$
	moveml  #0x051c,a0@-		;;; d5		a3 a4 a5 d7
	bras	1$
	moveml  #0x071c,a0@-		;;; d5 d6	a3 a4 a5 d7

1$:	movl	a0, d0			;;; limit for stack vars/dlocals
	movl	a2, a0			;;; where those start into a0
	movl	a1, a2@-		;;; stack owner in process
	movl	d2, a2@-		;;; and relative return address

	movb	a1@(_PD_NUM_STK_VARS), d2 ;;; number of on_stack vars
	beqs	3$
2$:	movl	sp@+, a0@+		;;; copy stack var values
	subqb	#1, d2
	bnes	2$			;;; br if more stack vars

3$:	subl	a0, d0			;;; diff between a0 and limit
	beqs	5$			;;; no dlocals if zero
	lea	a1@(_PD_TABLE), a1	;;; identifier table address
	addl	d0, a1			;;; + offset of number of dlocals
4$:	movl	a1@-, a6		;;; next identifier backwards
	movl	a6@(_ID_VALOF), a0@+	;;; stack idval in process
	movl	sp@+, a6@(_ID_VALOF)	;;; restore valof from stack
	subqw	#4, d0			;;; more to go?
	bnes	4$			;;; loop if so

	;;; restore registers (PD_REGMASK still in d1)
5$:	jmp	pc@(2, d1:W)		;;; jump to 6-byte code section
					;;;  pop		nonpop
	bras	sotest			;;; -- --	-- -- -- --
	nop
	nop
	movl	sp@+, d5		;;; d5 --	-- -- -- --
	bras	sotest
	nop
	moveml  sp@+,#0x0060		;;; d5 d6	-- -- -- --
	bras	sotest
	movl	sp@+, a3		;;; -- --	a3 -- -- --
	bras	sotest
	nop
	moveml  sp@+,#0x0820		;;; d5 --	a3 -- -- --
	bras	sotest
	moveml  sp@+,#0x0860		;;; d5 d6	a3 -- -- --
	bras	sotest
	moveml  sp@+,#0x1800		;;; -- --	a3 a4 -- --
	bras	sotest
	moveml  sp@+,#0x1820		;;; d5 --	a3 a4 -- --
	bras	sotest
	moveml  sp@+,#0x1860		;;; d5 d6	a3 a4 -- --
	bras	sotest
	moveml  sp@+,#0x3800		;;; -- --	a3 a4 a5 --
	bras	sotest
	moveml  sp@+,#0x3820		;;; d5 --	a3 a4 a5 --
	bras	sotest
	moveml  sp@+,#0x3860		;;; d5 d6	a3 a4 a5 --
	bras	sotest
	moveml  sp@+,#0x3880		;;; -- --	a3 a4 a5 d7
	bras	sotest
	moveml  sp@+,#0x38a0		;;; d5 --	a3 a4 a5 d7
	bras	sotest
	moveml  sp@+,#0x38e0		;;; d5 d6	a3 a4 a5 d7

sotest: cmpl	d3, a2			;;; reached the beginning?
	bhi	soloop			;;; next frame if not

	;;; finished -- chain procedure on stack
	movl	process, a0
	clrl	a0@(_PS_CALLSTACK_PARTIAL)  ;;; ensure PARTIAL reset to NULL
	clrw	a0@(_PS_FLAGS)		;;; 0 process flags = suspended
	subl	a2, a2			;;; restore a2 (always 0)
	movl	sav_a6, a6		;;; restore a6
	movl	a6@+, a0		;;; procedure
	movl	a0@, a0			;;; PD_EXECUTE address
	jmp	a0@			;;; chain it

	;;; come here to run dlocal expression code, by jumping into the
	;;; owner procedure. owner is in a1 and relative return address in d2
sobrk:  movl	a1, sp@-		;;; push owner back on stack
	movl	process, a0
	movl	d2, a0@(_PS_PARTIAL_RETURN) ;;; save return addr in PARTIAL_RETURN
	movl	a2, a0@(_PS_CALLSTACK_PARTIAL)  ;;; save a2 in CALLSTACK_PARTIAL
	subl	a2, a2			;;; restore a2 to 0
	movl	sav_a6, a6		;;; restore a6
	movl	a0, d0			;;; pass process in CHAIN_REG
	movl	a1@(_PD_EXIT), a1	;;; exit code base address
	jmp	a1@(-BRANCH_std*2)  	;;; go into procedure's suspend code

	;;; then return from procedure's suspend code is to here
	;;; (process in CHAIN_REG)
DEF_C_LAB (_swap_out_continue)
	movl	d0, a0			;;; regain the process
	movl	a6, sav_a6		;;; re-save a6
	movl	a0, process		;;; re-save process
	movl	a0@(_PS_CALLSTACK_PARTIAL), a2  ;;; restore a2
	movl	a0@(_PS_STATE), d3		;;; restore limit
	movl	a0@(_PS_PARTIAL_RETURN), d2 ;;; and rel return in PARTIAL_RETURN
	movl	sp@+, a1		;;; restore owner to a1
	bra	socont			;;; continue swap-out




	;;; swap in the callstack for a process
DEF_C_LAB (_swap_in_callstack)
	movl	a6@+, a0		;;; the process
	movl	a0, process		;;; save it here
	movl	a6, sav_a6		;;; save a6
	movl	a0@(_PS_CALLSTACK_LIM), limit	;;; limit of saved callstack
	movl	a0@(_PS_STATE), a2	;;; start of saved callstack
	bra	sitest

siloop: movl	a2@+, d2		;;; relative return address
	movl	a2@+, d3		;;; owner procedure address
	movl	d3, a1			;;; in an address reg

	;;; save registers on stack
	movw	a1@(_PD_REGMASK), d4	;;; 6-byte code section offset
	jmp	pc@(2, d4:W)		;;; jump to it
					;;;  pop		nonpop
	bras	1$			;;; -- --	-- -- -- --
	nop
	nop
	movl	d5, sp@-		;;; d5 --		-- -- -- --
	bras	1$
	nop
	moveml  #0x0600,sp@-		;;; d5 d6		-- -- -- --
	bras	1$
	movl	a3, sp@-		;;; -- --		a3 -- -- --
	bras	1$
	nop
	moveml  #0x0410,sp@-		;;; d5 --		a3 -- -- --
	bras	1$
	moveml  #0x0610,sp@-		;;; d5 d6	a3 -- -- --
	bras	1$
	moveml  #0x0018,sp@-		;;; -- --		a3 a4 -- --
	bras	1$
	moveml  #0x0418,sp@-		;;; d5 --		a3 a4 -- --
	bras	1$
	moveml  #0x0618,sp@-		;;; d5 d6	a3 a4 -- --
	bras	1$
	moveml  #0x001c,sp@-		;;; -- --		a3 a4 a5 --
	bras	1$
	moveml  #0x041c,sp@-		;;; d5 --		a3 a4 a5 --
	bras	1$
	moveml  #0x061c,sp@-		;;; d5 d6	a3 a4 a5 --
	bras	1$
	moveml  #0x011c,sp@-		;;; -- --		a3 a4 a5 d7
	bras	1$
	moveml  #0x051c,sp@-		;;; d5	a3 a4 a5 d7
	bras	1$
	moveml  #0x071c,sp@-		;;; d5 d6	a3 a4 a5 d7

1$:	moveq	#0, d1
	movb	a1@(_PD_NUM_STK_VARS), d1 ;;; no of on_stack vars
	aslw	#2, d1			;;; offset in bytes
	addl	d1, a2			;;; addr of after last var
	movl	a2, a0			;;; use in a0 to scan backwards

	moveq	#0, d0
	movb	a1@(_PD_NLOCALS), d0	;;; no of locals
	beqs	4$			;;; br if none
	aslw	#2, d0			;;; offset in bytes
	addl	d0, a2			;;; addr of after last local
	movl	a2, a0			;;; use in a0 to scan backwards
	lea	a1@(_PD_TABLE), a1	;;; identifier table address
2$:	movl	a1@+, a6		;;; next identifier
	movl	a6@(_ID_VALOF), sp@-	;;; stack idval
	movl	a0@-, a6@(_ID_VALOF)	;;; restore process idval
	subqw	#4, d0			;;; more to go?
	bnes	2$			;;; loop if so
	bras	4$

3$:	movl	a0@-, sp@-		;;; copy stack var values
4$:	subqw	#4, d1
	bges	3$			;;; br if more stack vars

	;;; restore registers from process
	jmp	pc@(2, d4:W)		;;; jump to 6-byte code section
					;;;  pop		nonpop
	bras	5$			;;; -- --	-- -- -- --
	nop
	nop
	movl	a2@+, d5		;;; d5 --	-- -- -- --
	bras	5$
	nop
	moveml  a2@+,#0x0060		;;; d5 d6	-- -- -- --
	bras	5$
	movl	a2@+, a3		;;; -- --	a3 -- -- --
	bras	5$
	nop
	moveml  a2@+,#0x0820		;;; d5 --	a3 -- -- --
	bras	5$
	moveml  a2@+,#0x0860		;;; d5 d6	a3 -- -- --
	bras	5$
	moveml  a2@+,#0x1800		;;; -- --	a3 a4 -- --
	bras	5$
	moveml  a2@+,#0x1820		;;; d5 --	a3 a4 -- --
	bras	5$
	moveml  a2@+,#0x1860		;;; d5 d6	a3 a4 -- --
	bras	5$
	moveml  a2@+,#0x3800		;;; -- --	a3 a4 a5 --
	bras	5$
	moveml  a2@+,#0x3820		;;; d5 --	a3 a4 a5 --
	bras	5$
	moveml  a2@+,#0x3860		;;; d5 d6	a3 a4 a5 --
	bras	5$
	moveml  a2@+,#0x3880		;;; -- --	a3 a4 a5 d7
	bras	5$
	moveml  a2@+,#0x38a0		;;; d5 --	a3 a4 a5 d7
	bras	5$
	moveml  a2@+,#0x38e0		;;; d5 d6	a3 a4 a5 d7

5$:	movl	d3, sp@-		;;; stack owner

	;;; test if has dlocal expression code to run
	movl	d3, a1
	moveq	#_:M_PD_PROC_DLEXPR_CODE, d0
	andb	a1@(_PD_FLAGS), d0
	bnes	sibrk			;;; yes -- break out to run code

	;;; (continue here after break)
sicont: addl	a1, d2			;;; make return address absolute
	movl	d2, sp@-		;;; stack it

sitest: cmpl	limit, a2		;;; reached the end?
	bcs	siloop			;;; next frame if not

	;;; finished -- call procedure off stack
	movl	process, a0
	clrl	a0@(_PS_CALLSTACK_PARTIAL)  ;;; ensure PARTIAL reset to NULL
	subl	a2, a2			;;; restore a2 to 0
	movl	#C_LAB(false), d4	;;; restore d4 to false
	movl	sav_a6, a6		;;; restore a6
	movl	a6@+, a0		;;; procedure
	movl	a0@, a0			;;; PD_EXECUTE address
	jmp	a0@			;;; call it with existing return


	;;; come here to run dlocal expression code, by jumping into the
	;;; owner procedure. owner is in a1 and relative return address in d2
sibrk:  movl	process, a0
	movl	d2, a0@(_PS_PARTIAL_RETURN) ;;; save return in PARTIAL_RETURN
	movl	a2, a0@(_PS_CALLSTACK_PARTIAL)  ;;; save a2 in CALLSTACK_PARTIAL
	subl	a2, a2			;;; restore a2 to 0
	movl	#C_LAB(false), d4	;;; restore d4 to false
	movl	sav_a6, a6		;;; restore a6
	movl	a0, d0			;;; pass process in CHAIN_REG
	movl	a1@(_PD_EXIT), a1	;;; exit code base address
	jmp	a1@(-BRANCH_std)	;;; go into procedure's resume code

	;;; then return from procedure's resume code is to here
	;;; (process in CHAIN_REG)
DEF_C_LAB (_swap_in_continue)
	movl	d0, a0			;;; regain the process
	movl	a6, sav_a6		;;; re-save a6
	movl	a0, process		;;; re-save process
	movl	a0@(_PS_CALLSTACK_PARTIAL), a2  ;;; restore a2
	movl	a0@(_PS_CALLSTACK_LIM), limit	;;; restore limit
	movl	a0@(_PS_PARTIAL_RETURN), d2 ;;; restore rel return in PARTIAL_RETURN
	movl	sp@, a1			;;; restore owner to a1
	bra	sicont			;;; continue swap-out


	.data
sav_a6:		.long 0
process:	.long 0
limit:		.long 0


	.text


;;; --- ROUTINES TO HANDLE USERSTACK SWAPPING --------------------------------

	;;; save and erase a given number of bytes at the end of the userstack
DEF_C_LAB (_ussave)
	movl	a6@+, a1		;;; address to store saved part
	movl	a6@+, d0		;;; length to save
	movl	I_LAB(_userhi), a0  ;;; stack base
	subl	d0, a0			;;; where moving from
	movl	a0, d4			;;; save for after move
	jsr	movchars_la		;;; move stuff into save area
	;;; now reposition the rest above
	movl	d4, d0			;;; start of saved part
	subl	a6, d0			;;; length of rest
	movl	a6, a0			;;; stack top is source
	movl	I_LAB(_userhi), a6
	subl	d0, a6			;;; new stack top after move
	movl	a6, a1			;;; is dest for move
	jsr	movchars_la		;;; do the move
	movl	#C_LAB(false), d4	;;; restore d4 to false
	rts

	;;; restore a given number of bytes at the end of the userstack
DEF_C_LAB (_usrestore)
	movl	a6@+, d4		;;; address of part to restore
	movl	a6@+, d3		;;; length of it
	movl	I_LAB(_userhi), d0	;;; stack base
	subl	a6, d0			;;; length of current stack
	movl	a6, a0			;;; stack top is source
	subl	d3, a6			;;; will be new stack top
	movl	a6, a1			;;; and is dest for move
	jsr	movchars_la		;;; make room for restored stuff
	;;; move in the new part
	movl	d3, d0			;;; length to restore
	movl	d4, a0			;;; where coming from
	movl	I_LAB(_userhi), a1	;;; stack base
	subl	d0, a1			;;; sub length to get dest for move
	jsr	movchars_la		;;; move it in under
	movl	#C_LAB(false), d4	;;; restore d4 to false
	rts

	;;; erase a given number of bytes at the end of the userstack
DEF_C_LAB (_userasund)
	movl	a6@+, d1		;;; length in bytes to erase
	movl	a6, a0			;;; current stack is source for move
	addl	d1, a6			;;; where stack will start after
	movl	a6, a1			;;; is dest for move
	movl	I_LAB(_userhi), d0	;;; stack end
	subl	a6, d0			;;; length to move
	jsr	movchars_la		;;; do the move
	rts


/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Jun 15 1991
	Made _swap_in_callstack call a procedure off the stack when
	finished
--- John Gibson, Sep 26 1990
	Rewrote _swap_out_callstack so that -sp- never points above wanted
	data (otherwise, a signal handler stack frame can overwrite data
	below where -sp- points). (_swap_in_callstack already fulfilled
	this condition.)
--- John Gibson, Dec  6 1989
	Changes for new pop pointers (use explicit ID_VALOF offset)
--- John Gibson, Sep 15 1989
	_swap_out_callstack now clears the process' flags and chains the
	procedure on the stack when finished; the SWAP_BACK_IN flag is
	therefore unnecessary.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Williams, Jul  4 1989
	Changed _M_PD_PROC_DLEXPR_CODE to _:M_PD_PROC_DLEXPR_CODE
--- John Gibson, Aug 22 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jul  5 1988
	Made all return addresses stored in process records relative.
--- John Gibson, Jul  3 1988
	Replaced double word field PS_PARTIAL_SAVE with single word field
	PS_PARTIAL_RETURN holding the relative return address (i.e.
	return address minus owner procedure).
--- John Gibson, Feb 22 1988
	Removed # from comment
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
