/* --- Copyright University of Sussex 1995. All rights reserved. -------
 * File:        S.sun3/src/asignals.s
 * Purpose:     Signal Handler for Sun 68000
 * Author:      John Gibson (see revisions)
 */

;;; ----------------------- SIGNAL HANDLER ----------------------------

#_<

#_INCLUDE 'declare.ph'

section $-Sys;

constant
	procedure (Callstack_reset, Error_signal, Vfork_parent)
	;

vars
	Extern$- _saved_sp
	;

endsection;

lconstant macro (
	_SAVED_SP	= [I_LAB(Sys$-Extern$- _saved_sp)],
	);

>_#


/********************* wrapping structures *******************************/

	.text
	.long	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
	.data
	.long	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**********************************************************************/

	.text

SYS_vfork	= 66


;;; --- ROUTINES TO CLEAN UP AND CALL A POP ERROR HANDLER ----------

reset_pop_environ:
	clrl	___pop_in_user_extern	;;; clear this just in case
	jsr	reset_pop_reg_environ
	movl    I_LAB(_userhi), a6	;;; reset user stack
	movl    sp@+, a0		;;; save return
	movl	_SAVED_SP, d0
	beqs    1$			;;; branch if not in external calls
	movl    d0, sp			;;; if so, reset sp to saved value
	clrl    _SAVED_SP
1$: 	jmp 	a0@			;;; return to caller

	;;; Error signals (e.g. SEGV) set return to this
.globl ___pop_errsig
___pop_errsig:
	bsrs    reset_pop_environ
	jsr     XC_LAB(Sys$-Error_signal)	;;; never returns


;;; ------------------------------------------------------------------------

DEF_C_LAB (Sys$- _do_vfork)
	pea	SYS_vfork:w
	trap    #0
	bccs    1$
	movl    d0, EXTERN_NAME(errno)
	movl    #-1, a6@-
	rts

1$: 	tstl    d1		;;; the child?
	beqs    2$		;;; no, the parent
	clrl    a6@-		;;; return 0 for child
	rts

2$:	clrl    _SAVED_SP	;;; in case in extern calls in child
	movl	d0, a6@-	;;; child ID
	movl    #C_LAB(weakref Sys$-Vfork_parent), a6@-
	jmp 	XC_LAB(Sys$-Callstack_reset)


;;; -------------------------------------------------------------------------

	;;; Make a system call, moving args from userstack
	;;; to system stack -- for internal use only (calls to this
	;;; are generated by the _extern syntax form).
	;;; (User external calls are done in aextern.s)

DEF_C_LAB (_call_sys)
	lea	sp@(4), a0		;;; caller's stack frame
	movl	a0, _SAVED_SP 		;;; save for exception conditions

#_IF DEF STACK_PROBES
	tstb	sp@(-256)
#_ENDIF
	movl	a6@+, a0		;;; system proc addr from pop stack
	movl	a6@+, d0		;;; argument count from pop stack
	beqs	2$			;;; no args
1$:	movl	a6@+, sp@-		;;; stack an arg on system stack
	subql	#1, d0
	bnes	1$

2$:	jsr	a0@			;;; call it
	movl	d0, a6@-		;;; stack the result on pop stack
	movl	_SAVED_SP, a0
	lea	a0@(-4), sp		;;; reset sp
	clrl	_SAVED_SP		;;; says no longer in extern calls
	rts


;;; -----------------------------------------------------------------------

	.data
save_val:
	.long 0



/*************** end labels for wrapping structures **************************/

	.text
Ltext_end:
	.data
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Mar 14 1995
	Removed _pop_m*alloc_exhausted (no longer needed)
--- John Gibson, Oct 24 1994
	Removed the C pointers to pop vars (now set up in initial.p)
--- John Gibson, May 24 1994
	errno now used directly for syscall error codes -- got rid of
	code transferring it to _sys*error.
--- John Gibson, Mar 14 1991
	Added __pop_in_X_call
--- John Gibson, Jan 19 1991
	Added clearing of ___pop_in_user_extern in reset_pop_environ
--- John Gibson, Dec 29 1990
	Actual signal handlers rewritten in C and moved to c_core.c (this
	file now contains only routines gone to on return from a signal).
--- John Gibson, Dec  3 1990
	Replaced _pop_a*dd_sig with _pop_add_ast taking ast type as 1st arg
--- Roger Evans, Nov 22 1990 added __pop_xt_dummy_fd
--- John Gibson, Nov 19 1990
	Grouped all C-accessible pointers and added
	__WEAK_pop_external_callback
--- John Gibson, Nov 15 1990
	Changed "jsr" to Callstack_reset in _do_vfork to "jmp", and made it
	clear _SAVED_SP.
--- John Gibson, Nov 13 1990
	Replaced _m*alloc_use_external by _external_flags and
	_pop_malloc_use_external by pop_external_flags, etc.
--- John Gibson, Aug 21 1990
	Signal queue routines rewritten in C and put into malloc.c.
	These access the pop variable _trap via the constant pointer
	_pop_signals_pending.
--- John Gibson, Jun 23 1990
	Fixed SunOS 4.1 problem where protection violation on memory mapped
	with mmap or mprotect causes SIGBUS rather than SIGSEGV.
--- John Gibson, May 15 1990
	a*ddsig now sets _trap to 1, and _remsig sets it to 0 when signal
	queue is empty. _remsig also now returns signal on stack.
--- John Gibson, May 13 1990
	Added __pop_malloc_use_external to enable malloc to get at
	Sys$-_malloc_use_external.
	Changed name of routine called by malloc when internal dynamic
	memory exhausted to __pop_m*alloc_exhausted, and error pop procedure
	called to Sys$-M*alloc_exhausted.
--- John Gibson, Apr 28 1990
	Moved _call_sys to this file from aextern.s (so core routine
	_call_sys doesn't pull in 'optional' external stuff).
	Also now uses signals.ph for signal numbers.
--- John Gibson, Apr 11 1990
	_saved_sp now in $-Sys$-Extern
--- John Gibson, Mar 23 1990
	Removed call of reset_pop_environ from do_vfork (mustn't be
	there now, because it resets the pop registers).
--- Ian Rogers, Jan 16 1990
	Made reset_pop_environ globally accessable. Added call to it
	in 	_do_vfork
--- John Gibson, Sep 12 1989
	Added correct code to deal with FPA_ERROR in SunOS 4 (fpa_handler
	is now called as an ordinary signal routine).
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- Rob Duncan, Apr  4 1989
	Replaced SUN_RELEASE with SUNOS
--- John Gibson, Aug 22 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Aug 16 1988
	Added use of -Seg_violation- for handling SEGV in Sun OS 4
--- Roger Evans, Jun 17 1988
	added SIGILL and SIGEMT to immediately handled signals
--- Roger Evans, Apr 13 1988
	installed in masters, superceding old signal handler
--- Roger Evans, Mar 22 1988
	Vfork_parent into section Sys and weakref'ed
--- Roger Evans, Jan 19 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
	Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- Roger Evans, Dec 23,1987
	Modified signal handler to block ALL signals while running
--- Roger Evans, Dec 17 1987
	Modified signal handler code to allow user handling of signals, and
	to queue signals if several are received before _checkall is
	invoked.
 */
