/* --- Copyright University of Sussex 1992. All rights reserved. ----------
 > File:            C.68000/src/closure_cons.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *PROCEDURE
 */

;;; --------------- CONSTRUCTING CLOSURES (68K) --------------------------

#_INCLUDE 'declare.ph'

constant
		procedure (Sys$-Exec_closure)
	;

;;; ---------------------------------------------------------------------

section $-Sys;

	;;; macros for dropping longs and shorts at _drop_ptr
lconstant macro (
	LONG	= [_drop_ptr!(l)++ -> _drop_ptr],
	SHORT	= [_drop_ptr!(s)++ -> _drop_ptr]
	);


	/*	Construct a raw closure for _nfroz frozvals
	*/
define Cons_closure(_nfroz) -> _clos;
	lvars _drop_ptr, _clos, _size, _nfroz;
	;;; calculate length in shorts (words) of code to be planted
	if _nfroz _gr _16 then
		_6 -> _size
	else
		_nfroz _add _6 -> _size
	endif;
	##(w)[_size | s.r] -> _size;

	;;; add header size and frozval size to get total
	@@PD_CLOS_FROZVALS[_nfroz _add _size] _sub @@POPBASE -> _size;
	Get_store(_size) -> _clos;
	##(w){_size} ->> _size -> _clos!PD_LENGTH;
	unless _clos!PD_LENGTH == _size then
		_clos -> Get_store();		;;; junk it
		mishap(0, 'CLOSURE EXCEEDS MAXIMUM ALLOWABLE SIZE')
	endunless;

	;;; plant code
	_clos@PD_CLOS_FROZVALS[_nfroz] ->> _drop_ptr -> _clos!PD_EXECUTE;

	if _nfroz _gr _16 then
		;;; just give _clos address to Exec_closure (6 words)
		_16:43FA -> SHORT;						;;; lea pc@(d),a1
		@@(w){_clos, _drop_ptr} -> SHORT;   		;;; (d)
		_16:2D09 -> SHORT;						;;; movl a1, a6@-
		_16:4EF9 -> SHORT;						;;; jmp abs
		Exec_closure!PD_EXECUTE -> LONG
	else
		;;; plant code to move PD_EXECUTE field of pdpart to a0 (5 words)
		_16:207A -> SHORT;						;;; movl pc@(d), a0
		@@(w){_clos@PD_CLOS_PDPART, _drop_ptr} -> SHORT;   ;;; (d)
		_16:2050 -> SHORT;						;;; movl a0@, a0
		;;; and address of first frozval to a1
		_16:43FA -> SHORT;						;;; lea pc@(d),a1
		@@(w){_clos@PD_CLOS_FROZVALS, _drop_ptr} -> SHORT;	;;; (d)
		;;; now plant code to push them onto the stack (_nfroz words)
		until _zero(_nfroz) do
			_16:2D19 -> SHORT;					;;; movl a1@+, a6@-
			_nfroz _sub _1 -> _nfroz
		enduntil;
		;;; finally, enter pdpart (1 word)
		_16:4ED0 -> SHORT						;;; jmp a0@
	endif
enddefine;

endsection;		/* $-Sys */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Sep 23 1992
		Added check for size not being too large
--- John Gibson, May  1 1988
		Procedure that used to be -partapply- now reduced to -Cons_closure-
		(called from -consclosure- in consclosure.p), which just returns
		a raw closure for a given number of frozvals.
--- John Gibson, Apr  1 1988
		Mpved Pdr_<> to pdr_compose.p
--- John Gibson, Mar 21 1988
		Rewrote to use SHORT and LONG macros to plant code rather than
		using ass.p procedures
--- John Gibson, Mar  8 1988
		Moved array constructor to C.vax/src/array_cons.p
--- John Williams, Nov  1 1987 -Cons_array- now works on 0-dim arrays
 */
