/* --- Copyright University of Sussex 1992. All rights reserved. ----------
 > File:            C.sun/lib/auto/sun_tty_size.p
 > Purpose:         Get current window size
 > Author:          Chris Slymon, Roger Evans, Jul 16 1985 (see revisions)
 > Documentation:   HELP * SUN_TTY_SIZE
 > Related Files:   <sys/ttycom.h>
 */
compile_mode:pop11 +strict;

section;

include unix_ioctl.ph;

define global sun_tty_size();
	lconstant Vec = initshortvec(2);
	if sys_io_control(poprawdevin, TIOCGWINSZ, Vec) then
		explode(Vec)
		;;; Returns width, height
	else
		false, false
	endif
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct 11 1992
		Created unix_ioctl.ph and this includes it
--- John Williams, Feb 20 1989
		Rewritten using TIOCGWINSZ and -initshortvec-
 */
