/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 * File:            S.sun4/src/aarith.s
 * Purpose:
 * Author:          John Gibson, Aug 19 1988 (see revisions)
 */

;;; ------------------- ARITHMETIC ROUTINES ------------------------------

#_<

#_INCLUDE 'asm.ph'

constant
	procedure Sys$-Array$-Sub_error
	;

lconstant macro (
	_PD_ARRAY_TABLE		= @@PD_ARRAY_TABLE,
	_PD_ARRAY_VECTOR	= @@PD_ARRAY_VECTOR,
	_PD_ARRAY_SUBSCR_PDR	= @@PD_ARRAY_SUBSCR_PDR,
	);

>_#

/********************* wrapping structures ***********************************/

ASM_TEXT_SECTION
	.word	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
ASM_DATA_SECTION
	.word	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

ASM_TEXT_SECTION

;;; --- LOGICAL BIT ROUTINES ------------------------------------------------

	;;; _biset(_int1, _int2) -> _int3  (logical or)
DEF_C_LAB 4 (_biset)
	ld	[%us], %o1
	ld	[%us+4], %o0
	inc	4, %us
	or	%o0, %o1, %o0
	retl
	st	%o0, [%us]

	;;; _biclear(_int1, _int2) -> _int3  (logical and not)
DEF_C_LAB 4 (_biclear)
	ld	[%us], %o1
	ld	[%us+4], %o0
	inc	4, %us
	andn	%o0, %o1, %o0
	retl
	st	%o0, [%us]

	;;; _bimask(_int1, _int2) -> _int3  (logical and)
DEF_C_LAB 4 (_bimask)
	ld	[%us], %o1
	ld	[%us+4], %o0
	inc	4, %us
	and	%o0, %o1, %o0
	retl
	st	%o0, [%us]

	;;; _bixor(_int1, _int2) -> _int3  (logical exclusive or)
DEF_C_LAB 4 (_bixor)
	ld	[%us], %o1
	ld	[%us+4], %o0
	inc	4, %us
	xor	%o0, %o1, %o0
	retl
	st	%o0, [%us]


;;; ------------------------------------------------------------------------

	;;; _mult(_int1, _int2) -> _product
	;;; integer multiply
DEF_C_LAB 4 (_mult)
	ld	[%us], %o1		;;; _int2
	ld	[%us+4], %o0		;;; _int1
	mov	%o7, %g1		;;; save return
	call	pop.Mul			;;; call our routine
	inc	4, %us
	jmp	%g1+8			;;; return
	st	%o0, [%us]		;;; result

;;; ------------------------------------------------------------------------

	;;; _div(_dividend, _divisor) -> _quotient -> _remainder
	;;; integer divide
DEF_C_LAB 4 (_div)
	save	%sp, -64, %sp
	clr	%pb
	ld	[%us], %o1		;;; divisor
	call	quot_rem		;;; defined at end of this file
	ld	[%us+4], %o0		;;; dividend
	st	%o0, [%us+4]		;;; remainder
	st	%o1, [%us]		;;; quotient
	ret
	restore

	;;; _divq(_dividend, _divisor) -> _quotient
	;;; integer divide, quotient only
DEF_C_LAB 2 (_divq)
	save	%sp, -64, %sp
	clr	%pb
	ld	[%us], %o1		;;; divisor
	inc	4, %us
	call	quot_rem		;;; defined at end of this file
	ld	[%us], %o0		;;; dividend
	st	%o1, [%us]		;;; quotient
	ret
	restore

;;; ------------------------------------------------------------------------

	;;; _pmult(int1, int2) -> product
	;;; pop integer multiply
DEF_C_LAB 4 (_pmult)
	ld	[%us], %o1		;;; int2
	ld	[%us+4], %o0		;;; int1
	sra	%o1, 2, %o1		;;; make int2 sysint
	bclr	3, %o0			;;; clear tag bits on other
	mov	%o7, %g1		;;; save return
	call	pop.Mul			;;; call mult routine
	inc	4, %us
	bset	3, %o0			;;; set tag bits on result
	jmp	%g1+8			;;; return
	st	%o0, [%us]		;;; result

	;;; _pmult_testovf(int1, int2) -> product -> bool
	;;; bool true if no overflow, false if overflow
DEF_C_LAB (_pmult_testovf)
	ld	[%us], %o1		;;; int2
	ld	[%us+4], %o0		;;; int1
	sra	%o1, 2, %o1		;;; make int2 sysint
	mov	%o7, %g1		;;; save return
	call	pop.Mul			;;; call mult routine (nz set if overflow)
	bclr	3, %o0			;;; clear tag bits on other
	bset	3, %o0			;;; set tag bits on result
	bz	1f			;;; br if no overflow
	st	%o0, [%us+4]		;;; and store in any case
	jmp	%g1+8			;;; return
	st	%r_false, [%us]		;;; false if overflow

1:	set	C_LAB(true), %o0
	jmp	%g1+8			;;; return
	st	%o0, [%us]		;;; true

;;; ------------------------------------------------------------------------

	;;; replace tos with false and return
repl_false:
	retl
	st	%r_false, [%us]

;;; ------------------------------------------------------------------------

	;;; _pdiv(dividend, divisor) -> quotient -> remainder
	;;; pop integer divide
DEF_C_LAB 4 (_pdiv)
	save	%sp, -64, %sp
	clr	%pb
	ld	[%us], %o1		;;; divisor
	ld	[%us+4], %o0		;;; dividend
	sra	%o1, 2, %o1		;;; make divisor sysint
	call	quot_rem		;;; defined at end of this file
	sra	%o0, 2, %o0		;;; make dividend sysint
	sll	%o0, 2, %o0		;;; make rem popint
	bset	3, %o0
	st	%o0, [%us+4]		;;; remainder
	sll	%o1, 2, %o1		;;; make quot popint
	bset	3, %o1
	st	%o1, [%us]		;;; quotient
	ret
	restore

;;; ------------------------------------------------------------------------

	;;; convert int to popint, with overflow test
DEF_C_LAB (_pint_testovf)
	ld	[%us], %o0
	sll	%o0, 2, %o1
	sra	%o1, 2, %o2
	cmp	%o2, %o0
	bne	repl_false
	bset	3, %o1			;;; set tag bits
	st	%o1, [%us]		;;; return popint
	dec	4, %us
	set	C_LAB(true), %o0
	retl
	st	%o0, [%us]		;;; return true also


;;; ------------------------------------------------------------------------

	;;; shift popint left, with overflow test
DEF_C_LAB (_pshift_testovf)
	ld	[%us], %o0		;;; +ve shift amount
	ld	[%us+4], %o1		;;; the popint
	inc	4, %us
	andncc	%o1, 3, %o1		;;; clear tag bits
	bz	1f			;;; no overflow if 0
	cmp	%o0, 30			;;; shift >= 30 bits ?
	bge	repl_false		;;; overflow if so
	sll	%o1, %o0, %o2		;;; do the shift
	sra	%o2, %o0, %o3		;;; and shift back again
	cmp	%o3, %o1		;;; should be same as original
	bne	repl_false		;;; overflow if not
	bset	3, %o2			;;; set tag bits on result
	st	%o2, [%us]

1:	set	C_LAB(true), %o0	;;; return true also
	dec	4, %us
	retl
	st	%o0, [%us]


;;; --- BIGINTEGER ARITHMETIC --------------------------------------------

	;;; _emul(_multiplicand, _multiplier) -> _hi -> _lo
	;;; multiply two slices to get double slice result
DEF_C_LAB (_emul)
DEF_C_LAB (_posword_emul)
	ld	[%us], %o1		;;; _multiplier
	mov	%o7, %g1		;;; save return
	call	pop.Mul			;;; call our routine -- result in o1,o0
	ld	[%us+4], %o0		;;; _multiplicand
	tst	%o0			;;; bit 31 set in lo part of result?
	bpos	1f			;;; br if not
	sll	%o1, 1, %o1		;;; shift up hi part of result
	bset	1, %o1			;;; becomes bit 0 of hi part
	sethi	%hi(0x80000000), %o2
	bclr	%o2, %o0		;;; clear in lo part
1:	st	%o0, [%us+4]		;;; return lo part
	jmp	%g1+8
	st	%o1, [%us]		;;; return hi part

	;;; _ediv(_hi, _lo, _divisor) -> _quotient -> _remainder
	;;; divide double slice dividend by single
DEF_C_LAB (_ediv)
	mov	%o7, %g1		;;; save return
	ld	[%us], %o2		;;; _divisor passed in o2
	ld	[%us+4], %o1		;;; _lo passed in o1
	ld	[%us+8], %o0		;;; _hi passed in o0
	call	ediv			;;; uses only o regs
	inc	4, %us
	st	%o0, [%us+4]		;;; remainder in o0
	jmp	%g1+8
	st	%o1, [%us]		;;; quotient in o1

	;;; _bgi_mult(_val, _saddr, _slim, _daddr) -> _nextdest -> _carry
	;;; multiply a biginteger by a signed value into a destination bigint
DEF_C_LAB (_bgi_mult)
	save	%sp, -64, %sp
	ld	[%us], %i2		;;; destination addr
	ld	[%us+4], %i1		;;; source lim addr
	ld	[%us+8], %i0		;;; source addr
	ld	[%us+12], %l2		;;; multiplier in l2
	inc	8, %us
	clr	%l0			;;; zero carry slice
	sethi	%hi(0x80000000), %l1	;;; bit 31 in l1

1:	ld	[%i0], %o0		;;; next source slice in o0
	inc	4, %i0			;;; step on source
	call	pop.Mul			;;; mult into o1, o0
	mov	%l2, %o1		;;; with multiplier in o1
	;;; add in last carry slice
	addcc	%o0, %l0, %o0		;;; add carry slice to product lo
	bcc	2f			;;; br if no carry bit
	sra	%l0, 31, %l0		;;; sign extn of carry slice
	inc	1, %o1			;;; add carry bit to product hi
2:	add	%o1, %l0, %l0		;;; + carry slice sign extn is next carry
	;;; move bit 31 of lo up to bit 0 of hi
	bpos	3f			;;; br if bit 31 in lo not set
	sll	%l0, 1, %l0		;;; shift up next carry
	bset	1, %l0			;;; trans bit 31 to bit 0 of hi
	bclr	%l1, %o0		;;; clear it in lo

3:	st	%o0, [%i2]		;;; store lo at next destination
	cmp	%i0, %i1		;;; compare source addr with lim
	blu	1b			;;; next source slice if more
	inc	4, %i2			;;; step on destination

	st	%l0, [%us+4]		;;; return next carry slice
	st	%i2, [%us]		;;; and next destination
	ret
	restore

	;;; _bgi_mult_add(_val, _saddr, _slim, _sdaddr) -> _nextdest -> _carry
	;;; multiply a biginteger by a signed value
	;;; and add into a destination bigint
DEF_C_LAB (_bgi_mult_add)
	save	%sp, -64, %sp
	ld	[%us], %i2		;;; source/destination addr
	ld	[%us+4], %i1		;;; source lim addr
	ld	[%us+8], %i0		;;; source addr
	ld	[%us+12], %l2		;;; multiplier in l2
	inc	8, %us
	clr	%l0			;;; zero carry slice
	sethi	%hi(0x80000000), %l1	;;; bit 31 in l1

1:	ld	[%i0], %o0		;;; next source slice in o0
	inc	4, %i0			;;; step on source
	call	pop.Mul			;;; mult into o1, o0
	mov	%l2, %o1		;;; with multiplier in o1
	;;; add in last carry slice
	addcc	%o0, %l0, %o0		;;; add carry slice to product lo
	bcc	2f			;;; br if no carry bit
	sra	%l0, 31, %l0		;;; sign extn of carry slice
	inc	1, %o1			;;; add carry bit to product hi
2:	add	%o1, %l0, %o1		;;; + carry slice sign extn
	;;; add in destination slice
	ld	[%i2], %l0		;;; dest slice
	addcc	%o0, %l0, %o0		;;; add that to product lo
	bcc	3f			;;; br if no carry bit
	sra	%l0, 31, %l0		;;; sign extn of dest slice
	inc	1, %o1			;;; add carry bit to product hi
3:	add	%o1, %l0, %l0		;;; + carry slice sign extn is next carry
	;;; move bit 31 of lo up to bit 0 of hi
	bpos	4f			;;; br if bit 31 in lo not set
	sll	%l0, 1, %l0		;;; shift up next carry
	bset	1, %l0			;;; trans bit 31 to bit 0 of hi
	bclr	%l1, %o0		;;; clear it in lo

4:	st	%o0, [%i2]		;;; replace lo at next destination
	cmp	%i0, %i1		;;; compare source addr with lim
	blu	1b			;;; next source slice if more
	inc	4, %i2			;;; step on destination

	st	%l0, [%us+4]		;;; return next carry slice
	st	%i2, [%us]		;;; and next destination
	ret
	restore

	;;; _bgi_div(_divisor, _saddr, _slim, _dlim) -> _remainder
	;;; divide a biginteger by a signed value into a destination bigint
DEF_C_LAB (_bgi_div)
	save	%sp, -64, %sp
	ld	[%us], %i2		;;; destination lim addr
	ld	[%us+4], %i1		;;; source lim addr
	ld	[%us+8], %i0		;;; source addr
	ld	[%us+12], %l4		;;; signed divisor in l4
	;;; do first slice with quot_rem
	ld	[%i1-4], %o0		;;; most sig slice (signed) into o0
	call	quot_rem		;;; quot into o1, rem in o0
	mov	%l4, %o1		;;; divisor
	b	2f
	inc	12, %us
	;;; loop for rest done with ediv
1:	call	ediv			;;; quot in o1, rem in o0
	mov	%l4, %o2		;;; divisor arg into o2
2:	dec	4, %i2			;;; step down destination
	st	%o1, [%i2]		;;; store quot at next dest (can be -ve)
	dec	4, %i1			;;; step down source
	cmp	%i1, %i0		;;; reached source start?
	bgu,a	1b			;;; loop if not
	ld	[%i1-4], %o1		;;; next (+ve) slice into o1

	st	%o0, [%us]		;;; return remainder
	ret
	restore


;;; --- COMPUTE ARRAY SUBSCRIPTS -----------------------------------------

	;;; compute an array total subscript -- called inside an array
	;;; procedure (which has done a "save", so can use i0, i1).
DEF_C_LAB (_array_sub)
	add	%pb, _PD_ARRAY_TABLE+4, %i0	;;; start of parameters + 4
	mov	%o7, %i2	;;; save return
	ld	[%i0], %o2	;;; length in first dimension
	ld	[%i0-4], %i1	;;; init total subscript to base subscript
	tst	%o2		;;; first len zero ? (0 dimensions)
	bz,a	3f		;;; br if so
	dec	4, %us

1:	ld	[%us], %o0	;;; next dimension subscript from stack
	ld	[%i0+4], %o3	;;; dimension lower bound
	ld	[%i0+8], %o1	;;; dimension scaling factor
	btst	2, %o0		;;; subscript is popint?
	bz	4f		;;; error if not
	sub	%o0, %o3, %o0	;;; subtract lower bound from subscript
	cmp	%o0, %o2	;;; compare with length
	bgeu	4f		;;; error if subscript >= length unsigned
	tst	%o1		;;; 0 means 1,
	bz	2f		;;; so no multiply needed
	inc	12, %i0		;;; step to next dimension params
	call	pop.Mul		;;; do mult on o0, o1 into o0
	nop
2:	ld	[%i0], %o2	;;; length in next dimension
	add	%i1, %o0, %i1	;;; add scaled subscript to total
	tst	%o2		;;; next length zero ? (marks end)
	bnz,a	1b
	inc	4, %us

	;;; finished -- stack total subscript and arrayvector, and then
	;;; chain subscripting procedure
3:	mov	%i2, %o7	;;; restore return address
	ld	[%pb+_PD_ARRAY_VECTOR], %o1
	ld	[%pb+_PD_ARRAY_SUBSCR_PDR], %opb
	st	%i1, [%us]	;;; subscript
	ld	[%opb], %o0
	st	%o1, [%us-4]	;;; arrayvector
	jmp	%o0+8
	dec	4, %us

	;;; subscript error (bad subscript still tos) -- call error procedure
4:	set	XC_LAB(weakref Sys$-Array$-Sub_error), %o0
	jmp	%o0		;;; chain Sub_error
	nop

;;; --- BASIC MULTIPLY ROUTINE -------------------------------------------
;;; Copy of .mul in C library that we can guarantee doesn't change
;;; any g registers.


.global pop.Mul
pop.Mul:
	mov	%o0, %y
	andncc	%o0, 0xf, %o4
	be	2f
	sethi	%hi(0xffff0000), %o5
	andncc	%o0, 0xff, %o4
	be,a	4f
	mulscc	%o4, %o1, %o4
	andncc	%o0, 0xfff, %o4
	be,a	6f
	mulscc	%o4, %o1, %o4
	andcc	%o0, %o5, %o4
	be,a	8f
	mulscc	%o4, %o1, %o4
	andcc	%g0, %g0, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %g0, %o4
	orcc	%g0, %o0, %g0
	rd	%y, %o0
	bge	0f
	orcc	%g0, %o0, %g0
	sub	%o4, %o1, %o4
0:	bge	1f
	mov	%o4, %o1
	jmp	%o7 + 0x8
	cmp	%o1, -0x1
1:	jmp	%o7 + 0x8
	addcc	%o1, %g0, %g0

2:	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %g0, %o4
	rd	%y, %o5
	sll	%o4, 0x4, %o0
	srl	%o5, 0x1c, %o5
	orcc	%o5, %o0, %o0
	bge	3f
	sra	%o4, 0x1c, %o1
	jmp	%o7 + 0x8
	cmp	%o1, -0x1
3:	jmp	%o7 + 0x8
	addcc	%o1, %g0, %g0

4:	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %g0, %o4
	rd	%y, %o5
	sll	%o4, 0x8, %o0
	srl	%o5, 0x18, %o5
	orcc	%o5, %o0, %o0
	bge	5f
	sra	%o4, 0x18, %o1
	jmp	%o7 + 0x8
	cmp	%o1, -0x1
5:	jmp	%o7 + 0x8
	addcc	%o1, %g0, %g0

6:	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %g0, %o4
	rd	%y, %o5
	sll	%o4, 0xc, %o0
	srl	%o5, 0x14, %o5
	orcc	%o5, %o0, %o0
	bge	7f
	sra	%o4, 0x14, %o1
	jmp	%o7 + 0x8
	cmp	%o1, -0x1
7:	jmp	%o7 + 0x8
	addcc	%o1, %g0, %g0

8:	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %o1, %o4
	mulscc	%o4, %g0, %o4
	rd	%y, %o5
	sll	%o4, 0x10, %o0
	srl	%o5, 0x10, %o5
	orcc	%o5, %o0, %o0
	bge	9f
	sra	%o4, 0x10, %o1
	jmp	%o7 + 0x8
	cmp	%o1, -0x1
9:	jmp	%o7 + 0x8
	addcc	%o1, %g0, %g0


;;; --- NASTY 32-BIT BY 32-BIT SIGNED DIVISION ROUTINE -------------------
;;; Produced by combining .div and .rem from the C library.
;;; Assumes a "save" has been done; takes dividend in o0, divisor in o1,
;;; and produces quotient in o1, remainder in o0
;;; Uses o-regs and l0-3

quot_rem:
	mov	%o0, %l1
	orcc	%o1, %o0, %g0
	bge	L2
	xor	%o1, %o0, %l0
	orcc	%g0, %o1, %g0
	bge	L1
	orcc	%g0, %o0, %g0
	bge	L2
	sub	%g0, %o1, %o1
L1:	sub	%g0, %o0, %o0
L2:	orcc	%o1, %g0, %o5
	bne	L3
	mov	%o0, %o3
	b	div_zero
	nop
L3:	cmp	%o3, %o5
	blu	L29
	clr	%o2
	sethi	%hi(0x8000000), %l2
	cmp	%o3, %l2
	blu	L11
	clr	%o4
L4:	cmp	%o5, %l2
	bgeu	L6
	mov	0x1, %l3
	sll	%o5, 0x4, %o5
	b	L4
	add	%o4, 0x1, %o4
L5:	addcc	%o5, %o5, %o5
	bgeu	L6
	add	%l3, 0x1, %l3
	sll	%l2, 0x4, %l2
	srl	%o5, 0x1, %o5
	add	%o5, %l2, %o5
	b	L7
	sub	%l3, 0x1, %l3
L6:	cmp	%o5, %o3
	blu	L5
	nop
	be	L7
	nop
L7:	subcc	%l3, 0x1, %l3
	bl	L28
	nop
	sub	%o3, %o5, %o3
	mov	0x1, %o2
	b,a	L10
L8:	sll	%o2, 0x1, %o2
	bl	L9
	srl	%o5, 0x1, %o5
	sub	%o3, %o5, %o3
	b	L10
	add	%o2, 0x1, %o2
L9:	add	%o3, %o5, %o3
	sub	%o2, 0x1, %o2
L10:	subcc	%l3, 0x1, %l3
	bge	L8
	orcc	%g0, %o3, %g0
	b,a	L28
L11:	sll	%o5, 0x4, %o5
	cmp	%o5, %o3
	bleu	L11
	addcc	%o4, 0x1, %o4
	be	L29
	sub	%o4, 0x1, %o4
	orcc	%g0, %o3, %g0
L12:	sll	%o2, 0x4, %o2
	bl	L20
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	bl	L16
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	bl	L14
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	bl	L13
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	b	L28
	add	%o2, 0xf, %o2
L13:	addcc	%o3, %o5, %o3
	b	L28
	add	%o2, 0xd, %o2
L14:	addcc	%o3, %o5, %o3
	bl	L15
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	b	L28
	add	%o2, 0xb, %o2
L15:	addcc	%o3, %o5, %o3
	b	L28
	add	%o2, 0x9, %o2
L16:	addcc	%o3, %o5, %o3
	bl	L18
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	bl	L17
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	b	L28
	add	%o2, 0x7, %o2
L17:	addcc	%o3, %o5, %o3
	b	L28
	add	%o2, 0x5, %o2
L18:	addcc	%o3, %o5, %o3
	bl	L19
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	b	L28
	add	%o2, 0x3, %o2
L19:	addcc	%o3, %o5, %o3
	b	L28
	add	%o2, 0x1, %o2
L20:	addcc	%o3, %o5, %o3
	bl	L24
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	bl	L22
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	bl	L21
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	b	L28
	add	%o2, -0x1, %o2
L21:	addcc	%o3, %o5, %o3
	b	L28
	add	%o2, -0x3, %o2
L22:	addcc	%o3, %o5, %o3
	bl	L23
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	b	L28
	add	%o2, -0x5, %o2
L23:	addcc	%o3, %o5, %o3
	b	L28
	add	%o2, -0x7, %o2
L24:	addcc	%o3, %o5, %o3
	bl	L26
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	bl	L25
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	b	L28
	add	%o2, -0x9, %o2
L25:	addcc	%o3, %o5, %o3
	b	L28
	add	%o2, -0xb, %o2
L26:	addcc	%o3, %o5, %o3
	bl	L27
	srl	%o5, 0x1, %o5
	subcc	%o3, %o5, %o3
	b	L28
	add	%o2, -0xd, %o2
L27:	addcc	%o3, %o5, %o3
	b	L28
	add	%o2, -0xf, %o2
L28:	subcc	%o4, 1, %o4
	bge	L12

	tst	%o3
	bl,a	L32
	dec	1, %o2

L29:	tst	%l0
	bl,a	1f
	neg	%o2
1:	tst	%l1
	bl,a	2f
	neg	%o3
2:      mov	%o3, %o0
	retl
	mov	%o2, %o1

L32:	b	L29
	add	%o3, %o1, %o3

div_zero:
	ta	2
	clr	%o1
	retl
	clr	%o0


;;; --- EVEN NASTIER BIGINT DOUBLE-SLICE BY SLICE DIVIDE ------------------

ediv:
	;;; get dividend +ve
	tst	%o0			;;; dividend -ve?
	bpos	1f			;;; br if +ve
	clr	%o5			;;; clear quot/rem sign bits
	;;; dividend -ve
	mov	3, %o5			;;; set to negate quot & rem at end
	subcc	%g0, %o1, %o1		;;; negate dividend ls
	bz	1f			;;; br if 0
	neg	%o0			;;; negate dividend ms
	dec	1, %o0			;;; propagate -1 carry from ls

	;;; get divisor +ve
1:	tst	%o2			;;; divisor -ve?
	bpos	2f			;;; br if not
	clr	%o3			;;; init 0 quotient in o3
	subcc	%g0, %o2, %o2		;;; negate divisor
	bpos	2f			;;; OK if now +ve
	btog	2, %o5			;;; invert quotient sign
	;;; largest -ve divisor (-2 ** 31 = bit 31)
	mov	%o0, %o3		;;; quotient is dividend ms
	b	3f
	andn	%o1, %o2, %o0		;;; remainder is dividend ls (clr bit 31)

2:	addcc	%o1, %o1, %o1		;;; first shift left 1 on ls

#_<
lvars n;
for n from 30 by -1 to 0 do
	'bpos	.+12		\n',	;;; br if no bit to carry to rem
	'add	%o0, %o0, %o0	\n',	;;; shifting rem left one
	'bset	1, %o0		\n',	;;; or in carry bit
	'cmp	%o0, %o2	\n',	;;; rem >= divisor?
    if n >= 12 then
	'blu	.+20		\n'	;;; br if not
    else
	'blu	.+16		\n'	;;; br if not
    endif,
	'addcc	%o1, %o1, %o1	\n',	;;; next shift left 1 on ls
	'sub	%o0, %o2, %o0	\n',	;;; reduce rem
    if n >= 12 then
	'sethi	%hi(1<<' >< n <> '), %o4\n',	;;; set quotient bit
	'bset	%o4, %o3	\n'
    else
	'bset	1<<' >< n <> ', %o3\n'
    endif
endfor
>_#

	;;; remainder in o0, quotient in o3
3:	btst	1, %o5			;;; negate remainder?
	bz	4f			;;; br if not
	btst	2, %o5			;;; negate quotient?
	neg	%o0
4:	bz	5f
	mov	%o3, %o1		;;; quotient returned in o1
	neg	%o1
5:	retl
	nop


/*************** end labels for wrapping structures **************************/

ASM_TEXT_SECTION
	.align	8
Ltext_end:
ASM_DATA_SECTION
	.align	8
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  1 1997
	Now includes asm.ph
--- John Gibson, Mar 24 1995
	Added pop.Mul and used it instead of C library .mul
--- John Gibson, Aug 30 1994
	Changes to _array_sub
--- Robert John Duncan, Jun  1 1993
	Changed to use ASM_SECTION macros for changing section
--- Simon Nichols, Mar  3 1992
	Changed not to assume that %g1 is unused by calls to .mul: this is
	not true if, e.g., the image is linked dynamically. The return
	address is saved on the user stack instead.
--- John Gibson, May 11 1990
	Corrected bug in _divq (was returning remainder in o0 instead of
	quotient in o1!)
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Dec  2 1988
	Added _divq
 */
