/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 * File:	S.sun4/src/aextern.s
 * Purpose:
 * Author:	John Gibson, Aug 19 1988 (see revisions)
 */

;;; ---------------- USER EXTERNAL CALLS / CALLBACK ----------------------

#_<

#_INCLUDE 'asm.ph'
#_INCLUDE 'external.ph'
#_INCLUDE 'numbers.ph'

    ;;; (Minimum) C stack frame
struct FRAME
  { int     FR_REGS[16];	;;; saved registers
    (byte)  FR_STRET;		;;; by-value struct return addr (not used)
    int     FR_DUMP[6];		;;; callee dump area for arg words in regs o0-o5
    int     FR_ARG7;		;;; arg words past the sixth passed on stack
  };

lconstant macro (
	_K_EXTERN_TYPE	= @@K_EXTERN_TYPE,
	_XP_PTR  	= @@XP_PTR,
	_BGI_LENGTH	= @@BGI_LENGTH,
	_BGI_SLICES	= @@BGI_SLICES,
	_EFC_FUNC	= @@EFC_FUNC,
	_EFC_ARG	= @@EFC_ARG,
	_EFC_ARG_DEST	= @@EFC_ARG_DEST,

	_FR_ARG7	= @@FR_ARG7,
	_FR_SIZE	= @@(struct FRAME)++,	;;; must be a mult of 8
	;;; work double (-aligned) location on stack
	WorkDouble	= [%"%"% sp+ % @@FR_STRET %],

	R_SVB		= ['%' r_svb],
	svb_SAVED_SP	= [R_SVB + _SVB_OFFS(Sys$-Extern$- _saved_sp)],
	svb_SAVED_USP	= [R_SVB + _SVB_OFFS(Sys$-Extern$- _saved_usp)],
	svb_IN_USER_EXTERN
			= [R_SVB + _SVB_OFFS(Sys$- _in_user_extern)],

	rPARG	= 'l5',
	rROUT	= 'l6',
	rCSTK	= 'l7',
	);

>_#

/********************* wrapping structures ***********************************/

ASM_TEXT_SECTION
	.word	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
ASM_DATA_SECTION
	.word	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

ASM_TEXT_SECTION

	;;;    _call_external(____arg1, ..., ____argN, _N, _______routine, _________fltsingle)
	;;;
	;;; Call an external procedure, moving args from userstack
	;;; to stack and converting -- for users. Must be capable of
	;;; dealing with callback.
	;;;    Bit N set in the _________fltsingle arg says pass the Nth arg as a
	;;; single float if it's a (d)decimal (otherwise pass (d)decimals
	;;; as doubles). Note that bit 31 governs all args from 32nd onwards
	;;; (i.e. after each arg, _________fltsingle is shifted right _____________algebraically).

DEF_C_LAB (_call_external)

	ld	[%us], %o2		;;; _________fltsingle arg in o2 (will be i2)
	ld	[%us+4], %o1		;;; _______routine to call in o1 (will be i1)
	ld	[%us+8], %o3		;;; argument count _N in o3
	inc	12, %us
	sll	%o3, 2, %o3		;;; offset of args on userstack
	add	%o3, %us, %o0		;;; keep addr of after args in o0 (i0)

	;;; create stack frame -- allow 2 words of stack space for each arg
	add	%o3, %o3, %o3		;;; double offset
	inc	_FR_SIZE, %o3		;;; plus min frame size
	neg	%o3
	;;; save caller's stack frame ptr for callback/exceptions
	st	%sp, [svb_SAVED_SP]
	save	%sp, %o3, %sp		;;; create frame

	;;; other regs maintained during loop (l5-l7)
	mov	%i0, %rPARG		;;; end of pop args as arg ptr in rPARG
	set	set_param, %rROUT	;;; addr of next store routine in rROUT
	b	first_arg
	add	%sp, _FR_ARG7, %rCSTK	;;; start addr for C stack args in rCSTK


	;;; 2nd and subsequent args
arg_loop:
	sra	%i2, 1, %i2		;;; shift down next _________fltsingle bit

first_arg:
	cmp	%rPARG, %us		;;; done all args?
	bgu,a	do_arg			;;; branch if not ...
	ld	[%rPARG-4], %l0		;;; ... loading next arg into l0

	;;; args transferred -- call routine
	;;; (save global registers to restore after)
	st	%i0, [svb_SAVED_USP]	;;; save user sp for callback
	mov	%r_false, %l2		;;; save r_false
	mov	%r_svb, %l3		;;; save r_svb

	call	%i1			;;; call the routine
	;;; NEXT INSTRUCTION ENABLES ASYNC CALLBACK
	st	%sp, [svb_IN_USER_EXTERN]	;;; any nonzero value

	mov	%l3, %r_svb		;;; recover r_svb   (g5)
	;;; NEXT INSTRUCTION DISABLES ASYNC CALLBACK
	clr	[svb_IN_USER_EXTERN]

	mov	%l2, %r_false		;;; recover r_false (g6)
	ld	[svb_SAVED_USP], %us	;;; recover user sp

	;;; set result_struct with possible float result from
	;;; f0 in first 2 words and possible word result from o0 in last
	set	C_LAB(Sys$-Extern$-result_struct), %o1
	std	%f0, [%o1]		;;; float result
	st	%o0, [%o1+8]		;;; word result

	restore
	retl
	clr	[svb_SAVED_SP]		;;; says no longer in extern calls


	;;; deal with arg in l0
do_arg:
	btst	1, %l0			;;; arg simple?
	bz,a	2f			;;; br if not ...
	ld	[%l0+_KEY], %l1		;;; ... getting key of structure in l1

	;;; simple
	btst	2, %l0			;;; integer?
	bz	0f			;;; br if decimal ...
	dec	4, %rPARG		;;; ... and step down arg ptr

	;;; integer
	jmp	%rROUT			;;; store arg ...
	sra	%l0, 2, %l0		;;; ... converting to sysint

	;;; decimal -- pass as double float unless _________fltsingle bit set
0:	btst	1, %i2			;;; _________fltsingle bit zero?
	bz	1f			;;; br if so ...
	bclr	1, %l0			;;; ... and clear bottom bit of arg
	;;; pass as single
	jmp	%rROUT			;;; store single arg
	nop
	;;; pass as double
1:	st	%l0, [WorkDouble]	;;; put in stack work location
	ld	[WorkDouble], %f0	;;; now into float reg
	fstod	%f0, %f0		;;; convert to double
	std	%f0, [WorkDouble]	;;; double back into mem
	jmp	%rROUT-8		;;; store double arg ...
	ldd	[WorkDouble], %l0	;;; ... after loading it into l0, l1


	;;; structure (key already in l1)
2:	ldub	[%l1+_K_EXTERN_TYPE], %l1 ;;; type
	cmp	%l1, _:EXTERN_TYPE_NORMAL ;;; normal?
	bne	3f			;;; br if not ...
	dec	4, %rPARG		;;; .... stepping down arg ptr
	;;; ordinary structure -- just pass pointer
	jmp	%rROUT			;;; store single arg
	nop

3:	cmp	%l1, _:EXTERN_TYPE_DEREF ;;; compare for deref type
	bne,a	4f			;;; br if not deref type ...
	cmp	%l1, _:EXTERN_TYPE_DDEC ;;; ... comparing for ddecimal
	;;; pass word field at pointer (e.g. external pointer)
	jmp	%rROUT			;;; store single arg
	ld	[%l0], %l0		;;; dereferenced

4:	be,a	6f			;;; br if ddecimal ...
	btst	1, %i2			;;; ... testing _________fltsingle bit

	;;; else must be biginteger (EXTERN_TYPE_BIGINT)
	;;; pass least significant 32 bits
	ld	[%l0+_BGI_LENGTH], %l2	;;; number of slices
	cmp	%l2, 1			;;; only 1 slice?
	be	5f			;;; just ls slice if so ...
	ld	[%l0+_BGI_SLICES], %l1	;;; ... ls slice (31 bits) into l1
	ld	[%l0+_BGI_SLICES+4], %l2 ;;; else next slice into l2
	sll	%l2, 31, %l2		;;; bottom bit upto top
	add	%l1, %l2, %l1		;;; add to ls 31 bits
5:	jmp	%rROUT			;;; store single arg
	mov	%l1, %l0		;;; with value in l0

	;;; ddecimal (_________fltsingle bit already tested)
6:	bnz	7f			;;; br if _________fltsingle bit set ...
	ld	[%l0+_DD_2], %l1	;;; ... loading ls part of ddecimal
	;;; pass as double
	jmp	%rROUT-8		;;; store double arg from l0, l1 ...
	ld	[%l0+_DD_1], %l0	;;; ... after loading ms part into l0
	;;; convert double to single
7:	ld	[%l0+_DD_1], %l0	;;; load ms part into l0
	std	%l0, [WorkDouble]	;;; put in stack work location
	ldd	[WorkDouble], %f0	;;; now into float reg
	fdtos	%f0, %f0		;;; convert to single
	st	%f0, [WorkDouble]	;;; single back into mem
	jmp	%rROUT			;;; store single arg from l0 ...
	ld	[WorkDouble], %l0	;;; ... after loading it


	;;; routines to store args in o0-o5 and then stack locations
	;;; next single routine address is %rROUT, double is %rROUT-8

	mov	%l1, %o1		;;; <- double o0, o1
	inc	5*4, %rROUT
set_param:
	mov	%l0, %o0		;;; <- single o0
	b	arg_loop
	inc	5*4, %rROUT

	mov	%l1, %o2		;;; <- double o1, o2
	inc	5*4, %rROUT
	mov	%l0, %o1		;;; <- single o1
	b	arg_loop
	inc	5*4, %rROUT

	mov	%l1, %o3		;;; <- double o2, o3
	inc	5*4, %rROUT
	mov	%l0, %o2		;;; <- single o2
	b	arg_loop
	inc	5*4, %rROUT

	mov	%l1, %o4		;;; <- double o3, o4
	inc	5*4, %rROUT
	mov	%l0, %o3		;;; <- single o3
	b	arg_loop
	inc	5*4, %rROUT

	mov	%l1, %o5		;;; <- double o4, o5
	inc	5*4, %rROUT
	mov	%l0, %o4		;;; <- single o4
	b	arg_loop
	inc	5*4, %rROUT

	st	%l1, [%rCSTK]		;;; <- double o5, first stack
	inc	4, %rCSTK		;;; incr stack arg ptr
	mov	%l0, %o5		;;; <- single o5
	b	arg_loop
	inc	5*4, %rROUT

	st	%l1, [%rCSTK+4]		;;; <- double on stack
	b	1f
	st	%l0, [%rCSTK]		;;; <- single on stack
	b	arg_loop
	inc	4, %rCSTK
1:	b	arg_loop
	inc	8, %rCSTK


;;; --- EXTERNAL FUNCTION CLOSURES --------------------------------------

	;;; g1 = (exfunc_clos address)+4, g2 = EFC_FUNC field
	;;; assign EFC_ARG to EFC_ARG_DEST and chain EFC_FUNC

DEF_C_LAB(Sys$- _exfunc_clos_action)

	ld	[%g1+_EFC_ARG_DEST-4], %g3	;;; dest addr in g3
	ld	[%g2], %g2			;;; deref func exptr in g2
	ld	[%g1+_EFC_ARG-4], %g4		;;; arg in g4
	jmp	%g2				;;; chain to func ...
	st	%g4, [%g3]			;;; ... storing arg at dest


;;; --- INTERFACE ROUTINE FOR EXTERNAL CALLBACK ----------------------------

	;;; C Synopsis:
	;;;
	;;; 	int _pop_external_callback(argp)
	;;; 	unsigned argp[];
	;;;
	;;; (where argp[0] is the function code for -Callback-)

.globl EXTERN_NAME(_pop_external_callback)
EXTERN_NAME(_pop_external_callback):

	;;; dummy stack frame (16 words for reg part plus 2 mem words
	;;; for SF_NEXT_SEG_SP and SF_NEXT_SEG_HI)
	save	%sp, -(16+2)*4, %sp
	set	C_LAB(_special_var_block), %r_svb	;;; = g5

	ld	[svb_IN_USER_EXTERN], %i2
	;;; NEXT INSTRUCTION DISABLES ASYNC CALLBACK
	clr	[svb_IN_USER_EXTERN]

	;;; set up pop global registers
	;;; (OK to crap on these non-locally, since C things do ...)
	set	C_LAB(false), %r_false	;;; = g6
	ld	[svb_SAVED_USP], %us	;;; recover user sp

	st	%i0, [%us-4]		;;; push argp
	clr	[%us-8]			;;; push dummy 0 for break diff

	call	XC_LAB(Sys$-Extern$-Callback)
	dec	8, %us

	ld	[%us], %i0		;;; return status
	inc	4, %us
	st	%us, [svb_SAVED_USP]	;;; resaving user sp

	restore
	retl				;;; return into external code
	;;; NEXT INSTRUCTION ENABLES ASYNC CALLBACK
	st	%o2, [svb_IN_USER_EXTERN]


	;;; for indirect weak reference
SET_C_LAB(Sys$- _external_callback_func) = EXTERN_NAME(_pop_external_callback)



/*************** end labels for wrapping structures **************************/

ASM_TEXT_SECTION
	.align	8
Ltext_end:
ASM_DATA_SECTION
	.align	8
Ldata_end:

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  1 1997
	Now includes asm.ph
--- John Gibson, Feb 17 1995
	Moved definition of Extern$- _r*esult_struct to extern_ptr.p as
	Extern$-result_struct
--- John Gibson, Oct 22 1994
	__pop_in_user_extern now accessed as Sys$- _in_user_extern in
	special var block
--- John Gibson, Oct 21 1994
	Changed to use new SET_C_LAB for defining _external_callback_func
--- John Gibson, Nov  9 1993
	Made _pop_external_callback set __pop_in_user_extern back to the same
	value it had on entry
--- Robert John Duncan, Jun  1 1993
	Changed to use ASM_SECTION macros for changing section
--- John Gibson, May 19 1993
	Template part of exfunc closures now generated by POPC, which
	jumps to the _exfunc_clos_action code in this file.
--- John Gibson, Dec 18 1992
	Moved pop_ex*func_arg to c_core.c (otherwise it's undefined if this
	file is not extracted)
--- John Gibson, Aug  6 1992
	Changed _call_external to take _________fltsingle arg whose Nth bit
	specifies the treatment of (d)decimals for the Nth arg
--- Robert John Duncan, Jul 27 1992
	Changed to use -EXTERN_NAME-
--- John Gibson, Mar 11 1991
	Changed _call_external to cope with any number of args.
--- John Gibson, Jan 19 1991
	Added setting and clearing of ___pop_in_user_extern (tested nonzero
	by signal handler in c_core.c to determine whether asynchronous
	callback is allowed)
--- John Gibson, Nov 19 1990
	Added pop label for _pop_external_callback.
	Removed functions for getting interrupt/disable flag info
	(replaced by pointer constants in asignals.s)
--- John Gibson, Nov 13 1990
	_call_external now doesn't return the result structure on the
	stack, so the procedures calling it have to push
	Sys$-Extern$- _r*esult_struct explicitly (this is so the result isn't
	left on the stack when the return address from _call_external is
	changed for abnormal exit).
	_pop_external_callback now receives and passes on a status return
	from Callback.
--- John Gibson, Sep  5 1990
	Added exfunc closure stuff
--- John Gibson, Sep  3 1990
	Corrected (highly embarassing) bug in which the second word of
	the stack work location used to convert a decimal arg to double
	was in fact the location receiving the 7th argument word (thus
	a decimal arg passed after the 7th arg word had been written would
	corrupt the latter).
--- Roger Evans, Jul  3 1990
	added pop_interrupt_disabled
--- John Gibson, May 20 1990
	Removed _pop_mishap
--- John Gibson, May 14 1990
	_call_external now returns pointer to 3-word array, first
	2 words of which are possible single/double float result, 3rd word
	is possible result of any other kind.
--- John Gibson, Apr 28 1990
	Added callback routine.
	Moved _call_sys to asignals.s (so this file is purely 'optional'
	external stuff).
--- John Gibson, Mar 14 1990
	_call_external rewritten to use K_EXTERN_TYPE field, including
	coping with biginteger args.
--- Ian Rogers, Jan 30 1990
	Added _pop_mishap
--- Ian Rogers, Jan 26 1990
	Added _pop_interrupt_pending
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Aug 14 1989
	Made _call_external save r_false and r_svb and restore them after
	calling external routine (in case that corrupts them)
--- John Williams, Jul	4 1989
	Changed _M_K_EXTERNAL to _:M_K_EXTERNAL
--- Roger Evans, Oct 10 1988
	External data classes now dereference the E_PTR field, other
	structures pass E_DATA field (third longword).
 */
