/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 * File:	    S.sun4/src/amove.s
 * Purpose:
 * Author:          John Gibson, Aug 19 1988 (see revisions)
 */

;;; ---------------- ROUTINES TO MOVE MEMORY, ETC ------------------------

#_<

#_INCLUDE 'asm.ph'

lconstant macro (
	_SF_FP		= @@SF_FP,
	);

>_#

/********************* wrapping structures ***********************************/

ASM_TEXT_SECTION
	.word	Ltext_end-Ltext_start, C_LAB(Sys$-objmod_pad_key)
Ltext_start:
ASM_DATA_SECTION
	.word	Ldata_end-Ldata_start, C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**************************************************************************/

ASM_TEXT_SECTION


;;; --- COMPARE ROUTINES ------------------------------------------------

	;;; _bcmp(_boffs, _bptr1, _bptr2) -> bool
	;;; compare two byte regions of the same length
DEF_C_LAB (_bcmp)
	ld	[%us], %o2	;;; _bptr2
	ld	[%us+4], %o1	;;; _bptr1
	ld	[%us+8], %o0	;;; _boffs
	inc	8, %us
	deccc	1, %o0
1:	bneg	2f		;;; reached end of strings
	inc	1, %o1		;;; step ptr1
	ldub	[%o1-1], %o3	;;; byte1
	ldub	[%o2], %o4	;;; byte2
	inc	1, %o2		;;; step ptr2
	cmp	%o3, %o4	;;; compare bytes
	be,a	1b		;;; loop if same
	deccc	1, %o0		;;; decrement size
	;;; not same
	retl
	st	%r_false, [%us]
	;;; same
2:	set	C_LAB(true), %o0
	retl
	st	%o0, [%us]


	;;; _scmp(_soffs, _sptr1, _sptr2) -> bool
	;;; compare two short (half) regions of the same length
DEF_C_LAB (_scmp)
	ld	[%us], %o2	;;; _sptr2
	ld	[%us+4], %o1	;;; _sptr1
	ld	[%us+8], %o0	;;; _soffs
	inc	8, %us
	deccc	2, %o0
1:	bneg	2f		;;; reached end of area
	inc	2, %o1		;;; step ptr1
	lduh	[%o1-2], %o3	;;; half1
	lduh	[%o2], %o4	;;; half2
	inc	2, %o2		;;; step ptr2
	cmp	%o3, %o4	;;; compare halves
	be,a	1b		;;; loop if same
	deccc	2, %o0		;;; decrement size
	;;; not same
	retl
	st	%r_false, [%us]
	;;; same
2:	set	C_LAB(true), %o0
	retl
	st	%o0, [%us]


	;;; _icmp(_ioffs, _iptr1, _iptr2) -> bool
	;;; _cmp(_woffs, _wptr1, _wptr2) -> bool
	;;; compare two int/word regions of the same length
DEF_C_LAB (_icmp)
DEF_C_LAB (_cmp)
	ld	[%us], %o2	;;; _wptr2
	ld	[%us+4], %o1	;;; _wptr1
	ld	[%us+8], %o0	;;; _woffs
	inc	8, %us
	deccc	4, %o0
1:	bneg	2f		;;; reached end of area
	inc	4, %o1		;;; step ptr1
	ld	[%o1-4], %o3	;;; word1
	ld	[%o2], %o4	;;; word2
	inc	4, %o2		;;; step ptr2
	cmp	%o3, %o4	;;; compare words
	be,a	1b		;;; loop if same
	deccc	4, %o0		;;; decrement size
	;;; not same
	retl
	st	%r_false, [%us]
	;;; same
2:	set	C_LAB(true), %o0
	retl
	st	%o0, [%us]


;;; --- MOVE ROUTINES ------------------------------------------------------


	;;; _bmove(_boffs, _bptr_src, _bptr_dst) -> _next_dst
	;;; move bytes
DEF_C_LAB (_bmove)
	ld	[%us], %o2	;;; _bptr_dst
	ld	[%us+4], %o1	;;; _bptr_src
	ld	[%us+8], %o0	;;; _boffs
	inc	8, %us
	add	%o2, %o0, %o4	;;; next destination into o4

	tst	%o0		;;; nothing to move?
	ble	4f		;;; return if so
	cmp	%o1, %o2	;;; moving up or down?
	bgu,a	2f		;;; moving down
	neg	%o0		;;; negate offset moving down
	be	4f		;;; return if source=dest
	nop

	;;; moving up
1:	deccc	1, %o0
	ldub	[%o1+%o0], %o3	;;; load next source byte
	bnz	1b
	stb	%o3, [%o2+%o0]	;;; store at dest

	retl
	st	%o4, [%us]	;;; return next destination

	;;; moving down (%o0 negated)
2:	sub	%o1, %o0, %o1
	dec	1, %o1
	sub	%o2, %o0, %o2
	dec	1, %o2
3:	inccc	1, %o0
	ldub	[%o1+%o0], %o3	;;; load next source byte
	bnz	3b
	stb	%o3, [%o2+%o0]	;;; store at dest

4:	retl
	st	%o4, [%us]	;;; return next destination


	;;; _smove(_soffs, _sptr_src, _sptr_dst) -> _next_dst
	;;; move shorts (halves)
DEF_C_LAB (_smove)
	ld	[%us], %o2	;;; _sptr_dst
	ld	[%us+4], %o1	;;; _sptr_src
	ld	[%us+8], %o0	;;; _soffs
	inc	8, %us
	add	%o2, %o0, %o4	;;; next destination into o4

	tst	%o0		;;; nothing to move?
	be	4f		;;; return if so
	cmp	%o1, %o2	;;; moving up or down?
	bgu,a	2f		;;; moving down
	neg	%o0		;;; negate offset moving down
	be	4f		;;; return if source=dest
	nop

	;;; moving up
1:	deccc	2, %o0
	lduh	[%o1+%o0], %o3	;;; load next source half
	bnz	1b
	sth	%o3, [%o2+%o0]	;;; store at dest

	retl
	st	%o4, [%us]	;;; return next destination

	;;; moving down (%o0 now negated)
2:	sub	%o1, %o0, %o1
	dec	2, %o1
	sub	%o2, %o0, %o2
	dec	2, %o2
3:	inccc	2, %o0
	lduh	[%o1+%o0], %o3	;;; load next source half
	bnz	3b
	sth	%o3, [%o2+%o0]	;;; store at dest

4:	retl
	st	%o4, [%us]	;;; return next destination


	;;; _imove(_ioffs, _iptr_src, _iptr_dst) -> _next_dst
	;;; _dmove(_doffs, _dptr_src, _dptr_dst) -> _next_dst
	;;; _move(_woffs, _wptr_src, _wptr_dst) -> _next_dst
	;;; move ints/words/doubles (_moveq is the same)
DEF_C_LAB (_imove)
DEF_C_LAB (_dmove)
DEF_C_LAB (_move)
DEF_C_LAB (_moveq)
	ld	[%us], %o2	;;; _wptr_dst
	ld	[%us+4], %o1	;;; _wptr_src
	ld	[%us+8], %o0	;;; _woffs
	inc	8, %us
	add	%o2, %o0, %o4	;;; next destination into o4
	st	%o4, [%us]	;;; return it
	;;; drop thru to movwords

	;;; do word move
	;;; word offset to move in o0, source in o1, dest in o2
	;;; (assumed not to use g1, o4, o5)
.global movwords
movwords:
	cmp	%o0, 4		;;; less than 2 words to move?
	bg,a	1f		;;; br if not ...
	cmp	%o1, %o2	;;; ... testing for move up or down
	bl	0f		;;; br if 0 to move ...
	nop
	ld	[%o1], %o3	;;; load 1
	st	%o3, [%o2]	;;; store at dest
0:	retl; nop

1:	add	%o1, %o0, %g2	;;; get lim addresses
	add	%o2, %o0, %g3
	bgu,a	movdown		;;; br if moving down ...
	neg	%o0		;;; ... negating offset
	be	0b		;;; else return if source=dest

	;;; MOVING UP
	btst	4, %g2		;;; test alignment on src lim
	bnz	6f		;;; br if src lim not double aligned ...
	btst	4, %g3		;;; ... testing alignment on dst lim
	bz	7f		;;; src and dst lim double aligned
	nop

	;;; src lim aligned, dst lim not -- move 1 word first
	ld	[%g2-4], %o3
	deccc	12, %o0
	st	%o3, [%g3-4]

2:	inc	4, %o1
	b	4f
	inc	8, %o2

	;;; dst lim aligned, src not
3:	dec	4, %o0
	ld	[%o1+%o0], %g2
	deccc	4, %o0
	std	%g2, [%o2+%o0]	;;; store at dest
4:	bg	3b
	ld	[%o1+%o0], %g3

	bnz,a	5f
	st	%g3, [%o2-8]
	ld	[%o1-4], %g2
	std	%g2, [%o2-8]
5:	retl; nop

6:	bz,a	2b		;;; br if dst aligned
	deccc	8, %o0

	;;; neither src nor dst lim aligned -- move 1 word first
	ld	[%g2-4], %o3
	dec	4, %o0
	st	%o3, [%g3-4]

	;;; both double aligned
7:	deccc	8, %o0
	ldd	[%o1+%o0], %g2	;;; load next source double
	bg,a	7b
	std	%g2, [%o2+%o0]	;;; store at dst

	bz,a	8f
	std	%g2, [%o2]
	st	%g3, [%o2]
8:	retl; nop


	;;; MOVING DOWN (%o0 now negated)
movdown:
	btst	4, %o1
	bnz	5f		;;; br if src not double aligned ...
	btst	4, %o2		;;; ... testing alignment on dst
	bz	6f		;;; src and dst double aligned
	nop

	;;; src aligned, dst not -- move 1 word first
	ld	[%o1], %o3
	inccc	12, %o0
	st	%o3, [%o2]

	;;; dst aligned, src not
1:	dec	8, %g2
	b	3f
	dec	16, %g3

2:	inc	4, %o0
	ld	[%g2+%o0], %o3
	inccc	4, %o0
	std	%o2, [%g3+%o0]	;;; store at dest
3:	bl	2b
	ld	[%g2+%o0], %o2

	bnz,a	4f
	st	%o2, [%g3+12]
	ld	[%g2+4], %o3
	std	%o2, [%g3+8]
4:	retl; nop


5:	bz,a	1b		;;; br if dst aligned
	inccc	8, %o0

	;;; neither src nor dst aligned -- move 1 word first
	ld	[%o1], %o3
	inc	4, %o0
	st	%o3, [%o2]

	;;; both double aligned
6:	dec	8, %g3

7:	ldd	[%g2+%o0], %o2	;;; load next source double
	inccc	8, %o0
	bl,a	7b
	std	%o2, [%g3+%o0]	;;; store at dst

	bz,a	8f
	std	%o2, [%g3]
	st	%o2, [%g3+4]
8:	retl; nop



;;; --- FILL ROUTINES ----------------------------------------------------

	;;; _bfill(_byte, _boffs, _bptr)
	;;; fill a region of words with a given byte
DEF_C_LAB (_bfill)
	ld	[%us], %o2	;;; _bptr
	ld	[%us+4], %o1	;;; _boffs
	ld	[%us+8], %o0	;;; _byte
	tst	%o1
	ble	2f
	inc	12, %us

1:	deccc	1, %o1
	bnz	1b
	stb	%o0, [%o2+%o1]	;;; store _byte at dest

2:	retl; nop

	;;; _ifill(_int, _ioffs, _iptr)
	;;; _fill(_word, _woffs, _wptr)
	;;; fill a region of ints/words with a given word
DEF_C_LAB (_ifill)
DEF_C_LAB (_fill)
	ld	[%us], %o2	;;; _wptr
	ld	[%us+4], %o1	;;; _woffs
	ld	[%us+8], %o0	;;; _word
	tst	%o1
	ble	2f
	inc	12, %us

1:	deccc	4, %o1
	bnz	1b
	st	%o0, [%o2+%o1]	;;; store _word at dest

2:	retl; nop


;;; ------------------------------------------------------------------------

	;;; _move_callstack(_woffs, _limaddr)
	;;; move the callstack from sp upto _limaddr by an amount _woffs
DEF_C_LAB (_move_callstack)
	ld	[%us+4], %o0		;;; _woffs (amount to shift UP)
	tst	%o0			;;; negative (shifting down) ?
	bpos,a	1f			;;; no hole to make if not
	clr	%o0			;;; so zero this
1:	dec	64, %o0			;;; allow for base frame size
	save	%sp, %o0, %sp		;;; create base frame with hole

	;;; ensure the stack frame just created is out in memory
#_< 	repeat SPARC_MAX_WINDOWS times '\tsave\t%sp,-64,%sp\n' endrepeat >_#

	add	%sp, _:SPARC_MAX_WINDOWS*64, %l0 ;;; get sp of base frame
	ld	[%l0+_SF_FP], %o1	;;; save caller's sp (source for move)
	ld	[%us], %l1		;;; _limaddr of frames to move
	ld	[%us+4], %l2		;;; _woffs again
	inc	8, %us

	;;; adjust fp in base frame and all frames being moved
2:	ld	[%l0+_SF_FP], %l3	;;; next fp
	add	%l3, %l2, %l4		;;; add _woffs to get new fp value
	st	%l4, [%l0+_SF_FP]	;;; replace in stack frame
	cmp	%l3, %l1		;;; compare with _limaddr
	blu,a	2b			;;; finished if >= _limaddr
	mov	%l3, %l0		;;; else loop with old fp as next sp

	;;; do the move
3:	sub	%l1, %o1, %o0		;;; _limaddr - caller's sp is size
	call	movwords		;;; do the move
	add	%o1, %l2, %o2		;;; caller's sp + _woffs is destination

	;;; then return
#_<	repeat SPARC_MAX_WINDOWS times '\trestore\n' endrepeat >_#
	ret
	restore				;;; restore out of base frame


	;;; _shift(_int, _n) -> _shifted_int
	;;; _n positive for left shift, negative for right shift
DEF_C_LAB (_shift)
	ld	[%us], %o1	;;; _n
	ld	[%us+4], %o0	;;; _int
	inc	4, %us
	tst	%o1
	bpos,a	1f		;;; br if shift left
	sll	%o0, %o1, %o0	;;; doing the shift
	neg	%o1		;;; else negate shift count
	sra	%o0, %o1, %o0	;;; and do shift right (arithmetic)
1:	retl
	st	%o0, [%us]


;;; --- BITFIELD ROUTINES ------------------------------------------------


	;;; access an unsigned bit field
	;;; o0 = struct address, o1 = bitoffset, o2 = field width W,
	;;; returns field value in o0
DEF_C_LAB (_bfield)
	mov	32, %o3
	sub	%o3, %o2, %o2		;;; 32-W = field shift-down
	and	%o1, 31, %o3		;;; get bitoffs within start word
	sra	%o1, 3, %o1		;;; get offset
	bclr	3, %o1			;;; to start word
	add	%o0, %o1, %o0		;;; add to struct addr in o0
	ld	[%o0], %o1		;;; load first word into o1
	cmp	%o2, %o3		;;; all bits in 1st word?
	bge	1f			;;; br if all in first word
	sll	%o1, %o3, %o1		;;; shift 1st word bits to top
	ld	[%o0+4], %o4		;;; else next word of field in o4
	neg	%o3
	add	%o3, 32, %o3		;;; 32-bitoffs (no of bits in 1st word)
	srl	%o4, %o3, %o4		;;; 2nd word down by that
	or	%o1, %o4, %o1		;;; or in the rest of the field
1:	retl
	srl	%o1, %o2, %o0		;;; bring down to bottom (32-W)


	;;; access a signed bit field
	;;; o0 = struct address, o1 = bitoffset, o2 = field width W,
	;;; returns field value in o0
DEF_C_LAB (_sbfield)
	mov	32, %o3
	sub	%o3, %o2, %o2		;;; 32-W = field shift-down
	and	%o1, 31, %o3		;;; get bitoffs within start word
	sra	%o1, 3, %o1		;;; get offset
	bclr	3, %o1			;;; to start word
	add	%o0, %o1, %o0		;;; add to struct addr in o0
	ld	[%o0], %o1		;;; load first word into o1
	cmp	%o2, %o3		;;; all bits in 1st word?
	bge	1f			;;; br if all in first word
	sll	%o1, %o3, %o1		;;; shift 1st word bits to top
	ld	[%o0+4], %o4		;;; else next word of field in o4
	neg	%o3
	add	%o3, 32, %o3		;;; 32-bitoffs (no of bits in 1st word)
	srl	%o4, %o3, %o4		;;; 2nd word down by that
	or	%o1, %o4, %o1		;;; or in the rest of the field
1:	retl
	sra	%o1, %o2, %o0		;;; sign-ext down to bottom (32-W)


	;;; update a bit field
	;;; o0 = struct address, o1 = bitoffset, o2 = field width W,
	;;; field updated from value off stack
DEF_C_LAB (_ubfield)
	mov	%o7, %g1		;;; save return
	mov	32, %o3
	sub	%o3, %o2, %o2		;;; 32-W = field shift-down
	and	%o1, 31, %o3		;;; get bitoffs within start word
	sra	%o1, 3, %o1		;;; get offset
	bclr	3, %o1			;;; to start word
	add	%o0, %o1, %o0		;;; add to struct addr in o0
	ld	[%o0], %o1		;;; load first word into o1
	ld	[%us], %o5		;;; new field value
	inc	4, %us
	mov	-1, %o7
	sll	%o7, %o2, %o7		;;; left by 32-W = W bits at top
	srl	%o7, %o3, %o7		;;; right by bitoffs = field mask
	subcc	%o2, %o3, %o4		;;; 32-W-bitoffs (bits below field)
	bpos,a	1f			;;; br if all in first word
	sll	%o5, %o4, %o5		;;; shifting up new value

	;;; field occupies second word
	add	%o4, 32, %o2		;;; 32 - number of overshoot bits
	sll	%o5, %o2, %o2		;;; get new value bits at top
	ld	[%o0+4], %o3		;;; get overshoot word
	neg	%o4			;;; number of overshoot bits
	sll	%o3, %o4, %o3		;;; clear those
	srl	%o3, %o4, %o3		;;; at top of old value
	bset	%o2, %o3		;;; or in new top bits
	st	%o3, [%o0+4]		;;; update in second word
	srl	%o5, %o4, %o5		;;; remove overshoot from new value

1:	bclr	%o7, %o1		;;; remove old field
	and	%o5, %o7, %o5		;;; mask new field
	bset	%o5, %o1		;;; insert new field
	jmp	%g1+8			;;; return
	st	%o1, [%o0]		;;; store new first word


	;;; multiply vector subscript by element size to get offset
	;;; o0 = popint subscript, o1 = fieldsize
	;;; result in o1
DEF_C_LAB (_vecsub_mult)
	cmp	%o1, 1			;;; fieldsize is 1?
	be	1f			;;; no multiply needed if so
	srl	%o0, 2, %o0		;;; subscript to sysint
	mov	%o7, %g1		;;; save return address
	call	pop.Mul			;;; call mult routine -- result in o0
	dec	1, %o0			;;; correct subscript base
	jmp	%g1+8			;;; return
	mov	%o0, %o1		;;; with result in o1

1:	retl
	sub	%o0, 1, %o1		;;; correct subscript base



/*************** end labels for wrapping structures **************************/

ASM_TEXT_SECTION
	.align	8
Ltext_end:
ASM_DATA_SECTION
	.align	8
Ldata_end:

/**************************************************************************/


/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  1 1997
	Now includes asm.ph
--- John Gibson, Apr  6 1995
	Added _icmp, _imove, _dmove, _ifill as equivalent to word versions
--- John Gibson, Mar 24 1995
	Changed to use our own pop.Mul instead of C .mul (guaranteed not
	to change any g regs)
--- John Gibson, Sep 16 1994
	Rewrote movwords to move in doubles when possible
--- Robert John Duncan, Jun  1 1993
	Changed to use ASM_SECTION macros for changing section
--- Simon Nichols, Mar  3 1992
	Changed not to assume that %g1 is unused by calls to .mul: this is
	not true if, e.g., the image is linked dynamically. The return
	address is saved on the user stack instead.
--- John Gibson, Feb 18 1991
	SPARC_N*WINDOWS replaced with SPARC_MAX_WINDOWS to ensure independence
	from hardware implementation.
--- Robert Smith, Mar 13 1990
	Changed shift used in word offset calculation in _{ub,sb,b}field
	from logical to arithmetic. Former damaged -ve subscripts which
	occur if field in first longword.
--- John Gibson, Dec 12 1989
	_vecsub_mult no longer adds vector base offset
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
 */
